#ifndef ZAT2_COM_H
#define ZAT2_COM_H

/**************************************************************************
*
*                       At Command Encode And Decode
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 :   ͨѶɷ޹˾ ֻҵ Ͼо ƽ̨ܹ
*   ģ   :   ATģ
*      :   zat2_com.h
*   ļʶ :   
*   ļ :   
*   ʵֹ :   ATģͨúغ궨
*        :   
*        :    
*    :   2007/11/13
*   ˵ :   
*
*   ޸ļ¼ :   
*                汾     ޸ı     ޸          ޸      
*   ---------------------------------------------------------------------
*   2007/11/13                               xuwen            
*
***************************************************************************
*
*   ļ
*   ----------------
*   ATģͨúغ궨
*
*
**************************************************************************/

/**************************************************************************
*    Include Files                  ļ
**************************************************************************/

#ifndef _OS_LINUX
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#endif

#include "atipsint.h"
#include "ps/src/nas/ati/inc/zat_api.h"
/**************************************************************************
*    Macros                         궨
**************************************************************************/
#define Z_ATI_GLOPLMN_NUM     1239
/* Convert the letter from lowercase to uppercase  */
#define ZAT2_SEMICOLON_CHAR       (';')
#define ZAT2_COMMA_CHAR           (',')
#define ZAT2_DOT_CHAR             ('.')
#define ZAT2_QUOTES_CHAR          ('"')
#define ZAT2_LEFTBRCKT_CHAR       ('(')
#define ZAT2_RIGHTBRCKT_CHAR      (')')
#define ZAT2_QUERY_CHAR           ('?')
#define ZAT2_EQUALS_CHAR          ('=')
#define ZAT2_COLON_CHAR           (':')
#define ZAT2_STAR_CHAR            ('*')
#define ZAT2_HASH_CHAR            ('#')
#define ZAT2_SPACE_CHAR           (' ')
#define ZAT2_AMPERSAND_CHAR       ('&')
#define ZAT2_BACK_SLASH_CHAR      (92)
#define ZAT2_PLUS_CHAR            ('+')
#define ZAT2_NULL_CHAR            (0)
#define ZAT2_CR_CHAR              ('\r')
//#define ZAT2_CR_CHAR              ('@')
#define ZAT2_LF_CHAR              ('\n')
#define ZAT2_ESC_CHAR             (27)
#define ZAT2_CTRL_Z_CHAR          (26)
#define ZAT2_BACKSPACE_CHAR       (8)

#define ZAT2_MAX_CMDHD_LEN  20//Ⱥϳ15  Ϊ20                       /* ͷ󳤶 */
#define ZAT2_MAX_CMDOP_LEN  3                        /* 󳤶 */
#define ZAT2_MAX_PARAM_LEN  600                      /* 󳤶 */
#define ZAT2_MAX_CMD_LEN   (ZAT2_MAX_CMDHD_LEN + \
                            ZAT2_MAX_CMDOP_LEN + \
                            ZAT2_MAX_PARAM_LEN)      /* 󳤶 */
#define ZAT2_MAX_FRC_LEN   20                        /* FRC(ս)󳤶 */
//#define ZAT2_SUB_PARAM_MAX_LEN 512                    /* Ӳ󳤶 */

#define ZAT2_BYTE_BUF_LEN  3                         /* 4ַĻ泤 */

#define ZAT2_SHORT_CMD_LEN 256
#define ZAT2_MID_CMD_LEN 512
#define ZAT_LONG_CMD_LEN 1024
#define  ZAT2_UPCASE( c ) ( ((c) >= 'a' && (c) <= 'z') ? ((c) - 0x20) : (c) )

/* Used in zAt_Str2Value() */
#define ZAT2_IS_DECIMAL_PARAM TRUE
#define ZAT2_IS_HEX_PARAM FALSE

/* Used for zAt2_GetCmdStr() */
#define ZAT2_IS_REQUEST        TRUE
#define ZAT2_IS_NOT_REQUEST    FALSE

#define ZAT2_DEC_STR_MAX_LEN_16B 10
#define ZAT2_HEX_STR_MAX_LEN_16B 8

#define ZAT2_DECIMAL_CARRY 10
#define ZAT2_HEX_CARRY 16

#define GUC  0x10       /* GSM δַ */

/* Ϣʾģʽ */
#define ZAT2_CMGF_PDU                       (UINT8)0    /* PDU mode */
#define ZAT2_CMGF_TEXT                      (UINT8)1    /* TEXT mode */

/*********ûѡ*****/
#define Z_ATI_CARD_1                                 (BYTE)1
#define Z_ATI_CARD_2                                 (BYTE)2

/* Used for zAt2_GetRangeStr() */
#define ZAT2_IS_RANGE_STR 0
#define ZAT2_NO_RANGE_STR 1
#define ZAT2_OVERFLOW_RANGE_STR 2

/* Used for zAt2_ParseSmsMemTyp() */
#define ZAT2_MEM_IS_BM (UINT8)0
#define ZAT2_MEM_IS_ME (UINT8)1
#define ZAT2_MEM_IS_MT (UINT8)2
#define ZAT2_MEM_IS_SM (UINT8)3
#define ZAT2_MEM_IS_TA (UINT8)4
#define ZAT2_MEM_IS_SR (UINT8)5
#define ZAT2_MEM_STR_ERR (UINT8)0xff

#define ZAT2_CMEE_CMDCONFLICT               (DWORD)6000 /* ͨ·ͻ */
#define ZAT2_CMEE_CMDOVERFLOW               (DWORD)6001 /* 볬 */
#define ZAT2_CMEE_SMSCONTENT_ERR            (DWORD)6002 /* Ϣ */
#define ZAT2_CMEE_CMDUNREC                  (DWORD)6003 /* ʶ */
#define ZAT2_CMEE_SYNTAX_ERR                (DWORD)6004 /* ﷨ */
#define ZAT2_CMEE_IPV4_ONLY                 (DWORD)6005 /* ֧IPV4 */
#define ZAT2_CMEE_IPV6_ONLY                 (DWORD)6006 /* ֧IPV6 */
#define ZAT2_CMEE_APN_AUTH_FAIL           (DWORD)6007/*APNȨʧ*/
#define ZAT2_CMEE_UNKNOW_PDP_TYPE         (DWORD)6008/*#28ԭ*/

/***************************TMGI ʧܴ*********************/
#define ZAT2_TMGI_UNICAST_UNSTABLE             (DWORD)6101/*unicast state unstable*/
#define ZAT2_TMGI_NOT_SUPP               (DWORD)6102/*EMBMS not support*/
#define ZAT2_TMGI_OUTOF_COVERAGE            (DWORD)6103/*TMGI out of coverage*/
#define ZAT2_TMGI_UNICAST_OOS             (DWORD)6104/*unicast out of service*/
#define ZAT2_TMGI_MAX_ACT_SERVICE            (DWORD)6105/*exceed max number*/

#define ZAT2_CMEE_NOAVAIBAND_ERR        Z_MmiaUmm_NoAvailableBand_Err/*6009޿Ƶ*/
#define ZAT2_CMEE_GETNOINFO_ERR           (DWORD)6010/*ȡϢʧ*/
#define ZAT2_CMEE_PCOAUTHCHKFAIL_ERR      (DWORD)6011/*ȨУʧ*/
#define ZAT2_CMEE_PCOAUTHCHK_EXCEEDMAX_ERR (DWORD)6012/*ȨУʧܳ*/
#define ZAT2_CMEE_DUALCARDADPT_ERR         (DWORD)6013/*нֹ*/
#define ZAT2_CMEE_DUALCARDCID_ERR          (DWORD)6014/*˫˫CIDʹô*/

#ifdef R9_SUPPORT
#define ZAT2_CMEE_VALUE_ERR                 (DWORD)50 /* ȡֵ */
#else
#define ZAT2_CMEE_VALUE_ERR                 (DWORD)5000 /* ȡֵ */
#endif

/* 617001591411 ܻ- ܻV3汾ͬʵ*/
#define ZAT2_NV_PARAM_MANUFACTURER_EGPRS_SUPPORT                              (BYTE)1
#define ZAT2_NV_PARAM_MANUFACTURER_8PSKMODCAPA                                (BYTE)1
#define ZAT2_NV_PARAM_MANUFACTURER_MODBMULTICLASSSUPP                         (BYTE)1
#define ZAT2_NV_PARAM_MANUFACTURER_EGPRSMULTISLOTCAPA                         (BYTE)12
#define ZAT2_NV_PARAM_MANUFACTURER_8PSKMULTISLOTPWRCAPA                       (BYTE)0
#define ZAT2_NV_PARAM_MANUFACTURER_EGPRSEXTDYNALLOC                           (BYTE)1
#define ZAT2_NV_PARAM_MANUFACTURER_8PSK                                       (BYTE)1
#define ZAT2_NV_PARAM_MANUFACTURER_8PSKPWRCAPA1                               (BYTE)2
#define ZAT2_NV_PARAM_MANUFACTURER_8PSKPWRCAPA2                               (BYTE)2
#define ZAT2_NV_PARAM_MANUFACTURER_MUSCCAPREDUCTIONFORDLDUALCARRIERSUPPORT    (BYTE)0
#define ZAT2_NV_PARAM_MANUFACTURER_MULTISLOTCAPREDUCTIONFORDLDUALCARRIER      (BYTE)0

/**************************************************************************
*    Types                          Ͷ
**************************************************************************/

typedef struct  /* ԭṹ */
{
    UINT32  iErrId;            /* ԭID */
    const char * strErr;       /* ԭַ */
} 
T_ZAt2_CmdOpErrInfo;

typedef struct/*ȫӪб*/
{
    BYTE  abNum[3];    /*ӪPLMNID*/
    const char * Longstr;   /*Ӫ̳*/
    const char * Shortstr;   /*Ӫ̶*/
}T_ZAt2_GlobalOperInfo;

typedef enum  /* ɲж+CREG/+CGREGCNFIND */
{
    ZAT2_ADD_PARSE_TYP_INVALID = -1,

    ZAT2_ADD_PARSE_IS_IND,     /* Ϊ֪ͨ */
    ZAT2_ADD_PARSE_IS_CNF,     /* ΪӦ */
    ZAT2_ADD_PARSE_PARAM_ERR   /* 쳣 */
}
T_ZAt2_AddParseType;


typedef enum /* ǰ׺ö */
{
    ZAT2_IS_HELLO_CMD,     /* ΪʺõĿ"AT" */ 
    ZAT2_RPT_PREV_REQ,     /* ظһ"A/" */
    ZAT2_IS_REQ_CMD,       /* Ϊ"AT+XXX" */
    ZAT2_PREFIX_ERR        /* ǰ׺*/
} 
T_ZAt2_CmdPrefixType;

typedef enum  /* Ӧͷö */
{
    ZAT2_RSLT_EER,          /* 쳣 */

    ZAT2_RSLT_IS_OK,        /* ɹ */
    ZAT2_RSLT_IS_ERR,       /* ʧ */
    ZAT2_RSLT_IS_CME,       /* CME/CMS */
    ZAT2_RSLT_OTHER         /*  */
} 
T_ZAt2_SimpleRsltType;

typedef enum /* +CSCSַʽ */
{
    ZAT2_CSCS_GSM,          /* 7-bitַ00-7FֱASCIIַʽ */
    ZAT2_CSCS_HEX,          /* 8-bitַ00-FF16ʽ */
    ZAT2_CSCS_IRA,           /*International Reference Alphabet  ʲοַ*/
    ZAT2_CSCS_UCS2,         /* 16-bitUNICODEַ0000-FFFF16ʽ */
    ZAT2_CSCS_NUM           /*  */
}
T_ZAt2_CscsType;

typedef enum /* ԭ򱨸淽ʽ */
{
    ZAT2_CMEE_INVALID = -1,      /* invalid value */

    ZAT2_CMEE_DISABLE = 0,      /* disable +CME ERROR */
    ZAT2_CMEE_NUMERIC = 1,      /* enable +CME ERROR, using numeric */
    ZAT2_CMEE_VERBOSE      /* enable +CME ERROR, using verbose */
}
T_ZAt2_CmeeType;


typedef enum /* ûͷָʾ,by +CSMP */
{
    ZAT2_SMS_TPDU_WITHOUT_HEAD,
    ZAT2_SMS_TPDU_WITH_HEAD
}
T_ZAt2_SmsTpudHeadIndType;


typedef enum  /* ȡ */
{
    ZAT2_PARAM_INTEGER,    /* ַ */
    ZAT2_PARAM_STRING,     /* ַ */
    ZAT2_PARAM_HEX_FORMAT, /* hexadecimal character format , 617001591411 ܻ- ܻV3汾ͬʵ*/
    ZAT2_PARAM_BRACKET     /* Ų(TESTظг) */
}
T_ZAt2_ParamType;


typedef struct    /* ͷϢṹ */
{
    const char * strHd;          /* ͷַ */
    T_ZAt2_CmdIdType  cmdId;          /* ʶ */
    const char * strTestInfo;        /* Ϣ */
} 
T_ZAt_CmdHd2Id;

typedef enum /* ҵ */
{
    ZAT2_SVR_TYPE_INVALID = -1,
        
    ZAT2_SVR_TYPE_CFG,
    ZAT2_SVR_TYPE_MM,
    ZAT2_SVR_TYPE_CC,
    ZAT2_SVR_TYPE_SMS,
    ZAT2_SVR_TYPE_UICC,
    ZAT2_SVR_TYPE_SM,
    ZAT2_SVR_TYPE_SS,
    ZAT2_SVR_TYPE_PB,
    
    ZAT2_SVR_TYPE_COUNT    
}
T_ZAt2_CmdSvrType;

extern const T_ZAt_CmdHd2Id g_zAt_CmdHd2IdTable[];


/**************************************************************************
*    Function prototypes            ԭ
**************************************************************************/

/**************************************************************************
* ƣ zAt_EncodeMMIClassToAT
*  7bitչַıת
* ˵ (IN):  
*            iSrcԴַ
*            (OUT): 
*   ֵ Ŀַ
* ˵ 
**************************************************************************/
UINT8 zAt_EncodeMMIClassToAT(UINT8 iSrc);

/************************************************************************
*:zAti_UpCaseRecvCmd
*:յATת Ϊд
***********************************************************************/
VOID zAti_UpCaseRecvCmd(CHAR* pStrData, UINT16 iDataLen);

/**************************************************************************
* ƣ zAt2_GetGnrlErrInfo
*  ݲg_zAt2_CmdOpGnrlErrTabвͨ
*            Ӧַ
* ˵ (IN):
*             iErrId:     
*            (OUT):
*             strGnrlErr: Ĵַ
*   ֵ TRUE ҵ, FALSE δҵ
* ˵ 
**************************************************************************/
VOID zAt2_GetGnrlErrInfo(UINT32 iErrId, CHAR * strGnrlErr);
#ifdef USE_VOICE_SUPPORT
BOOL zAt2_GetCeerCcInfo(UINT32 iErrId, CHAR * strGnrlErr);
#endif
BOOL zAt2_GetCeerSmInfo(UINT32 iErrId, CHAR * strGnrlErr);

BOOL zAt2_GetCeerUmmInfo(UINT32 iErrId, CHAR * strGnrlErr);

BOOL zAt2_GetCeerMmInfo(UINT32 iErrId, CHAR * strGnrlErr);

BOOL zAt2_GetCeerEsmInfo(UINT32 iErrId, CHAR * strGnrlErr);
/**************************************************************************
* ƣ zAt2_GetSmsErrInfo
*  ݲg_zAt2_CmdOpSmsErrTabвҶϢ
*            Ӧַ
* ˵ (IN):
*             iErrId:     
*            (OUT):
*             strSmsErr:  Ĵַ
*   ֵ TRUE ҵ, FALSE δҵ
* ˵ 
**************************************************************************/
VOID zAt2_GetSmsErrInfo(UINT32 iErrId, CHAR * strSmsErr);

/**************************************************************************
* ƣ zAt2_IsPduIndication
*  жַǰλǷΪָʾPDUַ
* ˵ (IN):
*             strCmd:           Ҫַָĵַ
*             cmd_id:           ҪID
*             cmd_op:           ҪOP
*            (OUT)
*   ֵ TRUE   FALSE 
* ˵ 
**************************************************************************/
BOOL zAt2_IsPduIndication( CHAR * strCmd, T_ZAt2_CmdIdType cmd_id, T_ZAt2_CmdOpType cmd_op );
    


/**************************************************************************
* ƣ zAt2_ExtractCmdStr
*  һеͷֶΡֶΡֶ
* ˵ (IN):
*             sCmd:        Ҫָ
*             cmdLen:      ҪַȣڷֹԽ
*             isReq:       Ƿ
*            (OUT)
*             sHead:       ŷͷֶελָ
*             sOp:         ŷĲֶελָ
*             sParam:      ŷĲֶελָ
*   ֵ TRUEɹ   FALSEʧ
* ˵ Ϊ"=","?","=?"ʱ޲ֶ
**************************************************************************/
BOOL zAt2_ExtractCmdStr( CHAR * sHead, CHAR * sOp, CHAR * sParam, CHAR * sCmd, UINT16 cmdLen, BOOL isReq );

/**************************************************************************
* ƣ zAt2_IsRsltCode
*  жͷǷͨý
* ˵ (IN):
*             strHead:       Ҫжϵͷֶַָ
*            (OUT)
*   ֵ TRUEͷΪͨý   FALSEͷͨý
* ˵ 
**************************************************************************/
//--BOOL zAt2_IsRsltCode( CHAR * strHead );

/**************************************************************************
* ƣ zAt2_CmdHdStr2CmdId
*  ͷַӦʶID
* ˵ (IN)
*             strHead:    Ҫжϵͷֶַָ
*             iSrvType:   ǰҵ(ڽͬʱҵͬʽ)
*            (OUT)
*   ֵ T_ZAt2_CmdIdType ʶID
* ˵ 
**************************************************************************/
T_ZAt2_CmdIdType  zAt2_CmdHdStr2CmdId( CHAR * strHead, UINT32 iSrvType);

/**************************************************************************
* ƣ zAt2_FindTestInfo
*  ͷַg_zAt2_CmdHd2IdTableе±
* ˵ (IN)
*             T_ZAt2_CmdIdType:  ID
*            (OUT)
*   ֵ g_zAt2_CmdHd2IdTable±
* ˵ 
**************************************************************************/
UINT16 zAt2_FindTestInfo(T_ZAt2_CmdIdType cmdId);

/**************************************************************************
* ƣ zAt2_GetRangeStr
*  жϲֶǷǷΧֶ("-") ֶȡΧβ֡
* ˵ (IN):
*             rangeFirst: ڴȡķΧʼֶεָ
*             rangeEnd:   ڴȡķΧiֶεָ           
*             pStrbuff:   ַָĵַȡַַһβͷλ
*            (OUT)
*   ֵ 0: ǷΧֶΣ1: ǷΧֶ;2 ַԽ硣-1ηǷ
* ˵ 
**************************************************************************/
SINT16 zAt2_GetRangeStr(CHAR * rangeFirst, CHAR * rangeEnd, CHAR **pStrbuff);

/**************************************************************************
* ƣ zAt_GetNextParamStr
*  ֶȡһ','֮ǰӲΣָһβͷλ
*            Ϊһżȡָһβͷλ
* ˵ (IO):
*             pStrParam:   ַָĵַȡַַһβͷλ
*             paramType:   ҪȡĲ
*            (OUT):
*             pStrSub:      ڴȡӲֶεָ
*   ֵ ȡӲεĳȣβ'\0',-1:ʾȡʧ
* ˵ 
**************************************************************************/
SINT16 zAt_GetNextParamStr(CHAR * pStrSub, T_ZAt2_ParamType paramType, CHAR **pStrParam);
/*************************************************************************
*ƣzAt_GetExchgStr
* ַеСдĸתɴд
*˵pStrSub ַ׵ַ
*                                 lenַ
*  ֵ
**************************************************************************/
VOID zAt_GetExchgStr(CHAR * pStrSub,BYTE len);
BOOL zAti_MemcmpStr(BYTE *pStr1, BYTE *pStr2, BYTE bCmpLen);
BOOL zAt_IsDigit(CHAR * pDigit);
/**************************************************************************
* ƣ zAt_GetNextParamStrOfGsm7
*  ֶȡһ','֮ǰӲΣָһβͷλ
*            Ϊһżȡָһβͷλ
* ˵ (I):
*             ppStrParam:  ַָĵַȡַַһβͷλ
*             paramType:   ҪȡĲ
*            (OUT):
*             pStrSub:      ڴȡӲֶεָ
*   ֵ ȡӲεĳȣβ'\0',-1:ʾȡʧ
* ˵ 
**************************************************************************/
SINT16 zAt_GetNextParamStrOfGsm7(CHAR * pStrSub, T_ZAt2_ParamType paramType, CHAR **ppStrParam);


/**************************************************************************
* ƣ zAt_Str2Value
*  ֵַʮƻʮʽתΪӦֵ
* ˵ (IN):
*             sStr: Ҫתֵַ
*             DorH: TRUEʮ  FALSEʮ
*            (OUT)
*             iValue: תֵ
*   ֵ ת TRUE ɹFALSE ʧ
* ˵ 
**************************************************************************/
BOOL zAt_Str2Value( CHAR *sStr , BOOL DorH, UINT32 * iValue );

/**************************************************************************
* ƣ zAt_DecDotSeparateStr
*  dot-separatedַ
* ˵ (I):
*            pDotStr:       ַָ
*            iMaxSectNum:   ֵ
*            iMaxVal:       ֵֵ
*            (O):
*            pDotVal:      ŷֵַ
*            pSectNum:     ֵ
*   ֵ BOOL:  ɹʧ
* ˵
**************************************************************************/
BOOL zAt_DecDotSeparateStr(CHAR * pDotStr, 
                            VOID * pDotVal, 
                            UINT8 * pSectNum, 
                            UINT8 iMaxSectNum, 
                            UINT32 iMaxVal);

/**************************************************************************
* ƣ zAt2_ParseSmsMemTyp
*  ַжϱʾĶŴ洢ͣӦĲֵ
* ˵ (IN):
*             sMem: ҪȽϵַ׵ַ
*            (OUT)
*   ֵ 
*            ZAT2_MEM_IS_BM:  ַΪ"BM"
*            ZAT2_MEM_IS_ME:  ַΪ"ME"
*            ZAT2_MEM_IS_MT:  ַΪ"MT"
*            ZAT2_MEM_IS_SM:  ַΪ"SM"
*            ZAT2_MEM_IS_TA:  ַΪ"TA"
*            ZAT2_MEM_STR_ERR:  ǱʾŴ洢ַ
* ˵ 
**************************************************************************/
UINT8 zAt2_ParseSmsMemTyp(CHAR * sMem);

/**************************************************************************
* ƣ zAt_DecideNumTypeValid
*  ַжϱʾĶŴ洢ͣӦĲֵ
* ˵ (IN):
*             iType:   ĺ
*   ֵ תTRUEΪɹ FALSEΪʧ
* ˵ 
**************************************************************************/
BOOL zAt_DecideNumTypeValid(UINT8 iType);

/**************************************************************************
* ƣ zAt_EncDate2StrByVpFormat
*  ַжϱʾĶŴ洢ͣӦĲֵ
* ˵ (IN):
*             pTpValidPeriod:   ЧڣͺͳȡiSmsVpFormat
*             iSmsVpFormat:     ԴACSIIַĳ
*            (OUT)
*             pStrTarget:       Ŀַĵַ
*   ֵ תTRUEΪɹ FALSEΪʧ
* ˵ 
**************************************************************************/
BOOL zAt_EncDate2StrByVpFormat( CHAR * pStrTarget, T_zApMmia_SmsVP tpValidPeriod, UINT8 iSmsVpFormat);

/**************************************************************************
* ƣ zAt_EncArr2StrByCscsType
*  ɵǰʽԴACSIIַתĿַ
* ˵ (IN):
*             pStrTarget:  Ŀַĵַ
*             pSource:     ԴACSIIַĵַ
*             iSourceLen:  ԴACSIIַĳ
*             curCscsTye:  ǰʽ
*            (OUT)
*   ֵ תT_ZAt_CscsType
* ˵ 
**************************************************************************/
BOOL zAt_EncArr2StrByCscsType(CHAR * pStrTarget, UINT8 * pSource, UINT32 iSourceLen, T_ZAt2_CscsType curCscsType);
BOOL zAt_EncPbStrByCscsType ( CHAR * pStrTarget, UINT8 * pSource, UINT16 iSourceLen, T_ZAt2_CscsType curCscsType );
BOOL zAt_ConvertPbstrToGsm(CHAR * pStrTarget, UINT8 * pSource, UINT16 iSourceLen);
VOID zAt_EncScpbrTxtStr(CHAR * pStrTarget, UINT8 * pSource, UINT16 iSourceLen, UINT8 *pCode);
BOOL zAt_ConvertPbstrToUcs(CHAR * pStrTarget, UINT8 * pSource, UINT16 iSourceLen);
BOOL zAt_ConvertPbstrToGsm(CHAR * pStrTarget, UINT8 * pSource, UINT16 iSourceLen);
BOOL zAt_ConvertGsmToAscii(CHAR * pStrTarget, UINT8 * pSource, UINT16 iSourceLen);
/**************************************************************************
* ƣ zAt_EncAlphaStrLenByCscsType
*  ȡǰַĳ
* ˵ (IN):
*             pSource:     ԴACSIIַĵַ
*   ֵ iSourceLenʵʵĳ
* ˵ 
**************************************************************************/
UINT16 zAt_EncAlphaStrLenByCscsType (UINT8 * pSource);
/**************************************************************************
* ƣ zAt_GetSpnStrlen
*  ȡSPN ַĳ
* ˵ (IN):
*             pSource:     ԴACSIIַĵַ
*   ֵ iSourceLenʵʵĳ
* ˵ SPN ַΪ16ֽ
**************************************************************************/
UINT16 zAt_GetSpnStrlen (UINT8 * pSource);
#ifdef USE_VOICE_SUPPORT
BYTE zAti_GetCurrencyCodeLen(UINT8 * pSource);
#endif
/**************************************************************************
* ƣ zAt_EncBcd2NumStrByCscsType
*  ɵǰʽԴBCDֽڱַתĿַ
* ˵ (IN):
*             pStrTarget:  Ŀַĵַ
*             pSource:     ԴACSIIַĵַ
*             iSrcByteLen: ԴBCDַĳ
*             curCscsTye:  ǰʽ
*            (OUT)
*   ֵ תT_ZAt_CscsType
* ˵ 
**************************************************************************/
BOOL zAt_EncBcd2NumStrByCscsType(CHAR * pStrTarget, UINT8 * pSource, UINT8 iSrcByteLen, T_ZAt2_CscsType curCscsType);
/**************************************************************************
* ƣ zAt_EncSmsTextData
*  ĸSMSıݱĿַ
* ˵ (IN):
*             pDataSrc:    ŶϢıݵĵַ
*             iSrcByteLen: ԴBCDַĳ
*             iCharNum     ַַ
*             dcs:         TPDUݴ뷽
*                            0:GSM 7 bit default alphabet
*                            1:8 bit data
*                            2:UCS2 (16bit)
*             tpudHeadInd: ûͷָʾUDHI
*                            0:TP-UDϢ
*                            1: TP-UDûͷͶϢ.
*             curCscsTye:  ǰʽ
*            (OUT):
*             pStrTgt:     Ŀַĵַ
*   ֵ תTRUEΪɹ FALSEΪʧ
* ˵ 
**************************************************************************/
BOOL zAt_EncSmsTextData( CHAR * pStrTgt, UINT8 * pDataSrc, UINT32 iSrcByteLen, 
                          UINT8 iCharNum, UINT8 dcs, UINT8 tpudHeadInd, 
                          T_ZAt2_CscsType curCscsType );

BOOL zAt_EncUsatTxtData( CHAR * pStrTgt, UINT8 * pDataSrc, UINT32 iSrcByteLen);

/********************************************************************
*:zAt_EncCbsTextData
*:Թ㲥ıģʽ<data>б
*˵:μ27005-3.1
********************************************************************/
BOOL zAt_EncCbsTextData( CHAR * pStrTgt, UINT8 * pDataSrc, UINT32 iSrcByteLen, 
                          UINT8 dcs, T_ZAt2_CscsType curCscsType,  UINT32 iMaxLen);

/**************************************************************************
* ƣ zAt_GetOperNameData
*  ĸתַ
* ˵ (IN):
*             pDataSrc:    Ӫ̳ݵĵַ
*             iSrcByteLen: Դַĳ
*             dcs:        0:GSM 7 bit default alphabet
*                            1:UCS2 (16bit)
*             sparenum:    Чbitλ         
*            (OUT):
*             pStrTgt:     Ŀַĵַ
*   ֵ Ӫ̳
* ˵ 
**************************************************************************/

UINT16 zAt_GetOperNameData( CHAR * pStrTgt, UINT8 * pDataSrc, UINT32 iSrcByteLen, 
                          UINT8 dcs, UINT8 sparenum);
VOID zAti_PlmnNameFromCard(BYTE * pStrTgt, T_z_UICC_Pnn *ptPnn, BYTE bNameFg);
#ifdef USE_VOICE_SUPPORT
UINT16 zAt_EncUssd7BitData(CHAR * pDataDst, UINT8 * pDataSrc, UINT16 iSrcByteLen);
#endif
BOOL zAt_EncUssdData(CHAR * pDataDst, UINT8 * pDataSrc, UINT16 iSrcByteLen, UINT8 dcs);
/**************************************************************************
* ƣ zAt_EncTime2Str
*  ʱṹݱĿַ
* ˵ (IO):
*            pStrWalk:  ַĵַ
*            (I):
*            tZAndTime:      ʱṹ
*   ֵ TRUE ɹ FALSE ʧ
* ˵ 
**************************************************************************/
UINT16 zAt_EncTime2Str(CHAR * pStrTarget, T_zApMmia_TZAndTime tZAndTime);
UINT16 zAt_EncTime2Str1(CHAR * pStrTarget, T_zAtiUmm_TZAndTime tZAndTime);
UINT16 zAt_EncPbTextByCscs(BYTE bCommaFg,CHAR * pTarget, BYTE bTextFg, BYTE *pbTextVal);
BOOL zAt_EncBCDNumType(BYTE bCommaFg, CHAR * pStrWalk, T_z_CallNum *ptNum);
BOOL zAt_EncBCDAddrType(BYTE bCommaFg, CHAR * pStrWalk, T_z_CallSubAddr *ptAddr);
UINT16 zAt_EncTpAddrVal(BYTE bCommaFg,CHAR * pStrTarget, BYTE bTpType, BYTE bAddrType, T_zApMmia_TpAddress *ptTpAddr);
// bTpType : Z_ATI_ADDRTYPE_NORM, Z_ATI_ADDRTYPE_SCA, 
UINT16 zAt_EncTpAddr (BYTE bCommaFg, CHAR * pStrTarget, BYTE bTpType, T_zApMmia_TpAddress *ptTpAddr);
UINT16 zAt_EncScAddr (BYTE bCommaFg, CHAR * pStrTarget, BYTE bTpType, T_zApMmia_TpAddress *ptTpAddr);

/**************************************************************************
* ƣ zAt_EncErrorCode
*  ɵǰʽʹԭӦ
* ˵ (IN):
*             cmdId:       ڲοݵID
*             dwReason:    ϢеĴԭֵ
*             cmeeType:    +CMEEõķش
*            (OUT)
*             pStrCmd:     õַ
*   ֵ TRUE ɹ FALSE ʧ
* ˵ 
**************************************************************************/
UINT16 zAt_EncErrorCode(CHAR * pStrCmd, T_ZAt2_CmdIdType cmdId, DWORD dwReason);

/**************************************************************************
* ƣ zAt_DecCallNum2Bcd
*  ɵǰʽԴBCDֽڱַĿַ
* ˵ (IN):
*             pStrNum:     ԴACSIIַĵַ
*             iStrNumLen:  ԴACSIIַĳ
*            (OUT)
*             pBcdArr:     ĿBCDĵַ
*             pPlusFlag:   Ƿ'+'
*   ֵ תֽڳȣ-1Ϊַ
* ˵ 
**************************************************************************/
SINT16 zAt_DecCallNum2Bcd(UINT8 * pBcdArr, BOOL * pPlusFlag, CHAR * pStrNum, UINT16 iStrNumLen, BYTE bMaxNumLen);

BOOL zAt_DecStr2CompArr(UINT8 * pTgtArr,UINT16 *iTgtArrLen, UINT16 iTgtArrMaxLen,CHAR ** pSrcStr,BOOL iNeedParam);

/**************************************************************************
* ƣ zAt_DecStr2ArrByCscsType
*  ֵַַ뷽ʽתĿ
* ˵ (IN):
*            pTgtArr:             Ŀָ
*            iTgtArrMaxLen:       Ŀ󳤶
*            pSrcStr:             Դֵַָ
*            iSrcLen:             Դֵַ
*            cscsType:            ַ뷽ʽ
*            (OUT):
*   ֵ ʵתֽڳȣ-1ΪԴ0Ϊ
* ˵ Ŀǰ֧GSM,HEX,UCS2
**************************************************************************/
SINT16 zAt_DecStr2ArrByCscsType(UINT8 * pTgtArr, UINT16 iTgtArrMaxLen, 
                                 CHAR * pSrcStr, UINT16 iSrcLen, UINT8 cscsType);
SINT16 zAt_DecScpbwPbStr(UINT8 * pTgtArr, UINT16 iTgtArrMaxLen, CHAR * pSrcStr, UINT16 iSrcLen, UINT8 cscsType);
SINT16 zAt_DecPbStrByCscsType(UINT8 * pTgtArr, UINT16 iTgtArrMaxLen, CHAR * pSrcStr, UINT16 iSrcLen, UINT8 cscsType);
#ifdef USE_VOICE_SUPPORT
/**************************************************************************
*:zAt_DecStr2Gsm7bByCscsType
*:ַתΪGSM7BIT 
*˵:(IN):
*                          pTgtArr:             Ŀָ
*                          iTgtArrMaxLen:       Ŀ󳤶
*                          pSrcStr:             Դֵַָ
*                          cscsType:            ַ뷽ʽ
*   ֵ ʵתֽڳȣ-1ΪԴ0Ϊ
**************************************************************************/
SINT16 zAt_DecStr2Gsm7bByCscsType(UINT8 * pTgtArr, UINT16 iTgtArrMaxLen, CHAR * pSrcStr, UINT16 iSrcLen, UINT8 cscsType);
#endif
/**************************************************************************
* ƣ zAt_DecStr2ArrByCbsOfDcs
*  ֵַַ뷽ʽתĿ
* ˵ (IN):
*            pTgtArr:             Ŀָ
*            iTgtArrMaxLen:       Ŀ󳤶
*            pSrcStr:             Դֵַָ
*            iSrcLen:             Դֵַ
*            cscsType:            ַ뷽ʽ
*            (OUT):
*   ֵ ʵתֽڳȣ-1ΪԴ0Ϊ
* ˵ Ŀǰ֧GSM,HEX,UCS2
**************************************************************************/
SINT16 zAt_DecStr2ArrByCbsOfDcs(UINT8 * pTgtArr, UINT16 iTgtArrMaxLen, CHAR * pSrcStr, UINT16 iSrcLen, UINT8 iDcs);
/**************************************************************************
* ƣ zAt_DecStr2ArrByCscsTypeCmcc
*  ֵַַ뷽ʽתĿ
* ˵ (IN):
*            pTgtArr:             Ŀָ
*            iTgtArrMaxLen:       Ŀ󳤶
*            pSrcStr:             Դֵַָ
*            iSrcLen:             Դֵַ
*            iCoding:             ַ뷽ʽ
*            (OUT):
*   ֵ ʵתֽڳȣ-1ΪԴ0Ϊ
* ˵ Ŀǰ֧GSM,HEX,UCS2
**************************************************************************/
//SINT16 zAt_DecStr2ArrByCscsTypeCmcc(UINT8 * pTgtArr, UINT16 iTgtArrMaxLen, 
//                                 CHAR * pSrcStr, UINT16 iSrcLen, UINT8 iCoding);

/**************************************************************************
* ƣ zAt_DecNumValid
*  жϺЧԣȡЧĺ
* ˵ (IN):
*             pStrNum:     ԴACSIIַĵַ
*             iStrNumLen:  ԴACSIIַĳ
*            (OUT)
*             pBcdArr:     ĿBCDĵַ
*   ֵ תֽڳȣ-1Ϊַ
* ˵ 
**************************************************************************/
BOOL zAt_DecNumValid(UINT8 * pValidArr, CHAR * pStrNum, UINT16 * iStrNumLen);

/**************************************************************************
* ƣ zAt_DecNumStr2BcdByCscsType
*  ֵַַ뷽ʽתĿBCD(ֽ)
* ˵ (IN):
*            pNumArr:             ĿBCDָ
*            iMaxNumLen:          Ŀȣֽ
*            pNumStr:             Դֵַָ
*            iSrcLen:             Դֵַ
*            cscsType:            ַ뷽ʽ
*            (OUT):
*   ֵ ʵת(ֽ)-1ΪԴ0Ϊ
* ˵ Ŀǰ֧GSM,HEX,UCS2
**************************************************************************/
SINT16 zAt_DecNumStr2BcdByCscsType(UINT8 * pNumArr, UINT32 iMaxNumLen, 
                                      CHAR * pNumStr, UINT16 iStrLen, T_ZAt2_CscsType cscsType);

/**************************************************************************
* ƣ zAt_DecDCmdGetNextParamStr
*  ֶȡһ'*'֮ǰӲΣָһβͷλ
* ˵ (IO):
*             pStrParam:   ַָĵַȡַַһβͷλ
*            (OUT):
*             pStrSub:      ڴȡӲֶεָ
*   ֵ ȡӲεĳȣβ'\0',-1:ʾȡʧ
* ˵ 
**************************************************************************/
SINT16 zAt_DecDCmdGetNextParamStr(CHAR * pStrSub, CHAR **pStrParam);

/**************************************************************************
* ƣ zAt_DecSmsTextStr
*  Textʽ¶Ϣıַ
* ˵ (IN):
*            pStrContent:     ¶δPDUַĵַָ
*            iContentLen:      ʣַ
*            wPduLen:          pdu
*              (OUT)
*            pbPduBuf:        Textָ
*   ֵ ؽ, TRUE ɹFALSE ʧ
* ˵ PDUtģʽ+CMGC,+CMGS,+CMGWĽ
**************************************************************************/
extern BOOL zAt_DecSmsPduStr(CHAR * pStrContent, UINT16 iContentLen, BYTE bPduLen, BYTE * pbPduBuf);
/**************************************************************************
* ƣ zAt_DecSmsTextStr
*  Textʽ¶Ϣıַ
* ˵ (IN):
*            ppSrcTextStr:     ¶δPDUַĵַָ
*            iSrcTextLen:      ʣַ
*            dcs:              TPDUݴ뷽
*                                0:GSM 7 bit default alphabet
*                                1:8 bit data
*                                2:UCS2 (16bit)
*            tpudHeadInd:      ûͷָʾUDHI
*                                0:TP-UDϢ
*                                1: TP-UDûͷͶϢ.
*            cscsType:         ǰʽ
*            (OUT):
*            ppTgtText:        Textָ
*            pTextLen:         ֽ
*   ֵ ؽ, TRUE ɹFALSE ʧ
* ˵ Textģʽ+CMGC,+CMGS,+CMGWĽ
**************************************************************************/
BOOL zAt_DecSmsTextStr(UINT8 ** ppTgtText, UINT32 * pTextLen, BYTE * pbCharNum,
                        CHAR * pSrcTextStr, UINT16 iSrcTextLen, 
                         T_ZAt2_CscsType cscsType);

/***************************************************************************
*:zAt_DecSmsCmdTextStr
*:CMGC·ıݽб
***************************************************************************/
BOOL zAt_DecSmsCmdTextStr(UINT8 ** ppTgtText, UINT32 * pTextLen, CHAR * pSrcTextStr, UINT16 iSrcTextLen);

/**************************************************************************
* ƣ zAt2_DataIntoStr
*  APDUתΪַ
* ˵ (IN):
*            data:      ¶δPDUַĵַָ
*            dataLen:   Ŵʣַȵָ
*            (OUT):
*            str:       ַָ
*            strbuff:   ַ󳤶
*   ֵ ؽ, TRUE ɹFALSE ʧ
* ˵ 
**************************************************************************/
BOOL zAt_DataIntoStr(UINT8 *data,UINT16 datalen,CHAR *str ,UINT16 strbuff);
VOID zAti_GetReadCardMutex(VOID);
VOID zAti_PutReadCardMutex(VOID);
#ifdef DSDS_VSIM
VOID zAti_GetDualCardStatMutex(VOID);
VOID zAti_PutDualCardStatMutex(VOID);
#endif
/**************************************************************************
*ƣzAt_EncNameStrByNum
*кӦ
*˵(IN):
*             ptCallNum:     źϢĵַ
*             curCscsTye:  ǰʽ
*            (OUT)
*             pStrTarget:  Ŀַĵַ
*  ֵ 
**************************************************************************/
UINT16 zAt_EncNameStrByNum (CHAR *pStrTarget, T_z_CallNum *ptCallNum, T_ZAt2_CscsType curCscsType);
BYTE zAti_UpDateIccid(PBYTE ptSrcIccid, BYTE bSrcIccidLen, PBYTE pDesIccid);
DWORD zAti_GetTmgiActErrorCode(BYTE bActStatus);
extern BYTE zAt_GetSmsCmgfType(VOID);
extern BYTE zAt_GetSmsTpDcs(VOID);
extern BYTE zAt_GetSmsTUDHI(VOID);
extern BOOL zAt_Is7BitCode(BYTE bTpDcs);
extern BOOL zAt_CheakSmsDcs(BYTE bDcs);
extern BOOL zAt_CheakCbsDcs(BYTE bDcs);
extern BOOL zAt_IsCbs7BitCode(BYTE bDcs);
extern BOOL zAt_IsClass2Sms(BYTE bDcs);
extern VOID zAt_CompressBy7Bit(BYTE *pTgtArr, BYTE *strSrcArr, UINT16 iSrcLen);
extern UINT16 zAt_CompressByCbs7Bit(BYTE *pTgtArr, BYTE *strSrcArr, UINT16 iSrcLen, UINT16 iTgtArrMaxLen);
extern BYTE zAti_IsUserMode(VOID);
extern UINT16 zAt_EncSmsAddrType ( CHAR * pStrTarget, BYTE bAddrType);

extern CHAR g_zAt_EncBuf[ZAT_LONG_CMD_LEN] ;
extern CHAR g_zAt_OK[7];
extern CHAR g_zAt_CRLF [3];
extern const T_ZAt2_GlobalOperInfo  g_zAt_Global_Plmninfo[Z_ATI_GLOPLMN_NUM];

#endif /* ZAT2_COM_H */
