/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 : ͨѶɷ޹˾ ֻҵ ƽ̨ܹ
*   ģ   : ATI2ģʵļ
*      : zati2_csd_fnc.c
*   ļʶ : 
*   ļ : 
*   ʵֹ :   
*        : ChenYun
*        : 2.0
*    : 2008/05/23
*   ˵ : 
*
*   ޸ļ¼ : 
*        : 
*     ޸ĺ : 
*     ޸ : 
*        : 
*
***************************************************************************
*
*   ļ
*   ----------------
*   ATI2ģCSʵ
*
*
**************************************************************************/
#include "ps/src/nas/ati/inc/zati_csd_fnc.h"
#include "ps/src/nas/ati/inc/zati_fnc.h"
//#include "apCsdInt.h"
#include "ps/src/nas/ati/inc/zati_com.h"
#ifndef CONFIG_SINGLECORE

extern T_ZAti_Context                  g_zAti_Context;
/**************************************************************************
*  : zAti_CsdQueueInit
*  : гʼ
* ˵ (IN) 
*               
*            (OUT)
*               
*   ֵ ɹZATI2_SUCCESSʧܷش
* ˵ ATI2ڲӿڣյCONNECTʱ
*            Ϊڴʧʱû취пӵ绰д
*            ֻһ·ӵ绰            
**************************************************************************/
SINT32 zAti_CsdQueueInit(BYTE bInstance) 
{
    g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff = (T_ZAti_VtBuff *)zOss_Malloc(sizeof(T_ZAti_VtBuff));

    if(NULL == g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdQueueInit(%d) ZATI2_MEMMALLOC_ERROR \r\n",bInstance));
        return ZATI2_MEMMALLOC_ERROR;
    }
    else
    {
        zOss_Memset((UINT8 *)g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff, 0, sizeof(T_ZAti_VtBuff));
        g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff->iCopyedLen = 0;
        g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff->iUsedLen = 0;
        g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff->bEnd = FALSE;
        g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff->mutexVtBuff = zOss_CreateMutex(ZATI2_MUTEX_OPERAT_VTBUFF, 0); 
        g_zAti_atDataEx[bInstance].tCsdBuf.wDataRemainLen = 0;
        return ZATI2_SUCCESS;
    }
}

/**************************************************************************
*  : zAti_CsdUpDataRecv
*  : ͨ 
* ˵ (IN) 
*            iChnelId     ͨID
*            iRecvLen     յݳ
*            pData        յݵ׵ַ
*            (OUT)
*   ֵ ɹZATI2_SUCCESSʧܷش
* ˵ ATI2ڲӿ
*            ҪҵӦУ̬ͨCS̬
**************************************************************************/
SINT32 __ps_static_func zAti_CsdUpDataRecv(UINT8 iChnelId, UINT16 iRecvLen, UINT8 *pData)
{
    BOOL                    bSuccessFind = FALSE;
    UINT8                   iCcNum = 0;
    BYTE                     bInstNo = 0;
    T_ZAti_ChannelInfo     *pChnelNode = NULL;
    
    UINT32                  iRetGetMuxt = 0;
    UINT32                  iRetPutMuxt = 0;
    T_ZAti_VtBuff      *ptVtBuff = NULL;
    WORD                    wRemainLen = 0;
    bInstNo = zAti_GetTaskInstantByChnlId(iChnelId);

    ptVtBuff = g_zAti_atDataEx[bInstNo].tCsdBuf.ptVtBuff;
    wRemainLen = g_zAti_atDataEx[bInstNo].tCsdBuf.wDataRemainLen;

    if((0 == iRecvLen) || (NULL == pData) || (NULL == ptVtBuff))
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv Param Error! \r\n"));
        return ZATI2_FALSE;
    }

    for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
    {
        if(g_zAti_atDataEx[bInstNo].tCcMan.callInfo[iCcNum].iSrcIndex == iChnelId) 
        {
            bSuccessFind = TRUE;
            break;
        }
    }
        
    if(!bSuccessFind) /* ҲӦУʧ */
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv: iChnelId = %d, AP_MMIA_CC_PROC_INFO_IND_EV Can't find Equal channel!2-1\r\n",iChnelId));
        return ZATI2_FALSE;
    }
    else
    {
        pChnelNode = zAti_GetChannelNodePtr(iChnelId); /* ͨŲҽ */

        if(NULL == pChnelNode)
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv: iChnelId = %d, Error!\r\n", iChnelId));
            return ZATI2_FALSE;
        }
        else if((ZATI2_CHANNEL_MODE_DATA != pChnelNode->server_mode) || (ZATI2_CHANNEL_DATA_TYPE_CSD != pChnelNode->dataType)) /* ͨ״̬ */
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv: pChnelNode->server_mode = %d, pChnelNode->dataType = %d Error!\r\n", pChnelNode->server_mode, pChnelNode->dataType));
            return ZATI2_FALSE;
        }
        else
        {
            /* go on.. */
        }
    }

    iRetGetMuxt = zOss_GetMutex(ptVtBuff->mutexVtBuff, ZOSS_WAIT_FOREVER);

    if(ZOSS_SUCCESS != iRetGetMuxt)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv д߳ (ZOSS_SUCCESS != iRetGetMuxt)! \r\n"));
        return ZATI2_FALSE;
    }
    else
    {
        //iRecvTimes++;
        //Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_DEBUG, "\n дiRecvTimes = %ld, iCopyedLen = %d, iReadLen = %d, iUsedLen = %d, bEnd = %d, g_zAti_iDataRemainLen = %d\n", 
        //    iRecvTimes, g_zAti_VtBuff->iCopyedLen, g_zAti_VtBuff->iReadLen, g_zAti_VtBuff->iUsedLen, g_zAti_VtBuff->bEnd, g_zAti_iDataRemainLen));
    }

    if(ptVtBuff->bEnd) /* Ѿ˾ͷ˵PwѾ浽ĩβͷ */
    {
        if(ptVtBuff->iCopyedLen == ptVtBuff->iUsedLen)
        {
            /*  */
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_DEBUG, "zati2---iRecvLen = %d, %s, ", iRecvLen, pData));
        }
        else if(ptVtBuff->iCopyedLen > 0) /* ͷʣĿλ */
        {
            if(ptVtBuff->iUsedLen + iRecvLen < ptVtBuff->iCopyedLen) /* ܹɸյģδڴ */
            {
                zOss_Memcpy(ptVtBuff->arrData + ptVtBuff->iUsedLen, pData, iRecvLen); /* ʼλãҪע */
                wRemainLen = wRemainLen + iRecvLen;
                ptVtBuff->iUsedLen = ptVtBuff->iUsedLen + iRecvLen;
            }
            else
            {
                UINT16 iRecvRestLen = 0; /* յģҪĲ֣ʣಿ֣ */
                
                iRecvRestLen = ptVtBuff->iCopyedLen - ptVtBuff->iUsedLen;
                zOss_Memcpy(ptVtBuff->arrData + ptVtBuff->iUsedLen, pData, iRecvRestLen); 
                wRemainLen = wRemainLen + iRecvRestLen;//g_zAti_VtBuff->iCopyedLen;
                ptVtBuff->iUsedLen = ptVtBuff->iUsedLen + iRecvRestLen;//g_zAti_VtBuff->iCopyedLen;

                if(iRecvLen - iRecvRestLen > 0)
                {
                    UINT8 arrData[160] = {0};
                    
                    if(iRecvLen - iRecvRestLen <= 160) /* С160ߴӡ */
                    {
                        zOss_Memcpy(arrData, pData + iRecvRestLen, iRecvLen - iRecvRestLen);
                        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_DEBUG, "zati2---arrData = %d, %s, ", iRecvLen - iRecvRestLen, arrData));
                    }
                    else
                    {
                    }
                }
            }
        }
        else
        {
            /* ݣҪͷſռ */
        }
    }
    else /* δͷֻPw<Pr */
    {
        if(ptVtBuff->iUsedLen == ZATI2_TOTAL_LEN) /* պõĩ˵ */
        {
            if(iRecvLen < ptVtBuff->iCopyedLen)
            {
                zOss_Memcpy(ptVtBuff->arrData, pData, iRecvLen);
                wRemainLen = wRemainLen + iRecvLen;
                ptVtBuff->iUsedLen = iRecvLen;
                ptVtBuff->bEnd = TRUE;
            }
            else
            {
                if(ptVtBuff->iCopyedLen == 0)
                {
                    /*  */
                    Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_DEBUG, "zati2---iRecvLen = %d, %s, ", iRecvLen, pData));
                }
                else
                {
                    zOss_Memcpy(ptVtBuff->arrData, pData, ptVtBuff->iCopyedLen); /* 0λÿ */
                    wRemainLen = wRemainLen + ptVtBuff->iCopyedLen;
                    ptVtBuff->iUsedLen = ptVtBuff->iCopyedLen;
                    ptVtBuff->bEnd = TRUE;
                }
            }
            
        }        
        else if((ptVtBuff->iUsedLen + iRecvLen) < ZATI2_TOTAL_LEN) /* 治ĩβ */
        {
            if(ptVtBuff->iUsedLen  > 0)
            {
                zOss_Memcpy(ptVtBuff->arrData + ptVtBuff->iUsedLen, pData, iRecvLen);
            }
            else
            {
                zOss_Memcpy(ptVtBuff->arrData, pData, iRecvLen);
            }
            
            wRemainLen = wRemainLen + iRecvLen;
            ptVtBuff->iUsedLen = ptVtBuff->iUsedLen + iRecvLen;
        }
        else if((ptVtBuff->iUsedLen + iRecvLen) == ZATI2_TOTAL_LEN) /* 浽ĩβ */
        {
            if(ptVtBuff->iUsedLen  > 0)
            {
                zOss_Memcpy(ptVtBuff->arrData + ptVtBuff->iUsedLen, pData, iRecvLen);
            }
            else
            {
                zOss_Memcpy(ptVtBuff->arrData, pData, iRecvLen);
            }
        
            wRemainLen = wRemainLen + iRecvLen;
            ptVtBuff->iUsedLen = ZATI2_TOTAL_LEN; //0; 090721 
            ptVtBuff->bEnd = FALSE; //TRUE; 090721 
        }
        else// ((g_zAti_VtBuff->iUsedLen + iRecvLen) > ZATI2_TOTAL_LEN) /* 浽ĩβ */
        {
            UINT16 iRecvHandleLen = 0; /* Ѿյ׼ڴеĳ */
            UINT16 iRecvUnHandleLen = 0; /* Ѿյδڴеĳ */
            
            iRecvHandleLen = ZATI2_TOTAL_LEN - ptVtBuff->iUsedLen; /* ע⣬Ҫ1copyڴҪ */
            iRecvUnHandleLen = iRecvLen - iRecvHandleLen;
            zOss_Memcpy(ptVtBuff->arrData + ptVtBuff->iUsedLen, pData, iRecvHandleLen);
            wRemainLen = wRemainLen + iRecvHandleLen;
            ptVtBuff->iUsedLen = ZATI2_TOTAL_LEN;//0;
            ptVtBuff->bEnd = FALSE;//TRUE;
            
            if(ptVtBuff->iCopyedLen > 0) /* ͷʣĿλ */
            {
                if(iRecvUnHandleLen < ptVtBuff->iCopyedLen) /* ܹɸյģδڴ */
                {
                    zOss_Memcpy(ptVtBuff->arrData, pData + iRecvHandleLen, iRecvUnHandleLen); /* ʼλãҪע */
                    wRemainLen = wRemainLen + iRecvUnHandleLen;
                    ptVtBuff->iUsedLen = iRecvUnHandleLen;
                }
                else
                {
                    zOss_Memcpy(ptVtBuff->arrData, pData + iRecvHandleLen, ptVtBuff->iCopyedLen); /* ģ */
                    wRemainLen = wRemainLen + ptVtBuff->iCopyedLen;
                    ptVtBuff->iUsedLen = ptVtBuff->iCopyedLen;
                }
                
                ptVtBuff->bEnd = TRUE; /* ͷʼдҪ1 */ /* ȡֳ */
            }
            else
            {
                /* ݣҪͷſռ */
                if(iRecvUnHandleLen > 0) 
                {
                    UINT8 arrData[160] = {0}; /* for test */
                    
                    if(iRecvUnHandleLen <= 160) /* С160߲Ŵӡ */
                    {
                        zOss_Memcpy(arrData, pData + iRecvHandleLen, iRecvUnHandleLen);
                        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_DEBUG, "zati2---arrData = %d, %s, ", iRecvUnHandleLen, arrData));
                    }
                    else
                    {
                    }
                }
            }
            
        }
    }

    {
        //Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_DEBUG, "\n д뿪iRecvTimes = %ld, iCopyedLen = %d, iReadLen = %d, iUsedLen = %d, bEnd = %d, g_zAti_iDataRemainLen = %d\n", 
        //    iRecvTimes, g_zAti_VtBuff->iCopyedLen, g_zAti_VtBuff->iReadLen, g_zAti_VtBuff->iUsedLen, g_zAti_VtBuff->bEnd, g_zAti_iDataRemainLen));
    }

    iRetPutMuxt = zOss_PutMutex(ptVtBuff->mutexVtBuff);

    if(ZOSS_SUCCESS != iRetPutMuxt)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv (ZOSS_SUCCESS != iRetGetMuxt)! \r\n"));
        return ZATI2_FALSE;
    }
    else
    {
        return ZATI2_SUCCESS;
    }
}




/**************************************************************************
*  : zAti_CsdUpDataRead
*  : ݶȡ
* ˵ (IN) 
*            iChnelId     ͨID
*            iInLen       CSDҪȡ󳤶
*            (OUT)
*            pData        ζȡݵ׵ַ
*            pOutLen      ζȡݵʵʳ
*   ֵ ɹZATI2_SUCCESSʧܷش
* ˵ ATI2ṩӿ
*            iChnelId ΪЭջԴ
*            iTempTimesReadڲԶĴ
*            CALL ID(Ti)ȡ 
*            CALL ID MO:0~6; MT:8~14; 
**************************************************************************/
SINT32 zAti_CsdUpDataRead(UINT8 bCallId, UINT16 iInLen, UINT8 **pData, UINT16 *pOutLen, UINT8 bInsNo)
{
    BOOL                    bSuccessFind = FALSE;
    UINT8                   iMmiaSrcIndex = bCallId;
    UINT8                   iZati2ChnelId = 0; /* ATIͨ */
    UINT8                   iCcNum = 0;
    T_ZAti_ChannelInfo     *pChnelNode = NULL;
    
    UINT32                  iRetGetMuxt = 0;
    UINT32                  iRetPutMuxt = 0;
    T_ZAti_VtBuff      *ptVtBuff = NULL;
    WORD                    wRemainLen = 0;
    /**/
    if((bInsNo >= Z_ATI_INSTANCE_MAX_NUM) || (0 == iInLen) || 
        (NULL == g_zAti_atDataEx[bInsNo].tCsdBuf.ptVtBuff)
        || (NULL == pData) || (NULL == pOutLen))
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRead () : bInsNo = %d ,para error\r\n", bInsNo));
        return ZATI2_FALSE;
    }

    ptVtBuff = g_zAti_atDataEx[bInsNo].tCsdBuf.ptVtBuff;
    wRemainLen = g_zAti_atDataEx[bInsNo].tCsdBuf.wDataRemainLen;

    for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
    {
        if(g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iDestIndex == iMmiaSrcIndex)
        {
            bSuccessFind = TRUE;
            iZati2ChnelId = g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iSrcIndex;
            break;
        }
    }
        
    if(!bSuccessFind) /* ҲӦͨʧ */
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRead (): bInsNo = %d, AP_MMIA_CC_PROC_INFO_IND_EV Can't find Equal channel!2-1\r\n", bInsNo));
        return ZATI2_FALSE;
    }
    else
    {
        pChnelNode = zAti_GetChannelNodePtr(iZati2ChnelId); /* ͨŲҽ */

        if(NULL == pChnelNode)
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRead: iChnelId = %d, Error!\r\n", iZati2ChnelId));
            return ZATI2_FALSE;
        }
        else if((ZATI2_CHANNEL_MODE_DATA != pChnelNode->server_mode) || (ZATI2_CHANNEL_DATA_TYPE_CSD != pChnelNode->dataType)) /* ͨ״̬ */
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain: pChnelNode->server_mode = %d, pChnelNode->dataType = %d, pChnelNode->iChnelId = %d, Error!\r\n", pChnelNode->server_mode, pChnelNode->dataType, pChnelNode->iChnelId));
            return ZATI2_FALSE;
        }
        else
        {
            /* go on.. */
        }
    }

    iRetGetMuxt = zOss_GetMutex(ptVtBuff->mutexVtBuff, ZOSS_WAIT_FOREVER);

    if(ZOSS_SUCCESS != iRetGetMuxt)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRead: bInsNo = %d, ߳ (ZOSS_SUCCESS != iRetGetMuxt)! \r\n",bInsNo));
        return ZATI2_FALSE;
    }
    else
    {
        //iTimesRead++;
        //Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\n iTimesRead = %ld, iCopyedLen = %d, iReadLen = %d, iUsedLen = %d, bEnd = %d, g_zAti_iDataRemainLen = %d\n", 
        //    iTimesRead, g_zAti_VtBuff->iCopyedLen, g_zAti_VtBuff->iReadLen, g_zAti_VtBuff->iUsedLen, g_zAti_VtBuff->bEnd, g_zAti_iDataRemainLen));
    }

    if((ptVtBuff->iUsedLen == 0) && (!ptVtBuff->bEnd)) /*  ൱ڸտʼ */
    {
        *pOutLen = 0; /* ֻسΪ0޸ĶԷָ */
    }
    else if(ptVtBuff->bEnd) /* дѾ˾ͷ˵PwѾ浽ĩβͷ */
    {
        if((ptVtBuff->iReadLen == ZATI2_TOTAL_LEN) && (ptVtBuff->iCopyedLen == ZATI2_TOTAL_LEN))
        {
            ptVtBuff->bEnd = FALSE; 
            ptVtBuff->iReadLen = 0;
            ptVtBuff->iCopyedLen = 0;

            if(iInLen > ptVtBuff->iUsedLen)
            {
                UINT16 iUnReadLen = iInLen - ptVtBuff->iUsedLen;
                UINT16 iReadLen = iInLen - iUnReadLen; /* g_zAti_VtBuff->iUsedLen */
                *pData = ptVtBuff->arrData;
                *pOutLen = iReadLen;
                ptVtBuff->iReadLen = ptVtBuff->iReadLen + iReadLen;
                wRemainLen = wRemainLen - iReadLen;
            }
            else /* <= */
            {
                *pData = ptVtBuff->arrData;
                *pOutLen = iInLen;
                ptVtBuff->iReadLen = ptVtBuff->iReadLen + iInLen;
                wRemainLen = wRemainLen - iInLen;
            }
        }
        else  if((ptVtBuff->iReadLen + iInLen) < ZATI2_TOTAL_LEN) /* ҪȡСڵﾡͷ */
        {
            if(ptVtBuff->iReadLen > 0)
            {
                *pData = ptVtBuff->arrData + ptVtBuff->iReadLen;
            }
            else
            {
                *pData = ptVtBuff->arrData;
            }

            ptVtBuff->iReadLen = ptVtBuff->iReadLen + iInLen;
            wRemainLen = wRemainLen - iInLen;
            *pOutLen = iInLen;
        }
        else if((ptVtBuff->iReadLen + iInLen) == ZATI2_TOTAL_LEN)
        {
            if(ptVtBuff->iReadLen > 0)
            {
                *pData = ptVtBuff->arrData + ptVtBuff->iReadLen;
            }
            else
            {
                *pData = ptVtBuff->arrData;
            }
            
            ptVtBuff->bEnd = TRUE;//FALSE; պö512Ҫ0
            ptVtBuff->iReadLen = ptVtBuff->iReadLen + iInLen;
            wRemainLen = wRemainLen - iInLen;
            *pOutLen = iInLen;
        }
        else /*  */
        {
            UINT16 iReadedLen = 0;   /* ֱĩβܶģѾֽ */           
            
            /* һ */
            iReadedLen = ZATI2_TOTAL_LEN - ptVtBuff->iReadLen;
            
            if(ptVtBuff->iReadLen > 0)
            {
                if(iReadedLen > 0)
                {
                    *pData = ptVtBuff->arrData + ptVtBuff->iReadLen;
                }
            }
            else
            {
                if(iReadedLen > 0)
                {
                    *pData = ptVtBuff->arrData;
                }
            }
            
            ptVtBuff->bEnd = TRUE;
            ptVtBuff->iReadLen = ZATI2_TOTAL_LEN; /* һ൱ڴͷʼ */
            wRemainLen = wRemainLen - iReadedLen;//iInLen;ȥɸ
            *pOutLen = iReadedLen;
        }
    }
    else /* δдͷֻPr < Pw */
    {
        if((ptVtBuff->iReadLen + iInLen) < ptVtBuff->iUsedLen) /* ҪȡСѾдȥ */
        {
            if(ptVtBuff->iReadLen > 0)
            {
                *pData = ptVtBuff->arrData + ptVtBuff->iReadLen;
            }
            else
            {
                *pData = ptVtBuff->arrData;
            }
            
            ptVtBuff->iReadLen = ptVtBuff->iReadLen + iInLen;
            wRemainLen = wRemainLen - iInLen;
            *pOutLen = iInLen;
        }
        else if(ptVtBuff->iReadLen == ptVtBuff->iUsedLen) /* ָպغ */
        {
            wRemainLen = wRemainLen;
            *pOutLen = 0;
        }
        else /* ĳȵڻߴѾдȥ */
        {
            UINT16 iReadedLen = 0;
            
            iReadedLen = ptVtBuff->iUsedLen - ptVtBuff->iReadLen;
            
            if(ptVtBuff->iReadLen > 0)
            {
                if(iReadedLen > ZATI2_TOTAL_LEN)
                {
                    Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\nxx(iReadedLen > ZATI2_TOTAL_LEN)xxxxxx\n"));
                }
                else if(iReadedLen == 0)
                {
                    Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\nxxxxx(iReadedLen == 0)xxx\n"));
                }
                
                *pData = ptVtBuff->arrData + ptVtBuff->iReadLen;
            }
            else
            {
                *pData = ptVtBuff->arrData;
            }
            
            ptVtBuff->iReadLen = ptVtBuff->iReadLen + iReadedLen;
            wRemainLen = wRemainLen - iReadedLen;
            *pOutLen = iReadedLen;
        }
    }
    

    iRetPutMuxt = zOss_PutMutex(ptVtBuff->mutexVtBuff);        
    if(ZOSS_SUCCESS != iRetPutMuxt)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv : bInsNo = %d, (ZOSS_SUCCESS != iRetGetMuxt)! \r\n", bInsNo));
        return ZATI2_FALSE;
    }

    return ZATI2_SUCCESS;
}



/**************************************************************************
*  : zAti_CsdUpDataRead
*  : ʣ೤
* ˵ (IN) 
*            iChnelId     ͨID
*            (OUT)
*            pOutLen      ʣݳ
*   ֵ ɹZATI2_SUCCESSʧܷش
* ˵ ATI2ṩӿ
*            iChnelIdΪЭջĿţӦΪĳһ·
**************************************************************************/
SINT32 zAti_CsdUpDataRemain(UINT8 bCallId, UINT16 *pOutLen, UINT8 bInsNo)
{
    BOOL                   bSuccessFind = FALSE;
    UINT8                  iMmiaSrcIndex = bCallId;
    UINT8                  iZati2ChnelId = 0; /* ATIͨ */
    UINT8                  iCcNum = 0;
    T_ZAti_ChannelInfo    *pChnelNode = NULL;

    if((bInsNo >= Z_ATI_INSTANCE_MAX_NUM) ||(iMmiaSrcIndex == 7) || (iMmiaSrcIndex > 14) || 
        (NULL == g_zAti_atDataEx[bInsNo].tCsdBuf.ptVtBuff)) /* ͨμ */
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain: bInsNo = %d\r\n", bInsNo));
        return ZATI2_FALSE;
    }

    for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
    {
        if(g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iDestIndex == iMmiaSrcIndex)
        {
            bSuccessFind = TRUE;
            iZati2ChnelId = g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iSrcIndex;
            break;
        }
    }
        
    if(!bSuccessFind) /* ҲӦͨʧ */
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain (): bInsNo = %d, AP_MMIA_CC_PROC_INFO_IND_EV Can't find Equal channel!2-1\r\n", bInsNo));
        return ZATI2_FALSE;
    }
    else
    {
        pChnelNode = zAti_GetChannelNodePtr(iZati2ChnelId); /* ͨŲҽ */

        if(NULL == pChnelNode)
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain: iChnelId = %d, Error!\r\n", iZati2ChnelId));
            return ZATI2_FALSE;
        }
        else if((ZATI2_CHANNEL_MODE_DATA != pChnelNode->server_mode) || (ZATI2_CHANNEL_DATA_TYPE_CSD != pChnelNode->dataType)) /* ͨ״̬ */
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain: pChnelNode->server_mode = %d, pChnelNode->dataType = %d, pChnelNode->iChnelId = %d Error!\r\n", pChnelNode->server_mode, pChnelNode->dataType, pChnelNode->iChnelId));
            return ZATI2_FALSE;
        }
        else
        {
            *pOutLen = g_zAti_atDataEx[bInsNo].tCsdBuf.wDataRemainLen;
            return ZATI2_SUCCESS;
        }
    }
}



/**************************************************************************
*  : zAti_CsdUpDataRelease
*  : ݶȡͷŴ
* ˵ (IN) 
*            iChnelId     ͨID
*            (OUT)
*            pData        ָ
*            pOutLen      ݳ
*   ֵ ɹZATI2_SUCCESSʧܷش
* ˵ ATI2ṩӿ
*            CALL ID(Ti)ȡ 
*            CALL ID MO:0~6; MT:8~14; 
**************************************************************************/
SINT32 zAti_CsdUpDataRelease(UINT8 bCallId, UINT8 *pData, UINT16 pOutLen, UINT8 bInsNo)
{
    BOOL                    bSuccessFind = FALSE;
    UINT8                   iMmiaSrcIndex = bCallId;
    UINT8                   iZati2ChnelId = 0; /* ATIͨ */
    UINT8                   iCcNum = 0;
    T_ZAti_ChannelInfo     *pChnelNode = NULL;
    UINT32                  iRetGetMuxt = 0;
    UINT32                  iRetPutMuxt = 0;
    T_ZAti_VtBuff      *ptVtBuff = NULL;

    if(bInsNo >= Z_ATI_INSTANCE_MAX_NUM ||NULL == g_zAti_atDataEx[bInsNo].tCsdBuf.ptVtBuff)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain (): Error!,bInsNo = %d\r\n", bInsNo));
        return ZATI2_FALSE;
    }

    ptVtBuff = g_zAti_atDataEx[bInsNo].tCsdBuf.ptVtBuff;

    for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
    {
        if(g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iDestIndex == iMmiaSrcIndex)
        {
            bSuccessFind = TRUE;
            iZati2ChnelId = g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iSrcIndex;
            break;
        }
    }
        
    if(!bSuccessFind) /* ҲӦͨʧ */
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain () :Can't find Equal channel, bInsNo = %d\r\n",bInsNo));
        return ZATI2_FALSE;
    }
    else
    {
        pChnelNode = zAti_GetChannelNodePtr(iZati2ChnelId); /* ͨŲҽ */

        if(NULL == pChnelNode)
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain: iChnelId = %d, Error!\r\n", iZati2ChnelId));
            return ZATI2_FALSE;
        }
        else if((ZATI2_CHANNEL_MODE_DATA != pChnelNode->server_mode) || (ZATI2_CHANNEL_DATA_TYPE_CSD != pChnelNode->dataType)) /* ͨ״̬ */
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRemain: pChnelNode->server_mode = %d, pChnelNode->dataType = %d , pChnelNode->iChnelId = %d,Error!\r\n", 
                pChnelNode->server_mode, pChnelNode->dataType,pChnelNode->iChnelId));
            return ZATI2_FALSE;
        }
        else
        {
            /* go on... */
        }
    }

    iRetGetMuxt = zOss_GetMutex(ptVtBuff->mutexVtBuff, ZOSS_WAIT_FOREVER);

    if(ZOSS_SUCCESS != iRetGetMuxt)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRelease ͷ߳ (ZOSS_SUCCESS != iRetGetMuxt)!, bInsNo = %d\r\n", bInsNo));
        return ZATI2_FALSE;
    }
    else
    {
        //iTimesRelease++;
        //Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_SEVERE, "\n ͷŽiTimesRelease = %ld, iCopyedLen = %d, iReadLen = %d, iUsedLen = %d, bEnd = %d, g_zAti_iDataRemainLen = %d\n", 
        //    iTimesRelease, g_zAti_VtBuff->iCopyedLen, g_zAti_VtBuff->iReadLen, g_zAti_VtBuff->iUsedLen, g_zAti_VtBuff->bEnd, g_zAti_iDataRemainLen));
    }

    if(ptVtBuff->iCopyedLen == ZATI2_TOTAL_LEN)
    {
        ptVtBuff->iCopyedLen = pOutLen; /* һθպõĩβ */
    }
    else if(((UINT8 *)pData != ptVtBuff->arrData + ptVtBuff->iCopyedLen) /* һεֵ */
        || (ptVtBuff->iCopyedLen + pOutLen > ZATI2_TOTAL_LEN))
    {
        iRetPutMuxt = zOss_PutMutex(ptVtBuff->mutexVtBuff);
        
        if(ZOSS_SUCCESS != iRetPutMuxt)
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRecv (ZOSS_SUCCESS != iRetGetMuxt)!,bInsNo = %d \r\n", bInsNo));
        }

        return ZATI2_FALSE;
    }
    else
    {
        if(ptVtBuff->iCopyedLen + pOutLen < ZATI2_TOTAL_LEN)
        {
            ptVtBuff->iCopyedLen = ptVtBuff->iCopyedLen + pOutLen;
        }
        else if(ptVtBuff->iCopyedLen + pOutLen == ZATI2_TOTAL_LEN)
        {
            ptVtBuff->iCopyedLen = ZATI2_TOTAL_LEN;
            
            if((ptVtBuff->iReadLen == ZATI2_TOTAL_LEN) && (ptVtBuff->bEnd)) //(g_zAti_VtBuff->bEnd == TRUE))
            {
                ptVtBuff->iCopyedLen = 0;
                ptVtBuff->iReadLen = 0;
                ptVtBuff->bEnd = FALSE;
            }
            else if((ptVtBuff->iReadLen == ZATI2_TOTAL_LEN) && (!ptVtBuff->bEnd)) //(g_zAti_VtBuff->bEnd == FALSE))
            {
                ptVtBuff->iCopyedLen = ZATI2_TOTAL_LEN;
                ptVtBuff->iReadLen = ZATI2_TOTAL_LEN;
                ptVtBuff->bEnd = FALSE;
            }
        }
    }

    iRetPutMuxt = zOss_PutMutex(ptVtBuff->mutexVtBuff);

    {
        //*iTempTimesRead = iTimesRead;
        //Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_SEVERE, "\n ͷ뿪iTimesRelease = %ld, iCopyedLen = %d, iReadLen = %d, iUsedLen = %d, bEnd = %d, g_zAti_iDataRemainLen = %d\n", 
        //    iTimesRelease, g_zAti_VtBuff->iCopyedLen, g_zAti_VtBuff->iReadLen, g_zAti_VtBuff->iUsedLen, g_zAti_VtBuff->bEnd, g_zAti_iDataRemainLen));
    }

    if(ZOSS_SUCCESS != iRetPutMuxt)
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdUpDataRelease ͷ߳ (ZOSS_SUCCESS != iRetPutMuxt)!,bInsNo = %d\r\n", bInsNo));
        return ZATI2_FALSE;
    }

    return ZATI2_SUCCESS;
}




/**************************************************************************
*  : zAti_CsdCallEnd
*  : ԭãԼͷδ
* ˵ (IN) 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_CsdCallEnd(BYTE bInstance)
{
    if(NULL != g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff->mutexVtBuff)
    {
        zOss_DeleteMutex(g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff->mutexVtBuff);
        g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff->mutexVtBuff = NULL;
    }
    
    if(NULL != g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff)
    {
        zOss_Free(g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff);
        g_zAti_atDataEx[bInstance].tCsdBuf.ptVtBuff = NULL;
    }
}




/**************************************************************************
*  : zAti_CsdEvProc
*  : ATI2CSDϢ
* ˵ (IN) 
*            iEvId          ϢID
*            iDataLen       ݳ
*            pDataPtr       ָ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ ATI2ڲӿ
*************************************************************************
VOID zAti_CsdEvProc(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData)
{
    
    switch(iEvId)
    {
    case ZPS_AtiCsd_DataInd_Ev:
        {
            zAti_CsdDownDataInd(pDataPtr, iDataLen);
        }
        break;
        
    case ZPS_AtiCsd_FlowCtrl_ON_Ev:
        {
            zAti_CsdFlowCtrlOn(pDataPtr, iDataLen);
        }
        break;
        
    case ZPS_AtiCsd_FlowCtrl_OFF_Ev:
        {
            zAti_CsdFlowCtrlOff(pDataPtr, iDataLen);
        }
        break;    
        
    default:
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---CSD Unkown EvId\r\n"));
        }
        break;
    }
}
*/


/**************************************************************************
*  : zAti_CsdDownDataInd
*  : յݴ취
* ˵ (IN) 
*            pDataPtr     ָ
*            iDataLen     ݳ
*            (OUT)
*   ֵ ɹCSDͨţʧܷЧͨ
* ˵ ATI2ڲӿ
*           CALL ID(Ti)ȡ 
*           CALL ID MO:0~6; MT:8~14; 
**************************************************************************/
VOID zAti_CsdDownDataInd(UINT8 *pDataPtr, UINT16 iDataLen, UINT8 bCallId, UINT8 bInsNo)
{
    BOOL                    bSuccessFind = FALSE;
    UINT8                   iZati2ChnelId = 0; /* ATIͨ */
    UINT8                   iCcNum = 0;
    T_ZAti_ChannelInfo     *pChnelNode = NULL;

    if((NULL == pDataPtr) || (0 == iDataLen) || (bInsNo>= Z_ATI_INSTANCE_MAX_NUM))
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdDownDataInd Para Error!,bInsNo = %d\r\n", bInsNo));
        return;   
    }

    for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
    {
        if(g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iDestIndex == bCallId)
        {
            bSuccessFind = TRUE;
            iZati2ChnelId = g_zAti_atDataEx[bInsNo].tCcMan.callInfo[iCcNum].iSrcIndex;
            break;
        }
    }

    if(!bSuccessFind) /* ҲӦͨʧ */
    {
        Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdDownDataInd () Can't find Equal channel!,bInsNo = %d\r\n", bInsNo));
    }
    else
    {
        pChnelNode = zAti_GetChannelNodePtr(iZati2ChnelId); /* ͨŲҽ */

        if(NULL == pChnelNode)
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdDownDataInd: iChnelId = %d, Error!\r\n", iZati2ChnelId));
        }
        else if((ZATI2_CHANNEL_MODE_DATA != pChnelNode->server_mode) || (ZATI2_CHANNEL_DATA_TYPE_CSD != pChnelNode->dataType)) /* ͨ״̬ */
        {
            Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdDownDataInd: pChnelNode->server_mode = %d, pChnelNode->dataType = %d, pChnelNode->iChnelId = %d, Error!\r\n", 
                pChnelNode->server_mode, pChnelNode->dataType, pChnelNode->iChnelId));
        }
        else
        {
            /* ݷ͵ͨͨiChnelId */
            if(ZATI2_SUCCESS == zAti_SendFnc(pChnelNode->iChnelId, pDataPtr, iDataLen, ZATI2_CHIND_CSD))
            {
                //Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdDownDataInd SendData Success! iLen = %d\r\n", CsdDataInd->bDataLen));
            }
            else
            {
                Z_PRINTF((SUBMDL_Z_ATI, PRINT_LEVEL_NORMAL, "\r\nZATI2---zAti_CsdDownDataInd SendData Failed!,bInsNo = %d\r\n", bInsNo));
            }
        }
    }
}

/**************************************************************************
*  : zAti_CsdFlowCtrlOff
*  : 
* ˵ (IN) 
*            (OUT)
*   ֵ 
* ˵ Ԥ
**************************************************************************/
VOID zAti_CsdFlowCtrlOff(UINT8 *pDataPtr, UINT16 iDataLen)
{
}


/**************************************************************************
*  : zAti_CsdFlowCtrlOn
*  : 
* ˵ (IN) 
*            (OUT)
*   ֵ 
* ˵ Ԥ
**************************************************************************/
VOID zAti_CsdFlowCtrlOn(UINT8 *pDataPtr, UINT16 iDataLen)
{
}

/**************************************************************************
*  : zAti_CsdDlData_Write
*  : յݴ취
* ˵ (IN) 
*            pBuf     ָ
*            bLen     ݳ
*            bPortId  ͨ
*            (OUT)
*   ֵ 
* ˵ ATI2ⲿӿ
**************************************************************************/
VOID zAti_CsdDlData_Write(PBYTE pBuf, WORD wLen, BYTE bCallId, BYTE bInsNo)
{
    zAti_CsdDownDataInd(pBuf, wLen, bCallId, bInsNo);
}
#endif
