/**************************************************************************
*
*             Protocol Stack Adapter Layer Telephone Interface
*
*                  Copyright (c) 2007 ZTE Corporation.
*
***************************************************************************
*
*   汾 : ͨѶɷ޹˾ ֻҵ ƽ̨ܹ
*   ģ   : ATI2ģʵļ
*      : zati2_fnc.c
*   ļʶ : 
*   ļ : 
*   ʵֹ :   
*        : ChenYun
*        : 2.0
*    : 2008/02/25
*   ˵ : 
*
***************************************************************************
*
*   ļ
*   ----------------
*   ATI2ʵ
*
***************************************************************************/

/**************************************************************************
*                        ͷļ                                      *
**************************************************************************/
#include "ps/src/nas/ati/inc/zat_com.h"
#include "ps/src/nas/ati/inc/zati_csd_fnc.h"
#include "ps/src/nas/ati/inc/zati_pdi_fnc.h"
#include "ps/src/nas/ati/inc/zat_fnc.h"
#include "ps/src/nas/ati/inc/zati_com.h"
#include "ps/src/nas/ati/inc/zati_othr.h" 
#include "ps/src/nas/ati/inc/zat_ext_fnc.h"
#include "ps/src/nas/ati/inc/zati_sm.h" 
#include "sys_func_atcfg.h"
#ifdef USE_VOICE_SUPPORT
#ifndef _OS_WIN
#include "drvs_volte.h"
#endif
#endif
/**************************************************************************
*                                                                    *
**************************************************************************/
#define ZATI2_INVAL_INDEX              0xff

/**************************************************************************
*                                                                      *
**************************************************************************/

/**************************************************************************
*                          ֲ                                       *
**************************************************************************/
static BYTE zAti_CheckRecvMsg(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen);
//--static VOID zAti_HandleSmOpenChInd(VOID *pBuff);
static VOID zAti_HandleSmGetPcoInd(VOID *pBuff);
static BOOL zAti_HandleSmActCnfExt(VOID *pDataPtr);
static DWORD zAti_HandleSmActCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
//static VOID zAti_HandleSmCloseChInd(VOID *pBuff);
static VOID zAti_HandleZmenaCnf(VOID *pDataPtr);
static BOOL zAti_IsNoOccupyedCid(PBYTE pExistedExCid, BYTE bCid);
static BOOL zAti_GetDualStackExCid(PBYTE pExistedExCid,PBYTE pExCid);
static BOOL zAti_HandleSmDeActCid(UINT8 bCid);
static BOOL zAti_HandleSmCleanExCidInfo(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf);
static BOOL zAti_HandleSmActFailedExCid(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf, UINT8* pDest);
static  T_ZAti_ChannelInfo * zAti_GetChnelNode(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen);
#ifdef USE_VOICE_SUPPORT
static VOID zAti_HandleCcDiscInd( T_ZAti_ChannelInfo *pChnelNode);
#endif
DWORD zAti_HandleCgattSetReqCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
static SINT32 zAti_ChangeChnelNodeToData(T_ZAti_DataType dataType, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen, T_ZAti_ChannelInfo *pChnelNode);
#ifdef USE_VOICE_SUPPORT
static VOID zAti_SendConnInd(UINT8 *pDataPtr, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen, T_ZAti_ChannelInfo *pChnelNode);
#endif
static SINT32 zAti_SendSmConnectInd(UINT8 *pDataPtr, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen, T_ZAti_ChannelInfo *pChnelNode);
static VOID zAti_HandleZgactCnfMsg(T_zMmiaSm_PdpAct_Cnf *pSmCgactCnf,  T_ZAti_ChannelInfo *pChnelNode);
static BOOL zAti_HandleCnfMsgBeforeEncCmd(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen,  T_ZAti_ChannelInfo *pChnelNode);
static VOID zAti_CpbrHandle(T_zApMmia_CpbrSet_Req* pCpbrReq, UINT16 iStartRec, T_zStmPb_StorageId readStorage, T_zStm_Cpbr_Cnf *pCpbrStmCnf);
static BOOL  zAti_GetDestTaskByMsgID(UINT32 msgId, UINT8 *destTask);
static VOID zAti_SaveOnlyCidTab(UINT8 iCid, BYTE bExCid, BYTE bExPdpType);

static VOID zAti_EUmcrBand39InfoInd(VOID* pBuff);

static BYTE zAti_ConvertTskIdToSbMdl(BYTE destTask);
static VOID zAti_CpbrCnf(UINT8 *pDataPtr);
static VOID zAti_StmListInd(UINT8 *pDataPtr);
// ϱϢ
#ifdef Z_DUALSTANDBY
static VOID zAti_RecvGrrNCellChngInd(VOID *pBuff);
#endif
#ifdef USE_VOICE_SUPPORT
static VOID zAti_Drv_dtmfrx_Report(char *dtmf, unsigned char dtmfLen);
#ifndef _OS_WIN
static VOID zAti_RegDtmfCallBack();
#endif
#endif
static VOID zAti_NotifyApModemReady(VOID); /* 617001591411 ܻ- ܻV3汾ͬʵ*/
static DWORD zAti_PreUiccSlotInd(VOID *pbMsgData, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
static DWORD zAti_HandleUserDeactCnfMsg( VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);
static DWORD zAti_HandlePppCommonCnf(VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode);

VOID zAti_RemoveALLCmd(T_ZAti_ChannelInfo *pChnelNode);
VOID zAti_HandlePppProcCmdError(VOID);
BYTE zAti_PppGetCid(BYTE  bChnelId);
#ifdef Z_DUALSTANDBY
VOID zAti_CsCallStartInd(VOID *pDataPtr);
VOID zAti_CsCallEndInd(VOID *pDataPtr);
#endif
VOID zAti_ClearPcoChap(VOID);
VOID zAti_GetEmInfoMutex(BYTE bInsIdx);
VOID zAti_PutEmInfoMutex(BYTE bInsIdx);
VOID zAti_DecreaseReqCountAndRelMutexSemaphore(VOID);
VOID zAti_EMCellInfoReq(VOID);
BOOL zAti_PcoItemIsValidByPcoId(WORD wId);
static VOID zAti_Transform (UINT32 *buf, UINT32 *in);
/**************************************************************************
*                           ȫֱ                                      *
**************************************************************************/

const T_ZAti_MsgTrnsprncy g_TaskMsgMap[] =
{
    /************************CC Massage************************/
#ifdef USE_VOICE_SUPPORT
    {MMIA_CC_ANS_MODE_REQ_EV,           Z_ATI_TASKID_CC },
    {MMIA_CC_STATE_QUERY_REQ_EV,        Z_ATI_TASKID_CC },
    {MMIA_CC_DIS_MODE_REQ_EV,           Z_ATI_TASKID_CC },
    {MMIA_CC_MODIFY_REQ_EV,             Z_ATI_TASKID_CC },
    {MMIA_CC_CHLD_REQ_EV,                Z_ATI_TASKID_CC},
    {MMIA_CC_CSTA_SET_REQ_EV,                Z_ATI_TASKID_CC  },
    {MMIA_CC_CSTA_QUERY_REQ_EV,                Z_ATI_TASKID_CC  },
    {MMIA_CC_DTMF_REQ_EV,              Z_ATI_TASKID_CC  },
    {MMIA_CC_MTC_RSP_EV,                Z_ATI_TASKID_CC  },
    //{MMIA_CC_CSTA_SET_REQ_EV,           Z_ATI_TASKID_CC},
    //{MMIA_CC_CSTA_QUERY_REQ_EV,         Z_ATI_TASKID_CC},
    {MMIA_CC_STATE_REQ_EV,        Z_ATI_TASKID_CC},
    {MMIA_CC_OPEN_VOICECHNL_REQ_EV,     Z_ATI_TASKID_CC},
    {MMIA_CC_SRVCC_NOTOPEN_VOICECHNL_REQ_EV,   Z_ATI_TASKID_CC},
#endif
    /************************ESM Massage************************/
    {MMIA_ESM_EPS_QOS_QUERY_REQ_EV, Z_ATI_TASKID_ESM   },

    
    /************************SM Massage*******************/
#if defined (PS_RAT_GSM) || defined (PS_RAT_TDD) || defined (PS_RAT_FDD)
    {MMIA_SM_NEG_QOS_QUERY_REQ_EV    ,Z_ATI_TASKID_SM},
    {MMIA_SM_NEG_EQOS_QUERY_REQ_EV    ,Z_ATI_TASKID_SM},
#endif
#ifdef CXT_MOV
    {MMIA_SM_CONTEXT_REQ_EV, Z_ATI_TASKID_SM},
#endif
    //{MMIA_SM_DISCONNECT_REQ_EV    ,Z_ATI_TASKID_SM},


    /************************SM and ESM Massage*******************/
    {MMIA_SM_IDLE_CHNL_QUERY_RSP_EV    ,Z_ATI_TASKID_SM},
    {MMIA_SM_PDP_STATUS_QUERY_REQ_EV, Z_ATI_TASKID_ESM    },
    {MMIA_SM_ACTIVATED_CID_QUERY_REQ_EV, Z_ATI_TASKID_ESM},
    {MMIA_SM_DATA_STATE_REQ_EV, Z_ATI_TASKID_ESM },
    {MMIA_SM_PDP_ADDR_QUERY_REQ_EV, Z_ATI_TASKID_ESM },
    {MMIA_SM_PDP_MODIFY_REQ_EV, Z_ATI_TASKID_ESM },
    {MMIA_SM_CGCONTRDP_REQ_EV, Z_ATI_TASKID_ESM   },
    {MMIA_SM_CGSCONTRDP_REQ_EV, Z_ATI_TASKID_ESM },
    {MMIA_SM_CGTFTRDP_REQ_EV, Z_ATI_TASKID_ESM    },
    {MMIA_SM_GET_PCO_RSP_EV, Z_ATI_TASKID_ESM},
    {MMIA_SM_IP_PDP_ACT_REQ_EV, Z_ATI_TASKID_ESM},

    /************************UICC Massage************************/
    {AP_UICC_INIT_REQ_EV, Z_ATI_TASKID_UICC  },
    {AP_UICC_PIN_REMAIN_NUM_REQ_EV, Z_ATI_TASKID_UICC   },
    {AP_UICC_PIN_STAT_QUERY_REQ_EV, Z_ATI_TASKID_UICC},
    {AP_UICC_PIN_APPL_SET_REQ_EV, Z_ATI_TASKID_UICC},
    {AP_UICC_PIN_APPL_READ_REQ_EV, Z_ATI_TASKID_UICC},
    {AP_UICC_CARD_MODE_REQ_EV, Z_ATI_TASKID_UICC},
    {AP_UICC_READ_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_ZPUK_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_AUTH_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_REFRESH_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_USAT_ENVELOP_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_USAT_TERMNL_RSP_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_USAT_TERMNL_PROF_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_TO_READ_CARD_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_CSIM_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_CCHO_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_CCHC_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_CGLA_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_CRSM_REQ_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_AIR_AUTH_RSP_IND_EV, Z_ATI_TASKID_UICC },
    {AP_UICC_READ_EID_REQ_EV, Z_ATI_TASKID_UICC },

    /************************UMM Massage************************/
    {MMIA_UMM_CGATT_QUERY_REQ_EV  , Z_ATI_TASKID_UMM},
    {MMIA_UMM_ACTIVE_REQ_EV  , Z_ATI_TASKID_UMM  },
    {MMIA_UMM_ZATT_QUERY_REQ_EV  , Z_ATI_TASKID_UMM},
    {MMIA_UMM_SYSCONFIG_REQ_EV  , Z_ATI_TASKID_UMM  },
    {MMIA_UMM_SYSCONFIG_QUERY_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_VOICE_MODE_SET_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_VOICE_MODE_QUERY_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_SMSOVERIPNET_SETREQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_CSG_SEL_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_CURRENT_CSG_QUERY_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_CSG_LIST_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_EPS_MODE_QUERY_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_EPS_MODE_SET_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_PLMN_LIST_REQ_EV  , Z_ATI_TASKID_UMM },
    {MMIA_UMM_SET_LTE_ACT_REQ_EV, Z_ATI_TASKID_UMM },
    {MMIA_UMM_CS_SRV_CNF_EV, Z_ATI_TASKID_UMM },
    {MMIA_UMM_IMS_REGISTER_STATES_EV, Z_ATI_TASKID_UMM},
    {MMIA_UMM_XCELLINFO_REQ_EV, Z_ATI_TASKID_UMM},
#ifdef USE_VOICE_SUPPORT
    {MMIA_UMM_CSVOICE_QUERY_REQ_EV, Z_ATI_TASKID_UMM},
#endif

    /************************SS Massage************************/
#ifdef USE_VOICE_SUPPORT
    {MMIA_SS_CLIP_READ_REQ_EV , Z_ATI_TASKID_SS },
    {MMIA_SS_CLIR_READ_REQ_EV , Z_ATI_TASKID_SS },
    {MMIA_SS_CCFC_SET_REQ_EV , Z_ATI_TASKID_SS },
    {MMIA_SS_CCWA_SET_REQ_EV , Z_ATI_TASKID_SS },
    {MMIA_SS_COLR_READ_REQ_EV , Z_ATI_TASKID_SS },
    {MMIA_SS_CNAP_READ_REQ_EV , Z_ATI_TASKID_SS },
    {MMIA_SS_COLP_READ_REQ_EV , Z_ATI_TASKID_SS },
#endif
#ifdef _USE_LPP_ECID
    {MMIA_SS_MTLR_ANS_REQ_EV , Z_ATI_TASKID_SS},
#endif
    /************************SMS Massage************************/
    {MMIA_SMS_REC_RSP_REQ_EV  ,Z_ATI_TASKID_SMS },
    {MMIA_SMS_MEM_AVAIL_REQ_EV, Z_ATI_TASKID_SMS},

        
    /************************PB Massage************************/
    {AP_MMIA_PB_STORAGE_STATUS_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_EDIT_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_CPBW_QUERY_REQ_EV , Z_ATI_TASKID_PB },
    //--{AP_MMIA_PB_FIND_INDEX_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_FIND_TEXT_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_STO_SET_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_S_FIND_INDEX_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_SCPBR_TEST_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_S_EDIT_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_SCPBW_TEST_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_C_NUM_REQ , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_READ_CAPA_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_READ_SET_NUM_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_PREF_MSG_STO_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_PREF_MSG_STO_TEST_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_QUERY_SMS_MAX_INDEX_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_SM_READ_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_SM_SAVE_REQ_EV , Z_ATI_TASKID_PB},
    {AP_MMIA_SM_DELETE_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_SM_READ_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_MEM_CAPA_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_PB_READ_LAST_EXT_ERR_REQ_EV , Z_ATI_TASKID_PB },
    {AP_MMIA_SM_MEM_AVAIL_RSP_EV,     Z_ATI_TASKID_PB },   


    /************************CBS Massage************************/
    { MMIA_CBS_ACTIVATE_REQ_EV , Z_ATI_TASKID_CBS },
    
    /************************AS Massage************************/
    { MMIA_EUCSR_LTEINFO_REQ_EV , Z_ATI_TASKID_EUCSR },
    { MMIA_AS_RSSI_QUERY_REQ_EV, Z_ATI_TASKID_EUMCR},
    { MMIA_AS_SINR_QUERY_REQ_EV, Z_ATI_TASKID_EUMCR},
    { MMIA_AS_SAI_LIST_QUERY_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_AS_SAI_LIST_REPORT_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_AS_TMGI_LIST_QUERY_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_AS_TMGI_LIST_REPORT_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_AS_TMGI_LIST_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_AS_MBMS_PREFERENCE_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_AS_NW_TIME_QUERY_REQ_EV, Z_ATI_TASKID_EUCSR},
    { MMIA_AS_EM_LTE_HO_SET_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_AS_EM_LTE_HO_SET_QUERY_REQ_EV, Z_ATI_TASKID_EUCER},
    { MMIA_GRR_ZGPCG_REQ_EV, Z_ATI_TASKID_GRR},
    { MMIA_L1T_ZTPCG_REQ_EV, Z_ATI_TASKID_L1T},
    { MMIA_L1W_ZWPCG_REQ_EV, Z_ATI_TASKID_L1W},

    /******************** LTE GoTaģ ***************************/
    /************************TSM Massage************************/
#ifdef BTRUNK_SUPPORT
    { ATI_TSM_REG_REQ_EV ,                    Z_ATI_TASKID_TSM },
    { ATI_TSM_CALL_REQ_EV ,                   Z_ATI_TASKID_TSM },
    { ATI_TSM_CALLCONFIRM_REQ_EV ,            Z_ATI_TASKID_TSM },
    { ATI_TSM_CALLCONNECT_REQ_EV ,            Z_ATI_TASKID_TSM },
    { ATI_TSM_CALLRLS_REQ_EV ,                Z_ATI_TASKID_TSM },
    { ATI_TSM_FLOOR_REQ_EV ,                  Z_ATI_TASKID_TSM },
    { ATI_TSM_FLOORRLS_REQ_EV ,               Z_ATI_TASKID_TSM },
    { ATI_TSM_STUNINFO_QUERY_REQ_EV ,         Z_ATI_TASKID_TSM },
    { ATI_TSM_GROUPINFO_QUERY_REQ_EV ,        Z_ATI_TASKID_TSM },
    { ATI_TSM_SCANGROUPINFO_REQ_EV ,          Z_ATI_TASKID_TSM },
    { ATI_TSM_SCANSWITCH_REQ_EV ,             Z_ATI_TASKID_TSM },
    { ATI_TSM_SHAKEHAND_REQ_EV ,              Z_ATI_TASKID_TSM },
    { ATI_TSM_SHORT_DATA_REQ_EV ,             Z_ATI_TASKID_TSM },
    { ATI_TSM_LOCATINFO_REQ_EV ,              Z_ATI_TASKID_TSM },
    { ATI_TSM_SETABILITY_REQ_EV ,             Z_ATI_TASKID_TSM },
    { ATI_TSM_CALLFORWARD_REQ_EV ,            Z_ATI_TASKID_TSM },
    { ATI_TSM_CALLMODIFY_RSP_EV ,             Z_ATI_TASKID_TSM },
    { ATI_TSM_CALLMODIFY_REJ_EV ,             Z_ATI_TASKID_TSM },

    /**************************ESM Massage**********************/
    { PTT_MMIA_ESM_TAUTYPE_REQ_EV ,           Z_ATI_TASKID_ESM },
#endif
};
       
// P_AtiProcFunc atiOuterMsgMap[22][Z_ATI_PROCFUNC_NUM] ޸
T_zAti_PreOuterMsgTab  atPreOuterMsg[] = {

        /**************SMS**********************/
        {MMIA_SMS_MSG_SEND_CNF_EV,     zAti_SmsMsgSendCnf},
        {MMIA_SMS_DELIVER_REC_IND_EV,  zAti_SmsDeliverRecInd},
        {MMIA_SMS_STATUS_REC_IND_EV,   zAti_SmsStatusRecInd},
        {MMIA_SMS_REC_RSP_CNF_EV,zAt_SmsRecRspCnf},

        /**************CBS**********************/
        {MMIA_CBS_DATA_IND_EV,         zAti_Cbs_DataInd},
        
        /***************UICC**********************/
        {AP_UICC_INIT_CNF_EV ,       zAti_UiccInitCnf},
        {AP_UICC_INIT_IND_EV,       zAti_UiccZuststInd},
        {AP_UICC_SLOT_IND_EV,        zAti_PreUiccSlotInd},
        {AP_UICC_UICCOK_IND_EV,      zAti_UiccOkInd},
        {AP_UICC_READ_CNF_EV,        zAti_UiccReadCnf},
        {AP_UICC_UPDATE_CNF_EV,      zAti_UiccUpdateCnf},
        {AP_UICC_AUTH_RSP_EV,        zAti_UiccAuthRsp},
        {AP_UICC_AUTH_FAIL_IND_EV,   zAti_UiccAuthFailInd},        
        {AP_UICC_UPDATE_ITEM_CNF_EV, zAti_UiccUpdateItemCnf},
        {AP_UICC_VERIFY_PIN2_CNF_EV, zAti_VerifyPin2Cnf},
        {AP_UICC_COMMON_CNF_EV,      zAti_UiccCommonCnf},

        /***************UMM**********************/
        {MMIA_UMM_PLMN_INFO_IND_EV,  zAti_PlmnInfo},
        {MMIA_UMM_PLMN_LIST_CNF_EV,  zAti_PlmnList},
        {MMIA_UMM_MM_INFO_IND_EV,    zAti_Mminfo},
        {MMIA_UMM_RF_CTRL_CNF_EV,    zAti_RfControl},
        {MMIA_UMM_SEARCH_PLMN_CNF_EV,zAti_UmmSearchPlmnCnf},
        {MMIA_UMM_ACTIVE_CNF_EV,     zAti_HandleCgattSetReqCnf},
        {MMIA_UMM_COMMON_CNF_EV,    zAti_UmmCommonCnf},
        {MMIA_UMM_CS_SRV_IND_Ev,    zAti_UmmCsSrvInd},

        /***************SM**********************/
       // {MMIA_SM_CONNECT_IND_EV,     zAti_SmConnectInd},
        {MMIA_SM_PDP_ACTIVATE_CNF_EV,zAti_HandleSmActCnf },
        {MMIA_SM_PDP_DEACTIVATE_CNF_EV, zAti_HandleUserDeactCnfMsg},
      //  {MMIA_SM_PDP_ACTIVATE_IND_EV, zAti_SmMtActivateInd},
        {MMIA_SM_CGEV_IND_EV, zAti_SmMtCgevInd},
        {MMIA_SM_COMMON_CNF_EV, zAti_HandlePppCommonCnf},
        {MMIA_SM_NO_CARRIER_CNF_EV,  zAti_HandleSmNoCarrierCnf},
        {MMIA_SM_PDP_CAUSE_QUERY_CNF_EV, zAti_HnadlePdpCauseQueryCnf},

        /***************ESM**********************/
        
        /***************CC**********************/
#ifdef USE_VOICE_SUPPORT
        {MMIA_CC_MOC_CNF_EV,         zAti_CcMocCnf},
        {MMIA_CC_MTC_IND_EV,         zAti_CcMtcInd},
        {MMIA_CC_ANS_MODE_CNF_EV,    zAti_CcAnsModCnf},
        {MMIA_CC_MODIFY_CNF_EV,      zAti_CcModifyCnf},
        {MMIA_CC_DISC_IND_EV,        zAti_CcDiscInd},
        {MMIA_CC_SS_NOTIFY_IND_EV,   zAti_CcSsNotifyInd},
        {MMIA_CC_PROC_INFO_IND_EV,   zAti_ProcInfoInd},
        {MMIA_CC_CCM_QUERY_CNF_EV,   zAti_CcmQueryCnf},
        {MMIA_CC_DISC_CNF_EV,        zAti_CcDicsCnf},
        {MMIA_CC_DTMF_CNF_EV,      zAti_CcDtmfCnf},
#endif
        /***************SS**********************/

        /***************PB**********************/
        {AP_MMIA_SM_SAVE_CNF_EV,           zAti_PbSaveSmCnf},
        {AP_MMIA_SM_READ_CNF_EV,           zAti_PbReadSmCnf},
        {AP_MMIA_SM_DELETE_CNF_EV,         zAti_PbDeleteSmCnf},

        {AP_MMIA_SM_MEM_AVAIL_IND_EV,      zAti_PbSmMemAvail},
        {AP_MMIA_PB_STORAGE_STATUS_CNF_EV, zAti_PbPBMemStatusCnf},
        {AP_MMIA_PB_INIT_COMP_IND_EV,      zAti_PbInitCmpltInd},
#ifdef CXT_MOV
        {MMIA_SM_CONTEXT_CNF_EV,  zAti_SmContextCnf},
        {MMIA_UMM_PS_CONTEXT_CNF_EV, zAti_UmmPsContextCnf},
#endif
#ifdef DSDS_VSIM
        {MMIA_AS_CARD_SWITCH_CNF_EV, zAti_CardSwitchCnf},
#endif
};


const T_zAti_NonReportMsg g_zAti_NonReportMsgTable[]  =
{
#ifdef USE_VOICE_SUPPORT
    {MMIA_CC_NOTIFY_AOC_TIMER_IND_EV,zAt_NotifyAocTimerInd},
#endif
    {RR_EM_HO_INFO_IND,zAt_EM_GrrcHoInfoInd},
    {MMIA_AS_EM_UHO_INFO_IND_EV,zAt_EM_UrrcHoInfoInd},
    {MSGTRACEPS_CELL_DISPLAY_REQ_EV,zAt_TracePsCellDisplayReq},
    {MMIA_UMM_SUBMODE_IND_EV,zAt_HspaInd},
    {MMIA_UMM_UPDATE_DUALPSSYSCONFIG_IND_EV,zAt_UpdtDualPsAdptChgVar},
#ifdef USE_VOICE_SUPPORT
    {MMIA_CC_DUALPSCFG_IND_EV, zAt_UpdtCcDualPsInd},
#endif
    {MMIA_SMS_MMS_DISABLE_IND_EV,zAt_SmsDisableInd},
#ifdef USE_VOICE_SUPPORT
    {MMIA_CC_OPEN_VOICE_CHNL_IND_EV,zAt_CcOpenVoiceChnlInd},
    {MMIA_CC_CLOSE_VOICE_CHNL_IND_EV,zAt_CcCloseVoiceChnlInd},
#endif
    {MSGTRACEPS_CELLRESORCCOCOUNT_REQ_EV, zAti_CellresOrCcoCountReq},
    {ROADTEST_UEINFO_REQ_EV, zAti_RoadTest_QueryUeInfoReq},
    {MMIA_AS_B39_INFO_IND_EV, zAti_EUmcrBand39InfoInd},
    {MMIA_UMM_IMSNOTSUPPORT_IND_EV, zAti_ImsNotSupportInd},
#ifdef Z_DUALSTANDBY
    {MMIA_UMM_CS_CALL_START_IND_EV,zAti_CsCallStartInd},
    {MMIA_UMM_CS_CALL_END_IND_EV,zAti_CsCallEndInd},
#endif
    {MMIA_ASC_LTE_LOSTCOVERAGE_IND_EV, zAti_LteNoCellInd},

    // ԭеϢ
#ifdef Z_DUALSTANDBY
     {Z_RRMI_INTER_RAT_NCELL_IND_EV, zAti_RecvGrrNCellChngInd},
#endif

    //ԭg_zAti_HandleMmiaMsgWithoutChnelNodeϢ
    {MMIA_SM_CID_DEACT_IND_EV,       zAti_SmDeactivateInd},//ûԴĿ
    {MMIA_SM_GET_PCO_IND_EV,         zAti_HandleSmGetPcoInd},
    {MMIA_SMS_MEM_AVAIL_CNF_EV,      zAti_HandleZmenaCnf},
    {MMIA_SM_IDLE_CHNL_QUERY_IND_EV, zAti_UsbSioSmMtQueryIdleChInd},

    /***************AS**********************/
    {MMIA_AS_RPT_RXLEV_IND_EV ,  zAti_McrRptRxlevInd},
    {MMIA_AS_QUERY_RXLEV_IND_EV, zAti_McrRptRxlevCnf},
    {RRMI_RXSTAT_IND,            zAti_GrrRptRxlevInd},
    {RRAT_RXSTAT_IND,            zAti_GrrRptRxlevCnf},
    {MMIA_AS_UL_PARAM_IND_EV,    zAti_HandleUlParaInd},
};

/**************************************************************************
*                           ȫֺԭ                                  *
**************************************************************************/

BYTE __ps_static_func zAti_IsNeedCardInit(VOID)
{
     return (BYTE)(g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag == Z_ATI_CARDINIT_NOT  && Z_INVALID == zDev_GetCfunFlag());
}

BOOL __ps_static_func zAti_IsSingleCardForTwoStandby()
{
    return (zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) == zDev_GetTaskId(Z_ATI_TASKID_UICC, 1));
}

BOOL zAti_IsLteStandBy(BYTE bInsNo)
{ 
    if(zDev_GetTaskId(Z_ATI_TASKID_ESM, bInsNo) != ZOSS_INVALID_TASK_ID)
    {
        return TRUE;
    }
    return FALSE;
}

BOOL __ps_static_func zAti_IsSingleCardForOneStandby(VOID)
{
    return (((zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) == ZOSS_INVALID_TASK_ID) && (zDev_GetTaskId(Z_ATI_TASKID_UICC, 1) != ZOSS_INVALID_TASK_ID))
        ||((zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) != ZOSS_INVALID_TASK_ID) && (zDev_GetTaskId(Z_ATI_TASKID_UICC, 1) == ZOSS_INVALID_TASK_ID ))); 
}

BOOL __ps_static_func zAti_IsRightStandAtCmd(UINT8 iChannel)
{
    BYTE bInsNo = zAti_GetTaskInstantByChnlId(iChannel);

    if(zDev_GetTaskId(Z_ATI_TASKID_UMM, bInsNo) == ZOSS_INVALID_TASK_ID)
    {
        return FALSE;
    }
    return TRUE;
}
#ifdef Z_DUALCARD_ADAPT
BOOL zAti_IsDualCardSelfAdaptChanging(VOID)
{
    if(g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging ||
        g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging)
    {
        return TRUE;
    }
    return FALSE;
}

/******************************************************
*:zAti_IsCmdChnelIdIdel
*:жͨǷڿ״̬
*жϹ:
*1)̬ͨûڴ
*2)̬ͨûдڶϢ̬
*3)ͨĽڵΪ
*4)ͨΪ
********************************************************/
BOOL zAti_IsCmdChnelIdIdel(BYTE bInsNo)
{
    T_ZAti_ChannelInfo *pChnelNode = zAti_GetFirstChannelNodePtrByInstance(bInsNo);
    BYTE bMaxChnlId = ((bInsNo == Z_ATI_INSNO_2)? Z_ATI_INSTANCE_TWO_CHNL_MAX : Z_ATI_INSTANCE_ONE_CHNL_MAX);

    while(pChnelNode != NULL && pChnelNode->iChnelId <= bMaxChnlId)
    {
        if(pChnelNode->cmdInputInfo.cmdInputStat == ZAT2_SMS_EDIT)
        {
            return FALSE;/*ǰŷѾͷŵݻδս*/
        }
        else if(pChnelNode->cmdInputInfo.cmdInputStat == ZAT2_ATCMD)
        {
            if(ZAT2_NO_COMMAND != pChnelNode->cmd_id && ZAT2_CO_INVALID != pChnelNode->cmd_op)
            {
                return FALSE;/*ǰڴ*/
            }
            else if(pChnelNode->atBuff.iLength != 0)
            {
                return FALSE;/*ͨлδȡ*/
            }
            else if(zAti_HasMoreCmd(pChnelNode))
            {
                return FALSE;/*ͨڵл*/
            }
        }

        pChnelNode = pChnelNode->pNextCnNode;
    }
    return TRUE;
}
#endif
BOOL __ps_static_func zAti_IsSingleCard()
{
    return (zAti_IsSingleCardForOneStandby() || zAti_IsSingleCardForTwoStandby());
}

BYTE __ps_static_func zAti_GetTaskInstantByChnlId(BYTE bChnlId)
{
    return (bChnlId > Z_ATI_INSTANCE_ONE_CHNL_MAX) ? Z_ATI_INSNO_2 : Z_ATI_INSNO_1;
}

BYTE __ps_static_func zAti_GetInstantForSingleCardOneStandby()
{
    return (zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) == ZOSS_INVALID_TASK_ID) ? Z_ATI_INSNO_2 : Z_ATI_INSNO_1;
}

BYTE __ps_static_func zAti_GetInstantbyDesIndex(BYTE bChnlId)
{
    if(ZATI2_CHANNEL_ID_NUM251 == bChnlId)
    {
        return Z_ATI_INSNO_1;
    }
    else if(ZATI2_CHANNEL_ID_NUM252 == bChnlId)
    {
        return Z_ATI_INSNO_2;
    }
    else
    {
        return zAti_GetTaskInstantByChnlId(bChnlId);
    }
}

BOOL __ps_static_func zAti_IsUiccEv(UINT32 iEvId)
{
    return ((iEvId >= AP_UICC_EVENT_BASE && iEvId <= AP_UICC_EVENT_END) ||
        (iEvId >= AP_MMIA_EVENT_UICC_BASE && iEvId <= AP_MMIA_EVENT_UICC_END));
}

BOOL __ps_static_func zAti_IsStmEv(UINT32 iEvId)
{
    return ((iEvId >= AP_MMIA_PB_RSP_EVENT && iEvId <= AP_MMIA_EVENT_PB_END) || iEvId == AP_MMIA_ZPBIC_IND_EV);
}

BOOL __ps_static_func zAti_IsLogTraceMsgAndGetTaskIndex(UINT32 iEvId, UINT8 *pDataPtr, PBYTE pbInsNo)
{
    T_zAti_RTUeInfo_Req *ptUeInfoReq = ZOSS_NULL;
    T_z_MsgtracePs_CellresOrCcoCount_Req *ptCellresOrCcoCountReq = ZOSS_NULL;
    T_zMsgtracePs_CellDisplay_Req *ptMsgTraceReq = ZOSS_NULL;

    switch(iEvId)
    {
        case ROADTEST_UEINFO_REQ_EV:
            ptUeInfoReq = (T_zAti_RTUeInfo_Req*)pDataPtr;
            *pbInsNo = ptUeInfoReq->bStackIndex - 1;
            return TRUE;
        case MSGTRACEPS_CELLRESORCCOCOUNT_REQ_EV:
            ptCellresOrCcoCountReq = (T_z_MsgtracePs_CellresOrCcoCount_Req*)pDataPtr;
            *pbInsNo = ptCellresOrCcoCountReq->bStackIndex - 1;
            return TRUE;
        case MSGTRACEPS_CELL_DISPLAY_REQ_EV:
            ptMsgTraceReq = (T_zMsgtracePs_CellDisplay_Req*)pDataPtr;
            *pbInsNo = ptMsgTraceReq->bStackIndex - 1;
            return TRUE;
        default:
            return FALSE;
    }
}
BOOL __ps_static_func zAti_IsSelfExpiryMsg(UINT32 iEvId)
{
    switch(iEvId)
    {
        case MMIA_EM_HO_INFO_EXPIRY_EV:
#ifdef Z_SELL_STAT_SUPPORT
        case MMIA_SELL_STAT_REG_EXPIRY_EV:
        case MMIA_SELL_STAT_SUM_PDP_EXPIRY_EV:
        case MMIA_SELL_STAT_ONE_PDP_EXPIRY_EV:
#endif
#ifdef USE_VOICE_SUPPORT
        case MMIA_AOC_EXPIRY_EV:
#endif
        case MMIA_ZGDT_EXPIRY_EV:
        case EV_ZATI2_TEST_SEND_CS_DATA:
        case MMIA_ZULRTIND_EXPIRY_EV:
            return TRUE;
        default:
            return FALSE;
    }
}

BOOL __ps_static_func zAti_IsAsMsg(UINT32 iEvId)
{ /*EMBMSʱ˴ҲҪϢ*/
    if(iEvId == AS_EM_CELL_INFO_IND_EV||
        iEvId == RR_EM_CELL_INFO_IND ||
        iEvId == MMIA_AS_EM_UCELL_INFO_IND_EV ||
        iEvId == MMIA_AS_EM_EUCELL_INFO_IND_EV ||
        iEvId == MMIA_AS_EM_UHO_INFO_IND_EV ||
        iEvId == MMIA_EUCSR_LTEINFO_IND_EV ||
        iEvId == MMIA_L1E_ZEPCG_CNF ||
        iEvId == MMIA_AS_RSSI_QUERY_CNF_EV ||
        iEvId == MMIA_AS_SINR_QUERY_CNF_EV ||
        iEvId == MMIA_EUSIR_ETWS_PRIMARY_IND_EV ||
        iEvId == MMIA_EUSIR_ETWS_SECONDARY_IND_EV ||
        iEvId == MMIA_AS_RPT_RXLEV_IND_EV ||
        iEvId == MMIA_AS_QUERY_RXLEV_IND_EV ||
        iEvId == MMIA_AS_B39_INFO_IND_EV ||
        iEvId == RR_EM_HO_INFO_IND ||
        iEvId == RRAT_RXSTAT_IND ||
        iEvId == RRMI_RXSTAT_IND ||
        iEvId == Z_RRMI_INTER_RAT_NCELL_IND_EV ||
        iEvId == MMIA_AS_QUERY_EM_UCELL_INFO_CNF_EV ||
        iEvId == MMIA_AS_QUERY_EM_EUCELL_INFO_CNF_EV ||
        iEvId == RR_QUERY_EM_CELL_INFO_CNF_EV ||
        iEvId == AS_QUERY_EM_CELL_INFO_CNF_EV||
        iEvId == MMIA_AS_TMGI_ACTIVATE_CNF_EV||
        iEvId == MMIA_AS_TMGI_DEACTIVATE_CNF_EV||
        iEvId == MMIA_AS_SAI_LIST_QUERY_RESP_EV||
        iEvId == MMIA_AS_SAI_LIST_IND_EV||
        iEvId == MMIA_AS_TMGI_LIST_QUERY_RESP_EV||
        iEvId == MMIA_AS_TMGI_LIST_IND_EV||
        iEvId == MMIA_AS_MBMS_SERVICE_SUSPEND_IND_EV||
        iEvId == MMIA_AS_MBMS_SERVICE_RESUME_IND_EV||
        iEvId == MMIA_AS_COMMON_CFG_CNF_EV||
        iEvId == MMIA_AS_NW_TIME_QUERY_RESP_EV||
        iEvId == MMIA_ASC_LTE_LOSTCOVERAGE_IND_EV||
        iEvId == MMIA_AS_EM_LTE_HO_SET_QUERY_CNF_EV||
        iEvId == MMIA_AS_EM_LTE_HO_INFO_IND_EV||
        iEvId == MMIA_GRR_ZGPCG_CNF_EV||
        iEvId == MMIA_L1T_ZTPCG_CNF_EV||
        iEvId == MMIA_L1W_ZWPCG_CNF_EV||
        iEvId == MMIA_AS_UL_PARAM_IND_EV||
        iEvId == MMIA_AS_CARD_SWITCH_CNF_EV)
    {
        return TRUE;
    }
    return FALSE;
}

BYTE __ps_static_func zAti_GetTaskInstantIndexByTaskId(UINT32 iEvId, UINT8 *pDataPtr, ZOSS_TASK_ID tSendTaskId)
{
    BYTE bSubMod = 0;
    BYTE bTaskIndex = Z_ATI_INVALID_BYTE;

    if(iEvId == EV_ZATI2_RECV_COMMAND_IND)
    {
        T_ZAti_ChannelDataBuf *recvCmdInd = (T_ZAti_ChannelDataBuf *)pDataPtr;
        return zAti_GetTaskInstantByChnlId(recvCmdInd->iChannel);
    }

    if (iEvId == EV_ZATI2_ZEMCELLINFO_REQ)
    {
        return ((T_ZAti_EMCellInfo_Req *)pDataPtr)->bInstance;
    }

    if(zAti_IsAsMsg(iEvId)) /*жASϢ*/
    {
        if(iEvId == AS_QUERY_EM_CELL_INFO_CNF_EV ||
            iEvId == AS_EM_CELL_INFO_IND_EV)
        {
            T_zEM_EmInfo_Ind *pEmInfoInd = (T_zEM_EmInfo_Ind*)pDataPtr;
            return zAti_GetInstantbyDesIndex(pEmInfoInd->bDesIndex);
        }
        else
        {
            return zAti_GetInstantbyDesIndex(*(pDataPtr + 1));
        }
    }
    if(iEvId == MMIA_L1E_ZEPCG_CNF )/*L1E޷zOss_Sender()ȡ*/
    {
        return zAti_GetTaskInstantByChnlId(*(pDataPtr + 1));
    }

    if(zAti_IsSelfExpiryMsg(iEvId))/*ʱϢ*/
    {
        return *pDataPtr;
    }

    if(zAti_IsLogTraceMsgAndGetTaskIndex(iEvId, pDataPtr, &bTaskIndex))
    {
        return bTaskIndex;
    }

    if(iEvId == EV_ZATI2_CPBR_CNF)/*ϢĿȽ*/
    {
        T_zStm_Cpbr_Cnf *pCpbrStmCnf = ( T_zStm_Cpbr_Cnf *)pDataPtr;
        return zAti_GetTaskInstantByChnlId(pCpbrStmCnf->cpbrSetCnf.bDesIndex);
    }

    if(zAti_IsSingleCardForOneStandby()&& (zAti_IsUiccEv(iEvId) || zAti_IsStmEv(iEvId)))
    {
        return zAti_GetInstantForSingleCardOneStandby();/*ʱIDʵ*/
    }
    else if (zAti_IsSingleCardForTwoStandby() && (zAti_IsUiccEv(iEvId) || zAti_IsStmEv(iEvId)))
    {
        /*˫ʱϱϢ޷ʵ
         һ⼴ɣӰϱʱ쳣۲
         ޸ĽΪҲӰ, ޸ 2013.10.30 by hyc*/
        return zAti_GetInstantbyDesIndex(*(pDataPtr + 1));
    }
    else if ((Z_VALID == zAti_IsDualPsDualUicc()) && ((iEvId == AP_UICC_USAT_PROV_CMD_IND_EV) || (iEvId == AP_UICC_NO_PROC_NOTIFY_IND_EV)))
    {
        /*˫˫ʱϱϢ޷ʵ*/
        return zAti_GetInstantbyDesIndex(*(pDataPtr + 1));
    }

    if (tSendTaskId == g_zAti_Context.taskIdMy)/*ԷϢ*/
    {
        return zAti_GetTaskInstantByChnlId(*(pDataPtr + 1));
    }

    for (bSubMod = 0; bSubMod < Z_SUBMDL_NUM; bSubMod++)
    {
        if (tSendTaskId == zDev_GetTaskId(bSubMod, 0))
        {
            return Z_ATI_INSNO_1;
        }

        if (tSendTaskId == zDev_GetTaskId(bSubMod, 1))
        {
            return Z_ATI_INSNO_2;
        }
    }

    return Z_ATI_INVALID_BYTE;
}

T_ZAti_ChannelInfo * zAti_GetFirstChannelNodePtrByInstance (BYTE bInstance)
{
    T_ZAti_ChannelInfo *pChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;

    if (pChnelNode == NULL)
    {
        return ZOSS_NULL;
    }

    if (bInstance)
    {
        while(pChnelNode && pChnelNode->iChnelId <= Z_ATI_INSTANCE_ONE_CHNL_MAX)
        {
            pChnelNode = pChnelNode->pNextCnNode;
        }

        return pChnelNode;
    }
    else if (pChnelNode->iChnelId <= Z_ATI_INSTANCE_ONE_CHNL_MAX)
    {
        return pChnelNode;
    }
    else
    {
        return ZOSS_NULL;
    }
}

#ifdef Z_DUALSTANDBY
VOID zAti_RecvGrrNCellChngInd(VOID *pBuff)
{
    T_z_RRMI_INTER_RAT_NCELL_IND *ptNCellInd = (T_z_RRMI_INTER_RAT_NCELL_IND *)pBuff;
    T_zMmiaUmm_DualPsTLNCell *ptNotifyUmm = (T_zMmiaUmm_DualPsTLNCell *)zAti_GetUB(sizeof(T_zMmiaUmm_DualPsTLNCell));

    zOss_Memcpy(ptNotifyUmm, ptNCellInd, sizeof(T_zMmiaUmm_DualPsTLNCell));
    g_zAti_CurInstance = g_zAti_CurInstance == 0? 1: 0;
    
    zAti_MsgSend(Z_TD_LTE_CELL_IND_EV, (PBYTE)ptNotifyUmm, sizeof(T_zMmiaUmm_DualPsTLNCell), Z_ATI_TASKID_UMM);

    g_zAti_CurInstance = g_zAti_CurInstance == 0? 1: 0;
}
#endif

VOID __ps_static_func zAti_InsertNodeInSortingAscend (T_ZAti_ChannelInfo *ptNewChnlNode)
{
    T_ZAti_ChannelInfo *ptPrevNode = ZOSS_NULL;
    T_ZAti_ChannelInfo *ptNode = g_zAti_ptData->tAtChnelList.pChnelNode;

    while(ptNode && ptNode->iChnelId < ptNewChnlNode->iChnelId)
    {
        ptPrevNode = ptNode;
        ptNode = ptNode->pNextCnNode;
    }

    if (!ptPrevNode)
    {
        g_zAti_ptData->tAtChnelList.pChnelNode = ptNewChnlNode;
    }
    else
    {
        ptPrevNode->pNextCnNode = ptNewChnlNode;
    }

    ptNewChnlNode->pNextCnNode = ptNode;
    g_zAti_ptData->tAtChnelList.iCount++;
    return;
}

SINT32 zAti_AtRecvNullFunc(UINT8 channelId, UINT8* pDataPtr, UINT16 iDataLen, T_zAti2_CtrmChInd iFlag)
{
    return ZATI2_FALSE;
}

VOID zAti_InitZgdatatestGlobalVar(VOID)
{
    T_zAti_PsDataTest_Info *pDataTstInfo = ZOSS_NULL;
    T_zAti_CsDataTest_Info *pVtDataTst = ZOSS_NULL;
    pDataTstInfo = &g_zAti_atDataEx[g_zAti_CurInstance].tDataTestInfo.tPsDataTestInfo;
    pVtDataTst = &g_zAti_atDataEx[g_zAti_CurInstance].tDataTestInfo.tCsDataTestInfo;

    if(pDataTstInfo->pTimrIdZgdt != ZOSS_INVALID_TIMER_ID)
    {
        zAti_HnadleZgdatatestCnf(pDataTstInfo->tPsZgdtInfo.iSrcIndex, pDataTstInfo->tPsZgdtInfo.iDestIndex, FALSE);
        zAti_KillTimer(&pDataTstInfo->pTimrIdZgdt);
        zOss_Memset(pDataTstInfo, 0, sizeof(T_zAti_PsDataTest_Info));
    }

    if(pVtDataTst->timerSendCsData != ZOSS_INVALID_TIMER_ID)
    {
        zAti_HnadleZgdatatestCnf(pVtDataTst->zTest.iSrcIndex, pVtDataTst->zTest.iDestIndex, FALSE);
        zAti_KillTimer(&pVtDataTst->timerSendCsData);
        zOss_Memset(pVtDataTst, 0, sizeof(T_zAti_CsDataTest_Info));
    }
}
VOID zAti_InitChnelNode(BYTE bCurChnelId)
{
    BYTE bMaxChnlId = (g_zAti_CurInstance ? Z_ATI_INSTANCE_TWO_CHNL_MAX : Z_ATI_INSTANCE_ONE_CHNL_MAX);
    T_ZAti_ChannelInfo *pTempChnelNode = zAti_GetFirstChannelNodePtrByInstance(g_zAti_CurInstance);  

    while(NULL != pTempChnelNode && pTempChnelNode->iChnelId <= bMaxChnlId)
    {
        if(pTempChnelNode->iChnelId != bCurChnelId)
        {
            if((ZAT2_NO_COMMAND != pTempChnelNode->cmd_id) || (ZAT2_CO_INVALID != pTempChnelNode->cmd_op))
            {
                pTempChnelNode->cmd_id = ZAT2_NO_COMMAND;
                pTempChnelNode->cmd_op = ZAT2_CO_INVALID;
                pTempChnelNode->bIsCardIniting = FALSE;
                zAti_Init_CmdInfo(&pTempChnelNode->cmdInputInfo);
                zAti_RemoveOneCmd(pTempChnelNode);
            }

            pTempChnelNode->IsPpp = FALSE;
        }

        if(ZATI2_CHANNEL_MODE_CMD != pTempChnelNode->server_mode)
        {
            pTempChnelNode->server_mode = ZATI2_CHANNEL_MODE_CMD;
            pTempChnelNode->dataType = ZATI2_CHANNEL_DATA_TYPE_INVAL; /* ԭ */
            zAti_SendFnc(pTempChnelNode->iChnelId, NULL, 0, ZATI2_CHIND_TURN_AT); /* лͨ */
            zAti_RemoveALLCmd(pTempChnelNode); // pppź󣬽̬ûӦ
        }

        pTempChnelNode = pTempChnelNode->pNextCnNode;
    }

}


/**************************************************************************
* ƣ zAti_StopTask
*  ֹͣ
* ˵ (IN) 
*            (OUT)
*   ֵ ɹTRUE,ʧܷFALSE;
* ˵ 
**************************************************************************/
VOID zAti_StopTask(VOID)
{
#ifndef CONFIG_SINGLECORE
    zAti_CsdCallEnd(Z_ATI_INSNO_1);
    zAti_CsdCallEnd(Z_ATI_INSNO_2);
#endif
    zOss_Memset((UINT8 *)g_zAti_SmContext, 0, sizeof(T_ZAti_SmContext) * Z_ATI_INSTANCE_MAX_NUM);
    zOss_Memset((UINT8 *)&g_zAti_atDataEx[Z_ATI_INSNO_1].tCcMan, 0, sizeof(T_ZAti_CallControlManagement));
    zOss_Memset((UINT8 *)&g_zAti_atDataEx[Z_ATI_INSNO_2].tCcMan, 0, sizeof(T_ZAti_CallControlManagement));

    g_zAti_Context.taskStatus = ZATI2_TASK_STATUS_NULL;
    g_zAti_Context.iTaskInitTimes = 0; /* ʼ */
    g_zAti_Context.sendFnc = NULL;

    if(NULL != g_zAti_Context.taskIdMy)
    {
        zOss_DeleteTask(g_zAti_Context.taskIdMy);
        g_zAti_Context.taskIdMy = NULL;
    }
}

/**************************************************************************
*                           ֲԭ                                  *
**************************************************************************/

/**************************************************************************
* ƣ zAti_TaskEntry
*  ATI2ں
* ˵ (IN) 
*            state          ״̬
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ ͨ/ݣ͸
*            շ㷢Ϣ/ݣ͸ͨ
*            ̬ATI2ջռҪΪ1024*50    
*            {1,"task_zati2",zAti_TaskEntry,20,1024*50,0,0,0}
**************************************************************************/
VOID __ps_static_func zAti_TaskEntry(UINT8 iState, UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData)
{
    switch(iState)
    {
    case ZOSS_STATUS_INIT:
        {
            zAti_TaskInit(iEvId, pDataPtr, iDataLen, pPrivateData);
        }
        break;
        
    case ZOSS_STATUS_WORK:
        {
            zAti_TaskWork(iEvId, pDataPtr, iDataLen, pPrivateData);
        }
        break;
        
    default: 
        break;
    }   
}

/**************************************************************************
* ƣ zAti_TaskInit
*  ڳʼ״̬Ĵ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_TaskInit(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData)
{
    switch(iEvId)
    {
    case EV_INIT:
        {
            g_zAti_ptData = (T_zAti_Data *)zAti_GetUB(sizeof(T_zAti_Data));
            zAti_Init();
            zAti_InitGlobalVarByInstNo(Z_ATI_INSNO_1);
            //zAti_InitGlobalVarByInstNo(Z_ATI_INSNO_2);
            zAti_InitOplPnnInfo(Z_ATI_INSNO_1);
            //zAti_InitOplPnnInfo(Z_ATI_INSNO_2);
            zAti_InitCeerGlobalVarByInstNo(Z_ATI_INSNO_1);
            //zAti_InitCeerGlobalVarByInstNo(Z_ATI_INSNO_2);
            #if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
            zAti_InitGlobalVarByInstNo(Z_ATI_INSNO_2);
            zAti_InitOplPnnInfo(Z_ATI_INSNO_2);
            zAti_InitCeerGlobalVarByInstNo(Z_ATI_INSNO_2);
            #endif
            zAti_Randomize();//
        }
        {
            zOss_Memset((UINT8 *)&g_zAti_Context, 0, sizeof(T_ZAti_Context)); /* ʼ */
            zOss_Memset((UINT8 *)g_zAti_SmContext, 0, sizeof(T_ZAti_SmContext) * Z_ATI_INSTANCE_MAX_NUM);
            g_zAti_Context.sendFnc = zAti_AtRecvNullFunc;            
            g_zAti_Context.pUsolChannelFunc = NULL;
            g_zAti_Context.pAlwaysReportChnel = NULL;
            #ifndef CONFIG_SINGLECORE
            zAti_CsdQueueInit(Z_ATI_INSNO_1);
            #endif
            //zAti_CsdQueueInit(Z_ATI_INSNO_2);
            zOss_Memset(g_zAti_atDataEx[Z_ATI_INSNO_1].abPcoAuthChkFailCount, 0, ZATI2_SM_MAX_SMCID_NUM);
            //zOss_Memset(g_zAti_atDataEx[Z_ATI_INSNO_2].abPcoAuthChkFailCount, 0, ZATI2_SM_MAX_SMCID_NUM);
            zAti_ClearPcoChap();
            zAti_InitEmInfoByInstNo(Z_ATI_INSNO_1);
            //zAti_InitEmInfoByInstNo(Z_ATI_INSNO_2);
            #if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
            #ifndef CONFIG_SINGLECORE
            zAti_CsdQueueInit(Z_ATI_INSNO_2);
            #endif
            zOss_Memset(g_zAti_atDataEx[Z_ATI_INSNO_2].abPcoAuthChkFailCount, 0, ZATI2_SM_MAX_SMCID_NUM);
            zAti_InitEmInfoByInstNo(Z_ATI_INSNO_2);
            #endif
        }
        break;
        
    case EV_POWERON:
        {
            zOss_SetState(ZOSS_STATUS_WORK); /* Ĺ״̬ */

            g_zAti_Context.taskIdMy = zOss_GetTaskID(PS_TASK_ID_ZATI);    
            g_zAti_Context.mutexGetOplPnn = zOss_CreateMutex("ZATI2_GET_OPLPNN", ZOSS_NO_INHERIT);
            g_zAti_Context.mutexOpenChnel = zOss_CreateMutex("ZATI2_OPEN_CHANNEL", ZOSS_NO_INHERIT); /* ȴDNSַź */
            #ifdef DSDS_VSIM
            g_zAti_Context.mutexCrdStat = zOss_CreateMutex("ZATI2_DUALCARDSTAT", ZOSS_NO_INHERIT);
            #endif
            g_zAti_Context.taskStatus = ZATI2_TASK_STATUS_READY;//һҪע״̬
            g_zAti_EmInfoMutex[Z_ATI_INSNO_1].mutexEmInfo = zOss_CreateMutex("ZATI_ZEMCELL_MUTEX_1", ZOSS_NO_INHERIT);
            //g_zAti_EmInfoMutex[Z_ATI_INSNO_2].mutexEmInfo = zOss_CreateMutex("ZATI_ZEMCELL_MUTEX_2", ZOSS_NO_INHERIT);
            g_zAti_EmInfoSemaphore[Z_ATI_INSNO_1].semaphoreEmInfo = zOss_CreateSemaphore("ZATI_ZEMCELL_SEMAP_1", 0);
            //g_zAti_EmInfoSemaphore[Z_ATI_INSNO_2].semaphoreEmInfo = zOss_CreateSemaphore("ZATI_ZEMCELL_SEMAP_2", 0);
           #if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
            g_zAti_EmInfoMutex[Z_ATI_INSNO_2].mutexEmInfo = zOss_CreateMutex("ZATI_ZEMCELL_MUTEX_2", ZOSS_NO_INHERIT);
            g_zAti_EmInfoSemaphore[Z_ATI_INSNO_2].semaphoreEmInfo = zOss_CreateSemaphore("ZATI_ZEMCELL_SEMAP_2", 0);
            #endif
            zAti_NotifyApModemReady();  /* 617001591411 ܻ- ܻV3汾ͬʵ*/
            #ifdef USE_VOICE_SUPPORT
            #ifndef _OS_WIN 
            zAti_RegDtmfCallBack();/*עDTMF KEYֵϱĽӿں*/
            #endif
            #endif
        }
        break;

    default:
        break;
        
    }
}

#ifdef _USE_GLOBAL_TRACE
VOID zAti_GetGvar (VOID)
{
    T_z_MsgInfo tMsgInfo = { 0 };

    if(!zAti_IsSingleCardForOneStandby())
    {
        tMsgInfo.bStackIndex = 0;
    }
    else
    {
        tMsgInfo.bStackIndex = g_zAti_CurInstance + 1;
    }
    tMsgInfo.dwMsgId = GVAR_MMIA_GET_CNF_EV;
    g_zAti_GlobData.ptSingleData = g_zAti_ptData;
    g_zAti_GlobData.ptDualData[Z_ATI_INSNO_1] = &g_zAti_atDataEx[Z_ATI_INSNO_1];
    g_zAti_GlobData.ptDualData[Z_ATI_INSNO_2] = &g_zAti_atDataEx[Z_ATI_INSNO_2];
    tMsgInfo.wMsgLen = sizeof(T_zAti_Golbal_Data);
    tMsgInfo.pMsg = (PBYTE)(&g_zAti_GlobData);

    tMsgInfo.bSrcMod = SUBMDL_Z_ATI;
    tMsgInfo.tSrcTask = zDev_GetTaskId(Z_ATI_TASKID_ATI, 0);

    tMsgInfo.bDestMod = SUBMDL_Z_EXTMOD;
    tMsgInfo.tDestTask = zOss_Sender();

    zSendMsg(&tMsgInfo, &g_zAti_ptData->dwFailCause);
    return ;
}

VOID zAti_GetGlobAtMemVar (VOID)
{
    T_z_MsgInfo tMsgInfo = {0};

    if(!zAti_IsSingleCardForOneStandby())
    {
        tMsgInfo.bStackIndex = 0;
    }
    else
    {
        tMsgInfo.bStackIndex = g_zAti_CurInstance + 1;
    }
    tMsgInfo.dwMsgId = GVAR_ATMEM_DEV_GET_CNF_EV;
    g_zAti_Atmem.ptAtMem[Z_ATI_INSNO_1] = (T_zDev_AtMem*)zDev_GetAtMemData(Z_ATI_INSNO_1);
    g_zAti_Atmem.ptAtMem[Z_ATI_INSNO_2] = (T_zDev_AtMem*)zDev_GetAtMemData(Z_ATI_INSNO_2);
    tMsgInfo.wMsgLen = sizeof(T_zAti_AtmemData);
    tMsgInfo.pMsg = (PBYTE)(&g_zAti_Atmem);

    tMsgInfo.bSrcMod = SUBMDL_Z_ATI;
    tMsgInfo.tSrcTask = zDev_GetTaskId(Z_ATI_TASKID_ATI, 0);

    tMsgInfo.bDestMod = SUBMDL_Z_EXTMOD;
    tMsgInfo.tDestTask = zOss_Sender();

    zSendMsg(&tMsgInfo, &g_zAti_ptData->dwFailCause);  
    return ;
}

VOID zAti_GetGlobNvVar (VOID)
{
    T_z_MsgInfo tMsgInfo = {0};

    if(!zAti_IsSingleCardForOneStandby())
    {
        tMsgInfo.bStackIndex = 0;
    }
    else
    {
        tMsgInfo.bStackIndex = g_zAti_CurInstance + 1;
    }
    tMsgInfo.dwMsgId = GVAR_NV_DEV_GET_CNF_EV;
    tMsgInfo.wMsgLen = zDev_GetNvDataSize();
    tMsgInfo.pMsg = zDev_GetNvData();
    
    tMsgInfo.bSrcMod = SUBMDL_Z_ATI;
    tMsgInfo.tSrcTask = zDev_GetTaskId(Z_ATI_TASKID_ATI, 0);
    
    tMsgInfo.bDestMod = SUBMDL_Z_EXTMOD;
    tMsgInfo.tDestTask = zOss_Sender();
    
    zSendMsg(&tMsgInfo, &g_zAti_ptData->dwFailCause); 
    return ;
}

BYTE __ps_static_func zAti_EnquireGlobalVar(DWORD dwMsgId)
{
    if (GVAR_MMIA_GET_REQ_EV == dwMsgId)
    {
        zAti_GetGvar ();
    }
    else if (GVAR_ATMEM_DEV_GET_REQ_EV == dwMsgId)
    {
        zAti_GetGlobAtMemVar();
    }
    else if (GVAR_NV_DEV_GET_REQ_EV == dwMsgId)
    {
        zAti_GetGlobNvVar();
    }
    else 
    {
        return Z_FAIL;
    }
    
    return Z_SUCC;
}
#endif

/**************************************************************************
* ƣ zAti_MsgSigTrace
*  յϢtraceϢ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_MsgSigTrace(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen)
{
    if (zAti_IsSingleCardForTwoStandby() && 
        (zAti_IsUiccEv(iEvId) || zAti_IsStmEv(iEvId)))
    {
        zAti_SendInfo2MsgTrace (pDataPtr, iDataLen, iEvId, Z_ATI_INSNO_1);
        zAti_SendInfo2MsgTrace (pDataPtr, iDataLen, iEvId, Z_ATI_INSNO_2);
    }
    else
    {
        zAti_SendInfo2MsgTrace (pDataPtr, iDataLen, iEvId, g_zAti_CurInstance);
    }
    return;
}
/*********************************************************
*:zAti_RecRcvMsg
*:¼յϢGVAR_MMIA_GET_REQ_EVĲѯ
*˵:ߴĲѯϢ¼
*********************************************************/
VOID __ps_static_func zAti_RecRcvMsg(UINT32 iEvId)
{
    if(iEvId != GVAR_MMIA_GET_REQ_EV &&
        iEvId != GVAR_ATMEM_DEV_GET_REQ_EV &&
        iEvId != GVAR_NV_DEV_GET_REQ_EV)
    {
        g_zAti_ptData->dwRcvMsg = iEvId;
    }
    return;
}
/**************************************************************************
* ƣ zAti_CpbrCnf
*   绰б
* ˵ (IN) 
*            pDataPtr       
*            (OUT)
*   ֵ 
* ˵  ȡֱѭ޷Ϣ
*                        ڴͷ
**************************************************************************/
VOID zAti_CpbrCnf(UINT8 *pDataPtr)
{
    T_zStm_Cpbr_Cnf *pCpbrStmCnf = ( T_zStm_Cpbr_Cnf *)pDataPtr;
    if(pCpbrStmCnf->cnfMsgId == AP_MMIA_CPBR_EXE_CNF_EV)
    {
        T_zApMmia_CpbrSet_Cnf * pCpbrSetCnf = (T_zApMmia_CpbrSet_Cnf *)zAti_GetUB(sizeof(T_zApMmia_CpbrSet_Cnf));
        (*pCpbrSetCnf) = pCpbrStmCnf->cpbrSetCnf;
        zAti_RecvServerHandlerSlaver(pCpbrStmCnf->cnfMsgId, (UINT8 *)pCpbrSetCnf, sizeof(T_zApMmia_CpbrSet_Cnf));
    }
    else if(pCpbrStmCnf->cnfMsgId == AP_MMIA_CPBR_SET_END_CNF_EV)
    {
        T_zApMmia_CpbrSetEnd_Cnf * pCpbrSetEndCnf = (T_zApMmia_CpbrSetEnd_Cnf *)zAti_GetUB(sizeof(T_zApMmia_CpbrSetEnd_Cnf));
        (*pCpbrSetEndCnf) = pCpbrStmCnf->CpbrSetEndCnf;
        zAti_RecvServerHandlerSlaver(pCpbrStmCnf->cnfMsgId, (UINT8 *)pCpbrSetEndCnf, sizeof(T_zApMmia_CpbrSetEnd_Cnf));
        zAti_RetUB((VOID **)&pCpbrStmCnf);
        return;
    }
    else
    {
        /* ERROR*/
    }
    zAti_CpbrHandle(&(pCpbrStmCnf->cpbrSetReq), (UINT16)(pCpbrStmCnf->cpbrSetCnf.wIndex+1), pCpbrStmCnf->readStorage, pCpbrStmCnf);
    return;
}
VOID zAti_HandleOplPnnCnf(T_zAti_CopnQry_Cnf *pCopnCnf)
{
    BYTE bInsNo = g_zAti_CurInstance;
    T_zAti_Copn_Exe_Cnf *pExeCnf = NULL;

    zAti_GetReadCardMutex();
    if(g_zAti_atDataEx[bInsNo].tCrdPnnOpl.bRecNum != pCopnCnf->bOplPnnTotalNum)
    {
        pCopnCnf->bOplPnnCurrNum = pCopnCnf->bOplPnnTotalNum;/*м޿쳣Ͳϱ*/
        zOss_TaskSendData(EV_ZATI2_COPN_CNF, (VOID *)pCopnCnf, sizeof(T_zAti_CopnQry_Cnf), g_zAti_Context.taskIdMy);
        zAti_PutReadCardMutex();
        return;
    }
    zAti_PutReadCardMutex();
    pExeCnf = (T_zAti_Copn_Exe_Cnf*)zAti_GetUB(sizeof(T_zAti_Copn_Exe_Cnf));
    pExeCnf->bDesIndex = pCopnCnf->bDesIndex;
    pExeCnf->bSrcIndex = pCopnCnf->bSrcIndex;
    pExeCnf->bMem = Z_ATI_OPLPNN;
    pExeCnf->wTotalNum = (WORD)pCopnCnf->bOplPnnTotalNum;
    pExeCnf->wCurrNum = (WORD)pCopnCnf->bOplPnnCurrNum;
    if((pCopnCnf->bOplPnnTotalNum - pCopnCnf->bOplPnnCurrNum)/Z_ATI_IND_NUM != 0)
    {
        pExeCnf->bIndNum = Z_ATI_IND_NUM;
        pCopnCnf->bOplPnnCurrNum += Z_ATI_IND_NUM;
    }
    else
    {
        pExeCnf->bIndNum = pCopnCnf->bOplPnnTotalNum - pCopnCnf->bOplPnnCurrNum;
        pCopnCnf->bOplPnnCurrNum = pCopnCnf->bOplPnnTotalNum;
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_COPN_EXE_CNF, (BYTE*)pExeCnf, sizeof(T_zAti_Copn_Exe_Cnf));

    zOss_TaskSendData(EV_ZATI2_COPN_CNF, (VOID *)pCopnCnf, sizeof(T_zAti_CopnQry_Cnf), g_zAti_Context.taskIdMy);
    return;
}
VOID zAti_HandleNetCnf(T_zAti_CopnQry_Cnf *pCopnCnf)
{
    T_zAti_Copn_Exe_Cnf *pExeCnf = NULL;

    pExeCnf = (T_zAti_Copn_Exe_Cnf*)zAti_GetUB(sizeof(T_zAti_Copn_Exe_Cnf));
    pExeCnf->bDesIndex = pCopnCnf->bDesIndex;
    pExeCnf->bSrcIndex = pCopnCnf->bSrcIndex;
    pExeCnf->bMem = Z_ATI_NET;
    pExeCnf->wTotalNum = (WORD)pCopnCnf->bNetTotalNum;
    pExeCnf->wCurrNum = (WORD)pCopnCnf->bNetCurrNum;
    if((pCopnCnf->bNetTotalNum - pCopnCnf->bNetCurrNum)/Z_ATI_IND_NUM != 0)
    {
        pExeCnf->bIndNum = Z_ATI_IND_NUM;
        pCopnCnf->bNetCurrNum += Z_ATI_IND_NUM;
    }
    else
    {
        pExeCnf->bIndNum = pCopnCnf->bNetTotalNum - pCopnCnf->bNetCurrNum;
        pCopnCnf->bNetCurrNum = pCopnCnf->bNetTotalNum;
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_COPN_EXE_CNF, (BYTE*)pExeCnf, sizeof(T_zAti_Copn_Exe_Cnf));
    zOss_TaskSendData(EV_ZATI2_COPN_CNF, (VOID *)pCopnCnf, sizeof(T_zAti_CopnQry_Cnf), g_zAti_Context.taskIdMy);
    return;
}
VOID zAti_HandleMeCnf(T_zAti_CopnQry_Cnf *pCopnCnf)
{
    T_zAti_Copn_Exe_Cnf *pExeCnf = NULL;

    pExeCnf = (T_zAti_Copn_Exe_Cnf*)zAti_GetUB(sizeof(T_zAti_Copn_Exe_Cnf));
    pExeCnf->bDesIndex = pCopnCnf->bDesIndex;
    pExeCnf->bSrcIndex = pCopnCnf->bSrcIndex;
    pExeCnf->bMem = Z_ATI_ME;
    pExeCnf->wTotalNum = (WORD)pCopnCnf->bMeTotalNum;
    pExeCnf->wCurrNum = (WORD)pCopnCnf->bMeCurrNum;
    if((pCopnCnf->bMeTotalNum - pCopnCnf->bMeCurrNum)/Z_ATI_IND_NUM != 0)
    {
        pExeCnf->bIndNum = Z_ATI_IND_NUM;
        pCopnCnf->bMeCurrNum += Z_ATI_IND_NUM;
    }
    else
    {
        pExeCnf->bIndNum = pCopnCnf->bMeTotalNum - pCopnCnf->bMeCurrNum;
        pCopnCnf->bMeCurrNum = pCopnCnf->bMeTotalNum;
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_COPN_EXE_CNF, (BYTE*)pExeCnf, sizeof(T_zAti_Copn_Exe_Cnf));
    zOss_TaskSendData(EV_ZATI2_COPN_CNF, (VOID *)pCopnCnf, sizeof(T_zAti_CopnQry_Cnf), g_zAti_Context.taskIdMy);
    return;
}
VOID zAti_HandleGloBalCnf(T_zAti_CopnQry_Cnf *pCopnCnf)
{
    T_zAti_Copn_Exe_Cnf *pExeCnf = NULL;

    pExeCnf = (T_zAti_Copn_Exe_Cnf*)zAti_GetUB(sizeof(T_zAti_Copn_Exe_Cnf));
    pExeCnf->bDesIndex = pCopnCnf->bDesIndex;
    pExeCnf->bSrcIndex = pCopnCnf->bSrcIndex;
    pExeCnf->bMem = Z_ATI_GLOBAL;
    pExeCnf->wTotalNum = (WORD)pCopnCnf->wGloBalTotalNum;
    pExeCnf->wCurrNum = (WORD)pCopnCnf->wGloBalCurrNum;
    if((pCopnCnf->wGloBalTotalNum - pCopnCnf->wGloBalCurrNum)/Z_ATI_IND_NUM != 0)
    {
        pExeCnf->bIndNum = Z_ATI_IND_NUM;
        pCopnCnf->wGloBalCurrNum += Z_ATI_IND_NUM;
    }
    else
    {
        pExeCnf->bIndNum = (BYTE)(pCopnCnf->wGloBalTotalNum - pCopnCnf->wGloBalCurrNum);
        pCopnCnf->wGloBalCurrNum = pCopnCnf->wGloBalTotalNum;
    }
    zAti_RecvServerHandlerSlaver(AP_MMIA_COPN_EXE_CNF, (BYTE*)pExeCnf, sizeof(T_zAti_Copn_Exe_Cnf));
    zOss_TaskSendData(EV_ZATI2_COPN_CNF, (VOID *)pCopnCnf, sizeof(T_zAti_CopnQry_Cnf), g_zAti_Context.taskIdMy);
    return;
}
VOID zAti_CopnCnf(UINT8 *pDataPtr)
{
    T_zAti_CopnQry_Cnf *pCopnCnf = (T_zAti_CopnQry_Cnf*)pDataPtr;

    if(pCopnCnf->wMsgId == AP_MMIA_COPN_EXE_CNF)
    {
        if(pCopnCnf->bOplPnnTotalNum > pCopnCnf->bOplPnnCurrNum)
        {
            zAti_HandleOplPnnCnf(pCopnCnf);
        }
        else if(pCopnCnf->bNetTotalNum > pCopnCnf->bNetCurrNum)
        {
            zAti_HandleNetCnf(pCopnCnf);
        }
        else if(pCopnCnf->bMeTotalNum > pCopnCnf->bMeCurrNum)
        {
            zAti_HandleMeCnf(pCopnCnf);
        }
        else if(pCopnCnf->wGloBalTotalNum > pCopnCnf->wGloBalCurrNum)
        {
            zAti_HandleGloBalCnf(pCopnCnf);
        }
        else
        {
            pCopnCnf->wMsgId = AP_MMIA_COPN_END_CNF;
            zOss_TaskSendData(EV_ZATI2_COPN_CNF, (VOID *)pCopnCnf, sizeof(T_zAti_CopnQry_Cnf), g_zAti_Context.taskIdMy);
        }
    }
    else//AP_MMIA_COPN_END_CNF
    {
        T_zAti_Copn_End_Cnf *pEndCnf = (T_zAti_Copn_End_Cnf*)zAti_GetUB(sizeof(T_zAti_Copn_End_Cnf));
        pEndCnf->bDesIndex = pCopnCnf->bDesIndex;
        pEndCnf->bSrcIndex = pCopnCnf->bSrcIndex;
        zAti_RecvServerHandlerSlaver(AP_MMIA_COPN_END_CNF, (BYTE*)pEndCnf, sizeof(T_zAti_Copn_End_Cnf));
        zAti_RetUB((VOID**)&pCopnCnf);
        return;
    }
    return;
}
/**************************************************************************
* ƣ zAti_StmListInd
*   б
* ˵ (IN) 
*            pDataPtr       
*            (OUT)
*   ֵ 
* ˵ ȡֱѭ޷Ϣ
*                        ڴͷ
**************************************************************************/
VOID zAti_StmListInd(UINT8 *pDataPtr)
{
    T_ZAti_StmList_Ind *ptStmInd = (T_ZAti_StmList_Ind *)pDataPtr;
    T_ZOss_List *pList = ZOSS_NULL;
    T_ZAti_ListForStm *pListForStm = NULL;

    if (ptStmInd == NULL)
    {
        return;
    }
    
    g_zAti_CurInstance = ptStmInd->iStackId;
    pList = ptStmInd->pStmMsgList;
    if(pList != NULL)
    {
        pListForStm = (T_ZAti_ListForStm *)zOss_ListFirst(pList);
        if(pListForStm != NULL)
        {
            zAti_RecvServerHandlerSlaver(pListForStm->iEvId, pListForStm->pDataPtr, pListForStm->iDataLen);
            zOss_ListDelete(pList,(T_ZOss_Node *)pListForStm);
            zOss_Free(pListForStm);
            zOss_TaskSendData(EV_ZATI2_STMLIST_IND, ptStmInd, sizeof(T_ZAti_StmList_Ind), g_zAti_Context.taskIdMy);
        }
        else
        {
            zOss_Free(pList);
            zOss_RetUB(ptStmInd);
        }
    }
    return;
}

/**************************************************************************
* ƣ zAti_ProcTimerExpiry
*  ʱʱϢ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            (OUT)
*   ֵ ʱʱϢZ_SUCCZ_FAIL
* ˵ Ҫͷڴ
**************************************************************************/
BYTE __ps_static_func zAti_ProcTimerExpiry(UINT32 iEvId, UINT8 *pDataPtr)
{
    if( iEvId ==MMIA_EM_HO_INFO_EXPIRY_EV)
    {
        zAti_EM_HoInfoInd(pDataPtr);
    }
#ifdef Z_SELL_STAT_SUPPORT
    else if(iEvId == MMIA_SELL_STAT_REG_EXPIRY_EV)
    {
         zAti_DoRegTimerExpir(pDataPtr);
    }
    else if(iEvId ==MMIA_SELL_STAT_SUM_PDP_EXPIRY_EV)
    {
        zAti_DoSumPdpTimerExpir(pDataPtr);
    }
    else if(iEvId ==MMIA_SELL_STAT_ONE_PDP_EXPIRY_EV)
    {
        zAti_DoOnePdpTimerExpir(pDataPtr);
    }
#endif
#ifdef USE_VOICE_SUPPORT
    else if(iEvId == MMIA_AOC_EXPIRY_EV)
    {
         /* 617001545194    +CCCMϱ*/
        zAti_AocTimerExpir(pDataPtr);
    }
#endif
    else if(iEvId ==EV_ZATI2_ZMSRI_IND_EXPIRY_EV)
    {    /* 617001591411 ܻ- ܻV3汾ͬʵ*/
        zAti_NotifyApModemReady();
    }
    else if(iEvId == MMIA_ZGDT_EXPIRY_EV)
    {
        zAti_ZgdataTestSendPsData();
    }
    else if(iEvId == MMIA_SOFTRESET_EXPIRY_EV)
    {
        zAti_ResetTimerExpir();
    }
    else if(iEvId == MMIA_ZULRTIND_EXPIRY_EV)
    {
        zAti_ZulrtindTimerExpir();
    }
    else
    {
        return Z_FAIL;
    }

    return Z_SUCC;
}

/**************************************************************************
* ƣ zAti_TaskWork
*  ڹ״̬Ĵ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            pPrivateData   
*            (OUT)
*   ֵ 
* ˵ 
*            Ϣ
*            һϢһ
**************************************************************************/
VOID __ps_static_func zAti_TaskWork(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen, UINT8 *pPrivateData)
{
    BYTE bInstance = zAti_GetTaskInstantIndexByTaskId(iEvId, pDataPtr, zOss_Sender());
    if (bInstance != Z_ATI_INVALID_BYTE)
    {
        #if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
        g_zAti_CurInstance = bInstance;
        #else
        g_zAti_CurInstance = Z_ATI_INSNO_1;
        #endif
    }

    zAti_RecRcvMsg(iEvId);

#ifdef _USE_SIG_TRACE
    zAti_MsgSigTrace(iEvId, pDataPtr, iDataLen);
#endif

#ifdef _USE_GLOBAL_TRACE
    if (zAti_EnquireGlobalVar(iEvId) == Z_SUCC)  /* ΪEC617001426283*/
    {
        return;
    }
#endif

    //  ʱʱϢҪͷڴ
    if(zAti_ProcTimerExpiry(iEvId, pDataPtr) == Z_SUCC)
    {
        return;
    }

    switch(iEvId)
    {
    case EV_POWEROFF:
        zAti_StopTask();
        break;

    case EV_ZATI2_RECV_COMMAND_IND:     /* յAT2ܹAT  */
        zAti_RecvCommandInd(pDataPtr, iDataLen);
        break;
#ifndef CONFIG_SINGLECORE
        //... 4.19ʱڴ˴,Ż
    case EV_ZATI2_TEST_SEND_CS_DATA:    /* GCFҪCSDģ */
        zAti_ZgdataTestSendCsData();
        break;
#endif
    case EV_ZATI2_STMLIST_IND:
        zAti_StmListInd(pDataPtr);
        break;

     case EV_ZATI2_CPBR_CNF:
        zAti_CpbrCnf(pDataPtr);
        break;

     case EV_ZATI2_COPN_CNF:
        zAti_CopnCnf(pDataPtr);
        break;

    case EV_ZATI2_ZEMCELLINFO_REQ:
        zAti_EMCellInfoReq();
        break;

    default:
        zAti_RecvServerHandlerSlaver(iEvId, pDataPtr, iDataLen);
        break;
    }
    #ifdef Z_DUALCARD_ADAPT 
    /*˫˫*/
    if(Z_VALID == zAti_IsDualPsDualUicc())
    {
        zAti_HandleDualCardSelfAdapt();
    }
    #endif
    return;
}




 /*******************************************************
  *------------------------------------------
  ******************************************************/
 DWORD zAti_PreUiccSlotInd(VOID *pbMsgData, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    /*617001861374ܻȲ*/
    T_zApUicc_Card_Ind * pZuslotCnf = (T_zApUicc_Card_Ind *)pbMsgData;
    BYTE bakInitFlag = g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag;
    
    if (pZuslotCnf->bSlotState == Z_APUICC_EVULSION_CARD)
    {
        zAti_SetCardState(g_zAti_CurInstance, Z_CARD_INIT_ERR);
        //zAti_RetUbCardPlmnInfo();
        //zOss_Memset(&g_zAti_atDataEx[g_zAti_CurInstance].tStUpMenu, 0, sizeof(T_zAti_SetUpMemnu));
        zAti_CardOffInitGlobalVarByInstNo(g_zAti_CurInstance);
        zStm_CardLostInd((T_zStm_TaskIdx)g_zAti_CurInstance);
        
        if(Z_ATI_CARDINIT_ING == bakInitFlag)
        {
            zAti_CardInitFlgClr_SigCd(g_zAti_CurInstance, Z_ATI_CARDINIT_FINISH);
            zAti_HandleMsgBuff ();
        }
        zAti_HandleAutoStart();
    }
    else if (pZuslotCnf->bSlotState == Z_APUICC_INSERT_CARD)
    {
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
        BYTE bSrcIndex    = (g_zAti_CurInstance == 0 ? ZATI2_CHANNEL_ID_NUM251 : ZATI2_CHANNEL_ID_NUM252);
#else
        BYTE bSrcIndex    = ZATI2_CHANNEL_ID_NUM251;
#endif
        zAti_InitCard(bSrcIndex, Z_ATI_INVALID_BYTE);
        zAti_CardInitFlgClr_SigCd(g_zAti_CurInstance, Z_ATI_CARDINIT_ING);
    }
    // ޱ仯
    * pdwChangedMsgId = AP_UICC_SLOT_IND_EV;
    return Z_APMMIA_NORESULT;
}
//-----------------start-------------

VOID __ps_static_func zAti_AddOneCmd(T_ZAti_ChannelInfo *pChnelNode, BYTE * pbCmdStr)
{
    T_zAti_ATCmdNode * ptTempAtCmdNode = pChnelNode->tAtCmdList.ptAtCmdNode;

    if(ptTempAtCmdNode != NULL)
    {
        while(ptTempAtCmdNode->ptNext != NULL)
        {
            ptTempAtCmdNode = ptTempAtCmdNode->ptNext;
        }

        ptTempAtCmdNode->ptNext = (T_zAti_ATCmdNode *)zAti_GetUB(sizeof(T_zAti_ATCmdNode));
        ptTempAtCmdNode->ptNext->pbAtCmd = (BYTE *)zAti_GetUB(strlen((const char *)pbCmdStr)+1);
        zOss_Memcpy(ptTempAtCmdNode->ptNext->pbAtCmd, pbCmdStr, strlen((const char *)pbCmdStr)+1);
    }
    else
    {
        pChnelNode->tAtCmdList.ptAtCmdNode = (T_zAti_ATCmdNode *)zAti_GetUB(sizeof(T_zAti_ATCmdNode));
        pChnelNode->tAtCmdList.ptAtCmdNode->pbAtCmd = (BYTE *)zAti_GetUB(strlen((const char *)pbCmdStr)+1);
        zOss_Memcpy(pChnelNode->tAtCmdList.ptAtCmdNode->pbAtCmd, pbCmdStr, strlen((const char *)pbCmdStr)+1);
    }

    pChnelNode->tAtCmdList.bAtCmdNum += 1;
    return;
}

VOID __ps_static_func zAti_RemoveOneCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    T_zAti_ATCmdNode * ptTempAtCmdNode = pChnelNode->tAtCmdList.ptAtCmdNode;

    if(ptTempAtCmdNode != NULL)
    {
        pChnelNode->tAtCmdList.ptAtCmdNode = ptTempAtCmdNode->ptNext;

        zAti_RetUB((VOID **)&ptTempAtCmdNode->pbAtCmd);
        zAti_RetUB((VOID **)&ptTempAtCmdNode);
    }

    pChnelNode->cmd_id = ZAT2_NO_COMMAND; /* = -1; */
    pChnelNode->cmd_op = ZAT2_CO_INVALID; /* = -1; */
    pChnelNode->iEvId = ZATI2_INVAL_EVID;
    return;
}

VOID zAti_RemoveALLCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    while(pChnelNode->tAtCmdList.ptAtCmdNode != NULL)
    {
        zAti_RemoveOneCmd(pChnelNode);
    }
    pChnelNode->tAtCmdList.bAtCmdNum = 0;

    pChnelNode->cmd_id = ZAT2_NO_COMMAND;
    pChnelNode->cmd_op = ZAT2_CO_INVALID;
    return;
}


/**************************************************************************
* ƣ zAti_IsMultiCmd
*  жǷǶ
* ˵ (IN):
*             pChnelNode:       ͨڵָ           
*            (OUT):
*   ֵ TRUE FALSE
* ˵
**************************************************************************/
BOOL __ps_static_func zAti_IsMultiCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    return  (pChnelNode->tAtCmdList.bAtCmdNum > 1);
}

/**************************************************************************
* ƣ zAti_HasMoreCmd
*  жǷ
* ˵ (IN):
*             pChnelNode:       ͨڵָ           
*            (OUT):
*   ֵ TRUE FALSE
* ˵
**************************************************************************/
BOOL __ps_static_func zAti_HasMoreCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    return (pChnelNode->tAtCmdList.ptAtCmdNode != NULL);
}

/**************************************************************************
* ƣ zAti_IsLastCmd
*  жڴǷΪһ
* ˵ (IN):
*             pChnelNode:       ͨڵָ           
*            (OUT):
*   ֵ TRUE FALSE
* ˵
**************************************************************************/
BOOL __ps_static_func zAti_IsLastCmd(T_ZAti_ChannelInfo *pChnelNode)
{
     // pChnelNode->tAtCmdList.ptAtCmdNodeڴ˲ǿ
     return (pChnelNode->tAtCmdList.ptAtCmdNode->ptNext == NULL);
}

BOOL __ps_static_func zAti_IsIntermediateMsg(DWORD dwMsgId, VOID* pBuff)
{
    /*CPBR/SCPBRмϢ*/
    if(AP_MMIA_CPBR_EXE_CNF_EV == dwMsgId 
        ||AP_MMIA_PB_S_FIND_INDEX_CNF_EV == dwMsgId
        ||AP_MMIA_COPN_EXE_CNF == dwMsgId)
    {
        return TRUE;
    }

    if(pBuff == NULL)
    {
        return FALSE;
    }

    /*бмϢ*/
    switch(dwMsgId)
    {
        case AP_MMIA_SMS_PCMGL_CNF_EV:
        {
            T_zApMmia_SmsPcmgl_Cnf *pPcmglCnf = (T_zApMmia_SmsPcmgl_Cnf*)pBuff;
            if(pPcmglCnf->wTotalNum != 0 && pPcmglCnf->WCurNum != pPcmglCnf->wTotalNum)
            {
                return TRUE;
            }
            break;
        }
        case AP_MMIA_SMS_TDELI_LIST_CNF_EV:
        {
            T_zApMmia_SmsTdeliList_Cnf *pTcmglDeliCnf = (T_zApMmia_SmsTdeliList_Cnf*)pBuff;
            if(pTcmglDeliCnf->wTotalNum != 0&&pTcmglDeliCnf->wCurNum != pTcmglDeliCnf->wTotalNum)
            {
                return TRUE;
            }
            break;
        }
        case AP_MMIA_SMS_TSUB_LIST_CNF_EV:
        {
            T_zApMmia_SmsTsubList_Cnf *pTcmglSubCnf = (T_zApMmia_SmsTsubList_Cnf*)pBuff;
            if(pTcmglSubCnf->wTotalNum != 0&&pTcmglSubCnf->wCurNum != pTcmglSubCnf->wTotalNum)
            {
                return TRUE;
            }
            break;
        }
        case AP_MMIA_SMS_TSTAT_LIST_CNF_EV:
        {
            T_zApMmia_SmsTstatList_Cnf *pTcmglStatCnf = (T_zApMmia_SmsTstatList_Cnf*)pBuff;
            if(pTcmglStatCnf->wTotalNum != 0&&pTcmglStatCnf->wCurNum != pTcmglStatCnf->wTotalNum)
            {
                return TRUE;
            }
            break;
        }
        case AP_MMIA_SMS_TCOM_LIST_CNF_EV:
        {
            T_zApMmia_SmsTcomList_Cnf *pTcmglComCnf = (T_zApMmia_SmsTcomList_Cnf*)pBuff;
            if(pTcmglComCnf->wTotalNum != 0&&pTcmglComCnf->wCurNum != pTcmglComCnf->wTotalNum)
            {
                return TRUE;
            }
            break;
        }
        case AP_MMIA_CBS_TCBM_LIST_CNF_EV:
        {
            T_zApMmia_Cbs_TcbmList_Cnf *pTcmglCbmCnf = (T_zApMmia_Cbs_TcbmList_Cnf*)pBuff;
            if(pTcmglCbmCnf->bTotalPage != 0&& pTcmglCbmCnf->bCurPage != pTcmglCbmCnf->bTotalPage)
            {
                return TRUE;
            }
            break;
        }
        case AP_MMIA_CBS_PCBM_LIST_CNF_EV:
        {
            T_zApMmia_Cbs_PcbmList_Cnf *pPcbmcmglCnf = (T_zApMmia_Cbs_PcbmList_Cnf*)pBuff;
            if(pPcbmcmglCnf->bListEndFg != 1)
            {
                return TRUE;
            }
            break;
        }
        default:
            break;
    }
    return FALSE;
}

/**************************************************************************
* ƣ zAti_GetFirstCmd
*  ȡһַ
* ˵ (IN):
*             pChnelNode:       ͨڵָ           
*            (OUT):
*   ֵ ַ׵ַ
* ˵
**************************************************************************/
BYTE * __ps_static_func zAti_GetFirstCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    return pChnelNode->tAtCmdList.ptAtCmdNode->pbAtCmd;
}

/**************************************************************************
* ƣ zAti_SendEncData
*  ϱ
* ˵ (IN):
*             pChnelNode:       ͨڵָ 
*             pStrCmd:           ַ
*            (OUT):
*   ֵ 
* ˵
**************************************************************************/
VOID __ps_static_func zAti_SendEncData(T_ZAti_ChannelInfo *pChnelNode, BYTE* pStrCmd, DWORD dwMsgId, VOID* pBuff)
{
    CHAR   ZATI2_ENC_ERR_STR[] = {"ERROR"};
    WORD  wStrLen = (WORD)strlen((const char *)pStrCmd);

    /*   OK , ȥûOK 
     *   OK, ȥ󲹷OK
     */      
    if(strstr((const char *)pStrCmd,(char *)g_zAt_OK) != NULL) 
    {
        if (zAti_IsMultiCmd(pChnelNode))
        {
            wStrLen  -= (WORD)strlen((const char *)g_zAt_OK);
        }
    }
    else if(strstr((const char *)pStrCmd,(char *)ZATI2_ENC_ERR_STR) != NULL)
    {
        zAti_RemoveALLCmd(pChnelNode);
        zAti_SendFnc(pChnelNode->iChnelId, pStrCmd, wStrLen, ZATI2_CHIND_AT);
        zAti_SendRspCmdStr2Trace(pChnelNode->iChnelId, wStrLen, (CHAR *)pStrCmd);
        return;
    }

    if (wStrLen > 0)
    {
        zAti_SendFnc(pChnelNode->iChnelId, pStrCmd, wStrLen, ZATI2_CHIND_AT);
        zAti_SendRspCmdStr2Trace(pChnelNode->iChnelId, wStrLen, (CHAR *)pStrCmd);
    }

    /* һOK*/
    if(zAti_IsMultiCmd(pChnelNode))
    {
        if(zAti_IsLastCmd(pChnelNode))
        {
            if(!zAti_IsIntermediateMsg(dwMsgId, pBuff))
            {
                zAti_SendFnc(pChnelNode->iChnelId, (BYTE *)g_zAt_OK, (WORD)strlen((const char *)g_zAt_OK), ZATI2_CHIND_AT);
                zAti_SendRspCmdStr2Trace(pChnelNode->iChnelId, (WORD)strlen((const char *)g_zAt_OK), (CHAR *)g_zAt_OK);
            }
            pChnelNode->tAtCmdList.bAtCmdNum = 0;
        }
    }
    else
    {
        pChnelNode->tAtCmdList.bAtCmdNum = 0;
    }
    return;
}

/**************************************************************************
* ƣ zAti_ReplyOK
*  ϱ
* ˵ (IN):
*             pChnelNode:       ͨڵָ 
*            (OUT):
*   ֵ 
* ˵
**************************************************************************/
VOID __ps_static_func zAti_ReplyOK(T_ZAti_ChannelInfo *pChnelNode)
{
    zAti_SendEncData(pChnelNode, (BYTE *)g_zAt_OK, ZATI_INVALID_MSGID, NULL);
    return;
}


/**************************************************************************
*  : zAti_GetErrorReply
*  : ȡʧϢ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
void zAti_GetErrorReplyStr(CHAR * pbErrorStr, T_ZAt2_DecRsltType  bDecRsltType)
{
    DWORD dwErrorCode[] = {
        (DWORD)ZAT2_CMD_INVALID_RSLT, //ZAT2_CMD_PARSE_OK,          /* ɹ */
        (DWORD)ZAT2_CMD_INVALID_RSLT, //ZAT2_CMD_REPLY_DIRECT,      /* ɹֱӻظ */
        (DWORD)ZAT2_CMD_INVALID_RSLT, // ZAT2_CMD_NOT_END_REPLY,     /* δֱӻظʾ */
        (DWORD)ZAT2_CMD_INVALID_RSLT, // ZAT2_CMD_NOT_END,           /* δ */
        ZAT2_CMEE_CMDUNREC,   //  ZAT2_CMD_UNREC,             /* ޷ʶ */
        ZAT2_CMEE_SYNTAX_ERR,  //  ZAT2_CMD_SYNTAX_ERR,        /* ﷨ */
        ZAT2_CMEE_SYNTAX_ERR,  // ZAT2_CMD_PARAM_ERR,         /*  */
        (DWORD)ZAT2_CMD_INVALID_RSLT, // ZAT2_CMD_CANCELED,          /* ȡ */
        (DWORD)ZAT2_CMEE_CMDCONFLICT, // ZAT2_CMD_CONFLICT,          /* ͨͻ */
        (DWORD)ZAT2_CMD_INVALID_RSLT, // ZAT2_INPUT_ILLEGAL,         /* ηǷ */
        (DWORD)ZAT2_CMD_INVALID_RSLT, // ZAT2_MEMORY_ERR,             /* ڴ */
        Z_APMMIA_NVFAILURE_ERR, // ZAT2_NVFAILURE_ERR ,
        Z_APMMIA_OPTNOTALW_ERR, // ZAT2_OPTNOTALW_ERR,
        Z_APMMIA_CMSNOCNMAACK_ERR, // ZAT2_CMSNOCNMAACK_ERR,
        Z_APMMIA_CMSMEMFAIL_ERR, // ZAT2_CMSINVALIDTEXTPARA_ERR, // = ERR_MMIA_CMSINVALIDTEXTPARA
        ZAT2_CMEE_VALUE_ERR, // ZAT2_CMD_VALUE_ERR
        ZAT2_CMEE_DUALCARDADPT_ERR,
        ZAT2_CMEE_CMDOVERFLOW, // ZAT2_CMD_OVERFLOW
        ZAT2_CMEE_DUALCARDCID_ERR, //ZAT2_CMD_DUALCARDERR
    };

    if(bDecRsltType == ZAT2_NVFAILURE_ERR && g_zAti_ptData->bEModeType == 0)
    {
        dwErrorCode[bDecRsltType] = Z_APMMIA_OPTNOTALW_ERR;
    }

    if(bDecRsltType == ZAT2_CMSNOCNMAACK_ERR || bDecRsltType == ZAT2_CMSINVALIDTEXTPARA_ERR)
    {
        zAt_EncErrorCode(pbErrorStr, ZAT2_SMS_CNMA, dwErrorCode[bDecRsltType]);
    }

    if(bDecRsltType <= ZAT2_CMEE_DUALCARDCID_ERR && dwErrorCode[bDecRsltType] != (DWORD)ZAT2_CMD_INVALID_RSLT)
    {
        zAt_EncErrorCode(pbErrorStr, ZAT2_CFG_CMEE, dwErrorCode[bDecRsltType]);
    }
    return;
}

/**************************************************************************
*  : zAti_CmdDirectReply
*  : ֱӻظȷҲܴ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
void __ps_static_func zAti_CmdDirectReply(T_ZAti_ChannelInfo *pChnelNode, T_ZAt2_DecRsltType  bDecRsltType)
{
    CHAR ZAT2_ENC_SMS_INPUT_IND_STR[20] = {"\r\n> "};

    if(bDecRsltType == ZAT2_CMD_NOT_END_REPLY) 
    {
        pChnelNode->cmdInputInfo.cmdInputStat = ZAT2_SMS_EDIT;
        zOss_Memcpy(g_zAt_EncBuf, ZAT2_ENC_SMS_INPUT_IND_STR, strlen((const char *)ZAT2_ENC_SMS_INPUT_IND_STR));
    }
    else if(bDecRsltType == ZAT2_CMD_REPLY_DIRECT)
    {
        // ѾϢg_zAt_EncBuf Уdo nothing
    }
    else
    {
        zAti_GetErrorReplyStr(g_zAt_EncBuf, bDecRsltType);
    }

    /* 1, ͨͻError , ֱӻظ
       2, ûпʼҪ
     */
    if(bDecRsltType == ZAT2_CMD_CONFLICT || bDecRsltType == ZAT2_CMD_OVERFLOW)
    {
        zAti_SendFnc(pChnelNode->iChnelId, (BYTE *)g_zAt_EncBuf, (WORD)strlen((const char *)g_zAt_EncBuf), ZATI2_CHIND_AT);
        zAti_SendRspCmdStr2Trace(pChnelNode->iChnelId, (WORD)strlen((const char *)g_zAt_EncBuf), (CHAR *)g_zAt_EncBuf);
    }
    else
    {
        zAti_SendEncData(pChnelNode, (BYTE *)g_zAt_EncBuf, ZATI_INVALID_MSGID, NULL);
    }
    return;
}


/**************************************************************************
*  : zAti_ProcError
*  : Ϣʧ
* ˵ (IN) 
*            pChnelNode      ͨڵ
*            dwError       
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
void zAti_ProcError(T_ZAti_ChannelInfo *pChnelNode, DWORD dwErrorCause)
{
    if (dwErrorCause == Z_APMMIA_NVFAILURE_ERR && g_zAti_ptData->bEModeType == 0)
    {     
        dwErrorCause  = Z_APMMIA_OPTNOTALW_ERR;  // 3
    }
    
    if(pChnelNode != NULL)
    {
        zAt_EncErrorCode(g_zAt_EncBuf, pChnelNode->cmd_id, dwErrorCause);
        zAti_SendEncData(pChnelNode, (BYTE *)g_zAt_EncBuf, ZATI_INVALID_MSGID, NULL);
    }
    return;
}

/**************************************************************************
*  : zAti_GetDistributeMsgIdx
*  : ȡַϢ±
* ˵ (IN) 
*            dwMsgId      Ϣ
*            (OUT)
*             pMsgIdx   : ַϢе±
*   ֵ ҵZ_SUCC,  ûҵZ_FAIL
* ˵ 
**************************************************************************/
BYTE __ps_static_func zAti_GetDistributeMsgIdx(DWORD dwMsgId, WORD *pMsgIdx)
{
    WORD wTabIdx = 0;
    for (wTabIdx = 0; wTabIdx < (sizeof(g_atDistributeMsgMap) / sizeof(g_atDistributeMsgMap[0])); wTabIdx++)
    {
        if(g_atDistributeMsgMap[wTabIdx].dwMsgId == dwMsgId)
        {
            *pMsgIdx = wTabIdx;
            return Z_SUCC;
        }
    }
    return Z_FAIL;
}

/**************************************************************************
*  : zAti_ProcDistributeMsg
*  : ַϢ
* ˵ (IN) 
*            wDistributeMsgIdx:      Ϣ±
*            pbMsgBody           :     Ϣ
 *           wMsgLen              :     Ϣ
*            pChnelNode          :     ͨڵָ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
DWORD __ps_static_func zAti_ProcDistributeMsg(WORD wDistributeMsgIdx, BYTE *pbMsgBody, WORD wMsgLen, T_ZAti_ChannelInfo *pChnelNode)
{ 
    return g_atDistributeMsgMap[wDistributeMsgIdx].pHandleMsg((VOID *)pbMsgBody);  
}


/**************************************************************************
*  : zAti_ProcError
*  : ȡתϢ±
* ˵ (IN) 
*            dwMsgId      Ϣ
*            (OUT)
*             pMsgIdx   : ַϢе±
*   ֵ ҵZ_SUCC,  ûҵZ_FAIL
* ˵ 
**************************************************************************/
BYTE __ps_static_func zAti_GetTransmitMsgTaskId(DWORD dwMsgId, BYTE *pbTaskId)
{
    if(zAti_GetDestTaskByMsgID(dwMsgId, pbTaskId))
        return Z_SUCC;
    else
        return Z_FAIL;
}

/**************************************************************************
*  : zAti_RrocTransmitMsg
*  : ַϢ
* ˵ (IN) 
*            wDistributeMsgIdx:      Ϣ±
*            pbMsgBody           :     Ϣ
 *           wMsgLen              :     Ϣ
*            pChnelNode          :     ͨڵָ
*            (OUT)
*   ֵ  
* ˵ 
**************************************************************************/
DWORD __ps_static_func zAti_RrocTransmitMsg(DWORD dwMsgId, BYTE *pbMsgBody, WORD wMsgLen, T_ZAti_ChannelInfo *pChnelNode,  BYTE bTaskId)
{
#ifdef USE_VOICE_SUPPORT
    if(dwMsgId == MMIA_CC_DIS_MODE_REQ_EV) /* ˴¼ӦCOMMON_CNFϢ */
    {
        pChnelNode->iEvId = dwMsgId;
        if(ZAT2_CC_CHUP == pChnelNode->cmd_id)
        {
            *(pbMsgBody + 1) = 0xff;
        }
    }
#endif
    zAti_MarkIndex(pbMsgBody, zAti_ConvertTskIdToSbMdl(bTaskId));
    if (bTaskId == Z_ATI_TASKID_ATI)
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    /*#ifndef USE_VOICE_SUPPORT
    else if(bTaskId == Z_ATI_TASKID_CC||bTaskId == Z_ATI_TASKID_SS)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    #endif*/
    else if( Z_SUCC != zAti_MsgForward(dwMsgId, (UINT8 *)pbMsgBody, wMsgLen,bTaskId))
    {
        // תϢʧܺͷڴ棬ͳһͷ
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    else 
    {
         return Z_APMMIA_NORESULT;
    }
}

// ----------------------ָ ------------

DWORD zAti_ProcCpbr(VOID *pbMsgData)
{
    zAti_CpbrHandle((T_zApMmia_CpbrSet_Req*)pbMsgData,0,ZSTM_STORAGE_ID_PBMAX,NULL);
    return Z_APMMIA_NORESULT;
}
DWORD zAti_ProcSmsCmglReq(VOID *pbMsgData)
{
    zStm_MmiaSms_CmglReq_Proc((BYTE *)pbMsgData, (WORD)sizeof(T_zApMmia_ListSm_Req), (T_zStm_TaskIdx)g_zAti_CurInstance);
    return Z_APMMIA_NORESULT;
}
DWORD zAti_ProcPbAddUserEn(VOID *pbMsgData)
{
    zStm_MmiaPb_AddUserEn_Proc((BYTE *)pbMsgData, (WORD)sizeof(T_ZAti_EmerNum_Req), (T_zStm_TaskIdx)g_zAti_CurInstance);
    return Z_APMMIA_NORESULT;
}
DWORD zAti_ProcSmsCmgdTest(VOID *pbMsgData)
{
    zStm_AtiSms_CmgdTest_Proc((BYTE *)pbMsgData, (WORD)sizeof(T_zApMmia_ListSm_Req), (T_zStm_TaskIdx)g_zAti_CurInstance);
    return Z_APMMIA_NORESULT;
}

DWORD zAti_ProcDtmfReq(VOID*pbMsgBody)
{
#ifdef USE_VOICE_SUPPORT
    T_ZAti_Dtmf_Req            *ptVtsReq = (T_ZAti_Dtmf_Req*)pbMsgBody; //pbMsgBody 
    T_zDev_AtMem_Mmia_PrivateMem tAtData = {0};
    g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bCurnum = 0;
    g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bTotalNum = ptVtsReq->bDtmfLen;
    zOss_Memcpy(g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bDtmf, ptVtsReq->bDtmf, ptVtsReq->bDtmfLen);
 
    if(ptVtsReq->bDurationFg == Z_APMMIA_INVALID)
    {
        zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
        g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.dwDuration = tAtData.dwDuration;
    }
    else
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.dwDuration = ptVtsReq->dwDuration;
    }

    return zAti_HandleVtsForCmcc(ptVtsReq->bSrcIndex, ptVtsReq->iDestIndex);
#else
    return Z_APMMIA_OPTNOTALW_ERR;
#endif
}
//-----------------------------ָ---------------

/**************************************************************************
* ƣ zAti_ProcCmdEnd
*  ǷǷ
* ˵ (IN) 
*            recvCmdInd       յATĽṹ
*            chnelNode        ͨ
*            (OUT)
*   ֵ : ɹ/ʧ
* ˵ ̽
**************************************************************************/
BYTE __ps_static_func zAti_ProcCmdEnd(T_ZAti_Buffer  *ptBuff)
{
    UINT16 i = 0;
    UINT16 bValidNum = 0;

    BYTE *pbStrATCmd = (BYTE *)zAti_GetUB(ZAT_LONG_CMD_LEN);

    while (ptBuff->arrData[i] == g_zAti_ptData->bCurS3Value || ptBuff->arrData[i] == g_zAti_ptData->bCurS4Value)
    {
        i++;
    }
    while(i < ptBuff->iLength)
    {
        if(ptBuff->arrData[i] == g_zAti_ptData->bCurS5Value)
        {
            if(bValidNum > 0)
                pbStrATCmd[--bValidNum] = ZAT2_NULL_CHAR;
        }
        else  if((ptBuff->arrData[i] == g_zAti_ptData->bCurS3Value) || (ptBuff->arrData[i] == g_zAti_ptData->bCurS4Value))
        {
            ptBuff->iLength = bValidNum;
            zOss_Memcpy(ptBuff->arrData, pbStrATCmd, bValidNum);/* յarrData浽 */
            ptBuff->arrData[bValidNum] = ZAT2_NULL_CHAR;
            zAti_RetUB((VOID**)&pbStrATCmd);
            return Z_SUCC;
        }
        else if (ptBuff->arrData[i] != g_zAti_ptData->bCurS4Value)
        {
            pbStrATCmd[bValidNum++] = ptBuff->arrData[i];
        }

        i++;
    }
    
    zAti_RetUB((VOID**)&pbStrATCmd);
    return Z_FAIL;
}

/**************************************************************************
* ƣ zAti_ProcSmsDataEnd
*  ϢǷǷǷ
* ˵ (IN) 
*            recvCmdInd       յATĽṹ
*            chnelNode        ͨ
*            (OUT)
*   ֵ : ɹ/ʧ
* ˵ ̽
**************************************************************************/
BYTE zAti_ProcSmsDataEnd(T_ZAti_Buffer  *ptBuff)
{
    UINT16 i = 0;
    UINT16 bValidNum = 0;
    
    BYTE *pbSMSData = (BYTE *)zAti_GetUB(ZAT_LONG_CMD_LEN);
    
    while(i < ptBuff->iLength)
    {
        if(ptBuff->arrData[i] == g_zAti_ptData->bCurS5Value)
        {
            if(bValidNum > 0)
                pbSMSData[--bValidNum] = ZAT2_NULL_CHAR;
        }
        else  if(ptBuff->arrData[i] == ZAT2_ESC_CHAR || ptBuff->arrData[i] == ZAT2_CTRL_Z_CHAR) 
        {
            if ((ptBuff->arrData[i] == ZAT2_ESC_CHAR) && (g_zAti_ptData->ptCmdInputInfo != NULL))
            {
                g_zAti_ptData->ptCmdInputInfo->bSmsEsc = Z_VALID;
            }
            
            ptBuff->iLength = bValidNum;
            zOss_Memcpy(ptBuff->arrData, pbSMSData, bValidNum);   /* յarrData浽 */
            ptBuff->arrData[bValidNum] = ZAT2_NULL_CHAR;
            zAti_RetUB((VOID**)&pbSMSData);
            return Z_SUCC;
        }
        else if (ptBuff->arrData[i] == g_zAti_ptData->bCurS3Value || ptBuff->arrData[i] == ZAT2_NULL_CHAR)
        {
            // do Nothing ,  s3
        }
        else 
        {
            pbSMSData[bValidNum++] = ptBuff->arrData[i];
        }
        i++;
    }
    zAti_RetUB((VOID**)&pbSMSData);
    return Z_FAIL;
}


VOID __ps_static_func zAti_PutDataToChnel(const T_ZAti_ChannelDataBuf *recvCmdInd, T_ZAti_ChannelInfo *pChnelNode)
{
    //zAti_SendRecvCmdStr2Trace(recvCmdInd->iChannel, recvCmdInd->iDataLen, (CHAR *)recvCmdInd->strData);
    
    if (recvCmdInd->iDataLen + pChnelNode->atBuff.iLength >= ZATI2_BUFFER_LENGTH)
    {
        /* 泤ջ */
        zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);
        pChnelNode->atBuff.iLength = 0;
        pChnelNode->checkAtOutLimit = TRUE;
    }

    /* STEP002-ӵӦͨĻ */    
    zOss_Memcpy(pChnelNode->atBuff.arrData + pChnelNode->atBuff.iLength, (char *)recvCmdInd->strData, recvCmdInd->iDataLen);/* յarrData浽 */
    pChnelNode->atBuff.iLength = pChnelNode->atBuff.iLength + recvCmdInd->iDataLen; /* ȼ */
    //pChnelNode->atBuff.arrData[pChnelNode->atBuff.iLength] = 0;        /*atBuff.iLength1024ʱԽ磬˴ټ\0,汣ʱ*/
    return;
}

/**************************************************************************
* ƣ zAti_ProcAtBufLimit
*  AT  
* ˵ (IN) 
*            recvCmdInd       յATĽṹ
*   ֵ : ɹ/ʧ
* ˵ ̽
**************************************************************************/
BYTE __ps_static_func zAti_ProcAtBufLimit(T_ZAti_ChannelInfo *pChnelNode)
{
    if(pChnelNode->checkAtOutLimit)
    {
        /* Ϣȡֱӷش */
        zAti_CmdDirectReply(pChnelNode, ZAT2_CMD_OVERFLOW);

         zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);
         pChnelNode->atBuff.iLength = 0;
         pChnelNode->checkAtOutLimit = FALSE;

         return Z_FAIL;
    }

    return Z_SUCC;
}


/**************************************************************************
* ƣ zAti_StoreAtCmd
*  յAT浽ATIĻ
* ˵ (IN) 
*            recvCmdInd       յATĽṹ
*            chnelNode        ͨ
*            (OUT)
*   ֵ : ɹ/ʧ
* ˵ ̽
**************************************************************************/
BYTE __ps_static_func zAti_StoreAtCmd(const T_ZAti_ChannelDataBuf *recvCmdInd, T_ZAti_ChannelInfo *pChnelNode)
{
    BYTE * pATDTStr = NULL;
    zAti_PutDataToChnel(recvCmdInd, pChnelNode);

    if(zAti_ProcCmdEnd(&pChnelNode->atBuff) == Z_FAIL)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,""); //λãûн
        return Z_FAIL;
    }

    if(zAti_ProcAtBufLimit(pChnelNode) == Z_FAIL)
    {
        return Z_FAIL;
    }

    // ATDT
    pATDTStr = (BYTE *)strstr((char *)pChnelNode->atBuff.arrData, "ATDT*");
    if(pATDTStr != NULL)
    {
        pATDTStr += 3; // *ֽڵλ
        while(*pATDTStr++ != '\0')
            *(pATDTStr -1)= *pATDTStr;
        pChnelNode->atBuff.iLength -= 1;
    }

    return Z_SUCC;
}

/**************************************************************************
* ƣ zAti_StoreSmsData
*  յĶϢݱ浽ATIĻ
* ˵ (IN) 
*            recvCmdInd       յATĽṹ
*            chnelNode        ͨ
*            (OUT)
*   ֵ : ɹ/ʧ
* ˵ ̽
**************************************************************************/
BYTE zAti_StoreSmsData(const T_ZAti_ChannelDataBuf *recvCmdInd, T_ZAti_ChannelInfo *pChnelNode)
{
    zAti_PutDataToChnel(recvCmdInd, pChnelNode);
    if(zAti_ProcSmsDataEnd(&pChnelNode->atBuff) == Z_FAIL)
    {
        return Z_FAIL;
    }
    return zAti_ProcAtBufLimit(pChnelNode);
}

VOID __ps_static_func zAti_Init_CmdInfo(T_ZAt2_CmdInputInfo * pCmdInputInfo)
{
    pCmdInputInfo->cmdInputStat = ZAT2_ATCMD;
    pCmdInputInfo->iSmsCrCnt = 0;
    pCmdInputInfo->smsInputType = ZAT2_NO_SMS_INPUT;
    pCmdInputInfo->pSmsInputMsg = NULL;
    pCmdInputInfo->bSmsEsc = Z_INVALID;
    return;
}
/**************************************************************************
*  : zAti_GetCmdLen
*  : ȡȺͷֺλ
* ˵ (IN) 
*            pbSrcStr       
*            pwSrcStrLen       ݳ 
*            ppCmdEnd   ֺλ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_GetCmdLen(BYTE *pbSrcStr, WORD *pwSrcStrLen, BYTE **ppCmdEnd)
{
    BYTE *pStrStart    = pbSrcStr;
    BYTE *pStrEnd      = NULL;
    BYTE *pStrPos      = NULL;
    WORD wCharNum      = 0;
    BYTE bCount        = 0;
    pStrEnd = (BYTE *)strstr((char *)pbSrcStr, ";");
    *ppCmdEnd = pStrEnd;

    while (pStrEnd != NULL)
    {
        bCount = 0;
        pStrPos = (BYTE *)strstr((char *)pStrStart, "\"");
        if ((pStrPos == NULL) ||(pStrPos > pStrEnd))
        {
            *pwSrcStrLen = (WORD)(pStrEnd - pbSrcStr);
            return ;
        }
        for (wCharNum=0; wCharNum < pStrEnd - pStrPos; wCharNum++)
        {
            if (pStrPos[wCharNum] == '\"')
            {
                bCount++;
            }
        }
        if ((bCount % 2) != 0)
        {
            pStrStart = pStrEnd;
            pStrPos = (BYTE *)strstr((char *)pStrStart, "\"");
            if (pStrPos == NULL)
            {
                *pwSrcStrLen = (WORD)(pStrEnd - pbSrcStr);
                return ;
            }
            pStrStart = pStrPos + 1;
            pStrEnd = (BYTE *)strstr((char *)pStrStart, ";");
            *ppCmdEnd = pStrEnd;
        }
        else
        {
            *pwSrcStrLen = (WORD)(pStrEnd - pbSrcStr);
            return ;
        }

    }
    
    return;
}

/**************************************************************************
*  : zAti_GetCmdStr
*  : ; Զзָ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ Z_SUCC 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_GetCmdStr(BYTE * pbOneCmdStr, T_ZAti_Buffer  *ptBuff, WORD * pwOffset)
{
    BYTE * pCmdStart     = ptBuff->arrData+(*pwOffset);
    BYTE * pCmdEnd       = NULL;
    WORD  wCmdLen       = 0;

    wCmdLen = ptBuff->iLength - (*pwOffset);
    zAti_GetCmdLen(pCmdStart, &wCmdLen, &pCmdEnd);

    if(pCmdEnd == NULL)
    {
        /* һ*/
        wCmdLen = ptBuff->iLength - (*pwOffset);
        zOss_Memcpy(pbOneCmdStr, pCmdStart, wCmdLen);
    }
    else 
    {
        /* һַ";" ʱ, ,"AT"  */
        if(wCmdLen > 0)
        {
            zOss_Memcpy(pbOneCmdStr, pCmdStart, wCmdLen);
            pbOneCmdStr[ZAT_LONG_CMD_LEN - 3] = '\0';
        }

        // ATD or AT+ZREDIAL Ըһ;      for VoLTE
        if(pCmdEnd[1] == ';' || pCmdEnd[1] == '\0')
        {
            if(pbOneCmdStr[0] == 'D' || strstr((char *)pbOneCmdStr, "ZREDIAL")) // ....жϣ
            {
                pbOneCmdStr[wCmdLen++] = ';';
            }
        }
    }
    
    *(pbOneCmdStr + wCmdLen) = '\0';
    *pwOffset += wCmdLen+1;
    return;
}
VOID __ps_static_func zAti_SkipLastComma(BYTE *pbAtCmd)
{
    WORD wCmdStrLen = (WORD)strlen((const char *)pbAtCmd);
    WORD wLen = wCmdStrLen;

    for (wLen = wCmdStrLen; wLen > 0; wLen--)
    {
        if (*(pbAtCmd + wLen) == '\0' && (*(pbAtCmd + wLen - 1) == ','))
        {
            *(pbAtCmd + wLen - 1) = '\0';
        }
        else
        {
            break;
        }
    }
    return;
}
/**************************************************************************
*  : zAti_DepartAtCmd
*  : 
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
BYTE __ps_static_func zAti_DepartAtCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    BYTE *pbAtCmd = (BYTE *)zAti_GetUB(ZAT_LONG_CMD_LEN);
    WORD wOffset           = 0;       // pChnelNode->atBuff.arrData ͷƫַĿʼλ
    strcpy((char*)pbAtCmd, "AT");/*ÿǰ"AT" ǰ׺*/
    
    // ·Ӧ"AT"ͷ򱨴
    if(ZAT2_UPCASE(pChnelNode->atBuff.arrData[0]) == 'A' && ZAT2_UPCASE(pChnelNode->atBuff.arrData[1]) == 'T')
    {
        wOffset += 2;
        if(pChnelNode->atBuff.iLength == 2) // "AT" 
        {
            zAti_AddOneCmd(pChnelNode, pbAtCmd); 
            pChnelNode->atBuff.iLength = 0;
            zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);
            zAti_RetUB((VOID**)&pbAtCmd);
            return Z_SUCC;
        }

        while(wOffset < pChnelNode->atBuff.iLength)
        {
            zAti_GetCmdStr(pbAtCmd+2, &(pChnelNode->atBuff), &wOffset);
            zAti_SkipLastComma(pbAtCmd);
            zAti_AddOneCmd(pChnelNode, pbAtCmd);
        }

        pChnelNode->atBuff.iLength = 0;
        zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);
        zAti_RetUB((VOID**)&pbAtCmd);
        return Z_SUCC;
    }
    else
    {
        zAti_CmdDirectReply(pChnelNode, ZAT2_CMD_SYNTAX_ERR);
        
        pChnelNode->atBuff.iLength = 0;
        zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);
        zAti_RetUB((VOID**)&pbAtCmd);
        return Z_FAIL;
    }
}
/**************************************************************************
*  : zAt_IsAbortCmdMsg
*  : жǷǿжϢ
* ˵ (IN) 
*            CmdId :       
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
BYTE zAti_IsAbortCmdMsg(T_ZAti_ChannelInfo *pChnelNode)
{
    T_ZAt2_CmdIdType CmdId = pChnelNode->cmd_id;
    if ((ZAT2_MM_COPS == CmdId) || (ZAT2_CC_D == CmdId) || (ZAT2_CC_A == CmdId) || (ZAT2_SM_D == CmdId) 
        || (ZAT2_SM_A == CmdId) || (ZAT2_SM_CGACT == CmdId) || (ZAT2_SM_CGDATA == CmdId) 
        || (ZAT2_SM_CGANS == CmdId) || (ZAT2_SMS_CMGS == CmdId) || (ZAT2_SMS_CMGC == CmdId) 
        || (ZAT2_SMS_CMSS == CmdId) || (ZAT2_SS_CCWA == CmdId||ZAT2_SMS_ZMGS == CmdId)
        || (ZAT2_LTE_ZGACT== CmdId) || (ZAT2_MM_BGLTEPLMN == CmdId||ZAT2_SMS_SMRS==CmdId)
        || (ZAT2_SS_CLCK == CmdId && pChnelNode->iEvId == ATI_DISTRIBUTE_FUNC_CLCK_SET_REQ_EV)
        || (ZAT2_MM_ZPLMNBAND== CmdId) || (ZAT2_MM_ZNCELLINFO== CmdId) || (ZAT2_MM_ZCOPS== CmdId)
        || (ZAT2_MM_ZSCAN == CmdId) || (ZAT2_MM_ZSCISCAN == CmdId) || (ZAT2_MM_ZNECQ == CmdId))
    {
        pChnelNode->iEvId = ZATI2_INVAL_EVID; /* ԭ */
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

/**************************************************************************
*  : zAti_AtCmdAbortReq
*  : жϢٽзַ
* ˵ (IN) 
*            CmdId :       
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_AtCmdAbortReq(T_ZAti_ChannelInfo *pChnelNode)
{
    BYTE bDesMdl = 0xFF;
    DWORD bAbortMsgInfo [][2] = {
        {MMIA_CC_ABORT_REQ_EV,         Z_ATI_TASKID_CC},     //Z_PSMDL_CC 1
        {MMIA_SMS_ABORT_MO_REQ_EV,     Z_ATI_TASKID_SMS},   // Z_PSMDL_SMS 2
        {MMIA_SS_ABORT_REQ_EV,         Z_ATI_TASKID_SS},     // Z_PSMDL_SS 3
        {MMIA_SM_ABORT_REQ_EV,         Z_ATI_TASKID_SM},    // Z_PSMDL_SM 4
        {MMIA_UMM_ABORT_REQ_EV,        Z_ATI_TASKID_UMM},  // Z_PSMDL_UMM 5
        {MMIA_SM_ABORT_REQ_EV,         Z_ATI_TASKID_ESM},  // Z_PSMDL_ESM 6
    };

    T_zApMmia_Abort_Req  *ptApReq   = (T_zApMmia_Abort_Req*)zAti_GetUB(sizeof(T_zApMmia_Abort_Req));
    ptApReq->bSrcIndex  = pChnelNode->iSrcIndex;
    ptApReq->bDesIndex = pChnelNode->iDestIndex;

    if (0xff == ptApReq->bDesIndex)
    {
        if(pChnelNode->cmd_id == ZAT2_SMS_CMSS && g_zAti_ptData->abChMdlTable[ptApReq->bSrcIndex] != Z_PSMDL_SMS)
        {
            g_zAti_ptData->abChMdlTable[ptApReq->bSrcIndex] = Z_PSMDL_PB;
        }
        bDesMdl = g_zAti_ptData->abChMdlTable[ptApReq->bSrcIndex];
    }
    else
    {
        bDesMdl   = (ptApReq->bDesIndex & 0xf0) >> 4;
    }

    if(bDesMdl < Z_PSMDL_CC || bDesMdl > Z_PSMDL_ESM)
    {
        // 
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_RetUB((VOID **)&ptApReq);
    }
    else
    {
        // ʧܺڴzAti_MsgSendͷ
        zAti_MsgSend(bAbortMsgInfo[bDesMdl-1][0],  (PBYTE)ptApReq, sizeof(T_zApMmia_Abort_Req), (BYTE) bAbortMsgInfo[bDesMdl-1][1]);
    }
    return;
}

/**************************************************************************
*  : zAti_ProcChnelConflict
*  : ͨͻ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_ProcChnelConflict(T_ZAti_ChannelInfo *pChnelNode)
{
    /* ͻ⣬ֱӻظ6000, 
        зǿжֱӻظ6000,
        пжж*/
    if (zAti_IsMultiCmd(pChnelNode)  || (!zAti_IsAbortCmdMsg(pChnelNode)) )
    {
        zAti_CmdDirectReply(pChnelNode, ZAT2_CMD_CONFLICT);
    }
    else
    {
       zAti_AtCmdAbortReq(pChnelNode);
    }
    return;
}

/**************************************************************************
*  : zAti_IsDirectReplyCmd
*  : ȡʧϢ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ TRUE , FALSE
* ˵ 
**************************************************************************/
BOOL __ps_static_func zAti_IsDirectReplyCmd(CHAR * pbStrCmd)
{    
    return (strcmp((const char *)pbStrCmd, "AT") == 0 ||
        strcmp((const char *)pbStrCmd, "ATQ0E0V1") == 0 ||
        //strcmp((const char *)pbStrCmd, "ATS0=0") == 0 ||
        strcmp((const char *)pbStrCmd, "ATH E1") == 0 ||
        strcmp((const char *)pbStrCmd, "ATE0V1") == 0 ||
        strcmp((const char *)pbStrCmd, "ATE0Q0V1") == 0 );
}

/**************************************************************************
*  : zAti_GetDistributeMsgIdx
*  : ȡ±
* ˵ (IN) 
*            pDecCmdInfo  : Ϣ
*            (OUT)
*             pMsgIdx   : е±
*   ֵ ҵZ_SUCC,  ûҵZ_FAIL
* ˵ 
**************************************************************************/
BYTE __ps_static_func zAti_GetCmd2MsgIdx(T_ZAt_DecCmdInfo *pDecCmdInfo, WORD *pCmd2MsgIdx)
{
    WORD wTabIdx = 0;
    WORD wTabLen = g_zAt_Cmd2MsgTable_Len; //sizeof(g_zAt_Cmd2MsgTable) / sizeof(T_ZAt_Cmd2MsgTab);
  
    for (wTabIdx = 0; wTabIdx < wTabLen; wTabIdx++)
    {
        if ((g_zAt_Cmd2MsgTable[wTabIdx].cmdId == pDecCmdInfo->curCmdId) &&
            (g_zAt_Cmd2MsgTable[wTabIdx].cmdOp == pDecCmdInfo->curCmdOp))
        {
            *pCmd2MsgIdx = wTabIdx;
            return Z_SUCC;
        }
    }

    return Z_FAIL;
}

/**************************************************************************
*  : zAti_DecCmd2Msg
*  : Ľ洢ڽṹ
* ˵ (IN) 
*            pDecCmdInfo  : Ϣָ
*            wCmd2MsgIdx  뺯
*   ֵ T_ZAt_ParseCmd2MsgRslt 
* ˵ 
**************************************************************************/
T_ZAt_ParseCmd2MsgRslt __ps_static_func zAti_DecCmd2Msg(T_ZAt_DecCmdInfo *pDecCmdInfo, WORD wCmd2MsgIdx)
{
    T_ZAt_ParseCmd2MsgRslt prsCmd2MsgRslt = {0};
    if (g_zAt_Cmd2MsgTable[wCmd2MsgIdx].pDecFnc != NULL)
    {
        prsCmd2MsgRslt = g_zAt_Cmd2MsgTable[wCmd2MsgIdx].pDecFnc(pDecCmdInfo);

        if ((pDecCmdInfo->curCmdId == ZAT2_SM_CGDATA) && (g_zAti_ptData->bSmOnlyL2PFlag == TRUE))
        {
            prsCmd2MsgRslt.iMsgId = 0;
        }
        else
        {
            prsCmd2MsgRslt.iMsgId = g_zAt_Cmd2MsgTable[wCmd2MsgIdx].iMsgId;
        }

        if ((pDecCmdInfo->curCmdId == ZAT2_SMS_CNMA)&& (zAt_GetSmsCmgfType() == ZAT2_CMGF_TEXT)
            && (pDecCmdInfo->curCmdOp != ZAT2_CO_TEST_REQ))
        {
            prsCmd2MsgRslt.iMsgId = MMIA_SMS_REC_RSP_REQ_EV;
        }
    }
    else
    {
        prsCmd2MsgRslt.decRslt2nd = ZAT2_CMD_UNREC;
    }
    return prsCmd2MsgRslt;
}


/**************************************************************************
*  : zAti_DecTestCmd
*  : 
* ˵ (IN) 
*            pDecCmdInfo  : Ϣָ
*   ֵ T_ZAt_ParseCmd2MsgRslt 
* ˵ 
**************************************************************************/
T_ZAt_ParseCmd2MsgRslt zAti_DecTestCmd(T_ZAt_DecCmdInfo *pDecCmdInfo)
{
    T_ZAt_ParseCmd2MsgRslt prsCmd2MsgRslt = {0};
    
    if (pDecCmdInfo->curCmdOp == ZAT2_CO_TEST_REQ)//testĴ
    {
        UINT16 iIndex = zAt2_FindTestInfo(pDecCmdInfo->curCmdId);
        if (g_zAt_CmdHd2IdTable[iIndex].strTestInfo[0] != 0)
        {
            sprintf((char *)g_zAt_EncBuf, "%s%s%s%s", g_zAt_CRLF, g_zAt_CmdHd2IdTable[iIndex].strTestInfo, g_zAt_CRLF, g_zAt_OK);
        }
        else
        {
            zOss_Memcpy(g_zAt_EncBuf, g_zAt_OK, strlen((const char *)g_zAt_OK));
        }
        prsCmd2MsgRslt.decRslt2nd = ZAT2_CMD_REPLY_DIRECT;
        if (strlen((const char *)pDecCmdInfo->strParam) != 0)
        {
            zOss_Memset(g_zAt_EncBuf, 0, ZAT_LONG_CMD_LEN); 
            prsCmd2MsgRslt.decRslt2nd = ZAT2_CMD_SYNTAX_ERR;
        }
    }
    else
    {
        prsCmd2MsgRslt.decRslt2nd = ZAT2_CMD_UNREC;
    }

    return prsCmd2MsgRslt;
}
/**************************************************************************
*  : zAti_GetMsgInfo
*  : ȡϢơṹ 
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
T_ZAt_ParseCmd2MsgRslt __ps_static_func zAti_GetMsgInfo(T_ZAt_DecCmdInfo *pDecCmdInfo)
{
    /* 1ȷݵõcmdIdcmdOpҶӦmsgId,ý봦Ӻ */
    WORD wCmd2MsgIdx = 0;
    if(zAti_GetCmd2MsgIdx(pDecCmdInfo, &wCmd2MsgIdx) == Z_SUCC)
    {
        return zAti_DecCmd2Msg(pDecCmdInfo, wCmd2MsgIdx);
    }
    else
    {
        return zAti_DecTestCmd(pDecCmdInfo);
    }
}

/********************************* LTE GoTa *******************************/
/**************************************************************************
*  : zAti_IsGotaReplyOK
*  : жǷǷϢɹҪֱӻظOKϢ
* ˵ (IN) 
*        
*            (OUT)
*   ֵ true,false
* ˵ Ⱥں
**************************************************************************/
BOOL __ps_static_func zAti_IsGotaReplyOK(DWORD dwMsgId)
{
    //ӼȺ
#ifdef BTRUNK_SUPPORT

    if (dwMsgId == ATI_TSM_REG_REQ_EV ||dwMsgId == ATI_TSM_CALL_REQ_EV
        ||dwMsgId == ATI_TSM_CALLCONFIRM_REQ_EV ||dwMsgId == ATI_TSM_CALLCONNECT_REQ_EV
        ||dwMsgId == ATI_TSM_CALLRLS_REQ_EV ||dwMsgId == ATI_TSM_FLOOR_REQ_EV
        ||dwMsgId == ATI_TSM_FLOORRLS_REQ_EV ||dwMsgId == ATI_TSM_SCANGROUPINFO_REQ_EV
        ||dwMsgId == ATI_TSM_SCANSWITCH_REQ_EV ||dwMsgId == ATI_TSM_SHAKEHAND_REQ_EV
        ||dwMsgId == ATI_TSM_SHORT_DATA_REQ_EV ||dwMsgId == ATI_TSM_LOCATINFO_REQ_EV
        ||dwMsgId == ATI_TSM_SETABILITY_REQ_EV ||dwMsgId == ATI_TSM_STUNINFO_QUERY_REQ_EV
        ||dwMsgId == ATI_TSM_GROUPINFO_QUERY_REQ_EV ||dwMsgId == ATI_TSM_CALLFORWARD_REQ_EV
        ||dwMsgId == PTT_MMIA_ESM_TAUTYPE_REQ_EV ||dwMsgId == ATI_TSM_CALLMODIFY_RSP_EV
        ||dwMsgId == ATI_TSM_CALLMODIFY_REJ_EV)
    {
        return TRUE;
    }
#endif

    return FALSE;

}

/**************************************************************************
*  : zAti_ProcCmdMsg
*  : һϢ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
T_zAti_DecResultType __ps_static_func zAti_ProcCmdMsg(DWORD dwMsgId, BYTE *pbMsgBody, WORD wMsgLen, T_ZAti_ChannelInfo *pChnelNode)
{
    BYTE          destTask    = 0;
    WORD          wIdx        = 0;
    DWORD         dwResult    = Z_APMMIA_OPTNOTSPT_ERR;
    zAti_GetServerIndex(dwMsgId, (BYTE *)pbMsgBody, pChnelNode);
#ifdef USE_VOICE_SUPPORT
    if(!zAti_CcMsgProc(&dwMsgId, pbMsgBody, &wMsgLen, pChnelNode)) /* ͨѡԴĿ */
    {
        zAti_RetUB((VOID **)&pbMsgBody);
        return ZATI_DEC_ERROR;
    }
#endif
    // ദϢ
    if (zAti_GetAtMemMsgIdx(dwMsgId , &wIdx) == Z_SUCC)
    {
        dwResult = zAti_ProcAtMemMsg(wIdx , pbMsgBody, wMsgLen, pChnelNode);
        if(dwResult == Z_APMMIA_NORESULT )
        {
             zAti_RetUB((VOID * *) &pbMsgBody);
        }
    }
    else if (zAti_GetDistributeMsgIdx(dwMsgId , &wIdx) == Z_SUCC)
    {
        dwResult = zAti_ProcDistributeMsg(wIdx , pbMsgBody, wMsgLen, pChnelNode);
        //·͵ϢҪռ
        //ͳɹ˴ pbMsgBody ͷŴ룬 
        if(dwResult == Z_APMMIA_NORESULT )
        {
             zAti_RetUB((VOID * *) &pbMsgBody);
        }
    }
    else if (zAti_GetTransmitMsgTaskId(dwMsgId , &destTask) == Z_SUCC)
    {
        dwResult = zAti_RrocTransmitMsg(dwMsgId , pbMsgBody, wMsgLen, pChnelNode, destTask);

#ifdef CXT_MOV
        if(dwResult != Z_APMMIA_NORESULT && dwMsgId == MMIA_SM_CONTEXT_REQ_EV)
        {
            // ˫Ǩʧ,ȫ
            zAti_ClearPsMovStat();
        }
#endif
    }

    // ֵ
    if( dwResult == Z_APMMIA_NOERROR_ERR)
    {
        zAti_RetUB((VOID **)&pbMsgBody);
        if(dwMsgId !=AP_MMIA_CPOL_QUERY_REQ_EV && dwMsgId != AP_MMIA_FPLMN_QUERY_REQ_EV
            && (dwMsgId != AP_MMIA_ZOPERLTEBAND_QUERY_REQ_EV))
        {
            zAti_CmdDirectReply(pChnelNode, ZAT2_CMD_REPLY_DIRECT);
        }
        return ZATI_DEC_INNER_OK;
    }
    else if ( dwResult == Z_APMMIA_NORESULT )
    {  
        // ·ɹֱӻظOK
        if (dwMsgId == MMIA_EUCSR_LTEINFO_REQ_EV || dwMsgId == MMIA_UMM_CS_SRV_CNF_EV || 
            dwMsgId == MMIA_CC_ANS_MODE_REQ_EV || dwMsgId == MMIA_CC_DIS_MODE_REQ_EV 
            ||dwMsgId == MMIA_UMM_IMS_REGISTER_STATES_EV || dwMsgId == MMIA_CC_STATE_REQ_EV
            ||dwMsgId == AP_UICC_AIR_AUTH_RSP_IND_EV
            || dwMsgId == MMIA_CC_OPEN_VOICECHNL_REQ_EV
            || dwMsgId == MMIA_CC_SRVCC_NOTOPEN_VOICECHNL_REQ_EV
            || dwMsgId == MMIA_AS_EM_LTE_HO_SET_REQ_EV
       /************** LTE GoTaģ ·ɹֱӻظOK*********************/
        ||zAti_IsGotaReplyOK(dwMsgId))
        {
            zAti_ReplyOK(pChnelNode);
            return ZATI_DEC_INNER_OK;
        }
        return ZATI_DEC_OUTER_OK;
    }
    else  // 
    {         
        zAti_RetUB((VOID **)&pbMsgBody);
        zAti_ProcError(pChnelNode, dwResult);
        return ZATI_DEC_ERROR;
    }
}


/**************************************************************************
*  : zAti_DecCmd
*  : һ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
T_zAti_DecResultType __ps_static_func zAti_DecCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    T_ZAt_DecCmdInfo *pdecCmdInfo = ZOSS_NULL;                          /* Used to store info of the 1st-step-parsing */
    T_ZAt_ParseCmd2MsgRslt prsCmd2MsgRslt = {0}; /* Used to store info of the 2nd-step-parsing */

    BYTE *pbStrCmd = zAti_GetFirstCmd(pChnelNode);
    if(zAti_IsDirectReplyCmd((CHAR *)pbStrCmd))
    {
        zAti_SendEncData(pChnelNode, (BYTE *)g_zAt_OK, ZATI_INVALID_MSGID, NULL);        
        return ZATI_DEC_INNER_OK;
    }

    g_zAti_ptData->ptCmdInputInfo = &pChnelNode->cmdInputInfo;
    zOss_Memset(g_zAt_EncBuf, 0, ZAT_LONG_CMD_LEN);

    pdecCmdInfo = (T_ZAt_DecCmdInfo *)zAti_GetUB(sizeof(T_ZAt_DecCmdInfo));

    /* 1: ͷʽȷӦϢʶ */
    zAt_ParseCmdStr(pChnelNode->cmd_id, pChnelNode->cmd_op, pChnelNode->iChnelId, (CHAR *)pbStrCmd, pdecCmdInfo);
    if (ZAT2_CMD_PARSE_OK == pdecCmdInfo->decRslt1st)
    {
        /* 2: ݵһõϢơṹ */
        prsCmd2MsgRslt = zAti_GetMsgInfo(pdecCmdInfo);
    }
    else
    {
        prsCmd2MsgRslt.decRslt2nd = pdecCmdInfo->decRslt1st;
    }

    if (ZAT2_CMD_PARSE_OK == prsCmd2MsgRslt.decRslt2nd)
    {
        /* ɹϢIDȣͨ״̬ */
        pChnelNode->cmd_id = pdecCmdInfo->curCmdId;
        pChnelNode->cmd_op = pdecCmdInfo->curCmdOp;
        
        zAti_RetUB((VOID **)&pdecCmdInfo);
        
        return zAti_ProcCmdMsg(prsCmd2MsgRslt.iMsgId, (BYTE *)prsCmd2MsgRslt.pMsgBody,  prsCmd2MsgRslt.iMsgLen, pChnelNode);  
    } 
    else if (ZAT2_CMD_REPLY_DIRECT == prsCmd2MsgRslt.decRslt2nd)
    {
        zAti_RetUB(&prsCmd2MsgRslt.pMsgBody);
        zAti_CmdDirectReply(pChnelNode, prsCmd2MsgRslt.decRslt2nd);
        zAti_RetUB((VOID **)&pdecCmdInfo);
        return ZATI_DEC_INNER_OK;
    }
    else  // 
    {
        zAti_RetUB(&prsCmd2MsgRslt.pMsgBody);
        zAti_CmdDirectReply(pChnelNode, prsCmd2MsgRslt.decRslt2nd);

        //ATDPPPţһʱһҪǰ沦
        if (pdecCmdInfo->curCmdId == ZAT2_SM_ZGPCOAUTH
            || pdecCmdInfo->curCmdId == ZAT2_SM_CGACT)
        {
            zAti_HandlePppProcCmdError();
        }
        zAti_RetUB((VOID **)&pdecCmdInfo);
        return ZATI_DEC_ERROR;
    }
}


/**************************************************************************
*  : zAti_DecMultiCmd
*  : 
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_DecMultiCmd(T_ZAti_ChannelInfo * pChnelNode)
{
    T_zAti_DecResultType  eDecRltType = ZATI_DEC_ERROR;

    
    while(zAti_HasMoreCmd(pChnelNode))
    {
        /* ڿʼǰͨӦǿյ,֮ǰҲӦ */
        pChnelNode->cmd_id = ZAT2_NO_COMMAND;
        pChnelNode->cmd_op = ZAT2_CO_INVALID;

        eDecRltType = zAti_DecCmd(pChnelNode);
        if(eDecRltType == ZATI_DEC_INNER_OK)
        {            
            zAti_RemoveOneCmd(pChnelNode);
        }
        else if(eDecRltType == ZATI_DEC_OUTER_OK)
        {
            break;
        }
        else  // ZATI_DEC_ERROR
        {
            zAti_RemoveALLCmd(pChnelNode);
            break;
        }
    }
    return;
}


BOOL __ps_static_func zAti_IsOnlyRefCmd(CHAR * pbStrCmd)
{
    if(strstr((const char *)pbStrCmd, "AT+ZCONSTAT") != NULL
        || strstr((const char *)pbStrCmd, "AT+ZSET=\"STANDMODE\"") != NULL
       ||strstr((const char *)pbStrCmd, "AT+CFUN=0") != NULL
       ||strstr((const char *)pbStrCmd, "AT+CGSN=") != NULL
       ||strstr((const char *)pbStrCmd, "AT+CFUN=1,1") != NULL
       ||strstr((const char *)pbStrCmd, "AT+ZCHNELSET") != NULL)
    {
        return TRUE;
    }
    return FALSE;
}
#ifdef DSDS_VSIM
BOOL __ps_static_func zAti_IsVsimDualCardInit(CHAR * pbStrCmd)
{
    if((g_zAti_CurInstance == Z_ATI_INSNO_2 && strstr((const char *)pbStrCmd, "AT+CFUN=1") != NULL 
       && strstr((const char *)pbStrCmd, "AT+CFUN=1,1") == NULL) || (g_zAti_CurInstance == Z_ATI_INSNO_1))
    {
        return TRUE;
    }
    return FALSE;
}
#endif
/**************************************************************************
*  : zAti_ProcessPsMovStatCmd
*  : ڰǨϲ㷢͵
* ˵ (IN) 
*                  pChnelNode    ͨڵ
*   ֵ 
* ˵ 
**************************************************************************/
#ifdef CXT_MOV
VOID zAti_ProcessCmdInPsMovStat(T_ZAti_ChannelDataBuf *recvCmdInd, T_ZAti_ChannelInfo *pChnelNode)
{
    if ((ZAT2_NO_COMMAND != pChnelNode->cmd_id && ZAT2_CO_INVALID != pChnelNode->cmd_op)
        ||pChnelNode->IsCmdStored)/*ǰͨлѾ*/
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_CmdDirectReply(pChnelNode, ZAT2_CMD_CONFLICT);
        return;
    }

    /* AT浽ATIȥ,Խֱӷ"ERROR" */ 
    if(zAti_StoreAtCmd(recvCmdInd, pChnelNode) == Z_FAIL)
    {
        return;
    }

    if(zAti_DepartAtCmd(pChnelNode) == Z_FAIL)
    {
        return;
    }

    pChnelNode->IsCmdStored = TRUE;
    return;
}
#endif
#ifdef USE_VOICE_SUPPORT
BOOL __ps_static_func zAti_ZredialHandle(T_ZAti_ChannelDataBuf *recvCmdInd, T_ZAti_ChannelInfo *pChnelNode)
{
    /*ҪЯҲǴַ*/
    BYTE * pZredial = (BYTE *)strstr((char *)recvCmdInd->strData, "AT+ZREDIAL=");
    /*ͨʱֱӻظCEND*/
    if (NULL != pZredial)
    {
        if(g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag == Z_ATI_CARDINIT_ING  ||
           (ZAT2_NO_COMMAND != pChnelNode->cmd_id && ZAT2_CO_INVALID != pChnelNode->cmd_op))
        {
            zAti_DeliverCendInd();
            return TRUE;
        }
    }
    return FALSE;
}
#endif
/**************************************************************************
*  : zAti_ProcessCmd
*  : ϲ㷢
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_ProcessCmd(T_ZAti_ChannelDataBuf      *recvCmdInd , T_ZAti_ChannelInfo *pChnelNode)
{
    // pChnelNode ΪãһΪգassert
    // ͨ״̬Ϊͨͻ 
    //һĿʼڽУʱͨֱӻظ6000 

    if (g_zAti_atDataEx[g_zAti_CurInstance].bCardInitiatedFlag == Z_ATI_CARDINIT_ING )
    {
        if(pChnelNode->bIsCardIniting == TRUE)
        {
            zAti_CmdDirectReply(pChnelNode, ZAT2_CMD_CONFLICT);
            return;
        }
    }

    if ( ZAT2_NO_COMMAND != pChnelNode->cmd_id && ZAT2_CO_INVALID != pChnelNode->cmd_op)
    {
        zAti_ProcChnelConflict(pChnelNode);
        return;
    }

    /* AT浽ATIȥ,Խֱӷ"ERROR" */ 
    if(zAti_StoreAtCmd(recvCmdInd, pChnelNode) == Z_FAIL)
    {
        return;
    }

    if(zAti_DepartAtCmd(pChnelNode) == Z_FAIL)
    {
        return;
    }

    if(!zAti_IsDirectReplyCmd((CHAR *)zAti_GetFirstCmd(pChnelNode))
        && !zAti_IsOnlyRefCmd((CHAR *)zAti_GetFirstCmd(pChnelNode))
        && zAti_IsNeedCardInit()
        #ifdef DSDS_VSIM
        && zAti_IsVsimDualCardInit((CHAR *)zAti_GetFirstCmd(pChnelNode))
        #endif
        )
    {
        // յʼȷϢҪж
        BYTE bInsNo = 0;
        BYTE bSrcIndex    = (g_zAti_CurInstance == 0 ? ZATI2_CHANNEL_ID_NUM251 : ZATI2_CHANNEL_ID_NUM252);

        bInsNo = ((g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);
        zAti_InitCard(bSrcIndex, Z_ATI_INVALID_BYTE);
        zAti_CardInitFlgClr_SigCd(bInsNo, Z_ATI_CARDINIT_ING);
        g_zAti_atDataEx[bInsNo].ptCardInitChnlOfFirstCmd = pChnelNode;

        pChnelNode->bIsCardIniting = TRUE;
        return;
    }

    zAti_DecMultiCmd(pChnelNode);
    return;
}

/**************************************************************************
*  : zAti_ProcessSMSData
*  : ϲ㷢ĶϢ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID zAti_ProcessSMSData(T_ZAti_ChannelDataBuf      *recvCmdInd , T_ZAti_ChannelInfo *pChnelNode)
{
    WORD               wMsgLen = 0; 
    WORD              wDataLen = 0;
    WORD            wMsgLenRet = 0;
    UINT32             dwMsgId = 0;
    VOID            * pMsgBody = NULL;     
    //--T_ZAt2_DecRsltType rsltTmp = ZAT2_CMD_PARSE_OK;

    if(zAti_StoreSmsData(recvCmdInd, pChnelNode) == Z_FAIL)/* Ϣ,δԽֱӷ*/ 
    {
        return;
    } 
    /*յESCʱֱӻظOK,ͶϢ */
    if ((g_zAti_ptData->ptCmdInputInfo != NULL) && (g_zAti_ptData->ptCmdInputInfo->bSmsEsc == Z_VALID))
    {
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        zAti_SendEncData(pChnelNode, (BYTE *)g_zAt_EncBuf, ZATI_INVALID_MSGID, NULL);

        /* ͷͨлϢݵڴַsmsInputTypeԭ */
        zAti_RetUB((VOID **)&pChnelNode->cmdInputInfo.pSmsInputMsg);

        /* λϢ״̬ */
        pChnelNode->atBuff.iLength = 0;
        zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);        
        zAti_Init_CmdInfo(&pChnelNode->cmdInputInfo);
        return ;
    }
    
    wDataLen = (UINT16)strlen((const char *)pChnelNode->atBuff.arrData);
    /* ȡϢݳɹֱӽ֮ǰϢ */
    wMsgLenRet = zAt_DecSmsContent(&dwMsgId, pChnelNode, wDataLen);
    
    if (wMsgLenRet == 0)
    {
        /* ݽʧ,ֱӷضϢ */
        zAt_EncErrorCode(g_zAt_EncBuf, ZAT2_CFG_CMEE, ZAT2_CMEE_SMSCONTENT_ERR); 
        zAti_SendEncData(pChnelNode, (BYTE *)g_zAt_EncBuf, ZATI_INVALID_MSGID, NULL);
        
        /* ͷͨлϢݵڴַsmsInputTypeԭ */
        zAti_RetUB((VOID **)&pChnelNode->cmdInputInfo.pSmsInputMsg);

        /* λϢ״̬ */
        pChnelNode->atBuff.iLength = 0;
        zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);        
        zAti_Init_CmdInfo(&pChnelNode->cmdInputInfo);
    }
    else
    {
        /* ݽɹ, ͨлϢݵڴַpMsgBody,smsInputTypeԭ */
        pMsgBody = pChnelNode->cmdInputInfo.pSmsInputMsg;
        pChnelNode->cmdInputInfo.pSmsInputMsg = NULL;
        wMsgLen = wMsgLenRet;
        
        /* ¼ͨ״̬cmdId,cmdOp */
        pChnelNode->cmd_op = ZAT2_CO_SET_REQ;
        switch (pChnelNode->cmdInputInfo.smsInputType)
        {
        case ZAT2_CMGC_PDU:
        case ZAT2_CMGC_TEXT:
            pChnelNode->cmd_id = ZAT2_SMS_CMGC;
            break;

        case ZAT2_CMGS_PDU:
        case ZAT2_CMGS_TEXT:
            pChnelNode->cmd_id = ZAT2_SMS_CMGS;
            break;

        case ZAT2_CMGW_PDU:
        case ZAT2_CMGW_TEXT:
            pChnelNode->cmd_id = ZAT2_SMS_CMGW;
            break;

        case ZAT2_CNMA_PDU:
            pChnelNode->cmd_id = ZAT2_SMS_CNMA;
            break;

        default:
            //--rsltTmp = ZAT2_CMD_UNREC;
            break;
        }
        
        /* λϢ״̬ */
        pChnelNode->atBuff.iLength = 0;
        zOss_Memset(pChnelNode->atBuff.arrData, 0, ZATI2_BUFFER_LENGTH);
        
        zAti_Init_CmdInfo(&pChnelNode->cmdInputInfo);
        zAti_ProcCmdMsg(dwMsgId, (BYTE *)pMsgBody, wMsgLen, pChnelNode);
     }   
    return;
}


/**************************************************************************
*  : zAti_RecvCommandInd
*  : յϱϢ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_RecvCommandInd(UINT8 *pDataPtr, UINT16 iDataLen)
{
    T_ZAti_ChannelDataBuf      *recvCmdInd = (T_ZAti_ChannelDataBuf *)pDataPtr;
    T_ZAti_ChannelInfo         *pChnelNode = NULL;

    g_zAti_ptData->bPowerIndFlag = FALSE;

    if( (NULL == pDataPtr) || (0 == iDataLen)  ||(NULL == (pChnelNode = zAti_GetChannelNodePtr(recvCmdInd->iChannel))))
    {
        return;
    }

    zOss_Memset(g_zAt_EncBuf, 0, ZAT_LONG_CMD_LEN);
    zAti_SendRecvCmdStr2Trace(recvCmdInd->iChannel, recvCmdInd->iDataLen, (CHAR *)recvCmdInd->strData);

    if(!zAti_IsRightStandAtCmd(recvCmdInd->iChannel))/*û*/
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_CmdDirectReply(pChnelNode, ZAT2_OPTNOTALW_ERR);
        return;
    }

    if(pChnelNode->cmdInputInfo.cmdInputStat == ZAT2_ATCMD)
    {
        zAti_UpCaseRecvCmd(recvCmdInd->strData, recvCmdInd->iDataLen);
        #ifdef USE_VOICE_SUPPORT
        if(zAti_ZredialHandle(recvCmdInd, pChnelNode))//for VOLTE
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
        }
        #endif
#ifdef Z_DUALCARD_ADAPT
        if(zAti_IsDualCardSelfAdaptChanging())/*̲κ*/
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");
            zAti_CmdDirectReply(pChnelNode, ZAT2_DUALCARDADPT_ERR);
            return;
        }
#endif
#ifdef CXT_MOV
        if(Z_ATI_PS_MOVE_ORIGIN != zAti_GetPsMovStat())
        {
            zAti_ProcessCmdInPsMovStat(recvCmdInd, pChnelNode);
            return;
        }
#endif
        zAti_ProcessCmd(recvCmdInd, pChnelNode);
    }
    else
    {
        // ZAT2_SMS_EDIT   /* Ϣ״̬ Ϣݴ*/
        zAti_ProcessSMSData(recvCmdInd, pChnelNode);
    }    
    return;
}

/**************************************************************************
*  : zAti_Open
*  : ͨ
* ˵ : (IN)
*            iChnelId     ͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشͣ
* ˵ : ܽͨ
*            ͬһܴͨΣҪرպܴ
**************************************************************************/

BOOL __ps_static_func zAti_IsValidChnelId(UINT8 iChnelId)
{
     return ( iChnelId >= ZATI2_CHANNEL_ID_NUM_START && iChnelId <= ZATI2_CHANNEL_ID_NUM_END);
}

SINT32 __ps_static_func zAti2_Open(UINT8 iChnelId)
{
    if( g_zAti_Context.taskStatus != ZATI2_TASK_STATUS_READY
        || !zAti_IsValidChnelId(iChnelId) 
        || ZATI2_SUCCESS == zAti_GetChannelNode(iChnelId)       // ͨѾ 
        || g_zAti_ptData->tAtChnelList.iCount > ZATI2_CHANNEL_ID_NUMCOUNT
        || NULL == g_zAti_Context.mutexOpenChnel
        )
    {
        return ZATI2_FALSE;
    }

    if(ZOSS_SUCCESS == zOss_GetMutex(g_zAti_Context.mutexOpenChnel, ZOSS_WAIT_FOREVER)) 
    {
        zAti_AddChannelToList(iChnelId);
        if(ZOSS_SUCCESS == zOss_PutMutex(g_zAti_Context.mutexOpenChnel))/* ͷŻ */
        {
            return ZATI2_SUCCESS;             
        } 
    }

    return ZATI2_FALSE;          
}

/**************************************************************************
*  : zAti_GetChannelNode
*  : ȡͨͬĽ
* ˵ : (IN)
*            iChnelId     ҪҵĿͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ͨţ
**************************************************************************/
SINT32 __ps_static_func zAti_GetChannelNode(UINT8 iChnelId)
{
    T_ZAti_ChannelInfo *pChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;
    
    while(NULL != pChnelNode)
    {
        if(iChnelId == pChnelNode->iChnelId)
        {
            return ZATI2_SUCCESS;
        }
        
        pChnelNode = pChnelNode->pNextCnNode;
    }

    return ZATI2_FALSE;
}

/**************************************************************************
*  : zAti_GetChannelNodePtr
*  : ȡͨͬĽ㣬ͬʱؽָ
* ˵ : (IN)
*            iChnelId     ҪҵĿͨID
*            (OUT)
*   ֵ : ɹظýָ룬ʧܷNULL
* ˵ : ͨţеĽָ
**************************************************************************/
T_ZAti_ChannelInfo * __ps_static_func zAti_GetChannelNodePtr(UINT8 iChnelId)
{
    T_ZAti_ChannelInfo *pChnelNode = NULL;
    
    if(g_zAti_Context.taskStatus != ZATI2_TASK_STATUS_READY || !zAti_IsValidChnelId(iChnelId)) 
    {
        return NULL;
    }

    pChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;
    while(NULL != pChnelNode)
    {
        if(iChnelId == pChnelNode->iChnelId)
        {
            return pChnelNode;
        }
        
        pChnelNode = pChnelNode->pNextCnNode;
    }

    return NULL;
}

/**************************************************************************
*  : zAti_GetChannelNodePtrByMmiaDestIndex
*  : ȡͨͬĽ㣬ͬʱؽָ,ͨMMIAĿвҵ
* ˵ : (IN)
*            iMmiaDestChnelId     ҪҵMMIAĿ
*            (OUT)
*   ֵ : ɹؽָ룻ʧܷNULL
* ˵ : ͨţеĽָ
*            βΪջ255
*            Ŀ൱ATI2ͨ
**************************************************************************/
T_ZAti_ChannelInfo * __ps_static_func zAti_GetChannelNodePtrByMmiaDestIndex(BYTE iMmiaDestChnelId)
{
    T_ZAti_ChannelInfo *pChnelNode = NULL;
    
    if(g_zAti_Context.taskStatus != ZATI2_TASK_STATUS_READY) 
    {
        return NULL;
    }
    else if(!((iMmiaDestChnelId >= ZATI2_CHANNEL_ID_NUM_START) && (iMmiaDestChnelId <= ZATI2_CHANNEL_ID_NUM_END)))
    {
        return NULL;
    }
    else// if(iMmiaDestChnelId == ZATI2_INVAL_INDEX)
    {
        pChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;
        while(NULL != pChnelNode)
        {
            if(iMmiaDestChnelId == pChnelNode->iSrcIndex)
            {
                pChnelNode = pChnelNode;
                return pChnelNode;
            }
    
            pChnelNode = pChnelNode->pNextCnNode;
        }
        return NULL;
    }
}

/**************************************************************************
*  : zAti_GetChannelNodePtrByMmiaSrcIndex
*  : ȡͨͬĽ㣬ͬʱؽָ룬ͨMMIAԴвҵ
* ˵ : (IN)
*            iMmiaSrcChnelId     ҪҵMMIAԴ
*            (OUT)
*   ֵ : ɹؽָ룻ʧܷNULL
* ˵ : ͨţеĽָ
*            һ˵ͨMMIAĿŲҲˣŵúв
**************************************************************************/
T_ZAti_ChannelInfo * __ps_static_func zAti_GetChannelNodePtrByMmiaSrcIndex(UINT16 iMmiaSrcChnelId)
{
    T_ZAti_ChannelInfo *pChnelNode = NULL;
    
    if(g_zAti_Context.taskStatus != ZATI2_TASK_STATUS_READY) 
    {
        return NULL;
    }

    pChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;    
    while(NULL != pChnelNode)
    {
        if(iMmiaSrcChnelId == pChnelNode->iDestIndex)
        {
            pChnelNode = pChnelNode;
            return pChnelNode;
        }
        
        pChnelNode = pChnelNode->pNextCnNode;
    }

    return NULL;
}

/**************************************************************************
*  : zAti_GetChannelNodePtrBystate
*  : ͨͬĽ㣬ͬʱؽָ룬ͨͨ״̬
* ˵ : (IN)
*            iChnelId     ҪҵĿͨID
*            (OUT)
*   ֵ : ɹظýָ룬ʧܷNULL
* ˵ : ͨţеĽָ
**************************************************************************/
T_ZAti_ChannelInfo * zAti_GetChannelNodePtrByState(T_ZAti_DataType dataType)
{
    T_ZAti_ChannelInfo *pChnelNode = NULL;  
    
    if(g_zAti_Context.taskStatus != ZATI2_TASK_STATUS_READY) 
    {
        return NULL;
    }
    else if(!((dataType > ZATI2_CHANNEL_DATA_TYPE_INVAL) && (dataType < ZATI2_CHANNEL_DATA_TYPE_COUNTT)))
    {
        return NULL;
    }

    pChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;
    
    while(NULL != pChnelNode)
    {
        if((ZATI2_CHANNEL_MODE_DATA == pChnelNode->server_mode) && (dataType == pChnelNode->dataType))
        {
            return pChnelNode;
        }
        
        pChnelNode = pChnelNode->pNextCnNode;
    }

    return NULL;
}

/**************************************************************************
*  : zAti_AddChannelToList
*  : رͨ
* ˵ : (IN)
*            iChnelId     ҪӵĿͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ͨţ
**************************************************************************/
SINT32 __ps_static_func zAti_AddChannelToList(UINT8 iChnelId)
{
    T_ZAti_ChannelInfo *pNewChnelNode = (T_ZAti_ChannelInfo *)zOss_Malloc(sizeof(T_ZAti_ChannelInfo));
    if(pNewChnelNode == NULL)
    {
        return ZATI2_FALSE;
    }
    /* ½ */
    zOss_Memset((UINT8 *)pNewChnelNode, 0, sizeof(T_ZAti_ChannelInfo));

    pNewChnelNode->iChnelId = iChnelId;
    pNewChnelNode->cmd_id = ZAT2_NO_COMMAND; /* = -1; */
    pNewChnelNode->cmd_op = ZAT2_CO_INVALID; /* = -1; */
    zAti_Init_CmdInfo(&pNewChnelNode->cmdInputInfo);
    pNewChnelNode->iEvId = ZATI2_INVAL_EVID;
    pNewChnelNode->server_mode = ZATI2_CHANNEL_MODE_CMD;
    pNewChnelNode->iSrcIndex = iChnelId; /* ATI2Դţȡͨ */
    pNewChnelNode->iDestIndex = ZATI2_INVAL_MMIA_INDEX;
    pNewChnelNode->server_id = iChnelId;
    pNewChnelNode->pNextCnNode = NULL;
    pNewChnelNode->bIsCardIniting = FALSE;
    pNewChnelNode->IsPpp = FALSE;
    pNewChnelNode->IsCmdStored = FALSE;
    
    zAti_InsertNodeInSortingAscend(pNewChnelNode);
    
    return ZATI2_SUCCESS;
}

/**************************************************************************
*  : zAti_Close
*  : رͨ
* ˵ : (IN)
*            iChnelId     ͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : 
*            ṩûӿ
*            ǰɽͨĿǹرͨ
**************************************************************************/
SINT32 zAti2_Close(UINT8 iChnelId)
{
    if( g_zAti_Context.taskStatus != ZATI2_TASK_STATUS_READY
        || !zAti_IsValidChnelId(iChnelId) 
        || ZATI2_SUCCESS != zAti_GetChannelNode(iChnelId)       // ͨδ 
        || g_zAti_ptData->tAtChnelList.iCount == 0
        || g_zAti_Context.mutexOpenChnel == NULL
        )
    {
         return ZATI2_FALSE;
    }

    if(ZOSS_SUCCESS == zOss_GetMutex(g_zAti_Context.mutexOpenChnel, ZOSS_WAIT_FOREVER))
    {
        zAti_DelChannelInList(iChnelId);
        if(ZOSS_SUCCESS == zOss_PutMutex(g_zAti_Context.mutexOpenChnel))/* ͷŻ */
        {
            return ZOSS_SUCCESS;
        }  
    }       

    return ZATI2_FALSE;
}

/**************************************************************************
*  : zAti_DelChannelInList
*  : ͨɾ
* ˵ : (IN)
*            iChnelId     ҪɾĿͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ͨţɾرͨʱʹ
**************************************************************************/
SINT32 zAti_DelChannelInList(UINT8 iChnelId)
{
    T_ZAti_ChannelInfo *pTargetChnelNode = NULL; /* ½ */
    T_ZAti_ChannelInfo *pTempChnelNode = NULL; /* ½ */   

    pTempChnelNode = NULL; /* һη */
    pTargetChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;
    
    while(pTargetChnelNode != NULL)
    {
        if(pTargetChnelNode->iChnelId == iChnelId) /* ҵ */
        {
            if(NULL == pTempChnelNode)
            {
                g_zAti_ptData->tAtChnelList.pChnelNode = pTargetChnelNode->pNextCnNode; /* ĵһ */
            }
            else
            {
                pTempChnelNode->pNextCnNode = pTargetChnelNode->pNextCnNode;
            }           

            g_zAti_ptData->tAtChnelList.iCount = g_zAti_ptData->tAtChnelList.iCount - 1;
           
            zOss_Free(pTargetChnelNode);
            pTargetChnelNode = NULL;
            return ZATI2_SUCCESS;
        }

        pTempChnelNode = pTargetChnelNode;
        pTargetChnelNode = pTargetChnelNode->pNextCnNode;
    }

    return ZATI2_FALSE;
}

/**************************************************************************
*  : zAti_RegRecvCb
*  : עص
* ˵ : (IN)
*            recvFunc     ص
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشԭ
* ˵ : ṩûӿ
*            ָtypedef SINT32 (*T_ZAti2_AtRecvFunc)(UINT8 channelId,
*            UINT8* pDataPtr, UINT16 iDataLen, UINT8 iFlag);
**************************************************************************/
SINT32 __ps_static_func zAti2_RegRecvCb(T_ZAti2_AtRecvFunc recvFunc)
{
    if(NULL == recvFunc)
    {
        return ZATI2_FALSE;
    }
    else
    {
        g_zAti_Context.sendFnc = recvFunc;
        return ZATI2_SUCCESS;
    }
}

/**************************************************************************
*  : zAti2_AtChannelFunc
*  : עص
* ˵ : (IN)
*            recvFunc     ص
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشԭ
* ˵ : ṩûӿ
**************************************************************************/
SINT32 zAti2_AtChannelFunc(T_zAti_AtChannelFunc pChannelFunc)
{
    g_zAti_Context.pUsolChannelFunc = pChannelFunc;
    return ZATI2_SUCCESS;
}

/**************************************************************************
*  : zAti2_SetAlwaysAtReportChannel
*  : ʼϱATͨעصصרͨš
*           רͨЧʱϱǷ/Ӱ죬ڴͨϱ
* ˵ : (IN)
*            pChannelFunc - صصרͨš      
*   ֵ :
* ˵ : ṩοƵĺӿ
**************************************************************************/
SINT32 zAti2_SetAlwaysAtReportChannel(T_zAti_AtChannelFunc pChannelFunc)
{
    g_zAti_Context.pAlwaysReportChnel = pChannelFunc;
    return ZATI2_SUCCESS;
}

/**************************************************************************
*  : zAti_Switch
*  : лͨ״̬CS̬лΪ̬
* ˵ : (IN)
*            iChnelId     ͨID
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷZATI2_FALSE
* ˵ : ṩûӿ,֧CS̬л
*            ܽͨ
*            ͬһܹͨر
**************************************************************************/
SINT32 __ps_static_func zAti_Switch( T_ZAti_ChannelInfo *pChannelNode, T_zAti2_CtrmChInd iFlag)
{
    if(iFlag == ZATI2_CHIND_TURN_AT)
    {
/*        if(ZATI2_CHANNEL_MODE_DATA == pChannelNode->server_mode)
        {
            pChannelNode->server_mode = ZATI2_CHANNEL_MODE_CMD;
            pChannelNode->dataType = ZATI2_CHANNEL_DATA_TYPE_INVAL; 
        } */
        zAti_UsbSioDeactiveByAtiReq(pChannelNode->iChnelId);
        return ZATI2_SUCCESS;
    }
    else if(iFlag == ZATI2_CHIND_TURN_PSD)
    {
        pChannelNode->server_mode = ZATI2_CHANNEL_MODE_DATA;
        pChannelNode->dataType = ZATI2_CHANNEL_DATA_TYPE_PS; 
        return ZATI2_SUCCESS;
    }
    else if(iFlag == ZATI2_CHIND_TURN_CSD)
    {
        pChannelNode->server_mode = ZATI2_CHANNEL_MODE_DATA;
        pChannelNode->dataType = ZATI2_CHANNEL_DATA_TYPE_CSD; 
        return ZATI2_SUCCESS;
    }
    else
    {
        return ZATI2_FALSE;
    }
}

/**************************************************************************
*  : zAti_Send
*  : ͨͨAT
* ˵ : (IN)
*            iChnelId     ص
*            pDataPtr      ָ
*            iDataLen      ݳ
*            iFlag         
*            (OUT)
*   ֵ : ɹZATI2_SUCCESSʧܷشԭ
* ˵ : ṩûӿ
*            ATIʱṩýӿ
*            ڴ(MUX)ģʽ£Ҫûصʽע 
*            616000270082Ż߶ϿŹг
**************************************************************************/
SINT32 __ps_static_func zAti2_Send(UINT8 iChnelId, UINT8 *pDataPtr, UINT16 iDataLen, T_zAti2_CtrmChInd iFlag)
{
    T_ZAti_ChannelInfo *pChnelNode = zAti_GetChannelNodePtr(iChnelId);     
    if(NULL == pChnelNode) /* ͨûд */
    {
        return ZATI2_CHANNEL_ID_ERROR;
    }

    if(iFlag >= ZATI2_CHIND_TURN_AT)
    {
        return zAti_Switch(pChnelNode, iFlag);
    }

    if((NULL == pDataPtr) || (0 == iDataLen))
    {
        return ZATI2_FALSE;
    }

    if((ZATI2_CHANNEL_MODE_CMD == pChnelNode->server_mode) && 
        (ZATI2_CHIND_PSD == iFlag || ZATI2_CHIND_PSDV6 == iFlag ||ZATI2_CHIND_CSD == iFlag))
    {
        return ZATI2_FALSE;/*ɿƹͷ*/
    }

    if(ZATI2_CHANNEL_MODE_DATA == pChnelNode->server_mode && ZATI2_CHIND_AT == iFlag)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,""); 
        return ZATI2_FALSE;
    }

    if((ZATI2_CHANNEL_MODE_CMD == pChnelNode->server_mode) && (iDataLen <= ZATI2_BUFFER_LENGTH)) /* ״̬ */
    {
        T_ZAti_ChannelDataBuf *precvCmdInd = (T_ZAti_ChannelDataBuf *)zAti_GetUB(sizeof(T_ZAti_ChannelDataBuf));
        precvCmdInd->iChannel = iChnelId;
        precvCmdInd->iDataLen = iDataLen;
        zOss_Memcpy(precvCmdInd->strData, pDataPtr, iDataLen);

        zOss_TaskSend(EV_ZATI2_RECV_COMMAND_IND, precvCmdInd, sizeof(T_ZAti_ChannelDataBuf), g_zAti_Context.taskIdMy);
        zAti_RetUB((VOID**)&precvCmdInd);
    }
    else if(ZATI2_CHANNEL_MODE_DATA == pChnelNode->server_mode)
    {
        if(ZATI2_CHANNEL_DATA_TYPE_CSD == pChnelNode->dataType)
        {
            #ifndef CONFIG_SINGLECORE
            /*  ͵CSD */
            zAti_CsdUpDataRecv(iChnelId, iDataLen, pDataPtr);
            #endif
        }
        else if(ZATI2_CHANNEL_DATA_TYPE_PS == pChnelNode->dataType)
        {
            /* ͵PSD */
            zAti_PsiDataReqProc(iChnelId, pDataPtr, iDataLen, (BOOL)(iFlag == ZATI2_CHIND_PSDV6)); /* װϢ͵TAF/PDI */
        }
        else
        {
            return ZATI2_FALSE;
        }
    }
    else
    {
        return ZATI2_FALSE;
    }

    return ZATI2_SUCCESS;
}
#ifdef USE_VOICE_SUPPORT
/**************************************************************************
* ƣ zAti_GetCallControlMsg
*  жϵǰǷΪCCϢ
* ˵ (IN) 
*            iEvId          ϢID
*            (OUT)
*   ֵ CCϢTRUEFALSE;
* ˵ ͳһCCϢֹЭջ޸CCϢֵҲϢ
*            if((iEvId >= ZPS_ApMmia_CcSetupCnf_Ev) && 
*               (iEvId <= ZPS_ApMmia_CcProcInfoInd_Ev)) ȡ
**************************************************************************/
BOOL __ps_static_func zAti_GetCallControlMsg(UINT32 iEvId)
{
    switch(iEvId)
    {
        case MMIA_CC_ANS_MODE_REQ_EV:            
        case MMIA_CC_MODIFY_REQ_EV:            
        case MMIA_CC_DIS_MODE_REQ_EV:              
        case EV_ZATI2_DTMF_REQ:
                return TRUE;
                
        default:
                return FALSE;
        }
}

/**************************************************************************
*  : zAti_GetCallControlChannelId
*  : ͨŻͨ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            (OUT)
*   ֵ : ɹͨţʧܷشͣ 
* ˵ : 1) Ҫƽ̨ATI֤ͨʹõȷ  
*            2) ͨţҵͷЧͨţΪЧͨ 
*            3) MMIAԴſܷЧֵ0xffCCϢʱ
*            4) PS_CCԴŲǹ̶ӳ䣬ǰ˳ѡԴŵ
*            5) ҪMMIAԴЧԽжϣ򵱲䷵0xffΪԴ
*            6) ͨ󣬲MMIAԴ/ĿŽϵ(1)
**************************************************************************/
T_ZAti_ChannelId zAti_GetCallControlChannelId(UINT8 *pDataPtr, UINT16 iDataLen)
{
    UINT8                   iCcNum = 0;
    BOOL                     bSuccessFind = FALSE;
    T_zMmiaCc_CallStateInd  *ptApInd = (T_zMmiaCc_CallStateInd *)pDataPtr;
    
    for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++)
    {
        if(g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iXid == ptApInd->bCallId)
        {
            if(ptApInd->bCallState ==  ZATI2_CALL_STATE_NULL)
            {
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex = ZATI2_INVAL_MMIA_INDEX;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex = ZATI2_INVAL_MMIA_INDEX;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState = ZATI2_CALL_STATE_NULL;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iXid = ZATI2_INVAL_MMIA_INDEX;
            }
            else
            {
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex = ptApInd->bDesIndex;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex = ptApInd->bSrcIndex;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState = ptApInd->bCallState;
            }
            bSuccessFind = TRUE;
            break;  /* SETUP_CNFֻܶӦһԴĿţbreak */
        }
    }
    if(!bSuccessFind)
    {
        for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++)
        {
            if(g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iXid == ZATI2_INVAL_MMIA_INDEX)
            {
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex = ptApInd->bDesIndex;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex = ptApInd->bSrcIndex;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState = ptApInd->bCallState;
                g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iXid = ptApInd->bCallId;
                break;  /* SETUP_CNFֻܶӦһԴĿţbreak */
            }
        }
    }

    return (T_ZAti_ChannelId)ptApInd->bDesIndex;
}
#endif
///---------------յģ Ϣ

/**************************************************************************
*  : zAti_GetNonReportMsgIdx
*  : ȡϱϢ±
* ˵ (IN) 
*            dwMsgId      Ϣ
*            (OUT)
*             pMsgIdx   : ԤϢе±
*   ֵ ҵZ_SUCC,  ûҵZ_FAIL
* ˵ 
**************************************************************************/
BYTE __ps_static_func zAti_GetNonReportMsgIdx(DWORD dwMsgId, WORD *pMsgIdx)
{
    WORD wTabIdx = 0;

    for (wTabIdx = 0; wTabIdx < (sizeof(g_zAti_NonReportMsgTable) / sizeof(T_zAti_NonReportMsg)); wTabIdx++)
    {
        if(g_zAti_NonReportMsgTable[wTabIdx].iMsgId == dwMsgId)
        {
            *pMsgIdx = wTabIdx;
            return Z_SUCC;
        }
    }
    return Z_FAIL;
}

/**************************************************************************
*  : zAti_PreProcMsg
*  : ±괦ϱϢ, 
* ˵ (IN) 
*            wAtMemCnfMsgIdx:      Ϣ±
*            pbMsgBody           :     Ϣ
 *           wMsgLen              :     Ϣ
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_ProcNonReportMsg(WORD wAtMemCnfMsgIdx, BYTE *pbMsgBody, WORD wMsgLen)
{
    g_zAti_NonReportMsgTable[wAtMemCnfMsgIdx].pEndFnc(pbMsgBody) ;
    return;
}

/**************************************************************************
*  : zAti_GetPreMsgIdx
*  : ȡԤϢ±
* ˵ (IN) 
*            dwMsgId      Ϣ
*            (OUT)
*             pMsgIdx   : ԤϢе±
*   ֵ ҵZ_SUCC,  ûҵZ_FAIL
* ˵ 
**************************************************************************/
BYTE __ps_static_func zAti_GetPreMsgIdx(DWORD dwMsgId, WORD *pMsgIdx)
{
    WORD wTabIdx = 0;    
    for (wTabIdx = 0; wTabIdx < sizeof(atPreOuterMsg) / sizeof(T_zAti_PreOuterMsgTab); wTabIdx++)
    {
        if(atPreOuterMsg[wTabIdx].dwMsgId== dwMsgId)
        {
            *pMsgIdx = wTabIdx;
            return Z_SUCC;
        }
    }
    return Z_FAIL;
}

/**************************************************************************
*  : zAti_PreProcMsg
*  : ±ԤϢ, 
* ˵ (IN) 
*            wDistributeMsgIdx:      Ϣ±
*            pbMsgBody           :     Ϣ
 *           wMsgLen              :     Ϣ
*            (OUT)pdwChangedMsgId  : ޸ĺmsgID
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_PreProcMsg(WORD wPreMsgIdx, BYTE *pbMsg, WORD wMsgLen, DWORD * pdwChangedMsgId,  T_ZAti_ChannelInfo  *pChnelNode)
{    
    DWORD dwErrorType = atPreOuterMsg[wPreMsgIdx].pPreHandleMsg(pbMsg, pdwChangedMsgId, pChnelNode);
    if ( dwErrorType == Z_APMMIA_NORESULT )
    {
         // ԤɹҪһ˴ʲô
    }
    else if( dwErrorType == Z_APMMIA_NOERROR_ERR)
    {
        // ɹֱӻظOK
        // ÷֧ӦΪconfirm Ϣ
        if(pChnelNode != NULL)
        {
            zAti_ReplyOK( pChnelNode);
            zAti_RemoveOneCmd(pChnelNode); 
            zAti_DecMultiCmd(pChnelNode);
        }
    }
    else
    {
        //  
        if(pChnelNode != NULL)
        {
            zAti_ProcError(pChnelNode, dwErrorType);
        }
    }
    return;
}

/********************************* LTE GoTa *******************************/
/**************************************************************************
*  : zAti_IsAlreadyReply
*  : жǷѾֱӻظӦϢ
* ˵ (IN) 
*        
*            (OUT)
*   ֵ true,false
* ˵ Ⱥں,ѾظϢ
*                            յӦʱͲҪͨ
**************************************************************************/
BOOL __ps_static_func zAti_IsAlreadyReply(DWORD dwMsgId)
{
    /*ѾظOK*/
    switch (dwMsgId)
    {
    case MMIA_CC_DISC_CNF_EV:
    case MMIA_CC_ANS_MODE_CNF_EV:
    case MMIA_CC_MOC_CNF_EV:
        return TRUE;
    default:
        break;
    }
    
    return FALSE;

}
#ifdef USE_VOICE_SUPPORT
VOID zAti_DeliverZredialEndInd(BYTE bCallId)
{
    UINT16  strLen=0;
    CHAR *pStrCmd = NULL;

    pStrCmd = (CHAR *)zAti_GetUB(ZAT2_SHORT_CMD_LEN);

    /*+ZREDIALEND: <callid>*/
    sprintf((char *)pStrCmd, "%s+ZREDIALEND: %d%s", g_zAt_CRLF, bCallId, g_zAt_CRLF);
    strLen = (UINT16)strlen((const char *)pStrCmd);

    zAti_DeliverAllMsg(AP_MMIA_REDIALEND_IND_EV, pStrCmd, strLen);

    zAti_RetUB((VOID **)&pStrCmd);
    return;
}
#endif
/**************************************************************************
* ƣ zAti_ProcReportMsg
*  ϱһϢ indcnf
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_ProcReportMsg(DWORD dwMsgId, BYTE *pbMsgBody, WORD wMsgLen, T_ZAti_ChannelInfo  *pChnelNode)
{
    CHAR                    *pEncodeCmd = NULL;
    UINT16                  iEncodeCmdLen = 0;
    T_ZAt2_CmdIdType             cmd_id = ZAT2_NO_COMMAND;         /* ǰ   */
    T_ZAt2_CmdOpType             cmd_op = ZAT2_CO_INVALID;         /* ״̬     */
    
    /*  1, ǿͨѾظԪֱӷ
         2,  ͨϱϢֱӷ
      */
     if(pChnelNode != NULL)
     {
         if(!zAti_HandleCnfMsgBeforeEncCmd(dwMsgId, pbMsgBody, wMsgLen, pChnelNode))
         {
             return;
         }
         cmd_id = pChnelNode->cmd_id;
         cmd_op = pChnelNode->cmd_op;
     }

    // ... 迼ͨʲôʱ
    iEncodeCmdLen = zAt_EncCmd(dwMsgId, pbMsgBody, &pEncodeCmd, &cmd_id, &cmd_op);
    if(iEncodeCmdLen == 0)
    {
        return;
    }

    if(dwMsgId == AP_MMIA_SM_CONNECT_IND_EV  && pChnelNode != NULL)
    {
        // sm̬ͨϱ̬
        zAti_SendSmConnectInd(pbMsgBody,pEncodeCmd, iEncodeCmdLen, pChnelNode);
    }
    else if(zAti_IsIndiCateCnfMsg(dwMsgId, pbMsgBody) ||zAti_IsDeliverAllMsg(dwMsgId)) //(ZATI2_CHANNEL_ID_NUMALL == channelId) /* Ⱥ */
    {
#ifdef USE_VOICE_SUPPORT
        if(dwMsgId == AP_MMIA_CEND_IND_EV && pChnelNode != NULL)  
        {
            // δҵǰͨΪգʱлͨ
            //Ҷϵ绰̬ͨϱ
            zAti_HandleCcDiscInd(pChnelNode);
        }
#endif
        zAti_DeliverAllMsg(dwMsgId, pEncodeCmd, iEncodeCmdLen);   
#ifdef USE_VOICE_SUPPORT
        if( dwMsgId == AP_MMIA_CONN_IND_EV && pChnelNode != NULL)
        {
            // ͨ绰ϱе̬
            zAti_SendConnInd(pbMsgBody, pEncodeCmd, iEncodeCmdLen, pChnelNode);//617001776023 lxh 10.09
        }
#endif
        if(dwMsgId == MMIA_SM_PDP_ACTIVATE_IND_EV)
        {
            // ϱϢ
            T_zDev_AtMem_SM_AutoRsp tAtData    = {0};
            T_zApMmia_SmMtActAns_Req tApAnsReq = {0};
            T_zMmiaSm_PdpAct_Ind *pSmMtActInd = (T_zMmiaSm_PdpAct_Ind*)pbMsgBody;
            zDev_AtMemReadItem(Z_AtMem_ID_AutoRsp, 0, (PBYTE)&tAtData, g_zAti_CurInstance);    
            if(zAti_GetMtAutoAnsMsg(pSmMtActInd->tPdpAddr.bPdpType, (PBYTE)&tAtData, &tApAnsReq))
            {
                zAti_SendSmAnsReq(&tApAnsReq);
            }
        }
#ifdef USE_VOICE_SUPPORT
        if (dwMsgId == MMIA_CC_CALL_STATE_IND_EV)
        {
            T_zMmiaCc_CallStateInd *pDsciInd = (T_zMmiaCc_CallStateInd*)pbMsgBody;
            if ((pDsciInd->bCallState == Z_MMIACC_CALL_STATE_END) && (pDsciInd->bReialFlag == 1))
            {
                zAti_DeliverZredialEndInd(pDsciInd->bCallId);
            }
        }
#endif
    }
    else
    {
        /* ͨΪջ²ҪϱϢ,. ˴ֻcnfϢ*/
        if(!(pChnelNode == NULL || zAti_IsDeliverMsgByPower(dwMsgId)))
        {
            zAti_SendEncData(pChnelNode, (BYTE *)pEncodeCmd, dwMsgId, pbMsgBody);

            /*мϢʱյϢʱٴ*/
            if(!(zAti_IsIntermediateMsg(dwMsgId, pbMsgBody) || zAti_IsAlreadyReply(dwMsgId)))
            {
                pChnelNode->cmd_id = ZAT2_NO_COMMAND;
                pChnelNode->cmd_op = ZAT2_CO_INVALID;
                zAti_RemoveOneCmd(pChnelNode);
                zAti_DecMultiCmd(pChnelNode);
            }
        }
    }
    zAti_RetUB((VOID **)&pEncodeCmd); 
    return;
}

/**************************************************************************
* ƣ zAti_CheckRecvMsg
*  յϢг
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            (OUT)
*   ֵ ϷZ_SUCC򷵻Z_FAIL
* ˵ 
**************************************************************************/
static BYTE __ps_static_func zAti_CheckRecvMsg(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen)
{
    if(ZATI2_TASK_STATUS_READY != g_zAti_Context.taskStatus)
    {
        return Z_FAIL; /* ATI2δ񱻹رգ´ */
    }

    /* (SM)MT󼤻ǰΪϢ */
    /* 617002476772 ԿϢ©MMIA_CC_CLOSE_VOICE_CHNL_IND_EV--hyc-- */
    /* 617002487393- ˫UEСԼѡCCOϢϱͳһZCATӿʵ--hyc-- */

    if(iEvId == MMIA_SM_IDLE_CHNL_QUERY_IND_EV  ||
       iEvId == MMIA_UMM_UPDATE_DUALPSSYSCONFIG_IND_EV ||
       iEvId == MMIA_CC_DUALPSCFG_IND_EV ||
       iEvId == MMIA_UMM_IMSNOTSUPPORT_IND_EV ||
       iEvId == MMIA_UMM_CS_CALL_START_IND_EV ||
       iEvId == MMIA_UMM_CS_CALL_END_IND_EV)
    {
        return Z_SUCC;
    }
    if((NULL == pDataPtr) || (0 == iDataLen)) /* ЭջӦϢΪ */
    {
        return Z_FAIL;
    }
    return Z_SUCC;
}

BOOL __ps_static_func zAti_IsPreProcIndMsg(UINT32 iEvId)
{
    /* ҪԤϱϢ*/
    switch(iEvId)
    {  
    case MMIA_UMM_PLMN_INFO_IND_EV:
    case MMIA_CC_MTC_IND_EV:
    case AP_MMIA_SM_MEM_AVAIL_IND_EV:
 
    case MMIA_SM_CONNECT_IND_EV:
    case AP_UICC_UICCOK_IND_EV:
    case MMIA_CBS_DATA_IND_EV:
    case MMIA_SMS_DELIVER_REC_IND_EV:
    case MMIA_SMS_STATUS_REC_IND_EV:
    case MMIA_CC_SS_NOTIFY_IND_EV: 
    case MMIA_CC_DISC_IND_EV:
    case MMIA_CC_PROC_INFO_IND_EV:
    case AP_MMIA_PB_INIT_COMP_IND_EV:

    /* ϢȻzAti_IsDeliverAllMsg,Ϊ˲g_ZAti_PowerIndFlagӰ,Ҫ*/
    case AP_UICC_SLOT_IND_EV:
    case MMIA_UMM_MM_INFO_IND_EV:

    case AP_MMIA_SM_SAVE_CNF_EV:
    case AP_UICC_INIT_CNF_EV:
    case AP_UICC_INIT_IND_EV:
    case AP_UICC_COMMON_CNF_EV:
    case MMIA_UMM_RF_CTRL_CNF_EV:
    case MMIA_L1E_ZEPCG_CNF:
    case MMIA_AS_LBS_CNF_EV:
    case MMIA_CC_DISC_CNF_EV:
    case MMIA_CC_ANS_MODE_CNF_EV:
        return TRUE;

    default:
        break;
    }    
    
    return FALSE;
}

BOOL __ps_static_func zAti_EmInfoQryCnfDesIndexIsInvaildProc(DWORD dwMsgId, BYTE *pbMsgBody)
{
    /*ģʽѯĿΪЧ0255˵ǵúӿڴĻȡ*/
    if ((AS_QUERY_EM_CELL_INFO_CNF_EV == dwMsgId) && ((((T_zEM_EmInfo_Ind*)pbMsgBody)->bDesIndex == 0) || (((T_zEM_EmInfo_Ind*)pbMsgBody)->bDesIndex == 0xff)))
    {
        zAti_GetEmInfoMutex(g_zAti_CurInstance);

        if (g_zAti_EmInfo[g_zAti_CurInstance].ptEmInfo != ZOSS_NULL)
        {
            zOss_Memcpy(g_zAti_EmInfo[g_zAti_CurInstance].ptEmInfo, pbMsgBody, sizeof(T_zEM_EmInfo_Ind));
        }

        zAti_DecreaseReqCountAndRelMutexSemaphore();

        return TRUE;
    }
    return FALSE;
}
/**************************************************************************
* ƣ zAti_RecvServerHandlerSlaver
*  ΪATI2(ЭջATI)Ϣ
* ˵ (IN) 
*            iEvId          ϢID
*            pDataPtr       
*            iDataLen       ݳ
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
VOID __ps_static_func zAti_RecvServerHandlerSlaver(DWORD dwMsgId, BYTE *pbMsgBody, WORD wMsgLen)
{
    WORD    wIdx  = 0;   // ȡϢ
    if(zAti_CheckRecvMsg(dwMsgId,pbMsgBody, wMsgLen) == Z_FAIL)
    {
        zAti_RetUB((VOID **)&pbMsgBody); 
        return;
    }

    if (zAti_EmInfoQryCnfDesIndexIsInvaildProc(dwMsgId, pbMsgBody))
    {
        zAti_RetUB((VOID **)&pbMsgBody);
        return;
    }
    // ȡͨʧܣֱӷأ
    // ϱϢATmemͨϢ
    if (zAti_GetNonReportMsgIdx(dwMsgId , &wIdx) == Z_SUCC)
    {
        zAti_ProcNonReportMsg(wIdx , pbMsgBody, wMsgLen);
    }
    else // ϱϢ
    {
        T_ZAti_ChannelInfo  *pChnelNode = zAti_GetChnelNode(dwMsgId,pbMsgBody, wMsgLen);
        if(pChnelNode == NULL && !zAti_IsDeliverAllMsg(dwMsgId))
        {
            if (!zAti_IsPreProcIndMsg(dwMsgId))
            {
                /* 617002487414 [V3.3.10B02] ATIMMIA_SMS_REC_RSP_CNF_EVδͷڴ*/
                 zAti_RetUB((VOID **)&pbMsgBody);
                 return;
            }
        }

        if (zAti_GetPreMsgIdx(dwMsgId , &wIdx) == Z_SUCC)
        {
            DWORD dwChangedMsgId = ZATI_INVALID_MSGID;
            zAti_PreProcMsg(wIdx , pbMsgBody, wMsgLen, &dwChangedMsgId, pChnelNode);
            dwMsgId = dwChangedMsgId;
        }

        /*  ҪԤԤɹҪһ*/
        if(dwMsgId != ZATI_INVALID_MSGID)
        {
            zAti_ProcReportMsg(dwMsgId,pbMsgBody, wMsgLen, pChnelNode);
        }
    }

    // Ϣͷţֻһ
    zAti_RetUB((VOID **)&pbMsgBody);
    return;
}
#ifdef Z_DUALCARD_ADAPT
VOID zAti_ClearSelfAdaptGlobVar(BYTE bInsNo)
{
    g_zAti_atDataEx[bInsNo].IsCfgChging = FALSE;
    g_zAti_atDataEx[bInsNo].IsFlymode = FALSE;
    g_zAti_atDataEx[bInsNo].IsNeedOutFlymode = FALSE;
}
#endif
/*******************************************************************
*:zAti_IsCurrStackInFlymode
*:жϵǰǷδƵ
*˵:
*******************************************************************/
BOOL zAti_IsStackInRfClose(BYTE bInsNo)
{
    if(Z_APMMIA_CFUNFUN_DISBOTHRF == g_zAti_atDataEx[bInsNo].tFun.bRfVal ||
            Z_APMMIA_CFUNFUN_MINIFUN == g_zAti_atDataEx[bInsNo].tFun.bRfVal)
    {
        return TRUE;
    }
    return FALSE;
}
#ifdef Z_DUALCARD_ADAPT 
VOID zAti_GetStackIntoFlymode(BYTE bInsNo)
{
    if(zAti_IsStackInRfClose(bInsNo))/*ѾǹƵ״̬*/
    {
        g_zAti_atDataEx[bInsNo].IsFlymode = TRUE;
    }
    else
    {
        zAti_SendCfunSetReq(Z_APMMIA_CFUNFUN_DISBOTHRF, bInsNo);
    }
    return;
}

/*************************************************
*:zAti_NeedChangeInNoChange
*:ûʱյҪ
*************************************************/
VOID zAti_NeedChangeInNoChange(VOID)
{
    if(zAti_IsCmdChnelIdIdel(Z_ATI_INSNO_1))
    {
        g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging = TRUE;
        /*Ҫûسʼ̬µ״̬*/
        zAti_IndicatCfgStart(); /*ϱ+ZPSCFGSTART*/
        zNas_SetEventStart(Z_ATI_INSNO_1, Z_ATI_EVENT_CARD_CONFIG);
        zAti_GetStackIntoFlymode(Z_ATI_INSNO_1);
    }

    if(zAti_IsCmdChnelIdIdel(Z_ATI_INSNO_2))
    {
        /*Ҫûسʼ̬µ״̬*/
        g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging = TRUE;
 
        if(!g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging) /*ظϱ*/
        {
            zAti_IndicatCfgStart();
            zNas_SetEventStart(Z_ATI_INSNO_2, Z_ATI_EVENT_CARD_CONFIG);
        }

        zAti_GetStackIntoFlymode(Z_ATI_INSNO_2);
    }
    /*δƵֱ^SYSCONFIG*/
    if(g_zAti_atDataEx[Z_ATI_INSNO_1].IsFlymode && 
        g_zAti_atDataEx[Z_ATI_INSNO_2].IsFlymode)
    {
        zAti_ExchangeSysconfig();
        zAti_IndicatCfgEnd(); /*ϱ+ZPSCFGEND*/
        g_zAti_ptData->bNeedChgFg = Z_NO_NEED_CHANGE;
        zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_1);  /*ȫ*/
        zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_2);  /*ȫ*/
    }
    return;
}

/*************************************************************************
*:zAti_NeedChangeInSingleCfgChanging
*:жϴǷͨжû
*˵:˺ǴһͨжһԼ
*ٴյNEEDCFGʱһһû
*************************************************************************/
VOID zAti_NeedChangeInSingleCfgChanging(VOID)
{
    if(zAti_IsCmdChnelIdIdel(Z_ATI_INSNO_1) && 
    !g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging)
    {
        g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging = TRUE;
        zAti_GetStackIntoFlymode(Z_ATI_INSNO_1);
    }

    if(zAti_IsCmdChnelIdIdel(Z_ATI_INSNO_2) &&
    !g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging)
    {
       g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging = TRUE;
       zAti_GetStackIntoFlymode(Z_ATI_INSNO_2);
    }

    /*δƵֱ^SYSCONFIG*/
    if(g_zAti_atDataEx[Z_ATI_INSNO_1].IsFlymode && 
        g_zAti_atDataEx[Z_ATI_INSNO_2].IsFlymode)
    {
        zAti_ExchangeSysconfig();
        zAti_IndicatCfgEnd(); /*ϱ+ZPSCFGEND*/
        g_zAti_ptData->bNeedChgFg = Z_NO_NEED_CHANGE;
        zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_1);  /*ȫ*/
        zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_2);
    }
    return;
}
/*************************************************************
*:zAti_NoNeedChangeInSingleCfgChanging
*:һʱյNONEEDCFG
*ԭ:ǰSYSCONFIG϶ûжǷҪ
*ģʽ,Ҫ,
**************************************************************/
VOID zAti_NoNeedChangeInSingleCfgChanging(VOID)
{
    BYTE bInsNo = 0;
    if(g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging)
    {
        bInsNo = Z_ATI_INSNO_1;
    }
    else
    {
        bInsNo= Z_ATI_INSNO_2;
    }

    if(g_zAti_atDataEx[bInsNo].IsFlymode)
    {
        if(g_zAti_atDataEx[bInsNo].IsNeedOutFlymode)/*ATIķģʽ*/
        {
            g_zAti_ptData->IsOutFlymodeIng = TRUE;
            zAti_SendCfunSetReq(Z_APMMIA_CFUNFUN_FULLFUN, bInsNo);
        }
        else /*δƵ*/
        {
            zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_1);  /*ȫ*/
            zAti_ClearSelfAdaptGlobVar(Z_ATI_INSNO_2);
            zAti_IndicatCfgEnd(); /*ϱ+ZPSCFGEND*/
        }
    }
    return;
}
/************************************************************
*:zAti_NoNeedChangeInDualChanging
*:յNONEEDCFGĴ
*************************************************************/
VOID zAti_NoNeedChangeInDualChanging(VOID)
{
    BYTE bAnothInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;

    if(g_zAti_atDataEx[bAnothInsNo].IsFlymode && g_zAti_atDataEx[g_zAti_CurInstance].IsFlymode)
    {
        zAti_OutFlymodeInSelfAdapt();/*ģʽٴ*/
        g_zAti_ptData->IsOutFlymodeIng = TRUE;/*ʱһҪģʽ*/
    }
    return;
}
/************************************************************
*:zAti_NeedChangeInDualChanging
*:ģʽģʽ
*************************************************************/
VOID zAti_NeedChangeInDualChanging(VOID)
{
    BYTE bAnothInsNo = (g_zAti_CurInstance == Z_ATI_INSNO_1)? Z_ATI_INSNO_2: Z_ATI_INSNO_1;

    if(g_zAti_atDataEx[bAnothInsNo].IsFlymode && g_zAti_atDataEx[g_zAti_CurInstance].IsFlymode)
    {
        zAti_ExchangeSysconfig();
        zAti_OutFlymodeInSelfAdapt();
        g_zAti_ptData->bNeedChgFg = Z_NO_NEED_CHANGE;
        g_zAti_ptData->IsOutFlymodeIng = TRUE;
    }
    return;
}

/*********************************************************************************************************************************
*:zAti_HandleDualCardChange
*:˫˫ģʽ˫Ӧ
*ԭ:
* 1)ûٴյNEEDCFG
* 2)ûٴյNONEEDCFG˵ûҲ봦
* 3)ٴյNONEEDCFGҽһ,ѾģʽֱӸģʽ,
*     ûнģʽ˵ڽģʽյӦýģʽڴ˴
*4)ٴյNEEDCFGҽһ,SYSCONFIGδ·,
*5)ǰڳģʽյκNEEDCFGı־¼һ,ģʽٴ
*6)ٴյNEEDCFGδڳģʽ,˵ǰһڽģʽ
*    Ĺ,ǰSYSCONFIGҲûд,.
*7)ٴյNONEEDCFGδڳģʽ,˵һڴڽģʽ
*    Ĺ,ģʽٽSYSCONFIG,ֱӳģʽ
******************************************************************************************************************************  */
VOID zAti_HandleDualCardSelfAdapt(VOID)
{
    if(g_zAti_ptData->IsOutFlymodeIng)
    {
        return;/*ģʽвκδ*/
    }
    /*û䵫Ҫ*/
    if(Z_NEED_CHANGE == g_zAti_ptData->bNeedChgFg &&
    !g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging && !g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging)
    {
        zAti_NeedChangeInNoChange();
    }
    /*ֻһһͨжû
        ֻһٴյҪ*/
    else if(Z_NEED_CHANGE == g_zAti_ptData->bNeedChgFg && 
    g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging != g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging)
    {
        zAti_NeedChangeInSingleCfgChanging();
    }
    /*ֻһյ*/
    else if(Z_NO_NEED_CHANGE == g_zAti_ptData->bNeedChgFg &&
    g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging != g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging)
    {
        zAti_NoNeedChangeInSingleCfgChanging();
    }
    /*յ*/
    else if(Z_NO_NEED_CHANGE == g_zAti_ptData->bNeedChgFg &&
    g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging && g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging)
    {
        zAti_NoNeedChangeInDualChanging();
    }
    /*еȫзģʽ󽻻SYSCONFIGģʽ*/
    else if(Z_NEED_CHANGE == g_zAti_ptData->bNeedChgFg && 
    g_zAti_atDataEx[Z_ATI_INSNO_1].IsCfgChging && g_zAti_atDataEx[Z_ATI_INSNO_2].IsCfgChging)
    {
        zAti_NeedChangeInDualChanging();
    }
    return;

}
#endif
VOID zAti_EncOKError(BOOL bResult)
{
    if (bResult)
    {
        sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
    }
    else
    {
        sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF,g_zAt_CRLF);
    }
    return;
}

/**************************************************************************
* ƣ zAti_ZpodwReqProc
*  ûAT+ZPODW
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ +ZPODW: <bResult> (including two reasons)
**************************************************************************/  
DWORD zAti_ZpodwReqProc(VOID *pDataPtr)
{
    zAti_EncOKError((BOOL)(DRV_SUCCESS == zDrv_ShutDown()));
    return Z_APMMIA_NOERROR_ERR;
}

/**************************************************************************
* ƣ zAti_BoardnumReqProc
*  ûAT+BOARDNUM
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ +BOARDNUM: <bResult> (including two reasons)
**************************************************************************/  
DWORD zAti_BoardnumReqProc(VOID *pDataPtr)
{
    T_ZAti_BoardnumSetReq      *ptboardnumReq = (T_ZAti_BoardnumSetReq*)pDataPtr;
    zAti_EncOKError((BOOL)(ZOSS_SUCCESS == zPS_NvAMTItemWrite(ABBORDNUm_NVPARAM, ptboardnumReq->abNum, ZAT2_MAX_BORDNAME_LEN)));
    return Z_APMMIA_NOERROR_ERR;
}

/**************************************************************************
* ƣ zAti_BoardnumQueryReqProc
*  ûAT+BOARDNUM
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ +BOARDNUM: <NUM>
**************************************************************************/  
DWORD zAti_BoardnumQueryReqProc(VOID *pDataPtr)
{
    CHAR *pStrWalk = g_zAt_EncBuf;
    #if !defined(_CHIP_ZX297510) && !defined(_CHIP_ZX297520_LATER)
    BYTE  i = 0;
    BYTE  iaddrTmp = 0;
    #endif
    BYTE  abNum[ZAT2_MAX_BORDNAME_LEN+1] = {0};

    if (ZOSS_SUCCESS == zPS_NvAMTItemRead(ABBORDNUm_NVPARAM, abNum, ZAT2_MAX_BORDNAME_LEN))
    {
    
        pStrWalk += sprintf((char *)pStrWalk, "%s+BOARDNUM: ", g_zAt_CRLF);

        
        #if !defined(_CHIP_ZX297510) && !defined(_CHIP_ZX297520_LATER)

        for (i = 0;i < ZAT2_MAX_BORDNAME_LEN;i++, pStrWalk += 2)
        {
            iaddrTmp = (UINT8)((abNum[i] << 4) | (abNum[i] >> 4));
            sprintf((char *)pStrWalk, "%02X", iaddrTmp);
        }
        #else
        snprintf((char *)pStrWalk, ZAT2_MAX_BORDNAME_LEN, "%s", abNum);
        pStrWalk += strlen((const char *)pStrWalk);
        #endif
        sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    }
    else
    {
        sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF,g_zAt_CRLF);
    }
    return Z_APMMIA_NOERROR_ERR;
}

/**************************************************************************
* ƣ zAti_ProdtestReqProc
*  ûAT+PRODTEST
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵If there is no <bb>,+PRODTEST:<ivalue> If there is <bb>, OK
**************************************************************************/  
DWORD zAti_ProdtestReqProc(VOID *pDataPtr)
{
    T_ZAti_ProdtestReq *ptprodtestReq = (T_ZAti_ProdtestReq*)pDataPtr;

    BYTE bValue = 0;
    BYTE    bResult = (ZAT2_CO_SET_REQ == ptprodtestReq->bCommandOp)? 
        (ZOSS_SUCCESS == zPS_NvAMTFlagsItemWrite((NvParam_AMTFlags)ptprodtestReq->iTestValue,&ptprodtestReq->iResult)) : 
        (ZOSS_SUCCESS == zPS_NvAMFlagsTItemRead((NvParam_AMTFlags)ptprodtestReq->iTestValue, &bValue));

    if (bResult == TRUE)
    {
        if (ZAT2_CO_SET_REQ == ptprodtestReq->bCommandOp)
        {
            sprintf((char *)g_zAt_EncBuf, "%s",  g_zAt_OK);
        }
        else
        {
            sprintf((char *)g_zAt_EncBuf, "%s+PRODTEST: %c%s%s", g_zAt_CRLF,bValue, g_zAt_CRLF, g_zAt_OK);
        }
    }
    else
    {
        sprintf((char *)g_zAt_EncBuf, "%sERROR%s", g_zAt_CRLF,g_zAt_CRLF);
    }
    return Z_APMMIA_NOERROR_ERR;
}

/**************************************************************************
* ƣ zAti_ZflagSetReqProc
*  ûAT+ZFLAGӦ豸Ƿ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵+ZFLAG=<dev>[,<n>]    OK/ERROR
**************************************************************************/  
DWORD zAti_ZflagSetReqProc(VOID *pDataPtr)
{
    T_ZAti_Zflag_Req           *ptzflagsetReq = (T_ZAti_Zflag_Req*)pDataPtr;
    BYTE    bResult = FALSE;

    zAti_ZflagSetReqProcContent(&bResult, ptzflagsetReq->bFac, ptzflagsetReq->bValue);
    zAti_EncOKError(bResult);    
    return Z_APMMIA_NOERROR_ERR;
}

VOID zAti_ZflagSetReqProcContent(PBYTE pbResult, BYTE bFac, BYTE  bValue)
{
    if(ZAT2_FAC_BOOT == bFac)
    {
         *pbResult = (zSys_NvSetBootFlag((bValue?OFF_STATE:ON_STATE)) == ZOSS_SUCCESS);          
    }
    else if(ZAT2_FAC_MUTI_AMT == bFac)
    {
        *pbResult = (zSys_NvSetCdromFlag((bValue?ON_STATE:OFF_STATE)) == ZOSS_SUCCESS);                  
    }
    else if(ZAT2_FAC_STM == bFac)
    {
        zStmPb_SetMode(bValue, (T_zStm_TaskIdx)g_zAti_CurInstance);
        *pbResult = TRUE;
    }
    #if !defined(_CHIP_ZX297510) && !defined(_CHIP_ZX297520_LATER)
    else if(ZAT2_FAC_DL_INTERVAL == bFac)
    {
        *pbResult = (zSys_NvSetDLIntervalFlag(bValue?LONG_INTERVAL:SHORT_INTERVAL) == ZOSS_SUCCESS);                  
    }
    #endif
    return;
}


/**************************************************************************
* ƣ zAti_ZflagQueryReqProc
*  ûAT+ZFLAGѯӦ豸Ƿ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
*            עĸʽ֮ģT_ZAti_ZflagQueryReq
**************************************************************************/  
DWORD zAti_ZflagQueryReqProc(VOID *pDataPtr)
{
    T_ZAti_Fac                  tFac[ZAT2_MAX_FAC_NUM] = {0};              /* The DTMF char */
    BYTE bFacNum = 0;
    BYTE i = 0;
    CHAR *pStrWalk = g_zAt_EncBuf;
    
    tFac[0].bFac = ZAT2_FAC_BOOT;
    tFac[1].bFac = ZAT2_FAC_MUTI_AMT; 
#if defined(_CHIP_ZX297510) || defined(_CHIP_ZX297520_LATER) || defined(_CHIP_ZX2804)
    bFacNum = 2;
    tFac[0].bValue = (ON_STATE == zSys_NvGetBootFlag() ? 0 : 1);
    tFac[1].bValue = (ON_STATE == zSys_NvGetCdromFlag()? 1 : 0);
#else
    bFacNum = ZAT2_MAX_FAC_NUM;
    tFac[2].bFac = ZAT2_FAC_DL_INTERVAL; 
    tFac[0].bValue = (ON_STATE == zSys_NvGetBootFlag() ? 0 : 1);
    tFac[1].bValue = (ON_STATE == zSys_NvGetCdromFlag()? 1 : 0);
    tFac[2].bValue = (LONG_INTERVAL == zSys_NvGetDLIntervalFlag()? 1 : 0);
#endif

    pStrWalk += sprintf((char *)pStrWalk, "%s+ZFLAG: ", g_zAt_CRLF);

    for(i = 0;i < bFacNum;i++)
    {
        pStrWalk += sprintf((char *)pStrWalk, "\"%s\",%d,", ZAT_FAC_TYPE[tFac[i].bFac], tFac[i].bValue);
    }
    pStrWalk--;
    sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
    
    return Z_APMMIA_NOERROR_ERR;
}

/**************************************************************************
* ƣ zAti_ZmodeswitchSetReqProc
*  ûAT+ZMODESWITCHõǰ汾ģʽ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/  
DWORD zAti_ZmodeswitchSetReqProc(VOID *pDataPtr)
{
    BYTE bMode = 0;

    UINT32                      iAddr = OS_FLASH_ATI_RW_NONFAC_OFFSET_FROM_NV +0x03E2;

    T_ZAti_Zmodeswitch_Req     *ptzModeswitchReq = (T_ZAti_Zmodeswitch_Req*)pDataPtr;

    if(ZOSS_ERROR == zOss_NvItemRead(iAddr, &bMode, 1) ||ptzModeswitchReq->bMode != bMode)
    {
        zAti_EncOKError((BOOL)(ZOSS_SUCCESS == zOss_NvItemWrite(iAddr, (UINT8 *)&ptzModeswitchReq->bMode, 1)));
    }
    else
    {
        zAti_EncOKError(TRUE);
    }
    return Z_APMMIA_NOERROR_ERR;
}

/**************************************************************************
* ƣ zAti_ZsetSetReqProc
*  ûAT+ZSETõǰ汾ģʽ
* ˵ (IN) 
*            pDataPtr       ṹָ
*            iDataLen       ṹ峤
*            (OUT)
*   ֵ 
* ˵ 
**************************************************************************/  
DWORD zAti_ZsetSetReqProc(VOID *pDataPtr)
{
    T_ZAti_Zset_Req         *ptzSetReq = (T_ZAti_Zset_Req*)pDataPtr;
    zAti_ZsetSendCnf(ptzSetReq);
    return Z_APMMIA_NOERROR_ERR;
}

VOID zAti_ZsetSendCnf(T_ZAti_Zset_Req * pZSetReq)
{
    CHAR *pStrWalk = g_zAt_EncBuf;
    if(pZSetReq->bCommandOp == ZAT2_CO_SET_REQ)
    {
        zAti_EncOKError((BOOL)(ZOSS_SUCCESS == zOss_AtCfgSet(pZSetReq->cmd, &(pZSetReq->iParam),g_zAti_CurInstance)));
    }
    else if(pZSetReq->bCommandOp == ZAT2_CO_QUERY_REQ)
    {
        pZSetReq->iParam = zOss_AtCfgGet(pZSetReq->cmd);
        if (pZSetReq->iParam.result == ZOSS_SUCCESS)
        {
            pStrWalk += sprintf((char *)pStrWalk, "%s+ZSET: \"%s\"", g_zAt_CRLF,pZSetReq->cmd);
            zAt_PsEncZsetQueryCnfContent(&pStrWalk, pZSetReq);
            sprintf((char *)pStrWalk, "%s%s", g_zAt_CRLF, g_zAt_OK);
        }
        else
        {
            zAti_EncOKError(FALSE);
        }
    }
    return;
}
#ifdef USE_VOICE_SUPPORT
BOOL __ps_static_func zAti_CcMsgProc(DWORD *pEvId, UINT8 *pEvData, WORD *pDataLen, T_ZAti_ChannelInfo *pChnelNode)
{
    if(zAti_GetCallControlMsg(*pEvId)) /* ((iEvId >= ZPS_ApMmia_CcSetupReq_Ev) && (iEvId <= ZPS_ApMmia_EtbmQueryReq_Ev)) */
    {
        if(ZATI2_SUCCESS != zAti_UsbSioGetCcManIndex(*pEvId, pEvData+1, pChnelNode))
        {
            return FALSE;
        }
    }
    return TRUE;
}
#endif
/**************************************************************************
*  : zAti_GetServerIndex
*  : ͨͨŻȡϢ
* ˵ (IN) 
*            iEvId          ϢID
*            pEvData        Ϣ
*            iDataLen        Ϣ峤
*            chnelNode        ͨŽ
*            (OUT)
*            pEvData        Ϣ
*            chnelNode        ͨŽ
*   ֵ : ɹZATI2_SUCCESSʧܷشͣ
* ˵ : Ҫ㱣֤ŵȷ  
*            ATI2--->MMIA ֻXXX_REQ  Ϣ  
*            ӦյCCͨSMʱͷ()ͨiDestIndex?
617001738758 [ati]AT޸ĵ
**************************************************************************/
VOID __ps_static_func zAti_GetServerIndex(UINT32 iEvId, UINT8 *pEvData, T_ZAti_ChannelInfo *pChnelNode)
{
    if (iEvId == MMIA_EUCSR_LTEINFO_REQ_EV)
    {
        return ;
    }
    zOss_Memcpy(pEvData, &pChnelNode->iSrcIndex, sizeof(UINT8));//ATI2 SrcIndexڵһ
    zOss_Memcpy(pEvData + 1, &pChnelNode->iDestIndex, sizeof(UINT8));//ATI2 DestIndexڵڶ
   
    if(MMIA_UMM_ACTIVE_REQ_EV == iEvId)
    {
        T_zMmiaUmm_Active_Req *pCgattSetReq = (T_zMmiaUmm_Active_Req *)pEvData;
        if((pCgattSetReq->bActiveValue == Z_PsDomain) && (pCgattSetReq->bActiveType == 1))
        {
            pChnelNode->iEvId = iEvId;
        }
    }
    else if(ZAT2_SS_CLCK==pChnelNode->cmd_id && ATI_DISTRIBUTE_FUNC_CLCK_SET_REQ_EV == iEvId)//ֹж
    {
        T_zApMmia_ClckSet_Req *pClckSetReq = (T_zApMmia_ClckSet_Req*)pEvData;
        if(Z_APMMIA_FACVALUE_SC !=pClckSetReq->bFac && Z_APMMIA_FACVALUE_FD !=pClckSetReq->bFac)
        {
            pChnelNode->iEvId = iEvId;
        }
    }
    return;
}

/**************************************************************************
*  : zAti_GetChannelIdByIndex
*  : ͨŻͨ
* ˵ (IN) 
*            iEvId          ϢID
*            iMmiaSrcIndex       mmiaԴ
*            iMmiaDestIndex      mmiaĿ
*            (OUT)
*            pChannelId         ҵͨ
*   ֵ : ɹָͨ룬ʧܷNULL
* ˵ : 1) Ҫƽ̨ATI֤ͨʹõȷ  
*            2) ͨţҵͷЧͨţΪЧͨ 
*            3) MMIAԴſܷЧֵ0xffCCϢʱ
*            4) PS_CCԴŲǹ̶ӳ䣬ǰ˳ѡԴŵ
*            5) ҪMMIAԴЧԽжϣ򵱲䷵0xffΪԴ
**************************************************************************/
T_ZAti_ChannelInfo * __ps_static_func zAti_GetChannelIdByIndex(UINT32 iEvId, const BYTE iMmiaSrcIndex, BYTE iMmiaDestIndex, UINT8 *pChannelId)
{
    T_ZAti_ChannelInfo *pChnelNode = NULL; /* ʹָ */
    
    if(ZATI2_INVAL_MMIA_INDEX != iMmiaDestIndex)  /* ܻЧӳȴѾţ򱨴 */
    {
        pChnelNode = zAti_GetChannelNodePtrByMmiaDestIndex(iMmiaDestIndex);
    }
    else /* Чֵ */
    {    /* ѾţţŰ֪ͨϢӦţ򱨴 */
        /* ˵Ϊһ֪ͨϢҪȥѰͨ, ֪ҵӦĸͨ */
        pChnelNode = zAti_GetChannelNodePtrByMmiaSrcIndex(iMmiaSrcIndex);
    }

    if(NULL == pChnelNode)
    {        
        *pChannelId = zAti_IsDeliverAllMsg(iEvId)?ZATI2_CHANNEL_ID_NUMALL : ZATI2_CHANNEL_ID_INVALID;
    }
    else
    {
        *pChannelId = pChnelNode->iChnelId;
    }
        
    return pChnelNode;
}

#ifdef USE_VOICE_SUPPORT
/**************************************************************************
*  : zAti_UsbSioGetCcManIndex
*  : USBתģʽ£ͨͨŻȡпϢ
* ˵ (IN) 
*            iSrcIndex      Դţͨ
*            iEvId          ϢID
*            pEvData        Ϣ
*            iDataLen        Ϣ峤
*            pChnelNode      ͨڵ
*            (OUT)
*            pDestIndex     Ŀ
*            pSrcCcManIndex     CC
*   ֵ : ɹZATI2_SUCCESSʧܷشͣ
* ˵ : 
*            ע·ʱ
*            1ZATI2_SUCCESSſԼִУϢЭջ
*            2ZATI2_FALSEӦֹϢЭջ
*            3 pChnelNodeʹýеcmd_idabortӰ
**************************************************************************/
SINT32 zAti_UsbSioGetCcManIndex(const UINT32 iEvId, UINT8 *pDestIndex, const T_ZAti_ChannelInfo *pChnelNode)
{
    UINT8 iCcNum = 0;

    if(NULL == pDestIndex)
    {
        return ZATI2_FALSE;
    }

    switch(iEvId)
    {
    case MMIA_CC_ANS_MODE_REQ_EV:
        {
            for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++)
            {
                if((ZATI2_CALL_STATE_INCOMING == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState)
                    ||(ZATI2_CALL_STATE_WAITING== g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState)
                    ||(ZATI2_CALL_STATE_ACTIVE == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState))
                {                     
                    *pDestIndex = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex;
                    g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex = pChnelNode->iSrcIndex; /* ӳϵ */
                    break; /* ҵһ·磬 */
                }
            }
        }
        break;
        
    case MMIA_CC_MODIFY_REQ_EV:        
        for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++)
        {
            if(ZATI2_CALL_STATE_ACTIVE == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState
                && pChnelNode->iSrcIndex == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex)
            {                    
                *pDestIndex = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex;
                break; /* ҵһ·磬 */
            }
        }
        break;
        
    case MMIA_CC_DIS_MODE_REQ_EV:
        {         
            for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
            {
                if((g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState == ZATI2_CALL_STATE_ACTIVE)
                    && (pChnelNode->iSrcIndex == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex))
                {                 
                    *pDestIndex = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex;
                    return ZATI2_SUCCESS; 
                }
            }
            for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
            {
                if((ZATI2_CALL_STATE_INCOMING == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState)
                   ||(ZATI2_CALL_STATE_WAITING== g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState))/* Ҷ*/ 
                {                     
                    *pDestIndex = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex;
                    g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex = pChnelNode->iSrcIndex; 
                    return ZATI2_SUCCESS; 
                }
            }
            for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++) 
            {
                if((g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iXid != ZATI2_INVAL_MMIA_INDEX)
                    && (pChnelNode->iSrcIndex == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex))
                {
                    *pDestIndex = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex;
                    return ZATI2_SUCCESS; 
                }
            }
            *pDestIndex = ZATI2_CHANNEL_ID_CC_MO;/* ЭջCCͨ*/ 
        }
        break;
    case EV_ZATI2_DTMF_REQ:
        {
            for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++)                
            {
                if((g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState == ZATI2_CALL_STATE_ACTIVE)
                    && (pChnelNode->iSrcIndex == g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iSrcIndex))
                {                 
                    *pDestIndex = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex;
                    break; 
                }
            }
            //if(pChnelNode->iSrcIndex == ZATI2_DTMF_SRCINDEX)
            //{
            for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++)                
            {
                if((g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState == ZATI2_CALL_STATE_DIALING)
                    ||(g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState == ZATI2_CALL_STATE_ALERTING)
                    ||(g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState == ZATI2_CALL_STATE_ACTIVE))
                {                
                    *pDestIndex = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iDestIndex;
                    break; 
                }
            }
            //}
        }
        break;

    default: /* ߣǷе绰 */
        break;
    }
    if((*pDestIndex) == 0)
    {
        *pDestIndex = ZATI2_INVAL_MMIA_INDEX;
    }

    return ZATI2_SUCCESS;
}
#endif
/**************************************************************************
* ƣ zAti_UsbSioGetChange
*  8λIPַʽΪ32λַ
* ˵ (IN) 
*            pSrcAddr       8λʽ
*            (OUT)
*   ֵ 32λʽֵ
* ˵ 
*            Ҫע
**************************************************************************/  
UINT16 __ps_4g_func zAti_UsbSioGetChange(UINT8 *pSrcAddr)
{
    return ( (pSrcAddr[0] << 8) |(pSrcAddr[1]));
}

/****************************************************************
:zAti_GetIpcpOptionsInfo
:дIPCPЭPCOϢ617002190564
****************************************************************/
VOID  __ps_4g_func zAti_GetIpcpOptionsInfo(T_ZAti_ProtocolCfgOpt * pIpcpOptions, UINT16 IpcpLen)
{
    zOss_Memset((UINT8 *)pIpcpOptions, 0, IpcpLen);
    pIpcpOptions->iCodeFile = 1; /* Configure-Request */
    pIpcpOptions->iprotocolId = 1; /*  */
    pIpcpOptions->iContentLen = zAti_UsbSioGetChange((UINT8 *)&IpcpLen);//ipcpOptions.iContentLen = iLenPcpOptions;
    pIpcpOptions->PriDnsAddr.iType = 0x81;
    pIpcpOptions->PriDnsAddr.iLen = 6;
    pIpcpOptions->SecDnsAddr.iType = 0x83;
    pIpcpOptions->SecDnsAddr.iLen = 6;
    return;
}
/****************************************************************
:zAti_GetIpcpPcoInfo
:IPCPЭPCO617002190564
****************************************************************/
VOID __ps_4g_func zAti_GetIpcpPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE bNum, T_ZAti_ProtocolCfgOpt * pIpcpOptions,
            UINT16 IpcpLen,T_zMmiaSm_GetPco_Rsp   *pSmGetPcoRsp)
{
    if(ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4V6 ||ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4)
    {
        pSmGetPcoRsp->atCidPco[bNum].ptPco->bProtNum = 1;
        pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[0].wId = 0x8021;
        pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[0].bLen = (UINT8)IpcpLen;
        zOss_Memcpy((UINT8 *)pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[0].abBuf, (UINT8 *)pIpcpOptions, IpcpLen);
    }
    if(ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4V6 ||ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV6)
    {
        if (zAti_PcoItemIsValidByPcoId(3))
        {
            pSmGetPcoRsp->atCidPco[bNum].ptPco->bAddParaNum = 1;
            pSmGetPcoRsp->atCidPco[bNum].ptPco->atAddParaList[0].wId = 3;
            pSmGetPcoRsp->atCidPco[bNum].ptPco->atAddParaList[0].bLen = 0;
        }
    }
    return;
}
/***************************************************************************
:zAti_GetPapPcoInfo
:ATMEMļȨȨΪPAPPCO
                          Ϊͷ(4BYTE)+û+617002190564
****************************************************************************/
VOID zAti_GetPapPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE bNum,T_zMmiaSm_GetPco_Rsp   *pSmGetPcoRsp, PBYTE pbIndex)
{
    BYTE bPssWdLen = ptSmData->tPcoAuth.tPapChapInfo.bPassWordLen;
    BYTE bUrNmLen =  ptSmData->tPcoAuth.tPapChapInfo.bUserNameLen;

    pSmGetPcoRsp->atCidPco[bNum].ptPco->bProtNum = *pbIndex + 1;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].wId = 0xC023;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].bLen = (BYTE)(bPssWdLen+bUrNmLen+2+Z_ATI_PAPCHAPDNSIP_VAL_LEN);
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[0] = 0x01;//Authenticate-Request
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[1] = 0x01;//Identifier
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[3] = pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].bLen;//Length
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[4] = bUrNmLen;
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf+Z_ATI_PAPCHAPDNSIP_VAL_LEN+1, ptSmData->tPcoAuth.tPapChapInfo.abUserName, bUrNmLen);
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[Z_ATI_PAPCHAPDNSIP_VAL_LEN+1+bUrNmLen] = bPssWdLen;
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf+
    Z_ATI_PAPCHAPDNSIP_VAL_LEN+2+bUrNmLen, ptSmData->tPcoAuth.tPapChapInfo.abPassWord, bPssWdLen);
    (*pbIndex)++;
    return;
}
/********************************************************************
:zAti_GetChapPcoInfo       617002190564
:ATMEMļȨCHAP͵PCO
ע:chapΪдݲһ
chap1:  ͷ(4BYTE)++ MT NAME     chap2:  ͷ(4BYTE)+hash + username
*********************************************************************/
VOID zAti_GetChapPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE bNum,T_zMmiaSm_GetPco_Rsp   *pSmGetPcoRsp, PBYTE pbIndex)
{
    BYTE bUrNmLen =  ptSmData->tPcoAuth.tPapChapInfo.bUserNameLen;

    pSmGetPcoRsp->atCidPco[bNum].ptPco->bProtNum = *pbIndex + 1;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].wId = 0xC223;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].bLen =  (BYTE)(Z_DEV_AtMem_MAX_CHALLENGE_LEN+bUrNmLen+Z_ATI_PAPCHAPDNSIP_VAL_LEN+1);/*+MT NAME+ֽ*/
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[0] = 0x01;//Authenticate-Request
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[1] = 0x00;//Identifier
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[3] = pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].bLen;//Length
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[4] = Z_DEV_AtMem_MAX_CHALLENGE_LEN;//
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf+
    Z_ATI_PAPCHAPDNSIP_VAL_LEN+1,ptSmData->tPcoAuth.tPapChapInfo.abChallenge,Z_DEV_AtMem_MAX_CHALLENGE_LEN);
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf+Z_ATI_PAPCHAPDNSIP_VAL_LEN+1+Z_DEV_AtMem_MAX_CHALLENGE_LEN,
        ptSmData->tPcoAuth.tPapChapInfo.abUserName,bUrNmLen);

    (*pbIndex)++;

    pSmGetPcoRsp->atCidPco[bNum].ptPco->bProtNum = *pbIndex + 1;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].wId = 0xC223;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].bLen =  (BYTE)(Z_DEV_AtMem_MAX_HASH_LEN + Z_ATI_PAPCHAPDNSIP_VAL_LEN+1+bUrNmLen);
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[0] = 0x02;//Authenticate-Request
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[1] = 0x00;//Identifier
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[3] = pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].bLen;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf[4] = Z_DEV_AtMem_MAX_HASH_LEN;/*HASH LEN*/
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf+
        Z_ATI_PAPCHAPDNSIP_VAL_LEN+1,ptSmData->tPcoAuth.tPapChapInfo.abHashRsp,Z_DEV_AtMem_MAX_HASH_LEN);/*HASH*/
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[*pbIndex].abBuf+
        Z_ATI_PAPCHAPDNSIP_VAL_LEN+1+Z_DEV_AtMem_MAX_HASH_LEN,ptSmData->tPcoAuth.tPapChapInfo.abUserName,bUrNmLen);
    return;
}
/**************************************************
:ȡAPNȨϢ
:zAti_GetPapChapPcoInfo
**************************************************/
VOID __ps_4g_func zAti_GetPapChapPcoInfo(T_zDev_AtMem_SmCidData* ptSmData,BYTE iCidNum,T_zMmiaSm_GetPco_Rsp   *pSmGetPcoRsp)
{
    if(Z_ATI_PDP_Define == ptSmData->bPcoAuthFg)
    {
        BYTE bIndex = pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bProtNum;
        if(Z_MMIASM_PDP_AUTH_TYPE_PAP == ptSmData->tPcoAuth.bAuthType)
        {
            zAti_GetPapPcoInfo(ptSmData, iCidNum,pSmGetPcoRsp,&bIndex);
        }
        if(Z_MMIASM_PDP_AUTH_TYPE_CHAP == ptSmData->tPcoAuth.bAuthType)
        {
            zAti_GetChapPcoInfo(ptSmData, iCidNum,pSmGetPcoRsp,&bIndex);
        }
        if(Z_MMIASM_PDP_AUTH_TYPE_PAPCHAP == ptSmData->tPcoAuth.bAuthType)
        {
            zAti_GetPapPcoInfo(ptSmData, iCidNum,pSmGetPcoRsp,&bIndex);
            zAti_GetChapPcoInfo(ptSmData, iCidNum,pSmGetPcoRsp,&bIndex);
        }
    }
    return;
}
/**********************************************************
:ȡP-CSCF Address RequestϢ
:zAti_GetPcsfPcoInfo
**********************************************************/
VOID __ps_4g_func zAti_GetPcscfPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE iCidNum, T_zMmiaSm_GetPco_Rsp* pSmGetPcoRsp)
{
    BYTE bIndex = pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum;

    if(Z_APMMIA_PREFER_PCSCF_THROUGH_NAS_SIGNAL == ptSmData->tPdpContext.bPCscfDisc)
    {
        if(ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4V6 ||ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4)
        {
            if (zAti_PcoItemIsValidByPcoId(12))
            {
                pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum++;
                pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId = 0x000C;
                bIndex++;
            }
        }
  
        if(ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4V6 ||ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV6)
        {
            if (zAti_PcoItemIsValidByPcoId(1))
            {
                pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum++;
                pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId = 0x0001;
            }
        }
    }
    return;
}
/**********************************************************
:ȡIM CNϢ
:zAti_GetImcnPcoInfo
**********************************************************/
VOID __ps_4g_func zAti_GetImcnPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE iCidNum, T_zMmiaSm_GetPco_Rsp* pSmGetPcoRsp)
{
    BYTE bIndex = pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum;

    if(Z_APMMIA_PDPCONT_IS_FOR_IMCN == ptSmData->tPdpContext.bImcnSignInd)
    {
        if (zAti_PcoItemIsValidByPcoId(2))
        {
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum++;
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId = 0x0002;
        }
    }
    return;
}
/*******************************************************************
:IPv4AddrAllocֶдPCOӲ
:
*******************************************************************/
VOID __ps_4g_func zAti_GetIPv4AddrAllocPcoInfo(T_zDev_AtMem_SmCidData* ptSmData, BYTE iCidNum, T_zMmiaSm_GetPco_Rsp* pSmGetPcoRsp)
{
    BYTE bIndex = pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum;

    if(Z_APMMIA_IPV4ADDR_ALLOC_THROUGH_SIGNAL == ptSmData->tPdpContext.bIPv4AddrAlloc)
    {
        if (zAti_PcoItemIsValidByPcoId(10))
        {
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum++;
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId = 0x000A;
        }
    }
    else if(Z_APMMIA_IPV4ADDR_ALLOC_THROUGH_DHCP == ptSmData->tPdpContext.bIPv4AddrAlloc)
    {
        if (zAti_PcoItemIsValidByPcoId(11))
        {
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum++;
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId = 0x000B;
        }
    }
    return;
}
VOID __ps_4g_func zAti_GetIpv4info(T_zDev_AtMem_SmCidData* ptSmData, BYTE iCidNum, T_zMmiaSm_GetPco_Rsp* pSmGetPcoRsp)
{
    BYTE bIndex = pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum;

    if(ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4V6 ||ptSmData->tPdpContext.bPdpType == Z_APMMIA_SM_IPV4)
    {
        if (zAti_PcoItemIsValidByPcoId(13))
        {
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum++;
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId = 0x000D;
        }
    }
    return;
}
/**************************************************************************
* ƣ zAti_UsbSioSmZgipdnsInd
*  IP/DNSַָ֪ͨʾϢ
* ˵ (IN) 
*            iAtiIndex       ATI2
*            iMmiaIndex       MMIA 
*            (OUT)
*   ֵ 
* ˵ 
*            ӦCONNECT֮ǰв
*            ûҪãΪATI2Ҫ
**************************************************************************/   
VOID __ps_4g_func zAti_UsbSioSmZgipdnsInd(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf, UINT8* pSrc)
{
    UINT8                iCidNum          = 0;
    T_ZAti_SmZgipdnsInd *pSmZgipdnsInd = (T_ZAti_SmZgipdnsInd *)zAti_GetUB(sizeof(T_ZAti_SmZgipdnsInd));
    
    pSmZgipdnsInd->iDestIndex = pSmActDeacCnf->bDesIndex;
    pSmZgipdnsInd->iSrcIndex = pSmActDeacCnf->bSrcIndex;
    for(iCidNum = 0; iCidNum < ZATI2_SM_MAX_SMCID_NUM; iCidNum++)
    {
        if(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].isUsed &&
            g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].iCid != pSrc[g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].iCid -1]
            && zAti_SmGetPdpAddrByCid(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].iCid, &(pSmZgipdnsInd->smIpDnsInfo[pSmZgipdnsInd->iCidNum]), 
            g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iCidNum].extActCid, g_zAti_CurInstance))
        {
            pSmZgipdnsInd->iCidNum++;
        }
    }
    zOss_TaskSendData(EV_ZATI2_SM_ZGIPDNS_IND, (VOID *)pSmZgipdnsInd, sizeof(T_ZAti_SmZgipdnsInd), g_zAti_Context.taskIdMy);
    return;
}
/******************************************************
:zAti_GetIdelCid
:ȡ͵CID
Ѱҹ:
1)ûвŵIP͵CID
2)ûвŵPPP͵CID
******************************************************/
BOOL zAti_GetMoIdelCid(T_zApMmia_SmActDeact_Req* pAct, PBYTE pbPdpType)
{
    BYTE bCid = 0;
    BYTE bFstCid = Z_DEV_AtMem_MININUM_CID;
    BYTE bLstCid = Z_DEV_AtMem_MAXINUM_CID;

#ifdef DUAL_CARD_DUAL_STANDBY
    if(g_zAti_CurInstance == Z_ATI_INSNO_1)
    {
        bLstCid = 4;
    }
    else
    {
        bFstCid = 5;
    }
#endif

    for (bCid = bFstCid; bCid <= bLstCid; bCid++)
    {
        if(zAti_CheakCidAndGetPdpType(bCid, pbPdpType) && *pbPdpType == Z_APMMIA_SM_IPV4)
        {
            pAct->abCid[0]=bCid;
            return TRUE;
        }
    }

    for (bCid = bFstCid; bCid <= bLstCid;bCid++)
    {
        if(zAti_CheakCidAndGetPdpType(bCid, pbPdpType) && *pbPdpType == Z_APMMIA_SM_PPP)
        {
            pAct->abCid[0]=bCid;
            return TRUE;
        }
    }
    return FALSE;
}
/**************************************************************************************
:zAti_GetIdelCid
:ȡ͵CID
Ѱҹ:
1)ѰûмƥѶCID
2)ѰûмûжĿCID
**************************************************************************************/
BOOL zAti_GetMtIdleCid(BYTE bType, PBYTE pbCid)
{
    BYTE i = 0;
    BYTE bFstCid = Z_DEV_AtMem_MININUM_CID;
    BYTE bLstCid = Z_DEV_AtMem_MAXINUM_CID;
    T_zMmiaSm_PdpAddr      *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));  
    T_zMmiaSm_PcoInfo      *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));

#ifdef DUAL_CARD_DUAL_STANDBY
    if(g_zAti_CurInstance == Z_ATI_INSNO_1)
    {
        bLstCid = 4;
    }
    else
    {
        bFstCid = 5;
    }
#endif

    for (i = bFstCid; i <= bLstCid; i++)
    {
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, i, (PBYTE)ptSmData, g_zAti_CurInstance);
        if(ptSmData->bPdpInfoFg==Z_ATI_PDP_Define&&ptSmData->bContFlag == Z_ATI_CONTXT_First
            &&ptSmData->tPdpContext.bPdpType==bType&& (0 == get_cid_state(i)))
        {
            *pbCid = i;
            zAti_RetUB((VOID**)&ptPdpAddr);
            zAti_RetUB((VOID**)&ptPcoInfo);
            zAti_RetUB((VOID**)&ptSmData);
            return TRUE;
        }
    }
    for (i = bFstCid; i <= bLstCid; i++)
    {
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, i, (PBYTE)ptSmData, g_zAti_CurInstance);
        if(ptSmData->bPdpInfoFg==Z_ATI_PDP_NotDefine && (0 == get_cid_state(i)))
        {
            *pbCid = i;
            zAti_RetUB((VOID**)&ptPdpAddr);
            zAti_RetUB((VOID**)&ptPcoInfo);
            zAti_RetUB((VOID**)&ptSmData);
            return TRUE;
        }
    }
    zAti_RetUB((VOID**)&ptPdpAddr);
    zAti_RetUB((VOID**)&ptPcoInfo);
    zAti_RetUB((VOID**)&ptSmData);
    return FALSE;
}
/**************************************************************************************
:zAti_PppTransCid
:ATD/CGDATAЯCIDתCGACTӿȥ
**************************************************************************************/
BOOL zAti_PppTransCid(T_zApMmia_SmActDeact_Req* pAct, 
T_zMmiaSm_DataState_Req* pDataStateReq, PBYTE pbPdpType)
{
    pAct->bSrcIndex = pDataStateReq->bSrcIndex;
    pAct->bDesIndex = pDataStateReq->bDesIndex;
    pAct->bTypeFlg = Z_APMMIA_VALID;
    pAct->bType = Z_APMMIA_SM_PDP_ACTIVE;
    pAct->bCidNum = 1;

    /*CIDʱֻѡһCIDм*/
    if(pDataStateReq->bCidNum > 0&&
        zAti_CheakCidAndGetPdpType(pDataStateReq->abCid[0], pbPdpType))
    {
        pAct->abCid[0]=pDataStateReq->abCid[0];
        return TRUE;
    }

    if(pDataStateReq->bCidNum == 0)
    {
        return zAti_GetMoIdelCid(pAct, pbPdpType);
    }
    return FALSE;
}

/*************************************************************
:zAti_HandleConnInd
:ϱCONNECT лͨ
*************************************************************/
VOID zAti_HandleConnInd(BYTE bSourceIndex, BYTE bDestIndex)
{
    T_zApMmia_SmConnect_Ind      *ptApConnectInd = ZOSS_NULL;
    T_zDev_AtMem_Mmia_PrivateMem tAtData       = {0};
    
    //if (Z_FAIL == zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData))
    //{               
    //    zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
    //}
    zDev_AtMemReadItem(Z_AtMem_ID_MmiaPrvtMem, 0, (PBYTE)&tAtData, g_zAti_CurInstance);
    if (Z_APMMIA_CR_ENABLE == tAtData.bCrSet)
    {
        /* crϱconnectInd */
        zAti_CrInd (bSourceIndex, bDestIndex, Z_APMMIA_CRSERV_GPRS, 0);
    }
    ptApConnectInd = (T_zApMmia_SmConnect_Ind*)zAti_GetUB(sizeof(T_zApMmia_SmConnect_Ind));
    ptApConnectInd->bSrcIndex = bSourceIndex;
    ptApConnectInd->bDesIndex = bDestIndex;

    zAti_RecvServerHandlerSlaver(AP_MMIA_SM_CONNECT_IND_EV, (UINT8 *)ptApConnectInd, sizeof(T_zApMmia_SmConnect_Ind));
    return;
}
/********************************************************
:zAti_HandleNoCarrierCnf
:ϱNOCARRIER лͨ
*********************************************************/
VOID zAti_HandleNoCarrierCnf(BYTE bSrcIndex, BYTE bDesIndex)
{
    T_zMmiaSm_NoCarrier_Cnf *pNoCarrierCnf = (T_zMmiaSm_NoCarrier_Cnf *)zAti_GetUB(sizeof(T_zMmiaSm_NoCarrier_Cnf));
    pNoCarrierCnf->bSrcIndex = bSrcIndex;
    pNoCarrierCnf->bDesIndex = bDesIndex;
    zAti_RecvServerHandlerSlaver(MMIA_SM_NO_CARRIER_CNF_EV, (UINT8 *)pNoCarrierCnf, sizeof(T_zMmiaSm_NoCarrier_Cnf));
    return;
}
/*********************************************************************
:zAti_IsDataStatus
:жCIDǷѾ
**********************************************************************/
BOOL __ps_4g_func zAti_IsDataStatus(BYTE bCid)
{
    BYTE bNum = 0;

    /*ظ*/
    for(bNum = 0; bNum<ZATI2_SM_MAX_SMCID_NUM; bNum++)
    {
        if((g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bNum].iCid == bCid
        ||g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bNum].extActCid == bCid)
        &&(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bNum].isNdis
        ||g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bNum].isPpp))
        {
            return TRUE;
        }
    }
    return FALSE;
}

/*ȡATMEMжCID*/
BOOL zAti_GetAtmemPdpType(PBYTE pAtMemBuf, PBYTE pbPdpType)
{
    T_zDev_AtMem_SmCidData *ptempSmData = ZOSS_NULL;
    T_zDev_AtMem_SmCidData* pSmData = (T_zDev_AtMem_SmCidData *)pAtMemBuf;

    if(pAtMemBuf == ZOSS_NULL||pbPdpType == ZOSS_NULL)
    {
        return FALSE;
    }

    if(pSmData->bPdpInfoFg == Z_ATI_PDP_Define
        &&pSmData->bContFlag == Z_ATI_CONTXT_First)
    {
        *pbPdpType = pSmData->tPdpContext.bPdpType;
        return TRUE;
    }

    if(pSmData->bPdpInfoFg == Z_ATI_PDP_Define
        &&pSmData->bContFlag == Z_ATI_CONTXT_Secnd )
    {
        ptempSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, pSmData->bPreCid,(PBYTE)ptempSmData, g_zAti_CurInstance);
        *pbPdpType = ptempSmData->tPdpContext.bPdpType;
        zAti_RetUB((VOID**)&ptempSmData);
        return TRUE;
    }

    return FALSE;
}

/*****************************************************************************
:zAti_GetPdpType
:ȡMO PPPŵCID
****************************************************************************/
BOOL zAti_GetCidPdpType(PBYTE pAtMemBuf, BYTE bCid, PBYTE pbPdpType)
{ 
    T_zDev_AtMem_SmCidData* pSmData = (T_zDev_AtMem_SmCidData *)pAtMemBuf;

    if(pbPdpType == ZOSS_NULL||pAtMemBuf == ZOSS_NULL)
    {
        return FALSE;
    }
    
    /*߲޸Ϊ:ֻȡѾCIDֻͣҪΪV4V6Ͳ*/
    
    if (pSmData->bPdpInfoFg == Z_ATI_PDP_Define && zAti_GetAtmemPdpType(pAtMemBuf, pbPdpType))
    {
        return TRUE;
    }

    return FALSE;
}
/********************************************************************
:zAti_CheakAndGetPdpType
:鲢ȡ
ע:Ŀǰ֧IPV4 PPP
********************************************************************/
BOOL zAti_CheakAndGetPdpType(PBYTE pAtMemBuf, BYTE bCid, PBYTE pbPdpType)
{
    if(!zAti_GetCidPdpType(pAtMemBuf, bCid, pbPdpType)
        ||(*pbPdpType != Z_MMIASM_IPV4 && *pbPdpType != Z_MMIASM_PPP))
    {
        return FALSE;
    }
    return TRUE;
}

/****************************************************************************************
:zAti_CheakCidAndGetPdpType
:鵱ǰCIDǷϷMO PPPŵ
:Ŀǰ֧IPV4PPP
****************************************************************************************/
BOOL zAti_CheakCidAndGetPdpType(BYTE bCid, PBYTE pbPdpType)
{
    BYTE bMastCid = 0;
    BYTE bExCid = 0;
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));

    zDev_AtMemReadItem(Z_AtMem_ID_SmCidData,bCid,(PBYTE)ptSmData, g_zAti_CurInstance);

    if(zAti_IsExCid(bCid, &bMastCid)||(zAti_IsMastCid(bCid, &bExCid) && (bExCid != 0)) ||zAti_IsDataStatus(bCid)
        ||!zAti_CheakAndGetPdpType((PBYTE)ptSmData, bCid, pbPdpType))
    {
        zAti_RetUB((VOID**)&ptSmData);
        return FALSE;
    }
    zAti_RetUB((VOID**)&ptSmData);
    return TRUE;
}




/**************************************************************************
* ƣ zAti_UsbSioSmDataStateReq
*  ̬ʹAT+CGDATA
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            ӦCONNECT֮ǰвҪ鵱ǰǷѾ
*            ṹzPS_ApMmia_SmDataState_Req
**************************************************************************/  
/* //--
BOOL zAti_UsbSioSmDataStateReq(UINT8 *pDataPtr)
{
    T_zMmiaSm_DataState_Req *pDataStateReq = (T_zMmiaSm_DataState_Req *)pDataPtr;
    g_zAti_SmContext[g_zAti_CurInstance].DataReqchnelId = pDataStateReq->bSrcIndex;
    if(pDataStateReq->bCidNum > 0)
    {
        return zAti_SaveLastCidTab(pDataStateReq->abCid[0], pDataStateReq->bSrcIndex);
    }
    return TRUE;
}
*/

/**************************************************************************
* ƣ zAti_UsbSioSmMtActAnsReq
*  AT+CGANSӦMTPDP
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            עCIDӳϵṹT_zPS_ApMmia_SmMtActAns_Req
**************************************************************************/  
BOOL zAti_UsbSioSmMtActAnsReq(VOID* pDataPtr)
{
    BYTE bCid = 0;
    T_zDev_AtMem_SM_AutoRsp tAtData    = {0};
    T_zApMmia_SmMtActAns_Req *pAnsReq = (T_zApMmia_SmMtActAns_Req *)pDataPtr;
    zDev_AtMemReadItem(Z_AtMem_ID_AutoRsp, 0, (PBYTE)&tAtData, g_zAti_CurInstance);

    if(tAtData.bCgauto != Z_APMMIA_TURN_OFF_RSP_PSDOMAIN
        ||g_zAti_atDataEx[g_zAti_CurInstance].bMtAdrrType == 0)//ֶһMTʱ
    {
        return FALSE;
    }
    if(pAnsReq->bCidNum == 0&&Z_APMMIA_SM_MT_ACT_ACC == pAnsReq->bAnsType)
    {
        if(zAti_GetMtIdleCid(g_zAti_atDataEx[g_zAti_CurInstance].bMtAdrrType, &bCid))
        {
            pAnsReq->abCid[0] = bCid;
            pAnsReq->bCidNum = 1;
        }
    }

    if(Z_APMMIA_SM_MT_ACT_ACC == pAnsReq->bAnsType
        &&pAnsReq->bCidNum == 0)
    {
        pAnsReq->bAnsType = Z_APMMIA_SM_MT_ACT_REJ;
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
    }

    g_zAti_atDataEx[g_zAti_CurInstance].bMtAdrrType = 0;
    return TRUE;
}


/**************************************************************************
* ƣ zAti_UsbSioSmMtQueryIdleChInd
*  SM/MMIAATI2ѯͨ״ָ̬ʾ
* ˵ (IN) 
*            pDataPtr       
*            iDataLen       ݳ 
*            (OUT)
*   ֵ 
* ˵ 
*            һ˵(MT)󼤻ʱŻдϢϱ
*            ZPS_ApMmia_SmQueryIdleChInd_EvΪϢ
**************************************************************************/  
VOID zAti_UsbSioSmMtQueryIdleChInd(VOID *pDataPtr) /* 0107 */
{        
    UINT8        destTask    = 0;
    UINT8        iSendCount = 0;
    UINT16      iLenQueryIdleChRsp = sizeof(T_zMmiaSm_QueryIdleCh_Rsp);
    T_zMmiaSm_QueryIdleCh_Rsp  *pQueryIdleChRsp = NULL;
    T_ZAti_ChannelInfo             *pChnelNodeDeliverAll = zAti_GetFirstChannelNodePtrByInstance(g_zAti_CurInstance);

    BYTE bMaxChnlId = (g_zAti_CurInstance ? Z_ATI_INSTANCE_TWO_CHNL_MAX : Z_ATI_INSTANCE_ONE_CHNL_MAX);

    if (!zAti_GetDestTaskByMsgID(MMIA_SM_IDLE_CHNL_QUERY_RSP_EV,&destTask))
    {
        return ;
    }
    pQueryIdleChRsp= (T_zMmiaSm_QueryIdleCh_Rsp *)zAti_GetUB(iLenQueryIdleChRsp);
    
    while(NULL != pChnelNodeDeliverAll && pChnelNodeDeliverAll->iChnelId <= bMaxChnlId)
    {
        if(ZATI2_CHANNEL_MODE_CMD == pChnelNodeDeliverAll->server_mode) /* ѡͨ */
        {
            iSendCount++;
        }
        
        pChnelNodeDeliverAll = pChnelNodeDeliverAll->pNextCnNode;
    }
    
    if(iSendCount <= 1) /* ֻ10ͨʱʧ */
    {
        pQueryIdleChRsp->bResult = Z_APMMIA_SM_CH_BUSY;
    }
    else
    {
        pQueryIdleChRsp->bResult = Z_APMMIA_SM_CH_IDLE;
    }
    
    zAti_MsgSend(MMIA_SM_IDLE_CHNL_QUERY_RSP_EV, (PBYTE)pQueryIdleChRsp, iLenQueryIdleChRsp,destTask);
    return;
}

/**************************************************************************
* ƣ zAti_UsbSioDeactiveByAtiReq
*  ͨATI2ȥ̡
* ˵ (IN) 
*            iChnelId     ͨID
*            (OUT)
*   ֵ 
* ˵ 
*            ֻڳɹ̬󣬶Ͽ̬ȥͨ
*            עĸʽ֮ģT_zPS_ApMmia_SmActDeact_Req
**************************************************************************/  
VOID __ps_static_func zAti_UsbSioDeactiveByAtiReq(UINT8 iChnelId)
{
    UINT8                       iAtiCidNum = 0;
    T_ZAti_ChannelInfo         *pChnelNode = NULL;
    T_zApMmia_SmActDeact_Req tAct = {0};
    BYTE bInstance = zAti_GetTaskInstantByChnlId(iChnelId);

#ifdef CXT_MOV
    if(Z_ATI_PS_MOVE_IN_PROCESS == zAti_GetPsMovStat()||
        Z_ATI_PS_MOVE_INSERT_USER_DISCONNECT == zAti_GetPsMovStat())
    {
        zAti_SetPsMovStat(Z_ATI_PS_MOVE_INSERT_USER_DISCONNECT);
        zAti_SetChnlWhenUserDisConn(iChnelId);
        return;
    }
#endif

    pChnelNode = zAti_GetChannelNodePtr(iChnelId);
    
    if(NULL == pChnelNode) /* ͨûд */
    {
        return;
    }
    for(iAtiCidNum = 0; iAtiCidNum < ZATI2_SM_MAX_SMCID_NUM; iAtiCidNum++)
    {
        if((g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].chnelId == pChnelNode->iChnelId)
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extActCid >= 1) 
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extActCid <= ZATI2_SM_MAX_SMCID_NUM) && (tAct.bCidNum < ZATI2_SM_MAX_SMCID_NUM))
        {
            tAct.abCid[tAct.bCidNum++]=g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extActCid;
        }

        if((g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].chnelId == pChnelNode->iChnelId)
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid >= 1)
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid <= ZATI2_SM_MAX_SMCID_NUM) && (tAct.bCidNum < ZATI2_SM_MAX_SMCID_NUM))
        {
            tAct.abCid[tAct.bCidNum++]=g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid;
        }
        if (tAct.bCidNum == ZATI2_SM_MAX_SMCID_NUM)
        {
            break;
        }
    }

    if(tAct.bCidNum>0)
    {
        tAct.bIsDisconnect = TRUE;
        tAct.bSrcIndex = iChnelId;
        tAct.bDesIndex = 0xff;
        tAct.bTypeFlg = Z_APMMIA_VALID;
        tAct.bType = Z_APMMIA_SM_PDP_INACTIVE;
        zAti_SendCgactDeactReq(&tAct, bInstance);       
    }
    return;
}

/**************************************************************************
* ƣ zAti_UsbSioGetAddr
*  8λIPַʽΪ32λַ
* ˵ (IN) 
*            pSrcAddr       8λʽ
*            (OUT)
*   ֵ 32λʽֵ
* ˵ 
*            Ҫע
*            úֻڴģʽµ
**************************************************************************/  
UINT32 zAti_UsbSioGetAddr(UINT8 *pSrcAddr)
{    
    return ((pSrcAddr[3] << 24) | (pSrcAddr[2] << 16) | (pSrcAddr[1] << 8) | (pSrcAddr[0]));
}

VOID zAti_LteZconstatInd(UINT8 iResult,UINT8 channelId)
{
    BYTE bAtiNum   = 0;
    BYTE bInstance = zAti_GetTaskInstantByChnlId(channelId);
    T_ZAti_ZconstatInd *pZconstatInd = (T_ZAti_ZconstatInd *)zAti_GetUB(sizeof(T_ZAti_ZconstatInd));
  
    for(bAtiNum = 0; bAtiNum < ZATI2_SM_MAX_SMCID_NUM; bAtiNum++)
    {
        if(g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].chnelId == channelId) /* ҵ */
        {
            pZconstatInd->iCid = g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].iCid;
            break;
        }
    }
    pZconstatInd->iResult = iResult;
    pZconstatInd->iDestIndex = channelId;
    pZconstatInd->iSrcIndex = 0xff;

    zOss_TaskSendData(EV_ZATI2_LTE_ZCONSTAT_IND, (VOID *)pZconstatInd, sizeof(T_ZAti_ZconstatInd), g_zAti_Context.taskIdMy);
    return;
}

/* 617001591411 ܻ- ܻV3汾ͬʵ*/
VOID __ps_static_func zAti_NotifyApModemReady()
{
    if (g_zAti_Context.sendFnc == zAti_AtRecvNullFunc)
    {
        zOss_SetRelativeTimer(1000, EV_ZATI2_ZMSRI_IND_EXPIRY_EV, 0);
        return ;
    }

    sprintf((char *)g_zAt_EncBuf, "%s+ZMSRI%s", g_zAt_CRLF, g_zAt_CRLF);
    zAti_DeliverAllMsg(EV_ZATI2_ZMSRI_IND, g_zAt_EncBuf, (WORD)strlen((const char *)g_zAt_EncBuf));
    return;
}
#ifdef USE_VOICE_SUPPORT
/******************************************************
*:DTMF KEYֵϱ
*:ȷdtmfLenȹ̶Ϊ1
******************************************************/
VOID zAti_Drv_dtmfrx_Report(char *dtmf, unsigned char dtmfLen)
{
    BYTE i = 0;
    BYTE iCcNum = 0;
    BYTE bCallId = 0;
    BYTE bTempNo = 0;
    CHAR abStr[30] = {0};

    zOss_Memset(abStr, 0, 30);
    bTempNo = g_zAti_CurInstance;

    g_zAti_CurInstance = Z_ATI_INSNO_1;/*̶ڴ1ϱ*/

    for(iCcNum = 0; iCcNum < ZATI2_MAX_CALL_NUM; iCcNum++)
    {
        if(g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].callState == ZATI2_CALL_STATE_ACTIVE)
        {
            bCallId = g_zAti_atDataEx[g_zAti_CurInstance].tCcMan.callInfo[iCcNum].iXid;

            sprintf((char *)abStr, "%s+IMSDTMF: %d,%c%s", g_zAt_CRLF, bCallId, (*dtmf), g_zAt_CRLF);
            zAti_DeliverAllMsg(EV_ZATI2_ZDTMF_IND, abStr, (WORD)strlen((const char *)abStr));

            g_zAti_CurInstance = bTempNo;
            return;
        }
    }

    g_zAti_CurInstance = bTempNo;
    return;
}
#ifndef _OS_WIN
VOID zAti_RegDtmfCallBack()
{
    T_DrvDtmf_Detect_Opt  dtmfrx;

    dtmfrx.drv_dtmfrx_report_cb = zAti_Drv_dtmfrx_Report;
    dtmfrx.drv_dtmftx_report_cb = NULL;

    zDrvDtmf_Detect_RegCallbacks(dtmfrx);
}
#endif
#endif
BOOL __ps_4g_func zAti_GetPdpInfoByCid(UINT8 bCid,T_zMmiaSm_PdpAddr * pPdpAddr,T_zMmiaSm_PcoInfo * pPcoInfo, BYTE bInsNo)
{
#if defined (PS_RAT_GSM) || defined (PS_RAT_TDD) || defined (PS_RAT_FDD)
    if(zSm_GetPdpInfoByCid(bInsNo, bCid, pPdpAddr, pPcoInfo) == Z_SUCC)
    {
        return TRUE;
    }
#endif
#ifdef PS_RAT_LTE
    if(zEsm_GetPdpInfoByCid(bInsNo, bCid, pPdpAddr, pPcoInfo) == Z_SUCC)
    {
        return TRUE;
    }
#endif
    return FALSE;
}
/**************************************************************
:zAti_IsTheCidActived
:жضCIDضĴǷ񼤻
***************************************************************/
BOOL zAti_IsTheCidActived(UINT8 bInsNo, UINT8 bCid)
{
    T_zMmiaSm_PdpAddr                     tPdpAddr = {0};  
    T_zMmiaSm_PcoInfo   *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));

#if defined (PS_RAT_GSM) || defined (PS_RAT_TDD) || defined (PS_RAT_FDD)
    if(zSm_GetPdpInfoByCid(bInsNo, bCid, &tPdpAddr, ptPcoInfo) == Z_SUCC)
    {
        zAti_RetUB((VOID **)&ptPcoInfo);
        return TRUE;
    }
#endif
#ifdef PS_RAT_LTE
    if(zEsm_GetPdpInfoByCid(bInsNo, bCid, &tPdpAddr, ptPcoInfo) == Z_SUCC)
    {
        zAti_RetUB((VOID **)&ptPcoInfo);
        return TRUE;
    }
#endif
    zAti_RetUB((VOID **)&ptPcoInfo);
    return FALSE;
}

/*******************************************************
:zAti_IsCidActivedStand
:ж϶ӦǷļ
*******************************************************/
BOOL zAti_IsCidActivedStand(BYTE bInsNo)
{
    BYTE bCid = 0;
    BYTE bIsAct = 0;
    T_zMmiaSm_PdpAddr  *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));
    T_zMmiaSm_PcoInfo *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));

    for(bCid = Z_DEV_AtMem_MININUM_CID; bCid <= Z_DEV_AtMem_MAXINUM_CID; bCid++)
    {
        #if defined (PS_RAT_GSM) || defined (PS_RAT_TDD) || defined (PS_RAT_FDD)
        if(zSm_GetPdpInfoByCid(bInsNo, bCid, ptPdpAddr, ptPcoInfo) == Z_SUCC)
        {
            bIsAct = 1;
        }
        #endif
        #ifdef PS_RAT_LTE
        if(zEsm_GetPdpInfoByCid(bInsNo, bCid, ptPdpAddr, ptPcoInfo) == Z_SUCC)
        {
            bIsAct = 1;
        }
        #endif

        if(bIsAct == 1)
        {
            zAti_RetUB((VOID **)&ptPdpAddr);
            zAti_RetUB((VOID **)&ptPcoInfo);
            return TRUE;
        }
    }
    zAti_RetUB((VOID **)&ptPdpAddr);
    zAti_RetUB((VOID **)&ptPcoInfo);
    return FALSE;
}
#ifdef Z_SELL_STAT_SUPPORT
/*************************************************************************
:zAti_SellStatForPppAct
:PPPųɹͳ
*************************************************************************/
VOID zAti_SellStatForPppAct(T_zAti_CIDInfo *pCidInfo, T_zMmiaSm_PdpActRes *ptActRes)
{
    BYTE    bCidIndex = 0;

    if (Z_SUCC == zAti_GetCidinfoFromSm(pCidInfo, ptActRes))
    {
        #ifdef DUAL_CARD_DUAL_STANDBY
        if(Z_VALID == zAti_IsDualPsDualUicc())
        {
            zAti_SellStat_PdpActCnfSendtoPdi(ptActRes->bCid, pCidInfo, g_zAti_CurInstance);
        }
        else
        #endif
        {
            zAti_SellStat_PdpActCnfSendtoPdi(ptActRes->bCid, pCidInfo, Z_ATI_INSNO_1);
        }
    }
    else
    {    
        bCidIndex = ptActRes->bCid - Z_DEV_AtMem_MININUM_CID;
        #ifdef DUAL_CARD_DUAL_STANDBY
        if(Z_VALID == zAti_IsDualPsDualUicc())
        {
            zOss_Memset(g_zAti_atDataEx[g_zAti_CurInstance].tCIDInfo + bCidIndex, 0, sizeof(T_zAti_CIDInfo));
            g_zAti_atDataEx[g_zAti_CurInstance].tCIDInfo[bCidIndex].bPdpActFg = Z_ATI_CIDINFO_PDPDEACT;
        }
        else
        #endif
        {
            zOss_Memset(g_zAti_atDataEx[Z_ATI_INSNO_1].tCIDInfo + bCidIndex, 0, sizeof(T_zAti_CIDInfo));
            g_zAti_atDataEx[Z_ATI_INSNO_1].tCIDInfo[bCidIndex].bPdpActFg = Z_ATI_CIDINFO_PDPDEACT;
        }
    }
    return;
}
#endif
/***********************************************************************************
:zAti_HandlePppActCnf
:PPP߲ӦĴ
***********************************************************************************/
static VOID zAti_HandlePppActCnf(T_zMmiaSm_PdpAct_Cnf * pActCnf, T_ZAti_ChannelInfo* pChnelNode)
{
    T_zApMmia_SmZgact_Req tZact = {0};
#ifdef Z_SELL_STAT_SUPPORT
    T_zAti_CIDInfo   tCidinfo = {0};
#endif
   
    if(pActCnf->bResult == Z_SUCC)
    {
        if(pActCnf->bAtType==Z_MMIASM_ATCMD_CGACT)    /*ɹ𲦺*/
        {
            tZact.bSrcIndex = pActCnf->bDesIndex;
            tZact.bDstIndex = pActCnf->bSrcIndex;
            tZact.bState = Z_APMMIA_SM_PDP_ACTIVATE;
            tZact.bCid = pActCnf->atResult[0].bCid;
            zAti_SendSmZgactReq(&tZact);
        }
        else if(pActCnf->bAtType==Z_MMIASM_ATCMD_ZGACT)    /*ųɹĴ*/
        {
            if(pChnelNode->server_mode == ZATI2_CHANNEL_MODE_CMD)
            {
                zAti_HandleConnInd(pActCnf->bSrcIndex,pActCnf->bDesIndex);
            }
#ifdef Z_SELL_STAT_SUPPORT
            zAti_SellStatForPppAct(&tCidinfo, &pActCnf->atResult[0]);//ͳ
#endif
        }        
    }
    else  /*߲ʧܵĴ*/
    {
        zAti_ClearCidInfobyChnel(pActCnf->bDesIndex);
        pChnelNode->IsPpp = FALSE;
    }
    return;
}

BOOL zAti_IsLastCidOfChnnel(BYTE bCid, BYTE iChnelId)
{
    UINT8  iAtiNum = 0;

    for(iAtiNum = 0; iAtiNum < ZATI2_SM_MAX_SMCID_NUM; iAtiNum++)
    {
        if(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iAtiNum].iCid != bCid
        &&g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iAtiNum].chnelId==iChnelId
        &&g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[iAtiNum].isUsed)
        {
            return FALSE;
        }
    }
    return TRUE;
}

BOOL __ps_4g_func zAti2_IsExCid(BYTE extActCid,PBYTE pbCid)
{
    BYTE i = 0;

    for(i=0; i<ZATI2_SM_MAX_SMCID_NUM; i++)
    {
        if(g_zAti_SmContext[0].lastCidTab[i].extActCid == extActCid)
        {
            *pbCid = g_zAti_SmContext[0].lastCidTab[i].iCid;
            return TRUE;
        }
    }
    return FALSE;
}

/*********************************************************************
:zAti_IsExCid
:жCIDǷΪCIDȡӦCID
ȡ:lastCidTabѰ
**********************************************************************/
BOOL __ps_4g_func zAti_IsExCid(BYTE extActCid,PBYTE pbCid)
{
    BYTE i = 0;
    
    for(i=0; i<ZATI2_SM_MAX_SMCID_NUM; i++)
    {
        if(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[i].extActCid == extActCid)
        {
            *pbCid = g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[i].iCid;
            return TRUE;
        }
    }
    return FALSE;
}
/*********************************************************************
:zAti_IsAllExCid
:жϽӿǷΪCID
ȡ:lastCidTabѰ
*********************************************************************/
BOOL __ps_4g_func zAti_IsAllExCid(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf)
{
    BYTE i = 0;
    BYTE bMastcid = 0;

    for(i = 0; i<pSmActDeacCnf->bCidNum; i++)
    {
        if(!zAti_IsExCid(pSmActDeacCnf->atResult[i].bCid, &bMastcid))
        {
            return FALSE;
        }
    }
    return TRUE;
}

/*********************************************************************
:zAti_IsMastCid
:жCIDǷΪCIDȡӦĸCID(ʱĸCIDΪ0)
ȡ:lastCidTabѰ
*********************************************************************/
BOOL __ps_4g_func zAti_IsMastCid(BYTE bMastCid,PBYTE pbExtCid)
{
    if(bMastCid > 0 && g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bMastCid-1].iCid > 0
        && g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bMastCid-1].isUsed)
    {
        *pbExtCid = g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bMastCid-1].extActCid;
         return TRUE;
    }
    return FALSE;
}
/*********************************************************************
:zAti_IsOccupyedCid
:жϴCIDǷѾCIDռ
˵:
      (IN)        pExistedExCid ѾʹõĸCID ָ
                      bCid ȽϵCID
*********************************************************************/
static BOOL zAti_IsNoOccupyedCid(PBYTE pExistedExCid, BYTE bCid)
{
    BYTE i = 0;

    for(i = 0; i < ZATI2_SM_MAX_SMCID_NUM; i++)
    {
        if(bCid == pExistedExCid[i])
        {
            return FALSE;
        }
    }
    return TRUE;
}

/***********************************************************************
:zAti_GetDualStackExCid
:ѰҿʹõĸCID
ȡ: ѰδʹδCID 
                            ѰѾƥ䵫δʹõCID
˵:
      (IN)             bPdpType       踨CID
                           pExistedExCid  ѾռõĿCIDָ
     (OUT)          pExCid             CIDָ
***********************************************************************/
static BOOL zAti_GetDualStackExCid(PBYTE pExistedExCid,PBYTE pExCid)
{
    BYTE bCid = 0;
    BYTE bFstCid = Z_DEV_AtMem_MININUM_CID;
    BYTE bLstCid = ZATI2_SM_MAX_SMCID_NUM;
    T_zMmiaSm_PdpAddr      *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));  
    T_zMmiaSm_PcoInfo      *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));

#ifdef DUAL_CARD_DUAL_STANDBY
    if(g_zAti_CurInstance == Z_ATI_INSNO_1)
    {
        bLstCid = 4;
    }
    else
    {
        bFstCid = 5;
    }
#endif

    /*ѰδʹδCID*/
    for(bCid = bFstCid; bCid <= bLstCid; bCid++)
    {
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, bCid, (PBYTE)ptSmData, g_zAti_CurInstance);
        if(!zAti_IsCidUsed(bCid) && !zAti_GetPdpInfoByCid(bCid, ptPdpAddr, ptPcoInfo, g_zAti_CurInstance)
        &&Z_ATI_PDP_NotDefine == ptSmData->bPdpInfoFg && zAti_IsNoOccupyedCid(pExistedExCid,bCid))
        {
            *pExCid = bCid;
            zAti_RetUB((VOID**)&ptPdpAddr);
            zAti_RetUB((VOID**)&ptPcoInfo);
            zAti_RetUB((VOID**)&ptSmData);
            return TRUE;
        }
    }
    zAti_RetUB((VOID**)&ptPdpAddr);
    zAti_RetUB((VOID**)&ptPcoInfo);
    zAti_RetUB((VOID**)&ptSmData);
    return FALSE;
}

VOID zAti_GetChallengeAndHash(T_zDev_AtMem_SmCidData* ptSmData, BYTE bCid)
{
    BYTE i = 0;
    BYTE abChallenge1[Z_DEV_AtMem_MAX_CHALLENGE_LEN/2+1] = {0};
    BYTE abChallenge2[Z_DEV_AtMem_MAX_CHALLENGE_LEN/2+1] = {0};

    if(Z_VALID == ptSmData->bPcoAuthFg)
    {
        DWORD dwRand = (DWORD)rand();//ȡ
        BYTE  bRand  = 0;
        for(i = 0; i < 4; i++)//תַ
        {
            bRand = (BYTE)(dwRand>>(8*i));
            itoa(bRand, (char*)&abChallenge1[i*2], 16);
            itoa(bRand, (char*)&abChallenge2[i*2], 16);
        }

        zOss_Memcpy(ptSmData->tPcoAuth.tPapChapInfo.abChallenge, abChallenge1, Z_DEV_AtMem_MAX_CHALLENGE_LEN/2);
        zOss_Memcpy(&ptSmData->tPcoAuth.tPapChapInfo.abChallenge[8], abChallenge2, Z_DEV_AtMem_MAX_CHALLENGE_LEN/2);

        zAti_GetMd5Hash(0, (CHAR*)ptSmData->tPcoAuth.tPapChapInfo.abPassWord, ptSmData->tPcoAuth.tPapChapInfo.bPassWordLen, 
            (CHAR*)ptSmData->tPcoAuth.tPapChapInfo.abChallenge, Z_DEV_AtMem_MAX_CHALLENGE_LEN, (CHAR*)ptSmData->tPcoAuth.tPapChapInfo.abHashRsp);//ȡHASH
        zDev_AtMemWriteItem(Z_AtMem_ID_SmCidData, bCid,(PBYTE)ptSmData, g_zAti_CurInstance);
    }
    return;
}
/********************************************************************
:zAti_GetZgpcoChapInfo       617002190564
:ZGPCOCHAPõֵCHAP͵PCO
ע:chapΪдݲһ
chap1:  ͷ(4BYTE)++ MT NAME     chap2:  ͷ(4BYTE)+hash + username
*********************************************************************/
VOID zAti_GetZgpcoChapInfo(BYTE bNum,BYTE bCid,T_zMmiaSm_GetPco_Rsp *pSmGetPcoRsp)
{
    BYTE bIndex   = pSmGetPcoRsp->atCidPco[bNum].ptPco->bProtNum;
    BYTE bUrNmLen = g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1].bUserNameLen;    
    BYTE bChallengeLen = g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1].bChallengeLen;
    BYTE bHashRspLen   = g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1].bHashRspLen;
    BYTE abUserName[Z_DEV_AtMem_MAX_STR_LEN+1] = {0};/*û*/
    BYTE abHashRsp[Z_DEV_AtMem_MAX_HASH_LEN] = {0};/*HASH*/
    BYTE abChallenge[Z_ATI_ZGPCOCHAP_CHALLENGE_MAXLEN] = {0};/**/
    
    zOss_Memcpy(abUserName,g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1].abUserName,bUrNmLen+1);
    zOss_Memcpy(abChallenge,g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1].abChallenge,Z_ATI_ZGPCOCHAP_CHALLENGE_MAXLEN);
    zOss_Memcpy(abHashRsp,g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1].abHashRsp,Z_DEV_AtMem_MAX_HASH_LEN);

    pSmGetPcoRsp->atCidPco[bNum].ptPco->bProtNum++;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].wId = 0xC223;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].bLen =  (BYTE)(bChallengeLen+bUrNmLen+Z_ATI_PAPCHAPDNSIP_VAL_LEN+1);/*+MT NAME+ֽ*/
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[0] = 0x01;//Authenticate-Request
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[1] = 0x00;//Identifier
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[3] = pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].bLen;//Length
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[4] = bChallengeLen;//
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf+
    Z_ATI_PAPCHAPDNSIP_VAL_LEN+1,abChallenge,bChallengeLen);
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf+Z_ATI_PAPCHAPDNSIP_VAL_LEN+1+bChallengeLen,
        abUserName,bUrNmLen);

    bIndex++;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->bProtNum++;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].wId = 0xC223;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].bLen =  (BYTE)(bHashRspLen + Z_ATI_PAPCHAPDNSIP_VAL_LEN+1+bUrNmLen);
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[0] = 0x02;//Authenticate-Request
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[1] = 0x00;//Identifier
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[3] = pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].bLen;
    pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf[4] = bHashRspLen;/*HASH LEN*/
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf+
        Z_ATI_PAPCHAPDNSIP_VAL_LEN+1,abHashRsp,bHashRspLen);/*HASH*/
    zOss_Memcpy(pSmGetPcoRsp->atCidPco[bNum].ptPco->atProtList[bIndex].abBuf+
        Z_ATI_PAPCHAPDNSIP_VAL_LEN+1+bHashRspLen,abUserName,bUrNmLen);
    return;
}
WORD __ps_4g_func zAti_GetPcoIdByNvPcoBit(BYTE bNvPcoBit)
{
    bNvPcoBit++;
    switch (bNvPcoBit)
    {
    case 1:
        return Z_ATI_ADDPARA_ID_PCSCF_IPV6ADDR;
    case 2:
        return Z_ATI_ADDPARA_ID_IMS_SIGNAL_FLG;
    case 3:
        return Z_ATI_ADDPARA_ID_DNS_SRV_IPV6ADDR;
    case 4:
        return Z_ATI_ADDPARA_ID_RESERVED4;
    case 5:
        return Z_ATI_ADDPARA_ID_SUPPORT_BC_INDICATOR;
    case 6:
        return Z_ATI_ADDPARA_ID_RESERVED6;
    case 7:
        return Z_ATI_ADDPARA_ID_DSMIPV6_HA_ADDR;
    case 8:
        return Z_ATI_ADDPARA_ID_DSMIPV6_HN_PREF;
    case 9:
        return Z_ATI_ADDPARA_ID_DSMIPV6V4_HA_ADDR;
    case 10:
        return Z_ATI_ADDPARA_ID_IPADDR_VIA_NAS_SIGNAL;
    case 11:
        return Z_ATI_ADDPARA_ID_IPV4ADDR_VIA_DHCPV4;
    case 12:
        return Z_ATI_ADDPARA_ID_PCSCF_IPV4_ADDR;
    case 13:
        return Z_ATI_ADDPARA_ID_DNS_SRV_IPV4_ADDR;
    case 14:
        return Z_ATI_ADDPARA_ID_MSISDN;
    case 15:
        return Z_ATI_ADDPARA_ID_IFOM;
    case 16:
        return Z_ATI_ADDPARA_ID_IPV4MTU;
    default:
        break;
    }
    
    return (WORD)bNvPcoBit;
}

BYTE __ps_4g_func zAti_GetNvPcoBitByPcoId(WORD wId)
{
    switch (wId)
    {
    case Z_ATI_ADDPARA_ID_PCSCF_IPV6ADDR:
        return 1;
    case Z_ATI_ADDPARA_ID_IMS_SIGNAL_FLG:
        return 2;
    case Z_ATI_ADDPARA_ID_DNS_SRV_IPV6ADDR:
        return 3;
    case Z_ATI_ADDPARA_ID_RESERVED4:
        return 4;
    case Z_ATI_ADDPARA_ID_SUPPORT_BC_INDICATOR:
        return 5;
    case Z_ATI_ADDPARA_ID_RESERVED6:
        return 6;
    case Z_ATI_ADDPARA_ID_DSMIPV6_HA_ADDR:
        return 7;
    case Z_ATI_ADDPARA_ID_DSMIPV6_HN_PREF:
        return 8;
    case Z_ATI_ADDPARA_ID_DSMIPV6V4_HA_ADDR:
        return 9;
    case Z_ATI_ADDPARA_ID_IPADDR_VIA_NAS_SIGNAL:
        return 10;
    case Z_ATI_ADDPARA_ID_IPV4ADDR_VIA_DHCPV4:
        return 11;
    case Z_ATI_ADDPARA_ID_PCSCF_IPV4_ADDR:
        return 12;
    case Z_ATI_ADDPARA_ID_DNS_SRV_IPV4_ADDR:
        return 13;
    case Z_ATI_ADDPARA_ID_MSISDN:
        return 14;
    case Z_ATI_ADDPARA_ID_IFOM:
        return 15;
    case Z_ATI_ADDPARA_ID_IPV4MTU:
        return 16;
    default:
        break;
    }
    
    return (BYTE)wId;
}
BOOL __ps_4g_func zAti_PcoItemIsValidByPcoId(WORD wId)
{
    BYTE bPcoBitIndex = 0;
    DWORD dwPcoInfo = zOss_GetPcoItemInfo();

    if (wId == 0)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_SEVERE,"");//pco id error
        return TRUE;
    }
    bPcoBitIndex = zAti_GetNvPcoBitByPcoId(wId);
    return (BOOL)((dwPcoInfo >> (bPcoBitIndex - 1)) & 0x00000001);
}

BOOL zAti_IsExistAddPara(WORD wId, BYTE iCidNum, T_zMmiaSm_GetPco_Rsp *pSmGetPcoRsp)
{
    BYTE bIndex = 0;

    for (bIndex=0; bIndex < pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum; bIndex++)
    {
        if (pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId == wId)
        {
            return TRUE;
        }
    }
    
    return FALSE;
}

VOID __ps_4g_func zAti_GetNVPcoItemInfo(BYTE iCidNum, T_zMmiaSm_GetPco_Rsp* pSmGetPcoRsp)
{
    BYTE bIndex = 0;
    BYTE bPcoBitIndex = 0;
    WORD wPcoId = 0;
    DWORD dwPcoInfo = zOss_GetPcoItemInfo();

    /*ĿǰNV32*/
    for (bPcoBitIndex=0; bPcoBitIndex < 32; bPcoBitIndex++)
    {
        if (pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum >= Z_MMIASM_PCO_PARA_ITEM_MAX_NUM)
        {
            break;
        }
        if ((dwPcoInfo >> bPcoBitIndex) & 0x00000001)
        {
            wPcoId = zAti_GetPcoIdByNvPcoBit(bPcoBitIndex);
            /*PcoIdΪ1,2,3,A,B,C,DѾݵǰCIDϢֱ*/
            if ((wPcoId == 1) || (wPcoId == 2) || (wPcoId == 3) || (wPcoId == 0x000A) 
                || (wPcoId == 0x000B) || (wPcoId == 0x000C) || (wPcoId == 0x000D))
            {
                continue;
            }
            /*Ѿʱֱһ*/
            if (zAti_IsExistAddPara(wPcoId, iCidNum, pSmGetPcoRsp))
            {
                continue;
            }

            bIndex = pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum;
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->atAddParaList[bIndex].wId = wPcoId;
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco->bAddParaNum++;
        }
    }
    
    return;
}

VOID __ps_4g_func zAti_HandleSmGetPcoInd(VOID *pBuff)
{
    UINT8  destTask = 0;
    UINT16 iLenPcpOptions = sizeof(T_ZAti_ProtocolCfgOpt);
    T_zMmiaSm_GetPco_Rsp   *pSmGetPcoRsp   = NULL;
    T_zMmiaSm_GetPco_Ind   *ptSmGetPcoInd   = (T_zMmiaSm_GetPco_Ind*)pBuff;// = (T_zPS_ApMmia_SmGetPco_Ind *)pDataPtr;
    T_zDev_AtMem_SmCidData *ptSmData   = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
    T_zDev_AtMem_SmCidData *ptPreSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
    T_ZAti_ProtocolCfgOpt  ipcpOptions   = {0};
    BYTE    bCid = 0;
    BYTE    bIsZgpcoauthchap = Z_INVALID;

    if (!zAti_GetDestTaskByMsgID(MMIA_SM_GET_PCO_RSP_EV,&destTask))
    {
        zAti_RetUB((VOID**)&ptSmData);
        zAti_RetUB((VOID**)&ptPreSmData);
        return ;
    }

    pSmGetPcoRsp = (T_zMmiaSm_GetPco_Rsp *)zAti_GetUB(sizeof(T_zMmiaSm_GetPco_Rsp));
    zAti_GetIpcpOptionsInfo(&ipcpOptions, iLenPcpOptions);

    if((ptSmGetPcoInd->bCidNum > 0) && (ptSmGetPcoInd->bCidNum <= Z_APMMIA_SM_MAX_CID_NUM))
    {
        UINT8 iCidNum = 0;

        pSmGetPcoRsp->bCidNum = ptSmGetPcoInd->bCidNum;

        for(iCidNum = 0; iCidNum < ptSmGetPcoInd->bCidNum; iCidNum++)
        {
            bCid = ptSmGetPcoInd->abCid[iCidNum];
            pSmGetPcoRsp->atCidPco[iCidNum].bCid = ptSmGetPcoInd->abCid[iCidNum];
            zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, ptSmGetPcoInd->abCid[iCidNum],(PBYTE)ptSmData, g_zAti_CurInstance);
            if(Z_VALID == ptSmData->bPcoAuthFg)
            {
                zAti_GetChallengeAndHash(ptSmData, pSmGetPcoRsp->atCidPco[iCidNum].bCid);
            }
            else if ((bCid != 0) && g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1].bIsSetChap == Z_VALID)
            {
                bIsZgpcoauthchap = Z_VALID;
            }
            pSmGetPcoRsp->atCidPco[iCidNum].ptPco = (T_zMmiaSm_PcoInfo *)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
            if (pSmGetPcoRsp->atCidPco[iCidNum].ptPco == ZOSS_NULL)
            {
                zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
                continue;
            }

            if (Z_ATI_PDP_Define == ptSmData->bPdpInfoFg && ptSmData->bContFlag == Z_ATI_CONTXT_First) 
            {
                zAti_GetIpcpPcoInfo(ptSmData, iCidNum, &ipcpOptions, iLenPcpOptions,pSmGetPcoRsp);
                if (bIsZgpcoauthchap == Z_INVALID)
                {
                    zAti_GetPapChapPcoInfo(ptSmData, iCidNum, pSmGetPcoRsp);
                }
                else
                {
                    zAti_GetZgpcoChapInfo(iCidNum, bCid, pSmGetPcoRsp);
                }
                zAti_GetPcscfPcoInfo(ptSmData, iCidNum, pSmGetPcoRsp);
                zAti_GetImcnPcoInfo(ptSmData, iCidNum, pSmGetPcoRsp);
                zAti_GetIPv4AddrAllocPcoInfo(ptSmData, iCidNum, pSmGetPcoRsp);
                zAti_GetIpv4info(ptSmData, iCidNum, pSmGetPcoRsp);

                zAti_GetNVPcoItemInfo(iCidNum, pSmGetPcoRsp);
            }
            if(ptSmData->bContFlag == Z_ATI_CONTXT_Secnd )
            {
                zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, ptSmData->bPreCid,(PBYTE)ptPreSmData, g_zAti_CurInstance);
                if(Z_ATI_PDP_Define == ptPreSmData->bPdpInfoFg)
                {
                    zAti_GetImcnPcoInfo(ptSmData, iCidNum, pSmGetPcoRsp);
                }
            }
        }
    }
    else
    {
        pSmGetPcoRsp->bCidNum = 0;
    }

    zAti_RetUB((VOID**)&ptSmData);
    zAti_RetUB((VOID**)&ptPreSmData);
    zAti_MsgSend(MMIA_SM_GET_PCO_RSP_EV,(PBYTE)pSmGetPcoRsp, sizeof(T_zMmiaSm_GetPco_Rsp),destTask);
    return;
}
/**************************************************************
:zAti_CheckDualStackPara
:Ƿ˫ջݴ
:1)෵52ԭҶΪ˫ջͷصջ
                           2)R8 
*EC 616000531325 NS-IOT7.2.5.2CIDΪIPV4V6ǱIPV4ַûЯԭ
*UE˫ջݴ̣ʧܡ
*SMЭݣESMЭR8ʼģûcause 0˵
*жϵcause=0ҷLTE˫ջݴ
****************************************************************************/
static BOOL __ps_4g_func zAti_CheckDualStackPara(T_zMmiaSm_PdpActRes *pSmActRes,PBYTE pAtMemBuf)
{
    BYTE bExCid = 0;
    T_zDev_AtMem_SmCidData* pSmData = (T_zDev_AtMem_SmCidData *)pAtMemBuf;
    BYTE bDualStackCauseFlag = Z_INVALID;
    BYTE bCurAct = zAti_GetCurAct_ByIndex(g_zAti_CurInstance);

    if (pSmActRes->bCause == Z_MMIASM_PDP_ACT_CAUSE_SINGLE_ADDR_ONLY_ALLOWED)
    {
        bDualStackCauseFlag = Z_VALID;
    }
    else if (pSmActRes->bCause == 0)
    {
        if (Z_LTE_ACT == bCurAct)
        {
            bDualStackCauseFlag = Z_INVALID;
        }
        else
        {
            bDualStackCauseFlag = Z_VALID;
        }
    }
    if((Z_VALID == bDualStackCauseFlag)&&(pSmActRes->bHandleResult == Z_SUCC)
        &&(Z_MMIASM_IPV4 == pSmActRes->tPdpAddr.bPdpType ||Z_MMIASM_IPV6 == pSmActRes->tPdpAddr.bPdpType)
        &&(Z_ATI_PDP_Define == pSmData->bPdpInfoFg &&pSmData->tPdpContext.bPdpType == Z_MMIASM_IPV4V6
        &&pSmData->bContFlag == Z_ATI_CONTXT_First)&& (!zAti_IsMastCid(pSmActRes->bCid,&bExCid)||
        (zAti_IsMastCid(pSmActRes->bCid,&bExCid) && bExCid == 0)))
    {
        return TRUE;
    }
    return FALSE;
}
static BOOL __ps_4g_func zAti_HandleSmActCnfExt(VOID *pDataPtr)
{
    BYTE i = 0;
    BYTE bNum = 0;
    BYTE abExPdpType[Z_MMIASM_MAX_CID_NUM] = {0};
    BYTE abExCid[Z_MMIASM_MAX_CID_NUM] = {0};
    T_zDev_AtMem_SmCidData *ptSmData = (T_zDev_AtMem_SmCidData*)zAti_GetUB(sizeof(T_zDev_AtMem_SmCidData));
    T_zApMmia_SmActDeact_Req tAct = {0};
    T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf = (T_zMmiaSm_PdpAct_Cnf *)pDataPtr;
    BYTE bPdpType = 0;
    BYTE bMastCid = 0;
    BYTE bExCid = 0;

    /*ѰҪ˫ջݴCID*/
    for(i = 0; i<pSmActDeacCnf->bCidNum; i++ )
    {
        zDev_AtMemReadItem(Z_AtMem_ID_SmCidData, pSmActDeacCnf->atResult[i].bCid ,(PBYTE)ptSmData, g_zAti_CurInstance);
        if(zAti_CheckDualStackPara(&pSmActDeacCnf->atResult[i],(PBYTE)ptSmData))
        {  /*ȡCID*/
            bPdpType = (pSmActDeacCnf->atResult[i].tPdpAddr.bPdpType==Z_MMIASM_IPV4)? Z_MMIASM_IPV6 : Z_MMIASM_IPV4;
            if(zAti_GetDualStackExCid(abExCid, &tAct.abCid[bNum]))
            {
                ptSmData->tPdpContext.bPdpType = bPdpType;
                abExCid[pSmActDeacCnf->atResult[i].bCid - 1]=tAct.abCid[bNum];
                abExPdpType[pSmActDeacCnf->atResult[i].bCid - 1]=ptSmData->tPdpContext.bPdpType;
                zDev_AtMemWriteItem(Z_AtMem_ID_SmCidData, (BYTE)tAct.abCid[bNum++], (PBYTE)ptSmData, g_zAti_CurInstance);
            }
        }
    }
    zAti_RetUB((VOID**)&ptSmData);
    
    if(bNum > 0)//CIDļϢȫ
    {
        tAct.bSrcIndex = pSmActDeacCnf->bDesIndex;
        tAct.bDesIndex = 0xFF;
        tAct.bCidNum = bNum;
        tAct.bTypeFlg = Z_APMMIA_VALID;
        tAct.bType = Z_APMMIA_SM_PDP_ACTIVATE;
        if(zAti_SmCgactReq(&tAct) == Z_APMMIA_NORESULT)
        {
            g_zAti_SmContext[g_zAti_CurInstance].bDualStackActResult = pSmActDeacCnf->bResult;//ΪCID
            for(i = 0; i < pSmActDeacCnf->bCidNum; i++)
            {
                /*Ҫ:1,ûбȲҲǸʱΪûжӦĸ
                2CID֮ǰѾΪұҪ˫ջCIDҪCIDͶӦĸCID*/
                if(pSmActDeacCnf->atResult[i].bCid != 0 && pSmActDeacCnf->atResult[i].bHandleResult == Z_SUCC 
                    && !zAti_IsExCid(pSmActDeacCnf->atResult[i].bCid, &bMastCid) && (!zAti_IsMastCid(pSmActDeacCnf->atResult[i].bCid, &bExCid)
                    || (abExCid[pSmActDeacCnf->atResult[i].bCid-1] != 0)))
                {
                    zAti_SaveOnlyCidTab(pSmActDeacCnf->atResult[i].bCid, abExCid[pSmActDeacCnf->atResult[i].bCid-1],
                        abExPdpType[pSmActDeacCnf->atResult[i].bCid-1]);
                }
            }
            return TRUE;
        }
    }
    return FALSE;
}
static VOID __ps_4g_func zAti_HandleZgactCnf(T_zMmiaSm_PdpAct_Cnf *pSmZgactCnf, T_ZAti_ChannelInfo *pChnelNode)
{    
    if (pSmZgactCnf->bResult == Z_SUCC)
    {
        zAti_HandleZgactCnfMsg(pSmZgactCnf, pChnelNode);
    }
    return;
}
/***********************************************************************************
:zAti_HandleATDIpPppActCnf
:PPP߲ӦĴ
***********************************************************************************/
BOOL __ps_4g_func zAti_HandleATDIpPppActCnf(T_zMmiaSm_PdpAct_Cnf * pActCnf, BYTE *pbIsNeedCnf)
{
    T_zApMmia_SmZgact_Req tZact = {0};
    //T_zAti_CIDInfo   tCidinfo = {0};
    T_ZAti_ChannelInfo *pChnelNode = NULL;
    BYTE bInstance = zAti_GetTaskInstantByChnlId(pActCnf->bDesIndex);
    BYTE bCidIndex = 0;
    BYTE bChnelId = 0xff;
    
    if ((pActCnf->atResult[0].bCid < 1) || (pActCnf->atResult[0].bCid > Z_MMIASM_MAX_CID_NUM))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//CID is 0
        return FALSE;
    }

    bCidIndex = pActCnf->atResult[0].bCid-1;
    if ((g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].iCid == pActCnf->atResult[0].bCid)
        &&g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].isPpp == TRUE 
        && g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].isPppActCmplete == FALSE)
    {
        bChnelId = g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].chnelId;
        pChnelNode = zAti_GetChannelNodePtr(bChnelId);
        if (pChnelNode == NULL)
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//get chnel fail
            return FALSE;
        }
        if(pActCnf->bResult == Z_SUCC)
        {
            if(pActCnf->bAtType==Z_MMIASM_ATCMD_CGACT)    /*ɹ𲦺*/
            {
                tZact.bSrcIndex = pActCnf->bDesIndex;
                tZact.bDstIndex = pActCnf->bSrcIndex;
                tZact.bState = Z_APMMIA_SM_PDP_ACTIVATE;
                tZact.bCid = pActCnf->atResult[0].bCid;
                zAti_SendSmZgactReq(&tZact);
                g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].isUsed = TRUE;
            }
            else if(pActCnf->bAtType==Z_MMIASM_ATCMD_ZGACT)    /*ųɹĴ*/
            {
                if(pChnelNode->server_mode == ZATI2_CHANNEL_MODE_CMD)
                {
                    zAti_HandleConnInd(pActCnf->bSrcIndex,bChnelId);
                }
                //zAti_SellStatForPppAct(&tCidinfo, &pActCnf->atResult[0]);//ͳ
                g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].isPppActCmplete = TRUE;
                *pbIsNeedCnf = Z_VALID;
            }
            
        }
        else/*߲ʧܵĴ*/
        {
            if(pChnelNode->server_mode == ZATI2_CHANNEL_MODE_DATA)
            {
                zAti_HandleNoCarrierCnf(pActCnf->bSrcIndex, bChnelId);
            }
            zAti_ClearCidInfobyChnel(bChnelId);
            *pbIsNeedCnf = Z_VALID;
        }
        return TRUE;
    }

    return FALSE;
}
DWORD __ps_4g_func zAti_HandleSmActCnf(VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaSm_PdpAct_Cnf *pSmActDeacCnf = (T_zMmiaSm_PdpAct_Cnf *)pBuff;
    UINT8 i = 0;
    BYTE bCid=0;
    UINT8 abDeactCid[Z_MMIASM_MAX_CID_NUM] = {0};
    BYTE bIsNeedCnf = Z_INVALID;//ǷҪϱ

    /*PPPŴ*/
    if(pChnelNode != NULL && pChnelNode->IsPpp)
    {
        zAti_HandlePppActCnf(pSmActDeacCnf,pChnelNode);
        if(pSmActDeacCnf->bResult == Z_FAIL)
        {
            if(pChnelNode->server_mode == ZATI2_CHANNEL_MODE_CMD)
            {
                *pdwChangedMsgId = MMIA_SM_PDP_ACTIVATE_CNF_EV;
            }
            else
            {
                zAti_HandleNoCarrierCnf(pSmActDeacCnf->bSrcIndex, pSmActDeacCnf->bDesIndex);
                //*pdwChangedMsgId = MMIA_SM_NO_CARRIER_CNF_EV;  // ṹ岻һ£Ҫ
            }
        }

        return Z_APMMIA_NORESULT;
    }
    
    /*ZGACT Ӧڴ˴*/
    if (pChnelNode != NULL && pChnelNode->cmd_id == ZAT2_LTE_ZGACT)
    {
        zAti_HandleZgactCnf(pSmActDeacCnf, pChnelNode);
        *pdwChangedMsgId = MMIA_SM_PDP_ACTIVATE_CNF_EV;
        return Z_APMMIA_NORESULT;    
    }

    /*ATD*98ΪIPV4PPP,յCGACTӦʱĴ*/
    if (zAti_HandleATDIpPppActCnf(pSmActDeacCnf, &bIsNeedCnf))
    {
        if (bIsNeedCnf == Z_VALID)
        {
            zAti_UsbSioSmZgipdnsInd(pSmActDeacCnf,abDeactCid);
            *pdwChangedMsgId = MMIA_SM_PDP_ACTIVATE_CNF_EV;
        }
        return Z_APMMIA_NORESULT;
    }

    /*жǷ˫ջ*/
    if(zAti_HandleSmActCnfExt(pBuff))
    {
        return Z_APMMIA_NORESULT;
    }
   /*˫ջCIDĴ*/
    if(zAti_IsAllExCid(pSmActDeacCnf))
    {
        zAti_HandleSmActFailedExCid(pSmActDeacCnf, abDeactCid);//ʧ
        zAti_HandleSmCleanExCidInfo(pSmActDeacCnf);//ʧܵĸCIDϢ 
        zAti_UsbSioSmZgipdnsInd(pSmActDeacCnf,abDeactCid);
        *pdwChangedMsgId = MMIA_SM_PDP_ACTIVATE_CNF_EV;
        return Z_APMMIA_NORESULT;
    }

    /*洢˫ջCIDΪCGACTʱ*/
    for(i = 0; i < pSmActDeacCnf->bCidNum; i++)
    {
        if(pSmActDeacCnf->atResult[i].bCid != 0 && pSmActDeacCnf->atResult[i].bHandleResult == Z_SUCC
        && !zAti_IsExCid(pSmActDeacCnf->atResult[i].bCid, &bCid)&&!zAti_IsMastCid(pSmActDeacCnf->atResult[i].bCid, &bCid))
        {
            zAti_SaveOnlyCidTab(pSmActDeacCnf->atResult[i].bCid,0,0);
        }
    }
    zAti_UsbSioSmZgipdnsInd(pSmActDeacCnf,abDeactCid); /* IP/DNSַ */
    *pdwChangedMsgId = MMIA_SM_PDP_ACTIVATE_CNF_EV;

    return Z_APMMIA_NORESULT;
}
/* //---
VOID zAti_HandleSmCloseChInd(VOID *pBuff)
{
    T_zMmiaSm_CloseCh_Ind *pSmCloseChInd = (T_zMmiaSm_CloseCh_Ind *)pBuff;

    if((pSmCloseChInd->bCidNum > 0) && (pSmCloseChInd->bCidNum <= ZATI2_SM_MAX_SMCID_NUM))
    {
        UINT8 iSmCidNum = 0;
        
        for(iSmCidNum = 0; iSmCidNum < pSmCloseChInd->bCidNum; iSmCidNum++)
        {           
            if(pSmCloseChInd->abCid[iSmCidNum] == g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[pSmCloseChInd->abCid[iSmCidNum]-1].iCid)
            {
                T_ZAti_ChannelInfo *pChnelNode = zAti_GetChannelNodePtr((UINT8)g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[pSmCloseChInd->abCid[iSmCidNum]-1].chnelId);
                
                if(NULL == pChnelNode)
                {
                    continue;
                }
                else
                {
                    zAti_ChangeChnelNodeToCmd(pChnelNode);
                }
            }
        } //for(iSmCidNum = 0; iSmCidNum < SmCloseChInd.bCidNum; iSmCidNum++)
    }
}
*/
VOID zAti_HandleZmenaCnf(VOID *pDataPtr)
{
    T_zMmiaSms_MemAvail_Cnf  *ptSmsCnf = (T_zMmiaSms_MemAvail_Cnf*)pDataPtr;
    UINT8 destTask = 0;

    if (zAti_GetDestTaskByMsgID(AP_MMIA_SM_MEM_AVAIL_RSP_EV,&destTask))
    {
        T_zApMmia_MemAvail_Rsp   *ptPbRsp = (T_zApMmia_MemAvail_Rsp*)zAti_GetUB(sizeof(T_zApMmia_MemAvail_Rsp));    
        ptPbRsp->bSrcIndex = ptSmsCnf->bDestIndex;  /* SMSϢٷPBҪ*/
        ptPbRsp->bDesIndex = ptSmsCnf->bSrcIndex;
        ptPbRsp->bResult = (Z_MMIASMS_RESULT_OK == ptSmsCnf->bResult)?Z_APMMIA_OPERATION_SUCCESS: Z_APMMIA_OPERATION_FAILURE;
        ptPbRsp->dwReason = ptSmsCnf->dwCause;
        zAti_MsgSend(AP_MMIA_SM_MEM_AVAIL_RSP_EV, (PBYTE)ptPbRsp, sizeof(T_zApMmia_MemAvail_Rsp),destTask);
    }
    return;
}
/************************************************************
:zAti_ClearCidInfobyChnel
:ͨȫֱCIDϢ
************************************************************/
VOID zAti_ClearCidInfobyChnel(UINT8 ChnelId)
{
    BYTE i=0;
    BYTE bInstance = zAti_GetTaskInstantByChnlId(ChnelId);

    for(i = 0; i<Z_MMIASM_MAX_CID_NUM; i++)
    {
        if(g_zAti_SmContext[bInstance].lastCidTab[i].chnelId==ChnelId)
        {
            zOss_Memset(&g_zAti_SmContext[bInstance].lastCidTab[i],0,sizeof(T_ZAti_LastCidTab));
        }
    }
    return;
}

/**************************************************
:zAti_HandleSmCleanExCidInfo
:ȫֱĸCID¼
:
****************************************************/
static BOOL zAti_HandleSmCleanExCidInfo(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf)
{
    BYTE i = 0;
    BYTE bMastCid = 0;

    for(i=0; i<pSmActDeacCnf->bCidNum; i++)
    {
        if(zAti_IsExCid(pSmActDeacCnf->atResult[i].bCid,&bMastCid) && pSmActDeacCnf->atResult[i].bHandleResult != Z_SUCC)
        {           
            g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bMastCid-1].extActCid = 0;
            g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bMastCid-1].extPdpType = 0;
            zAt_SmUndefinePdpContInAtMem(pSmActDeacCnf->atResult[i].bCid);//ȥCID           
        }
    }
    return TRUE;
}

/*********************************************************
:zAti_HandleSmDeActAbortedEx
:CIDABORTCIDȥ
                           ǼʧCID
:CIDABORTCID---23-03-29
**********************************************************/
static BOOL zAti_HandleSmActFailedExCid(T_zMmiaSm_PdpAct_Cnf * pSmActDeacCnf, UINT8* pDest)
{
#if 0
    BYTE i = 0;
    BYTE bCid = 0;
    T_zApMmia_SmActDeact_Req  smCgactReq = {0};
    
    for(i = 0; i<pSmActDeacCnf->bCidNum; i++)
    {
        if(pSmActDeacCnf->atResult[i].bHandleResult != Z_SUCC&&
            pSmActDeacCnf->atResult[i].dwReason == Z_MMIASM_PDP_HANDLE_ABORT
            &&zAti_IsExCid(pSmActDeacCnf->atResult[i].bCid,&bCid))
        {
            smCgactReq.abCid[smCgactReq.bCidNum++] = bCid;
            pDest[bCid - 1] = bCid;
        }
    }
    
    if(smCgactReq.bCidNum > 0)
    {
        smCgactReq.bSrcIndex = ZATI2_CHANNEL_ID_NUM_END + 1;
        smCgactReq.bDesIndex = 0xFF;
        smCgactReq.bType = Z_APMMIA_SM_PDP_INACTIVE;
        smCgactReq.bTypeFlg=Z_APMMIA_VALID;
        
        g_zAti_SmContext[g_zAti_CurInstance].bDualStackActResult = Z_SUCC;//

        return zAti_SmCgactReq(&smCgactReq) == Z_APMMIA_NORESULT;
    }
#endif
    //ABORTʱϱҪCIDıһ
    pSmActDeacCnf->bResult = g_zAti_SmContext[g_zAti_CurInstance].bDualStackActResult;
    g_zAti_SmContext[g_zAti_CurInstance].bDualStackActResult = Z_SUCC;//
    return TRUE;
}
/**************************************************************
:zAti_HandleSmDeActCid
:CIDȥҪȥ
***************************************************************/
static BOOL zAti_HandleSmDeActCid(UINT8 bCid)
{
    T_zApMmia_SmZgact_Req tAct = {0};
    
    tAct.bSrcIndex = ZATI2_CHANNEL_ID_NUM_END + 1;
    tAct.bDstIndex = 0xFF;
    tAct.bState    = Z_APMMIA_SM_PDP_DEACTIVATE;
    tAct.bCid      = bCid;
    
    return zAti_SendSmZgactReq(&tAct) == Z_APMMIA_NORESULT;
}

BOOL zAti_SendDeActReq(BYTE bCid, BYTE bSrcIndex)
{
    T_zApMmia_SmActDeact_Req  tCgactReq = {0};
    BYTE bMastCid = 0;
    BYTE bBackupCid = bCid;

    if ((bCid < Z_DEV_AtMem_MININUM_CID) || (bCid > ZATI2_SM_MAX_SMCID_NUM))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//cid error
        return FALSE;
    }
    bMastCid = bCid;
    if (zAti_IsExCid(bBackupCid, &bMastCid))
    {
        if ((bMastCid < Z_DEV_AtMem_MININUM_CID) || (bMastCid > ZATI2_SM_MAX_SMCID_NUM))
        {
            zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//cid error
            bMastCid = bCid;
        }
    }
    
    if (g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bMastCid -1].iCid == bMastCid
        && g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bMastCid -1].isUsed)
    {
        tCgactReq.bCidNum = 1;
        tCgactReq.abCid[0] = bCid;
        tCgactReq.bSrcIndex = bSrcIndex;
        tCgactReq.bDesIndex = 0xFF;
        tCgactReq.bType = Z_APMMIA_SM_PDP_INACTIVE;
        tCgactReq.bTypeFlg=Z_APMMIA_VALID;

        return zAti_SmCgactReq(&tCgactReq) == Z_APMMIA_NORESULT;
    }

    return FALSE;
}
static VOID zAti_HandlePppSmDeActInd(BYTE bCid)
{    
    BYTE bCidIndex = bCid-1;
    T_ZAti_ChannelInfo  *pChnelNode = zAti_GetChannelNodePtr(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].chnelId);
    if(pChnelNode != NULL)
    {
        BYTE iChnelId = g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].chnelId;        
        if(zAti_IsLastCidOfChnnel(bCid,iChnelId))
        {
            if(ZATI2_CHANNEL_MODE_DATA ==pChnelNode->server_mode)
            {
                zAti_HandleNoCarrierCnf(0xff, iChnelId);
            }
            pChnelNode->IsPpp = FALSE;
        }
    }

    zOss_Memset(&g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex], 0, sizeof(T_ZAti_LastCidTab));
    return;
}

VOID __ps_4g_func zAti_HandleSmDeActInd(T_zMmiaSm_CidDeact_Ind *ptDeactInd)
{
    BYTE bCid      = 0;
    BYTE bCidIndex = ptDeactInd->bCid-1;//¼CIDlastCidTab[]жӦ±
    T_ZAti_ChannelInfo *pChnelNode = NULL;
    BYTE bSrcIndex = 0;
    BOOL bIsExCid = FALSE;
    BYTE bMastCid = 0;

   //PPPŴ,ܴ˫ջ
    if(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].iCid == ptDeactInd->bCid
            &&g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].isPpp)
    {
        zAti_HandlePppSmDeActInd(ptDeactInd->bCid);
        return;
    }
    
    if (zAti_IsExCid(ptDeactInd->bCid, &bCid))
    {
        bIsExCid = TRUE;
        bMastCid = bCid;
    }
    
    /*ZGACTʱȥֻص£صȫֲҪ*/
    if (ptDeactInd->bAtType == Z_MMIASM_ATCMD_ZGACT)
    {
        if (bIsExCid)
        {
            if ((bMastCid >= Z_DEV_AtMem_MININUM_CID) && (bMastCid <= ZATI2_SM_MAX_SMCID_NUM))
            {
                bCidIndex = bMastCid -1;
            }
            else
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//DeactInd cid error
            }
        }
        if (g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].isNdis)
        {
            pChnelNode = zAti_GetChannelNodePtr((UINT8)g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].chnelId);
            if(pChnelNode != NULL)
            {
                zAti_ChangeChnelNodeToCmd(pChnelNode);
            }
            g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].isNdis = FALSE;
        }

        return;
    }

    /*CIDȥȥ帨CID*/
    if(bIsExCid && ((bMastCid >= 1) && (bMastCid <= ZATI2_SM_MAX_SMCID_NUM)))
    {
        bCidIndex = bMastCid -1;
        g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].extActCid = 0;  
        g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].extPdpType = 0;
        zAt_SmUndefinePdpContInAtMem(ptDeactInd->bCid);//ȥ帨CID

        /*ûյCID DeActInd*/
        if (g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].bMastCidState == 0)
        {
            /*ڲ֪ǰȥ֪ͨȥǱȥҪȥCID
            *εȥܻظ*/
            bSrcIndex = ZATI2_CHANNEL_ID_NUM_END + 1;
            zAti_SendDeActReq(bMastCid, bSrcIndex);/*ӦôЧ*/
            return;
        }
        /*˵ǰѾյCIDȥյCIDȥѾȥ֪ͨ*/
    }
    
    /*CIDȥжǷиCIDûлͨ
    *1˫ջCIDȥ2˫ջȥCIDȥѾ*/
    if (!g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].extActCid)
    {
        pChnelNode = zAti_GetChannelNodePtr((UINT8)g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].chnelId);
        if(pChnelNode != NULL)
        {
            zAti_ChangeChnelNodeToCmd(pChnelNode);
        }
        g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].isUsed = FALSE;
        g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].isNdis = FALSE;
        if (g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].bMastCidState == 1)
        {
            g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].bMastCidState = 0;
        }
    }
    else//иCID
    {
        /*ڲ֪ǰȥ֪ͨȥǱȥҪȥCID
        *εȥܻظ*/
        bSrcIndex = ZATI2_CHANNEL_ID_NUM_END + 1;
        zAti_SendDeActReq(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].extActCid, bSrcIndex);/*ӦôЧ*/
        g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].bMastCidState = 1;
    }
    return;
}



static  T_ZAti_ChannelInfo * __ps_static_func zAti_GetChnelNode(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen)
{
    T_ZAti_ChannelId       channelId = ZATI2_CHANNEL_ID_INVALID; 

    if (zAti_IsWithOutIndexDelivInd(iEvId, pDataPtr))
    {
        return NULL;
    }

    if(AS_QUERY_EM_CELL_INFO_CNF_EV == iEvId)
    {
        T_zEM_EmInfo_Ind* pLteZemciInd = (T_zEM_EmInfo_Ind*)pDataPtr;
        return zAti_GetChannelIdByIndex(iEvId, pLteZemciInd->bSrcIndex, pLteZemciInd->bDesIndex, (UINT8 *)&channelId);
    }
#ifdef USE_VOICE_SUPPORT
    else if(MMIA_CC_CALL_STATE_IND_EV == iEvId)
    {
       channelId = zAti_GetCallControlChannelId(pDataPtr, iDataLen);

        if((channelId > ZATI2_CHANNEL_ID_INVALID) && (channelId <= ZATI2_CHANNEL_ID_NUMCOUNT))
        {
            return zAti_GetChannelNodePtr((UINT8)channelId); /* ͨŻȡ */           
        }//617001738758 [ati]AT޸ĵ㲻STATEϱDSCI
        return NULL;
    }
#endif
    else
    {
        return zAti_GetChannelIdByIndex(iEvId, *pDataPtr, *(pDataPtr + 1), (UINT8 *)&channelId);
    }
}

/*
    жϵǰͨǷڵǰʵ
 */
static BOOL __ps_static_func zAti_IsCurInstanceChnlNode(BYTE bInstance, T_ZAti_ChannelInfo *pChnelNode)
{
    if(pChnelNode->iChnelId <= Z_ATI_INSTANCE_ONE_CHNL_MAX)
    {
        return (bInstance == 0);
    }
    else if(pChnelNode->iChnelId <= Z_ATI_INSTANCE_TWO_CHNL_MAX)
    {
        return (bInstance == 1);
    }
    else // ͨ> 180  ڲʹãκһʵ
    {
        return FALSE;
    }
}

/* 
    ȡϱͨ
    PsId ЭջʵţȡֵΪ12
*/
static BYTE __ps_static_func zAti_GetUnsolChannel(BYTE bPsId)
{
    if(g_zAti_Context.pUsolChannelFunc == NULL)       // ܻͨ
    {
        return Z_ATI_UNOSL_CHANNEL_ALL_FREE;
    }
    else // ܻͨȡֵɲοƾ
    {
        return g_zAti_Context.pUsolChannelFunc(bPsId);
    }
}

/**************************************************************************
*  : zAti_GetAlwaysReportChnel
*  : ȡǷ/Ӱ죬ϱͨ
* ˵ : 
*            bPsId   :  ЭջţȡֵΪ12
*   ֵ : Ƿ/Ӱ죬ϱͨ
* ˵ : ṩûӿ
**************************************************************************/
BYTE __ps_static_func zAti_GetAlwaysReportChnel(BYTE bPsId)
{
    if(g_zAti_Context.pAlwaysReportChnel == NULL)
    {
        return 0XFF;
    }
    else
    {
        return g_zAti_Context.pAlwaysReportChnel(bPsId);
    }
}
/***********************************************************************
*:zAti_GetChnelIndState
*:ͨŻȡͨǷҪϱ
*ֵ:  Z_VALID:ϱʱҪϱZ_INVALID:ϱʱϱ
*˵:
***********************************************************************/
BYTE __ps_static_func zAti_GetChnelIndState(BYTE bChnelId)
{
    BYTE bArryNum = 0;
    BYTE bBitNum = 0;
    if (bChnelId == 0)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");//chnelID err
        return Z_VALID;
    }
    bArryNum = ((bChnelId-1) / 32) % 8;//ֹʱԽ
    bBitNum = (bChnelId-1) % 32;
    return (BYTE)((g_zAti_ptData->adwIndChnel[bArryNum] >> bBitNum) & 0x00000001);
}

/*zAti_DeliverAllMsg
*  Ⱥϱ
*/
VOID __ps_static_func zAti_DeliverAllMsg(UINT32 iEvId, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen)
{
    UINT8                   iSendCount = 0;
    T_ZAti_ChannelInfo *pTempChnelNode = g_zAti_ptData->tAtChnelList.pChnelNode;
    T_ZAti_ChannelInfo *pDataChnelNode  = NULL;
    BOOL                    bIsAllChnlDeliver = FALSE;  //true ȫͨͣfalse ʵŷ 
    BYTE                     bChnelId = zAti_GetUnsolChannel((BYTE)(g_zAti_CurInstance+1));
    BYTE bCurrReportChnel = zAti_GetAlwaysReportChnel((BYTE)(g_zAti_CurInstance+1));

    if ((zAti_IsSingleCardForTwoStandby() && (zAti_IsUiccEv(iEvId) || zAti_IsStmEv(iEvId)))||
        (iEvId == EV_ZATI2_ZMSRI_IND)||(iEvId == AP_MMIA_PSCFGSTART_IND_EV)||(iEvId ==AP_MMIA_PSCFGEND_IND_EV )
        #ifdef DSDS_VSIM
        ||(iEvId == MMIA_UMM_CARDSWITCH_REQ_IND_EV) || (iEvId == MMIA_SM_CGEV_IND_EV)
        #endif
        )
    {
        /*пͨϱ*/
        bIsAllChnlDeliver = TRUE;
    }

    if(iEvId == AP_MMIA_SMS_ZCMTIND_EV)
    {
        zAti_SendRspCmdStr2Trace(72, iEncodeCmdLen, pEncodeCmd);
        zAti_SendFnc(72, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
        return;
    }

    /* жϱͨǷΪܻ*/
    if (bChnelId != Z_ATI_UNOSL_CHANNEL_ALL_FREE )
    {
        if (Z_VALID == zAti_GetChnelIndState(bChnelId))
        {
            zAti_SendRspCmdStr2Trace(bChnelId, iEncodeCmdLen, pEncodeCmd);
            zAti_SendFnc(bChnelId, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
        }

        /* 617002489746 ڻȡͨʱUICCSTMϱϢڵ˫඼ϱ  --hyc-- */
        if(bIsAllChnlDeliver)
        {
            BYTE    bInstanceNo = (g_zAti_CurInstance == 1 ? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);
            bChnelId = zAti_GetUnsolChannel((BYTE)(bInstanceNo+1));
            if (bChnelId != Z_ATI_UNOSL_CHANNEL_ALL_FREE && (Z_VALID == zAti_GetChnelIndState(bChnelId)))
            {
                zAti_SendRspCmdStr2Trace(bChnelId, iEncodeCmdLen, pEncodeCmd);
                zAti_SendFnc(bChnelId, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
            }
        }

        return;
    }

    if (zAti_IsBlackScreenReportMsg(iEvId))
    {
        if (bCurrReportChnel != 0XFF)
        {
            if (Z_VALID == zAti_GetChnelIndState(bCurrReportChnel))
            {
                zAti_SendRspCmdStr2Trace(bCurrReportChnel, iEncodeCmdLen, pEncodeCmd);
                zAti_SendFnc(bCurrReportChnel, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
            }
            /* 617002489746 ڻȡͨʱUICCSTMϱϢڵ˫඼ϱ  --hyc-- */
            if(bIsAllChnlDeliver)
            {
                BYTE bInstanceNo = (g_zAti_CurInstance == 1 ? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);
                bCurrReportChnel = zAti_GetAlwaysReportChnel((BYTE)(bInstanceNo+1));
                if (bCurrReportChnel != 0XFF && (Z_VALID == zAti_GetChnelIndState(bCurrReportChnel)))
                {
                    zAti_SendRspCmdStr2Trace(bCurrReportChnel, iEncodeCmdLen, pEncodeCmd);
                    zAti_SendFnc(bCurrReportChnel, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
                }
            }
            
        }
        return;
    }

    while(NULL != pTempChnelNode)
    {
        // ҪʵϱͨڵǰʵŷΧ
        if(!bIsAllChnlDeliver && !zAti_IsCurInstanceChnlNode(g_zAti_CurInstance, pTempChnelNode))
        {
            pTempChnelNode = pTempChnelNode->pNextCnNode;
            continue;
        }

        if(ZATI2_CHANNEL_MODE_CMD == pTempChnelNode->server_mode && (Z_VALID == zAti_GetChnelIndState(pTempChnelNode->iChnelId)))
        {
            iSendCount++;
            if(ZAT2_SM_D == pTempChnelNode->cmd_id)/*  ATD*xxxx֮Ĳϱ  */
            {
                pTempChnelNode = pTempChnelNode->pNextCnNode;
                continue;
            }
            zAti_SendRspCmdStr2Trace(pTempChnelNode->iChnelId, iEncodeCmdLen, pEncodeCmd);
            zAti_SendFnc(pTempChnelNode->iChnelId, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
        }
        else 
        {
            pDataChnelNode = pTempChnelNode;
        }
        pTempChnelNode = pTempChnelNode->pNextCnNode;
    }

    if(iSendCount == 0 && pDataChnelNode != NULL && (Z_VALID == zAti_GetChnelIndState(pDataChnelNode->iChnelId)))
    {
        zAti_ChangeChnelNodeToCmd(pDataChnelNode);
        zAti_SendRspCmdStr2Trace(pDataChnelNode->iChnelId, iEncodeCmdLen, pEncodeCmd);
        zAti_SendFnc(pDataChnelNode->iChnelId, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
    }
    return;
}
#ifdef USE_VOICE_SUPPORT
VOID zAti_DeliverCendInd(VOID)
{
    UINT16  strLen=0;
    CHAR *pStrCmd = NULL;

    pStrCmd = (CHAR *)zAti_GetUB(ZAT2_SHORT_CMD_LEN);

    /*^CEND: <Call_X>,[reserve],<endstatus>*/
    sprintf((char *)pStrCmd, "%s^CEND: 1,,29%s", g_zAt_CRLF, g_zAt_CRLF);/*Call_X̶Ϊ1*/
    strLen = (UINT16)strlen((const char *)pStrCmd);

    zAti_DeliverAllMsg(AP_MMIA_CEND_IND_EV, pStrCmd, strLen);

    zAti_RetUB((VOID **)&pStrCmd);
    return;
}
#endif
VOID __ps_4g_func zAti_ChangeChnelNodeToCmd(T_ZAti_ChannelInfo *pChnelNode)
{
    if(pChnelNode != NULL && pChnelNode->server_mode == ZATI2_CHANNEL_MODE_DATA)
    {
        pChnelNode->server_mode = ZATI2_CHANNEL_MODE_CMD;
        pChnelNode->dataType = ZATI2_CHANNEL_DATA_TYPE_INVAL; /* ԭ */
        zAti_SendFnc(pChnelNode->iChnelId, NULL, 0, ZATI2_CHIND_TURN_AT); /* лͨ */
    }
    return;
}

DWORD zAti_HandleSmNoCarrierCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    zAti_ChangeChnelNodeToCmd(pChnelNode);
    *pdwChangedMsgId = MMIA_SM_NO_CARRIER_CNF_EV;
    return Z_APMMIA_NORESULT;
}

DWORD zAti_HnadlePdpCauseQueryCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    ZOSS_TASK_ID tTaskId = zOss_Sender();
    T_zMmiaSm_QueryPdpCause_Cnf *pCeerCnf = (T_zMmiaSm_QueryPdpCause_Cnf*)pBuff;

    if(tTaskId == zDev_GetTaskId(Z_ATI_TASKID_SM, 0) || 
       tTaskId == zDev_GetTaskId(Z_ATI_TASKID_SM, 1))
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.dwSmCause       = pCeerCnf->dwCause; 
        g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bSmCauseFg      = pCeerCnf->bCauseFg;
    }
    else
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.dwEsmCause       = pCeerCnf->dwCause; 
        g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bEsmCauseFg      = pCeerCnf->bCauseFg;
    }
    g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bBkOffTimeFg      = pCeerCnf->bBkOffTimeFg;
    g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.dwBkOffTime       = pCeerCnf->dwBkOffTime;
    g_zAti_atDataEx[g_zAti_CurInstance].tCeerInfo.bSmCauseRpted  = Z_VALID;

    *pdwChangedMsgId = MMIA_SM_PDP_CAUSE_QUERY_CNF_EV;
    return Z_APMMIA_NORESULT;
}
#ifdef USE_VOICE_SUPPORT
VOID zAti_HandleCcDiscInd(T_ZAti_ChannelInfo *pChnelNode)
{
    zAti_ChangeChnelNodeToCmd(pChnelNode);
    return;
}
#endif
DWORD zAti_HandleCgattSetReqCnf(VOID* pBuff, DWORD * pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    BYTE bInstance = 0;
    T_zMmiaUmm_Active_Cnf *pCnf = (T_zMmiaUmm_Active_Cnf *)pBuff;
    UINT8  iAtiCidNum = 0;

    if(pChnelNode == NULL)
    {
        *pdwChangedMsgId = MMIA_UMM_ACTIVE_CNF_EV;
        return Z_APMMIA_NORESULT;
    }
    bInstance = zAti_GetTaskInstantByChnlId(pChnelNode->iChnelId);
    if(Z_SUCC == pCnf->bResult && (pChnelNode->iEvId == MMIA_UMM_ACTIVE_REQ_EV || pChnelNode->cmd_id == ZAT2_MM_COPS))/* ȥųɹ */
    {
        pChnelNode->iEvId = ZATI2_INVAL_EVID;
        for(iAtiCidNum = 0; iAtiCidNum < ZATI2_SM_MAX_SMCID_NUM; iAtiCidNum++)
        {
            if(g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid > 0 && 
                g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid <= ZATI2_SM_MAX_SMCID_NUM)
            {
                T_ZAti_ChannelInfo *pChNode = zAti_GetChannelNodePtr((UINT8)g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].chnelId);
                if(pChNode != NULL)
                {
                    if(g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].isPpp
                    &&(ZATI2_CHANNEL_MODE_DATA == pChNode->server_mode))
                    {
                        zAti_HandleNoCarrierCnf(0xff,pChNode->iChnelId);
                    }
                    else
                    {
                        zAti_ChangeChnelNodeToCmd(pChNode);
                    }
                }               
            }
        } 
    }
    *pdwChangedMsgId = MMIA_UMM_ACTIVE_CNF_EV;
    return Z_APMMIA_NORESULT;
}
#ifdef USE_VOICE_SUPPORT
DWORD zAti_HandleVtsForCmcc(BYTE bSourceIndex, BYTE bDestIndex)
{
    T_zMmiaCc_Dtmf_Req *pDecEvBody = NULL;
    UINT8 destTask = 0;

    if( !zAti_GetDestTaskByMsgID(MMIA_CC_DTMF_REQ_EV,&destTask)) /*617001941772*/ 
    {
         zAti_SendExpt2TraceAgt(ERR_InvalidMsg, TRACE_ERR_LEVEL_NORMAL,"");
        return Z_APMMIA_OPTNOTALW_ERR;
    }
    pDecEvBody = (T_zMmiaCc_Dtmf_Req *)zAti_GetUB(sizeof(T_zMmiaCc_Dtmf_Req));
    pDecEvBody->bSrcIndex = bSourceIndex;
    pDecEvBody->bDesIndex = bDestIndex;
    pDecEvBody->bDtmf = g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bDtmf[g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bCurnum++];
    pDecEvBody->dwDuration  = g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.dwDuration;

    if(g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bCurnum == g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bTotalNum)
    {
        g_zAti_atDataEx[g_zAti_CurInstance].tDtmf.bTotalNum = 0;
    }

    if (  Z_SUCC != zAti_MsgSend(MMIA_CC_DTMF_REQ_EV, (PBYTE)pDecEvBody, sizeof(T_zMmiaCc_Dtmf_Req),destTask))
    {
        return Z_APMMIA_OPTNOTALW_ERR;
    }   
    
    return Z_APMMIA_NORESULT;
}
#endif
static SINT32 zAti_ChangeChnelNodeToData(T_ZAti_DataType dataType, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen, T_ZAti_ChannelInfo *pChnelNode)
{
    T_zAti2_CtrmChInd iFlag = ZATI2_CHIND_TURN_CSD;
    pChnelNode->server_mode = ZATI2_CHANNEL_MODE_DATA;
    pChnelNode->dataType = dataType;
    if(dataType == ZATI2_CHANNEL_DATA_TYPE_CSD)
    {
        iFlag = ZATI2_CHIND_TURN_CSD;
    }
    else //if(dataType == ZATI2_CHANNEL_DATA_TYPE_PS)
    {
        iFlag = ZATI2_CHIND_TURN_PSD;
    }
    return zAti_SendFnc(pChnelNode->iChnelId, (UINT8 *)pEncodeCmd, iEncodeCmdLen, iFlag);
}
#ifdef USE_VOICE_SUPPORT
/*617001840313ATIں״̬ϱһ^CONN*/
static VOID zAti_SendConnInd(UINT8 *pDataPtr, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen, T_ZAti_ChannelInfo *pChnelNode)
{
    T_zApMmia_Conn_Ind       *pCcConnInd = (T_zApMmia_Conn_Ind *)pDataPtr;
    
    if((Z_APMMIA_CALLTYPE_DATA == pCcConnInd->bCallType) || (Z_APMMIA_CALLTYPE_PS_DATA == pCcConnInd->bCallType)) /* connect ̬ */
    {
         zAti_ChangeChnelNodeToData(ZATI2_CHANNEL_DATA_TYPE_CSD, pEncodeCmd, iEncodeCmdLen, pChnelNode);
    }
    return;
}
#endif
static SINT32 zAti_SendSmConnectInd(UINT8 *pDataPtr, CHAR *pEncodeCmd, UINT16 iEncodeCmdLen, T_ZAti_ChannelInfo *pChnelNode)
{
    zAti_SendFnc(pChnelNode->iChnelId, (UINT8 *)pEncodeCmd, iEncodeCmdLen, ZATI2_CHIND_AT);
    zAti_SendRspCmdStr2Trace(pChnelNode->iChnelId, iEncodeCmdLen, pEncodeCmd);
    return zAti_ChangeChnelNodeToData(ZATI2_CHANNEL_DATA_TYPE_PS, pEncodeCmd, iEncodeCmdLen, pChnelNode);
}


/**********************************************************
:zAti_GetUmmPsContext
:UMMPSע״̬Ϣ
**********************************************************/
#ifdef CXT_MOV
VOID zAti_GetUmmPsContext(T_zMmiaSm_Context_Cnf  *ptContextCnf)
{
    T_zMmiaUmm_PsContext_Req* ptUmmContextReq = ZOSS_NULL;

    ptUmmContextReq = (T_zMmiaUmm_PsContext_Req*)zAti_GetUB(sizeof(T_zMmiaUmm_PsContext_Req));

    ptUmmContextReq->bSrcIndex = ptContextCnf->bDesIndex;
    ptUmmContextReq->bDesIndex = ptContextCnf->bSrcIndex;

    zAti_MsgSend(MMIA_UMM_PS_CONTEXT_REQ_EV,(PBYTE)ptUmmContextReq,
    sizeof(T_zMmiaUmm_PsContext_Req),Z_ATI_TASKID_UMM);

    return;
}

/********************************************************
:zAti_SendContextInd
:SM/ESMͰǨָʾ
********************************************************/
DWORD zAti_SendContextInd(T_zMmiaSm_Context_Cnf* ptContextCnf, BYTE bInsNo)
{
    BYTE bMod =  zAti_GetTaskIndex(bInsNo);
    BYTE bRet = 0;
    T_zMmiaSm_Context_Ind *ptContetInd = ZOSS_NULL;
    BYTE bTempInsNo = g_zAti_CurInstance;    

    if(bMod == Z_ATI_TASKID_ATI)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//mod error
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    ptContetInd = (T_zMmiaSm_Context_Ind*)zAti_GetUB(sizeof(T_zMmiaSm_Context_Ind));
    /*ʱһϢֵҪƫ*/
    zOss_Memcpy(ptContetInd, ptContextCnf, sizeof(T_zMmiaSm_Context_Cnf));
    
    if(Z_ATI_INSNO_1 == bInsNo)
    {
        ptContetInd->bSrcIndex = ptContextCnf->bDesIndex - Z_ATI_INSTANCE_ONE_CHNL_MAX;
    }
    else
    {
        ptContetInd->bSrcIndex = ptContextCnf->bDesIndex + Z_ATI_INSTANCE_ONE_CHNL_MAX;
    }
    ptContetInd->bDesIndex = ptContextCnf->bSrcIndex;

    g_zAti_CurInstance = bInsNo;
    bRet = zAti_MsgSend(MMIA_SM_CONTEXT_IND_EV,(PBYTE)ptContetInd, sizeof(T_zMmiaSm_Context_Ind),bMod);
    g_zAti_CurInstance = bTempInsNo;

    if(Z_FAIL== bRet)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidMsg,  TRACE_ERR_LEVEL_NORMAL,"");//send error
        return Z_APMMIA_OPTNOTALW_ERR;
    }

    zAti_GetUmmPsContext(ptContextCnf);
    return Z_APMMIA_NORESULT;
}
#endif

/***************************************************************
:zAti_SendCgactDeactReq
:𲦺ŹҶ
***************************************************************/
VOID __ps_static_func zAti_SendCgactDeactReq(T_zApMmia_SmActDeact_Req *ptDeactReq, BYTE bInsNo)
{
    BYTE bMod = 0;
    BYTE bTempInsNo = g_zAti_CurInstance;
    T_zMmiaSm_PdpDeact_Req       *ptSmDeactReq = ZOSS_NULL;
    

    bMod = zAti_GetTaskIndex(bInsNo);

    if(bMod == Z_ATI_TASKID_ATI)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//mod error
        return ;
    }

    ptSmDeactReq = (T_zMmiaSm_PdpDeact_Req*)zAti_GetUB(sizeof(T_zMmiaSm_PdpDeact_Req));

    ptSmDeactReq->bSrcIndex = ptDeactReq->bSrcIndex;
    ptSmDeactReq->bDesIndex = ptDeactReq->bDesIndex;
    ptSmDeactReq->bCidNum   = ptDeactReq->bCidNum;
    ptSmDeactReq->bAtType = Z_MMIASM_ATCMD_CGACT;
    zOss_Memcpy(ptSmDeactReq->abCid,ptDeactReq->abCid,Z_APMMIA_SM_MAX_CID_NUM);
    ptSmDeactReq->bIsDisconnect = ptDeactReq->bIsDisconnect;

    g_zAti_CurInstance = bInsNo;
    zAti_MsgSend(MMIA_SM_PDP_DEACTIVATE_REQ_EV, (PBYTE)ptSmDeactReq, sizeof(T_zMmiaSm_PdpDeact_Req), bMod);
    g_zAti_CurInstance = bTempInsNo;
    return;
}
/***************************************************************
:zAti_SendZgactDeactReq
:𲦺ŹҶϣʹЧ
***************************************************************/
static VOID zAti_SendZgactDeactReq(T_zMmiaSm_PdpDeact_Req *ptDeactReq)
{
    BYTE bMod = 0;
    T_zMmiaSm_PdpDeact_Req       *ptSmDeactReq = ZOSS_NULL;
    
    bMod = zAti_GetTaskIndex(g_zAti_CurInstance);
    if(bMod == Z_ATI_TASKID_ATI)
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//mod error
        return;
    }

    ptSmDeactReq = (T_zMmiaSm_PdpDeact_Req*)zAti_GetUB(sizeof(T_zMmiaSm_PdpDeact_Req));

    ptSmDeactReq->bDesIndex = ptDeactReq->bDesIndex;
    ptSmDeactReq->bSrcIndex = ptDeactReq->bSrcIndex;
    ptSmDeactReq->bAtType = Z_MMIASM_ATCMD_ZGACT;
    zOss_Memcpy(ptSmDeactReq->abCid,ptDeactReq->abCid,ptDeactReq->bCidNum);
    ptSmDeactReq->bCidNum = ptDeactReq->bCidNum;

    zAti_MsgSend(MMIA_SM_PDP_DEACTIVATE_REQ_EV,(PBYTE)ptSmDeactReq, sizeof(T_zMmiaSm_PdpDeact_Req), bMod);
    return;
}
BOOL zAti_HandleATDIpPppCommonCnf(T_zMmiaSm_Common_Cnf *pCnf)
{
    BYTE  bAtiNum = 0;
    T_ZAti_ChannelInfo *pChnelNode = NULL;
    BYTE bInstance = zAti_GetTaskInstantByChnlId(pCnf->bDesIndex);
    BYTE bChnelId = 0xff;

    for(bAtiNum = 0; bAtiNum < ZATI2_SM_MAX_SMCID_NUM; bAtiNum++)
    {
        if(g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].iCid != 0
        && g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].isPpp
        && !g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].isPppActCmplete)
        {
            bChnelId = g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].chnelId;
            pChnelNode = zAti_GetChannelNodePtr(bChnelId);
            if (pChnelNode == NULL)
            {
                zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");//get chnel fail
                return FALSE;
            }
            if(pChnelNode->server_mode == ZATI2_CHANNEL_MODE_DATA)
            {
                zAti_HandleNoCarrierCnf(pCnf->bSrcIndex, bChnelId);
            }
            zAti_ClearCidInfobyChnel(bChnelId);
            return TRUE;
        }
    }
    return TRUE;
}
/*************************************************************
:zAti_HandlePppCommonCnf
:PPPյSM_COMMON_CNF
*************************************************************/
static DWORD zAti_HandlePppCommonCnf(VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaSm_Common_Cnf *pCnf = (T_zMmiaSm_Common_Cnf*)pBuff;

    *pdwChangedMsgId = MMIA_SM_COMMON_CNF_EV;
    if(pChnelNode != NULL && pChnelNode->IsPpp)
    {
         zAti_ClearCidInfobyChnel(pCnf->bDesIndex);
        pChnelNode->IsPpp = FALSE;
        if(pChnelNode->server_mode == ZATI2_CHANNEL_MODE_DATA)
        {
            zAti_HandleNoCarrierCnf(pCnf->bSrcIndex, pCnf->bDesIndex);
           // *pdwChangedMsgId = MMIA_SM_NO_CARRIER_CNF_EV;
        }
    }
    zAti_HandleATDIpPppCommonCnf(pCnf);
   
    return Z_APMMIA_NORESULT;
}
/**************************************************************************
*  : zAti_PppGetCid
*  : ͨŷCID
* ˵ (IN) 
*            iChnelId     ͨID
*   ֵ ɹCIDʧܷ0
* ˵ 
**************************************************************************/
BYTE zAti_PppGetCid(BYTE  bChnelId)
{
    BYTE bInstance = zAti_GetTaskInstantByChnlId(bChnelId);
    BYTE bAtiCidNum = 0;
    
    for(bAtiCidNum = 0; bAtiCidNum < ZATI2_SM_MAX_SMCID_NUM; bAtiCidNum++)
    {
        if((g_zAti_SmContext[bInstance].lastCidTab[bAtiCidNum].chnelId == bChnelId)
        && (g_zAti_SmContext[bInstance].lastCidTab[bAtiCidNum].isPpp)
        && (g_zAti_SmContext[bInstance].lastCidTab[bAtiCidNum].iCid >= 1) /* ȡֵ1~4 */
        && (g_zAti_SmContext[bInstance].lastCidTab[bAtiCidNum].iCid <= ZATI2_SM_MAX_SMCID_NUM)) 
        {
            
            return g_zAti_SmContext[bInstance].lastCidTab[bAtiCidNum].iCid;
            
        }
    }
    return 0;
}
/*****************************************************************
:zAti_HandleUserDeactCnfMsg
:ûҶӦ
*****************************************************************/
static DWORD __ps_4g_func zAti_HandleUserDeactCnfMsg( VOID* pBuff, DWORD *pdwChangedMsgId, T_ZAti_ChannelInfo  *pChnelNode)
{
    T_zMmiaSm_PdpDeact_Req tSmDeact = {0};
    T_zMmiaSm_PdpDeact_Cnf *pDeactCnf = (T_zMmiaSm_PdpDeact_Cnf*)pBuff;
        
    BYTE bNum = 0;
    BYTE i = 0;
    BYTE bInstance = 0;
    BYTE bCid = 0;

    if(!pDeactCnf->bIsDisconnect)
    {
        *pdwChangedMsgId = MMIA_SM_PDP_DEACTIVATE_CNF_EV;
        return Z_APMMIA_NORESULT;
    }

    if(pChnelNode != NULL)
    {
        bInstance = zAti_GetTaskInstantByChnlId(pChnelNode->iChnelId);
        bCid = zAti_PppGetCid(pChnelNode->iChnelId);
        /*PPPŲܳɹʧܶҪϱNOCARRIER*/
        if(pChnelNode->IsPpp || (bCid != 0 && g_zAti_SmContext[bInstance].lastCidTab[bCid-1].isPpp))
        {
            pChnelNode->IsPpp = FALSE;
            if(pChnelNode->server_mode == ZATI2_CHANNEL_MODE_DATA)
            {
                zAti_HandleNoCarrierCnf(pDeactCnf->bSrcIndex,pDeactCnf->bDesIndex);
                //*pdwChangedMsgId = MMIA_SM_NO_CARRIER_CNF_EV;
            }
            zAti_ClearCidInfobyChnel(pChnelNode->iChnelId);
        }
    }

    /*ûҶʧܲPPPRNDISҪٴηZGACTҶ*/
    if(Z_SUCC != pDeactCnf->bResult)
    {
        for(i = 0; i<Z_MMIASM_MAX_CID_NUM; i++)
        {
            if(Z_SUCC != pDeactCnf->atResult[i].bHandleResult)
            {
                tSmDeact.abCid[bNum++]=pDeactCnf->atResult[i].bCid;
                tSmDeact.bCidNum++;
            }
        }
        tSmDeact.bDesIndex = 0xff;
        tSmDeact.bSrcIndex = ZATI2_CHANNEL_ID_NUM_END + 1;
        if(tSmDeact.bCidNum>0)
        {
            zAti_SendZgactDeactReq(&tSmDeact);
        }
    }
    
    return Z_APMMIA_NORESULT;
}
static VOID __ps_4g_func zAti_HandleZgactCnfMsg(T_zMmiaSm_PdpAct_Cnf *pSmCgactCnf,  T_ZAti_ChannelInfo *pChnelNode)
{
    BYTE bAtiNum = 0;
    BYTE bMastCid = 0;
    BYTE bCidIndex = pSmCgactCnf->atResult[0].bCid - 1;//¼CIDlastCidTab[]жӦ±
    BYTE bInstance = zAti_GetTaskInstantByChnlId(pChnelNode->iChnelId);
    /*Ϊͨͬжһ㹻
       ֮ǰȥŵͨţֹһͨӦcid*/
    for(bAtiNum = 0; bAtiNum < ZATI2_SM_MAX_SMCID_NUM; bAtiNum++)
    {
        if(g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].chnelId == pSmCgactCnf->bDesIndex
            && g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].iCid != pSmCgactCnf->atResult[0].bCid
            &&g_zAti_SmContext[bInstance].lastCidTab[bAtiNum].extActCid!= pSmCgactCnf->atResult[0].bCid)
        {
            zOss_Memset(&g_zAti_SmContext[bInstance].lastCidTab[bAtiNum], 0, sizeof(T_ZAti_LastCidTab));
        }
    }
    
    (VOID)zAti_IsExCid(pSmCgactCnf->atResult[0].bCid, &bMastCid);  //  ǸCID ҵ CID
    if (bMastCid > 0)
    {
        bCidIndex = --bMastCid;
    }
    
    g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].chnelId = pSmCgactCnf->bDesIndex;

    // Mt Cid, ATi ûȫϢм¼Cid
    g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].iCid = bCidIndex + 1;
    if(zAti_SendFnc(pSmCgactCnf->bDesIndex, NULL, 0, ZATI2_CHIND_TURN_PSD) == ZATI2_SUCCESS)
    {
        g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].isNdis = TRUE;
        g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].isUsed = TRUE;
        pChnelNode->server_mode = ZATI2_CHANNEL_MODE_DATA;
        pChnelNode->dataType = ZATI2_CHANNEL_DATA_TYPE_PS;
        pSmCgactCnf->bResult = Z_SUCC;
    }
    else
    {
        g_zAti_SmContext[bInstance].lastCidTab[bCidIndex].chnelId = 0;
        zAti_HandleSmDeActCid(pSmCgactCnf->atResult[0].bCid);
        pSmCgactCnf->bResult = Z_FAIL;
    }
    return;
}

static BOOL __ps_static_func zAti_HandleCnfMsgBeforeEncCmd(UINT32 iEvId, UINT8 *pDataPtr, UINT16 iDataLen,  T_ZAti_ChannelInfo *pChnelNode)
{
    if (pChnelNode->cmd_id == ZAT2_NO_COMMAND && (iEvId == AP_MMIA_COMMON_CNF_EV || 
        iEvId == MMIA_SMS_COMMON_CNF_EV || iEvId == MMIA_SS_COMMON_CNF_EV ||
        iEvId == MMIA_UMM_COMMON_CNF_EV || iEvId == MMIA_SM_COMMON_CNF_EV|| 
        iEvId == AP_UICC_USAT_COMMON_CNF_EV || iEvId == AP_UICC_COMMON_CNF_EV || 
        iEvId == AP_MMIA_PB_COMMON_CNF_EV|| iEvId == MMIA_CC_COMMON_CNF_EV))
    {/*617001738758 AT ޸ģеڶظϢ */
        return FALSE;
    }
    return TRUE;
}
static VOID zAti_CpbrHandle(T_zApMmia_CpbrSet_Req *pCpbrReq, UINT16 iStartRec, T_zStmPb_StorageId readStorage, T_zStm_Cpbr_Cnf *pCpbrStmCnf)
{
    UINT16                      iLen = sizeof(T_zStm_Cpbr_Cnf);
    T_zStm_Cpbr_Cnf             *pCnf = NULL;
    T_zStm_Cpbr_Req             cpbrStmReq;
    zOss_Memset(&cpbrStmReq, 0, sizeof(T_zStm_Cpbr_Req));
    cpbrStmReq.cpbrSetReq = *pCpbrReq;
    cpbrStmReq.iStartRec = iStartRec;
    cpbrStmReq.readStorage = readStorage;
    if(NULL == pCpbrStmCnf)
    {
        pCnf = (T_zStm_Cpbr_Cnf *)zAti_GetUB(iLen);
    }
    else
    {
        pCnf = pCpbrStmCnf;
    }
    zStmPb_CpbrSynHandle(&cpbrStmReq, pCnf, (T_zStm_TaskIdx)g_zAti_CurInstance);
    zOss_TaskSendData(EV_ZATI2_CPBR_CNF, (VOID *)pCnf, iLen, g_zAti_Context.taskIdMy);
}

BOOL zAti_SmIpPdpActReq(UINT8 iChnelId, T_ZAti_SmIpDnsInfo* pAddr)
{
    UINT8 iAtiCidNum = 0;
    BYTE bInstance = zAti_GetTaskInstantByChnlId(iChnelId);
    T_ZAti_ChannelInfo *pChnelNode = zAti_GetChannelNodePtr(iChnelId);
    
    if(NULL == pChnelNode) /* ͨûд */
    {
        return FALSE;
    }
    for(iAtiCidNum = 0; iAtiCidNum < ZATI2_SM_MAX_SMCID_NUM; iAtiCidNum++)
    {
        if((g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].chnelId == pChnelNode->iChnelId)
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid >= 1) /* ȡֵ1~4 */
        && (g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid <= ZATI2_SM_MAX_SMCID_NUM)) 
        {
            return zAti_SmGetPdpAddrByCid(g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid, pAddr, g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].extActCid, bInstance);
           // {
            //    return TRUE;
            //}
            //zAti_UsbSioSmIpPdpActReq(g_zAti_SmContext[bInstance].lastCidTab[iAtiCidNum].iCid);
            //return FALSE;
        }
    }
    return FALSE;
}
/**************************************************************************
* ƣ zAti_GetDestTaskByMsgID
*  
* ˵ 
*            
*   ֵ
* ˵ 
**************************************************************************/
BOOL __ps_static_func zAti_GetDestTaskByMsgID(UINT32 msgId, UINT8 *destTask)
{
    UINT16 iTaskMsgMap = 0;
    
    for(iTaskMsgMap = 0; iTaskMsgMap < sizeof(g_TaskMsgMap)/sizeof(T_ZAti_MsgTrnsprncy);iTaskMsgMap++ )
    {
        if(msgId == g_TaskMsgMap[iTaskMsgMap].dwMsgId)
        {
            *destTask = g_TaskMsgMap[iTaskMsgMap].bDestTak;
            if(g_TaskMsgMap[iTaskMsgMap].bDestTak == Z_ATI_TASKID_SM
                || g_TaskMsgMap[iTaskMsgMap].bDestTak == Z_ATI_TASKID_ESM)
            {
                *destTask = zAti_GetTaskIndex(g_zAti_CurInstance);
            }                 
            return TRUE;  
        }        
    }
    return FALSE;
}

BYTE __ps_static_func zAti_ConvertTskIdToSbMdl(BYTE destTask)
{
    switch (destTask)
    {
        case Z_ATI_TASKID_CC:
            return Z_PSMDL_CC;
        case Z_ATI_TASKID_SS:
            return Z_PSMDL_SS;
        case Z_ATI_TASKID_SM:
            return Z_PSMDL_SM;
        case Z_ATI_TASKID_SMS:
            return Z_PSMDL_SMS;
        case Z_ATI_TASKID_UMM:
            return Z_PSMDL_UMM;
        case Z_ATI_TASKID_ESM:
           return Z_PSMDL_ESM;    
        default:
           return 0xff;
    }
}

BOOL zAti_SaveLastCidTab(UINT8 iCid, UINT8 chnelId)
{
    BYTE i = 0;
    BYTE bInstance = zAti_GetTaskInstantByChnlId(chnelId);

    if(iCid == 0 || chnelId == 0)
    {
        return FALSE;
    }

    for(i = 0; i < ZATI2_SM_MAX_SMCID_NUM; i++)
    {
        if(g_zAti_SmContext[bInstance].lastCidTab[i].chnelId == chnelId
            ||g_zAti_SmContext[bInstance].lastCidTab[i].iCid == iCid) /* ҵǰ */
        {
            if(g_zAti_SmContext[bInstance].lastCidTab[i].isNdis && g_zAti_SmContext[bInstance].lastCidTab[i].isUsed)
            {
                return FALSE;
            }
            zOss_Memset(&g_zAti_SmContext[bInstance].lastCidTab[i], 0, sizeof(T_ZAti_LastCidTab));
        }
    }
    
    g_zAti_SmContext[bInstance].lastCidTab[iCid - 1].chnelId = chnelId;
    g_zAti_SmContext[bInstance].lastCidTab[iCid - 1].iCid = iCid;
    g_zAti_SmContext[bInstance].lastCidTab[iCid - 1].isUsed = TRUE;
    g_zAti_SmContext[bInstance].lastCidTab[iCid - 1].isPpp = TRUE;
    g_zAti_SmContext[bInstance].lastCidTab[iCid - 1].isPppActCmplete = TRUE;
    return TRUE;
}


static VOID __ps_4g_func zAti_SaveOnlyCidTab(BYTE bCid, BYTE bExCid, BYTE bExPdpType)
{    
    g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCid - 1].iCid = bCid;
    g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCid - 1].extActCid = bExCid;
    g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCid - 1].extPdpType = bExPdpType;           
    g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCid - 1].isUsed = TRUE;
    g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCid - 1].isNdis = FALSE;
    return;
}


/* 617001591411 ܻ- ܻV3汾ͬʵ*/
UINT8 zAti2_BlGetChnlSrvMode(UINT8 iChnelId)
{
    T_ZAti_ChannelInfo *ptChnlNode = zAti_GetChannelNodePtr(iChnelId);

    if (!ptChnlNode)
    {
        return ZATI2_CHANNEL_SRV_MODE_INVAL;
    }
    else if (ptChnlNode->server_mode == ZATI2_CHANNEL_MODE_CMD)
    {
        return ZATI2_CHANNEL_SRV_MODE_CMD;
    }
    else
    {
        return ZATI2_CHANNEL_SRV_MODE_DATA;
    }
}

/* 617001591411 ܻ- ܻV3汾ͬʵ*/
// 617002532410[7510ʡ]zPS_umm_IsLossOfCoveragezAti2_PsIsInFlyModeӿڱ
BOOL zAti2_PsIsInFlyMode(VOID)
{
    if(zAti_IsSingleCardForOneStandby())
    {
        //return g_zAti_atDataEx[g_zAti_CurInstance].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF;
        if(zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) != ZOSS_INVALID_TASK_ID)
        {
            return g_zAti_atDataEx[Z_ATI_INSNO_1].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF;  
        }
        else
        {
            return g_zAti_atDataEx[Z_ATI_INSNO_2].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF;
        }
    }
    else
    {
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
        return (g_zAti_atDataEx[Z_ATI_INSNO_1].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF && 
                      g_zAti_atDataEx[Z_ATI_INSNO_2].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF) 
                || (g_zAti_atDataEx[Z_ATI_INSNO_1].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF && 
                      g_zAti_atDataEx[Z_ATI_INSNO_2].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN) 
                || (g_zAti_atDataEx[Z_ATI_INSNO_2].tFun.bFunVal == Z_APMMIA_CFUNFUN_DISBOTHRF && 
                      g_zAti_atDataEx[Z_ATI_INSNO_1].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN);
#else
        return FALSE;
#endif
    }    
}
// 616000505421ʡṩûƵӿ
BOOL zAti2_PsRfNotOpen(VOID)
{
    if(zAti_IsSingleCardForOneStandby())
    {
        if(zDev_GetTaskId(Z_ATI_TASKID_UICC, 0) != ZOSS_INVALID_TASK_ID)
        {
            return g_zAti_atDataEx[Z_ATI_INSNO_1].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN;  
        }
        else
        {
            return g_zAti_atDataEx[Z_ATI_INSNO_2].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN;
        }
    }
    else
    {
        return (g_zAti_atDataEx[Z_ATI_INSNO_1].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN && 
                g_zAti_atDataEx[Z_ATI_INSNO_2].tFun.bFunVal == Z_APMMIA_CFUNFUN_MINIFUN);
    }    
}

VOID __ps_4g_func zAti_SmGetIpDnsAddr(BYTE bDnsAddrType, BYTE bDnsAddrlen,BYTE bBufLen, PBYTE pbProtBuf, PBYTE pbDnsAddr)
{
    BYTE  bProtConIdx   = 0;
    BYTE  bProtCon          = 0;
    BYTE  bDnsFieldLen    =0;
    
    for(bProtConIdx = 4; bProtConIdx < bBufLen;)
    {
        bProtCon = *(pbProtBuf + bProtConIdx);
        bDnsFieldLen = *(pbProtBuf + bProtConIdx + 1);
        if(bDnsFieldLen < 2)
        {
            return;
        }
        if ((bProtCon == bDnsAddrType) && (bBufLen >= bDnsFieldLen + 4)
            &&(bDnsFieldLen >= bDnsAddrlen +2))
        {
            zOss_Memcpy(pbDnsAddr, pbProtBuf + bProtConIdx + 2, bDnsAddrlen);
            return;
        }
        bProtConIdx += bDnsFieldLen;
    }
    return;
}
VOID __ps_4g_func zAti_SmGetIpDnsFromPcoProtList(T_ZAti_SmIpDnsInfo* pbDnsInfo, T_zMmiaSm_PcoInfo *pcoInfo, BYTE PdpType)
{
    BYTE bProtIdx = 0;
    T_zMmiaSm_Container *ptProtList       = ZOSS_NULL;
    BYTE bIsPrimaryDns = Z_INVALID;

    for(bProtIdx = 0;bProtIdx < Z_MMIASM_PCO_PROT_ITEM_MAX_NUM; bProtIdx++)
    {
        ptProtList = pcoInfo->atProtList + bProtIdx;
        if(PdpType == Z_APMMIA_SM_IPV4 && ptProtList->wId == Z_ATI_PROTOCOLID_IPCP)
        {
            zAti_SmGetIpDnsAddr(Z_ATI_PRIMDNSSER_ADDR,ZATI2_SM_IPV4_PDPADDR_LEN,pcoInfo->atProtList[bProtIdx].bLen,pcoInfo->atProtList[bProtIdx].abBuf,pbDnsInfo->iPrimaryDns);
            zAti_SmGetIpDnsAddr(Z_ATI_SECMDNSSER_ADDR,ZATI2_SM_IPV4_PDPADDR_LEN,pcoInfo->atProtList[bProtIdx].bLen,pcoInfo->atProtList[bProtIdx].abBuf,pbDnsInfo->iSecondaryDns);
        }
    }

    for(bProtIdx = 0;bProtIdx < Z_MMIASM_PCO_PARA_ITEM_MAX_NUM; bProtIdx++)
    {
        ptProtList = pcoInfo->atAddParaList + bProtIdx;
        
        if(PdpType == Z_APMMIA_SM_IPV4 && ptProtList->wId == 13 && (bIsPrimaryDns == Z_INVALID))
        {
            zOss_Memcpy(pbDnsInfo->iPrimaryDns, pcoInfo->atAddParaList[bProtIdx].abBuf, ZATI2_SM_IPV4_PDPADDR_LEN);
            bIsPrimaryDns = Z_VALID;
        }
        else if(PdpType == Z_APMMIA_SM_IPV4 && ptProtList->wId == 13 && (bIsPrimaryDns == Z_VALID))
        {
            zOss_Memcpy(pbDnsInfo->iSecondaryDns, pcoInfo->atAddParaList[bProtIdx].abBuf, ZATI2_SM_IPV4_PDPADDR_LEN);
            break;
        }
    }
    return;
}
static VOID __ps_4g_func zAti_SmSaveIpv4Addr(T_ZAti_SmIpDnsInfo* pAddr, T_zMmiaSm_PdpAddr *pdpAddr, T_zMmiaSm_PcoInfo *pcoInfo)
{
    zOss_Memset(pAddr->iGateWay, 0, ZATI2_SM_MAX_PDPADDR_LEN);
    zOss_Memcpy(pAddr->iPdpAddr, pdpAddr->abIPv4Addr, ZATI2_SM_IPV4_PDPADDR_LEN);
    zAti_SmGetIpDnsFromPcoProtList(pAddr, pcoInfo,Z_APMMIA_SM_IPV4);
    return;
}

VOID zAti_SmSaveIpv6DnsAddr(T_ZAti_SmIpDnsInfo* pAddr, T_zMmiaSm_PdpAddr *pdpAddr,T_zMmiaSm_PcoInfo *pcoInfo, BOOL bNeedAddIpv4)
{
    BYTE bIdx = 0;
    BYTE bIsPrimaryDns = Z_INVALID;
    BYTE bOffSet = (bNeedAddIpv4 == TRUE)? ZATI2_SM_IPV4_PDPADDR_LEN : 0;
    
    zOss_Memcpy(pAddr->iPdpAddr + bOffSet, pdpAddr->abIPv6Addr, Z_MMIASM_IPV6_ADDR_MAX_LEN);

    for (bIdx = 0; bIdx < Z_MMIASM_PCO_PROT_ITEM_MAX_NUM; bIdx++)
    {
        if(pcoInfo->atProtList[bIdx].wId == 0x8057)
        {
            zAti_SmGetIpDnsAddr(Z_ATI_PRIMDNSSER_ADDR,ZATI2_SM_IPV6_PDPADDR_LEN,pcoInfo->atProtList[bIdx].bLen,pcoInfo->atProtList[bIdx].abBuf,pAddr->iPrimaryDns+bOffSet);
            zAti_SmGetIpDnsAddr(Z_ATI_SECMDNSSER_ADDR,ZATI2_SM_IPV6_PDPADDR_LEN,pcoInfo->atProtList[bIdx].bLen,pcoInfo->atProtList[bIdx].abBuf,pAddr->iSecondaryDns+bOffSet);
        }
    }
    
    for (bIdx = 0; bIdx < Z_MMIASM_PCO_PARA_ITEM_MAX_NUM; bIdx++)
    {
        if((pcoInfo->atAddParaList[bIdx].wId == Z_ATI_ADDPARAID_IPV6DNS) && (bIsPrimaryDns == Z_INVALID))
        {
            zOss_Memcpy(pAddr->iPrimaryDns + bOffSet, pcoInfo->atAddParaList[bIdx].abBuf, ZATI2_SM_IPV6_PDPADDR_LEN);
            bIsPrimaryDns = Z_VALID;
        }
        else if((pcoInfo->atAddParaList[bIdx].wId == Z_ATI_ADDPARAID_IPV6DNS) && (bIsPrimaryDns == Z_VALID))
        {
            zOss_Memcpy(pAddr->iSecondaryDns + bOffSet, pcoInfo->atAddParaList[bIdx].abBuf, ZATI2_SM_IPV6_PDPADDR_LEN);
            break;
        }
    }
    return;
}
static VOID zAti_SmSaveIpv6AddrAfterIpv4(T_ZAti_SmIpDnsInfo* pAddr, T_zMmiaSm_PdpAddr *pdpAddr, T_zMmiaSm_PcoInfo *pcoInfo)
{
    zAti_SmSaveIpv6DnsAddr(pAddr, pdpAddr,pcoInfo, TRUE);
    return;
}

VOID __ps_4g_func zAti_SmSaveIpAddr(T_ZAti_SmIpDnsInfo* pAddr, T_zMmiaSm_PdpAddr *pdpAddr, T_zMmiaSm_PcoInfo *pcoInfo)
{
    if(pAddr->iPdpType == Z_APMMIA_SM_IPV4)
    {
        zAti_SmSaveIpv4Addr(pAddr, pdpAddr, pcoInfo);
    }
    else if(pAddr->iPdpType == Z_APMMIA_SM_IPV4V6)
    {
        zAti_SmSaveIpv4Addr(pAddr, pdpAddr, pcoInfo);
        zAti_SmSaveIpv6AddrAfterIpv4(pAddr, pdpAddr, pcoInfo);
    }
    else if(pAddr->iPdpType == Z_APMMIA_SM_IPV6)
    {
        zOss_Memset(pAddr->iGateWay, 0, ZATI2_SM_MAX_PDPADDR_LEN);
        /*ȡIPV6DNS*/
        zAti_SmSaveIpv6DnsAddr(pAddr, pdpAddr,pcoInfo, FALSE);
    }
    return;
}

BOOL __ps_4g_func zAti_SmGetPdpAddrByCid(UINT8 iCid, T_ZAti_SmIpDnsInfo* pAddr, BYTE bExtActCid, BYTE bInsNo)
{
    T_zMmiaSm_PdpAddr      *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));  
    T_zMmiaSm_PcoInfo      *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));

    if(bExtActCid)
    {
        T_zMmiaSm_PdpAddr                     tPdpAddrExt = {0};  
        T_zMmiaSm_PcoInfo   *ptPcoInfoExt = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));

        if(zAti_GetPdpInfoByCid(iCid, ptPdpAddr, ptPcoInfo, bInsNo) && zAti_GetPdpInfoByCid((UINT8)bExtActCid, &tPdpAddrExt, ptPcoInfoExt, bInsNo))
        {
            pAddr->iPdpType = Z_APMMIA_SM_IPV4V6;
            pAddr->iCid = iCid;
            if(ptPdpAddr->bPdpType == Z_APMMIA_SM_IPV4 && tPdpAddrExt.bPdpType == Z_APMMIA_SM_IPV6)
            {
                zAti_SmSaveIpv4Addr(pAddr, ptPdpAddr, ptPcoInfo);
                zAti_SmSaveIpv6AddrAfterIpv4(pAddr, &tPdpAddrExt, ptPcoInfoExt);
            }
            else if(ptPdpAddr->bPdpType == Z_APMMIA_SM_IPV6 && tPdpAddrExt.bPdpType == Z_APMMIA_SM_IPV4)
            {
                zAti_SmSaveIpv4Addr(pAddr, &tPdpAddrExt, ptPcoInfoExt);
                zAti_SmSaveIpv6AddrAfterIpv4(pAddr, ptPdpAddr, ptPcoInfo);
            }
            else
            {
                zAti_RetUB((VOID**)&ptPdpAddr);
                zAti_RetUB((VOID**)&ptPcoInfo);
                zAti_RetUB((VOID **)&ptPcoInfoExt);
                return FALSE;
            }
            zAti_RetUB((VOID**)&ptPdpAddr);
            zAti_RetUB((VOID**)&ptPcoInfo);
            zAti_RetUB((VOID **)&ptPcoInfoExt);
            return TRUE;
        }
        zAti_RetUB((VOID **)&ptPcoInfoExt);
    }
    if(zAti_GetPdpInfoByCid(iCid, ptPdpAddr, ptPcoInfo, bInsNo)) /* Ѿ*/
    {
        pAddr->iPdpType = ptPdpAddr->bPdpType;
        pAddr->iCid = iCid;
        zAti_SmSaveIpAddr(pAddr, ptPdpAddr, ptPcoInfo);
        zAti_RetUB((VOID**)&ptPdpAddr);
        zAti_RetUB((VOID**)&ptPcoInfo);
        return TRUE;
    }
    zAti_RetUB((VOID**)&ptPdpAddr);
    zAti_RetUB((VOID**)&ptPcoInfo);
    return FALSE;
}

/**************************************************************************
*  : zAti_IsAtChReady
*  : ȷָͨ״̬
* ˵ : (IN)
*            chID     ͨID
*            (OUT)
*   ֵ : ͨ÷OK,򷵻FALSE
* ˵ : ṩûӿ
**************************************************************************/
BOOL  zAti2_IsAtChReady(UINT8 chID)
{
    T_ZAti_ChannelInfo *pChnelNode = zAti_GetChannelNodePtr(chID);
    if(pChnelNode != NULL 
        && pChnelNode->cmd_id == ZAT2_NO_COMMAND 
        && pChnelNode->cmd_op == ZAT2_CO_INVALID)
    {
        return TRUE;
    }
    return FALSE;
}

/************************************************************************
: zAti_EUmcrBand39InfoInd
: 
          UMCR/EUMCR֪ͨATIǷB39
    : pBuff,
    
    أ
ע    ͣ
---------------------------------------------------------------------------
޸        汾        ޸        ޸ԭ     
09.03                                                                        
************************************************************************/
VOID zAti_EUmcrBand39InfoInd(VOID* pBuff)
{
    BYTE bInsCurNo = g_zAti_CurInstance;
    T_zMmiaAs_Band39_Info_Ind  *ptBand39InfoInd = (T_zMmiaAs_Band39_Info_Ind*)pBuff;
    T_zMmiaAs_Band39_Info_Req *ptBand39InfoReq = (T_zMmiaAs_Band39_Info_Req*)zAti_GetUB(sizeof(T_zMmiaAs_Band39_Info_Req));

    ptBand39InfoReq->bBand39Info = ptBand39InfoInd->bBand39Info;

    g_zAti_CurInstance = (g_zAti_CurInstance == Z_ATI_INSNO_1)? 1 : 0;
    zAti_MsgSend(MMIA_AS_B39_INFO_REQ_EV, (PBYTE)ptBand39InfoReq, sizeof(T_zMmiaAs_Band39_Info_Req), Z_ATI_TASKID_GRR);
    g_zAti_CurInstance = bInsCurNo;
    return;
}

/******************************************************************
*    :zAti_ChangeSubActMacro
*    :Эջȫⲿӿڷֵ֮
*                               Ĺϵ
*˵    :617002805927/616000237711ʶH+ʾ֧
*******************************************************************/
BYTE zAti_ChangeSubActMacro(BYTE bSubMode)
{
    BYTE bReturnSubAct = 0xff;

    switch(bSubMode)
    {
        case Z_SUBMODE_NOSERVE:
            bReturnSubAct = 0;
            break;
        case Z_SUBMODE_GSM:
            bReturnSubAct = 1;
            break;
        case Z_SUBMODE_GPRS:
            bReturnSubAct = 2;
            break;
        case Z_SUBMODE_EDGE:
            bReturnSubAct = 3;
            break;
        case Z_SUBMODE_WCDMA:
            bReturnSubAct = 4;
            break;
        case Z_SUBMODE_HSDPA:
            bReturnSubAct = 5;
            break;
        case Z_SUBMODE_HSUPA:
            bReturnSubAct = 6;
            break;
        case Z_SUBMODE_DPA_UPA:
            bReturnSubAct = 7;
            break;
        case Z_SUBMODE_TD:
            bReturnSubAct = 8;
            break;
        case Z_SUBMODE_LTE_TDD:
            bReturnSubAct = 9;
            break;
        case Z_SUBMODE_LTE_FDD:
            bReturnSubAct = 10;
            break;
        case Z_SUBMODE_LTE:
            bReturnSubAct = 11;
            break;
        case Z_SUBMODE_DPAORUPA:
            bReturnSubAct = 12;
            break;
        case Z_SUBMODE_HSPA_PLUS:
            bReturnSubAct = 13;
            break;
        default:
            break;
    }
    return bReturnSubAct;
}
/**************************************************************************
      :zAt_GetCurrntAct
      :ṩƷ߻ȡЭջǰʽ
      :
      :
 ֵ      :BYTE -ǰЭջʽ
                                 (BYTE)0    ޷ 
                                 (BYTE)1    GSMģʽ 
                                 (BYTE)2    GPRSģʽ 
                                 (BYTE)3    EDGEģʽ 
                                 (BYTE)4    WCDMAģʽ 
                                 (BYTE)5    HSDPAģʽ 
                                 (BYTE)6    HSUPAģʽ 
                                 (BYTE)7    HSUPAHSDPAģʽ 
                                 (BYTE)8    TD_SCDMAģʽ 
                                 (BYTE)9    LTEģʽTDD 
                                 (BYTE)10   LTEģʽ FDD
                                 (BYTE)11   LTEģʽ
                                 (BYTE)12    HSDPAHSUPAģʽ 
617001826545LTE Ʒ
**************************************************************************/
BYTE zAt_GetCurrntAct(VOID)
{
    BYTE bSubMode = 0xff;
    /*֧вŵ*/
    if(zAti_IsCidActivedStand(Z_ATI_INSNO_1))
    {
        bSubMode = g_zAti_atDataEx[Z_ATI_INSNO_1].tCurrPlmnPara.bSubMode;
    }
    else if(zAti_IsCidActivedStand(Z_ATI_INSNO_2))
    {
        bSubMode = g_zAti_atDataEx[Z_ATI_INSNO_2].tCurrPlmnPara.bSubMode;
    }
    else
    {
        bSubMode = g_zAti_atDataEx[Z_ATI_INSNO_1].tCurrPlmnPara.bSubMode;
    }

    return zAti_ChangeSubActMacro(bSubMode);
}
/***************************************************************
*:zAti_IsSameOperPlmn
*:жǷΪͬһӪ̵PLMNID
***************************************************************/
BYTE zAti_IsSameOperPlmn(T_z_PlmnId *ptPlmnId1, T_z_PlmnId *ptPlmnId2, BYTE bInsNo)
{
    T_zApMmia_NetName tPlmnId1Full = {0};
    T_zApMmia_NetName tPlmnId2Full = {0};
    T_zApMmia_NetName tPlmnId1Short = {0};
    T_zApMmia_NetName tPlmnId2Short = {0};

    if(Z_INVALID == zAti_IsPlmnIdValid(ptPlmnId1) || Z_INVALID == zAti_IsPlmnIdValid(ptPlmnId2))
    {
        return Z_INVALID;
    }
    /*ΪͬһӪ*/
    if(zAt_GetOperName(Z_ATI_OPER_NUMTOSHORT, ptPlmnId1, (VOID*)&tPlmnId1Short, bInsNo) &&
        zAt_GetOperName(Z_ATI_OPER_NUMTOSHORT, ptPlmnId2, (VOID*)&tPlmnId2Short, bInsNo))
    {
        if(tPlmnId1Short.bLen == tPlmnId2Short.bLen &&
            zAti_MemcmpStr(tPlmnId1Short.abName, tPlmnId2Short.abName, tPlmnId2Short.bLen))
        {
            return Z_VALID;
        }
    }

    /*ΪͬһӪ*/
    if(zAt_GetOperName(Z_ATI_OPER_NUMTOLONG, ptPlmnId1, (VOID*)&tPlmnId1Full, bInsNo) &&
        zAt_GetOperName(Z_ATI_OPER_NUMTOLONG, ptPlmnId2, (VOID*)&tPlmnId2Full, bInsNo))
    {
        if(tPlmnId1Full.bLen == tPlmnId2Full.bLen &&
            zAti_MemcmpStr(tPlmnId1Full.abName, tPlmnId2Full.abName, tPlmnId2Full.bLen))
        {
            return Z_VALID;
        }
    }

    return Z_INVALID;
}

/*********************************************
*:zAti_IsCmccPlmnId
*:жPLMNIDǷΪ
*********************************************/
BYTE __ps_static_func zAti_IsCmccPlmnId(T_z_PlmnId *ptPlmnId, BYTE bInsNo)
{
    if(Z_OPER_CMCC == zAti_GetOperByPlmnId(ptPlmnId, bInsNo))
    {
        return Z_VALID;
    }
    return Z_INVALID;
}

/*********************************************
*:zAti_IsCTPlmnId
*:жPLMNIDǷΪ
*********************************************/
BYTE __ps_static_func zAti_IsCTPlmnId(T_z_PlmnId *ptPlmnId, BYTE bInsNo)
{
    if(Z_OPER_CTCC == zAti_GetOperByPlmnId(ptPlmnId, bInsNo))
    {
        return Z_VALID;
    }
    return Z_INVALID;
}

BYTE __ps_static_func zAti_GetOperByPlmnId(T_z_PlmnId *ptPlmnId, BYTE bInsNo)
{
    T_zApMmia_NetName tShortName = {0};
    BYTE abCmcc[] = {'C','M','C','C'};
    BYTE abCtcc[] = {'C','T'};
    BYTE abUnicom[] = {'U','N','I','C','O','M'};

    if(Z_INVALID == zAti_IsPlmnIdValid(ptPlmnId))
    {
        return Z_OPER_OTHER;
    }

    if(zAt_GetOperName(Z_ATI_OPER_NUMTOSHORT, ptPlmnId, (VOID*)&tShortName, bInsNo))
    {
        if(tShortName.bLen == sizeof(abCmcc) &&
            zAti_MemcmpStr(abCmcc, tShortName.abName, tShortName.bLen))
        {
            return Z_OPER_CMCC;
        }
        else if(tShortName.bLen == sizeof(abCtcc) &&
            zAti_MemcmpStr(abCtcc, tShortName.abName, tShortName.bLen))
        {
            return Z_OPER_CTCC;
        }
        else if(tShortName.bLen == sizeof(abUnicom) &&
            zAti_MemcmpStr(abUnicom, tShortName.abName, tShortName.bLen))
        {
            return Z_OPER_UNICOM;
        }
    }
    return Z_OPER_OTHER;
}

BYTE zAti_GetAppointedOperPlmnByOperName(BYTE bNameFg, BYTE *pName, BYTE *pVal, BYTE bInsNo)
{
    T_zMmiaUmm_OperPlmn *ptPlmn = (T_zMmiaUmm_OperPlmn*)pVal;
    zOss_Memset(ptPlmn, 0xff, sizeof(T_zMmiaUmm_OperPlmn));
    ptPlmn->bNum = 0;

    if(strlen((const char*)pName) == 0)
    {
        return Z_INVALID;
    }

    switch(bNameFg)
    {
        case Z_ATI_LONG_NAME:
            zAti_GetAppointedPlmnIdbyFullName(pName, ptPlmn, bInsNo);
            break;
        case Z_ATI_SHORT_NAME:
            zAti_GetAppointedPlmnIdbyShortName(pName, ptPlmn, bInsNo);
            break;
        default:
            break;
    }

    if(ptPlmn->bNum == 0 || ptPlmn->bNum > Z_MAX_OPERATE_PLMNNUM)
    {
        return Z_INVALID;
    }

    return Z_VALID;
}
/********************************************************************
*:zAti_GetAppointedOperPlmnbyOperPlmnId
*:һPLMNIDȡͬһӪ̵PLMNID
********************************************************************/
BYTE __ps_static_func zAti_GetAppointedOperPlmnByOperPlmnId(T_z_PlmnId *ptPlmnId, BYTE *pVal, BYTE bInsNo)
{
    BYTE i = 0;
    T_zApMmia_NetName tFullName;
    T_zApMmia_NetName tShortName;
    T_zMmiaUmm_OperPlmn *ptPlmn = (T_zMmiaUmm_OperPlmn*)pVal;

    zOss_Memset(&tFullName, 0, sizeof(T_zApMmia_NetName));
    zOss_Memset(&tShortName, 0, sizeof(T_zApMmia_NetName));
    zOss_Memset(ptPlmn, 0xff, sizeof(T_zMmiaUmm_OperPlmn));
    ptPlmn->bNum = 0;

    if(Z_INVALID == zAti_IsPlmnIdValid(ptPlmnId))
    {
        return Z_INVALID;
    }

    zAti_GetCardPlmnInfo(bInsNo);
    /*Ȼȡ,ݶȡͬһӪ̵PLMNID*/
    if(zAt_GetOperName(Z_ATI_OPER_NUMTOSHORT, ptPlmnId, (VOID*)&tShortName, bInsNo))
    {
        zAti_GetAppointedPlmnIdbyShortName(tShortName.abName, ptPlmn, bInsNo);
    }

    if(ptPlmn->bNum < Z_MAX_OPERATE_PLMNNUM)
    {
        if(zAt_GetOperName(Z_ATI_OPER_NUMTOLONG, ptPlmnId, (VOID*)&tFullName, bInsNo))
        {
            zAti_GetAppointedPlmnIdbyFullName(tFullName.abName, ptPlmn, bInsNo);
        }
    }

    /*UMMṩPLMNIDǷѾҵ,ûҵڿд,
        ûпеľ͸һ*/
    for(i = 0; i < ptPlmn->bNum; i++)
    {
        if(Z_VALID == zUmm_IsPlmnIdEqual(ptPlmnId, &ptPlmn->abOperatePlmn[i], bInsNo))
        {
            return Z_VALID;
        }
    }

    if(ptPlmn->bNum < Z_MAX_OPERATE_PLMNNUM)
    {
        ptPlmn->abOperatePlmn[ptPlmn->bNum] = *ptPlmnId;
        ptPlmn->bNum++;
    }
    else
    {
        ptPlmn->abOperatePlmn[Z_MAX_OPERATE_PLMNNUM-1] = *ptPlmnId;
    }

    return Z_VALID;
}

VOID zAti_HandlePppProcCmdError(VOID)
{    
    BYTE bCidIndex = 0;
    BYTE  bAtiNum = 0;
    T_ZAti_ChannelInfo  *pChnelNode = NULL;

    for(bAtiNum = 0; bAtiNum < ZATI2_SM_MAX_SMCID_NUM; bAtiNum++)
    {
        if(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bAtiNum].iCid != 0
        && g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bAtiNum].isPpp
        && !g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bAtiNum].isPppActCmplete)
        {
            bCidIndex = bAtiNum;
            pChnelNode = zAti_GetChannelNodePtr(g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].chnelId);
            if(pChnelNode != NULL)
            {
                if(ZATI2_CHANNEL_MODE_DATA ==pChnelNode->server_mode)
                {
                    zAti_HandleNoCarrierCnf(0xff, g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex].chnelId);
                }
            }
            zOss_Memset(&g_zAti_SmContext[g_zAti_CurInstance].lastCidTab[bCidIndex], 0, sizeof(T_ZAti_LastCidTab));
            return;
        }
    }
}

#ifdef Z_DUALSTANDBY
VOID zAti_CsCallStartInd(VOID *pDataPtr)
{
    if (Z_VALID == zAti_IsDualPsDualUicc())
    {
    #ifdef Z_SINGLEANTENNA
        g_zAti_CurInstance = g_zAti_CurInstance == 0? 1: 0;
    
        zAti_MsgSend(MMIA_UMM_CS_CALL_START_IND_EV, ZOSS_NULL, 0, Z_ATI_TASKID_UMM);
        
        g_zAti_CurInstance = g_zAti_CurInstance == 0? 1: 0;
    #endif
    }
}
#endif

#ifdef Z_DUALSTANDBY
VOID zAti_CsCallEndInd(VOID *pDataPtr)
{
    if (Z_VALID == zAti_IsDualPsDualUicc())
    {
    #ifdef Z_SINGLEANTENNA
        g_zAti_CurInstance = g_zAti_CurInstance == 0? 1: 0;
    
        zAti_MsgSend(MMIA_UMM_CS_CALL_END_IND_EV, ZOSS_NULL, 0, Z_ATI_TASKID_UMM);
        
        g_zAti_CurInstance = g_zAti_CurInstance == 0? 1: 0; 
    #endif
    }
}
#endif
/************************************************************
:zAti_ClearPcoChap
:ȫֱCHAPȨϢ
************************************************************/
VOID __ps_static_func zAti_ClearPcoChap(VOID)
{
    zOss_Memset(g_zAti_atDataEx[Z_ATI_INSNO_1].tPcoChapAuth,0,ZATI2_SM_MAX_SMCID_NUM * sizeof(T_ZAti_PcoChapInfo));
    zOss_Memset(g_zAti_atDataEx[Z_ATI_INSNO_2].tPcoChapAuth,0,ZATI2_SM_MAX_SMCID_NUM * sizeof(T_ZAti_PcoChapInfo));
}
/************************************************************
:zAti_ClearPcoChapByCid
:ȫֱCHAPȨϢ
************************************************************/
VOID __ps_4g_func zAti_ClearPcoChapByCid(BYTE bCid)
{
    if (bCid > 0 && bCid <= ZATI2_SM_MAX_SMCID_NUM)
    {
        zOss_Memset(&g_zAti_atDataEx[g_zAti_CurInstance].tPcoChapAuth[bCid-1], 0, sizeof(T_ZAti_PcoChapInfo));
    }
}

VOID zAti_GetEmInfoMutex(BYTE bInsIdx)
{
    zOss_GetMutex(g_zAti_EmInfoMutex[bInsIdx].mutexEmInfo, ZOSS_WAIT_FOREVER);
}

VOID zAti_PutEmInfoMutex(BYTE bInsIdx)
{
    if (g_zAti_EmInfoMutex[bInsIdx].mutexEmInfo != NULL)
    {
        zOss_PutMutex(g_zAti_EmInfoMutex[bInsIdx].mutexEmInfo);
    }
}

VOID zAti_DecreaseReqCountAndRelMutexSemaphore(VOID)
{
    if (g_zAti_EmInfo[g_zAti_CurInstance].dwReqCount > 0)
    {
        g_zAti_EmInfo[g_zAti_CurInstance].dwReqCount--;
    }

    /*ͷţҪͷźǰͷ*/
    zAti_PutEmInfoMutex(g_zAti_CurInstance);
 
    if (g_zAti_EmInfoSemaphore[g_zAti_CurInstance].semaphoreEmInfo != NULL)
    {
        zOss_PutSemaphore(g_zAti_EmInfoSemaphore[g_zAti_CurInstance].semaphoreEmInfo);
    }
}
VOID zAti_EMCellInfoReq(VOID)
{
    T_zMmiaAs_CellInfo_Qry_Req tCellInfoQryReq = {0};
#if defined (DUAL_CARD_DUAL_STANDBY) || defined (_OS_WIN)
    tCellInfoQryReq.bSrcIndex = (g_zAti_CurInstance == 0) ? 0 : 255;/*Чͨţʵ10ʵ2255*/
#else
    tCellInfoQryReq.bSrcIndex = 0;/*ʵ10*/
#endif
    tCellInfoQryReq.bDesIndex = 0xff;

    /*յ,ͼһ*/
    zAti_GetEmInfoMutex(g_zAti_CurInstance);
    g_zAti_EmInfo[g_zAti_CurInstance].dwReqCount++;
    
    if (Z_APMMIA_NORESULT != zAti_EM_CellInfoQryReq(&tCellInfoQryReq))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        /*ʧҪָԭģҪͷŻͱεź*/
        zAti_DecreaseReqCountAndRelMutexSemaphore();
        return ;
    }

    if ((g_zAti_EmInfo[g_zAti_CurInstance].ptEmInfo == ZOSS_NULL))
    {
        g_zAti_EmInfo[g_zAti_CurInstance].ptEmInfo = (T_zEM_EmInfo_Ind *)zOss_GetUB(sizeof(T_zEM_EmInfo_Ind));
        
        if (g_zAti_EmInfo[g_zAti_CurInstance].ptEmInfo == ZOSS_NULL)
        {
            zAti_SendExpt2TraceAgt(ERR_NvFailure,  TRACE_ERR_LEVEL_SEVERE,"");
            /*ʧҪָԭģҪͷŻͱεź*/
            zAti_DecreaseReqCountAndRelMutexSemaphore();
            return ;
        }
    }
    /*ͷ*/
    zAti_PutEmInfoMutex(g_zAti_CurInstance);

    return;
}
/**************************************************************************
*  : zAti_GetEMCellInfo
*  : ȡģʽСϢ
* ˵ : pEmInfo: ṹT_zEM_EmInfo_Ind
*            bInstanceIdx: ʵ,0ʾ11ʾ2
*                         汾0˫汾ʵʴд01
*   ֵ : ɹZATI2_SUCCESS (0)
* ˵ : ṩûӿڣʧ˵ʱûлȡ
**************************************************************************/
SINT32 zAti_GetEMCellInfo(UINT8 *pEmInfo, UINT8 bInstanceIdx)
{
    T_ZAti_EMCellInfo_Req tEMCellInfo = {0};

    if (pEmInfo == ZOSS_NULL || (bInstanceIdx != 0 && bInstanceIdx != 1))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        return ZATI2_FALSE;
    }

    bInstanceIdx = ((bInstanceIdx == Z_ATI_INSNO_1)? Z_ATI_INSNO_1 : Z_ATI_INSNO_2);
    tEMCellInfo.bInstance = bInstanceIdx;

    if (ZOSS_SUCCESS != zOss_TaskSend(EV_ZATI2_ZEMCELLINFO_REQ, &tEMCellInfo, sizeof(T_ZAti_EMCellInfo_Req), g_zAti_Context.taskIdMy))
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        return ZATI2_FALSE;
    }

    zOss_GetSemaphore(g_zAti_EmInfoSemaphore[bInstanceIdx].semaphoreEmInfo, ZOSS_WAIT_FOREVER);

    zAti_GetEmInfoMutex(bInstanceIdx);
    
    if (g_zAti_EmInfo[bInstanceIdx].ptEmInfo != ZOSS_NULL)
    {
        zOss_Memcpy(pEmInfo, g_zAti_EmInfo[bInstanceIdx].ptEmInfo, sizeof(T_zEM_EmInfo_Ind));
        /*ˣͷڴ*/
        if (g_zAti_EmInfo[bInstanceIdx].dwReqCount == 0)
        {
            zAti_RetUB((VOID **)&g_zAti_EmInfo[bInstanceIdx].ptEmInfo);
        }
        zAti_PutEmInfoMutex(bInstanceIdx);
    }
    else
    {
        zAti_SendExpt2TraceAgt(ERR_InvalidPara,  TRACE_ERR_LEVEL_NORMAL,"");
        zAti_PutEmInfoMutex(bInstanceIdx);
        return ZATI2_FALSE;
    }

    return ZATI2_SUCCESS;
}

static UINT8 PADDING[64] = {
  0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* F, G, H and I are basic MD5 functions */
#define F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define G(x, y, z) (((x) & (z)) | ((y) & (~z)))
#define H(x, y, z) ((x) ^ (y) ^ (z))
#define I(x, y, z) ((y) ^ ((x) | (~z)))

/* ROTATE_LEFT rotates x left n bits */
#define ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

/* FF, GG, HH, and II transformations for rounds 1, 2, 3, and 4 */
/* Rotation is separate from addition to prevent recomputation */
#define FF(a, b, c, d, x, s, ac) \
  {(a) += F ((b), (c), (d)) + (x) + (UINT32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define GG(a, b, c, d, x, s, ac) \
  {(a) += G ((b), (c), (d)) + (x) + (UINT32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define HH(a, b, c, d, x, s, ac) \
  {(a) += H ((b), (c), (d)) + (x) + (UINT32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }
#define II(a, b, c, d, x, s, ac) \
  {(a) += I ((b), (c), (d)) + (x) + (UINT32)(ac); \
   (a) = ROTATE_LEFT ((a), (s)); \
   (a) += (b); \
  }

#ifdef __STDC__
#define UL(x)   x##UL
#else
#ifdef WIN32
#define UL(x)   x##UL
#else
#define UL(x)   x
#endif
#endif
VOID zAti_MD5Init (T_zAti_Md5Ctx *mdContext)
{
  mdContext->i[0] = mdContext->i[1] = (UINT32)0;

  /* Load magic initialization constants.
   */
  mdContext->buf[0] = (UINT32)0x67452301UL;
  mdContext->buf[1] = (UINT32)0xefcdab89UL;
  mdContext->buf[2] = (UINT32)0x98badcfeUL;
  mdContext->buf[3] = (UINT32)0x10325476UL;
  return;
}

/* The routine MD5Update updates the message-digest context to
   account for the presence of each of the characters inBuf[0..inLen-1]
   in the message whose digest is being computed.
 */
VOID zAti_MD5Update(T_zAti_Md5Ctx *mdContext, UINT8 *inBuf, UINT32 inLen)
{
  UINT32 in[16];
  SINT32 mdi;
  UINT32 i, ii;
 
  /* compute number of bytes mod 64 */
  mdi = (SINT32)((mdContext->i[0] >> 3) & 0x3F);

  /* update number of bits */
  if ((mdContext->i[0] + ((UINT32)inLen << 3)) < mdContext->i[0])
    mdContext->i[1]++;
  mdContext->i[0] += ((UINT32)inLen << 3);
  mdContext->i[1] += ((UINT32)inLen >> 29);

  while (inLen--) {
    /* add new character to buffer, increment mdi */
    mdContext->in[mdi++] = *inBuf++;

    /* transform if necessary */
    if (mdi == 0x40) {
      for (i = 0, ii = 0; i < 16; i++, ii += 4)
        in[i] = (((UINT32)mdContext->in[ii+3]) << 24) |
                (((UINT32)mdContext->in[ii+2]) << 16) |
                (((UINT32)mdContext->in[ii+1]) << 8) |
                ((UINT32)mdContext->in[ii]);
      zAti_Transform (mdContext->buf, in);
      mdi = 0;
    }
  }
  return;
}

/* The routine MD5Final terminates the message-digest computation and
   ends with the desired message digest in mdContext->digest[0...15].
 */
VOID zAti_MD5Final (UINT8 hash[], T_zAti_Md5Ctx *mdContext)
{
  UINT32 in[16];
  SINT32 mdi;
  UINT32 i, ii;
  UINT32 padLen;

  /* save number of bits */
  in[14] = mdContext->i[0];
  in[15] = mdContext->i[1];

  /* compute number of bytes mod 64 */
  mdi = (SINT32)((mdContext->i[0] >> 3) & 0x3F);

  /* pad out to 56 mod 64 */
  padLen = (UINT32)((mdi < 56) ? (56 - mdi) : (120 - mdi));
  zAti_MD5Update (mdContext, PADDING, padLen);

  /* append length in bits and transform */
  for (i = 0, ii = 0; i < 14; i++, ii += 4)
    in[i] = (((UINT32)mdContext->in[ii+3]) << 24) |
            (((UINT32)mdContext->in[ii+2]) << 16) |
            (((UINT32)mdContext->in[ii+1]) << 8) |
            ((UINT32)mdContext->in[ii]);
  zAti_Transform (mdContext->buf, in);

  /* store buffer in digest */
  for (i = 0, ii = 0; i < 4; i++, ii += 4) {
    mdContext->digest[ii] = (UINT8)(mdContext->buf[i] & 0xFF);
    mdContext->digest[ii+1] =
      (UINT8)((mdContext->buf[i] >> 8) & 0xFF);
    mdContext->digest[ii+2] =
      (UINT8)((mdContext->buf[i] >> 16) & 0xFF);
    mdContext->digest[ii+3] =
      (UINT8)((mdContext->buf[i] >> 24) & 0xFF);
  }
  zOss_Memcpy(hash, mdContext->digest, 16);
  return;
}

/* Basic MD5 step. Transforms buf based on in.
 */
static VOID zAti_Transform (UINT32 *buf, UINT32 *in)
{
  UINT32 a = buf[0], b = buf[1], c = buf[2], d = buf[3];

  /* Round 1 */
#define ZATI_S11 7
#define ZATI_S12 12
#define ZATI_S13 17
#define ZATI_S14 22
  FF ( a, b, c, d, in[ 0], ZATI_S11, UL(3614090360)); /* 1 */
  FF ( d, a, b, c, in[ 1], ZATI_S12, UL(3905402710)); /* 2 */
  FF ( c, d, a, b, in[ 2], ZATI_S13, UL( 606105819)); /* 3 */
  FF ( b, c, d, a, in[ 3], ZATI_S14, UL(3250441966)); /* 4 */
  FF ( a, b, c, d, in[ 4], ZATI_S11, UL(4118548399)); /* 5 */
  FF ( d, a, b, c, in[ 5], ZATI_S12, UL(1200080426)); /* 6 */
  FF ( c, d, a, b, in[ 6], ZATI_S13, UL(2821735955)); /* 7 */
  FF ( b, c, d, a, in[ 7], ZATI_S14, UL(4249261313)); /* 8 */
  FF ( a, b, c, d, in[ 8], ZATI_S11, UL(1770035416)); /* 9 */
  FF ( d, a, b, c, in[ 9], ZATI_S12, UL(2336552879)); /* 10 */
  FF ( c, d, a, b, in[10], ZATI_S13, UL(4294925233)); /* 11 */
  FF ( b, c, d, a, in[11], ZATI_S14, UL(2304563134)); /* 12 */
  FF ( a, b, c, d, in[12], ZATI_S11, UL(1804603682)); /* 13 */
  FF ( d, a, b, c, in[13], ZATI_S12, UL(4254626195)); /* 14 */
  FF ( c, d, a, b, in[14], ZATI_S13, UL(2792965006)); /* 15 */
  FF ( b, c, d, a, in[15], ZATI_S14, UL(1236535329)); /* 16 */

  /* Round 2 */
#define ZATI_S21 5
#define ZATI_S22 9
#define ZATI_S23 14
#define ZATI_S24 20
  GG ( a, b, c, d, in[ 1], ZATI_S21, UL(4129170786)); /* 17 */
  GG ( d, a, b, c, in[ 6], ZATI_S22, UL(3225465664)); /* 18 */
  GG ( c, d, a, b, in[11], ZATI_S23, UL( 643717713)); /* 19 */
  GG ( b, c, d, a, in[ 0], ZATI_S24, UL(3921069994)); /* 20 */
  GG ( a, b, c, d, in[ 5], ZATI_S21, UL(3593408605)); /* 21 */
  GG ( d, a, b, c, in[10], ZATI_S22, UL(  38016083)); /* 22 */
  GG ( c, d, a, b, in[15], ZATI_S23, UL(3634488961)); /* 23 */
  GG ( b, c, d, a, in[ 4], ZATI_S24, UL(3889429448)); /* 24 */
  GG ( a, b, c, d, in[ 9], ZATI_S21, UL( 568446438)); /* 25 */
  GG ( d, a, b, c, in[14], ZATI_S22, UL(3275163606)); /* 26 */
  GG ( c, d, a, b, in[ 3], ZATI_S23, UL(4107603335)); /* 27 */
  GG ( b, c, d, a, in[ 8], ZATI_S24, UL(1163531501)); /* 28 */
  GG ( a, b, c, d, in[13], ZATI_S21, UL(2850285829)); /* 29 */
  GG ( d, a, b, c, in[ 2], ZATI_S22, UL(4243563512)); /* 30 */
  GG ( c, d, a, b, in[ 7], ZATI_S23, UL(1735328473)); /* 31 */
  GG ( b, c, d, a, in[12], ZATI_S24, UL(2368359562)); /* 32 */

  /* Round 3 */
#define ZATI_S31 4
#define ZATI_S32 11
#define ZATI_S33 16
#define ZATI_S34 23
  HH ( a, b, c, d, in[ 5], ZATI_S31, UL(4294588738)); /* 33 */
  HH ( d, a, b, c, in[ 8], ZATI_S32, UL(2272392833)); /* 34 */
  HH ( c, d, a, b, in[11], ZATI_S33, UL(1839030562)); /* 35 */
  HH ( b, c, d, a, in[14], ZATI_S34, UL(4259657740)); /* 36 */
  HH ( a, b, c, d, in[ 1], ZATI_S31, UL(2763975236)); /* 37 */
  HH ( d, a, b, c, in[ 4], ZATI_S32, UL(1272893353)); /* 38 */
  HH ( c, d, a, b, in[ 7], ZATI_S33, UL(4139469664)); /* 39 */
  HH ( b, c, d, a, in[10], ZATI_S34, UL(3200236656)); /* 40 */
  HH ( a, b, c, d, in[13], ZATI_S31, UL( 681279174)); /* 41 */
  HH ( d, a, b, c, in[ 0], ZATI_S32, UL(3936430074)); /* 42 */
  HH ( c, d, a, b, in[ 3], ZATI_S33, UL(3572445317)); /* 43 */
  HH ( b, c, d, a, in[ 6], ZATI_S34, UL(  76029189)); /* 44 */
  HH ( a, b, c, d, in[ 9], ZATI_S31, UL(3654602809)); /* 45 */
  HH ( d, a, b, c, in[12], ZATI_S32, UL(3873151461)); /* 46 */
  HH ( c, d, a, b, in[15], ZATI_S33, UL( 530742520)); /* 47 */
  HH ( b, c, d, a, in[ 2], ZATI_S34, UL(3299628645)); /* 48 */

  /* Round 4 */
#define ZATI_S41 6
#define ZATI_S42 10
#define ZATI_S43 15
#define ZATI_S44 21
  II ( a, b, c, d, in[ 0], ZATI_S41, UL(4096336452)); /* 49 */
  II ( d, a, b, c, in[ 7], ZATI_S42, UL(1126891415)); /* 50 */
  II ( c, d, a, b, in[14], ZATI_S43, UL(2878612391)); /* 51 */
  II ( b, c, d, a, in[ 5], ZATI_S44, UL(4237533241)); /* 52 */
  II ( a, b, c, d, in[12], ZATI_S41, UL(1700485571)); /* 53 */
  II ( d, a, b, c, in[ 3], ZATI_S42, UL(2399980690)); /* 54 */
  II ( c, d, a, b, in[10], ZATI_S43, UL(4293915773)); /* 55 */
  II ( b, c, d, a, in[ 1], ZATI_S44, UL(2240044497)); /* 56 */
  II ( a, b, c, d, in[ 8], ZATI_S41, UL(1873313359)); /* 57 */
  II ( d, a, b, c, in[15], ZATI_S42, UL(4264355552)); /* 58 */
  II ( c, d, a, b, in[ 6], ZATI_S43, UL(2734768916)); /* 59 */
  II ( b, c, d, a, in[13], ZATI_S44, UL(1309151649)); /* 60 */
  II ( a, b, c, d, in[ 4], ZATI_S41, UL(4149444226)); /* 61 */
  II ( d, a, b, c, in[11], ZATI_S42, UL(3174756917)); /* 62 */
  II ( c, d, a, b, in[ 2], ZATI_S43, UL( 718787259)); /* 63 */
  II ( b, c, d, a, in[ 9], ZATI_S44, UL(3951481745)); /* 64 */

  buf[0] += a;
  buf[1] += b;
  buf[2] += c;
  buf[3] += d;
  return;
}

VOID zAti_GetMd5Hash(CHAR id, CHAR* secret, UINT8 secretLen, CHAR* challenge, UINT8 challengeLen, CHAR* hashOut)
{
    T_zAti_Md5Ctx mdContext = {0};
    
    if(secret == NULL || challenge == NULL || hashOut == NULL || secretLen == 0 || challengeLen == 0)
    {
        return;
    }
    zAti_MD5Init(&mdContext);
    zAti_MD5Update(&mdContext, (UINT8 *)&id, 1);
    zAti_MD5Update(&mdContext, (UINT8 *)secret, (UINT32)secretLen);
    zAti_MD5Update(&mdContext, (UINT8 *)challenge, (UINT32)challengeLen);
    zAti_MD5Final((UINT8 *)hashOut, &mdContext); 
    return;
}
T_z_PlmnId zAti_GetCurrPlmn(BYTE bInsIdx)
{
    return g_zAti_atDataEx[bInsIdx].tCurrPlmnPara.tPlmnId;
}


BOOL __ps_4g_func zAti_CidIsUsed(BYTE bCid)
{
    BOOL bResult = FALSE;
    T_zMmiaSm_PdpAddr  *ptPdpAddr = (T_zMmiaSm_PdpAddr*)zAti_GetUB(sizeof(T_zMmiaSm_PdpAddr));
    T_zMmiaSm_PcoInfo   *ptPcoInfo = (T_zMmiaSm_PcoInfo*)zAti_GetUB(sizeof(T_zMmiaSm_PcoInfo));
    
    if (zAti_IsCidUsed(bCid) || zAti_GetPdpInfoByCid(bCid, ptPdpAddr, ptPcoInfo, g_zAti_CurInstance))
    {
        bResult = TRUE;
    }
    else
    {
        bResult = FALSE;
    }
    zAti_RetUB((VOID**)&ptPdpAddr);
    zAti_RetUB((VOID**)&ptPcoInfo);
    return bResult;
}
