#ifndef BASTYPES_H

#define BASTYPES_H 1

#if defined(PCTEST) || defined(SGOLD) || defined (SGOLDLITE) || defined(SGOLD3) || defined(SGOLDRADIO) || defined(_WIN32)
#define near
#define xnear
#define far
#define huge
#define bit

#elif defined (STARCORE)
#define near
#define bit

#else
#define near 
#define xnear 
#define far  
#define bit  
#endif

#ifdef _OS_LINUX
# undef bit
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#ifndef NULL
#define NULL    ((void *)0)
#endif

#define STD_OK    0
#ifndef STD_ERR
#define STD_ERR (-1)
#endif

#include "pub.h"
#define int16               short

#define int32               long int

typedef unsigned char       ubyte; 
typedef signed   char       sbyte; 
typedef signed   int16      sshort;
typedef signed   int32      slong; 

typedef signed  long    S64;
#ifndef _OS_WIN
typedef unsigned long  U64_T;  
#else
typedef DWORD64  U64_T;
#endif
#ifdef _OS_WIN
#if !defined ALI_FILE_VER 

typedef signed char         S8;
typedef signed short        S16;
typedef unsigned char       U8;
typedef unsigned short      U16;

typedef signed int          S32;
typedef unsigned int        U32;

#if !defined SDTENV
#if defined(UNITEST) && defined(_WIN32)
typedef __int64             S64;
typedef __int64             U64;
#else
typedef signed  long    S64;
typedef unsigned  long  U64;
#endif
#endif
#endif
typedef unsigned  long  U64;
#endif

#if defined (__arm) || defined (_USE_CMPL_GCC) || defined (_ENTERPRISE_C_) || defined (UNITEST)
//note: 
//"Enterprise C" is a compiler 
//for StarCore by Metrowerks
typedef unsigned int        uint;
#endif 



#if defined(_WIN32)

#undef shuge
#define shuge

typedef unsigned char       UINT8;
typedef unsigned short      UINT16;

#if !defined UNITEST
typedef unsigned char       U8;
typedef unsigned short      U16;
#endif

#endif 


#ifdef __CYGWIN__
typedef unsigned long    ulong;
#elif defined(_Windows)
typedef unsigned long    ulong;
typedef unsigned short   ushort;
#else
#if !defined X_SCTTYPES_H || defined (__arm) || defined (_USE_CMPL_GCC) || defined (_ENTERPRISE_C_)
typedef unsigned long    ulong;
typedef unsigned short ushort;
#endif
#endif

#if defined (WIN32) || defined (_Windows)
typedef __int64 ullong;
typedef __int64 sllong;
#define  LL(a) (a)
#define ULL(a) (a)
#elif defined (__arm) || defined (_USE_CMPL_GCC) || defined (_ENTERPRISE_C_) || \
      (defined (__GNUC__) && !defined (__STRICT_ANSI__)) || \
      (defined (SUN5_ANSICC) && (__STDC__ == 0) && !defined(_POSIX_C_SOURCE) && !defined(_XOPEN_SOURCE))
typedef unsigned long long ullong;
typedef   signed long long sllong;
#define  LL(a) (a##LL)
#define ULL(a) (a##ULL)
#else
#define LONGLONG_EMUL 1
typedef struct
{
  slong hi;
  ulong lo;
} sllong;
typedef struct
{
  ulong hi;
  ulong lo;
} ullong;
#endif

#ifndef MS_UNUSED_VAR
#define MS_UNUSED_VAR(a)  {if(sizeof(a)){}}
#endif

#endif
