/************************************************************************
* Ȩ (C)2007,ͨѶɷ޹˾
* 
* ļƣ ms_os.h
* ļʶ 
* ժҪ External declarations of interface routines to the operation system.
*
* ޸     汾     ޸ı     ޸	     ޸      
* -----------------------------------------------------------------------
* 2008/06/27  	    V0.5		                                               
************************************************************************/

#ifndef _MS_OS_H_
#define _MS_OS_H_

#include <stddef.h>
#include "base_api.h"
/*#include "ms_hwtrc.h"*/   /* Trace interface as standard out, hwtrc_print(). */

#if MS_OS_CRITICAL_SECTION_SUPPORT > 0
#include "ms_crit.h"
#endif


/*===========================================================================
Exported Type Declarations
===========================================================================*/

/**B*************************************************************************
 * Macro:        OS_pid_t
 *---------------------------------------------------------------------------
 * Purpose:      PID of an operation system process.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define OS_pid_t     SDL_PId
#define OS_SDL_NULL  SDL_NULL


/**B*************************************************************************
 * Macro:        OS_no_sig_params_t
 *---------------------------------------------------------------------------
 * Purpose:      Used to allocate a signal without parameters.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define OS_no_sig_params_t  XSIGNALHEADERTYPE


/*===========================================================================
Exported Macro Declarations
===========================================================================*/

/**B*************************************************************************
 * Macro:        os_mem_xalloc
 *----------------------------------------------------------------------------
 * Purpose:      mallocs dynamic memory
 *
 * Parameters:   size: number of bytes to be malloced
 *
 * Returns:      pointer to first byte of memory
 *
 * Remarks:
 ***E************************************************************************/
/**B*************************************************************************
 * Macro:        os_mem_xfree
 *----------------------------------------------------------------------------
 * Purpose:      frees dynamic memory
 *
 * Parameters:   ptr:  pointer to memory to be returned
 *
 * Returns:      nothing
 *
 * Remarks:
 ***E************************************************************************/

#define os_mem_xalloc(ptr_, size_)  (ptr_) = ps_malloc(size_);
#define os_mem_xfree(ptr_)          {ps_free( *((void **)&(ptr_))); *((void **)&(ptr_)) = NULL;}


/**B*************************************************************************
 * Macro:        os_msleep
 *---------------------------------------------------------------------------
 * Purpose:      see below os_sleep_ms
 *
 * Parameters:   see below.
 *
 * Returns:      see below.
 ***E************************************************************************/

#define os_msleep(millisec_)    os_sleep_ms(millisec_)


/**B*************************************************************************
 * Macro:        os_next_state
 *---------------------------------------------------------------------------
 * Purpose:      Go back to the read entry point of the process.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_next_state(p_var_, state_)  goto os_process_loop_l


/**B*************************************************************************
 * Macro:        os_now
 *---------------------------------------------------------------------------
 * Purpose:      Return the number of ticks since system start.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_now(sample_id)    RetrieveClock(sample_id)



/**B*************************************************************************
 * Macro:        os_outsig_declare
 *---------------------------------------------------------------------------
 * Purpose:      Declaration of an output signal.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_outsig_declare  xSignalHeaderRec  *yOutputSignalPtr;


/**B*************************************************************************
 * Macro:        os_outsig_get
 *---------------------------------------------------------------------------
 * Purpose:      Get the pointer to the output signal.
 *
 * Parameters:   None.
 *
 * Returns:      Pointer to the output signal.
 ***E************************************************************************/

#define os_outsig_get()  (void *)(yOutputSignalPtr)


/**B*************************************************************************
 * Macro:        OS_PROCESS
 *---------------------------------------------------------------------------
 * Purpose:      Declaration of an operating system task.
 *
 * Parameters:   x: task name.
 *
 * Returns:      None.
 ***E************************************************************************/
#ifdef OS_PROCESS
#undef OS_PROCESS
#endif
#define OS_PROCESS(x) void x(UNSIGNED argc, VOID *argv)
#define OS_PROCESS_RETURN(value_)  return;


/**B*************************************************************************
 * Macro:        os_process_begin
 *---------------------------------------------------------------------------
 * Purpose:      Define the startup of an operting system process with
 *               input queue.
 *
 * Parameters:   Process variables with the generic header os_process_var.
 *
 * Returns:      None.
 ***E************************************************************************/
/*
// P98C-YXS #if 0
// P98C-YXS //#ifdef _OS_WIN
// P98C-YXS #if defined UNITEST
// P98C-YXS #define os_process_begin(var_, self_id_) \
// P98C-YXS    unsigned char SelfId = self_id_; \
// P98C-YXS    memset ( (void *) yVarP, 0, sizeof ( var_ ) ); \
// P98C-YXS    yVarP->Self = ( (struct args *) argv ) -> self; \
// P98C-YXS    yVarP->SelfId = (unsigned char)( ( (struct args *) argv ) -> self_id ); \
// P98C-YXS    yVarP->Offspring = SDL_NULL; \
// P98C-YXS    yVarP->SaveQ.succ = &(yVarP->SaveQ); \
// P98C-YXS    yVarP->SaveQ.pred = &(yVarP->SaveQ); \
// P98C-YXS    yVarP->CurrentInSaveQ = &(yVarP->SaveQ); \
// P98C-YXS    yVarP->yInSignalPtr = 0; 
// P98C-YXS #else
// P98C-YXS #define os_process_begin(var_, self_id_) \
// P98C-YXS    unsigned char SelfId = self_id_; \
// P98C-YXS    (void) argc; \
// P98C-YXS    memset ( (void *) yVarP, 0, sizeof ( var_ ) ); \
// P98C-YXS    yVarP->Self = ( (struct args *) argv ) -> self; \
// P98C-YXS    yVarP->SelfId = (unsigned char)( ( (struct args *) argv ) -> self_id ); \
// P98C-YXS    yVarP->Offspring = SDL_NULL; \
// P98C-YXS    yVarP->SaveQ.succ = &(yVarP->SaveQ); \
// P98C-YXS    yVarP->SaveQ.pred = &(yVarP->SaveQ); \
// P98C-YXS    yVarP->CurrentInSaveQ = &(yVarP->SaveQ); \
// P98C-YXS    yVarP->yInSignalPtr = 0; 
// P98C-YXS #endif
// P98C-YXS //#endif
// P98C-YXS //#else
// P98C-YXS #endif
*/

#if defined UNITEST
#define os_process_begin(var_) \
   TID            SelfId; \
   memset ( (void *) yVarP, 0, sizeof ( var_ ) ); \
   yVarP->Self = ( (struct args *) argv ) -> self; \
   yVarP->SelfId = (unsigned char)( ( (struct args *) argv ) -> self_id ); \
   yVarP->Offspring = SDL_NULL; \
   yVarP->SaveQ.succ = &(yVarP->SaveQ); \
   yVarP->SaveQ.pred = &(yVarP->SaveQ); \
   yVarP->CurrentInSaveQ = &(yVarP->SaveQ); \
   yVarP->yInSignalPtr = 0; 
#else
#define os_process_begin(var_) \
   TID            SelfId; \
   (void) argc; \
   memset ( (void *) yVarP, 0, sizeof ( var_ ) ); \
   yVarP->Self = ( (struct args *) argv ) -> self; \
   yVarP->SelfId = (unsigned char)( ( (struct args *) argv ) -> self_id ); \
   yVarP->Offspring = SDL_NULL; \
   yVarP->SaveQ.succ = &(yVarP->SaveQ); \
   yVarP->SaveQ.pred = &(yVarP->SaveQ); \
   yVarP->CurrentInSaveQ = &(yVarP->SaveQ); \
   yVarP->yInSignalPtr = 0; 
#endif
//#endif

/**B*************************************************************************
 * Macro:        os_process_loop
 *---------------------------------------------------------------------------
 * Purpose:      Free the consumed signal and wait for the next signal on the
 *               input queue with the blocked method.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_process_loop(var_) \
    os_process_loop_l: \
        os_signal_free (var_##.yInSignalPtr); \
        var_##.yInSignalPtr = os_signal_receive (var_##.Self);


/**B*************************************************************************
 * Macro:        os_process_vars
 *---------------------------------------------------------------------------
 * Purpose:      Generic header of the process variables.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_process_vars   PROCESS_VARS


/**B*************************************************************************
 * Macro:        OS_PROCESS_ID
 *---------------------------------------------------------------------------
 * Purpose:      Process Id of the current process
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_current_process()  (yVarP->Self)


/**B*************************************************************************
 * Macro:        os_is_booting
 *---------------------------------------------------------------------------
 * Purpose:      Return 1 if the OS executes the boot procedure otherwise 0.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

extern SINT32 nu_is_booting(VOID);
#define os_is_booting()   nu_is_booting()


/**B*************************************************************************
 * Macro:        os_sem_t
 *---------------------------------------------------------------------------
 * Purpose:      Semaphore data type
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

typedef NU_SEMAPHORE os_sem_t;


/**B*************************************************************************
 * Macro:        os_sem_p
 *---------------------------------------------------------------------------
 * Purpose:      Semaphore pointer declaration
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

typedef NU_SEMAPHORE *os_sem_p;


/**B*************************************************************************
 * Macro:        os_protect_t
 *---------------------------------------------------------------------------
 * Purpose:      Semaphore data type
 *               This can oly be used in HISR context for Tasks use
 *               os_sem_t
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

typedef NU_PROTECT os_protect_t;


/**B*************************************************************************
 * Macro:        os_sem_addr
 *---------------------------------------------------------------------------
 * Purpose:      Address of a semaphore
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_sem_addr(sem_)  &sem_


/**B*************************************************************************
 * Macros:        OS_SEM_[TYPE]
 *---------------------------------------------------------------------------
 * Purpose:      Define several styles of semaphores
 *               order of pending task execution.
 *               semaphore obtainer task acceleration
 *               task preemption deactivation
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define OS_SEM_FIFO 1
#define OS_SEM_PRIORITY 2
#define OS_SEM_CUSTOM_TYPES 3
#define OS_SEM_CRIT_SECT OS_SEM_CUSTOM_TYPES
#define OS_SEM_NO_PREEMPT (OS_SEM_CUSTOM_TYPES+1)
#define OS_SEM_IRQ_LOCK (OS_SEM_CUSTOM_TYPES+2)
#define OS_SEM_CRIT_SECT_SIMPLE (OS_SEM_CUSTOM_TYPES+3)
#define OS_SEM_CS_DEFAULT OS_SEM_CRIT_SECT


/**B*************************************************************************
 * Macro:        os_sem_create, os_ssem_create, os_protect_create
 *---------------------------------------------------------------------------
 * Purpose:      Create a (static) semaphore and define the initial state. 1 means
 *               do not block after the first call, otherwise use 0.
 *
 * Parameters:   sem_:           Pointer to the semaphore.
 *               name_pref_:     Prefix of the semaphore's name.
 *               name_no_:       Postfix of the name to make the name unique.
 *               initial_count_: Initial semaphore count.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_ssem_create  os_sem_create
#define os_protect_create(sem_, name_pref_, name_no_, initial_count_) 

#if MS_OS_CRITICAL_SECTION_SUPPORT > 0
extern VOID os_sem_create_t_func(NU_SEMAPHORE *sem_p, CHAR const*name_pref,
                                         SINT32 name_no, SINT32 initial_count_, SINT32 sema_style);

#define os_sem_create_t(sem_, name_pref_, name_no_, initial_count_, sema_style) \
os_sem_create_t_func(&(sem_), name_pref_, name_no_, initial_count_, sema_style)

#define os_sem_create(sem_, name_pref_, name_no_, initial_count_) \
 os_sem_create_t(sem_, name_pref_, name_no_, initial_count_, OS_SEM_FIFO)

#else

#define os_sem_create(sem_, name_pref_, name_no_, initial_count_) \
do { \
    UINT32  status; \
    status = NU_Create_Semaphore( &(sem_), name_pref_, (initial_count_), NU_FIFO); \
    if (status != ZOSS_SUCCESS) \
        zOss_ASSERT(0); \
} while (0)


#endif


/**B*************************************************************************
 * Macro:        os_sem_reset
 *---------------------------------------------------------------------------
 * Purpose:      Set the semaphore counter to the initial value.
 *
 * Parameters:   sem_:           Pointer to the semaphore.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_sem_reset(sem_)  \
do { \
    STATUS  status = NU_Reset_Semaphore ( &(sem_), 0 ); \
    if (status != NU_SUCCESS) \
        zOss_ASSERT(0); \
} while (0)


/**B*************************************************************************
 * Macro:        os_sem_signal, os_protect
 *---------------------------------------------------------------------------
 * Purpose:      Releases a previously obtained semaphore. If one or 
 *               more tasks are waiting, the first task is given the released
 *               instance of the semaphore.  Otherwise, the semaphore instance
 *               counter is simply incremented.
 *
 * Parameters:   sem_:           Pointer to the semaphore.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_protect(sem_)  

#if MS_OS_CRITICAL_SECTION_SUPPORT > 0

extern VOID os_sem_signal_func(NU_SEMAPHORE *sem_p);
#define os_sem_signal(sem_)  \
os_sem_signal_func(&(sem_))

#else

#define os_sem_signal(sem_)  \
do { \
    UINT32  status = NU_Release_Semaphore(&(sem_)); \
    if (status != ZOSS_SUCCESS) \
        zOss_ASSERT(0); \
} while (0)

#endif


/**B*************************************************************************
 * Macro:        os_sem_wait, os_unprotect
 *---------------------------------------------------------------------------
 * Purpose:      Decrement the semphore counter by 1. If the counter is
 *               greater than zero at the time of this call, this function can
 *               be completed immediately, otherwise suspension.
 *
 * Parameters:   sem_:           Pointer to the semaphore.
 *
 * Returns:      None.
 ***E************************************************************************/


#define os_unprotect(sem_)  

#if MS_OS_CRITICAL_SECTION_SUPPORT > 0

extern VOID os_sem_wait_func (NU_SEMAPHORE *sem_p);
#define os_sem_wait(sem_)  os_sem_wait_func(&(sem_))

#else
#define os_sem_wait(sem_)  \
do { \
    UINT32 status = NU_Obtain_Semaphore ( &(sem_), NU_SUSPEND ); \
    if (status != ZOSS_SUCCESS) \
        zOss_ASSERT(0); \
} while (0)
#endif


/**B*************************************************************************
 * Macro:        os_sem_kill, os_ssem_kill,  os_protect_kill

 *---------------------------------------------------------------------------
 * Purpose:      Destroy a (static) semphore.
 *
 * Parameters:   sem_:           Pointer to the semaphore.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_protect_kill
#define os_ssem_kill  os_sem_kill


#if MS_OS_CRITICAL_SECTION_SUPPORT > 0

extern VOID os_sem_kill_func(NU_SEMAPHORE *sem_p);

#define os_sem_kill(sem_)  \
os_sem_kill_func(&(sem_))

#else
#define os_sem_kill(sem_)  \
do { \
    STATUS status = NU_Delete_Semaphore ( &(sem_) ); \
    if (status != NU_SUCCESS) \
        zOss_ASSERT(0); \
} while (0)
#endif



/**B*************************************************************************
 * Macro:        os_signal_t
 *---------------------------------------------------------------------------
 * Purpose:      Generic part of an I/O signal.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

typedef xSignalHeaderRec os_signal_t;


/**B*************************************************************************
 * Macro:        os_print
 *---------------------------------------------------------------------------
 * Purpose:      Prints strings to the trace output.
 *
 * Parameters:   str_: String to be printed.
 *
 * Returns:      None
 ***E************************************************************************/
#if 0
#define os_print(str_)    hwtrc_print (str_)
#define os_task_info(state_, self_id_, sig_cod_, msg_, len_)  \
            hwtrc_task_info(state_, self_id_, sig_cod_, msg_, len_) 

    
/**B*************************************************************************
 * Macro:        os_nprint
 *---------------------------------------------------------------------------
 * Purpose:      Prints the first n chars of a string to the trace output.
 *
 * Parameters:   str_: string
 *               n_:   number of chars in str_
 *
 * Returns:      None
 ***E************************************************************************/

#define os_nprint(str_, n_)    hwtrc_write (str_, n_)

    
/**B*************************************************************************
 * Macro:        os_write
 *---------------------------------------------------------------------------
 * Purpose:      Send n bytes to the trace output.
 *
 * Parameters:   buf_: char sequence
 *               n_: number of chars in buf_
 *
 * Returns:      None
 ***E************************************************************************/

#define os_write(buf_, n_)    hwtrc_write (buf_, n_)
#endif
    
/**B*************************************************************************
 * Macro:        os_signal_alloc
 *---------------------------------------------------------------------------
 * Purpose:      Allocation of a message buffer for a signal from the 
 *               specified partition pool.
 *
 * Parameters:   signal_id_:   Corresponding ID (process index + message id)
 *                             to the message type.
 *               signal_type_: Message type used to allocate a message buffer.
 *
 * Returns:      Pointer to the allocated message buffer.
 ***E************************************************************************/

#define os_signal_alloc(signal_id_, signal_type_) \
     { xSignalHeader yOutputSignalPtr = \
       alloc_sig( sizeof (signal_type_) ); \
       yOutputSignalPtr->Sender = 0; \
       yOutputSignalPtr->SignalCode = (signal_id_);
    
    
/**B*************************************************************************
 * Macro:        os_signal_alloc_from
 *---------------------------------------------------------------------------
 * Purpose:      Allocation of a message buffer for a signal from the 
 *               specified partition pool.
 *
 * Parameters:   sender_pid_:  Used to send back signals.
 *               signal_id_:   Corresponding ID (process index + message id)
 *                             to the message type.
 *               signal_type_: Message type used to allocate a message buffer.
 *
 * Returns:      Pointer to the allocated message buffer.
 ***E************************************************************************/

#define os_signal_alloc_from(sender_pid_, signal_id_, signal_type_) \
     { xSignalHeader yOutputSignalPtr = \
       alloc_sig( sizeof (signal_type_) ); \
       yOutputSignalPtr->Sender = (sender_pid_); \
       yOutputSignalPtr->SignalCode = (signal_id_);
    

/**B*************************************************************************
 * Macro:        os_signal_alloc_from_to
 *---------------------------------------------------------------------------
 * Purpose:      Allocation of a message buffer for a signal from the 
 *               specified partition pool with generic receiver.
 *
 * Parameters:   signal_id_:   Corresponding ID (process index + message id)
 *                             to the message type.
 *               signal_type_: Message type used to allocate a message buffer.
 *               receiver_:    PID of the receiver process.*
 *               
 * Returns:      Pointer to the allocated message buffer.
 ***E************************************************************************/

#define os_signal_alloc_from_to(sender_pid_, receiver_, signal_id_, signal_type_) \
     yOutputSignalPtr = \
       alloc_sig(sizeof(signal_type_)); \
       yOutputSignalPtr->Sender = (sender_pid_); \
       yOutputSignalPtr->SignalCode = (signal_id_); 
    

/**B*************************************************************************
 * Macro:        os_signal_alloc_to
 *---------------------------------------------------------------------------
 * Purpose:      Allocation of a message buffer for a signal from the 
 *               specified partition pool with generic receiver.
 *
 * Parameters:   signal_id_:   Corresponding ID (process index + message id)
 *                             to the message type.
 *               signal_type_: Message type used to allocate a message buffer.
 *               receiver_:    PID of the receiver process.*
 *               
 * Returns:      Pointer to the allocated message buffer.
 ***E************************************************************************/

#define os_signal_alloc_to(receiver_, signal_id_, signal_type_) \
     yOutputSignalPtr = \
       alloc_sig(sizeof(signal_type_)); \
       yOutputSignalPtr->SignalCode = (signal_id_); 


/**B*************************************************************************
 * Macro:        os_signal_paramassign
 *---------------------------------------------------------------------------
 * Purpose:      Set a scalar paramter value.
 *
 * Parameters:   sig_:      Pointer to the signal header.
 *
 *               param_no_: Number of the parameter to be set.
 *
 *               value_:    Source value.
 *
 * Returns:      None
 ***E************************************************************************/

#define os_signal_paramassign(sig_, param_no_, value_) \
  ((yPDef_##sig_ *) OUTSIGNAL_DATA_PTR)->Param##param_no_ = (value_)

 
/**B*************************************************************************
 * Macro:        os_signal_paramcopy
 *---------------------------------------------------------------------------
 * Purpose:      Copies parameter values into a signal message buffer.
 *
 * Parameters:   sig_:      Pointer to the signal header.
 *
 *               param_no_: Number of the parameter to be set
 *
 *               src_adr_:  Source address
 *
 *               size_t:    Parameter size
 *
 * Returns:      None
 ***E************************************************************************/

#define os_signal_paramcopy(sig_, param_no_, src_adr_, size_) \
 memcpy( (void *) &(((yPDP_##sig_)(OUTSIGNAL_DATA_PTR))->Param##param_no_), \
         (void *)(src_adr_), \
         (size_) );

 
/**B*************************************************************************
 * Macro:        os_signal_paramreset
 *---------------------------------------------------------------------------
 * Purpose:      Resets parameter values of a signal message buffer.
 *
 * Parameters:   sig_:      Pointer to the signal header.
 *
 *               param_no_: Number of the parameter to be reset
 *
 *               size_t:    Parameter size
 *
 * Returns:      None
 ***E************************************************************************/

#define os_signal_paramreset(sig_, param_no_, size_)
    
 
/**B*************************************************************************
 * Macro:        os_signal_free
 *---------------------------------------------------------------------------
 * Purpose:      Deallocation of a message buffer for a signal. 
 *
 * Parameters:   signal_ptr: pointer to the signal allocated with
 *               os_signal_alloc().
 *
 * Returns:      None.
 ***E************************************************************************/
 
#define os_signal_free  free_sig


/**B*************************************************************************
 * Macro:        os_signal_id
 *---------------------------------------------------------------------------
 * Purpose:      Extract the signal id from the received input signal
 *
 * Parameters:   signal_ptr:: pointer to the received signal.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_signal_id(signal_ptr_)  SIGNAL_NAME (signal_ptr_->SignalCode, 0)


/**B*************************************************************************
 * Macro:        os_signal_receive
 *---------------------------------------------------------------------------
 * Purpose:      Wait for a signal to arrive. After having performed a
 *               transition,
 *               each process waits here for the next signal to arrive. Once
 *               a signal is available, it is taken out of the queue and the 
 *               next transition takes place.
 *
 * Parameters:   None.
 *
 * Returns:      Pointer to message buffer.
 ***E************************************************************************/

#define os_signal_receive(self_)  receive_sig(self_)


/**B*************************************************************************
 * Macro:        os_signal_route
 *---------------------------------------------------------------------------
 * Purpose:      Route and send signal according to signal code.
 *               The signal code is an element of the generic signal header.
 *               This element is set in os_signal_alloc().
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_signal_route(signal_id_, signal_name_) \
    send_sig_no_to (yOutputSignalPtr, signal_id_, signal_name_); }


/**B*************************************************************************
 * Macro:        os_signal_send
 *---------------------------------------------------------------------------
 * Purpose:      The given signal is send to the specified task queue.
 *
 * Parameters:   receiver_: PID of the receiver process.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_signal_send(receiver_, signal_name_) \
    SEND_SIG (yOutputSignalPtr, receiver_, signal_name_ );


/**B*************************************************************************
 * Macro:        os_signal_vars
 *---------------------------------------------------------------------------
 * Purpose:      Generic signal header.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_signal_vars   SIGNAL_VARS


/**B*************************************************************************
 * Macro:        os_timer_t
 *---------------------------------------------------------------------------
 * Purpose:      Type definition of a timer mapped to an input signal.
 *
 * Parameters:   None.
 *
 * Returns:      None.
 ***E************************************************************************/

typedef char  os_timer_t;  /* It is a dummy type. */


/**B*************************************************************************
 * Macro:        os_timer_start
 *---------------------------------------------------------------------------
 * Purpose:      A timer is started with an expiry time relative to the 
 *               current system time. The call of os_timer_start()
 *               causes an implicit stop of the timer.
 *               The timer queue, the processes' save and input queues are
 *               searched for the timer signal.
 *               If the timer signal can be found there, it is taken from the
 *               queue and the timer is started anew. If the timer is neither
 *               running nor can the timer signal be found in the process
 *               queues, a message buffer for the timer signal is allocated.
 *               This block (re-used or newly allocated) is
 *               then enqueued at the proper place in the timer queue.
 *
 * Parameters:   Import of the process variables as yVarP with the generic 
 *               header (os_process_var).
 *               t_name_: name of the timer variable, must be an element of 
 *               the process variables.
 *               t_id_: timer id, used as input signal.
 *               secs_: number of seconds (long).
 *               nano_secs_: nano seconds (long).
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_timer_start(t_name_, t_id_, tick_expr_,sample_id) \
do { \
    SDL_SET_DUR (0, tick_expr_, t_id_, 0, t_name_, "",sample_id); \
} while (0)


/**B*************************************************************************
 * Macro:        os_timer_stop
 *---------------------------------------------------------------------------
 * Purpose:      A timer is stopped.
 *               The timer queue, the processes' save and input queues are
 *               searched for the timer signal. 
 *               If the timer signal can be found there, it is removed from
 *               the queue, and the timer signal (i. e. the message buffer)
 *               is freed.
 *
 * Parameters:   Import of the process variables as yVarP with the generic
 *               header (os_process_var).
 *               t_name_: name of the timer variable,
 *                        must be an element of the process variables.
 *               t_id_: timer id, used as input signal.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_timer_stop(t_name_, t_id_) \
do { \
    SDL_RESET (t_id_, 0, t_name_, ""); \
} while (0)


/**B*************************************************************************
 * Macro:        os_timer_stop_with_para
 *---------------------------------------------------------------------------
 * Purpose:      A timer is stopped.
 *               The timer queue, the processes' save and input queues are
 *               searched for the timer signal. 
 *               If the timer signal can be found there, it is removed from
 *               the queue, and the timer signal (i. e. the message buffer)
 *               is freed.
 *
 * Parameters:   Import of the process variables as yVarP with the generic
 *               header (os_process_var).
 *               t_name_: name of the timer variable,
 *                        must be an element of the process variables.
 *               t_id_: timer id, used as input signal.
 *
 * Returns:      None.
 ***E************************************************************************/

#define os_timer_stop_with_para(t_name_, t_id_, t_param,sample_id) \
do { \
    SDL_Reset (t_id_, t_param, (t_process_vars *) yVarP,sample_id); \
} while (0)


/**B*************************************************************************
 * Macro:        os_timer_start_with_para
 *---------------------------------------------------------------------------
 * Purpose:      A timer is started with an expiry time relative to the 
 *               current system time. The call of os_timer_start()
 *               causes an implicit stop of the timer.
 *               The timer queue, the processes' save and input queues are
 *               searched for the timer signal.
 *               If the timer signal can be found there, it is taken from the
 *               queue and the timer is started anew. If the timer is neither
 *               running nor can the timer signal be found in the process
 *               queues, a message buffer for the timer signal is allocated.
 *               This block (re-used or newly allocated) is
 *               then enqueued at the proper place in the timer queue.
 *
 * Parameters:   Import of the process variables as yVarP with the generic 
 *               header (os_process_var).
 *               t_name_: name of the timer variable, must be an element of 
 *               the process variables.
 *               t_id_: timer id, used as input signal.
 *               secs_: number of seconds (long).
 *               nano_secs_: nano seconds (long).
 *
 * Returns:      None.
 ***E************************************************************************/

#if defined (SDL_SET_DUR_EX)
 
#define os_timer_soft_start_with_para(t_name_, t_id_, t_param, earliest_tick_expr_, latest_tick_expr_,sample_id) \
do { \
    SDL_Set_Dur_Ex (earliest_tick_expr_, latest_tick_expr_, t_id_, t_param, (t_process_vars *) yVarP,sample_id); \
} while (0)

#define os_timer_start_with_para(t_name_, t_id_, t_param, tick_expr_,sample_id) \
do { \
    SDL_Set_Dur (tick_expr_, t_id_, t_param, (t_process_vars *) yVarP,sample_id); \
} while (0)

#else
 
#define os_timer_start_with_para(t_name_, t_id_, t_param, tick_expr_,sample_id) \
do { \
    SDL_Set_Dur (tick_expr_, t_id_, t_param, (t_process_vars *) yVarP,sample_id); \
} while (0)

#define os_timer_soft_start_with_para(t_name_, t_id_, t_param, earliest_tick_expr_, latest_tick_expr_,sample_id) \
do { \
    SDL_Set_Dur (earliest_tick_expr_, t_id_, t_param, (t_process_vars *) yVarP,sample_id); \
} while (0)
 
#endif


/**B*************************************************************************
 * Macro:        os_is_task_call
 *---------------------------------------------------------------------------
 * Purpose:    Nucleus often crashes if a TASK functions are called 
 *             from HISR and LISR  context     
 *             
 *
 * Parameters: NONE
 *
 * Returns:   0 if it is a HISR or LISR context  
 *            1 if it is a TASK context
 ***E************************************************************************/

#define os_is_task_call() (NU_Current_Task_Pointer() != NULL)


/*===========================================================================
EXPORTED TYPE DECLARATIONS
===========================================================================*/

typedef void (* os_timeout_handler) (void *arg);


/*============================================================================
EXPORTED FUNCTIONS
============================================================================*/

/**B************************************************************************
 * Function:     os_init
 *--------------------------------------------------------------------------
 * Purpose:      Module initialization for MS OS abstraction layer.
 *
 * Parameters:   None
 *
 * Returns:      None
 ***E***********************************************************************/

extern VOID os_init(VOID);


/**B*************************************************************************
 * Function:     os_sdlpid_current
 *---------------------------------------------------------------------------
 * Purpose:      Return the SDL pid of the current task.
 *
 * Parameters:   None
 *
 * Returns:      SDL pid.
 ***E************************************************************************/

extern OS_pid_t os_sdlpid_current(VOID);

 
/**B*************************************************************************
 * Function:     os_sdlpid_deregister
 *---------------------------------------------------------------------------
 * Purpose:      Remove the pid of an SDL process.
 *
 * Parameters:   None
 *
 * Returns:      None
 ***E************************************************************************/

extern VOID os_sdlpid_deregister(VOID);

 
/**B*************************************************************************
 * Function:     os_sdlpid_register
 *---------------------------------------------------------------------------
 * Purpose:      os_sdlpid_current
 *---------------------------------------------------------------------------
 * Purpose:      Return the SDL pid of the current task.
 *
 * Parameters:   None
 *
 * Returns:      SDL pid.
 ***E************************************************************************/

extern OS_pid_t os_sdlpid_current(VOID);
 
 
/**B*************************************************************************
 * Function:     os_sdlpid_deregister
 *---------------------------------------------------------------------------
 * Purpose:      Save the pid of an SDL process.
 *
 * Parameters:   SDL pid
 *
 * Returns:      None
 ***E************************************************************************/

// P98C-YXS extern VOID os_sdlpid_register(OS_pid_t sdl_pid);

 
/**B*************************************************************************
 * Macro:        os_sleep_ms
 *---------------------------------------------------------------------------
 * Purpose:      os_sleep_ms() makes the current process sleep until ms
 *               milliseconds have  elapsed.
 *
 * Parameters:   unsigned long ms: # of milliseconds
 *
 * Returns:      None.
 ***E************************************************************************/

extern VOID os_sleep_ms(UNSIGNED ms); 


/**B*************************************************************************
 * Macro:        os_task_create
 *---------------------------------------------------------------------------
 * Purpose:      This procedure creates an application task. 
 *
 * Parameters:
 * task        Pointer to th user-supplied task control block.
 * name        Pointer to an 8 character name for the task.
 * entry       Specifies the entry function of the task.
 * stack       Designates the starting memory location of the tasks
 *             stack area.
 * stack_size  Specifies the number of bytes in the stack.
 * priority    Specifies a priority value between 0 and 255. The lower
 *             numeric value, the higher the tasks priority.
 *
 * Returns:    1 indicates successful completion of the service,
 *             otherwise 0 or soft crash..
 ***E************************************************************************/
typedef NU_TASK *os_task_id_t;
typedef VOID    *os_task_stack_t;
typedef VOID (*os_task_func_t)(SINT32);
typedef OPTION  os_task_prio_t;

// P98C-YXS extern SINT32 os_task_create (os_task_id_t     *id,
// P98C-YXS 			   CHAR             *name,
// P98C-YXS 			   os_task_func_t    entry,
// P98C-YXS 			   os_task_stack_t  *stack,
// P98C-YXS 			   UNSIGNED            stack_size,
// P98C-YXS 			   os_task_prio_t    priority);

/**B*************************************************************************
 * Macro:        os_timeout
 *---------------------------------------------------------------------------
 * Purpose:      Schedule a timeout a specified amount of seconds in the
 *               future. When the timeout occurs, the specified timeout
 *               handler will be called. The handler will be passed the
 *               "arg" argument when called.
 *
 * Parameters:   unsigned char secs:    # of seconds
 *               os_timeout_handler h:  timer handler.
 *               void *arg:             argument of the timer handler.
 *
 * Returns:      None.
 ***E************************************************************************/

// P98C-YXS extern VOID os_timeout(UINT8 secs, os_timeout_handler h, VOID *arg);


/**B*************************************************************************
 * Macro:        os_timeout_ms
 *---------------------------------------------------------------------------
 * Purpose:      Schedule a timeout a specified amount of milliseconds in the
 *               future. When the timeout occurs, the specified timeout
 *               handler will be called. The handler will be passed the
 *               "arg" argument when called.
 *
 * Parameters:   unsigned long ms:      # of seconds
 *               os_timeout_handler h:  timer handler.
 *               void *arg:             argument of the timer handler.
 *
 * Returns:      None.
 ***E************************************************************************/
 
// P98C-YXS extern VOID os_timeout_ms(UNSIGNED ms, os_timeout_handler h, VOID *arg);
 

/**B*************************************************************************
 * Macro:        os_untimeout
 *---------------------------------------------------------------------------
 * Purpose:      Deinstall the timeout handler activated about os_timeout or
 *               about os_timeout_ms.
 *
 * Parameters:   os_timeout_handler h:  timer handler.
 *               void *arg:             argument of the timer handler.
 *
 * Returns:      None.
 ***E************************************************************************/

// P98C-YXS extern VOID os_untimeout(os_timeout_handler h, VOID *arg);
 
#endif 

/* ms_os.h ends here. */

