/* --------------------------------------------------------------- */
/* This document contains proprietary information belonging to     */
/* debis Systemhaus GEI. Passing on and copying of this document,  */
/* use and communication of its contents is not permitted without  */
/* prior written authorisation.                                    */
/* --------------------------------------------------------------- */

/* ===========================================================================
** Project:              Mobile Station (MS)
**
** Revision Information:
**    File name: proc_id.h
**    Version:   /main/system/12
**    Date:   2007-07-04    9:48:23
** ===========================================================================
** Contents:
**
** ===========================================================================
** History:
**
** Date         Author          Comment
** 06-08-02     MLY             adapted for NAS+AS+L1 system, release 2
** 30-09-02     MLY             removed P_snp
**
** ===========================================================================
*/

#ifndef PROC_ID_H
#define PROC_ID_H


/*** statically created processes ***/

/* ===================== */
/*  GPRS Access Stratum  */
/* ===================== */

/* L1G */
#define P_l1g   1

#ifdef Z_SEND_TO_SIMPHY 
#define P_l1g_single   ( P_l1g + 1 )
/* AUD */
#define P_aud    ( P_l1g_single + 1 )
#else
#define P_l1g_single  ( P_l1g + 1 )

#define P_aud    ( P_l1g_single + 1 )
#endif

#define P_tic   ( P_aud + 1 )

/******ͨ*********/
/* mmia */
/* #define P_mmia  ( 0xff00 + 1 ) */

/* gsma */
/* #define P_gsma  ( P_mmia + 1 ) */
/* ӦЭջ޸2010-6-10 */
#define P_gsma  ( 0x7f00 + 1 )

/* taf */
#define P_taf   ( P_gsma + 1 )

/* LAPDm */
#define P_dll   ( P_taf + 1 )
#define P_dll_inst ( P_dll + 1 )

/* LL */
#define P_llc  ( P_dll_inst + 1 )

/* MA */
#define P_mac  ( P_llc + 1 )

/* RL */
#define P_rlc  ( P_mac + 1 )

/* GRRC */
#define P_rrc  ( P_rlc + 1 )

/* GRRC */
#define P_grr  ( P_rrc + 1 )

/* SNDCP */
#define P_snp  ( P_grr + 1 )


/* CBS */
#define P_cbs   ( P_snp + 1 )

/* urrc */
#define P_urrc  ( P_cbs + 1 )

/* l1t */
#define P_l1t  ( P_urrc + 1 )

/* td phy */
#define P_tdPhy ( P_l1t + 1 )

/* l1e */
#define P_l1e  ( P_tdPhy + 1 )

/* lte phy */
#define P_ltePhy ( P_l1e + 1 )

/* l1w */
#define P_l1w  ( P_ltePhy + 1 )

/* wphy */
#define P_wPhy ( P_l1w + 1 )
/* TC */
#define P_tc   ( P_wPhy + 1 )

/* gsma_2 */
#define P_gsma_2  ( P_tc + 1 )

/* taf_2 */
#define P_taf_2   ( P_gsma_2 + 1 )

/* LAPDm_2 */
#define P_dll_2   ( P_taf_2 + 1 )
#define P_dll_inst_2 ( P_dll_2 + 1 )

/* LL_2 */
#define P_llc_2  ( P_dll_inst_2 + 1 )

/* MA_2*/
#define P_mac_2  ( P_llc_2 + 1 )

/* RL_2 */
#define P_rlc_2  ( P_mac_2 + 1 )

/* GRRC_2 */
#define P_rrc_2  ( P_rlc_2 + 1 )

/* GRRC_2 */
#define P_grr_2  ( P_rrc_2 + 1 )

/* SNDCP_2 */
#define P_snp_2  ( P_grr_2 + 1 )

/* TC_2 */
#define P_tc_2  ( P_snp_2 + 1 )

#define P_last   P_tic


#endif /* PROC_ID_H */

