/**
 * 
 * @file      commgt_api.h
 * @brief     
 *            This file is part of tools.
 *            CommAgtӿڹ
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.4
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2013/01/14  1.0      lu.xieji       Create file
 * 2018/09/24  1.1      jiang.fenglin  ˼ͨŹڴ1MΪ512K
 * 2018/09/25  1.2      dai.kang       λڴ3.5MΪ2M
 * 2018/12/25  1.3      dai.kang       λڴɾ̬ΪzOss_GetUBֱ̬
 * 2019/02/02  1.4      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/03/11  1.5      dai.kang       ֧log + ap<->cp log䶯̬
 * 2019/05/13  1.6      dai.kang       psphyĻbufferзֿ룻apbufferռλõ
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef COMM_AGT_H_
#define COMM_AGT_H_

#include "ram_config.h"
#include "ZspTrace.h"

#define MAX_PACKET_LEN                      (0x10000)
#define MAX_ENCODE_PACKET_LEN               (MAX_PACKET_LEN * 2)

// Buffer ַ
extern UINT32 g_zToolAgtBaseDDR;

#define COMM_SEND_BUFFER_BASE_ADDR          (g_zToolAgtBaseDDR)
#define COMM_SEND_BUFFER_SIZE               (0x77000)

#define COMM_RECV_BUFFER_BASE_ADDR          (COMM_SEND_BUFFER_BASE_ADDR + COMM_SEND_BUFFER_SIZE)
#define COMM_RECV_BUFFER_SIZE               (0x0)

#define COMM_READ_BUFFER_BASE_ADDR          (COMM_RECV_BUFFER_BASE_ADDR + COMM_RECV_BUFFER_SIZE)
#define COMM_READ_BUFFER_SIZE               (0x0)

#define COMM_ENCODE_BUFFER_BASE_ADDR        (COMM_READ_BUFFER_BASE_ADDR + COMM_READ_BUFFER_SIZE)
#define COMM_ENCODE_BUFFER_SIZE             (0x0)

#define COMM_DECODE_BUFFER_BASE_ADDR        (COMM_ENCODE_BUFFER_BASE_ADDR + COMM_ENCODE_BUFFER_SIZE)
#define COMM_DECODE_BUFFER_SIZE             (0x0)

// GSM buff
#define ZCAT_GSM_BUFFER_BASE_ADDR           (COMM_DECODE_BUFFER_BASE_ADDR + COMM_DECODE_BUFFER_SIZE)

#ifdef _USE_L1G
#define ZCAT_GSM_BUFFER_SIZE                (0x8000)
#else
#define ZCAT_GSM_BUFFER_SIZE                (0x0)
#endif

#define COMM_ARM1_ALL_ADDR                  (ZCAT_GSM_BUFFER_BASE_ADDR + ZCAT_GSM_BUFFER_SIZE)
#define COMM_ARM1_ALL_SIZE                  (0x100)
#define COMM_ARM1_TICK_ADDR                 (COMM_ARM1_ALL_ADDR)
#define COMM_ARM1_TICK_SIZE                 (0x4)
#define COMM_ARM1_ORITIME_ADDR              (COMM_ARM1_TICK_ADDR + COMM_ARM1_TICK_SIZE)
#define COMM_ARM1_ORITIME_SIZE              (0x4)
#define COMM_ARM1_ORITICK_ADDR              (COMM_ARM1_ORITIME_ADDR + COMM_ARM1_ORITIME_SIZE)
#define COMM_ARM1_ORITICK_SIZE              (0x4)

#if ((COMM_ARM1_TICK_SIZE + COMM_ARM1_ORITIME_SIZE + COMM_ARM1_ORITICK_SIZE) > COMM_ARM1_ALL_SIZE)
#error "tool ram overflow!"
#endif

// PS CPU <-->PHY CPU
#define COMM_PS_TO_PHY_BASE_ADDR            (COMM_ARM1_ALL_ADDR + COMM_ARM1_ALL_SIZE)
#define COMM_PS_TO_PHY_SIZE                 (0x100)

#define COMM_PHY_TO_PS_BASE_ADDR            (COMM_PS_TO_PHY_BASE_ADDR + COMM_PS_TO_PHY_SIZE)
#define COMM_PHY_TO_PS_SIZE                 (0x100)

#define ZCAT_KERNEL_TO_CP_BASE_ADDR         (COMM_PHY_TO_PS_BASE_ADDR + COMM_PHY_TO_PS_SIZE)
#define ZCAT_KERNEL_TO_CP_BUFFER_SIZE       (0x4000)
 
#define ZCAT_APP_TO_CP_BASE_ADDR            (ZCAT_KERNEL_TO_CP_BASE_ADDR + ZCAT_KERNEL_TO_CP_BUFFER_SIZE)
#define ZCAT_APP_TO_CP_BUFFER_SIZE          (0x4000)

#define COMM_CP_TO_AP_BASE_ADDR             (ZCAT_APP_TO_CP_BASE_ADDR + ZCAT_APP_TO_CP_BUFFER_SIZE)
#ifdef CONFIG_SINGLECORE
#define COMM_CP_TO_AP_SIZE                  (0)
#else
#define COMM_CP_TO_AP_SIZE                  (0x20000)
#endif

#define COMM_AP_TO_CP_BASE_ADDR             (COMM_CP_TO_AP_BASE_ADDR + COMM_CP_TO_AP_SIZE)
#ifdef CONFIG_SINGLECORE
#define COMM_AP_TO_CP_SIZE                  (0)
#else
#define COMM_AP_TO_CP_SIZE                  (0x8000)
#endif

#define TOOL_AGENT_RAM_SIZE (COMM_SEND_BUFFER_SIZE + COMM_RECV_BUFFER_SIZE + COMM_READ_BUFFER_SIZE + COMM_ENCODE_BUFFER_SIZE + \
	                         COMM_DECODE_BUFFER_SIZE + ZCAT_GSM_BUFFER_SIZE + COMM_ARM1_ALL_SIZE + COMM_PS_TO_PHY_SIZE + \
	                         COMM_PHY_TO_PS_SIZE + ZCAT_KERNEL_TO_CP_BUFFER_SIZE + ZCAT_APP_TO_CP_BUFFER_SIZE + COMM_CP_TO_AP_SIZE + \
	                         COMM_AP_TO_CP_SIZE)

/* MODEM PRINT ģ */
#define SUBMDL_TOOLAGENT_SET  (85)
#define SUBMDL_ZCATAGT        (SUBMDL_TOOLAGENT_SET + 0)  /* ZCATߴ */
#define SUBMDL_TOOLCOMMON     (SUBMDL_TOOLAGENT_SET + 1)  /* TOOL COMMON  */
#define SUBMDL_COMM           (SUBMDL_TOOLAGENT_SET + 2)  /* ͨѶ */
#define SUBMDL_NVAGT          (SUBMDL_TOOLAGENT_SET + 3)  /* NVߴ       */

/* ͨѶģ */
#define MDL_TOOLS_BASE        (100)
#define MDL_WINTRACE          (MDL_TOOLS_BASE + 1)   /* WinTrace */
#define MDL_NVEDIT            (MDL_TOOLS_BASE + 3)   /* NvTool */
#define MDL_VUART1            (MDL_TOOLS_BASE + 4)   /* Virtual of Serial Comm1,used in SimEnv */
#define MDL_EFSTOOL           (MDL_TOOLS_BASE + 7)   /* EfsTool */
#define MDL_PTET              (MDL_TOOLS_BASE + 10)  /* ЭջԹ */
#define MDL_ZCAT              (MDL_TOOLS_BASE + 15)  /* ZCAT          */
#define MDL_NVTOOL            (MDL_TOOLS_BASE + 16)  /* NvTool */
#define MDL_AUDIO              (MDL_TOOLS_BASE + 17)  /* audio */

#define MDL_SIMTH             (MDL_TOOLS_BASE + 18)  /* TH */

/*wincomm: ӦǷHDLC*/
#define COMM_HEADER_PAD_HDLC         (0xAB)
#define COMM_HEADER_MSG_TYPE_HDLC    (0x4)
#define COMM_HEADER_RESERVED_HDLC    (0xBBBB)
#define COMM_ACK_HDLC_READY          (0x2)

#ifdef _OS_WIN
#define MDL_PHONE                    (MDL_VUART1)  /* windows 滷 */
#else
#define MDL_PHONE                    (1)           /* ֻ   */
#endif

#define ZCAT_MODE_INVALID  (UINT32)0

typedef enum
{
    ZCAT_MODE_AP_USB = 0xC1,
    ZCAT_MODE_AP_NET,
    ZCAT_MODE_AP_TF,
    ZCAT_MODE_AP_FS,
    ZCAT_MODE_CP_USB,
    ZCAT_MODE_CP_TF,
    ZCAT_MODE_CP_NET,
    ZCAT_MODE_CP_FS,
#ifdef _USE_VEHICLE_DC
    ZCAT_MODE_CAP_FS,
#endif

} E_ZCAT_MODE;

typedef enum
{
    ZCAT_IPC_SYN = 0xA0,
    ZCAT_IPC_ACK,
    ZCAT_IPC_ESTABLISHED,
    ZCAT_IPC_SET_TTY,
    ZCAT_IPC_SET_PERIPHERAL_MODE,
    ZCAT_IPC_STOP,
    ZCAT_IPC_START,
    ZCAT_IPC_EXIT,
#ifdef _USE_VEHICLE_DC
    ZCAT_IPC_ALLOC_CAP_SMLOGBUF,
#endif
} E_ZCAT_IPC_HANDSHAKE;


#define COMM_AP_FD           1001
#define COMM_SINGLE_CORE_FD  1002
#define COMM_CP_TF_FD        1234

#define ZCAT_MEM_TYPE_KERNEL 0  
#define ZCAT_MEM_TYPE_USER   1

#define HDLC_DECODE_CONTINUE           (0x00)
#define HDLC_DECODE_OK                 (0x01)
#define HDLC_DECODE_FIRST_ESCAPE       (0x02)
#define HDLC_DECODE_DROP               (0x03)


/* zcatȫϢ */
typedef struct
{
    int  status;
    int  peripheral_mode;
    char usblog_path[8];
} T_ZCAT_CONFIG_INFO;


// ģص
typedef VOID (*ModuleFunc)(UINT32 msgID/**/, const UINT8 *buf, UINT32 msgLen);

typedef enum
{
    LINK_CONNECT,                   /* ·Ϣ */
    LINK_BREAK,                     /* ·ϿϢ */

    MAX_LINK_INFO
} LINK_INFO;

typedef enum
{
    COMM_RET_SUCCESS,               /* ݳɹ,ȴ */
    COMM_ERR_NOTINIT,               /* ʧ,ͨѶûгʼ */
    COMM_ERR_LINKBREAK,             /* ʧ,·ѾϿ */
    COMM_ERR_DATALEN,               /* ʧ,Ϣݳȳ󳤶 */
    COMM_ERR_MEM,                   /* ʧ,ڴʧ */
    COMM_ERR_MUTEX,                 /* ʧ,ִ */

    MAX_COMM_ERR
} COMM_RET;

typedef enum
{
    FUNC_RET_FAILURE,
    FUNC_RET_SUCCESS,

    MAX_FUNC_RET
} FUNC_RET;

// Commṹ
typedef struct
{
    UINT8  msg_type;                /* Ϣ */
    UINT8  pad;                     /* λ */
    UINT16 reserved;                /* ֶΣΪ0xAAAA */
    UINT8  tgt_mdl_no;              /* Ŀ(Ϣ)ģģ */
    UINT8  tgt_submdl_no;           /* Ŀ(Ϣ)ģģ */
    UINT8  src_mdl_no;              /* Դ(Ϣ)ģģ */
    UINT8  src_submdl_no;           /* Դ(Ϣ)ģģ */
    UINT32 buf_len;                 /* Ϣݳ(Ϣͷ) */
} T_COMM_TYPE;

/* ӡ */
typedef struct
{
    UINT32 capacity;                /* */
    volatile UINT32 readPoint;      /* ָ */
    volatile UINT32 writePoint;     /* дָ */
    UINT32 symbol;                  /* ƿʶ */
    UINT8 buf[1];                   /* ӡ */
} T_RINGBUFFER;

typedef struct
{
    UINT8 *buf;
    UINT32 bufIndex; // ָƫ
    UINT32 bufSize;
} T_HDLC_BUFFER_TYPE;


/**
 * @brief commλһڴ
 * @param[in] size ʵݵĿռС
 * @return ɹڴָ룬򷵻NULL
 * @note ڴֻcommݷͣ!!! \n
         ͳɹͷţ\n
         δͻͲɹComm_Freeͷţ
 * @see 
 */
VOID* Comm_Malloc(UINT32 size);

/**
 * @brief ͷComm_Mallocڴ
 * @param[in] mem_ptr ͷŵcommڴָ
 * @return void
 * @note
 * @see 
 */
VOID Comm_Free(VOID *mem_ptr);

/**
 * @brief ZCATͨѶģʼ
 * @param[in] void
 * @return ɹZOSS_SUCCESSʧܷZOSS_ERROR
 * @note
 * @see 
 */
UINT32 Comm_Init(VOID);

/**
 * @brief ZCATͨѶģעӿ,
 * @param[in] void
 * @return void
 * @note
 * @see 
 */
void Comm_Release(void);


/**
 * @brief ZCATģעӿ \n
 *        ṩģãעģϢ
 * @param[in] submdl_no  עģţѾpub_mdldef.hж
 * @param[in] uart_name  Ϊ²uart_nameЧ,һuart/0
 * @param[in] moduleFunc ģص
 * @return ɹZOSS_SUCCESS, ʧܷZOSS_ERROR
 * @note
 * @see 
 */
UINT32 zTools_CommReg(UINT8 submdl_no, const CHAR *uart_name, ModuleFunc moduleFunc);

/**
 * @brief ZCATģעӿ \n
 *        ṩģãעģϢ
 * @param[in] submdl_no  Ҫעģ
 * @return ɹZOSS_SUCCESS, ʧܷZOSS_ERROR
 * @note
 * @see 
 */
UINT32 zTools_CommUnReg(UINT8 submdl_no);

/**
 * @brief ṩͬģ""ݵĹ \n
 *        TraceAgtģʹ,첽ӿڣֻܷͶǷܹյ
 *        һȵ"ͳһ"УȻ֪ͨ߳ݴ
 * @param[in] buf           (Comm_Mallocڴ!!!)
 * @param[in] buf_len       ݵĳ
 * @param[in] tgt_mdl_no    ĿģţֻPC
 * @param[in] tgt_submdl_no Ŀģ
 * @param[in] src_submdl_no Դģ
 * @return ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
 * @note
 * @see 
 */
UINT32 zTools_SendData(UINT8 *buf, UINT32 buf_len,
                       UINT8 tgt_mdl_no, UINT8 tgt_submdl_no, UINT8 src_submdl_no);

/**
 * @brief ҪĻ
 *        bufΪNULLַָһڴΪ
 * @param[in] buf ַ
 * @param[in] bufSize С
 * @return ɹָ򻺳ṹָ룬򷵻NULL
 * @note
 * @see 
 */
T_RINGBUFFER* CreateRingBuffer(UINT8 *buf, UINT32 bufSize);

/**
 * @brief ҪĻ,ָλֵ
 *        bufΪNULLַָһڴΪ
 * @param[in] buf ַ
 * @param[in] bufSize С
 * @param[in] bufSize λ
 * @return ɹָ򻺳ṹָ룬򷵻NULL
 * @note
 * @see 
 */
T_RINGBUFFER* CreateRingBufferWithSymbol(UINT8 *buf, UINT32 bufSize, UINT32 symbol);

/**
 * @brief жϻǷЧ
 * @param[in] ringBuf λ
 * @return ǷTRUE,񷵻FALSE
 * @note
 * @see 
 */
BOOL IsRingBufferValid(T_RINGBUFFER *ringBuf);

/**
 * @brief ÿ
 * @param[in] ringBuf λָ
 * @return void
 * @note
 * @see 
 */
VOID EmptyRingBuffer(T_RINGBUFFER *ringBuf);

/**
 * @brief д뻷λ
 * @param[in] ringBuf λָ
 * @param[in] buf ݻָ
 * @param[in] len ݳ
 * @param[in] flags ݻڴͣ0:ں̬,1:û̬
 * @return дʵʳ
 * @note
 * @see 
 */
UINT32 WriteRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len, UINT32 flags);

/**
 * @brief ȡһλλݵĿ껺
 * @param[in] ringBuf λָ
 * @param[in] buf Ŀ껺ָ
 * @param[in] len Ŀ껺泤
 * @param[in] flags Ŀ껺ڴͣ0:ں̬,1:û̬
 * @return ضȡ
 * @note
 * @see 
 */
UINT32 ReadRingBuffer(T_RINGBUFFER *ringBuf, UINT8 *buf, UINT32 len, UINT32 flags);

/**
 * @brief ȡǰRing BufferпĴС
 * @param[in] ringBuf λָ
 * @return ֽ
 * @note
 * @see 
 */
UINT32 GetRingBufferSize(T_RINGBUFFER *ringBuf);

/**
 * @brief HDLC
 * @param[out] dest ĿT_HDLC_BUFFER_TYPEָ
 * @param[in] src ԴT_HDLC_BUFFER_TYPEָ
 * @return ɹTRUEʧܷFALSE
 * @note
 * @see 
 */
BOOL hdlc_encode(T_HDLC_BUFFER_TYPE *dest, const T_HDLC_BUFFER_TYPE *src);

/**
 * @brief ݽHDLCָĵFIFO
 *        FIFOֻܴͷ(0λ)ݻʱ˳д뵽FIFO
 *        ÿҵһֹͣд룬Ȼݻ߶
 *        òreadPointʼΪ0
 * @param[out] dest 洢FIFOָ
 * @param[in] src Ļָ
 * @param[in] len Ļ泤
 * @return ؽʵʳ
 * @note
 * @see 
 */
UINT32 hdlc_decode(T_RINGBUFFER *dest, unsigned char *src, unsigned int len);

/**************************************************************************
                                                CommAgtӿ
**************************************************************************/

/**************************************************************************
*ģϢص
*˵:
*          (IN)
*           ucLinkMsg    ·״̬
*           LINK_CONNECT ·
*           LINK_BREAK   ·Ͽ
**************************************************************************/
typedef void (* LINKRPTFUNC)(LINK_INFO ucLinkMsg);

/**************************************************************************
*ͨģ(ùϢID)ݻص
*˵:
*           (IN)
*            ucSrcModNo       Դģ
*            ucSrcSubModNo    Դģ
*            pBuf             Ϣָ
*            wLen             Ϣݳ
**************************************************************************/
typedef void (* RECVFUNC)(unsigned char ucSrcModNo, unsigned char ucSrcSubModNo, const char *pBuf, unsigned short wLen);

/**************************************************************************
*չģ(ʹϢID)ݻص
*˵:
*           (IN)
*            ucSrcModNo       Դģ
*            ucSrcSubModNo    Դģ
*            dwMsgID          Ϣ
*            pBuf             Ϣָ
*            wLen             Ϣݳ
**************************************************************************/
typedef void (* RECVFUNCEX)(unsigned char ucSrcModNo, unsigned char ucSrcSubModNo, unsigned int dwMsgID, const char *pBuf, unsigned short wLen);

/**************************************************************************
*⴮ģݻص,ʹϢID
*˵:
*           (IN)
*            ucSrcModNo       Դģ
*            ucSrcSubModNo    Դģ
*            ucTarSubModNo    Ŀģ
*            dwMsgID          Ϣ
*            pBuf             Ϣָ
*            wLen             Ϣݳ
**************************************************************************/
typedef void (* RECVFUNCUART)(unsigned char ucSrcModNo, unsigned char ucSrcSubModNo, unsigned char ucTarModNo, unsigned char ucTarSubModNo, unsigned int dwMsgID, const char *pBuf, unsigned short wLen);

/**************************************************************************
* ƣ Comm_Register
*  ͨģ(ùϢID)עӿ(97)
* ˵ (IN)
*             ucModNo     ģ
*             linkRptFunc ģϢص
*            (OUT)
*   ֵ VOID
* ˵ ûзֵ
**************************************************************************/
FUNC_RET Comm_Register(unsigned char ucModNo, LINKRPTFUNC linkRptFunc);

/**************************************************************************
* ƣ Comm_RegisterSub
*  ͨģ(ùϢID)ģעӿ(97)
* ˵ (IN)
*             ucModNo    ģ
*             ucSubModNo ģ
*             recvFunc   ģݻص
*            (OUT)
*   ֵ
*             FUNC_RET_SUCCESS עɹ
*             FUNC_RET_FAILURE עʧ,ֿ,һģظ,עģѾ޶
* ˵ ֻעͨѶ
**************************************************************************/
FUNC_RET Comm_RegisterSub(unsigned char ucModNo, unsigned char ucSubModNo, RECVFUNC recvFunc);

/**************************************************************************
* ƣ Comm_SendMsg
*  ͨģ(ùϢID)Ϣӿ(97)
* ˵ (IN)
*             ucTarModNo    Ŀģ
*             ucTarSubModNo Ŀģ
*             ucSrcModNo    Դģ
*             ucSrcSubModNo Դģ
*             pBuf          Ϣָ
*             wLen          Ϣݳ,ܴMAX_COMM_LEN
*            (OUT)
*   ֵ
*             COMM_RET_SUCCESS    ͳɹ
*             COMM_ERR_NOTINIT    ʧ,ͨѶδʼ
*             COMM_ERR_LINKBREAK  ʧ,Ϊ·δ(PC)˿δ(ֻ)
*             COMM_ERR_DATALEN    ʧ,Ϣݳ󳤶
*             COMM_ERR_MEM        ʧ,ڴʧ
*             COMM_ERR_MUTEX      ʧ,ִ
* ˵
**************************************************************************/
COMM_RET Comm_SendMsg(unsigned char ucTarModNo, unsigned char  ucTarSubModNo,  \
                      unsigned char ucSrcModNo, unsigned char ucSrcSubModNo, \
                      const char * pBuf, unsigned short wLen);

/**************************************************************************
* ƣ Comm_GetStatus
*  ȡͨѶͨѶߵ·״̬
* ˵ (IN)
*             ucModNo ģ
*            (OUT)
*   ֵ
*            FUNC_RET_SUCCESS ·
*            FUNC_RET_FAILURE ·δ
* ˵
**************************************************************************/
FUNC_RET Comm_GetStatus(unsigned char ucModNo);

/**************************************************************************
* ƣ Comm_UnRegister
*  ģעӿ
* ˵ (IN)
*             ucModNo    ģ
*            (OUT)
*   ֵ
*             FUNC_RET_SUCCESS עɹ
*             FUNC_RET_FAILURE עʧ
* ˵
**************************************************************************/
FUNC_RET Comm_UnRegister(unsigned char ucModNo);

/**************************************************************************
* ƣ Comm_UnRegisterSub
*  ͨģ(ùϢID)ģעӿ
* ˵ (IN)
*             ucModNo    ģ
*             ucSubModNo ģ
*            (OUT)
*   ֵ
*             FUNC_RET_SUCCESS עɹ
*             FUNC_RET_FAILURE עʧ
* ˵
**************************************************************************/
FUNC_RET Comm_UnRegisterSub(unsigned char ucModNo, unsigned char ucSubModNo);

/**************************************************************************
* ƣ Comm_RegisterEx
*  չģ(ʹϢID)עӿ
* ˵ (IN)
*             ucModNo     ģ
*             linkRptFunc ģϢص
*            (OUT)
*   ֵ VOID
* ˵ ûзֵ
**************************************************************************/
FUNC_RET Comm_RegisterEx(unsigned char ucModNo, LINKRPTFUNC linkRptFunc);

/**************************************************************************
* ƣ Comm_RegisterSubEx
*  չģ(ʹϢID)ģעӿ
* ˵ (IN)
*             ucModNo    ģ
*             ucSubModNo ģ
*             recvFunc   ģݻص
*            (OUT)
*   ֵ
*             FUNC_RET_SUCCESS עɹ
*             FUNC_RET_FAILURE עʧ,ֿ,һģظ,עģѾ޶
* ˵ ֻעͨѶ
**************************************************************************/
FUNC_RET Comm_RegisterSubEx(unsigned char ucModNo, unsigned char ucSubModNo, RECVFUNCEX recvFunc);

/**************************************************************************
* ƣ Comm_SendMsgEx
*  չģ(ʹϢID)Ϣӿ
* ˵ (IN)
*             ucTarModNo    Ŀģ
*             ucTarSubModNo Ŀģ
*             ucSrcModNo    Դģ
*             ucSrcSubModNo Դģ
*             dwMsgID       Ϣ
*             pBuf          Ϣָ
*             wLen          Ϣݳ,ܴMAX_COMM_LEN - MSG_HEADER_LEN
*            (OUT)
*   ֵ
*             COMM_RET_SUCCESS    ͳɹ
*             COMM_ERR_NOTINIT    ʧ,ͨѶδʼ
*             COMM_ERR_LINKBREAK  ʧ,Ϊ·δ(PC)˿δ(ֻ)
*             COMM_ERR_DATALEN    ʧ,Ϣݳ󳤶
*             COMM_ERR_MEM        ʧ,ڴʧ
*             COMM_ERR_MUTEX      ʧ,ִ
* ˵
**************************************************************************/
COMM_RET Comm_SendMsgEx(unsigned char ucTarModNo, unsigned char ucTarSubModNo,  \
                        unsigned char ucSrcModNo, unsigned char ucSrcSubModNo, \
                        unsigned int dwMsgID, const char * pBuf, unsigned short wLen);

/**************************************************************************
* ƣ Comm_RegisterUart
*  ⴮ģעӿ,֧ϢID,־Ͳעģ
* ˵ (IN)
*             ucModNo     ģ
*             linkRptFunc ģϢص
*             recvFunc    ģݻص
*            (OUT)
*   ֵ VOID
* ˵ ûзֵ
**************************************************************************/
FUNC_RET Comm_RegisterUart(unsigned char ucModNo, LINKRPTFUNC linkRptFunc, RECVFUNCUART recvFunc);

/**************************************************************************
* ƣ Comm_TaskSendToPhone
*  ӿṩЭջĲԹʹ,ģ͵ظϢĽӿ
* ˵(IN)
*            msg_id      ϢţûԼ
*            buf         Ϣָ
*            buf_len     Ϣݳ
*            tgtMdlNo    ĿģţֻPC
*            tgtSubMdlNo Ŀģ
*            srcSubMdlNo Դģ
*            srcTask     ԴID
*            tgtTask     ĿID
*           (OUT)
*   ֵ ͳɹZOSS_SUCCESS,򷵻ZOSS_ERROR
* ˵ 
**************************************************************************/
unsigned int Comm_TaskSendToPhone(unsigned int msg_id, const unsigned char *buf, unsigned short bufLen,  \
                                  unsigned char tgtMdlNo, unsigned char tgtSubMdlNo, unsigned char srcSubMdlNo, void * srcTask, void * tgtTask);


/**
 * @brief ݵ"ͳһ"
 * @param[in] buf           (Comm_Mallocڴ!!!)
 * @param[in] buf_len       ݵĳ
 * @param[in] tgt_mdl_no    ĿģţֻPC
 * @param[in] tgt_submdl_no Ŀģ
 * @param[in] src_submdl_no Դģ
 * @return ɹZOSS_SUCCESS, 򷵻ZOSS_ERROR
 * @note
 * @see 
 */
VOID Comm_HeaderInit(T_COMM_TYPE *commHeader, UINT32 buf_len,
                     UINT8 tgt_mdl_no, UINT8 tgt_submdl_no, UINT8 src_submdl_no);
#endif /*COMM_PUB_H_*/

