/**
 * 
 * @file      zcat_dbg.h
 * @brief     
 *            This file is part of ZCAT.
 *            ZCATDbg
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.1
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2012/12/27  1.0      lu.xieji       Create file
 * 2019/02/02  1.1      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#ifndef ZCAT_DBG_H
#define ZCAT_DBG_H

//#include "oss_api.h"
#include "zcat_sig.h"
#include "zcat_event.h"

#ifdef __cplusplus
extern "C"
{
#endif

#define GSM_PHY_MOD_NUM         64
#define TD_PHY_MOD_NUM          64
#define TD_PHY_PROCCESS_NUM     16
#define LTE_PHY_MOD_NUM         128
#define WCDMA_PHY_MOD_NUM       64
#define WCDMA_PHY_PROCCESS_NUM  16
#define PS_MOD_NUM              256
#define PS_MSG_NUM              4096
#define PS_ERR_NUM              2046


typedef enum
{
    MAX_RULE_SIG_LEN           = 2 + SIG_MASK_BYTE_NUM,
    MAX_RULE_EVENT_LEN         = 2 + EVENT_MASK_BYTE_NUM,
    MAX_RULE_GSM_PHY_LEN       = 2 + 2 * GSM_PHY_MOD_NUM,
    MAX_RULE_TD_PHY_MOD_LEN    = 1 + 1 + TD_PHY_MOD_NUM,
    MAX_RULE_TD_PHY_PRO_LEN    = 1 + 1 + TD_PHY_PROCCESS_NUM,
    MAX_RULE_TD_PHY_LEN        = MAX_RULE_TD_PHY_MOD_LEN + MAX_RULE_TD_PHY_PRO_LEN,
    MAX_RULE_WCDMA_PHY_MOD_LEN = 1 + 1 + WCDMA_PHY_MOD_NUM,
    MAX_RULE_WCDMA_PHY_PRO_LEN = 1 + 1 + WCDMA_PHY_PROCCESS_NUM,
    MAX_RULE_WCDMA_PHY_LEN     = MAX_RULE_WCDMA_PHY_MOD_LEN + MAX_RULE_WCDMA_PHY_PRO_LEN,
    MAX_RULE_LTE_PHY_LEN       = 1 + LTE_PHY_MOD_NUM,
    MAX_RULE_PS_MSG_LEN        = 2 + 2 + 4 * PS_MSG_NUM,
    MAX_RULE_PS_MOD_LEN        = 2 + 2 + PS_MOD_NUM,
    MAX_RULE_PS_ERR_LEN        = 2 + 2 + 4 * PS_ERR_NUM,
    MAX_RULE_PS_ERR_LEVEL_LEN  = 4,
    MAX_RULE_PS_TYPE_LEN       = 4,

    MAX_RULE_LEN               = 2 * (MAX_RULE_PS_MSG_LEN + MAX_RULE_PS_MOD_LEN + MAX_RULE_PS_TYPE_LEN)      // ĹΪЭջȫ *2
}DBG_ENUM_RULE_LEN;

typedef enum 
{
    DBG_TYPE_TOTAL   = 0,
    DBG_GSM_PHY      = 1,
    DBG_TD_PHY       = 2,
    DBG_LTE_PHY      = 3,
    DBG_WCDMA_PHY    = 4,
    DBG_PS_PRIMARY   = 5,
    DBG_PS_EXCEPTION = 8,
    DBG_PS_GLOBAL    = 9,

    DBG_ALL_TYPE
} DBG_ENUM_TYPE;

typedef enum 
{
    TD_PHY_MOD_FILTER = 1,
    TD_PHY_PRO_FILTER = 2
} TD_PHY_FILTER_TYPE;

typedef enum 
{
    WCDMA_PHY_MOD_FILTER = 1,
    WCDMA_PHY_PRO_FILTER = 2
} WCDMA_PHY_FILTER_TYPE;

typedef enum 
{
    PS_MOD_FILTER     = 1,
    PS_MSG_FILTER     = 2,
    PS_MSG_TYPE       = 3
} PS_FILTER_TYPE;

typedef enum 
{
    PS_EXCEPTION_MOD_FILTER        = 1,
    PS_EXCEPTION_ERRORCODE_FILTER  = 2,
    PS_EXCEPTION_LEVEL_FILTER      = 3,
    PS_EXCEPTION_MSG_TYPE          = 4
} PS_EXCEPTION_FILTER_TYPE;

// GSMӡ
#define GSM_PHY_TL_NONE           (0x00)
#define GSM_PHY_TL_MSG            (0x01)
#define GSM_PHY_TL_SDL            (0x02)
#define GSM_PHY_TL_FUNC_IF        (0x04)
#define GSM_PHY_TL_CALC           (0x08)
#define GSM_PHY_TL_HWTP           (0x10)
#define GSM_PHY_TL_DEAC           (0x20)
#define GSM_PHY_TL_ACT            (0x40)
#define GSM_PHY_TL_STATE          (0x80)
#define GSM_PHY_TL_WARN           (0x100)
#define GSM_PHY_TL_ERROR          (0x200)

// TDӡ
#define TD_PHY_LEVEL_NONE         (0x00)     /* ӡ */
#define TD_PHY_LEVEL_LOW          (0x01)     /* ͼ */
#define TD_PHY_LEVEL_MED          (0x02)     /* м */
#define TD_PHY_LEVEL_HIGH         (0x04)     /* ߼ */

// LTEӡ
#define LTE_PHY_LEVEL_NONE        (0x00)     /* ӡ */
#define LTE_PHY_LEVEL_LOW         (0x01)     /* ͼ */
#define LTE_PHY_LEVEL_MED         (0x02)     /* м */
#define LTE_PHY_LEVEL_HIGH        (0x04)     /* ߼ */

// WCDMAӡ
#define WCDMA_PHY_LEVEL_NONE      (0x00)     /* ӡ */
#define WCDMA_PHY_LEVEL_LOW       (0x01)     /* ͼ */
#define WCDMA_PHY_LEVEL_MED       (0x02)     /* м */
#define WCDMA_PHY_LEVEL_HIGH      (0x04)     /* ߼ */

// PSģ
#define PS_MOD_NONE               (0x00)     /* ӡ */
#define PS_MOD_OUT                (0x01)     /*  */
#define PS_MOD_IN                 (0x02)     /*  */

// PS쳣ģ
#define PS_EXCEPTION_MOD_NONE     (0x00)     /* ӡ */
#define PS_EXCEPTION_MOD_TRACE    (0x01)     /*  */

// PS쳣ӡ
#define PS_EXCEPTION_LEVEL_NORMAL (0x01)     /* һ㼶 */
#define PS_EXCEPTION_LEVEL_SEVERE (0x02)     /* ؼ */
#define PS_EXCEPTION_LEVEL_DEBUG  (0x04)     /* Լ */

// TDģ
#define TD_PHY_MOD_NONE           (0x00)     /* ӡ */
#define TD_PHY_MOD_TRACE          (0x01)     /*  */

#define PS_TYPE_OR_LEVEL_0        (0x00)     /* PS0 */
#define PS_TYPE_OR_LEVEL_1        (0x01)     /* PS1 */
#define PS_TYPE_OR_LEVEL_2        (0x02)     /* PS2 */
#define PS_TYPE_OR_LEVEL_3        (0x03)     /* PS1PS2 */
// DBG header
typedef struct  
{
    UINT16 DbgID;
    UINT16 Filter;
    UINT32 MsgID;
    UINT32 Length;
} T_ZCAT_DBG_HEADER;

// ЭջϢṹ
typedef struct
{
    UINT32         msgID;               // ϢID
    BYTE           bSrcModID;           // ԴģID
    BYTE           bDestModID;          // ĿģID
    BYTE           Direct;
    BYTE           bPsType;             // 0:Эջ1, 2:Эջ2
    UINT32         gsmSFN;              // GSM֡
    UINT32         tdSFN;               // TD֡
    UINT32         lteSFN;              // LTE֡
    UINT32         wcdmaSFN;            // WCDMA֡
    BYTE          *pMsgBuf;             //   
    UINT32         msgLen;              // 
    UINT32         wphyCFN;
    UINT32         wphySubFrame;
    UINT32         wphyRTCFN;
} T_ZCAT_PS_HEADER;

typedef struct
{
    UINT32          Errcode;
    BYTE            ModelId;
    BYTE            PsType;             //0:Эջ1,2Эջ2
    BYTE            State;
    BYTE            Level;
    UINT32          RecvMsgId;
    UINT32          SendMsgId;
    UINT32          SFN;                // SFn
    BYTE           *pMsgBuf;
    UINT32          MsgLen;
    UINT32          gsmSFN; 
    UINT32          lteSFN; 
    UINT32          WCDMASFN; 
} T_ZCAT_PS_EXCEPTION_HEADER;

#define GSM_MAX_PARAM_NUM    20  // ԶӡϢ
#define GSM_SIG_HEAD         20  // L1GϢϢͷȣʱҪƫƵ20ֽںȡԭʼ

// GSMӡϢͷṹ
typedef struct
{
    UINT32    dwSFN;             // ֡
    UINT16    wCOState;          // CO״̬λ
    UINT16    wMsgId;
    UINT16    wModNo;
    UINT8     cLevel;
    UINT8     cParamCnt;
} T_ZCAT_GSM_PRINTINFO;

// GSMϢͶ壬Ŀǰִ֧ӡϢϢ
typedef enum
{
    GSM_MSG_PRN     =  0,
    GSM_MSG_SIG     =  1,
    GSM_MSG_OLD_PRN =  2,
    GSM_MSG_UNKNOWN =  0x1FFFFFFF  // ǿöΪ4ֽڣPC(Ĭ4ֽ)
} T_ZCAT_GSM_MSGTYPE;

typedef struct
{
    T_ZCAT_GSM_MSGTYPE   MsgType;  // Ϣ
    UINT32               SFN;      // ֡
    UINT32               Tick;
    UINT16               CoState;  // CO״̬λ
} T_ZCAT_GSM_TRACEHEADER;

//GSMϢṹ
typedef struct
{
    UINT32   MsgID;         // ϢID
    UINT16   Len;           // 
    UINT16   SrcModID;      // ԴģID
    UINT16   DestModID;     // ĿģID
    unsigned char* Buf;     // ַ
} T_ZCAT_GSM_SIGMSGINFO;

//GSMӡϢṹ
typedef  struct
{
    UINT16   MsgID;
    UINT16   ParamNum;
    SINT32   Buf[GSM_MAX_PARAM_NUM];
    UINT32   ModID;
    UINT32   Level;
} T_ZCAT_GSM_PRNMSGINFO;

//GSMĳϢṹ
typedef union
{
    T_ZCAT_GSM_SIGMSGINFO     sigMsgInfo;  //Ϣ
    T_ZCAT_GSM_PRNMSGINFO     prnMsgInfo;  //ӡϢ
} T_ZCAT_GSM_SPECMSGINFO;

//GSMϢͷṹ
typedef struct
{
    T_ZCAT_GSM_TRACEHEADER    traceHeader;  //Ϣͷ
    T_ZCAT_GSM_SPECMSGINFO    specMsgInfo; //ĳϢϢ
} T_ZCAT_GSM_TRACEINFO;

#define LTE_MAX_PARAM_NUM     32 /*ԶӡϢ*/

typedef struct
{
    UINT32 dwLogInfoHeader;
    UINT16 wMsgId;
    UINT16 wParaNum;
    UINT32 wLteSfn;
} T_ZCAT_LTE_PRINTINFO;

typedef struct
{
    UINT8  operation;
    UINT8  reserved;
    UINT16 len;
}T_ZCAT_LTE_CONTROL_MSG;

typedef enum
{
    LTE_SET_FILTERNUM = 1
} T_ZCAT_LTE_CONTROL_MSG_TYPE;



#ifdef __cplusplus
}
#endif

#endif // ZCAT_DBG_H

