/*****************************************************************************
** Ȩ (C)2015, ͨѶɷ޹˾
** 
** ļ: mix.c
** ļʶ:     
** ժҪ:    
** ʹ÷:     
** 
** ޸        汾      ޸ı        ޸          ޸
** -----------------------------------------------------------------------------
** 2019/09/25     V1.0        Create          xxq        
** 
* ******************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
 
#include <stdint.h>
#include <linux/volte_drv.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#define MIX_DEV_INVALID_ID (-1)
#define DRV_SUCCESS 0
#define DRV_ERROR (-1)
#define AUDIO_MIX_DEV_NAME "/dev/audio_mix_device"
 
int audio_mix_devfd = MIX_DEV_INVALID_ID;

int zDrvAudioMix_Write(unsigned char *pBuf, unsigned int uiLen) 
{ 
	if(audio_mix_devfd == MIX_DEV_INVALID_ID)
	{
        printf("audio /dev/audio_mix_device zDrvAudioMix_WriteOneFrame invalid dev!\n");
        return DRV_ERROR;
	} 
    
	if(write(audio_mix_devfd, pBuf, uiLen) <= 0)
	{
        printf("audio /dev/audio_mix_device zDrvAudioMix_WriteOneFrame write failed!\n");
		return DRV_ERROR;
	} 

	return DRV_SUCCESS;
}  

int zDrvAudioMix_Open(T_ZDrvAudioMix_Cfg *cfgParam) 
{
	audio_mix_devfd = open(AUDIO_MIX_DEV_NAME, O_RDWR);
    printf("open end! audio_mix_devfd=%d, audioType=%d, sample_rate=%d\n", audio_mix_devfd, cfgParam->audioType, cfgParam->sample_rate);
	if(audio_mix_devfd < 0)
	{
        printf("audio /dev/audio_mix_device zDrvAudioMix_Open failed!\n");
		return DRV_ERROR;
	}  
     
	if(ioctl(audio_mix_devfd, AUDIOMIX_IOCTL_SET_CFG, cfgParam) < 0)
	{ 
        printf("audio /dev/audio_mix_device set cfg failed!\n");
		goto err;
	}
    
	return DRV_SUCCESS;
err: 
	close(audio_mix_devfd);
	audio_mix_devfd = MIX_DEV_INVALID_ID;
    printf("audio /dev/audio_mix_device zDrvAudioMix_Open failed!\n");
	return DRV_ERROR;

}

int zDrvAudioMix_Close(void)   
{
	if(audio_mix_devfd == MIX_DEV_INVALID_ID)
	{
        printf("audio /dev/audio_mix_device zDrvAudioMix_Close invalid dev!\n");
		return DRV_ERROR;
	}
	close(audio_mix_devfd); 
	audio_mix_devfd = MIX_DEV_INVALID_ID;
    
	return DRV_SUCCESS;
}

