/*
 * arch/arm/mach-zx297510/include/mach/pcu.h
 *
 *  Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * NOTICE:
 * In zx297510 platform, some interrupt lines pass through pcu, such as definition in PCU_INT_INDEX enumeration type. Whatever types of interrupt lines is, pcu will
 * adjust its to high level. additional, if type of interrupt source is pulse, pcu will lacth it to high level. So in ISR ,we need clear interrupt status in pcu by using 
 *            void pcu_int_clear(PCU_INT_INDEX index)
 * to avoid interrupt coming incessantly when interrupt was triggered only once.
 *
 * If gpio pin is configured to interrupt mode, pcu_int_clear(PCU_INT_INDEX index) need to be called too, because hardware can trigger a fake interrupt which is just 
 * a interference whatever there is interrupt on pin or not.
 * configure a gpio pin to interrupt mode should as follows:
 * first
 *            pcu_int_set_type(PCU_INT_INDEX index, unsigned int type);
 * then
 *            pcu_int_clear(PCU_INT_INDEX index);
 */
 
#ifndef _PCU_H
#define _PCU_H

/*PCU base address*/
#define PCU_BASE_VA    (ZX29_TOP_VA+0x600)

/*int bit index which needs be clear in PCU*/
typedef enum{
	PCU_SD1_DETECT_ON_INT = 1,
	PCU_SD1_DETECT_OFF_INT,
	PCU_RTC_ALARM_INT,
	PCU_RTC_TIMER_INT,	

	PCU_USB0_POWERDWN_UP_INT = 10,
	PCU_USB0_POWERDWN_DOWN_INT,

	PCU_EX0_INT = 16,
	PCU_EX1_INT,
	PCU_EX2_INT,
	PCU_EX3_INT,
	PCU_EX4_INT,
	PCU_EX5_INT,
	PCU_EX6_INT,
	PCU_EX7_INT,
	PCU_EX8_INT,
	PCU_EX9_INT,
	PCU_EX10_INT,
	PCU_EX11_INT,
	PCU_EX12_INT,
	PCU_EX13_INT,
	PCU_EX14_INT,
	PCU_EX15_INT,

	PCU_USIM0_DETECT_ON_INT = 0x100+3,
	PCU_USIM0_DETECT_OFF_INT,
	PCU_USIM1_DETECT_ON_INT,
	PCU_USIM1_DETECT_OFF_INT,

	PCU_USB1_POWERDWN_UP_INT = 0x100+8,
	PCU_USB1_POWERDWN_DOWN_INT,	

}PCU_INT_INDEX;

/* for lowpower */
#define SYSTEM_CONFIG_REG           (PCU_BASE_VA)
#define ARM_AP_CONFIG_REG           (PCU_BASE_VA + 0x4)
#define AXI_DDR_PLL_CONFIG_REG      (PCU_BASE_VA + 0x10)
#define ARM_AP_SLEEP_TIME_REG       (PCU_BASE_VA + 0x14)
#define TIMER_SELECTION_REG         (PCU_BASE_VA + 0x4c)
#define IRAM0156_LOW_POWER_REG      (PCU_BASE_VA + 0xa4)
#define DEBUG_CONFIG_REG      		(PCU_BASE_VA + 0xc8)
#define AP_L2_POWER_ENABLE_REG      (PCU_BASE_VA + 0xcc)

#define	AP_LOW_POWER_REG1			(PCU_BASE_VA + 0x17C)
#define	AP_LOW_POWER_REG2			(PCU_BASE_VA + 0x180)

#define AP_INT_WAKE_DIS_REG1        (PCU_BASE_VA + 0x50)
#define AP_INT_TYPE_REG1            (PCU_BASE_VA + 0x60)
#define AP_INT_POLARITY_REG1        (PCU_BASE_VA + 0x70)
#define AP_INT_CLEAR_REG1           (PCU_BASE_VA + 0x80)
#define AP_INT_VCXO_SEL_REG1        (PCU_BASE_VA + 0x90)

#define AP_INT_WAKE_DIS_REG2        (PCU_BASE_VA + 0xdc)
#define AP_INT_TYPE_REG2            (PCU_BASE_VA + 0xe4)
#define AP_INT_POLARITY_REG2        (PCU_BASE_VA + 0xe8)
#define AP_INT_CLEAR_REG2           (PCU_BASE_VA + 0xec)
#define AP_INT_VCXO_SEL_REG2        (PCU_BASE_VA + 0xf0)


#define TIMER_INT_WAKE_DIS_REG      (PCU_BASE_VA + 0x5c)
#define TIMER_INT_TYPE_REG          (PCU_BASE_VA + 0x6c)
#define TIMER_INT_POLARITY_REG      (PCU_BASE_VA + 0x7c)
#define TIMER_INT_DDR_SW_CLEAR_REG  (PCU_BASE_VA + 0x8c)
#define TIMER_INT_VCXO_SEL_REG      (PCU_BASE_VA + 0x9c)

#define SHARED_DEVICE_REG1          (PCU_BASE_VA + 0xa8)
#define SHARED_DEVICE_REG2          (PCU_BASE_VA + 0xac)
#define SHARED_DEVICE_REG3          (PCU_BASE_VA + 0xb0)
#define SHARED_DEVICE_REG4          (PCU_BASE_VA + 0xb4)

#define EX_INT_TOP_CLEAR_REG		(PCU_BASE_VA + 0x1dc)
#define EX_INT_VECTOR_REG			(PCU_BASE_VA + 0x1e0)

/*ARM_AP_CONFIG_REG*/
#define	PCU_STANDBY_MODE			(1U << 0)
#define	PCU_DORMANT_MODE			(1U << 1)
#define	PCU_SHUTDOWN_MODE			(1U << 2)
#define	PCU_USE_PLL_MAIN			(7U << 3)
#define	PCU_USE_PLL_UFI				(1U << 3)
#define	PCU_USE_PLL_624				(1U << 4)
#define	PCU_USE_PLL_BUS				(1U << 5)
#define	PCU_L2_CLK_GATE				(1U << 6)	 /*1-enable*/
#define	PCU_PLL_OFF					(1U << 7)	 /*1-can turn off*/
#define	PCU_MG_CLK_RESET			(1U << 16)   /*1-can turn on*/
#define	PCU_MG_CLK_DIS				(1U << 17)   /*0-can turn off*/
#define	PCU_CORE_POWER_DIS			(1U << 18)   /*0-can turn off*/
#define	PCU_MG_POWER_DIS			(1U << 19)   /*0-can turn off*/

#define	PCU_MODE_MASK				(0x7U << 0)
#define	PCU_USE_PLL_MASK			(0x7U << 3)

/*ARM_AP_SLEEP_TIME_REG*/
#define	PCU_AP_SLEEP_TIME_DIS       (1U << 31)

/*debug config*/
#define	PCU_DEBUG_CONFIG_AP       	(0)			/* bit 1/0 */

#define	PCU_DEBUG_HIGH_PINS       	(0U << 2)	/* bit2 1--debug low 16 bit  for there are total 16 debug pins , 
                                                   but we will use them to debug 32 signals */
#define	PCU_DEBUG_LOW_PINS       	(1U << 2)
                                                   

/*AP_INT_*/
#define WAKE_SRC_INT_SDMMC0         (1U << 0)
#define WAKE_SRC_SD0_DETECT_ON      (1U << 1)
#define WAKE_SRC_SD0_DETECT_OFF     (1U << 2)
#define WAKE_SRC_RTC_ALARM          (1U << 3)
#define WAKE_SRC_RTC_TIMER          (1U << 4)
#define WAKE_SRC_ICP_M02AP          (1U << 5)
#define WAKE_SRC_ICP_PHY2AP         (1U << 6)
#define WAKE_SRC_ICP_PS2AP          (1U << 7)
#define WAKE_SRC_SPCW_PW            (1U << 8)
#define WAKE_SRC_TD_LPM_TIMER3      (1U << 9)
#define WAKE_SRC_USB_POWERDOWN_UP   (1U << 10)
#define WAKE_SRC_USB_POWERDOWN_DOWN (1U << 11)
#define WAKE_SRC_LTE_LPM_TIMER1     (1U << 12)
#define WAKE_SRC_LTE_LPM_TIMER2     (1U << 13)
#define WAKE_SRC_LTE_LPM_TIMER4     (1U << 14)
#define WAKE_SRC_SDMMC1             (1U << 15)
#define WAKE_SRC_EXTERNAL0          (1U << 16)
#define WAKE_SRC_EXTERNAL1          (1U << 17)
#define WAKE_SRC_EXTERNAL2          (1U << 18)
#define WAKE_SRC_EXTERNAL3          (1U << 19)
#define WAKE_SRC_EXTERNAL4          (1U << 20)
#define WAKE_SRC_EXTERNAL5          (1U << 21)
#define WAKE_SRC_EXTERNAL6          (1U << 22)
#define WAKE_SRC_EXTERNAL7          (1U << 23)
#define WAKE_SRC_EXTERNAL_GPIO0     (1U << 24)
#define WAKE_SRC_EXTERNAL_GPIO1     (1U << 25)
#define WAKE_SRC_EXTERNAL_GPIO2     (1U << 26)
#define WAKE_SRC_EXTERNAL_GPIO3     (1U << 27)
#define WAKE_SRC_EXTERNAL_GPIO4     (1U << 28)
#define WAKE_SRC_EXTERNAL_GPIO5     (1U << 29)
#define WAKE_SRC_EXTERNAL_GPIO6     (1U << 30)
#define WAKE_SRC_EXTERNAL_GPIO7     (1U << 31)

/*int 2*/
#define WAKE_SRC_SD0_DATA1          (1U << 0)
#define WAKE_SRC_UART0_CTS          (1U << 1)
#define WAKE_SRC_UART1_CTS          (1U << 2)
#define WAKE_SRC_USIM0_DETECT_ON    (1U << 3)
#define WAKE_SRC_USIM0_DETECT_OFF   (1U << 4)
#define WAKE_SRC_USIM1_DETECT_ON    (1U << 5)
#define WAKE_SRC_USIM_DETECT_OFF    (1U << 6)
#define WAKE_SRC_GSM_LPM            (1U << 7)
#define WAKE_SRC_USB1_POWERDWN_UP   (1U << 8)
#define WAKE_SRC_USB1_POWERDWN_DOWN (1U << 9)

/* timer int */
#define WAKE_SRC_TIMER2          	(1U << 0)
#define WAKE_SRC_TIMER3          	(1U << 1)


/*external  interrupt function */
extern void pcu_int_clear(PCU_INT_INDEX index);
extern void pcu_int_set_type(PCU_INT_INDEX index, unsigned int type);
extern unsigned int pcu_int_vector_8in1(void);
extern  void pcu_int_clear_8in1(PCU_INT_INDEX index);
extern void pcu_irq_wakeup(PCU_INT_INDEX index, int enable);

/* low power function */
extern void zx297510_pcu_init(void);
extern int zx297510_set_pcu(void);
extern int zx297510_clear_pcu(void);
extern int zx297510_unmask_wakeup_interrupt(void);
extern int zx297510_interrupt_mask_restore(void);
extern void pcu_set_pll_used(unsigned pll);
extern void pcu_get_wakeup_setting(unsigned int *pointer);
extern void pcu_clr_timer3_int(void);

#endif
