/*
 *  zx-pm.h - power management helpers interface.
 *
 *  Written by zxp.
 *
 */

#ifndef _ZX_PM_HELPERS_H
#define _ZX_PM_HELPERS_H

/*
 * common helper functions
 */
 
extern unsigned va_to_pa(unsigned virtual_address);
extern unsigned read_drar(void);
extern unsigned read_dsar(void);
extern void write_osdlr(unsigned value);
extern unsigned read_sctlr(void);
extern void write_sctlr(unsigned value);
extern void disable_mmu(void);
extern unsigned read_cpuid(void);
extern void enable_cache(void);
extern void exit_coherency(void);
extern void join_coherency(void);

extern unsigned * copy_words(volatile unsigned *destination, volatile unsigned *source, unsigned num_words);

/*
 * V7 functions
 */
extern void save_control_registers(u32 *pointer, int is_secure);
extern void save_mmu(u32 *pointer);
extern void save_performance_monitors(u32 *pointer);
extern void save_banked_registers(u32 *pointer);
extern void save_cp15(u32 *pointer);
extern void save_vfp(u32 *pointer);
extern void save_generic_timer(u32 *pointer);
extern void save_v7_debug(u32 *pointer);

extern void restore_control_registers(u32 *pointer, int is_secure);
extern void zx_restore_control_registers(u32 *pointer, int is_secure);
extern void restore_mmu(u32 *pointer);
extern void restore_performance_monitors(u32 *pointer);
extern void restore_banked_registers(u32 *pointer);
extern void restore_cp15(u32 *pointer);
extern void restore_vfp(u32 *pointer);
extern void restore_generic_timer(u32 *pointer);
extern void restore_v7_debug(u32 *pointer);

extern void disable_clean_inv_dcache_v7_l1(void);
extern void disable_clean_inv_cache_pl310(unsigned pl310_address, unsigned stack_start, unsigned stack_size, int disable);
extern void disable_clean_inv_dcache_v7_all(void);
extern void clean_dcache_v7_l1(void);
extern void clean_mva_dcache_v7_l1(void *mva);
extern void invalidate_icache_v7_pou(void);
extern void invalidate_icache_v7(void);
extern void invalidate_dcache_v7_all(void);

extern void appf_smc_handler(void);
extern void enter_secure_monitor_mode(void);
extern void enter_nonsecure_svc_mode(void);
extern void set_security_state(int ns);

/*
 * PL310 functions
 */
extern void clean_inv_range_pl310(void *start, unsigned size, unsigned pl310_address);  /* addresses are inclusive */
extern void clean_range_pl310(void *start, unsigned size, unsigned pl310_address);  /* addresses are inclusive */
extern void inv_range_pl310(void *start, unsigned size, unsigned pl310_address);
extern void clean_inv_pl310(unsigned pl310_address);
extern void clean_pl310(unsigned pl310_address);
extern void save_pl310(u32 *pointer, unsigned pl310_address);
extern void restore_pl310(u32 *pointer, unsigned pl310_address, int dormant);
extern void set_enabled_pl310(unsigned enabled, unsigned pl310_address);
extern void set_status_pl310(unsigned status, unsigned pl310_address);
extern int is_enabled_pl310(unsigned pl310_address);
extern void init_lp_of_l2(unsigned pl310_address);


/*
 * GIC functions
 */
extern int gic_distributor_set_enabled(int enabled, unsigned gic_distributor_address);
extern void save_gic_interface(u32 *pointer, unsigned gic_interface_address, int is_secure);
extern int save_gic_distributor_private(u32 *pointer, unsigned gic_distributor_address, int is_secure);
extern int save_gic_distributor_shared(u32 *pointer, unsigned gic_distributor_address, int is_secure);
extern void restore_gic_interface(u32 *pointer, unsigned gic_interface_address, int is_secure);
extern void restore_gic_distributor_private(u32 *pointer, unsigned gic_distributor_address, int is_secure);
extern void restore_gic_distributor_shared(u32 *pointer, unsigned gic_distributor_address, int is_secure);


/*
 * A9 functions
 */
extern void save_a9_timers(u32 *pointer, unsigned twd_address);
extern void save_a9_global_timer(u32 *pointer, unsigned timer_address);
extern void save_a9_other(u32 *pointer, int is_secure);

extern void restore_a9_timers(u32 *pointer, unsigned twd_address);
extern void restore_a9_global_timer(u32 *pointer, unsigned timer_address);
extern void restore_a9_other(u32 *pointer, int is_secure);


/*
 * A9 SCU functions
 */
extern void save_a9_scu(u32 *pointer, unsigned scu_address);
extern void restore_a9_scu(u32 *pointer, unsigned scu_address);
extern void set_status_a9_scu(unsigned cpu_index, unsigned status, unsigned scu_address);
extern int num_cpus_from_a9_scu(unsigned scu_address);
extern void init_lp_of_scu(unsigned scu_address);

/*
 * A9 CRM functions
 */
#define save_crm		zx297510_save_crm
#define restore_crm		zx297510_restore_crm

/*
 * pm common functions
 */
extern void zx_set_wakeup_address(void *wakeup_addr);
extern void pm_sram_write(const char *fmt, ...);
extern void pm_sram_printk(void);
extern void pm_sram_init(void);
extern cpu_sleep_type_t pm_get_sleep_type(void);
extern int zx_get_pll_used(void);
extern int pm_get_pll_used(void);
extern u32 pm_get_sleep_time(void);
extern void pm_init_crm_temp(void);
#ifdef CONFIG_ZX_PM_DEBUG
extern u32 pcu_get_debug_pin_sel(void);
extern void zx_trace_flag1(unsigned flag);
extern void zx_trace_flag2(unsigned flag);
#endif

/* 
  *pm suspend functions
  */
extern void zx_suspend_init(void);

/* 
  *cpu sleep functions
  */
extern void cpu_reset_handler(void);
extern void cpu_wake_up(void);
extern void do_sleep_cpu(void);
extern void zx_jump_addr(unsigned long addr);

/*
 * GCC Compatibility
 */
#ifndef __ARMCC_VERSION
#define __nop() __asm__ __volatile__( "nop\n" )
#endif

#endif /*_ZX_PM_HELPERS_H*/
