/*
 * arch/arm/mach-zx297520v2/include/mach/debug-macro.S
 *
 *  Copyright (C) 2013 ZTE-TSP
 *
 * Debugging macro include header
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
*/

#include <mach/iomap.h>

#define UART_FR 0x14
#define UART_DR 0x04
#define DEBUG_UART_VA	   	(ZX_UART0_BASE)
#define DEBUG_UART_PHYS	   	(ZX297520V2_UART0_PHYS)

		.macro	addruart, rp, rv, tmp
		ldr		\rp, =DEBUG_UART_PHYS		@ System peripherals (phys address)
		ldr		\rv, =DEBUG_UART_VA		@ System peripherals (virt address)
		.endm

  		.macro	senduart,rd,rx
		strb		\rd, [\rx, #UART_DR]
		.endm

		.macro	waituart,rd,rx
1001:		ldr		\rd, [\rx, #UART_FR]
		tst     	\rd, #0x20                 	@ FIFO full or not
		bne 		1001b
		.endm

		.macro	busyuart,rd,rx
1002:		ldr		\rd, [\rx, #UART_FR]
		tst     	\rd, #0x100                	@TX busy or not             
		bne		1002b
		.endm


