/*
 *  arch/arm/mach-zx297520v2/include/mach/memory.h
 *
 *  Copyright (C) 1996-1999 ZXIC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __ASM_ARCH_MEMORY_H
#define __ASM_ARCH_MEMORY_H

/*
 * Physical DRAM offset.
 */
#ifdef CONFIG_SYSTEM_RECOVERY
#define PLAT_PHYS_OFFSET	UL(0x20000000)
#define PLAT_PHYS_SIZE		UL(0x5E00000) //94M
#else
#define PLAT_PHYS_OFFSET	UL(0x22500000)
#define PLAT_PHYS_SIZE		UL(0x3900000) //57M
#endif

/*
 * DMA shared memeory
 */
#define DMA_MEM_BASE		0x25E00000
#define DMA_MEM_SIZE		0x100000 //1M

/*
 * ICP shared memeory
 */
#define ICP_MEM_BASE		0x25F00000
#define ICP_MEM_SIZE		0x100000 //1M

/*
 * Power management shared memeory
 */
#define PM_MEM_BASE		0x27BC0000
#define PM_MEM_SIZE		0xC0000 //0.75M

/*
 * TOOLs shared memeory
 */
#define TOOL_MEM_BASE		0x27A00000
#define TOOL_MEM_SIZE		0x100000 //1M

/*
 * PS buffer shared memeory
 */
#define PSBUFFER_MEM_BASE		0x27C80000
#define PSBUFFER_MEM_SIZE		0x380000 //3.5M

/* 2Kж̹߳켣 */
#define IRAM_BASE_ADDR_OS_STATISTIC     (0x8201F800)
#define IRAM_BASE_LEN_OS_STATISTIC      ((2 * 1024))

/* IRAM켣ַ */
#define IRAM_BASE_ADDR_OS_STATISTIC_PSCPU   (IRAM_BASE_ADDR_OS_STATISTIC)
#define IRAM_BASE_LEN_OS_STATISTIC_PSCPU    (0x200)
#define IRAM_BASE_ADDR_OS_STATISTIC_PHYCPU  (IRAM_BASE_ADDR_OS_STATISTIC + IRAM_BASE_LEN_OS_STATISTIC_PSCPU)
#define IRAM_BASE_LEN_OS_STATISTIC_PHYCPU   (0x200)
#define IRAM_BASE_ADDR_OS_STATISTIC_APCPU   (IRAM_BASE_ADDR_OS_STATISTIC + IRAM_BASE_LEN_OS_STATISTIC_PHYCPU)
#define IRAM_BASE_LEN_OS_STATISTIC_APCPU    (0x400)
 
#endif
