/*
 * linux/arch/arm/mach-zx297520v2/reset.c
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/clockchips.h>
#include <linux/clk.h>
#include <linux/module.h>
#include <linux/err.h>
#include <linux/syscore_ops.h>
#include <linux/gpio.h>

#include <mach/board.h>
#include <mach/iomap.h>
#include <mach/spinlock.h>
#include <linux/mfd/zx234290.h>

#define	GLOBAK_RESET_REG		(ZX_TOP_CRM_BASE)

#define	USER_RST_UNDEFINE	 	0
#define	USER_RST_TO_NORMAL  	1
#define	USER_RST_TO_CHARGER  	2
#define	USER_RST_TO_ALARM  		3
#define	USER_RST_TO_EXCEPT  	4


static bool debug_stop_reboot = false;
module_param(debug_stop_reboot, bool, 0644);

void zx29_restart(char str, const char *cmd)
{
	/* reset */
	unsigned char reg = 0;
    int ret = 0;
	u8 restart_flag = 0;
	unsigned char  status = USER_RST_UNDEFINE;

	printk(KERN_INFO "reset reboot restart\n");

  	if((cmd != NULL )&&(strcmp(cmd,"mmi_key reboot") == 0)){
		printk(KERN_INFO"restart:enter mmi_key reboot :reset to charger\n");

		/*set the vale = 2*/
		status = USER_RST_TO_CHARGER;
   	}
	else if ((cmd != NULL ) && (strcmp(cmd,"mmi_rtc reboot") == 0)){
		printk(KERN_INFO"restart: enter mmi_rtc reboot: reset to alarm\n");

		status = USER_RST_TO_ALARM;
	}
  	else if((cmd != NULL )&&(strcmp(cmd,"drv_key reboot") == 0)){
		printk(KERN_INFO"restart:enter drv_key reboot :reset to charger\n");

		/*set the vale = 2*/
		status = USER_RST_TO_CHARGER;
   	}
	else{
		printk(KERN_INFO"restart:enter reboot  :reset to normal\n");

		/*set the vale = 1*/
		status = USER_RST_TO_NORMAL;
	}
	if(debug_stop_reboot ){
		printk(KERN_INFO"debug_stop_reboot= 0x%x, for debug, bug_on!!!!\n", debug_stop_reboot);
		panic("reboot");
	}

	local_irq_disable();
	soft_spin_lock_psm(I2C2_SFLOCK);

	ret = Zx234290_SetUserReg_PSM(status);
	if(0!= ret){
		panic("restart:set restar flag error!\n");
	}

	zx_write_reg(GLOBAK_RESET_REG, 1);

	soft_spin_unlock_psm(I2C2_SFLOCK);
	local_irq_enable();
}
EXPORT_SYMBOL_GPL(zx29_restart);


