/*
 * linux/arch/arm/mach-zx297520v2/debug.c
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/clockchips.h>
#include <linux/clk.h>
#include <linux/module.h>
#include <linux/err.h>
#include <linux/syscore_ops.h>
#include <linux/gpio.h>

#include <asm/mach/time.h>

#include <mach/timex.h>
#include <mach/iomap.h>
#include <mach/debug.h>
#include <mach/irqs.h>
#include <mach/gpio.h>

#include <linux/ramdump/ramdump.h>

#define	CONFIG_USE_DEBUG_LED		0
/*
 *  we use sysfs to test&debug some system funcs
 *
 */
struct kobject *zx_root_kobj; 
struct kobject *zx_test_kobj;

extern int __init zx_clk_test_init(void);
extern int __init zx_dma_test_init(void);
extern int __init zx_icp_test_init(void);

/*
 *  test led helper interface
 *
 */
#if CONFIG_USE_DEBUG_LED
static void test_led_init(void)
{
	int ret;
	
	ret = gpio_request(ZX29_GPIO_16, "gpio16_led");
	if (ret) 
	{
		pr_info("gpio16_led gpio request error.\n");
		return ;
	}

	zx29_gpio_config(ZX29_GPIO_16, 0);  /*GPIO*/
	gpio_direction_output(ZX29_GPIO_16, GPIO_LOW);
}
static void test_led_on(void)
{
	gpio_direction_output(ZX29_GPIO_16, GPIO_HIGH);
}
static void test_led_off(void)
{
	gpio_direction_output(ZX29_GPIO_16, GPIO_LOW);
}
#else
static void test_led_init(void){}
static void test_led_on(void){}
static void test_led_off(void){}
#endif


/*=============================================================================
 *========  /sys/zte/test/timer  ==============================================
 *=============================================================================
 */
static ssize_t timer_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	s += sprintf(s, "%s\n", "[TEST]Test will light on/off led every 5s~");	

	return (s - buf);
}

/*echo 1 > /sys/zte/test/timer*/
static struct timer_list test_timer;
static unsigned long test_timer_count = 0;
static void test_timer_expired(unsigned long data)
{
	mod_timer(&test_timer, jiffies + msecs_to_jiffies(5*1000));
	
	pr_info("[TEST]Test timer arrived:%lu \n", ++test_timer_count);	

	if(test_timer_count&1)
		test_led_on();
	else
		test_led_off();
}

static ssize_t timer_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	long temp;	
//    BUG();
	if(strict_strtol(buf, 0, &temp))
		error = -EINVAL;

	if(temp == 1)
	{
		mod_timer(&test_timer, jiffies + msecs_to_jiffies(5*1000));
	}
	else
	{
		del_timer(&test_timer);
		test_timer_count = 0;	
	}
		
	return error ? error : n;
}

zte_attr(timer);

/*=============================================================================
 *========  /sys/zte/test/timer  ==============================================
 *=============================================================================
 */
/*echo 0xXXXXXXXX > /sys/zte/test/reg_read*/
static ssize_t reg_read_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

//	s += sprintf(s, "%s\n", "[TEST]Read register[0xXXXXXXXX] value~");	
	s += sprintf(s, "reg[0xf8b0002c]=%x, reg[0xf8801010]=%x, reg[0xf880100c]=%x \n",  \
				ioread32((void __iomem *)0xf8b0002c), ioread32((void __iomem *)0xf8801010), \
				ioread32((void __iomem *)0xf880100c));	

	return (s - buf);
}

static ssize_t reg_read_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	unsigned int temp;
	void __iomem * addr;

	if(strict_strtol(buf, 16, &temp))
		error = -EINVAL;

		
	addr = ioremap(temp, 4);
	if (addr) {
		pr_info("\nreg[0x%8x]=0x%8x\n", temp, ioread32(addr));
		iounmap(addr);
	}

	return error ? error : n;
}

zte_attr(reg_read);

/*test group*/
static struct attribute * g[] = 
{
	&timer_attr.attr,
	&reg_read_attr.attr,		
	NULL,
};


static struct attribute_group zte_test_attr_group = 
{
	.attrs = g,
};

/**
 *  1create sysfs "/sys/zte/test" 
 *  2call other debug modules 
 */
static int __init zx_test_init(void)
{
	int ret;

	zx_test_kobj = kobject_create_and_add("test", zx_root_kobj);
	if (!zx_test_kobj)
		return -ENOMEM;	
	
    ret = sysfs_create_group(zx_test_kobj, &zte_test_attr_group);
    if (ret)
    {
        pr_info("[DEBUG] sysfs_create_group ret %d\n", ret);	
		return ret;
    }

	setup_timer(&test_timer, test_timer_expired, 0);

	test_led_init();

    pr_info("[DEBUG] create test sysfs interface OK.\n");
	return 0;
}

static void sys_ramdump_config(void)
{
	ramdump_ram_conf_table_add("pcu_reg",0x13a000,0x7e0,ZX_PCU_BASE,0,0);
	ramdump_ram_conf_table_add("soc_sys_reg",0x140000,0x620,ZX_SOC_SYS_BASE,0,0);
	ramdump_ram_conf_table_add("std_crm_reg",0x1306000,0x170,ZX_MATRIX_CRM_BASE,0,0);
	ramdump_ram_conf_table_add("lsp_crm_reg",0x1400000,0x150,ZX_LSP_CRPM_BASE,0,0);
	ramdump_ram_conf_table_add("top_crm_reg",0x13b000,0x4b0,ZX_TOP_CRM_BASE,0,0);
	ramdump_ram_conf_table_add("ICP_reg",0x1302000,0x920,ZX_ICP_BASE,0,0);
	ramdump_ram_conf_table_add("IRAM1_reg",0x100000,0x10000,ZX_IRAM1_BASE,0,0);
	ramdump_ram_conf_table_add("DMA_reg",0x1301000,0x1000,ZX_DMA_PS_BASE,0,0);

	ramdump_ram_conf_table_add("RM_TIMER0_reg",0x142000,0x20,ZX_RM_TIMER0_BASE,0,0);
	ramdump_ram_conf_table_add("AP_TIMER1_reg",0x143000,0x20,ZX_AP_TIMER1_BASE,0,0);
	ramdump_ram_conf_table_add("AP_TIMER2_reg",0x144000,0x20,ZX_AP_TIMER2_BASE,0,0);
	ramdump_ram_conf_table_add("RM_TIMER1_reg",0x145000,0x20,ZX_RM_TIMER1_BASE,0,0);
	ramdump_ram_conf_table_add("AP_TIMER3_reg",0x146000,0x20,ZX_AP_TIMER3_BASE,0,0);
	ramdump_ram_conf_table_add("PS_TIMER1_reg",0x138000,0x20,ZX_PS_TIMER1_BASE,0,0);
	ramdump_ram_conf_table_add("PS_TIMER2_reg",0x139000,0x20,ZX_PS_TIMER2_BASE,0,0);
	ramdump_ram_conf_table_add("PS_TIMER0_reg",0x1401000,0x20,ZX_PS_TIMER0_BASE,0,0);
	ramdump_ram_conf_table_add("PS_RM_TIMER_reg",0x140B000,0x20,ZX_PS_RM_TIMER_BASE,0,0);
	ramdump_ram_conf_table_add("AP_TIMER0_reg",0x140F000,0x20,ZX_AP_TIMER0_BASE,0,0);
	ramdump_ram_conf_table_add("AP_TIMER4_reg",0x1411000,0x20,ZX_AP_TIMER4_BASE,0,0);
	ramdump_ram_conf_table_add("AP_GIC_reg",0xF2000000,0x1000,ZX_GIC_BASE,0,0);
	ramdump_ram_conf_table_add("AP_CRM_reg",0xF2202000,0x1000,AP_CRM_BASE,0,0);
		
}

/**
 *  1create sysfs "/sys/zte" 
 *  2call other debug modules 
 */
static int __init zx_debug_init(void)
{
    pr_info("[DEBUG] create  sysfs interface OK.\n");
	zx_root_kobj = kobject_create_and_add("zte", NULL);
	if (!zx_root_kobj)
		return -ENOMEM;	


	zx_test_init();

	zx_clk_test_init();
	
#ifdef CONFIG_ZX29_DMA
	zx_dma_test_init();	
#endif

#ifdef CONFIG_RPM_ZX29 
	zx_icp_test_init();
#endif
	sys_ramdump_config( );

    return 0;
}

late_initcall(zx_debug_init);

