/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:
 * File Mark:
 * Description:  definition of clock name and frequency for zx297520
 * Others:
 * Version:       v1.0
 * Author:        xuzhiguo
 * Date:          2014-07-01
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/

#ifndef _DRVS_CLK_H
#define _DRVS_CLK_H

/****************************************************************************
*                                           Macros
****************************************************************************/

/****************************************************************************
*                                           Types
****************************************************************************/
#ifndef DRV_USE_MODEM_TYPE
typedef int 			   SINT32;
typedef void				 VOID;
#endif

/*
* ACLK: AXI BUS CLOCK
* HCLK: AHB BUS CLOCK
* ACLK: APB BUS CLOCK
*/
typedef enum
{
    /*
    * chip input clock
    */
    CLK_MAIN_26M = 0, /* ---------0 */

    /*
    * PS
    */
    CLK_PS_CORE,
    CLK_PS_CORE_IDLE,
    CLK_AXI2AXI_APB_AS_FOR_TCM,  
	CLK_FROMMATIRX_ACLK,
    CLK_AXI2AXI_AS_M1,
    CLK_AXI2AXI_APB_AS,
	CLK_R7CRM_PCLK,
	CLK_R7CFG_APBMUX_PCLK,
	CLK_R7INT,
    CLK_TODDR3_ACLK, 
    CLK_TOMATIRX_ACLK,

    /*
    * USB
    */
    CLK_USB_ACLK,
    CLK_M1_1M3S_USB30,
    CLK_USB20_PHY_WCLK,   
    CLK_USB30_PHY_WCLK, 
	CLK_USB30_CTRL_WCLK,
    CLK_USB_REF,
    CLK_USB_32K,

    CLK_HSIC_HCLK,       
    CLK_HSIC_12M_PHY_WCLK,   
    CLK_HSIC_480M_PHY_WCLK,
	CLK_HSIC_CTRL_WCLK,
    CLK_S3_MATRIX3X2_HSIC,  
	
    /*
    *dma
    */
    CLK_DMA0_PCLK,    
    CLK_DMA0_ACLK,  

    /*
    * M2_AXI2AHB
    */
    CLK_M2_ACLK,
    CLK_M2_HCLK,

    /*
    * edcp
    */             
    CLK_EDCP_HCLK,
    CLK_EDCPASYNC_ACLK,   
    CLK_EDCPSYNC_ACLK,   

    /*
    * nand
    */
	CLK_4M1SNAND_HCLK,
    CLK_NAND_HCLK ,
    CLK_NAND_WCLK,

    /*
    * sd
    */
    CLK_SD0_HCLK,
    CLK_SD1_HCLK, 
	
    CLK_SD0_32K, 
    CLK_SD1_32K,
	
    CLK_SD0_WCLK,    
    CLK_SD1_WCLK,     

    /*
    * i2s
    */    
    CLK_I2S0_PCLK,
	CLK_I2S1_PCLK,
    
    CLK_I2S0_WCLK,
    CLK_I2S1_WCLK,

    /*
    * blg
    */     
    CLK_BLG_PCLK,
    CLK_BLG_WCLK,    

    /*
    * mculcd
    */
    CLK_MCULCD_PCLK,  
    CLK_MCULCD_WCLK,

    /*
    * spifc
    */
    CLK_SPIFC_PCLK,
    CLK_SPIFC_WCLK,    

    /*
    * lsp mg input clock
    */
    CLK_LSP78M,       
    CLK_LSP156M,      
    CLK_LSP208M,
    CLK_LSP122M88,

    /*
    * ssp
    */      
    CLK_SSP0_PCLK,
    CLK_SSP1_PCLK,
    
    CLK_SSP0_WCLK,    
    CLK_SSP1_WCLK,

    /*
    * uart0
    */
    CLK_UART0_PCLK,
    CLK_UART1_PCLK,
    CLK_UART2_PCLK, 
  
    CLK_UART0_WCLK, 
    CLK_UART1_WCLK,        
    CLK_UART2_WCLK,     

    /*
    * i2c
    */
    CLK_RMI2C_PCLK,
	CLK_I2C0_PCLK,
    CLK_I2C1_PCLK,	
	
    CLK_RMI2C_WCLK,         
    CLK_I2C0_WCLK,         
    CLK_I2C1_WCLK,

    /*
    * timer
    */
    CLK_TIMER0_PCLK,
	CLK_TIMER1_PCLK, 
	CLK_TIMER5_PCLK,
	CLK_TIMER6_PCLK,
		
    CLK_TIMER0_WCLK,    
    CLK_TIMER1_WCLK,   
	CLK_TIMER5_WCLK,
    CLK_TIMER6_WCLK,

    /*
    * usim
    */
    CLK_USIM_PCLK,     
    CLK_USIM_WCLK,    

    /*
    * rtc
    */
    CLK_RTC_PCLK,   
    CLK_RTC_WCLK,

    /*
    * key
    */
    CLK_KEY_PCLK,
    CLK_KEY_WCLK,    

    /*
    * gsmlpm
    */
    CLK_GSMLPM_PCLK,    
    CLK_GSMLPM_WCLK,  
} T_ZDrvSysClk_Name;




/*
*  bits domain definition  for clock frequency
*  base clock name   same clock number  reserved       clock selection   frequency division
*  31...28 27...24   23...20            19...16        15...12 11...8    7...4 3...0
*  invalid value:
*  0xff              0xf or 0x0         0x0 or ignore     0xff          0xff
*/

typedef enum
{
    /*fixed frequency*/
	FIXED_FREQ =0xffffffff,
	    /*
    *ps core
    */
    PS_CORE_APLL      = (CLK_PS_CORE << 24) | 0x00100000,
    PS_CORE_26M       = (CLK_PS_CORE << 24) | 0x00100100,
    PS_CORE_624M      = (CLK_PS_CORE << 24) | 0x00100200,
    PS_CORE_491M52    = (CLK_PS_CORE << 24) | 0x00100300,
    PS_CORE_312M      = (CLK_PS_CORE << 24) | 0x00100400,
    PS_CORE_208M      = (CLK_PS_CORE << 24) | 0x00100500,
    PS_CORE_104M      = (CLK_PS_CORE << 24) | 0x00100600,
    PS_CORE_78M       = (CLK_PS_CORE << 24) | 0x00100700,
    PS_CORE_52M       = (CLK_PS_CORE << 24) | 0x00100800,
    PS_CORE_156M      = (CLK_PS_CORE << 24) | 0x00100900,
    PS_CORE_245M76    = (CLK_PS_CORE << 24) | 0x00100a00,
    PS_CORE_APLL_div2 = (CLK_PS_CORE << 24) | 0x00100b00,

    /*
     *ps core idle
     */
    PS_CORE_IDLE_APLL      = (CLK_PS_CORE_IDLE << 24) | 0x00100000,
    PS_CORE_IDLE_26M       = (CLK_PS_CORE_IDLE << 24) | 0x00100100,
    PS_CORE_IDLE_624M      = (CLK_PS_CORE_IDLE << 24) | 0x00100200,
    PS_CORE_IDLE_491M52    = (CLK_PS_CORE_IDLE << 24) | 0x00100300,
    PS_CORE_IDLE_312M      = (CLK_PS_CORE_IDLE << 24) | 0x00100400,
    PS_CORE_IDLE_208M      = (CLK_PS_CORE_IDLE << 24) | 0x00100500,
    PS_CORE_IDLE_104M      = (CLK_PS_CORE_IDLE << 24) | 0x00100600,
    PS_CORE_IDLE_78M       = (CLK_PS_CORE_IDLE << 24) | 0x00100700,
    PS_CORE_IDLE_52M       = (CLK_PS_CORE_IDLE << 24) | 0x00100800,
    PS_CORE_IDLE_156M      = (CLK_PS_CORE_IDLE << 24) | 0x00100900,
    PS_CORE_IDLE_245M76    = (CLK_PS_CORE_IDLE << 24) | 0x00100a00,
    PS_CORE_IDLE_APLL_div2 = (CLK_PS_CORE_IDLE << 24) | 0x00100b00,

    /* EDCP WCLK*/
	WCLK_EDCP_156M = (CLK_EDCPASYNC_ACLK << 24) | 0x00100000,
	WCLK_EDCP_208M = (CLK_EDCPASYNC_ACLK << 24) | 0x00100100,
	WCLK_EDCP_245M76 = (CLK_EDCPASYNC_ACLK << 24) | 0x00100200,
	WCLK_EDCP_312M = (CLK_EDCPASYNC_ACLK << 24) | 0x00100300,
	
	/*NAND WCLK*/
	WCLK_NAND_104M = (CLK_NAND_WCLK << 24) | 0x00100000,
	WCLK_NAND_26M = (CLK_NAND_WCLK << 24) | 0x00100100,
	WCLK_NAND_78M = (CLK_NAND_WCLK << 24) | 0x00100200,
	WCLK_NAND_52M = (CLK_NAND_WCLK << 24) | 0x00100300,

	/* SD0 WCLK*/
	WCLK_SD0_52M = (CLK_SD0_WCLK << 24) | 0x00100000,
	WCLK_SD0_26M = (CLK_SD0_WCLK << 24) | 0x00100100,
	WCLK_SD0_96M = (CLK_SD0_WCLK << 24) | 0x00100200,
	WCLK_SD0_49M1= (CLK_SD0_WCLK << 24) | 0x00100300,

	/* SD1 WCLK*/
	WCLK_SD1_52M = (CLK_SD1_WCLK << 24) | 0x00100000,
	WCLK_SD1_26M = (CLK_SD1_WCLK << 24) | 0x00100100,
	WCLK_SD1_96M = (CLK_SD1_WCLK << 24) | 0x00100200,
	WCLK_SD1_49M1= (CLK_SD1_WCLK << 24) | 0x00100300,
	WCLK_SD1_24M57 = (CLK_SD1_WCLK << 24) | 0x00100400,
	WCLK_SD1_208M = (CLK_SD1_WCLK << 24) | 0x00100500,
	WCLK_SD1_104M = (CLK_SD1_WCLK << 24) | 0x00100600,
	WCLK_SD1_156M = (CLK_SD1_WCLK << 24) | 0x00100700,
	

	/* I2S WCLK*/
	/*I2S not be used in zx297520, so ignore it's clock*/

	/* BLG WCLK*/
	/* blg work clock used default 32KHz*/

	/*MCULCD WCLK*/
	WCLK_MCULCD_104M = (CLK_MCULCD_WCLK << 24) | 0x00100000,
	WCLK_MCULCD_26M = (CLK_MCULCD_WCLK << 24) | 0x00100100,
	WCLK_MCULCD_52M = (CLK_MCULCD_WCLK << 24) | 0x00100200,
	WCLK_MCULCD_78M = (CLK_MCULCD_WCLK << 24) | 0x00100300,

    /*SPIFC WCLK*/
	WCLK_SPIFC_104M = (CLK_SPIFC_WCLK << 24) | 0x00100000,
	WCLK_SPIFC_26M = (CLK_SPIFC_WCLK << 24) | 0x00100100,
	WCLK_SPIFC_52M = (CLK_SPIFC_WCLK << 24) | 0x00100200,
	WCLK_SPIFC_122M88 = (CLK_SPIFC_WCLK << 24) | 0x00100300,
	WCLK_SPIFC_156M = (CLK_SPIFC_WCLK << 24) | 0x00100400,
	WCLK_SPIFC_208M = (CLK_SPIFC_WCLK << 24) | 0x00100500,

    /* TIMER WCLK*/
    WCLK_TIMER_32K = (CLK_TIMER0_WCLK << 24) | 0x00400000,
    WCLK_TIMER_26M = (CLK_TIMER0_WCLK << 24) | 0x00400100,     /* 1 div*/
	WCLK_TIMER_13M = (CLK_TIMER0_WCLK << 24) | 0x00400101,     /* 2 div*/
	

    /* I2C WCLK*/
    WCLK_I2C_26M = (CLK_RMI2C_WCLK << 24) | 0x00300100,
    WCLK_I2C_104M = (CLK_RMI2C_WCLK << 24) | 0x00300000,

    /* UART WCLK*/
    WCLK_UART0_26M = (CLK_UART0_WCLK << 24) | 0x00100100,
    WCLK_UART0_104M = (CLK_UART0_WCLK << 24) | 0x00100000,

	WCLK_UART12_26M = (CLK_UART1_WCLK << 24) | 0x00200000,
    WCLK_UART12_104M = (CLK_UART1_WCLK << 24) | 0x00200100,

    /* SSP WCLK*/
    WCLK_SSP_0M = (CLK_SSP0_WCLK << 24) | 0x00200301,
    WCLK_SSP_6M5 = (CLK_SSP0_WCLK << 24) | 0x00200203,
    WCLK_SSP_13M = (CLK_SSP0_WCLK << 24) | 0x00200201,
    WCLK_SSP_26M = (CLK_SSP0_WCLK << 24) | 0x00200200,
    WCLK_SSP_52M = (CLK_SSP0_WCLK << 24) | 0x00200101,
    WCLK_SSP_78M = (CLK_SSP0_WCLK << 24) | 0x00200001,


    /* USIM WCLK */
    /* usim work clock is fixed 13MHz*/
    /*WCLK_USIM_13M = (CLK_USIM_WCLK << 24) | 0x0010ffff,*/

    /* RTC WCLK */
    /* rtc work clock is fixed 32KHz*/
    /*WCLK_RTC_32K = (CLK_RTC_WCLK << 24) | 0x0010ffff,*/

    /* KEY WCLK */
    /* KEY work clock is fixed 32KHz*/
    /*WCLK_KEY_32K = (CLK_RTC_WCLK << 24) | 0x0010ffff,*/
    

} T_ZDrvSysClk_Freq;

typedef enum
{
    SYSCLK_DISABLE = 0x100,   /*disable  software gate */
    SYSCLK_ENABLE,            /*enable   software gate */
    SYSCLK_DISAUTO,           /*disable  hardware gate */
    SYSCLK_AUTO,              /*enable   hardware gate */
} T_ZDrvSysClk_Gate;


/****************************************************************************
*                                           function
****************************************************************************/
/*******************************************************************************
* Function: zDrvSys_PreInit
* Description: system previous initialization
* Parameters:
*	Input:
*
*	Output:
*
* Returns:
*
* Others:
********************************************************************************/
SINT32 zDrvSys_PreInit(VOID);

/*******************************************************************************
* Function: zDrvSys_Initiate
* Description: system initialization
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
SINT32 zDrvSys_Initiate(VOID);

/*******************************************************************************
* Function:    zDrvSysClk_IsEnable
* Description: get clock software gate status
* Parameters:
*   Input:
*           name: clock number
*
*   Output: NULL
*
* Returns: 0: software gate disable
*          1: software gate enable
*          DRV_ERR_INVALID_PARAM: invalid parameter
*
* Others:
********************************************************************************/
SINT32 zDrvSysClk_IsEnable(T_ZDrvSysClk_Name name);


/*******************************************************************************
* Function:    zDrvSysClk_IsAutoGate
* Description: get clock hardware gate status
* Parameters:
*   Input:
*           name: clock number
*
*   Output: NULL
*
* Returns: 0: hardware gate disable
*          1: hardware gate enable
*          DRV_ERR_INVALID_PARAM:invalid parameter
*
* Others:
********************************************************************************/
SINT32 zDrvSysClk_IsAutoGate(T_ZDrvSysClk_Name name);


/*******************************************************************************
 * Function:    zDrvSysClk_Reset
 * Description: set logic to reset status
 * Parameters:
 *   Input:
 *           name: clock number
 *
 *   Output: NULL
 *
 * Returns: DRV_SUCCESS
 *          DRV_ERR_INVALID_PARAM
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvSysClk_Reset(T_ZDrvSysClk_Name name);

/*******************************************************************************
 * Function:    zDrvSysClk_Release
 * Description:  set logic out of reset status
 * Parameters:
 *   Input:
 *           name: clock number
 *
 *   Output: NULL
 *
 * Returns: DRV_SUCCESS
 *          DRV_ERR_INVALID_PARAM
 *
 * Others:
 ********************************************************************************/
SINT32 zDrvSysClk_Release(T_ZDrvSysClk_Name name);

/*******************************************************************************
* Function:    zDrvSysClk_SetGate
* Description:  set clock gate status
* Parameters:
*   Input:
*           name: clock number
*           gate: gate status
*   Output: NULL
*
* Returns: DRV_SUCCESS
*          DRV_ERR_INVALID_PARAM
*
* Others:
********************************************************************************/
SINT32 zDrvSysClk_SetGate(T_ZDrvSysClk_Name name, T_ZDrvSysClk_Gate gate);

/*******************************************************************************
* Function: zDrvSysClk_SetFreq
* Description: set clock frequency which defined in drvs_sys.h by T_ZDrvSysClk_Freq
* Parameters:
 *   Input:
 *           name: clock number
*            freq: clock frequency
*   Output: NULL
*
* Returns:  DRV_SUCCESS
*           DRV_ERR_INVALID_PARAM
* Others:
********************************************************************************/
SINT32 zDrvSysClk_SetFreq(T_ZDrvSysClk_Name name, T_ZDrvSysClk_Freq freq);


#endif

