/**
 * File: dma_ch_cfg.h
 * Brief: Implementation of dma channel config
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * Author: Xingxing Xue <xue.xingxing@sanechips.com.cn>
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

#ifndef _DMA_CH_CFG_H
#define _DMA_CH_CFG_H
/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "dma.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define DMA_CHANNEL_CONFIG(peripheral_id, is_used , enable_mem2mem)		{peripheral_id, is_used, enable_mem2mem}

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*dma channel config define*/
typedef struct 
{
    dma_peripheral_id 	peripheral_id;		/* hw channel id */
    unsigned int 		is_used;
    unsigned int 		enable_mem2mem;
#if 0	
    void *				data;
    dma_callback_func 	channel_callback;
#endif	
}dma_channel_config;

static dma_channel_config dma_chan_config[] =
{
	DMA_CHANNEL_CONFIG(DMA_CH_UART0_TX, 	false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_UART0_RX,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_UART1_TX,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_UART1_RX,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_SSP0_TX,		false,	false),
	
	DMA_CHANNEL_CONFIG(DMA_CH_SSP0_RX,		false,	true),
#if 1	/* only ps core used */
	DMA_CHANNEL_CONFIG(DMA_CH_GPRS0,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_GPRS1,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_USIM,			false,	false),
#endif	
	DMA_CHANNEL_CONFIG(DMA_CH_I2S0_TX, 		false,	false),

	DMA_CHANNEL_CONFIG(DMA_CH_I2S0_RX0,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_I2S1_TX,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_I2S1_RX0,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_SPIFC_TX,		false,	false),
	DMA_CHANNEL_CONFIG(DMA_CH_SPIFC_RX,		false,	false),	
	
	DMA_CHANNEL_CONFIG(DMA_CH_SSP1_TX,		false,	true),
	DMA_CHANNEL_CONFIG(DMA_CH_SSP1_RX,		false,	false),	
	DMA_CHANNEL_CONFIG(DMA_CH_UART2_TX,		false,	true),
	DMA_CHANNEL_CONFIG(DMA_CH_UART2_RX,		false,	true),
	
	DMA_CHANNEL_CONFIG(DMA_CH_EMBMS,		false,	false),
	#if 1	/* only ps core used */	
	DMA_CHANNEL_CONFIG(DMA_CH_USIM1,		false,	true),
	#endif	
	DMA_CHANNEL_CONFIG(DMA_CH_M2M_TX,		false,	true),
	DMA_CHANNEL_CONFIG(DMA_CH_M2M_RX,		false,	true),
};

#endif

