#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/init.h>
#include <linux/slab.h>
#include <linux/device.h>
#include <lynq/lynq_ap_nv_cfg.h>
#include <linux/crc16.h>
#include <mach/iomap.h>
#include <linux/cdev.h>
//#include <asm-generic/iomap.h>
#include "lynq_default_nv_cfg.h"

static struct nv_cfg_info * g_nv_cfg_info = NULL;

static struct nv_cfg_info * get_valid_nv_cfg(unsigned char * buff, unsigned int len)
{
    int content_len, pos, crc;
    unsigned char * p_cfg_body = NULL;
    struct lynq_nv_cfg_header *p_tail;
    struct version_info * p_versions;
    struct lynq_nv_cfg * p_nv_cfg = (struct lynq_nv_cfg *)buff;
    if (p_nv_cfg == NULL)
        return NULL;
    if (p_nv_cfg->head.magic_flag != 0xaa55 || p_nv_cfg->head.valid_flag != 1 ||
            len < (p_nv_cfg->head.content_len + sizeof(struct lynq_nv_cfg_header)*2))
    {
        printk("got bad header\n");
        return NULL;
    }
    content_len = (char*)&p_nv_cfg->tail - (char*)&p_nv_cfg->head - sizeof(struct lynq_nv_cfg_header);
    //actual content len less than default request len, maybe a lower version protocol, ignore
    if (content_len > p_nv_cfg->head.content_len || content_len != sizeof(lynq_nv_cfg_bitmap))
    {
        printk("got bad content len\n");
        return NULL;
    }
    else if ( content_len == p_nv_cfg->head.content_len)
    {
        if (p_nv_cfg->tail.magic_flag != 0x55aa || p_nv_cfg->tail.valid_flag != 1
                || p_nv_cfg->tail.content_len != p_nv_cfg->head.content_len)
        {
            printk("got bad tail %d\n", __LINE__);
            return NULL;
        }
        p_cfg_body = (unsigned char*)kzalloc(p_nv_cfg->head.content_len, GFP_KERNEL);
        memcpy(p_cfg_body, &p_nv_cfg->content, p_nv_cfg->head.content_len);
        p_versions = p_nv_cfg->versions;
    }
    else // maybe a newer protocol, need backward compatible
    {
        p_cfg_body = (unsigned char*)&p_nv_cfg->content;
        p_tail = (struct lynq_nv_cfg_header *)(p_cfg_body+p_nv_cfg->head.content_len);
        if (p_tail->magic_flag != 0x55aa || p_tail->valid_flag != 1
                || p_tail->content_len != p_nv_cfg->head.content_len)
        {
            printk("got bad tail %d\n", __LINE__);
            return NULL;
        }
        p_versions = (struct version_info *)(p_cfg_body+p_nv_cfg->head.content_len + sizeof (struct lynq_nv_cfg_header));
        p_cfg_body = (unsigned char*)kzalloc(p_nv_cfg->head.content_len, GFP_KERNEL);
        memcpy(p_cfg_body, &p_nv_cfg->content, p_nv_cfg->head.content_len);
    }

    while(p_versions->soft_ver != 0 && p_versions->crc != 0)
    {
        if (p_versions->soft_ver != lynq_default_soft_version)
        {
            p_versions++;
            continue;
        }

        //
        for(pos = 0; pos < content_len; pos ++)
        {
            p_cfg_body[pos] &= lynq_nv_cfg_bitmap[pos];
        }

        crc = crc16(0, p_cfg_body, content_len);
        printk("crc is %d\n", crc);

        if (crc != p_versions->crc)
        {
            printk("got bad crc\n");
            break;
        }

        return (struct nv_cfg_info *)p_cfg_body;
    }

    printk("no valid protocal version found\n");

    if (p_cfg_body != NULL)
    {
        kfree(p_cfg_body);
    }
    return NULL;
}

static int read_from_uboot_memory(unsigned char * buff)
{
    int len, total_read_cnt, min_read_cnt, zero_cnt, ret;
    int * curr_pos;
    struct lynq_nv_cfg_header * head = (struct lynq_nv_cfg_header *)buff;
    curr_pos = (int*)buff;
    *curr_pos = ioread32(MMC_LYNQ_NV_CFG_ADDR);
    printk("read data is %08x\n", *curr_pos);
    curr_pos++;
    if (head->magic_flag != 0xaa55 || head->valid_flag != 1
            || head->content_len > (MMC_LYNQ_NV_CFG_SIZE - sizeof(struct lynq_nv_cfg_header)*2))
    {
        printk("got bad header len %d\n",head->content_len);
        printk("magic %04x-need %04x\n", head->magic_flag, 0xaa55);
        return 0;
    }
    min_read_cnt = head->content_len + sizeof(struct lynq_nv_cfg_header) + sizeof (struct version_info) + sizeof(int);
    if (min_read_cnt > MMC_LYNQ_NV_CFG_SIZE)
    {
        total_read_cnt = MMC_LYNQ_NV_CFG_SIZE;
        min_read_cnt = MMC_LYNQ_NV_CFG_SIZE;
    }

    total_read_cnt = total_read_cnt / sizeof (int);
    min_read_cnt = min_read_cnt / sizeof (int);

    len = 1;
    zero_cnt = 0;
    while(len < total_read_cnt && zero_cnt < 4)
    {
        ret = ioread32(MMC_LYNQ_NV_CFG_ADDR + len * sizeof(int));
        printk("read data %08x\n", ret);
        *curr_pos++ = ret;
        if (ret != 0) {
            zero_cnt = 0;
        }
        else{
            zero_cnt ++;
        }
        len ++;
    }

    return len * sizeof(int);
}

struct nv_cfg_info *get_ap_nv_cfg_info()
{

    int len;
    unsigned char * buff;
    struct nv_cfg_info * ret;
    printk("enter get_ap_nv_cfg_info\n");
    if (g_nv_cfg_info != NULL)
        return g_nv_cfg_info;

    printk("[%s] start init!\n", __func__);

    ret = NULL;
    buff = kzalloc(MMC_LYNQ_NV_CFG_SIZE, GFP_KERNEL);
    printk("enter read_from_uboot_memory\n");
    len = read_from_uboot_memory(buff);
    if (len > 0)
    {
        printk("enter check cfg from uboot\n");
        ret = get_valid_nv_cfg(buff, len);
    }
    // read default in head file
    if (ret == NULL)
    {
        printk("enter check lynq_default_nv_cfg_value\n");
        ret = get_valid_nv_cfg(lynq_default_nv_cfg_value, sizeof (lynq_default_nv_cfg_value));
    }

    // use local default values
    if (ret == NULL){
        printk("enter use local default values\n");
        ret = (struct nv_cfg_info *)kzalloc(sizeof (struct nv_cfg_info), GFP_KERNEL);
        memset(ret, 0, sizeof(struct nv_cfg_info));
        ret->mmc0_enable = 0;
        ret->mmc1_enable = 1;
    }

    g_nv_cfg_info = ret;

    return ret;
}

#define DECLARE_NV_CFG_ATTR(name) \
static ssize_t name##_show(struct device *dev, struct device_attribute *attr, char *buf) \
{ \
    return sprintf(buf, "%d", get_##name()); \
}\
\
static DEVICE_ATTR(name, 0664, name##_show, NULL); \


DECLARE_NV_CFG_ATTR(wifi_enable)
DECLARE_NV_CFG_ATTR(rndis_ip_map)
/*
static struct attribute * lynq_nv_cfg_attrs[] = {
    &dev_attr_wifi_enable.attr,
    NULL,
};

static const struct attribute_group lynq_nv_cfg_attr_grp = {
    .attrs = lynq_nv_cfg_attrs,
};
*/
static struct class * lynq_nv_cfg_class;
static struct class_device * lynq_nv_cfg_device;
static int __init lynq_nv_cfg_init(void)
{
    printk("[%s] start init!\n", __func__);
    lynq_nv_cfg_class =  class_create(THIS_MODULE, "lynq_nv_cfg");
    if (lynq_nv_cfg_class == NULL)
        return -1;
    lynq_nv_cfg_device = device_create(lynq_nv_cfg_class, NULL, MKDEV(1,0), NULL, "cdev_lynq_nv_cfg");
    if (lynq_nv_cfg_device == NULL)
        return -1;
    //sysfs_create_group(&lynq_nv_cfg_device->kobj, &lynq_nv_cfg_attr_grp);
    device_create_file(lynq_nv_cfg_device, &dev_attr_wifi_enable);
    device_create_file(lynq_nv_cfg_device, &dev_attr_rndis_ip_map);
    return 0;
}

static void __exit lynq_nv_cfg_exit(void)
{
    printk("[%s] start exit!\n", __func__);
    //platform_driver_unregister(&lynq_nv_cfg_device);
}

module_init(lynq_nv_cfg_init);
module_exit(lynq_nv_cfg_exit);
