/*
 * linux/arch/arm/mach-zx297520v2/pwr_ctrl.c
 *
 * Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <linux/clk.h>
#include <linux/errno.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/debugfs.h>
#include <linux/seq_file.h>
#include <linux/kernel.h>
#include <linux/list.h>
#include <linux/module.h>
#include <linux/io.h>

#include <mach/gpio.h>
#include <mach/gpio_def.h>
#include <linux/gpio.h>
#include <mach/pwr_ctrl.h>
#include <linux/delay.h>
#include <mach/pcu.h>
//++yuwei 20160719
#include <mach/gpio_cfg.h>
//++
//youchen@2024-06-20 add for lynq nv config begin
#include <lynq/lynq_ap_nv_cfg.h>
//youchen@2024-06-20 add for lynq nv config end


static unsigned int pwr_buck3v3_init_flag	= 0;
static unsigned int pwr_buck3v3_status  		= 0;
extern void sd_io_config(u32 sd_index,bool active_flag);

void pwr_buck3v3_init(void)
{
	int ret=0;

	ret=gpio_request(PIN_WIFI_PWR_CTL,"buck3V3");
	if(ret)
		BUG();
	//zx29_gpio_config(ZX29_GPIO_27, GPIO27_GPIO27);
	zx29_gpio_config(PIN_WIFI_PWR_CTL, PIN_WIFI_PWR_CTL_SEL);
    	gpio_direction_output(PIN_WIFI_PWR_CTL, GPIO_LOW);
}

void pwr_buck3v3_on(power_buck3v3_id val)
{	
	if(pwr_buck3v3_init_flag == 0)
	{
		pwr_buck3v3_init();
		pwr_buck3v3_init_flag = 1;
		mdelay(100);
	}

	if(pwr_buck3v3_status == 0)
	{
		gpio_set_value(PIN_WIFI_PWR_CTL, GPIO_HIGH);
	}
	pwr_buck3v3_status |= (1<<val);	
}

void pwr_buck3v3_off(power_buck3v3_id val)
{
	pwr_buck3v3_status &= ~(1<<val);	
	if( pwr_buck3v3_status == 0)
	{
		gpio_set_value(PIN_WIFI_PWR_CTL, GPIO_LOW);
	}
}

//#ifdef CONFIG_RDA5995_WIFI
#if defined (CONFIG_RDAWFMAC)||defined(CONFIG_RDAWFMAC_MODULE)
int rda_wifi_init(void)
{	
	int ret = 0;
	ret = gpio_request(PIN_WIFI_CHIP_ENABLE,"wifi_chip_enable");	
	if(ret < 0)	
	{        
		printk("request wifi enable gpio failed\n");     
		gpio_free(PIN_WIFI_CHIP_ENABLE);    
	}
	return ret;
}
EXPORT_SYMBOL(rda_wifi_init);

void rda_wifi_deinit(void)
{	
	       
	printk("gpio_free wifi enable gpio \n");     
	gpio_free(PIN_WIFI_CHIP_ENABLE);    

}
EXPORT_SYMBOL(rda_wifi_deinit);

void rda_wifi_enable(int bval)
{	
	zx29_gpio_config(PIN_WIFI_CHIP_ENABLE, PIN_WIFI_CHIP_ENABLE_SEL);
	if(bval)	
	{	
		gpio_direction_output(PIN_WIFI_CHIP_ENABLE, GPIO_HIGH);	
		printk("rda_wifi gpio%d success high ##############################\n",PIN_WIFI_CHIP_ENABLE);
	}	
	else	
	{	
		gpio_direction_output(PIN_WIFI_CHIP_ENABLE, GPIO_LOW);	
		printk("rda_wifi gpio%d success low  ##############################\n",PIN_WIFI_CHIP_ENABLE);
	}
}
EXPORT_SYMBOL(rda_wifi_enable);
#endif

#if defined (CONFIG_ESP8089)||defined(CONFIG_ESP8089_MODULE)
int esp_wifi_init(void)
{	
	int ret = 0;
	ret = gpio_request(PIN_WIFI_PWR_CTL,"wifi_pwr_ctl");	
	if(ret < 0)	
	{        
		printk("request wifi pwr ctl gpio failed, maybe lcd used.\n");     
		gpio_free(PIN_WIFI_PWR_CTL); 
		return 0;
	}
	
	ret = gpio_request(PIN_WIFI_CHIP_ENABLE,"wifi_chip_enable");	
	if(ret < 0)	
	{        
		printk("request wifi enable gpio failed\n");     
		gpio_free(PIN_WIFI_CHIP_ENABLE);    
	}
	return ret;
}
EXPORT_SYMBOL(esp_wifi_init);

void esp_wifi_deinit(void)
{	
	gpio_free(PIN_WIFI_CHIP_ENABLE);    
}
EXPORT_SYMBOL(esp_wifi_deinit);

void esp_wifi_enable(int bval)
{	
	zx29_gpio_config(PIN_WIFI_PWR_CTL, PIN_WIFI_PWR_CTL_SEL);
	if(bval)	
	{	
		gpio_direction_output(PIN_WIFI_PWR_CTL, GPIO_HIGH);	
		printk("esp_wifi gpio%d success high, pwr on ##############################\n",PIN_WIFI_PWR_CTL);
	}	

	zx29_gpio_config(PIN_WIFI_CHIP_ENABLE, PIN_WIFI_CHIP_ENABLE_SEL);
	if(bval)	
	{	
		gpio_direction_output(PIN_WIFI_CHIP_ENABLE, GPIO_LOW);
		printk("esp_wifi gpio%d success low, chip enable ##############################\n",PIN_WIFI_CHIP_ENABLE);
	}	
	else	
	{	
		gpio_direction_output(PIN_WIFI_CHIP_ENABLE, GPIO_HIGH);	
		printk("esp_wifi gpio%d success high, chip disable  ##############################\n",PIN_WIFI_CHIP_ENABLE);
	}
}
EXPORT_SYMBOL(esp_wifi_enable);
#endif

#if defined (CONFIG_XR_WLAN)
int xr_wifi_init(void)
{	
	int ret = 0;
#if 0
	ret = gpio_request(PIN_WIFI_PWR_CTL,"wifi_pwr_ctl");	
	if(ret < 0)	
	{        
		printk("request wifi pwr ctl gpio failed, maybe lcd used.\n");     
		gpio_free(PIN_WIFI_PWR_CTL); 
		return 0;
	}
#endif
	ret = gpio_request(ZX29_GPIO_123, "wlan_reset");	
	if(ret < 0)	
	{        
		printk("request wifi reset gpio failed\n");     
		gpio_free(ZX29_GPIO_123);    
	}
	return ret;
}
EXPORT_SYMBOL(xr_wifi_init);

void xr_wifi_deinit(void)
{	
	gpio_free(ZX29_GPIO_123);    
	//io_free(PIN_WIFI_PWR_CTL);
}
EXPORT_SYMBOL(xr_wifi_deinit);

void xr_wifi_enable(int bval)
{	
	//29_gpio_config(PIN_WIFI_PWR_CTL, PIN_WIFI_PWR_CTL_SEL);
#if 0
	if(bval)	
	{	
		gpio_direction_output(PIN_WIFI_PWR_CTL, GPIO_HIGH);	
		printk("xr_wifi gpio%d success high, pwr on ##############################\n",PIN_WIFI_PWR_CTL);
	}
	else
	{
		gpio_direction_output(PIN_WIFI_PWR_CTL, GPIO_LOW);
		printk("xr_wifi gpio%d success low, pwr down ##############################\n",PIN_WIFI_PWR_CTL);
	}
#endif

	zx29_gpio_config(ZX29_GPIO_123, GPIO123_GPIO123);
	zx29_gpio_pd_pu_set(ZX29_GPIO_123,0);
	if(bval)	
	{	
		gpio_direction_output(ZX29_GPIO_123, 0);
		mdelay(50);
		gpio_direction_output(ZX29_GPIO_123, 1);
		mdelay(2);
		gpio_direction_output(ZX29_GPIO_123, 0);
		mdelay(50);
		//gpio_direction_output(PIN_WIFI_CHIP_ENABLE, GPIO_LOW);
		printk("xr_wifi gpio%d success reset, chip enable ##############################\n",ZX29_GPIO_123);
	}	
	else	
	{	
		gpio_direction_output(ZX29_GPIO_123, 1);	
		printk("xr_wifi gpio%d chip disable  ##############################\n",ZX29_GPIO_123);
	}
	
}
EXPORT_SYMBOL(xr_wifi_enable);
#endif

#if defined (CONFIG_SSV6X5X)

void ssv6x5x_wifi_enable(int bval)
{	
	if(bval)	
	{	
	   gpio_direction_output(PIN_WIFI_CHIP_ENABLE, 0);
	   mdelay(10);
	   gpio_direction_output(PIN_WIFI_CHIP_ENABLE, 1);
	   printk("wifi enable gpio success low%d\n",PIN_WIFI_CHIP_ENABLE);
	}	
	else	
	{	
		gpio_direction_output(PIN_WIFI_CHIP_ENABLE, 0);	
		printk("ssv6x5x_wifi gpio%d chip disable  ##############################\n",PIN_WIFI_CHIP_ENABLE);
	}
	
}
EXPORT_SYMBOL(ssv6x5x_wifi_enable);
#endif

#if (defined CONFIG_AIC8800 || defined CONFIG_AIC8800D80L)

void aic8800_wifi_enable(int bval)
{	
	// zw.wang The WiFi-related control pins gpio132 and gpio91 are still affected after the uboot removes mmc0 on 20241031 on start
	if (get_wifi_enable() != 1)
		return;
	// zw.wang The WiFi-related control pins gpio132 and gpio91 are still affected after the uboot removes mmc0 on 20241031 on end
	int ret = 0;
	if(bval)	
	{	
		if (get_wifi_enable() == 1)
			sd_io_config(0, 1);
#ifdef CONFIG_AIC8800_MIFI_EN
	   ret=gpio_request(ZX29_GPIO_85,"aic_mifi_en");
	   if(ret){
	       printk("request aic_mifi_en gpio failed\n"); 
	       gpio_free(ZX29_GPIO_85); 	
	   }    
	   ret=gpio_request(ZX29_GPIO_130,"aic_mifi_power_en");
	   if(ret){
		   printk("request aic_mifi_power_en gpio failed\n"); 
	       gpio_free(ZX29_GPIO_130); 
	   }
	   gpio_direction_output(ZX29_GPIO_85, 1);
	   gpio_direction_output(ZX29_GPIO_130, 1);
#else
	#ifdef _USE_VEHICLE_DC_REF
		ret=gpio_request(ZX29_GPIO_132,"aic_vehicle_en");
	   if(ret){
	       printk("request aic_vehicle_en gpio failed\n"); 
	       gpio_free(ZX29_GPIO_132); 	
	   }    
	   ret=gpio_request(ZX29_GPIO_91,"aic_vehicle_power_en");
	   if(ret){
		   printk("request aic_vehicle_power_en gpio failed\n"); 
	       gpio_free(ZX29_GPIO_91); 
	   }

	   // zw.wang The WiFi-related control pins gpio132 and gpio91 are still affected after the uboot removes mmc0 on 20240531 on start
	   if (get_wifi_enable() == 1)
	   {
		   gpio_direction_output(ZX29_GPIO_132, 1);
		   gpio_direction_output(ZX29_GPIO_91, 1);
	   }
	   // zw.wang The WiFi-related control pins gpio132 and gpio91 are still affected after the uboot removes mmc0 on 20240531 on end
#else
	   ret=gpio_request(ZX29_GPIO_123,"aic_ufi_en");
	   if(ret){
	       printk("request aic_ufi_en gpio failed\n"); 
	       gpio_free(ZX29_GPIO_123); 	
	   }    
	   ret=gpio_request(ZX29_GPIO_129,"aic_ufi_power_en");
	   if(ret){
		   printk("request aic_ufi_power_en gpio failed\n"); 
	       gpio_free(ZX29_GPIO_129); 
	   }
	   gpio_direction_output(ZX29_GPIO_123, 1);
	   gpio_direction_output(ZX29_GPIO_129, 1);
	#endif
#endif
	   mdelay(10);
	   printk("qqq aic en succ.\n");
	}	
	else	
	{	
		if (get_wifi_enable() == 1)
			sd_io_config(0, 0);
#ifdef CONFIG_AIC8800_MIFI_EN
		gpio_direction_output(ZX29_GPIO_85, 0);	
		gpio_direction_output(ZX29_GPIO_130, 0);
#else
	#ifdef _USE_VEHICLE_DC_REF
		gpio_direction_output(ZX29_GPIO_132, 0);	
		gpio_direction_output(ZX29_GPIO_91, 0);
	#else
		gpio_direction_output(ZX29_GPIO_123, 0);	
		gpio_direction_output(ZX29_GPIO_129, 0);
	#endif
#endif
		printk("qqq aic en fail.\n");
	}
	
}
EXPORT_SYMBOL(aic8800_wifi_enable);
#endif
#if (defined CONFIG_AIC8800 || defined CONFIG_AIC8800D80L)
void aic8800_wifi_disable(int bval)
{	
	// zw.wang The WiFi-related control pins gpio132 and gpio91 are still affected after the uboot removes mmc0 on 20241031 on start
	if (get_wifi_enable() != 1)
		return;
	// zw.wang The WiFi-related control pins gpio132 and gpio91 are still affected after the uboot removes mmc0 on 20241031 on end
	int ret = 0;
	if(bval)	
	{	
		if (get_wifi_enable() == 1)
			sd_io_config(0, 0);
#ifdef CONFIG_AIC8800_MIFI_EN
	   gpio_direction_output(ZX29_GPIO_85, 0);
	   gpio_direction_output(ZX29_GPIO_130, 0);
#else
	#ifdef _USE_VEHICLE_DC_REF
		gpio_direction_output(ZX29_GPIO_132, 0);	
		gpio_direction_output(ZX29_GPIO_91, 0);
	#else
	   gpio_direction_output(ZX29_GPIO_123, 0);
	   gpio_direction_output(ZX29_GPIO_129, 0);
	#endif
#endif
	   mdelay(50);
	   printk("qqq aic dis succ.\n");
	}	
	else	
	{		
		if (get_wifi_enable() == 1)
			sd_io_config(0, 1);
#ifdef CONFIG_AIC8800_MIFI_EN
		gpio_direction_output(ZX29_GPIO_85, 1);
		gpio_direction_output(ZX29_GPIO_130, 1);
#else
	#ifdef _USE_VEHICLE_DC_REF
		gpio_direction_output(ZX29_GPIO_132, 1);	
		gpio_direction_output(ZX29_GPIO_91, 1);
	#else
		gpio_direction_output(ZX29_GPIO_123, 1);	
		gpio_direction_output(ZX29_GPIO_129, 1);
	#endif
#endif
		printk("qqq aic dis fail.\n");
	}
}
EXPORT_SYMBOL(aic8800_wifi_disable);
#endif
#if (defined CONFIG_AIC8800 || defined CONFIG_AIC8800D80L)
void aic8800_wifi_re_enable(int bval)
{	
	int ret = 0;
	if(bval)	
	{	
		if (get_wifi_enable() == 1)
			sd_io_config(0, 1);
#ifdef CONFIG_AIC8800_MIFI_EN
	   gpio_direction_output(ZX29_GPIO_85, 1);
	   gpio_direction_output(ZX29_GPIO_130, 1);
#else
	#ifdef _USE_VEHICLE_DC_REF
		gpio_direction_output(ZX29_GPIO_132, 1);	
		gpio_direction_output(ZX29_GPIO_91, 1);
	#else
	   gpio_direction_output(ZX29_GPIO_129, 1);
	   gpio_direction_output(ZX29_GPIO_123, 1);   
	#endif
#endif
	   mdelay(50);
	   printk("qqq re enable succ.\n");
	}	
	else	
	{	
		if (get_wifi_enable() == 1)
			sd_io_config(0, 0);
#ifdef CONFIG_AIC8800_MIFI_EN
	   gpio_direction_output(ZX29_GPIO_85, 0);
	   gpio_direction_output(ZX29_GPIO_130, 0);
#else
	#ifdef _USE_VEHICLE_DC_REF
		gpio_direction_output(ZX29_GPIO_132, 0);	
		gpio_direction_output(ZX29_GPIO_91, 0);
	#else
		gpio_direction_output(ZX29_GPIO_123, 0);	
		gpio_direction_output(ZX29_GPIO_129, 0);
	#endif
#endif
		printk("qqq aic dis fail.\n");
	}
}
EXPORT_SYMBOL(aic8800_wifi_re_enable);
#endif

#ifdef CONFIG_RTL8192CD
//hess add, called by 8192cd_pwrctrl.c
unsigned int Get_WiFi_Wakeup_Pin_Num()
{
    //return ZX29_GPIO_57;
    return PIN_WIFI_WAKEUP;
}

int Get_WiFi_Wakeup_Pin_INT()
{
    //return PCU_EX7_INT;
    return INT_WIFI_WAKEUP;
}

#endif


