/*
 *  zx-pm-context.h - cpu sleep context save&restore interface for power management.
 *
 *  Written by zxp.
 *
 */

#ifndef _ZX_PM_CONTEXT_H
#define _ZX_PM_CONTEXT_H

#define CPU_SAVE_PMU                   	(1U << 0)
#define CPU_SAVE_TIMERS                	(1U << 1)
#define CPU_SAVE_VFP                   	(1U << 2)
#define CPU_SAVE_DEBUG                 	(1U << 3)
#define CPU_SAVE_GIC                   	(1U << 4)
#define CPU_SAVE_OTHER        		   	(1U << 5)

#define CPU_SAVE_GLOBAL_TIMER          	(1U << 16)
#define CPU_SAVE_L2           		   	(1U << 17)
#define CPU_SAVE_L2_RAM                	(1U << 18)
#define CPU_SAVE_SCU           		   	(1U << 19)
#define CPU_SAVE_CRM           		   	(1U << 20)

#define SCU_ADDRESS					   	A9_PERIPHERAL_VA 			//(0x00800000)
#define SCU_ADDRESS_P				   	A9_PERIPHERAL_BASE
#define	IC_INTERFACE_OFFSET			   	(0x100)
#define	GLOBAL_TIMER_OFFSET			   	(0x200)
#define	PRIVATE_TWD_OFFSET			   	(0x600)
#define	IC_DISTRIBUTOR_OFFSET		   	(0x1000)
#define	L2_CONTROLLER_ADDRESS          	L2CACHE_CONFIG_VA			//(0x00C00000)
#define	L2_CONTROLLER_ADDRESS_P		   	L2CACHE_CONFIG_BASE	
#define	A9_CRM_ADDRESS          	   	(A9_PERIPHERAL_VA+0x3000)	//(0x00803000)
#define	A9_CRM_ADDRESS_P          	   	A9_CRPM_BASE

#define	GIC_DIST_SET_PENDING			(SCU_ADDRESS+IC_DISTRIBUTOR_OFFSET+0x200)
#define	GIC_CPU_HIGHPRI_PENDING			(SCU_ADDRESS+IC_INTERFACE_OFFSET+0x18)

#define LP1_MG_SAVE_FLAG 			   (CPU_SAVE_GIC|/*CPU_SAVE_GLOBAL_TIMER|*/CPU_SAVE_L2|CPU_SAVE_L2_RAM|CPU_SAVE_SCU|CPU_SAVE_CRM)
#define LP1_CPU_SAVE_FLAG 			   (CPU_SAVE_PMU|CPU_SAVE_TIMERS|/*CPU_SAVE_VFP|*//*CPU_SAVE_DEBUG|*/CPU_SAVE_GIC|CPU_SAVE_OTHER)
#define LP2_MG_SAVE_FLAG 			   (CPU_SAVE_GIC|/*CPU_SAVE_GLOBAL_TIMER|*/CPU_SAVE_L2|CPU_SAVE_L2_RAM|CPU_SAVE_SCU|CPU_SAVE_CRM)
#define LP2_CPU0_SAVE_FLAG 			   (CPU_SAVE_PMU|/*CPU_SAVE_TIMERS|CPU_SAVE_VFP|*//*CPU_SAVE_DEBUG|*/CPU_SAVE_GIC|CPU_SAVE_OTHER)
#define LP2_CPUX_SAVE_FLAG 			   (CPU_SAVE_PMU|/*CPU_SAVE_TIMERS|CPU_SAVE_VFP|*//*CPU_SAVE_DEBUG|*/CPU_SAVE_GIC|CPU_SAVE_OTHER)
#define MG_SAVE_FLAG_NULL 			   (0)

/* Maximum size of each item of context, in bytes */
#define PMU_DATA_SIZE                  (128)
#define TIMER_DATA_SIZE                (128)
#define VFP_DATA_SIZE                  (288)
#define GIC_INTERFACE_DATA_SIZE        (64)
#define GIC_DIST_PRIVATE_DATA_SIZE     (96)
#define BANKED_REGISTERS_SIZE          (128)
#define CP15_DATA_SIZE                 (64)
#define DEBUG_DATA_SIZE                (352)
#define MMU_DATA_SIZE                  (64)
#define OTHER_DATA_SIZE                (32)
#define CONTROL_DATA_SIZE              (64)

#define GIC_DIST_SHARED_DATA_SIZE      (2592)
#define SCU_DATA_SIZE                  (32)
#define L2_DATA_SIZE                   (96)
#define GLOBAL_TIMER_DATA_SIZE         (128)
#define CRM_DATA_SIZE                  (136)

#define PM_MEMORY_SIZE                 (8192)
#define MAX_CPU_NUM                    (1)      /* for ZX297510,  ZX297550- (4) */
#define SHADOW_RAM_SIZE                (1024)

struct zx_cluster_context 
{
	u32 flags;                   		/*before save context, set this flag*/
	u32 saved_items;             		/*after save a context, set a flag for restore*/
	u32 *gic_dist_shared_data;
	u32 *l2_data;
	u32 *scu_data;
	u32 *global_timer_data;
	u32 *crm_data;
	cpu_power_mode_t  power_state;    	/*dormant or shutdown*/ 
};

struct zx_cpu_context 
{
	u32 flags;                   		/*before save context, set this flag*/
	u32 saved_items;             		/*after save a context, set a flag for restore*/
	u32 *control_data;
	u32 *pmu_data;
	u32 *timer_data;
	u32 *vfp_data;
	u32 *gic_interface_data;
	u32 *gic_dist_private_data;
	u32 *banked_registers;
	u32 *cp15_data;
	u32 *debug_data;
	u32 *mmu_data;
	u32 *other_data;
	cpu_power_mode_t  power_state;    	/*dormant or shutdown*/  
	cpu_sleep_type_t  sleep_type;     	/*hotplug or idle or suspend*/
};


struct zx_pm_main_table 
{
	u32  ddr_ram_addr;                	/*the iram:0 shadow ram*/
	u32  ddr_ram_size;
	u32  reset_code_addr;             	/*the addr jumped from addr_0*/
	u32  num_cpus; 
	u32  cur_cpu; 
    u32  scu_address;             	 	/*  0 => no SCU                             */
    u32  scu_address_p;
    u32  ic_dist_address;             	/*  0 => no Interrupt Controller            */
	u32  ic_interface_address;	
    u32  l2_address;              	  	/*  0 => no L2CC     	                    */
    u32  l2_address_p;
    u32  crm_address;              	  	
    u32  crm_address_p;              	  		
	struct zx_cluster_context* cluster_context;   
	struct zx_cpu_context* cpu_context[MAX_CPU_NUM];
};



extern int zx_pm_context_init(void);
extern int zx_set_context_level (cpu_sleep_type_t sleep_type);
extern void zx_pm_save_context(void);
extern void zx_pm_restore_context(void);
extern void zx_pm_restore_abort_context(void);
extern void pm_init_l2_and_scu(void);

#endif /*_ZX_PM_CONTEXT_H*/
