/*********************************************************************
 Copyright 2007 by  ZTE Corporation.
 *
 * FileName::    hal_spinlock.c
 * File Mark:
* Description:   ĵʵzx297510˷ʹ
*			ԴĻ⣬ںͬʱ
*			ͬһ衣
* Others:
* Version:  	v.10
* Author:  	chenjianguo
* Date:  	2013-5-31

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/

/**************************************************************************
 *                                                      Include files                                	    *
 **************************************************************************/
#include <linux/kernel.h>
#include <mach/iomap.h>
#include <mach/debug.h>
#include <linux/io.h>
#include <mach/spinlock.h>
#include <mach/rpmsg.h>
#include <linux/mutex.h>

/**************************************************************************
 *                                                      Macro                                    	            *
 **************************************************************************/
 #ifndef MACH_NR_SFLOCKS
#define MACH_NR_SFLOCKS		32
#endif

#ifndef MACH_NR_HWLOCKS
#define MACH_NR_HWLOCKS		4
#endif

/*zx7510*/
#define TOP_SYS_REG_BASE	ZX29_TOP_VA
#define PCU_REG_BASE	(TOP_SYS_REG_BASE + 0x600)
#define SHARED_DEVICE1_REG	 (PCU_REG_BASE + 0xa8)
#define SHARED_DEVICE2_REG	 (PCU_REG_BASE + 0xac)
#define SHARED_DEVICE3_REG	 (PCU_REG_BASE + 0xb0)
#define SHARED_DEVICE4_REG	 (PCU_REG_BASE + 0xb4)
#define SOFTLOCK_HWLOCK	3
#define REGLOCK_HWLOCK	2
#define SOFTLOCK_DESC_BASE	(ZX29_IRAM02_VA + (SOFTLOCK_BASE-ZX297510_SRAM02_BASE))

#define reg32(addr)			(*(volatile unsigned long*)(addr))

#define SPINLOCK_DEBUG

#ifdef SPINLOCK_DEBUG
#define zspinlock_debug(fmt, ...) \
	printk(KERN_INFO fmt, ##__VA_ARGS__)
#else
#define zspinlock_debug(fmt, ...)	
#endif

#define zspinlock_assert(_EXP) ZDRV_ASSERT(_EXP)
static DEFINE_MUTEX(zspinlock_mutex);
static unsigned long s_hwSpinlockMsr;
/****************************************************************************
* 	                                        Types
****************************************************************************/
struct zte_softlock_desc {
	unsigned long	used;
	unsigned long	owner;
};
/**************************************************************************
 *                                                Global Variables                                    *
 **************************************************************************/
 static struct zte_softlock_desc *softlock_desc[MACH_NR_SFLOCKS];

static const void __iomem __force *hwlock_regs[MACH_NR_HWLOCKS] = 
{
	SHARED_DEVICE1_REG,
	SHARED_DEVICE2_REG,
	SHARED_DEVICE3_REG,	
	SHARED_DEVICE4_REG
};

#define CORE_ID_UFI 212
#define SELF_CORE_ID CORE_ID_UFI
extern void msleep(unsigned int msecs);

/****************************************************************************
* 	                                Local Function Prototype                                           *
****************************************************************************/


/**************************************************************************
 *                                              Function Definitions                                       *
 **************************************************************************/
 /*******************************************************************************
 * Function: _hw_spin_lock
 * Description:ȡӲid 0~3
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 static void  _hw_spin_lock(unsigned long hwid)
{  
   unsigned long tmp;
   unsigned long msr; 
   local_irq_save(msr);
   s_hwSpinlockMsr = msr;
   
   while(ioread32(hwlock_regs[hwid])&0x1);
   tmp = ioread32(hwlock_regs[hwid]);
   tmp &= 0x00ffffff;
   tmp |= (SELF_CORE_ID&0xff)<<24;
   iowrite32(tmp, hwlock_regs[hwid]);
   
}
/*******************************************************************************
 * Function: _hw_spin_unlock
 * Description:ͷӲid 0~3
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void  _hw_spin_unlock(unsigned long hwid)
{  
   unsigned long tmp;	

   
   	if(SELF_CORE_ID != (ioread32(hwlock_regs[hwid])&0xff000000)>>24){
		zspinlock_assert(0);
   	}		
  	 tmp = ioread32(hwlock_regs[hwid]);
	 tmp &= 0x00fffffe;
	 iowrite32(tmp, hwlock_regs[hwid]);
	 
	 local_irq_restore(s_hwSpinlockMsr);
}
/*******************************************************************************
 * Function: hw_spin_lock
 * Description:ȡӲid 0~2
 *			id 3ʹãⲿá
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  hw_spin_lock(emhw_lock_id hwid)
{  
   _hw_spin_lock(hwid);
   zspinlock_debug("cpu %d gets %d hardware lock!/n",SELF_CORE_ID,hwid);
}
/*******************************************************************************
 * Function: hw_spin_unlock
 * Description:ͷӲid 0~2
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  hw_spin_unlock(emhw_lock_id hwid)
{  
   _hw_spin_unlock(hwid);
   zspinlock_debug("cpu %d releases %d hardware lock!/n",SELF_CORE_ID,hwid);
}
/*******************************************************************************
 * Function: soft_spin_lock
 * Description:ӿ
 * Parameters:
 *   Input:	sfid: id
 *			coreid: idΪsfidcpuid
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  soft_spin_lock(emsf_lock_id sfid)
{  
	static unsigned long lock_count = 0;
softlock_loop:
   while(softlock_desc[sfid]->owner != SELF_CORE_ID && softlock_desc[sfid]->used)
   	{
   		lock_count++;
		if(lock_count == 1000)
		{
			lock_count = 0;
			msleep(5);
		}
   	}
   _hw_spin_lock(SOFTLOCK_HWLOCK);
   if(softlock_desc[sfid]->owner != SELF_CORE_ID && softlock_desc[sfid]->used)
   	{
	      _hw_spin_unlock(SOFTLOCK_HWLOCK);
		goto softlock_loop;
   	}
    softlock_desc[sfid]->used ++;
    softlock_desc[sfid]->owner = SELF_CORE_ID;
    _hw_spin_unlock(SOFTLOCK_HWLOCK);
    //zspinlock_debug("cpu %d releases %d software lock!/n",SELF_CORE_ID,sfid);
	
}
/*******************************************************************************
 * Function: soft_spin_unlock
 * Description:soft_spin_lockӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  soft_spin_unlock(emsf_lock_id sfid)
{  	
    if(softlock_desc[sfid]->used){
		
	if(SELF_CORE_ID != softlock_desc[sfid]->owner){
		zspinlock_assert(0);
	}
	_hw_spin_lock(SOFTLOCK_HWLOCK);
   	softlock_desc[sfid]->used --;
	if(softlock_desc[sfid]->used == 0) {
   			softlock_desc[sfid]->owner = 0x0;
		}
   	_hw_spin_unlock(SOFTLOCK_HWLOCK); 
	//zspinlock_debug("cpu %d releases %d software lock!/n",SELF_CORE_ID,sfid);
   }
}
#if 0
 /*******************************************************************************
 * Function: _hw_spin_lockPsm
 * Description:ȡӲid 0~3
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 static void  _hw_spin_lockPsm(unsigned long hwid)
{  
   unsigned long tmp;

   while(reg32(hwlock_regs[hwid])&0x1);
   tmp = reg32(hwlock_regs[hwid]);
   tmp &= 0x00ffffff;
   tmp |= (SELF_CORE_ID&0xffUL)<<24;
   reg32(hwlock_regs[hwid]) = tmp;
   
}
/*******************************************************************************
 * Function: _hw_spin_unlockPsm
 * Description:ͷӲid 0~3
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static void  _hw_spin_unlockPsm(unsigned long hwid)
{  
   	if(SELF_CORE_ID != (reg32(hwlock_regs[hwid])&0xff000000UL)>>24)
	{
		zspinlock_assert(0);
   	}
  	reg32(hwlock_regs[hwid]) &= 0x00fffffe;

}
 #endif
/*******************************************************************************
 * Function: soft_spin_lock_Psm
 * Description:ӿ(ʡר)
 * Parameters:
 *   Input:	sfid: id
 *			coreid: idΪsfidcpuid
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  soft_spin_lock_Psm(emsf_lock_id sfid)
{  

softlock_loop:
   while(softlock_desc[sfid]->owner != SELF_CORE_ID && softlock_desc[sfid]->used)
   	{

   	}
   _hw_spin_lock(SOFTLOCK_HWLOCK);
   if(softlock_desc[sfid]->owner != SELF_CORE_ID && softlock_desc[sfid]->used)
   	{
	    _hw_spin_unlock(SOFTLOCK_HWLOCK);
		goto softlock_loop;
   	}
    softlock_desc[sfid]->used ++;
    softlock_desc[sfid]->owner = SELF_CORE_ID;
    _hw_spin_unlock(SOFTLOCK_HWLOCK);
    //zspinlock_debug("cpu %d releases %d software lock!/n",SELF_CORE_ID,sfid);
	
}
/*******************************************************************************
 * Function: zDrvSysSpinlock_SoftUnlock
 * Description:zDrvSysSpinlock_SoftLockӦͷӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  soft_spin_unlock_Psm(emsf_lock_id sfid)
{  	
    if(softlock_desc[sfid]->used){
		
	if(SELF_CORE_ID != softlock_desc[sfid]->owner){
		zspinlock_assert(0);
	}
	_hw_spin_lock(SOFTLOCK_HWLOCK);
   	softlock_desc[sfid]->used --;
	if(softlock_desc[sfid]->used == 0) {
   			softlock_desc[sfid]->owner = 0x0;
		}
   	_hw_spin_unlock(SOFTLOCK_HWLOCK); 
	//zspinlock_debug("cpu %d releases %d software lock!/n",SELF_CORE_ID,sfid);
   }
}

/*******************************************************************************
 * Function: reg_spin_lock
 * Description:üĴӿ
 * Parameters:
 *   Input:	
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  reg_spin_lock(void)
{  
    
   _hw_spin_lock(REGLOCK_HWLOCK);
    softlock_desc[REG_SFLOCK]->owner = SELF_CORE_ID;
    
	
}
/*******************************************************************************
 * Function: reg_spin_unlock
 * Description:reg_spin_lockӦͷżĴӿڡ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 void  reg_spin_unlock(void)
{  	
    softlock_desc[REG_SFLOCK]->owner = 0x0;
	_hw_spin_unlock(REGLOCK_HWLOCK);

}

/*******************************************************************************
 * Function: softspinlock_init
 * Description:ʼ
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
 int softspinlock_init(void)
{  	
    int i;
	
    for(i = 0; i<MACH_NR_SFLOCKS; i++){
    	softlock_desc[i] = 
			(struct zte_softlock_desc *)(SOFTLOCK_DESC_BASE +i*sizeof(struct zte_softlock_desc));
		//softlock_desc[i]->used = 0;
		//softlock_desc[i]->owner= CORE_ID_NUM;
    }
	zspinlock_debug("softspinlock init success base=0x%x!",(int)SOFTLOCK_DESC_BASE);
	return 0;
}

//arch_initcall(softspinlock_init);

