/*
 * ZTE CPU low power powerdown and powerup code.
 *
 * Copyright (C) 2013 ZTE, Inc.
 * Written by ZXP
 *
 */
#include <linux/linkage.h>
#include <linux/threads.h>
#include <asm/asm-offsets.h>
#include <asm/assembler.h>
#include <asm/glue-cache.h>
#include <asm/glue-proc.h>
	 
#include <asm/memory.h>

/* =======================================================================
 * The wakeup code will jump to this code in ddr-mem.
 * This code will build C environment for resume code. 
 *
 * =======================================================================*/
        .global cpu_reset_handler 
cpu_reset_handler:

	bl	invalidate_icache_v7		/* Clear I cache */

	bl	invalidate_dcache_v7_all	/* Clear all data cache levels visible to CPU */

	b   	cpu_resume



/* =======================================================================
 * Because IRAM may power down, M0 will copy this code to IRAM(address 0) 
 * after CPU_AP is waked up. 
 *
 * So this code will run in IRAM.
 * =======================================================================*/
        .global cpu_wake_up
cpu_wake_up:
	nop					/* add 16 nops */
	nop
	nop
	nop
	nop
	nop
	nop
	nop
	nop	
	nop
	nop
	nop
	nop
	nop	
	nop
	nop	

	movw	r3, #0xC02C			/* enable ddr clk */
	movt	r3, #0x0010	
	ldr   	r2, [r3]
	
	movw	r1, #0x0000
	movt	r1, #0x0008			/* ddr port3 */
	orr   	r2, r2, r1
	str   	r2, [r3]
	
	ldr  r2, =1000				/* cpu_reset_handler */
	ldr  r5, [r2]		
	bx   r5  				/* call cpu_reset_handler */

/* =======================================================================
 * 
 * disable ddr port3.
 * addr assigned 0x200
 * =======================================================================*/
	.global do_sleep_cpu
	.global zx_jump_addr
do_sleep_cpu:
	movw	r3, #0xC02C			/* disable ddr clk */
	movt	r3, #0xF880	
	ldr   	r2, [r3]
	
	movw	r1, #0x0000
	movt	r1, #0x0008			/* ddr port3 */
	bic   	r2, r2, r1
	str   	r2, [r3]

	isb
	dsb
	wfi	

	movw	r3, #0xC02C			/* enable ddr clk */
	movt	r3, #0xF880	
	ldr   	r2, [r3]
	
	movw	r1, #0x0000
	movt	r1, #0x0008			/* ddr port3 */
	orr   	r2, r2, r1
	str   	r2, [r3]
	
	bx 	lr

zx_jump_addr:
	mov 	pc, r0

wake_up_buf:			.space 1024


