/*
 * ZTE CPU low power powerdown and powerup helper code.
 *
 * Copyright (C) 2013 ZTE, Inc.
 * Written by ZXP
 *
 * This program is free software,you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#include <linux/linkage.h>
#include <linux/threads.h>
#include <asm/asm-offsets.h>
#include <asm/assembler.h>
#include <asm/glue-cache.h>
#include <asm/glue-proc.h>

        
#define	MIDR_CPU_MASK		0xff00fff0
#define	MMU_DISABLE_MASK	0x10001807   	/* clear TRE, I Z C M */


#define	SCTLR_I 			(1<<12)
#define	SCTLR_Z 			(1<<11)
#define	SCTLR_C 			(1<<2)

/**
 * This function takes three arguments
 * r0: Destination start address (must be word aligned)
 * r1: Source start address (must be word aligned)
 * r2: Number of words to copy
 * Return value is updated destination pointer (first unwritten word)
 */	
ENTRY(copy_words)
	cmp	r2, #0
	beq	copy_end
loop_copy:
	ldr	r3, [r1], #4
	str	r3, [r0], #4
	subs	r2, r2, #1
	bne	loop_copy
copy_end:
	bx	lr
ENDPROC(copy_words)

/* ; Note: assumes conversion will be successful! */
ENTRY(va_to_pa)	
	mov	r1, r0
	mcr	p15, 0, r0, c7, c8, 1	/* Priv Write Current World VA-PA */
	mrc	p15, 0, r0, c7, c4, 0	/* Get PA */
    bfc	r0, #0, #12				/* We want top bits of translated addr */
    bfc	r1, #12, #20			/* plus bottom bits of input addr */
    orr	r0, r0, r1
    bx	lr
ENDPROC(va_to_pa) 


ENTRY(read_sctlr)
	mrc	p15, 0, r0, c1, c0, 0
	bx	lr
ENDPROC(read_sctlr)


ENTRY(write_sctlr)
	mcr	p15, 0, r0, c1, c0, 0
	isb
	bx	lr
ENDPROC(write_sctlr)

ENTRY(read_drar)
	mrc p14, 0, r0, c1, c0, 0	/* Read Debug ROM Address Register */
	bx	lr
ENDPROC(read_drar)


ENTRY(read_dsar)
	mrc p14, 0, r0, c2, c0, 0	/* Read Debug Self Address Offset Register */
	bx	lr
ENDPROC(read_dsar)



ENTRY(write_osdlr)
	mcr p14, 0, r0, c1, c3, 4	/* Write OS Double Lock Register */
	bx	lr
ENDPROC(write_osdlr)



ENTRY(disable_mmu)
	mrc	p15, 0, r3, c1, c0, 0
	ldr	r2, =MMU_DISABLE_MASK
	bic	r3, r3, r2
	dsb
	mcr	p15, 0, r3, c1, c0, 0
	isb
	bx	lr
ENDPROC(disable_mmu)	

ENTRY(read_cpuid)
	mrc	p15, 0, r0, c0, c0, 5	/* Read MPIDR */
	and	r0, r0, #0xff			/* extract CPU number */
	bx  lr
ENDPROC(read_cpuid)


ENTRY(enable_cache)
	mrc	p15, 0, r0, c1, c0, 0
	movw r1, #SCTLR_I | SCTLR_Z | SCTLR_C
	orr	r0, r0, r1
	mcr	p15, 0, r0, c1, c0, 0
	bx 	lr
ENDPROC(enable_cache)


ENTRY(exit_coherency)
	isb
	dsb
	mrc p15,0,r0,c1,c0,1
	bic r0,r0,#0x00000040
	mcr p15,0,r0,c1,c0,1
	isb
	dsb
	bx	lr
ENDPROC(exit_coherency)


ENTRY(join_coherency)
	isb
	dsb
    mrc p15,0,r0,c1,c0,1
    orr r0,r0,#0x00000040
    mcr p15,0,r0,c1,c0,1
	isb
	dsb
	bx	lr
ENDPROC(join_coherency)

