/*
 * arch/arm/mach-zx297520v2/include/mach/board.h
 *
 *  Copyright (C) 2013 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */



#ifndef __ASM_ARCH_BOARD_H
#define __ASM_ARCH_BOARD_H

#include <linux/version.h>
#include <linux/init.h>

#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
#define	NEW_LINUX_FRAME		1
#else
#define	NEW_LINUX_FRAME		0
#endif

struct zx29_reg_conf
{
	void __iomem *	reg_addr;
    unsigned char 	reg_bit_offset;
    unsigned char 	reg_bit_size;
};

extern struct kobject *zx_test_kobj;

/*********************************************************************
 **           io operation interface                                **
 *********************************************************************
 */
#define zx_reg_sync_write(v, a) \
        do {    \
            iowrite32(v, a);    \
        } while (0)

#define zx_read_reg(addr) \
    ioread32(addr)

#define zx_write_reg(addr, val)   \
	zx_reg_sync_write(val, addr)

#define zx_set_reg(addr, val) \
    zx_reg_sync_write(zx_read_reg(addr) | (val), addr)

#define zx_clr_reg(addr, val) \
    zx_reg_sync_write(zx_read_reg(addr) & ~(val), addr)

#define zx_reg_sync_write_16(v, a) \
        do {    \
            iowrite16(v, a);    \
        } while (0)

#define zx_read_reg_16(addr) \
    ioread16(addr)

#define zx_write_reg_16(addr, val)   \
	zx_reg_sync_write_16(val, addr)

void zx_write_bits(void __iomem *reg_addr, unsigned char offset, unsigned char width, unsigned long value);
#define zx_wrie_bit(addr, offset, val)      	\
	zx_write_bits(addr, offset, 1, val)

extern struct platform_device *zx29_device_table[];
extern unsigned int zx29_device_table_num;

void __init zx29_map_io(void);
void __init zx29_clock_init(void);
void __init zx29_timer_init(void);
void zx29_restart(char str, const char *cmd);
void __init i2c_add_devices(void);
#endif
