/*
 * arch/arm/mach-zx297520v2/include/mach/gpio.h
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 *
 */

#ifndef __ASM_ARCH_ARM_GPIO_H
#define __ASM_ARCH_ARM_GPIO_H

#include <mach/board.h>
#include <mach/gpio-names.h>

#define ARCH_NR_GPIOS  					(ZX29_GPIO_MAX + 1)
#define BASE_GPIO      					(ZX29_GPIO_0)
#define NGPIO        					(ARCH_NR_GPIOS - BASE_GPIO)

#define GPIOPDD_REG0(gpio)   			(ZX_GPIO0_BASE + ((gpio>>4) * 16) * 4)
#define RECV_REG0(gpio)   	  			(ZX_GPIO0_BASE + ((gpio>>4) * 16 + 5) * 4)
#define SET1_SEND_REG0(gpio) 			(ZX_GPIO0_BASE + ((gpio>>4) * 16 + 6) * 4)
#define SET0_SEND_REG0(gpio) 			(ZX_GPIO0_BASE + ((gpio>>4) * 16 + 7) * 4)
#define SEND_REG0(gpio) 			    (ZX_GPIO0_BASE + ((gpio>>4) * 16 + 8) * 4)

#define GPIOPDD_REG1(gpio)   			(ZX_GPIO1_BASE + ((gpio>>4) * 16) * 4)
#define RECV_REG1(gpio)   	  			(ZX_GPIO1_BASE + ((gpio>>4) * 16 + 5) * 4)
#define SET1_SEND_REG1(gpio) 			(ZX_GPIO1_BASE + ((gpio>>4) * 16 + 6) * 4)
#define SET0_SEND_REG1(gpio) 			(ZX_GPIO1_BASE + ((gpio>>4) * 16 + 7) * 4)
#define SEND_REG1(gpio) 			    (ZX_GPIO1_BASE + ((gpio>>4) * 16 + 8) * 4)

enum
{
	GPIO_IN  = 0,
	GPIO_OUT = 1
};

enum
{
	GPIO_LOW  = 0,
	GPIO_HIGH = 1
};

/******************************************
 **0--pe(1-pull enable)   1--ps (0-PD 1-PU)
 ******************************************/
enum 	/*IO_CFG*/
{
	IO_CFG_PULL_DISABLE = 0,	/*00/10*/
	IO_CFG_PULL_DOWN  	= 1,	/*01*/
	IO_CFG_PULL_UP  	= 3,	/*11*/
};

enum
{
	PIN_FUNC_SEL_AON  	= 0,
	PIN_FUNC_SEL_PD 	= 1,
};


struct zx29_pin_info
{
	char *					pin_name;
	unsigned int 			gpio;
	struct zx29_reg_conf    top_func_sel_reg;	/*0--aon func  1--pd func*/
	struct zx29_reg_conf    aon_func_sel_reg;
	struct zx29_reg_conf    pd_func_sel_reg;
	struct zx29_reg_conf    io_cfg_reg;
};

#define GPIO_UFI_RESETKEY				ZX29_GPIO_13
#define GPIO_POWER_ON_INT				ZX29_GPIO_14
#define GPIO_UFI_WPS					ZX29_GPIO_17
#define GPIO_WIFI_HOST_WAKE				ZX29_GPIO_16
#define GPIO_CHARGER_PG					ZX29_GPIO_11

struct zx29_gpio_platform_data
{
    int ufi_resetkey;
    int power_on_int;
    int ufi_wps;
    int wifi_host_wake;
    int charger_pg;
};

typedef enum
{
    /*[31:24]:gpio_id   [23:12]:level1_sel   [11:0]:level2_sel*/
    GPIO0_GPIO0              = 0x00000000,
    GPIO0_NAND_WE            = 0x00001000,
    GPIO1_GPIO1              = 0x01000000,
    GPIO1_NAND_CS0           = 0x01001000,
    GPIO2_GPIO2              = 0x02000000,
    GPIO2_NAND_READY         = 0x02001000,
    GPIO3_GPIO3              = 0x03000000,
    GPIO3_NAND_CLE           = 0x03001000,
    GPIO3_SPIFC0_SCLK        = 0x03001001,
    GPIO4_GPIO4              = 0x04000000,
    GPIO4_NAND_ALE           = 0x04001000,
    GPIO5_GPIO5              = 0x05000000,
    GPIO5_NAND_RE            = 0x05001000,
    GPIO5_SPIFC0_CS          = 0x05001001,
    GPIO6_GPIO6              = 0x06000000,
    GPIO6_NAND_WRITE_PROTECT = 0x06001000,
    GPIO7_GPIO7              = 0x07000000,
    GPIO7_NAND_DATA0         = 0x07001000,
    GPIO7_SSP1_CS            = 0x07001001,
    GPIO8_GPIO8              = 0x08000000,
    GPIO8_NAND_DATA1         = 0x08001000,
    GPIO8_SSP1_CLK           = 0x08001001,
    GPIO9_GPIO9              = 0x09000000,
    GPIO9_NAND_DATA2         = 0x09001000,
    GPIO9_SPIFC0_DATA0       = 0x09001001,
    GPIO10_GPIO10            = 0x0A000000,
    GPIO10_NAND_DATA3        = 0x0A001000,
    GPIO10_SPIFC0_DATA1      = 0x0A001001,
    GPIO11_GPIO11            = 0x0B000000,
    GPIO11_NAND_DATA4        = 0x0B001000,
    GPIO11_SPIFC0_DATA2      = 0x0B001001,
    GPIO12_GPIO12            = 0x0C000000,
    GPIO12_NAND_DATA5        = 0x0C001000,
    GPIO12_SPIFC0_DATA3      = 0x0C001001,
    GPIO13_GPIO13            = 0x0D000000,
    GPIO13_NAND_DATA6        = 0x0D001000,
    GPIO13_SSP1_RXD          = 0x0D001001,
    GPIO14_GPIO14            = 0x0E000000,
    GPIO14_NAND_DATA7        = 0x0E001000,
    GPIO14_SSP1_TXD          = 0x0E001001,
    GPIO23_CLK_OUT0          = 0x17000000,
    GPIO23_GPIO23            = 0x17000001,
    GPIO24_GPIO24            = 0x18000000,
    GPIO24_CLK_OUT1          = 0x18000001,
    GPIO25_GPIO25            = 0x19000000,
    GPIO25_CLK_OUT2          = 0x19000001,
    GPIO25_TEST_CLK_OUT      = 0x19000002,
    GPIO26_GPIO26            = 0x1A000000,
    GPIO26_CLK_32K_OUT       = 0x1A000001,
    GPIO27_CLK_REQ0          = 0x1B000000,
    GPIO27_GPIO27            = 0x1B000001,
    GPIO29_PWRCTRL1          = 0x1D000000,
    GPIO29_GPIO29            = 0x1D000001,
    GPIO30_GPIO30            = 0x1E000000,
    GPIO30_SSP0_CS           = 0x1E001000,
    GPIO31_GPIO31            = 0x1F000000,
    GPIO31_SSP0_CLK          = 0x1F001000,
    GPIO32_GPIO32            = 0x20000000,
    GPIO32_SSP0_RXD          = 0x20001000,
    GPIO33_GPIO33            = 0x21000000,
    GPIO33_SSP0_TXD          = 0x21001000,
    GPIO34_UART0_RXD         = 0x22000000,
    GPIO34_GPIO34            = 0x22000001,
    GPIO34_UART0_TXD         = 0x22000002,
    GPIO34_FRAME_SYNC        = 0x22001000,
    GPIO34_TEST_PIN10        = 0x22001001,
    GPIO35_UART0_TXD         = 0x23000000,
    GPIO35_GPIO35            = 0x23000001,
    GPIO35_UART0_RXD         = 0x23000002,
    GPIO35_LTE_PRE_TX        = 0x23001000,
    GPIO35_TEST_PIN11        = 0x23001001,
    GPIO36_UART0_CTS         = 0x24000000,
    GPIO36_GPIO36            = 0x24000001,
    GPIO36_UART1_RXD         = 0x24001000,
    GPIO36_LTE_TPU_OUT3      = 0x24001001,
    GPIO36_TEST_PIN12        = 0x24001002,
    GPIO36_UART1_TXD         = 0x24001003,
    GPIO37_UART0_RTS         = 0x25000000,
    GPIO37_GPIO37            = 0x25000001,
    GPIO37_UART1_TXD         = 0x25001000,
    GPIO37_LTE_TPU_OUT4      = 0x25001001,
    GPIO37_UART1_RXD         = 0x25001002,
    GPIO38_GPIO38            = 0x26000000,
    GPIO38_I2S0_WS           = 0x26001000,
    GPIO38_TEST_PIN0         = 0x26001001,
    GPIO38_LTE_DATA_DONGLE_CLK  = 0x26001002,
    GPIO38_TDM_FS            = 0x26001003,
    GPIO39_GPIO39            = 0x27000000,
    GPIO39_I2S0_CLK          = 0x27001000,
    GPIO39_TEST_PIN1         = 0x27001001,
    GPIO39_LTE_DATA_DONGLE_CMD  = 0x27001002,
    GPIO39_TDM_CLK           = 0x27001003,
    GPIO40_GPIO40            = 0x28000000,
    GPIO40_I2S0_DIN          = 0x28001000,
    GPIO40_TEST_PIN2         = 0x28001001,
    GPIO40_LTE_DATA_DONGLE0  = 0x28001002,
    GPIO40_TDM_DATA_IN       = 0x28001003,
    GPIO41_GPIO41            = 0x29000000,
    GPIO41_I2S0_DOUT         = 0x29001000,
    GPIO41_TEST_PIN3         = 0x29001001,
    GPIO41_LTE_DATA_DONGLE1  = 0x29001002,
    GPIO41_TDM_DATA_OUT      = 0x29001003,
    GPIO42_GPIO42            = 0x2A000000,
    GPIO42_I2S1_WS           = 0x2A001000,
    GPIO42_TEST_PIN4         = 0x2A001001,
    GPIO42_LTE_DATA_DONGLE2  = 0x2A001002,
    GPIO42_TDM_FS            = 0x2A001003,
    GPIO43_GPIO43            = 0x2B000000,
    GPIO43_I2S1_CLK          = 0x2B001000,
    GPIO43_TEST_PIN5         = 0x2B001001,
    GPIO43_LTE_DATA_DONGLE3  = 0x2B001002,
    GPIO43_TDM_CLK           = 0x2B001003,
    GPIO44_GPIO44            = 0x2C000000,
    GPIO44_I2S1_DIN          = 0x2C001000,
    GPIO44_TEST_PIN6         = 0x2C001001,
    GPIO44_TDM_DATA_IN       = 0x2C001002,
    GPIO45_GPIO45            = 0x2D000000,
    GPIO45_I2S1_DOUT         = 0x2D001000,
    GPIO45_TEST_PIN7         = 0x2D001001,
    GPIO45_TDM_DATA_OUT      = 0x2D001002,
    GPIO46_SCL0              = 0x2E000000,
    GPIO46_GPIO46            = 0x2E000001,
    GPIO47_SDA0              = 0x2F000000,
    GPIO47_GPIO47            = 0x2F000001,
    GPIO48_GPIO48            = 0x30000000,
    GPIO48_SCL1              = 0x30001000,
    GPIO49_GPIO49            = 0x31000000,
    GPIO49_SDA1              = 0x31001000,
    GPIO50_GPIO50            = 0x32000000,
    GPIO50_EXT_INT0          = 0x32000001,
    GPIO51_GPIO51            = 0x33000000,
    GPIO51_EXT_INT1          = 0x33000001,
    GPIO52_GPIO52            = 0x34000000,
    GPIO52_EXT_INT2          = 0x34000001,
    GPIO53_GPIO53            = 0x35000000,
    GPIO53_EXT_INT3          = 0x35000001,
    GPIO53_TEST_PIN8         = 0x35001000,
    GPIO54_GPIO54            = 0x36000000,
    GPIO54_EXT_INT4          = 0x36000001,
    GPIO54_TEST_PIN9         = 0x36001000,
    GPIO55_GPIO55            = 0x37000000,
    GPIO55_EXT_INT5          = 0x37000001,
    GPIO55_TEST_PIN13        = 0x37001000,
    GPIO56_GPIO56            = 0x38000000,
    GPIO56_EXT_INT6          = 0x38000001,
    GPIO56_CLK_REQ1          = 0x38000002,
    GPIO56_TEST_PIN14        = 0x38001000,
    GPIO57_GPIO57            = 0x39000000,
    GPIO57_EXT_INT7          = 0x39000001,
    GPIO57_TEST_PIN15        = 0x39001000,
    GPIO58_GPIO58            = 0x3A000000,
    GPIO58_SD1_HOST_SDCLK    = 0x3A001000,
    GPIO59_GPIO59            = 0x3B000000,
    GPIO59_M_JTAG_TDO        = 0x3B000001,
    GPIO59_SD1_CMD           = 0x3B001000,
    GPIO59_PS_JTAG_TDO       = 0x3B001001,
    GPIO59_PHY_JTAG_TDO      = 0x3B001002,
    GPIO59_AP_JTAG_TDO       = 0x3B001003,
    GPIO60_GPIO60            = 0x3C000000,
    GPIO60_M_JTAG_TCK        = 0x3C000001,
    GPIO60_SD1_DATA0         = 0x3C001000,
    GPIO60_PS_JTAG_TCK       = 0x3C001001,
    GPIO60_PHY_JTAG_TCK      = 0x3C001002,
    GPIO60_AP_JTAG_TCK       = 0x3C001003,
    GPIO61_GPIO61            = 0x3D000000,
    GPIO61_M_JTAG_TRST       = 0x3D000001,
    GPIO61_SD1_DATA1         = 0x3D001000,
    GPIO61_PS_JTAG_TRST      = 0x3D001001,
    GPIO61_PHY_JTAG_TRST     = 0x3D001002,
    GPIO61_AP_JTAG_TRST      = 0x3D001003,
    GPIO62_GPIO62            = 0x3E000000,
    GPIO62_M_JTAG_TMS        = 0x3E000001,
    GPIO62_SD1_DATA2         = 0x3E001000,
    GPIO62_PS_JTAG_TMS       = 0x3E001001,
    GPIO62_PHY_JTAG_TMS      = 0x3E001002,
    GPIO62_AP_JTAG_TMS       = 0x3E001003,
    GPIO63_GPIO63            = 0x3F000000,
    GPIO63_M_JTAG_TDI        = 0x3F000001,
    GPIO63_SD1_DATA2         = 0x3F001000,
    GPIO63_PS_JTAG_TDI       = 0x3F001001,
    GPIO63_PHY_JTAG_TDI      = 0x3F001002,
    GPIO63_AP_JTAG_TDI       = 0x3F001003,
    GPIO64_M_JTAG_TCK        = 0x40000000,
    GPIO64_GPIO64            = 0x40000001,
    GPIO64_PS_JTAG_TCK       = 0x40001000,
    GPIO64_PHY_JTAG_TCK      = 0x40001001,
    GPIO64_AP_JTAG_TCK       = 0x40001002,
    GPIO66_M_JTAG_TDI        = 0x42000000,
    GPIO66_GPIO66            = 0x42000001,
    GPIO66_PS_JTAG_TDI       = 0x42001000,
    GPIO66_PHY_JTAG_TDI      = 0x42001001,
    GPIO66_AP_JTAG_TDI       = 0x42001002,
    GPIO67_M_JTAG_TDO        = 0x43000000,
    GPIO67_GPIO67            = 0x43000001,
    GPIO67_PS_JTAG_TDO       = 0x43001000,
    GPIO67_PHY_JTAG_TDO      = 0x43001001,
    GPIO67_AP_JTAG_TDO       = 0x43001002,
    GPIO68_M_JTAG_TMS        = 0x44000000,
    GPIO68_GPIO68            = 0x44000001,
    GPIO68_PS_JTAG_TMS       = 0x44001000,
    GPIO68_PHY_JTAG_TMS      = 0x44001001,
    GPIO68_AP_JTAG_TMS       = 0x44001002,
    GPIO69_M_JTAG_TRST       = 0x45000000,
    GPIO69_GPIO69            = 0x45000001,
    GPIO69_PS_JTAG_TRST      = 0x45001000,
    GPIO69_PHY_JTAG_TRST     = 0x45001001,
    GPIO69_AP_JTAG_TRST      = 0x45001002,
    GPIO70_KEY_COL0          = 0x46000000,
    GPIO70_GPIO70            = 0x46000001,
    GPIO70_EXT_INT8          = 0x46000002,
    GPIO70_M_JTAG_TDO        = 0x46000003,
    GPIO70_PS_JTAG_TDO       = 0x46001000,
    GPIO70_PHY_JTAG_TDO      = 0x46001001,
    GPIO70_AP_JTAG_TDO       = 0x46001002,
    GPIO70_LTE_DATA_DONGLE4  = 0x46001003,
    GPIO71_KEY_COL1          = 0x47000000,
    GPIO71_GPIO71            = 0x47000001,
    GPIO71_EXT_INT9          = 0x47000002,
    GPIO71_LTE_DATA_DONGLE5  = 0x47001000,
    GPIO72_KEY_COL2          = 0x48000000,
    GPIO72_GPIO72            = 0x48000001,
    GPIO72_EXT_INT10         = 0x48000002,
    GPIO72_M_JTAG_TCK        = 0x48000003,
    GPIO72_PS_JTAG_TCK       = 0x48001000,
    GPIO72_PHY_JTAG_TCK      = 0x48001001,
    GPIO72_AP_JTAG_TCK       = 0x48001002,
    GPIO72_LTE_DATA_DONGLE6  = 0x48001003,
    GPIO73_KEY_COL3          = 0x49000000,
    GPIO73_GPIO73            = 0x49000001,
    GPIO73_EXT_INT11         = 0x49000002,
    GPIO73_LTE_DATA_DONGLE7  = 0x49001000,
    GPIO74_KEY_ROW0          = 0x4A000000,
    GPIO74_GPIO74            = 0x4A000001,
    GPIO74_EXT_INT12         = 0x4A000002,
    GPIO74_M_JTAG_TRST       = 0x4A000003,
    GPIO74_PS_JTAG_TRST      = 0x4A001000,
    GPIO74_PHY_JTAG_TRST     = 0x4A001001,
    GPIO74_AP_JTAG_TRST      = 0x4A001002,
    GPIO74_LTE_DATA_DONGLE8  = 0x4A001003,
    GPIO75_KEY_ROW1          = 0x4B000000,
    GPIO75_GPIO75            = 0x4B000001,
    GPIO75_EXT_INT13         = 0x4B000002,
    GPIO75_M_JTAG_TMS        = 0x4B000003,
    GPIO75_PS_JTAG_TMS       = 0x4B001000,
    GPIO75_PHY_JTAG_TMS      = 0x4B001001,
    GPIO75_AP_JTAG_TMS       = 0x4B001002,
    GPIO75_LTE_DATA_DONGLE9  = 0x4B001003,
    GPIO76_KEY_ROW2          = 0x4C000000,
    GPIO76_GPIO76            = 0x4C000001,
    GPIO76_EXT_INT14         = 0x4C000002,
    GPIO76_M_JTAG_TDI        = 0x4C000003,
    GPIO76_PS_JTAG_TDI       = 0x4C001000,
    GPIO76_PHY_JTAG_TDI      = 0x4C001001,
    GPIO76_AP_JTAG_TDI       = 0x4C001002,
    GPIO76_UART2_RXD         = 0x4C001003,
    GPIO77_KEY_ROW3          = 0x4D000000,
    GPIO77_GPIO77            = 0x4D000001,
    GPIO77_EXT_INT15         = 0x4D000002,
    GPIO77_UART2_TXD         = 0x4D001000,
    GPIO78_GPIO78            = 0x4E000000,
    GPIO78_MODEM_TXRX_DATA0  = 0x4E001000,
    GPIO79_GPIO79            = 0x4F000000,
    GPIO79_MODEM_TXRX_DATA1  = 0x4F001000,
    GPIO80_GPIO80            = 0x50000000,
    GPIO80_MODEM_TXRX_DATA2  = 0x50001000,
    GPIO81_GPIO81            = 0x51000000,
    GPIO81_MODEM_TXRX_DATA3  = 0x51001000,
    GPIO82_GPIO82            = 0x52000000,
    GPIO82_MODEM_TXRX_DATA4  = 0x52001000,
    GPIO83_GPIO83            = 0x53000000,
    GPIO83_MODEM_TXRX_DATA5  = 0x53001000,
    GPIO84_GPIO84            = 0x54000000,
    GPIO84_MODEM_TXRX_DATA6  = 0x54001000,
    GPIO85_GPIO85            = 0x55000000,
    GPIO85_MODEM_TXRX_DATA7  = 0x55001000,
    GPIO86_GPIO86            = 0x56000000,
    GPIO86_MODEM_TXRX_DATA8  = 0x56001000,
    GPIO87_GPIO87            = 0x57000000,
    GPIO87_MODEM_TXRX_DATA9  = 0x57001000,
    GPIO88_GPIO88            = 0x58000000,
    GPIO88_MODEM_TXRX_DATA10 = 0x58001000,
    GPIO89_GPIO89            = 0x59000000,
    GPIO89_MODEM_TXRX_DATA11 = 0x59001000,
    GPIO90_GPIO90            = 0x5A000000,
    GPIO90_MODEM_RX_DATA0    = 0x5A001000,
    GPIO91_GPIO91            = 0x5B000000,
    GPIO91_MODEM_RX_DATA1    = 0x5B001000,
    GPIO92_GPIO92            = 0x5C000000,
    GPIO92_MODEM_RX_DATA2    = 0x5C001000,
    GPIO93_GPIO93            = 0x5D000000,
    GPIO93_MODEM_RX_DATA3    = 0x5D001000,
    GPIO94_GPIO94            = 0x5E000000,
    GPIO94_MODEM_RX_DATA4    = 0x5E001000,
    GPIO95_GPIO95            = 0x5F000000,
    GPIO95_MODEM_RX_DATA5    = 0x5F001000,
    GPIO96_GPIO96            = 0x60000000,
    GPIO96_MODEM_RX_DATA6    = 0x60001000,
    GPIO97_GPIO97            = 0x61000000,
    GPIO97_MODEM_RX_DATA7    = 0x61001000,
    GPIO98_GPIO98            = 0x62000000,
    GPIO98_MODEM_RX_DATA8    = 0x62001000,
    GPIO99_GPIO99            = 0x63000000,
    GPIO99_MODEM_RX_DATA9    = 0x63001000,
    GPIO100_GPIO100          = 0x64000000,
    GPIO100_MODEM_RX_DATA10  = 0x64001000,
    GPIO101_GPIO101          = 0x65000000,
    GPIO101_MODEM_RX_DATA11  = 0x65001000,
    GPIO102_GPIO102          = 0x66000000,
    GPIO102_MODEM_FCLK_O     = 0x66001000,
    GPIO103_GPIO103          = 0x67000000,
    GPIO103_MODEM_FRAME_TX_O = 0x67001000,
    GPIO104_GPIO104          = 0x68000000,
    GPIO104_MODEM_FRAME_RX_I = 0x68001000,
    GPIO105_GPIO105          = 0x69000000,
    GPIO105_MODEM_MCLK_I     = 0x69001000,
    GPIO106_GPIO106          = 0x6A000000,
    GPIO106_LTE_REF_CLK      = 0x6A001000,
    /*GPIO107  GPIO108*/
    GPIO109_GPIO109          = 0x6D000000,
    GPIO110_GPIO110          = 0x6E000000,
    GPIO110_GSM_OUT_OLD_O_12 = 0x6E000001,
    GPIO111_PWRCTRL2         = 0x6F000000,
    GPIO111_GPIO111          = 0x6F000001,
    GPIO112_GPIO112          = 0x70000000,
    GPIO112_RF_SPI0_STR0     = 0x70001000,
    GPIO113_GPIO113          = 0x71000000,
    GPIO113_RF_SPI0_STR1     = 0x71001000,
    GPIO114_GPIO114          = 0x72000000,
    GPIO114_RF_SPI0_CLK      = 0x72001000,
    GPIO115_GPIO115          = 0x73000000,
    GPIO115_RF_SPI0_DIN      = 0x73001000,
    GPIO116_GPIO116          = 0x74000000,
    GPIO116_RF_SPI0_DATA     = 0x74001000,
    GPIO117_GPIO117          = 0x75000000,
    GPIO117_RF_SPI1_STR0     = 0x75001000,
    GPIO118_GPIO118          = 0x76000000,
    GPIO118_RF_SPI1_CLK      = 0x76001000,
    GPIO119_GPIO119          = 0x77000000,
    GPIO119_RF_SPI1_DIN      = 0x77001000,
    GPIO120_GPIO120          = 0x78000000,
    GPIO120_RF_SPI1_DATA     = 0x78001000,
    /*GPIO121 --GPIO144*/
    GPIO145_GPIO145          = 0x91000000,
    GPIO145_RMII_TXEN        = 0x91001000,
    GPIO146_GPIO146          = 0x92000000,
    GPIO146_RMII_RXEN        = 0x92001000,
    GPIO147_GPIO147          = 0x93000000,
    GPIO147_RMII_RXD0        = 0x93001000,
    GPIO148_GPIO148          = 0x94000000,
    GPIO148_RMII_RXD1        = 0x94001000,
    GPIO149_GPIO149          = 0x95000000,
    GPIO149_RMII_TXD0        = 0x95001000,
    GPIO150_GPIO150          = 0x96000000,
    GPIO150_RMII_TXD1        = 0x96001000,
    GPIO151_GPIO151          = 0x97000000,
    GPIO151_MDC_SCLK         = 0x97001000,
    GPIO152_GPIO152          = 0x98000000,
    GPIO152_MDC_SDIO         = 0x98001000,
    GPIO153_GPIO153          = 0x99000000,
    GPIO153_PHY_RST          = 0x99001000,
    GPIO154_GPIO154          = 0x9A000000,
    GPIO154_RMII_CLK_O       = 0x9A001000,
    GPIO155_GPIO155          = 0x9B000000,
    GPIO155_RMII_CLK_I       = 0x9B001000,

}gpio_func_id;

int zx29_gpio_function_sel(unsigned int gpio, gpio_func_id func );
void zx29_gpio_set_direction(unsigned int gpio, unsigned int value);
void zx29_gpio_output_data(unsigned int gpio, unsigned int value);
unsigned int zx29_gpio_input_data(unsigned int gpio);
int zx29_gpio_function_sel_get(unsigned int gpio);
unsigned int zx29_gpio_outputdata_get(unsigned int gpio);
unsigned int zx29_gpio_get_direction(unsigned int gpio);
void zx29_gpio_pd_enable(unsigned int gpio);
void zx29_gpio_pd_disable(unsigned int gpio);
void zx29_gpio_pu_enable(unsigned int gpio);
void zx29_gpio_pu_disable(unsigned int gpio);

int zx29_gpio2irq(unsigned int gpio);

int zx29_gpio_config(unsigned int gpio, gpio_func_id func );
void zx29_gpio_set_inttype(unsigned int gpio, unsigned int type);

void jtag_config(unsigned int jtag_num, unsigned int function);
void zx29_gpio_pd_pu_set(unsigned int gpio, unsigned int config);

#endif
