/*
 * arch/arm/mach-zx297520v2/include/mach/gpio_def.h
 *
 * Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <mach/iomap.h>
#include <mach/gpio.h>

/* config 0 for saving ram, for some pin no need config here forerver  */
#define	NAND_MAY_USED_AS_GPIO			1
#define	I2C0_MAY_USED_AS_GPIO			1
#define	I2C1_MAY_USED_AS_GPIO			1
#define	SPI0_MAY_USED_AS_GPIO			1
#define	SPI1_MAY_USED_AS_GPIO			1
#define	I2S0_MAY_USED_AS_GPIO			1
#define	I2S1_MAY_USED_AS_GPIO			1
#define	SD1_MAY_USED_AS_GPIO			1
#define	JTAG_MAY_USED_AS_GPIO			1
#define	RF_SPI0_MAY_USED_AS_GPIO		0
#define	RF_SPI1_MAY_USED_AS_GPIO		0
#define	RF_CTRL_MAY_USED_AS_GPIO		0

#define	TOP_FUNC_SEL_BASE		(ZX_PAD_CTRL_BASE)
#define	AON_FUNC_SEL_BASE		(ZX_PAD_CTRL_BASE)
#define	PD_FUNC_SEL_BASE		(ZX_PIN_MUX_BASE)
#define	IO_CFG_BASE				(ZX_PAD_CTRL_BASE+0x800)

static struct zx29_pin_info pin_info[] = 
{
#if NAND_MAY_USED_AS_GPIO
	{
		.pin_name			= "nand_we", 
	 	.gpio				= ZX29_GPIO_0, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 0, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE, 0, 2},
	},	
	{
		.pin_name			= "nand_csn", 
	 	.gpio				= ZX29_GPIO_1, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 1, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE, 2, 2},
	},	
	{
		.pin_name			= "nand_ready", 
	 	.gpio				= ZX29_GPIO_2, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 2, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE, 4, 2},
	},
	{
		.pin_name			= "nand_cle", 
	 	.gpio				= ZX29_GPIO_3, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 3, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE, 0, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 6, 2},
	},
	{
		.pin_name			= "nand_ale", 
	 	.gpio				= ZX29_GPIO_4, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 4, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE, 8, 2},
	},	
	{
		.pin_name			= "nand_re", 
	 	.gpio				= ZX29_GPIO_5, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 5, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE, 2, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 10, 2},
	},	
	{
		.pin_name			= "nand_wp", 
	 	.gpio				= ZX29_GPIO_6, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 6, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE, 12, 2},
	},		
	{
		.pin_name			= "nand_data_0", 
	 	.gpio				= ZX29_GPIO_7, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 7, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 0, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 14, 2},
	},		
	{
		.pin_name			= "nand_data_1", 
	 	.gpio				= ZX29_GPIO_8, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 8, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 2, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE, 16, 2},
	},	
	{
		.pin_name			= "nand_data_2", 
	 	.gpio				= ZX29_GPIO_9, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 9, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE, 4, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 18, 2},
	},
	{
		.pin_name			= "nand_data_3", 
	 	.gpio				= ZX29_GPIO_10, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 10, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE, 6, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 20, 2},
	},
	{
		.pin_name			= "nand_data_4", 
	 	.gpio				= ZX29_GPIO_11, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 11, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE, 8, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 22, 2},
	},		
	{
		.pin_name			= "nand_data_5", 
	 	.gpio				= ZX29_GPIO_12, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 12, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE, 10, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 24, 2},
	},	
	{
		.pin_name			= "nand_data_6", 
	 	.gpio				= ZX29_GPIO_13, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 13, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 4, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE, 26, 2},
	},	
	{
		.pin_name			= "nand_data_7", 
	 	.gpio				= ZX29_GPIO_14, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 14, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 6, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE, 28, 2},
	},	
#if 0	/* removed in 7520v2 */
	{
		.pin_name			= "nand_data_8", 
	 	.gpio				= ZX29_GPIO_15, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 15, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE, 30, 2},
	},	
	{
		.pin_name			= "nand_data_9", 
	 	.gpio				= ZX29_GPIO_16, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 16, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 0, 2},
	},	
	{
		.pin_name			= "nand_data_10", 
	 	.gpio				= ZX29_GPIO_17, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 17, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 2, 2},
	},	
	{
		.pin_name			= "nand_data_11", 
	 	.gpio				= ZX29_GPIO_18, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 18, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 4, 2},
	},	
	{
		.pin_name			= "nand_data_12", 
	 	.gpio				= ZX29_GPIO_19, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 19, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 0, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 6, 2},
	},		
	{
		.pin_name			= "nand_data_13", 
	 	.gpio				= ZX29_GPIO_20, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 20, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 2, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 8, 2},
	},
	{
		.pin_name			= "nand_data_14", 
	 	.gpio				= ZX29_GPIO_21, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 21, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 4, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 10, 2},
	},
	{
		.pin_name			= "nand_data_15", 
	 	.gpio				= ZX29_GPIO_22, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 22, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 6, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 12, 2},
	},
#endif	
#endif	
	{
		.pin_name			= "clk_out0", 
	 	.gpio				= ZX29_GPIO_23, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 0, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 4, 2},
	},
	{
		.pin_name			= "clk_out1", 
	 	.gpio				= ZX29_GPIO_24, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 2, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 6, 2},
	},
	{
		.pin_name			= "clk_out2", 
	 	.gpio				= ZX29_GPIO_25, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 4, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 8, 2},
	},
	{
		.pin_name			= "clk_32k_out", 
	 	.gpio				= ZX29_GPIO_26, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 6, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 10, 2},
	},
	{
		.pin_name			= "clk_request0", 
	 	.gpio				= ZX29_GPIO_27, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 8, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 12, 2},
	},
#if 0  /* removed in 7520v2 */	
	{
		.pin_name			= "clk_request1", 
	 	.gpio				= ZX29_GPIO_28, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 10, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x4, 14, 2},
	},
#endif	
	{
		.pin_name			= "pwrctrl1", 
	 	.gpio				= ZX29_GPIO_29, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 12, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 0, 2},
	},		
#if SPI0_MAY_USED_AS_GPIO	
	{
		.pin_name			= "ssp0_cs", 
	 	.gpio				= ZX29_GPIO_30, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 15, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 2, 2},
	},	
	{
		.pin_name			= "ssp0_clk", 
	 	.gpio				= ZX29_GPIO_31, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 16, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 4, 2},
	},	
	{
		.pin_name			= "ssp0_rxd", 
	 	.gpio				= ZX29_GPIO_32, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 17, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 6, 2},
	},	
	{
		.pin_name			= "ssp0_txd", 
	 	.gpio				= ZX29_GPIO_33, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 18, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 8, 2},
	},	
#endif	
	{
		.pin_name			= "uart0_rxd", 
	 	.gpio				= ZX29_GPIO_34, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 19, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 0, 2},	 	
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 12, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 14, 2},
	},
	{
		.pin_name			= "uart0_txd", 
	 	.gpio				= ZX29_GPIO_35, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 20, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 2, 2},	 	
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 14, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 16, 2},
	},	
	{
		.pin_name			= "uart0_cts", 
	 	.gpio				= ZX29_GPIO_36, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x10, 21, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 4, 2},	 	
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 16, 2},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 18, 2},
	},
	{
		.pin_name			= "uart0_rts", 
	 	.gpio				= ZX29_GPIO_37, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 0, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 6, 2},	 	
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE, 18, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 20, 2},
	},		
#if I2S0_MAY_USED_AS_GPIO	
	{
		.pin_name			= "i2s0_ws", 
	 	.gpio				= ZX29_GPIO_38, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 1, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 8, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 22, 2},
	},	
	{
		.pin_name			= "i2s0_clk", 
	 	.gpio				= ZX29_GPIO_39, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 2, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 10, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 24, 2},
	},	
	{
		.pin_name			= "i2s0_datain", 
	 	.gpio				= ZX29_GPIO_40, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 3, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 12, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 26, 2},
	},	
	{
		.pin_name			= "i2s0_dataout", 
	 	.gpio				= ZX29_GPIO_41, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 4, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 14, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 28, 2},
	},	
#endif
#if I2S1_MAY_USED_AS_GPIO
	{
		.pin_name			= "i2s1_ws", 
	 	.gpio				= ZX29_GPIO_42, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 5, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 16, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x8, 30, 2},
	},	
	{
		.pin_name			= "i2s1_clk", 
	 	.gpio				= ZX29_GPIO_43, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 6, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 18, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 0, 2},
	},	
	{
		.pin_name			= "i2s1_datain", 
	 	.gpio				= ZX29_GPIO_44, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 7, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 20, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 2, 2},
	},	
	{
		.pin_name			= "i2s1_dataout", 
	 	.gpio				= ZX29_GPIO_45, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 8, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x4, 22, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 4, 2},
	},	
#endif
#if I2C0_MAY_USED_AS_GPIO
	{
		.pin_name			= "scl0", 
	 	.gpio				= ZX29_GPIO_46, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 0, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 6, 2},
	},	
	{
		.pin_name			= "sda0", 
	 	.gpio				= ZX29_GPIO_47, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 2, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 8, 2},
	},
#endif	
#if I2C1_MAY_USED_AS_GPIO
	{
		.pin_name			= "scl1", 
	 	.gpio				= ZX29_GPIO_48, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 9, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 10, 2},
	},	
	{
		.pin_name			= "sda1", 
	 	.gpio				= ZX29_GPIO_49, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 10, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 12, 2},
	},	
#endif	
	{
		.pin_name			= "ext_int0", 
	 	.gpio				= ZX29_GPIO_50, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 11, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 4, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 14, 2},
	},	
	{
		.pin_name			= "ext_int1", 
	 	.gpio				= ZX29_GPIO_51, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 12, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 6, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 16, 2},
	},	
	{
		.pin_name			= "ext_int2", 
	 	.gpio				= ZX29_GPIO_52, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 13, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 8, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 18, 2},
	},	
	{
		.pin_name			= "ext_int3", 
	 	.gpio				= ZX29_GPIO_53, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 14, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 10, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 20, 2},
	},	
	{
		.pin_name			= "ext_int4", 
	 	.gpio				= ZX29_GPIO_54, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 15, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 12, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 22, 2},
	},	
	{
		.pin_name			= "ext_int5", 
	 	.gpio				= ZX29_GPIO_55, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 16, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 14, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 24, 2},
	},	
	{
		.pin_name			= "ext_int6", 
	 	.gpio				= ZX29_GPIO_56, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 17, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 16, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 26, 2},
	},	
	{
		.pin_name			= "ext_int7", 
	 	.gpio				= ZX29_GPIO_57, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 18, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 18, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0xC, 28, 2},
	},	
#if SD1_MAY_USED_AS_GPIO
	{
		.pin_name			= "sd1_clk", 
	 	.gpio				= ZX29_GPIO_58, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 19, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x10, 0, 8},
	},	
	{
		.pin_name			= "sd1_cmd", 
	 	.gpio				= ZX29_GPIO_59, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 20, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 8, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 20, 2},	 	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x10, 8, 8},
	},	
	{
		.pin_name			= "sd1_data0", 
	 	.gpio				= ZX29_GPIO_60, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 21, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 10, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 22, 2},	 	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x10, 16, 8},
	},	
	{
		.pin_name			= "sd1_data1", 
	 	.gpio				= ZX29_GPIO_61, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 22, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 12, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 24, 2},	 	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x10, 24, 8},
	},
	{
		.pin_name			= "sd1_data2", 
	 	.gpio				= ZX29_GPIO_62, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 23, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 14, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 26, 2},	 	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x14, 0, 8},
	},		
	{
		.pin_name			= "sd1_data3", 
	 	.gpio				= ZX29_GPIO_63, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 24, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x8, 16, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x4, 28, 2},	 	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x14, 8, 8},
	},
#endif
#if JTAG_MAY_USED_AS_GPIO
	{
		.pin_name			= "jtag_tck", 
	 	.gpio				= ZX29_GPIO_64, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 25, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0xC, 0, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x8, 0, 2},	 	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 0, 2},
	},		
#if 0	/* removed in 7520v2 */	
	{
		.pin_name			= "jtag_rtck", 
	 	.gpio				= ZX29_GPIO_65, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 26, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 2, 2},
	},	
#endif	
	{
		.pin_name			= "jtag_tdi", 
	 	.gpio				= ZX29_GPIO_66, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 26, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0xC, 2, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x8, 2, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 2, 2},
	},	
	{
		.pin_name			= "jtag_tdo", 
	 	.gpio				= ZX29_GPIO_67, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 27, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0xC, 4, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x8, 4, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 4, 2},
	},	
	{
		.pin_name			= "jtag_tms", 
	 	.gpio				= ZX29_GPIO_68, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 28, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0xC, 6, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x8, 6, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 6, 2},
	},	
	{
		.pin_name			= "jtag_trst", 
	 	.gpio				= ZX29_GPIO_69, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 29, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0xC, 8, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0x8, 8, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 8, 2},
	},	
#endif	
	{
		.pin_name			= "kbc_0", 
	 	.gpio				= ZX29_GPIO_70, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 30, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x10, 0, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 0, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 10, 2},
	},	
	{
		.pin_name			= "kbc_1", 
	 	.gpio				= ZX29_GPIO_71, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x14, 31, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 2, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 12, 2},
	},	
	{
		.pin_name			= "kbc_2", 
	 	.gpio				= ZX29_GPIO_72, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 0, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x10, 2, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 4, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 14, 2},
	},	
	{
		.pin_name			= "kbc_3", 
	 	.gpio				= ZX29_GPIO_73, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 1, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x10, 4, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 6, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 16, 2},
	},	
	{
		.pin_name			= "kbr_0", 
	 	.gpio				= ZX29_GPIO_74, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 2, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x10, 6, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 8, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 18, 2},
	},	
	{
		.pin_name			= "kbr_1", 
	 	.gpio				= ZX29_GPIO_75, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 3, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x10, 8, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 10, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 20, 2},
	},	
	{
		.pin_name			= "kbr_2", 
	 	.gpio				= ZX29_GPIO_76, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 4, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x10, 10, 2},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 12, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 22, 2},
	},	
	{
		.pin_name			= "kbr_3", 
	 	.gpio				= ZX29_GPIO_77, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 5, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 14, 2},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x1c, 24, 2},
	},	
	{
		.pin_name			= "tdd_data0", 
	 	.gpio				= ZX29_GPIO_78, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 6, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data1", 
	 	.gpio				= ZX29_GPIO_79, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 7, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},
	{
		.pin_name			= "tdd_data2", 
	 	.gpio				= ZX29_GPIO_80, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 8, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data3", 
	 	.gpio				= ZX29_GPIO_81, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 9, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data4", 
	 	.gpio				= ZX29_GPIO_82, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 10, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data5", 
	 	.gpio				= ZX29_GPIO_83, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 11, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data6", 
	 	.gpio				= ZX29_GPIO_84, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 12, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data7", 
	 	.gpio				= ZX29_GPIO_85, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 13, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data8", 
	 	.gpio				= ZX29_GPIO_86, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 14, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data9", 
	 	.gpio				= ZX29_GPIO_87, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 15, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data10", 
	 	.gpio				= ZX29_GPIO_88, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 16, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_data11", 
	 	.gpio				= ZX29_GPIO_89, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 17, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data0", 
	 	.gpio				= ZX29_GPIO_90, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 18, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data1", 
	 	.gpio				= ZX29_GPIO_91, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 19, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data2", 
	 	.gpio				= ZX29_GPIO_92, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 20, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data3", 
	 	.gpio				= ZX29_GPIO_93, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 21, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data4", 
	 	.gpio				= ZX29_GPIO_94, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 22, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data5", 
	 	.gpio				= ZX29_GPIO_95, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 23, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data6", 
	 	.gpio				= ZX29_GPIO_96, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 24, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data7", 
	 	.gpio				= ZX29_GPIO_97, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 25, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data8", 
	 	.gpio				= ZX29_GPIO_98, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 26, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data9", 
	 	.gpio				= ZX29_GPIO_99, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 27, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data10", 
	 	.gpio				= ZX29_GPIO_100, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 28, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "tdd_rx_data11", 
	 	.gpio				= ZX29_GPIO_101, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 29, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x20, 0, 8},
	},	
	{
		.pin_name			= "fclk", 
	 	.gpio				= ZX29_GPIO_102, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 30, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x28, 8, 8},
	},	
	{
		.pin_name			= "frame_tx", 
	 	.gpio				= ZX29_GPIO_103, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x18, 31, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 0, 2},
	},	
	{
		.pin_name			= "frame_rx", 
	 	.gpio				= ZX29_GPIO_104, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 0, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 2, 2},
	},	
	{
		.pin_name			= "mclk", 
	 	.gpio				= ZX29_GPIO_105, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 1, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 4, 2},
	},	
	{
		.pin_name			= "lte_rf_clk", 
	 	.gpio				= ZX29_GPIO_106, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 2, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 6, 2},
	},	
	{
		.pin_name			= "lte_tx_rx", 
	 	.gpio				= ZX29_GPIO_107, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 3, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x14, 0, 10},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 8, 2},
	},	
	{
		.pin_name			= "lte_tx_rx_switch", 
	 	.gpio				= ZX29_GPIO_108, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 4, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x14, 10, 10},	 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 10, 2},
	},	
	{
		.pin_name			= "resetb_out", 
	 	.gpio				= ZX29_GPIO_109, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 5, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 12, 2},
	},
	{
		.pin_name			= "pdn_gsm", 
	 	.gpio				= ZX29_GPIO_110, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 6, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 16, 2},	 		 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 14, 2},
	},	
	{
		.pin_name			= "wake_up", 
	 	.gpio				= ZX29_GPIO_111, 
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 18, 2},	 		 	
	 	.io_cfg_reg			= {IO_CFG_BASE+0x24, 20, 2},
	},	
#if RF_SPI0_MAY_USED_AS_GPIO	
	{
		.pin_name			= "rf_spi0_str0", 
	 	.gpio				= ZX29_GPIO_112, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 7, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x28, 0, 8},
	},	
	{
		.pin_name			= "rf_spi0_str1", 
	 	.gpio				= ZX29_GPIO_113, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 8, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x28, 0, 8},
	},	
	{
		.pin_name			= "rf_spi0_clk", 
	 	.gpio				= ZX29_GPIO_114, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 9, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x28, 0, 8},
	},	
	{
		.pin_name			= "rf_spi0_din", 
	 	.gpio				= ZX29_GPIO_115, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 10, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x28, 0, 8},
	},	
	{
		.pin_name			= "rf_spi0_data", 
	 	.gpio				= ZX29_GPIO_116, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 11, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x28, 0, 8},
	},	
#endif
#if RF_SPI1_MAY_USED_AS_GPIO
	{
		.pin_name			= "rf_spi1_str", 
	 	.gpio				= ZX29_GPIO_117, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 12, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 0, 2},
	},		
	{
		.pin_name			= "rf_spi1_clk", 
	 	.gpio				= ZX29_GPIO_118, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 13, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 2, 2},
	},		
	{
		.pin_name			= "rf_spi1_din", 
	 	.gpio				= ZX29_GPIO_119, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 14, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 4, 2},
	},
	{
		.pin_name			= "rf_spi1_data", 
	 	.gpio				= ZX29_GPIO_120, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 15, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 6, 2},
	},	
#endif
#if RF_CTRL_MAY_USED_AS_GPIO
	{
		.pin_name			= "rf_control0", 
	 	.gpio				= ZX29_GPIO_121, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 16, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x18, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 8, 2},
	},	
	{
		.pin_name			= "rf_control1", 
	 	.gpio				= ZX29_GPIO_122, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 17, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x18, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 10, 2},
	},	
	{
		.pin_name			= "rf_control2", 
	 	.gpio				= ZX29_GPIO_123, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 18, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x18, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 12, 2},
	},
	{
		.pin_name			= "rf_control3", 
	 	.gpio				= ZX29_GPIO_124, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 19, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x1C, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 14, 2},
	},	
	{
		.pin_name			= "rf_control4", 
	 	.gpio				= ZX29_GPIO_125, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 20, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x1C, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 16, 2},
	},	
	{
		.pin_name			= "rf_control5", 
	 	.gpio				= ZX29_GPIO_126, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 21, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x1C, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 18, 2},
	},	
	{
		.pin_name			= "rf_control6", 
	 	.gpio				= ZX29_GPIO_127, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 22, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 20, 2},		 	
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x20, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 20, 2},
	},
	{
		.pin_name			= "rf_control7", 
	 	.gpio				= ZX29_GPIO_128, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 23, 1},
	 	.aon_func_sel_reg	= {AON_FUNC_SEL_BASE+0xC, 22, 2},		 	
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x20, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 22, 2},
	},	
	{
		.pin_name			= "rf_control8", 
	 	.gpio				= ZX29_GPIO_129, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 24, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x20, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 24, 2},
	},
	{
		.pin_name			= "rf_control9", 
	 	.gpio				= ZX29_GPIO_130, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 25, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x24, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 26, 2},
	},	
	{
		.pin_name			= "rf_control10", 
	 	.gpio				= ZX29_GPIO_131, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 26, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x24, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 28, 2},
	},		
	{
		.pin_name			= "rf_control11", 
	 	.gpio				= ZX29_GPIO_132, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 27, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x24, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x2C, 30, 2},
	},	
	{
		.pin_name			= "rf_control12", 
	 	.gpio				= ZX29_GPIO_133, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 28, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x28, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 0, 2},
	},	
	{
		.pin_name			= "rf_control13", 
	 	.gpio				= ZX29_GPIO_134, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 29, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x28, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 2, 2},
	},	
	{
		.pin_name			= "rf_control14", 
	 	.gpio				= ZX29_GPIO_135, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 30, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x28, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 4, 2},
	},	
	{
		.pin_name			= "rf_control15", 
	 	.gpio				= ZX29_GPIO_136, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x1C, 31, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x2C, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 6, 2},
	},	
	{
		.pin_name			= "rf_control16", 
	 	.gpio				= ZX29_GPIO_137, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 0, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x2C, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 8, 2},
	},	
	{
		.pin_name			= "rf_control17", 
	 	.gpio				= ZX29_GPIO_138, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 1, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x2C, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 10, 2},
	},	
	{
		.pin_name			= "rf_control18", 
	 	.gpio				= ZX29_GPIO_139, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 2, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x30, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 12, 2},
	},
	{
		.pin_name			= "rf_control19", 
	 	.gpio				= ZX29_GPIO_140, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 3, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x30, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 14, 2},
	},	
	{
		.pin_name			= "rf_control20", 
	 	.gpio				= ZX29_GPIO_141, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 4, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x30, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 16, 2},
	},	
	{
		.pin_name			= "rf_control21", 
	 	.gpio				= ZX29_GPIO_142, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 5, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x34, 0, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 18, 2},
	},	
	{
		.pin_name			= "rf_control22", 
	 	.gpio				= ZX29_GPIO_143, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 6, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x34, 10, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 20, 2},
	},	
	{
		.pin_name			= "rf_control23", 
	 	.gpio				= ZX29_GPIO_144, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 7, 1},
	 	.pd_func_sel_reg	= {PD_FUNC_SEL_BASE+0x34, 20, 10},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x30, 22, 2},
	},	
#endif	
	{
		.pin_name			= "rmii_clk_i",
	 	.gpio				= ZX29_GPIO_155, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 8, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "rmii_clk_o", 
	 	.gpio				= ZX29_GPIO_154, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 9, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "rmii_txen", 
	 	.gpio				= ZX29_GPIO_145, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 10, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},
	{
		.pin_name			= "rmii_rxen", 
	 	.gpio				= ZX29_GPIO_146, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 11, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},
	{
		.pin_name			= "rmii_rxd0", 
	 	.gpio				= ZX29_GPIO_147, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 12, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "rmii_rxd1", 
	 	.gpio				= ZX29_GPIO_148, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 13, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "rmii_txd0", 
	 	.gpio				= ZX29_GPIO_149, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 14, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "rmii_txd1", 
	 	.gpio				= ZX29_GPIO_150, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 15, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "mdc_sclk", 
	 	.gpio				= ZX29_GPIO_151, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 16, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "mdc_sdio", 
	 	.gpio				= ZX29_GPIO_152, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 17, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},
	{
		.pin_name			= "phy_rst", 
	 	.gpio				= ZX29_GPIO_153, 
	 	.top_func_sel_reg	= {TOP_FUNC_SEL_BASE+0x20, 18, 1},
	 	.io_cfg_reg			= {IO_CFG_BASE+0x40, 8, 8},
	},	
	{
		.pin_name			= "pin_def_end", 
	 	.gpio				= ZX29_GPIO_NULL, 
	},		
};


