/*******************************************************************************
* Copyright (C) 2009, ZTE Corporation.
*
* File Name:    hal_xp2xp.c
* File Mark:
* Description:
* Others:
* Version:		 V1.0
* Author:		 xuexingxing
* Date: 		 2016-07-04
* History 1:
*	  Date:
*	  Version:
*	  Author:
*	  Modification:
* History 2:
********************************************************************************/
#if 1
/****************************************************************************
*											   Include files
****************************************************************************/
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/suspend.h>
#include <linux/tick.h>
#include <linux/slab.h>

#include <mach/irqs.h>
#include <mach/gpio.h>
#include <mach/pcu.h>
#include <linux/irq.h>
#include <linux/delay.h>
#include <linux/gpio.h>
#include <linux/wakelock.h>
#include <linux/soc/zte/pm/drv_idle.h>

#include <linux/sysfs.h>
#include <linux/kobject.h>
/****************************************************************************
*											   Local Macros
****************************************************************************/
#define AP2CP_WAKE_GPIO     ZX29_GPIO_50			/*APCPж߶ӦGPIO*/
#define AP2CP_SLEEP_GPIO    ZX29_GPIO_53			/*APCP˯߻״̬ӦGPIO*/
#define CP2AP_WAKE_GPIO     ZX29_GPIO_131			/*CPAPж߶ӦGPIO*/
#define CP2AP_SLEEP_GPIO    ZX29_GPIO_130			/*CPAP˯߻״̬ӦGPIO*/


#define AP_SLEEP_STATUS     0	/*AP˯ʱΪ0*/
#define AP_WAKE_STATUS      1	/*APʱΪ1*/

#define CP_SLEEP_STATUS     0	/*CP˯ʱΪ0*/
#define CP_WAKE_STATUS      1	/*CPʱΪ1*/

#ifdef BTRUNK_SUPPORT
#define CP_WAKE_AP_INT_SET    1
#define CP_WAKE_AP_INT_CLEAR  0
#else
#define CP_WAKE_AP_INT_SET    0
#define CP_WAKE_AP_INT_CLEAR  1
#endif

#ifndef TRUE
#define TRUE  1
#endif

#ifndef FALSE
#define FALSE 0
#endif

#define XP2XP_DEBUG

#ifdef XP2XP_DEBUG
#define xp2xp_debug(fmt, args...)	 printk(KERN_INFO "[SLP] " fmt, ##args)
#else
#define xp2xp_debug(fmt, args...)
#endif

#define XP2XP_STATE    "xp2xp_state"
/****************************************************************************
*											   Local Types
****************************************************************************/
struct zx29_pin_table
{
	unsigned int 			gpio_num;
    unsigned int 			func_gpio;
    unsigned int 			func_int;
};

typedef enum{
	SLEEP_NOTIFY,
	WAKEUP_NOTIFY
} notify_type;

typedef enum{
	SET_EDGE_RISING,
	SET_EDGE_FALLING
} interrupt_type;


#define GPIO_CONFIG(gpio_num, func_gpio , func_int)		{gpio_num, func_gpio, func_int}

static struct zx29_pin_table pin_table[] = 
{
    GPIO_CONFIG(ZX29_GPIO_0,  GPIO0_GPIO0 , 0),
    GPIO_CONFIG(ZX29_GPIO_1,  GPIO1_GPIO1 , 0),
    GPIO_CONFIG(ZX29_GPIO_2,  GPIO2_GPIO2 , 0),
    GPIO_CONFIG(ZX29_GPIO_3,  GPIO3_GPIO3 , 0),
    GPIO_CONFIG(ZX29_GPIO_4,  GPIO4_GPIO4 , 0),
    GPIO_CONFIG(ZX29_GPIO_5,  GPIO5_GPIO5 , 0),
    GPIO_CONFIG(ZX29_GPIO_6,  GPIO6_GPIO6 , 0),
    GPIO_CONFIG(ZX29_GPIO_7,  GPIO7_GPIO7 , 0),
    GPIO_CONFIG(ZX29_GPIO_8,  GPIO8_GPIO8 , 0),
    GPIO_CONFIG(ZX29_GPIO_9,  GPIO9_GPIO9 , 0),
    GPIO_CONFIG(ZX29_GPIO_10, GPIO10_GPIO10 , 0),
    GPIO_CONFIG(ZX29_GPIO_11, GPIO11_GPIO11 , 0),
    GPIO_CONFIG(ZX29_GPIO_12, GPIO12_GPIO12 , 0),
    GPIO_CONFIG(ZX29_GPIO_13, GPIO13_GPIO13 , 0),
    GPIO_CONFIG(ZX29_GPIO_14, GPIO14_GPIO14 , 0),
    GPIO_CONFIG(ZX29_GPIO_15, GPIO15_GPIO15 , 0),
    GPIO_CONFIG(ZX29_GPIO_16, GPIO16_GPIO16 , 0),
    GPIO_CONFIG(ZX29_GPIO_17, GPIO17_GPIO17 , 0),
    GPIO_CONFIG(ZX29_GPIO_18, GPIO18_GPIO18 , 0),
    GPIO_CONFIG(ZX29_GPIO_19, GPIO19_GPIO19 , 0),
    GPIO_CONFIG(ZX29_GPIO_20, GPIO20_GPIO20 , 0),
    GPIO_CONFIG(ZX29_GPIO_21, GPIO21_GPIO21 , 0),
    GPIO_CONFIG(ZX29_GPIO_22, GPIO22_GPIO22 , 0), 
    GPIO_CONFIG(ZX29_GPIO_23, GPIO23_GPIO23 , 0), 
    GPIO_CONFIG(ZX29_GPIO_24, GPIO24_GPIO24 , 0), 
    GPIO_CONFIG(ZX29_GPIO_25, GPIO25_GPIO25 , 0), 
    GPIO_CONFIG(ZX29_GPIO_26, GPIO26_GPIO26 , 0), 
    GPIO_CONFIG(ZX29_GPIO_27, GPIO27_GPIO27 , 0), 
    GPIO_CONFIG(ZX29_GPIO_28, GPIO28_GPIO28 , 0),
    GPIO_CONFIG(ZX29_GPIO_29, GPIO29_GPIO29 , 0), 
    GPIO_CONFIG(ZX29_GPIO_30, GPIO30_GPIO30 , 0),  
    GPIO_CONFIG(ZX29_GPIO_31, GPIO31_GPIO31 , 0), 
    GPIO_CONFIG(ZX29_GPIO_32, GPIO32_GPIO32 , 0), 
    GPIO_CONFIG(ZX29_GPIO_33, GPIO33_GPIO33 , 0), 
    GPIO_CONFIG(ZX29_GPIO_34, GPIO34_GPIO34 , 0), 
    GPIO_CONFIG(ZX29_GPIO_35, GPIO35_GPIO35 , 0), 
    GPIO_CONFIG(ZX29_GPIO_36, GPIO36_GPIO36 , 0), 
    GPIO_CONFIG(ZX29_GPIO_37, GPIO37_GPIO37 , 0), 
    GPIO_CONFIG(ZX29_GPIO_38, GPIO38_GPIO38 , 0), 
    GPIO_CONFIG(ZX29_GPIO_39, GPIO39_GPIO39 , 0), 
    GPIO_CONFIG(ZX29_GPIO_40, GPIO40_GPIO40 , 0), 
    GPIO_CONFIG(ZX29_GPIO_41, GPIO41_GPIO41 , 0),    
    GPIO_CONFIG(ZX29_GPIO_42, GPIO42_GPIO42 , 0),
    GPIO_CONFIG(ZX29_GPIO_43, GPIO43_GPIO43 , 0),       
    GPIO_CONFIG(ZX29_GPIO_44, GPIO44_GPIO44 , 0),
    GPIO_CONFIG(ZX29_GPIO_45, GPIO45_GPIO45 , 0), 
    GPIO_CONFIG(ZX29_GPIO_46, GPIO46_GPIO46 , 0),
    GPIO_CONFIG(ZX29_GPIO_47, GPIO47_GPIO47 , GPIO47_EXT_INT0), 
    GPIO_CONFIG(ZX29_GPIO_48, GPIO48_GPIO48 , GPIO48_EXT_INT1), 
    GPIO_CONFIG(ZX29_GPIO_49, GPIO49_GPIO49 , GPIO49_EXT_INT2), 
    GPIO_CONFIG(ZX29_GPIO_50, GPIO50_GPIO50 , GPIO50_EXT_INT3),
    GPIO_CONFIG(ZX29_GPIO_51, GPIO51_GPIO51 , GPIO51_EXT_INT4),
    GPIO_CONFIG(ZX29_GPIO_52, GPIO52_GPIO52 , GPIO52_EXT_INT5),
    GPIO_CONFIG(ZX29_GPIO_53, GPIO53_GPIO53 , GPIO53_EXT_INT6),
    GPIO_CONFIG(ZX29_GPIO_54, GPIO54_GPIO54 , GPIO54_EXT_INT7),
    GPIO_CONFIG(ZX29_GPIO_55, GPIO55_GPIO55 , 0),
    GPIO_CONFIG(ZX29_GPIO_56, GPIO56_GPIO56 , 0),
    GPIO_CONFIG(ZX29_GPIO_57, GPIO57_GPIO57 , 0),
    GPIO_CONFIG(ZX29_GPIO_58, GPIO58_GPIO58 , 0),
    GPIO_CONFIG(ZX29_GPIO_59, GPIO59_GPIO59 , 0),
    GPIO_CONFIG(ZX29_GPIO_60, GPIO60_GPIO60 , 0),
    GPIO_CONFIG(ZX29_GPIO_61, GPIO61_GPIO61 , 0),
    GPIO_CONFIG(ZX29_GPIO_62, GPIO62_GPIO62 , 0),
    GPIO_CONFIG(ZX29_GPIO_63, GPIO63_GPIO63 , 0),
    GPIO_CONFIG(ZX29_GPIO_64, GPIO64_GPIO64 , 0),
    GPIO_CONFIG(ZX29_GPIO_65, GPIO65_GPIO65 , 0),
    GPIO_CONFIG(ZX29_GPIO_66, GPIO66_GPIO66 , 0),
    GPIO_CONFIG(ZX29_GPIO_67, GPIO67_GPIO67 , 0),
    GPIO_CONFIG(ZX29_GPIO_68, GPIO68_GPIO68 , 0),
    GPIO_CONFIG(ZX29_GPIO_69, GPIO69_GPIO69 , 0),
    GPIO_CONFIG(ZX29_GPIO_70, GPIO70_GPIO70 , 0),
    GPIO_CONFIG(ZX29_GPIO_71, GPIO71_GPIO71 , 0),
    GPIO_CONFIG(ZX29_GPIO_72, GPIO72_GPIO72 , 0),
    GPIO_CONFIG(ZX29_GPIO_73, GPIO73_GPIO73 , 0),
    GPIO_CONFIG(ZX29_GPIO_74, GPIO74_GPIO74 , 0),
    GPIO_CONFIG(ZX29_GPIO_75, GPIO75_GPIO75 , 0),
    GPIO_CONFIG(ZX29_GPIO_76, GPIO76_GPIO76 , 0),
    GPIO_CONFIG(ZX29_GPIO_77, GPIO77_GPIO77 , 0),
    GPIO_CONFIG(ZX29_GPIO_78, GPIO78_GPIO78 , 0),
    GPIO_CONFIG(ZX29_GPIO_79, GPIO79_GPIO79 , 0),
    GPIO_CONFIG(ZX29_GPIO_80, GPIO80_GPIO80 , 0),
    GPIO_CONFIG(ZX29_GPIO_81, GPIO81_GPIO81 , 0), 
    GPIO_CONFIG(ZX29_GPIO_82, GPIO82_GPIO82 , 0), 
    GPIO_CONFIG(ZX29_GPIO_83, GPIO83_GPIO83 , 0), 
    GPIO_CONFIG(ZX29_GPIO_84, GPIO84_GPIO84 , 0), 
    GPIO_CONFIG(ZX29_GPIO_85, GPIO85_GPIO85 , 0), 
    GPIO_CONFIG(ZX29_GPIO_86, GPIO86_GPIO86 , 0), 
    GPIO_CONFIG(ZX29_GPIO_87, GPIO87_GPIO87 , 0), 
    GPIO_CONFIG(ZX29_GPIO_88, GPIO88_GPIO88 , 0), 
    GPIO_CONFIG(ZX29_GPIO_89, GPIO89_GPIO89 , 0), 
    GPIO_CONFIG(ZX29_GPIO_90, GPIO90_GPIO90 , 0), 
    GPIO_CONFIG(ZX29_GPIO_91, GPIO91_GPIO91 , 0), 
    GPIO_CONFIG(ZX29_GPIO_92, GPIO92_GPIO92 , 0), 
    GPIO_CONFIG(ZX29_GPIO_93, GPIO93_GPIO93 , 0), 
    GPIO_CONFIG(ZX29_GPIO_94, GPIO94_GPIO94 , 0), 
    GPIO_CONFIG(ZX29_GPIO_95, GPIO95_GPIO95 , 0),
    GPIO_CONFIG(ZX29_GPIO_96, GPIO96_GPIO96 , 0), 
    GPIO_CONFIG(ZX29_GPIO_97, GPIO97_GPIO97 , 0),
    GPIO_CONFIG(ZX29_GPIO_98, GPIO98_GPIO98 , 0), 
    GPIO_CONFIG(ZX29_GPIO_99, GPIO99_GPIO99 , 0), 
    GPIO_CONFIG(ZX29_GPIO_100, GPIO100_GPIO100 , 0),
    GPIO_CONFIG(ZX29_GPIO_101, GPIO101_GPIO101 , 0),
    GPIO_CONFIG(ZX29_GPIO_102, GPIO102_GPIO102 , 0),
    GPIO_CONFIG(ZX29_GPIO_103, GPIO103_GPIO103 , 0),
    GPIO_CONFIG(ZX29_GPIO_104, GPIO104_GPIO104 , 0),
    GPIO_CONFIG(ZX29_GPIO_105, GPIO105_GPIO105 , 0),
    GPIO_CONFIG(ZX29_GPIO_106, GPIO106_GPIO106 , 0),
    GPIO_CONFIG(ZX29_GPIO_107, GPIO107_GPIO107 , 0),
    GPIO_CONFIG(ZX29_GPIO_108, GPIO108_GPIO108 , 0),
    GPIO_CONFIG(ZX29_GPIO_109, GPIO109_GPIO109 , 0),
    GPIO_CONFIG(ZX29_GPIO_110, GPIO110_GPIO110 , 0),
    GPIO_CONFIG(ZX29_GPIO_111, GPIO111_GPIO111 , 0),
    GPIO_CONFIG(ZX29_GPIO_112, GPIO112_GPIO112 , 0),
    GPIO_CONFIG(ZX29_GPIO_113, GPIO113_GPIO113 , 0),
    GPIO_CONFIG(ZX29_GPIO_114, GPIO114_GPIO114 , 0),
    GPIO_CONFIG(ZX29_GPIO_115, GPIO115_GPIO115 , 0),
    GPIO_CONFIG(ZX29_GPIO_116, GPIO116_GPIO116 , 0),
    GPIO_CONFIG(ZX29_GPIO_117, GPIO117_GPIO117 , 0),
    GPIO_CONFIG(ZX29_GPIO_118, GPIO118_GPIO118 , 0),
    GPIO_CONFIG(ZX29_GPIO_119, GPIO119_GPIO119 , GPIO119_EXT_INT8),
    GPIO_CONFIG(ZX29_GPIO_120, GPIO120_GPIO120 , GPIO120_EXT_INT9),
    GPIO_CONFIG(ZX29_GPIO_121, GPIO121_GPIO121 , GPIO121_EXT_INT10),
    GPIO_CONFIG(ZX29_GPIO_122, GPIO122_GPIO122 , GPIO122_EXT_INT11),
    GPIO_CONFIG(ZX29_GPIO_123, GPIO123_GPIO123 , GPIO123_EXT_INT12),
    GPIO_CONFIG(ZX29_GPIO_124, GPIO124_GPIO124 , GPIO124_EXT_INT13),
    GPIO_CONFIG(ZX29_GPIO_125, GPIO125_GPIO125 , GPIO125_EXT_INT14),
    GPIO_CONFIG(ZX29_GPIO_126, GPIO126_GPIO126 , GPIO126_EXT_INT15),
    GPIO_CONFIG(ZX29_GPIO_127, GPIO127_GPIO127 , GPIO127_EXT_INT8),
    GPIO_CONFIG(ZX29_GPIO_128, GPIO128_GPIO128 , GPIO128_EXT_INT9),
    GPIO_CONFIG(ZX29_GPIO_129, GPIO129_GPIO129 , GPIO129_EXT_INT10),
    GPIO_CONFIG(ZX29_GPIO_130, GPIO130_GPIO130 , GPIO130_EXT_INT11),
    GPIO_CONFIG(ZX29_GPIO_131, GPIO131_GPIO131 , GPIO131_EXT_INT12),
    GPIO_CONFIG(ZX29_GPIO_132, GPIO132_GPIO132 , GPIO132_EXT_INT13),
    GPIO_CONFIG(ZX29_GPIO_133, GPIO133_GPIO133 , 0),
    GPIO_CONFIG(ZX29_GPIO_134, GPIO134_GPIO134 , 0),
    GPIO_CONFIG(ZX29_GPIO_135, GPIO135_GPIO135 , 0),
};


/****************************************************************************
*											  Global Variables
****************************************************************************/

struct wake_lock xp2xp_wake_lock;
static int xp2xp_init_flag = 0;
static int irq_num = 0;
static int nWakeupCount=0;

static int currState = 1;

/****************************************************************************
*											   Local Constants
****************************************************************************/

struct kset *kset_xp2xp;
//struct kset kset_c;
struct kobject *xp2xpkobj = NULL;


static struct attribute xp2xp_state_attr =
{
        .name = "xp2xp_state",
        //.mode = S_IRUGO|S_IWUSR,
        .mode = S_IRUGO,
};


static struct attribute *xp2xp_status_attrs[] =
{
	&xp2xp_state_attr,
       NULL,
};

ssize_t xp2xp_obj_show(struct kobject *kobject,struct attribute *attr,char *buf)
{

	  if(!strcmp(attr->name, XP2XP_STATE)){
	  		sprintf(buf, "nWakeupCount:%d, currState:%s\n",nWakeupCount, (currState == 1 ? "work" : "sleep"));
	  }	
      return strlen(buf);
}


ssize_t xp2xp_obj_store(struct kobject *kobject,struct attribute *attr, const char *buf,size_t size)
{
	unsigned int value = 0;

	return size;
}
static struct sysfs_ops xp2xp_obj_sysops =
{
        .show = xp2xp_obj_show,
        .store = xp2xp_obj_store,        
};


void xp2xp_obj_release(struct kobject *kobject)
{
	printk("[kobj_test: release!]\n");
}
static struct kobj_type xp2xp_ktype =

{       .release = xp2xp_obj_release,
        .sysfs_ops = &xp2xp_obj_sysops,
        .default_attrs = xp2xp_status_attrs,
};

static int xp2xp_kset_filter(struct kset *kset,struct kobject *kobj)
{
	printk("Filter: kobj %s.\n",kobj->name);
	return 1;
}

static const char *xp2xp_kset_name(struct kset *kset,struct kobject *kobj)
{    
	static char buf[20];

	printk("Name kobj %s.\n",kobj->name);
	sprintf(buf,"%s","xp2xp");

	return buf;
}

static int xp2xp_kset_uevent(struct kset *kset,struct kobject *kobj, struct kobj_uevent_env *env)
{
   int i = 0;
    printk("uevent: kobj %s.\n",kobj->name);

   while(i < env->envp_idx)
    {
        printk("%s.\n",env->envp[i]);
       i ++;
    }

    return 0;
}


static struct kset_uevent_ops xp2xp_uevent_ops =
{
    .filter = xp2xp_kset_filter,
    .name = xp2xp_kset_name,
    .uevent = xp2xp_kset_uevent,
};


/****************************************************************************
*											   Local Function Prototypes
****************************************************************************/

static ATOMIC_NOTIFIER_HEAD(wakeup_notifier);
int xp2xp_Wakeup_notifier_register(struct notifier_block *nb);
int xp2xp_Wakeup_notifier_unregister(struct notifier_block *nb);

static irqreturn_t xp2xp_Ap2CpWakeCpHisr(int irq, void *id);
bool xp2xp_Ap2CpIsApWakeup(void);
int xp2xp_Cp2ApWakeApSignal(void);
int xp2xp_Cp2ApCpSleepStats(bool isCpWake);
int zDrvXp2xp_Cp2ApWakeupAp(void);
int zDrvXp2xp_Initiate(void);

/****************************************************************************
*											  Global Constants
****************************************************************************/

/****************************************************************************
*											  Function Definitions
****************************************************************************/



int xp2xp_Wakeup_notifier_register(struct notifier_block *nb)
{
	return atomic_notifier_chain_register(&wakeup_notifier, nb);
}
EXPORT_SYMBOL_GPL(xp2xp_Wakeup_notifier_register);

int xp2xp_Wakeup_notifier_unregister(struct notifier_block *nb)
{
	return atomic_notifier_chain_unregister(&wakeup_notifier, nb);
}
EXPORT_SYMBOL_GPL(xp2xp_Wakeup_notifier_unregister);



/*******************************************************************************
* Function:	xp2xp_wakeup_notifier_call_chain.
* Description:	xp2xp_wakeup_notifier_call_chain.
* Parameters:
*   Input:wake_or_sleep:means wakeup or sleep notify to other device
*
*   Output:call_result:means devices been called return result
*
* Returns:  
*
* Others:the callback shall not block or sleep
********************************************************************************/
int xp2xp_wakeup_notifier_call_chain(unsigned long wake_or_sleep, void *call_result)
{
//	printk("xp2xp_wakeup_notifier_call_chain,val=%ld\n", val);
	return atomic_notifier_call_chain(&wakeup_notifier, wake_or_sleep, call_result);
}
EXPORT_SYMBOL_GPL(xp2xp_wakeup_notifier_call_chain);


/*******************************************************************************
* Function:	func_gpio_value_get.
* Description:	func_gpio_value_get.
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
static int func_gpio_value_get(unsigned gpio)
{
    unsigned int i = 0;
    for(i=0; i<ARRAY_SIZE(pin_table); i++)
    {
        if(gpio == pin_table[i].gpio_num)
        {
            return pin_table[i].func_gpio;
        }
    }
    
    xp2xp_debug("XP2XP: func_gpio_value_get failed gpio = %d",gpio);
    BUG();
    return -1;
}  

/*******************************************************************************
* Function:	func_int_value_get.
* Description:	func_int_value_get.
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
static int func_int_value_get(unsigned gpio)
{
    unsigned int i = 0;
    for(i=0; i<ARRAY_SIZE(pin_table); i++)
    {
        if(gpio == pin_table[i].gpio_num)
        {
            return pin_table[i].func_int;
        }
    }
    
    xp2xp_debug("XP2XP: func_int_value_get failed gpio = %d",gpio);
    BUG();
    return -1;
}  

void xp2xp_change_irq_setting(interrupt_type set_type)
{
    irq_num = gpio_to_irq(AP2CP_WAKE_GPIO); 
 
	if(set_type == SET_EDGE_RISING){//waiting wakeup int
	    zx29_gpio_set_inttype(AP2CP_WAKE_GPIO, IRQ_TYPE_EDGE_RISING);
		
	} else{
	//enter waiting sleep int  
	    zx29_gpio_set_inttype(AP2CP_WAKE_GPIO, IRQ_TYPE_EDGE_FALLING);
	}
    pcu_clr_irq_pending(irq_num); 
    
}



void xp2xp_notify_up(notify_type isWakeup)
{
	unsigned char buf[100];
	int rtv = -1;
	enum kobject_action action =KOBJ_MAX;
	char*envp_ext[] = {NULL,NULL};
	strcpy(buf,"USBEVENT=xp2xp_notify");
	action = ((isWakeup == WAKEUP_NOTIFY)? KOBJ_ONLINE : KOBJ_OFFLINE);
	envp_ext[0] = buf;
	rtv = kobject_uevent_env(xp2xpkobj, action,envp_ext);	
	printk("xp2xp_notify_up isWakeup:%d, result:%d\n", isWakeup, rtv);
}
	
/*******************************************************************************
* Function:	xp2xp_Ap2CpWakeCpHisr
* Description:	ap2cp wake up int isr
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
static irqreturn_t xp2xp_Ap2CpWakeCpHisr(int irq, void *id)
{
	int call_state = 0;
	int v_gpio = 0;
    pcu_clr_irq_pending(irq_num); 
	nWakeupCount++;
	//change pinmux to gpio
	zx29_gpio_config(AP2CP_WAKE_GPIO,func_gpio_value_get(AP2CP_WAKE_GPIO));
	//gpio_direction_input(USB_GPIO);
	//msleep(5);
	v_gpio = gpio_get_value(AP2CP_WAKE_GPIO);
	printk("%s,value:%d\n", __func__,v_gpio);
	zx29_gpio_config(AP2CP_WAKE_GPIO,func_int_value_get(AP2CP_WAKE_GPIO));

	
#if 1
 	if(v_gpio){//now is wakeup
		zx_cpuidle_set_busy(IDLE_FLAG_XP2XP);
		wake_lock(&xp2xp_wake_lock);
		//tell application 
		xp2xp_notify_up(WAKEUP_NOTIFY);
#ifdef CONFIG_KERNEL_CONTROL_WAKEUP		
	 	xp2xp_wakeup_notifier_call_chain(WAKEUP_NOTIFY, &call_state);
	 	if(call_state == 0){//check device wakeup result
			xp2xp_Cp2ApCpSleepStats(TRUE);
	 	}
#endif		
		currState = 1;//means working
		xp2xp_change_irq_setting(SET_EDGE_FALLING);
 	} else{//this is sleep
		xp2xp_change_irq_setting(SET_EDGE_RISING);
		xp2xp_Cp2ApCpSleepStats(FALSE);
		xp2xp_notify_up(SLEEP_NOTIFY);
#ifdef CONFIG_KERNEL_CONTROL_WAKEUP		
	 	xp2xp_wakeup_notifier_call_chain(SLEEP_NOTIFY, &call_state);
	 	if(call_state){//check device sleep result
	 	//to do
	 	}
#endif		
		currState = 0;//means sleep
 	
		wake_unlock(&xp2xp_wake_lock);
		zx_cpuidle_set_free(IDLE_FLAG_XP2XP);
 	}
 #else
	xp2xp_Cp2ApCpSleepStats(TRUE);
	zx_cpuidle_set_busy(IDLE_FLAG_XP2XP);
	wake_lock(&xp2xp_wake_lock);
	msleep(5000);	/*between 5 sec, cp can not sleep*/
	xp2xp_Cp2ApCpSleepStats(FALSE);
	wake_unlock(&xp2xp_wake_lock);
	zx_cpuidle_set_free(IDLE_FLAG_XP2XP);
#endif	
	return IRQ_HANDLED;
}
/*******************************************************************************
* Function:
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
bool xp2xp_Ap2CpIsApWakeup(void)
{
    int apStatus = 0;

    apStatus = gpio_get_value(AP2CP_SLEEP_GPIO);/*get ap status*/
    if(apStatus == AP_WAKE_STATUS)
    {
        return TRUE;
    }
	
    return FALSE;
}
EXPORT_SYMBOL_GPL(xp2xp_Ap2CpIsApWakeup);

/*******************************************************************************
* Function:
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
bool xp2xp_Ap2CpWaitApWake(void)
{
    int apStatus = 0;
    int i;

#ifdef BTRUNK_SUPPORT
    for(i=0; i<200; i++)//delay times to be determined?
#else
    for(i=0; i<5; i++)//delay times to be determined?
#endif
    {
        apStatus = gpio_get_value(AP2CP_SLEEP_GPIO);    /*get ap status*/
        if(apStatus == AP_WAKE_STATUS)
        {
            return TRUE;
        }
		msleep(5);//delay time to be determined?
    }
    return FALSE;
}


/*******************************************************************************
* Function:
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int xp2xp_Cp2ApCpSleepStats(bool isCpWake)
{
    if(isCpWake == TRUE)//wake
    {
        gpio_set_value(CP2AP_SLEEP_GPIO,CP_WAKE_STATUS);
        xp2xp_debug("XP2XP: cp send wake status:wake, wakeupcount = %d\n",nWakeupCount);
    }
    else //sleep
    {
        gpio_set_value(CP2AP_SLEEP_GPIO,CP_SLEEP_STATUS);
        msleep(20);/*between 20ms, cp keep wake, but ap think cp is sleep, if ap want to send data to cp, must sent wake up int*/
        xp2xp_debug("XP2XP: cp send sleep status:sleep\n");
    }

    return 0;
}



/*******************************************************************************
* Function:
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int xp2xp_Cp2ApWakeApSignal(void)
{
	gpio_set_value(CP2AP_WAKE_GPIO,CP_WAKE_AP_INT_SET);
	msleep(10);
	gpio_set_value(CP2AP_WAKE_GPIO,CP_WAKE_AP_INT_CLEAR);

	xp2xp_debug("XP2XP: cp send wakeup ap signal\n");

	return 0;
}


/*******************************************************************************
* Function:
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int zDrvXp2xp_Cp2ApWakeupAp(void)
{
    bool apStat = FALSE;
	int i = 0;

	if( xp2xp_init_flag == 0)
	{
		xp2xp_debug("XP2XP: cp wakeup ap cp not init!\n");
		return -1;
	}

	apStat = xp2xp_Ap2CpIsApWakeup();
	xp2xp_debug("XP2XP: call cp2ap wake func, apStat = %d!",apStat);
	if(apStat == TRUE)
	{
		return 0;
	}

	for(i=0; i<1; i++)//delay times to be determined?
	{
		xp2xp_Cp2ApWakeApSignal();
		apStat = xp2xp_Ap2CpWaitApWake();
		if(apStat == TRUE)
		{
			wake_lock_timeout(&xp2xp_wake_lock, msecs_to_jiffies(5*1000));  /*between 5 sec, cp can not sleep*/
			xp2xp_debug("XP2XP: cp wakeup ap ok!\n");
			return 0;
		}
	}
	xp2xp_debug("XP2XP: cp wakeup ap faild!\n");
	return -1;
}


/*******************************************************************************
* Function:
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others: 4 line sleep enable check
********************************************************************************/
int xp2xp_enable_4line(void)
{
	#ifdef CONFIG_KERNEL_CONTROL_WAKEUP
		return 1;
	#endif
	return 0;
}
EXPORT_SYMBOL_GPL(xp2xp_enable_4line);

int kset_xp2xp_init(void)
{
  int ret = 0;

   printk("kset test init!\n");
   
   /* ע kset_p */
   kset_xp2xp = kset_create_and_add("xp2xp", &xp2xp_uevent_ops, NULL);    
   

    /* ڽ°汾ںˣע kset ֮ǰҪ 
        *  kset.kobj  ktype Աע᲻ɹ */
  // kset_c.kobj.ktype = &ktype;
   //ret = kset_register(&kset_c);

  // if(ret)
   //     kset_unregister(kset_p);
   xp2xpkobj = kzalloc(sizeof(*xp2xpkobj),GFP_KERNEL);
   if(!xp2xpkobj){
   		printk(KERN_WARNING "mallock xp2xpkobj failed \n");
		return 0;
   }
   kobject_init(xp2xpkobj, &xp2xp_ktype);
   kobject_add(xp2xpkobj,&kset_xp2xp->kobj,"%s","xp2xp_notify");
   xp2xpkobj->kset = kset_xp2xp;

    
   return ret;
}


void kset_xp2xp_exit(void)
{
   printk("kset_xp2xp_exit exit!\n");
   
   kset_unregister(kset_xp2xp);
}

/*******************************************************************************
* Function: zDrvAp2cp_Initiate
* Description:
* Parameters:
*   Input:
*
*   Output:
*
* Returns:
*
* Others:
********************************************************************************/
int zDrvXp2xp_Initiate(void)
{
	int ret=0;
	int errCode = -1;
	printk("------------zDrvXp2xp_Initiate, enter\n");
	ret=gpio_request(AP2CP_WAKE_GPIO,"ap2cp_wake");
	if(ret)
		BUG();
#ifdef CONFIG_KERNEL_CONTROL_WAKEUP
//app need requst these gpio,so using macro 
	ret=gpio_request(CP2AP_WAKE_GPIO,"cp2ap_wake");
	if(ret)
		BUG();
	ret=gpio_request(CP2AP_SLEEP_GPIO,"cp2ap_sleep");
	if(ret)
		BUG();
	ret=gpio_request(AP2CP_SLEEP_GPIO,"ap2cp_sleep");
	if(ret)
		BUG();
#endif	

	/*ap2cp wake interrupt, input*/
	zx29_gpio_config(AP2CP_WAKE_GPIO, func_int_value_get(AP2CP_WAKE_GPIO));

#ifdef CONFIG_KERNEL_CONTROL_WAKEUP
	/*cp2ap wake gpio, output*/
	zx29_gpio_config(CP2AP_WAKE_GPIO, func_gpio_value_get(CP2AP_WAKE_GPIO));
	gpio_direction_output(CP2AP_WAKE_GPIO, CP_WAKE_AP_INT_CLEAR);//keep level

	/*cp2ap sleep status, output*/
	zx29_gpio_config(CP2AP_SLEEP_GPIO, func_gpio_value_get(CP2AP_SLEEP_GPIO));
	gpio_direction_output(CP2AP_SLEEP_GPIO, CP_SLEEP_STATUS);

	/*ap2cp sleep status, input*/
	zx29_gpio_config(AP2CP_SLEEP_GPIO, func_gpio_value_get(AP2CP_SLEEP_GPIO));
	gpio_direction_input(AP2CP_SLEEP_GPIO);
#endif
	wake_lock_init(&xp2xp_wake_lock, WAKE_LOCK_SUSPEND, "xp2xp");
    
    irq_num = gpio_to_irq(AP2CP_WAKE_GPIO); 
	printk("------------zDrvXp2xp_Initiate, irq_num:%d\n", irq_num);
    
    zx29_gpio_set_inttype(AP2CP_WAKE_GPIO, IRQ_TYPE_EDGE_RISING);
    pcu_clr_irq_pending(irq_num); 
    
	errCode = request_threaded_irq(irq_num, NULL, xp2xp_Ap2CpWakeCpHisr,IRQF_ONESHOT, "WakeInt2CP",NULL);
	if(errCode < 0)
	{
	    return errCode;
	}
	
	irq_set_irq_wake(irq_num, 1);
	kset_xp2xp_init();
	xp2xp_init_flag = 1;
	
	xp2xp_debug("XP2XP: init ok!\n");

	return 0;
}
int zDrvXp2xp_Release(void)
{
	kset_xp2xp_exit();
	gpio_free(AP2CP_WAKE_GPIO);

#ifdef CONFIG_KERNEL_CONTROL_WAKEUP	
	gpio_free(AP2CP_SLEEP_GPIO);
	gpio_free(CP2AP_WAKE_GPIO);
	gpio_free(CP2AP_SLEEP_GPIO);
#endif	
	return 0;
}
late_initcall(zDrvXp2xp_Initiate);

module_exit(zDrvXp2xp_Release);
#endif

