#ifndef DEBUG_H
#define DEBUG_H

static inline void exp_handler(void)
{
 asm volatile("mrs r0,cpsr\n\t"
              "orr r0,r0,#0xc0\n\t "
			  "msr cpsr,r0\n\t"
              "bkpt"
              );
}

#define ZDRV_ASSERT(_EXP) \
	do{    \
	if(!(_EXP))      \
	  exp_handler(); \
	}while(0)  


/*sys fs*/
#define zte_attr(_name) \
static struct kobj_attribute _name##_attr = 	\
{                           \
	.attr	= 				\
	{                       \
		.name = __stringify(_name),	\
		.mode = 0644,			\
	},					\
	.show	= _name##_show,			\
	.store	= _name##_store,		\
}

/* /sys/zte */
extern struct kobject *zx_root_kobj;

#endif
