

#include <linux/sched.h>

#define USB_DEBUG_EN 1

void usb_dbg_showLog(void);
void usb_dbg_printf(const char *fmt,...);

//#define USB_CHG_DEV


#if USB_DEBUG_EN

#define HAL_DBG_EN		1
#define STACK_DBG_EN	1
#define REG_DBG_EN      0

#define USBREG_DBG(_format, _args...)		do{if(REG_DBG_EN)usb_dbg_printf("(%u)reg," _format "\n", \
												jiffies, ## _args);}while(0)

#define USBHAL_DBG(_format, _args...)		do{if(HAL_DBG_EN)usb_dbg_printf("(%u)hal," _format "\n", \
												jiffies, ## _args);}while(0)

#define USBSTACK_DBG(_format, _args...)	do{if(STACK_DBG_EN)usb_dbg_printf("(%u)stack," _format "\n", \
												jiffies, ## _args);}while(0)

#define USB_ASSERT(_expr, _format, _args...)	do{if(!(_expr)) {usb_dbg_printf("(%u)ERROR(%s, %d): " _format "\n", \
												jiffies,  __func__, __LINE__, ## _args);BUG_ON(1);}}while(0)
#else

#define USBREG_DBG(_format, _args...)		do{}while(0)
#define USBHAL_DBG(_format, _args...)			do{}while(0)
#define USBSTACK_DBG(_format, _args...)		do{}while(0)
#define USB_ASSERT(_expr, _format, _args...)	do{}while(0)

#endif

extern void usb_dbg_ep0reg(void);

#ifdef CONFIG_KERNEL_GLOBAL_DEBUG
#define usb_printk(_format, _args...)		do{printk(KERN_INFO"usb," _format "\n",##_args);}while(0)
#define mmc_printk(_format, _args...)		do{printk(KERN_INFO"mmc," _format "\n",##_args);}while(0)
#define gmac_printk(_format, _args...)		do{printk(KERN_INFO"gmac," _format "\n",##_args);}while(0)
#else
extern unsigned int usb_printk_en;
extern unsigned int mmc_printk_en;
extern unsigned int gmac_printk_en;

#define usb_printk(_format, _args...)		do{if(usb_printk_en){printk(KERN_INFO"usb," _format "\n",##_args);}}while(0)
#define mmc_printk(_format, _args...)		do{if(mmc_printk_en){printk(KERN_INFO"mmc," _format "\n",##_args);}}while(0)
#define gmac_printk(_format, _args...)		do{if(gmac_printk_en){printk(KERN_INFO"gmac," _format "\n",##_args);}}while(0)
#endif

