/*
 * arch/arm/mach-zx297520v2/include/mach/iomap.h
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef IOMAP_H
#define IOMAP_H

#define CPU_SHIFT 0
#include "ram_base_config_7520v3.h"

/*virtual address 0xf8000000--0xfeffffff  for static io remap*/
#define ZX29_ADDR_BASE						(0xf8000000)

#ifndef __ASSEMBLY__
#define ZX29_ADDR(x)						((void __iomem __force *)ZX29_ADDR_BASE + (x))
#else
#define ZX29_ADDR(x)						(ZX29_ADDR_BASE + (x))
#endif

/**************************************************************************************
 *                   virtual address  (need remap)                        
 **************************************************************************************/
#define ZX_GIC_BASE    						ZX29_ADDR(0x0)
#define ZX_GIC_SIZE    						(SZ_2M)

#define ZX_AP_PERIPHERAL_BASE    			ZX29_ADDR(0x200000)
#define ZX_AP_PERIPHERAL_SIZE    			(SZ_1M)

#define ZX_IRAM0_BASE        				ZX29_ADDR(0x300000)
#define ZX_IRAM0_SIZE        				(SZ_1M)

#define ZX_IRAM1_BASE        				ZX29_ADDR(0x400000)
#define ZX_IRAM1_SIZE        				(SZ_1M)  /*(SZ_64K)*/

#define ZX_IRAM2_BASE        				ZX29_ADDR(0x500000)
#define ZX_IRAM2_SIZE        				(SZ_1M)

#define ZX_AHB_CFG_BASE        				ZX29_ADDR(0x600000)
#define ZX_AHB_CFG_SIZE        				(SZ_1M)

#define ZX_USB_BASE        					ZX29_ADDR(0x700000)
#define ZX_USB_SIZE        					(SZ_1M)

#define USB_GLOBAL_SIZE					    0x400	
#define USB_DEVICE_SIZE						0x600
#define USB_PWR_CLK_SIZE					0x200

#define ZX_HSIC_BASE        				ZX29_ADDR(0x800000)
#define ZX_HSIC_SIZE        				(SZ_1M)

#define ZX_APB_CFG_BASE        				ZX29_ADDR(0x900000)
#define ZX_APB_CFG_SIZE        				(SZ_1M)

#define ZX_LSP_BASE        					ZX29_ADDR(0xA00000)
#define ZX_LSP_SIZE        					(SZ_1M)

#define ZX_GICC_BASE        				ZX29_ADDR(0xB00000)
#define ZX_GICC_SIZE        				(SZ_1M)

#define ZX_GSM_CFG_BASE        				ZX29_ADDR(0xC00000)
#define ZX_GSM_CFG_SIZE        				(SZ_1M)

#define ZX_GSM_MODEM_BASE   				ZX29_ADDR(0xD00000)
#define ZX_GSM_MODEM_SIZE     				(SZ_32M + SZ_16M)

#define ZX_DDR_PHYCODE_BASE				    ZX29_ADDR(0x3D00000)
#define ZX_DDR_PHYCODE_SIZE				    (DDR_BASE_LEN_PHY)

#define ZX_DDR_MODEM_BASE    				(ZX_DDR_PHYCODE_BASE+ZX_DDR_PHYCODE_SIZE)
#define ZX_DDR_MODEM_SIZE     				(DDR_BASE_LEN_LTE_DATA+DDR_BASE_LEN_RAMDUMP)

#define ZX_DDR_CAPBUF_BASE                  (ZX_DDR_MODEM_BASE+ZX_DDR_MODEM_SIZE)
#define ZX_DDR_CAPBUF_SIZE                  (DDR_BASE_LEN_CAP_BUF)

#ifdef CONFIG_MEM_TRACKER
#define ZX_MEM_TRACKER_BASE					(ZX_DDR_CAPBUF_BASE+ZX_DDR_CAPBUF_SIZE)
#define ZX_MEM_TRACKER_SIZE					(SZ_1M)

#define ZX_KMALLOC_TRACKER_BASE			    (ZX_MEM_TRACKER_BASE+ZX_MEM_TRACKER_SIZE)
#define ZX_KMALLOC_TRACKER_SIZE				(SZ_1M)

#endif

/**************************************************************************************
 *                   virtual address  (for driver)                        
 **************************************************************************************/
#define ZX_A1_BASE        					(ZX_IRAM1_BASE + 0x30000)
#define ZX_KEY_BASE        					(ZX_A1_BASE)
#define ZX_UART0_BASE        				(ZX_A1_BASE + 0x1000)
#define ZX_PMIC_I2C_BASE      				(ZX_A1_BASE + 0x2000)
#define ZX_RTC_BASE      					(ZX_A1_BASE + 0x3000)
#define ZX_LPM_BASE      					(ZX_A1_BASE + 0x4000)
#define ZX_LPM_GSM_BASE      				(ZX_LPM_BASE)
#define ZX_LPM_LTE_BASE      				(ZX_A1_BASE + 0x4200)
#define ZX_LPM_TD_BASE      				(ZX_A1_BASE + 0x4400)
#define ZX_LPM_W_BASE      					(ZX_A1_BASE + 0x4600)
#define ZX_PCU_BASE      					(ZX_A1_BASE + 0xA000)
#define ZX_TOP_CRM_BASE      				(ZX_A1_BASE + 0xB000)
#define ZX_PAD_CTRL_BASE      				(ZX_A1_BASE + 0xC000)
#define ZX_GPIO0_BASE      					(ZX_A1_BASE + 0xD000)
#define ZX_GPIO1_BASE      					(ZX_A1_BASE + 0xE000)
#define ZX_SOC_SYS_BASE      				(ZX_A1_BASE + 0x10000)
#define ZX_AP_TIMER1_BASE     				(ZX_A1_BASE + 0x13000)
#define ZX_AP_TIMER2_BASE     				(ZX_A1_BASE + 0x14000)
#define ZX_AP_TIMER3_BASE     				(ZX_A1_BASE + 0x16000)
#define ZX_RM_WDT_BASE     					(ZX_A1_BASE + 0x18000)

#define ZX_RM_TIMER0_BASE     				(ZX_A1_BASE + 0x12000)
#define ZX_RM_TIMER1_BASE     				(ZX_A1_BASE + 0x15000)
#define ZX_PS_TIMER1_BASE     				(ZX_A1_BASE + 0x8000)
#define ZX_PS_TIMER2_BASE     				(ZX_A1_BASE + 0x9000)
#define ZX_USIM1_BASE     					(ZX_A1_BASE + 0x26000)
#define ZX_PS_TIMER0_BASE     				(ZX_LSP_BASE + 0x1000)
#define ZX_PS_RM_TIMER_BASE     			(ZX_LSP_BASE + 0xB000)

#define ZX_DDR_CTRL_BASE                    (ZX_IRAM1_BASE + 0x50000)
#define ZX_DDR_PHY_BASE     				(ZX_DDR_CTRL_BASE + 0x4000)
#define ZX_DDR_FFC_BASE     				(ZX_AHB_CFG_BASE + 0x5000)

#define ZX_EDCP_BASE       					(ZX_AHB_CFG_BASE)
#define ZX_SD0_BASE       					(ZX_AHB_CFG_BASE + 0x10000)
#define ZX_SD1_BASE       					(ZX_AHB_CFG_BASE + 0x11000)
#define ZX_NAND_REG_BASE      				(ZX_AHB_CFG_BASE + 0x14000)
#define ZX_NAND_DATA_BASE     				(ZX_AHB_CFG_BASE + 0x15000)
/*#define ZX_DDR_CTRL_BASE     				(ZX_AHB_CFG_BASE + 0x16000)*/
/*#define ZX_DDR_PHY_BASE     				(ZX_AHB_CFG_BASE + 0x1A000)*/
#define ZX_EFUSE_BASE     					(ZX_AHB_CFG_BASE + 0x1B000)
#define ZX_RSA_BASE     					(ZX_AHB_CFG_BASE + 0x1C000)
#define ZX_HASH_BASE     					(ZX_AHB_CFG_BASE + 0x1D000)

#define ZX_DMA_PHY_BASE       				(ZX_APB_CFG_BASE)
#define ZX_DMA_PS_BASE       				(ZX_APB_CFG_BASE + 0x1000)
#define ZX_ICP_BASE       					(ZX_APB_CFG_BASE + 0x2000)
#define ZX_PIN_MUX_BASE       				(ZX_APB_CFG_BASE + 0x3000)
#define ZX_SSC_BASE         				(ZX_APB_CFG_BASE + 0x4000)
#define ZX_MATRIX_CRM_BASE       			(ZX_APB_CFG_BASE + 0x6000)//STD_CRM
#define ZX_GMAC_BASE       					(ZX_APB_CFG_BASE + 0x7000)
#define ZX_VOU_CFG_BASE       				(ZX_APB_CFG_BASE + 0x80000)

#define ZX_LSP_CRPM_BASE       				(ZX_LSP_BASE)
#define ZX_PS_WDT_BASE       				(ZX_LSP_BASE + 0x3000)
#define ZX_I2S0_BASE       					(ZX_LSP_BASE + 0x5000)
#define ZX_I2S1_BASE       					(ZX_LSP_BASE + 0x6000)
#define ZX_SPIFC0_BASE       				(ZX_LSP_BASE + 0x7000)
#define ZX_UART1_BASE       				(ZX_LSP_BASE + 0x8000)
#define ZX_I2C1_BASE       					(ZX_LSP_BASE + 0x9000)
#define ZX_SSP0_BASE       					(ZX_LSP_BASE + 0xA000)
#define ZX_UART2_BASE       				(ZX_LSP_BASE + 0xD000)
#define ZX_AP_WDT_BASE       				(ZX_LSP_BASE + 0xE000)
#define ZX_AP_TIMER0_BASE       			(ZX_LSP_BASE + 0xF000)
#define ZX_SSP1_BASE       					(ZX_LSP_BASE + 0x10000)
#define ZX_AP_TIMER4_BASE       			(ZX_LSP_BASE + 0x11000)
#define ZX_TDM_BASE       					(ZX_LSP_BASE + 0x12000)

#define GIC_DIST_BASE  						(ZX_GIC_BASE)
#define GIC_REDIST_BASE   					(ZX_GIC_BASE + 0x40000)

#define AP_PMU_COUNTER_BASE   				(ZX_AP_PERIPHERAL_BASE)
#define AP_PROBE_BASE   					(ZX_AP_PERIPHERAL_BASE + 0x10000)
#define AP_CRM_BASE   						(ZX_AP_PERIPHERAL_BASE + 0x2000)


/**************************************************************************************
 *                        physical address (need map)                         
 **************************************************************************************/
#define ZX29_GIC_PHYS    				(0xF2000000)					/*2MB*/
#define ZX29_AP_PERIPHERAL_PHYS     	(0xF2200000)					/*1MB*/
#define ZX29_GICC_PHYS    			    (0x02900000)					/*1MB*/

#define ZX29_IRAM0_PHYS        	    	(0x82000000)					/*128KB*/
#define ZX29_IRAM1_PHYS        	    	(0x100000)						/*64KB*/
#define ZX29_IRAM2_PHYS        	    	(0x80000)						/*64KB*/
#define ZX29_A1_PHYS        			(0x130000)						/*128KB*/
#define ZX29_LPM_PHYS                   (0x134000)
#define ZX29_PAD_CTRL_PHYS      		(0x13C000)
#define ZX29_GPIO0_PHYS      			(0x13D000)
#define ZX29_SOC_SYS_PHYS   			(0x140000)
#define ZX29_AHB_CFG_PHYS       		(0x1200000)						/*1MB*/
/*change by gsn, here is realy usb controller, not phy*/
#define ZX29_USB_PHYS       	   	    (0x1500000)						/*256KB*/
#define ZX29_USB_GLOBAL_REG		        ZX29_USB_PHYS					/*1KB*/
#define ZX29_USB_HOST_REG		        (ZX29_USB_PHYS + 0X400)			/*1KB*/
#define ZX29_USB_DEVICE_REG		      	(ZX29_USB_PHYS + 0x800)			/*1.5KB*/
#define ZX29_USB_PWR_CLK_REG 		   	(ZX29_USB_PHYS + 0xE00)			/*0.5KB*/
#define ZX29_HSIC_PHYS                 	(0x1600000)						/*256KB*/
/*#define ZX297520_HSIC_PHYS       			ZX297520V3_HSIC_PHYS*/
#define ZX29_APB_CFG_PHYS       		(0x1300000)						/*1MB*/
#define ZX29_LSP_PHYS       			(0x1400000)						/*1MB*/

#define ZX29_I2S0_PHYS       		    (0x01405000)
#define ZX29_I2S1_PHYS       		    (0x01406000)
#define ZX29_TDM_PHYS       		    (0x01412000)
#define ZX29_UART0_PHYS       	     	        (0x131000)
#define ZX29_UART1_PHYS          	  	     	(0x01408000)
#define ZX29_UART2_PHYS          	  	     	(0x0140d000)
#define ZX29_SSP0_PHYS               (0x0140a000)
#define ZX29_SSP1_PHYS               (0x01410000)
#define ZX29_SPIFC0_PHYS       		(ZX29_LSP_PHYS+0x7000)

#define ZX29_GSM_CFG_PHYS      			(0xF3000000)
#define ZX29_GSM_MODEM_PHYS   			(0xF4000000)
#define ZX29_DDR_PHYCODE_PHYS       		(DDR_BASE_PHYCODE_ADDR_PA)
#define ZX29_DDR_MODEM_PHYS        		(DDR_BASE_MODEM_ADDR_PA)
#define ZX29_DDR_CAPBUF_PHYS            (DDR_BASE_CAPBUF_ADDR_PA)

#ifdef CONFIG_MEM_TRACKER
#define ZX29_MEM_TRACKER_PHYS 				(0x25400000)
#define ZX29_KMALLOC_TRACKER_PHYS 			(0x25600000)
#endif

/**************************************************************************************
 *                        iram: icp/spinlock/poweron_type
 **************************************************************************************/
#define ZX_RPMSG_DDR_BASE 					(ICP_MEM_BASE)//(0x25500000)	/* 1M */

#define ZX29_ICP_APM0_REG 					(ZX_ICP_BASE + 0x188)
#define ZX29_ICP_APM0_REG_SIZE 				SZ_1K

#define ZX29_ICP_PSAP_REG 					(ZX_ICP_BASE + 0xc8)
#define ZX29_ICP_PSAP_REG_SIZE 				SZ_1K

#define ZX29_ICP_APPS_REG 					(ZX_ICP_BASE + 0xf8)
#define ZX29_ICP_APPS_REG_SIZE 				SZ_1K

#define ZX29_ICP_APPHY_REG 					(ZX_ICP_BASE + 0x128)
#define ZX29_ICP_APPHY_REG_SIZE 			SZ_1K

#define ICP_IRAM_BASE 						(ZX_IRAM0_BASE + 0x400)	/* TBD, total 12K */

#define ICP_MSG_MODEM_SIZE          		(0x1400)      /* just for ARM0 & ARM1 & M0 communication */
#define ICP_IRAM_AP_BASE  					(ICP_IRAM_BASE + ICP_MSG_MODEM_SIZE) /* for AP&M0&PS */ 
#define SPINLOCK_SOFTLOCK_BASE 				(ICP_IRAM_BASE + 0x25C0)
#define DMA_PUB_CONFIG_BASE 				(SPINLOCK_SOFTLOCK_BASE + 0x100)
#define POWERON_TYPE_BASE 					(SPINLOCK_SOFTLOCK_BASE + 0x200)	/* 0x40 bytes */

#define SECURE_PUK_BASE						(POWERON_TYPE_BASE + 0xc)/*secure pub key 256byte*/
#define WDT_IRAM_BASE						(SECURE_PUK_BASE + 0x100)/*wdt iram flag 36byte*/
//youchen@2024-06-20 add for lynq nv config begin
//#define MMC_CFG_BASE						(WDT_IRAM_BASE+0x34)/*mmc flag 4Byte*/
#define MMC_LYNQ_NV_CFG_ADDR				(WDT_IRAM_BASE+0x34)/*mmc flag 1024Byte*/
#define MMC_LYNQ_NV_CFG_SIZE				(0x100UL)
//youchen@2024-06-20 add for lynq nv config end
//
/**************************************************************************************
 *                        iram: tsc
 **************************************************************************************/

/* 1K?????y?Y??  */
#define IRAM_TSC_BASE              (ZX_IRAM0_BASE + 0x00004800)
#define IRAM__LEN_TPC              ((1 * 1024UL))
#endif

