/*
 * arch/arm/mach-zx297520v2/include/mach/irqs.h
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

union gic_base {
	void __iomem *common_base;
	void __percpu __iomem **percpu_base;
};

struct gic_chip_data {
	union gic_base dist_base;
	union gic_base cpu_base;
#ifdef CONFIG_CPU_PM
	u32 saved_spi_enable[DIV_ROUND_UP(1020, 32)];
	u32 saved_spi_conf[DIV_ROUND_UP(1020, 16)];
	u32 saved_spi_target[DIV_ROUND_UP(1020, 4)];
	u32 __percpu *saved_ppi_enable;
	u32 __percpu *saved_ppi_conf;
#endif
	struct irq_domain *domain;
	unsigned int gic_irqs;
};


/* 0-15:  SGI (software generated interrupts)
 * 16-31: PPI (private peripheral interrupts)
 * 32+:   SPI (shared peripheral interrupts)
 */

#define GIC_PPI_START 16
#define GIC_SPI_START 32

/*
 * software generated interrupts
 */
#define SGI0_INT  					(0)
#define SGI1_INT    				(1)
#define SGI2_INT    				(2)
#define SGI3_INT    				(3)
#define SGI4_INT    				(4)
#define SGI5_INT    				(5)
#define SGI6_INT					(6)
#define SGI7_INT					(7)
#define SGI8_INT					(8)
#define SGI9_INT					(9)
#define SGI10_INT					(10)
#define SGI11_INT					(11)
#define SGI12_INT					(12)
#define SGI13_INT					(13)
#define SGI14_INT					(14)
#define SGI15_INT					(15)

/*
 * private peripheral interrupts
 */
#define IRQ_CT_PMU_CPU0				(23)  
#define GLOBAL_TIMER_INT       		(27)
#define LEGACY_FIQ_INT        		(28)
#define PRIVATE_TIMER_INT      		(29)
#define PRIVATE_WDT_INT        		(30)
#define LEGACY_IRQ_INT         		(31)
 
/*
 * shared peripheral interrupts
 */
#ifndef CONFIG_ARCH_ZX297520V3_CAP
#define WDT_INT						(GIC_SPI_START+76)
#define UART0_MIX_INT				(GIC_SPI_START+0)
#define UART1_MIX_INT				(GIC_SPI_START+1)
#define UART2_MIX_INT				(GIC_SPI_START+2)
#define SSP0_INT					(GIC_SPI_START+3)
#define SYS_COUNTER_INT				(GIC_SPI_START+4)
#define RTC_ALARM_INT				(GIC_SPI_START+5)
#define RTC_TIMER_INT				(GIC_SPI_START+6)
#define I2S0_INT					(GIC_SPI_START+7)
#define I2S1_INT					(GIC_SPI_START+8)
#define USIM1_INT					(GIC_SPI_START+9)
#define I2C1_INT					(GIC_SPI_START+10)
#define I2C0_INT					(GIC_SPI_START+11)	/*pmic i2c*/
#define KEYPAD_INT					(GIC_SPI_START+12)
#define SD1_INT						(GIC_SPI_START+13)
#define WLAN_PRIORITY_POS_INT		(GIC_SPI_START+14)
#define WLAN_PRIORITY_NEG_INT		(GIC_SPI_START+15)
#define SD0_INT						(GIC_SPI_START+16)
#define ICP_PHY2PS_INT				(GIC_SPI_START+17)/*ICP_PHY2PS_INT*/

#define ICP_M02PS_INT				(GIC_SPI_START+18)/*ICP_M02PS_INT*/
#define PS_TIMER0_INT				(GIC_SPI_START+19)/*PS_TIMER0_INT*/
#define PS_TIMER1_INT				(GIC_SPI_START+20)/*PS_TIMER1_INT*/
#define PS_RM_TIMER_INT				(GIC_SPI_START+21)/*PS_RM_TIMER_INT*/
#define GSM_RFSSCR_INT				(GIC_SPI_START+22)
#define GSM_RFSSCT_INT				(GIC_SPI_START+23)
#define GSM_GP0_INT					(GIC_SPI_START+24)
#define GSM_T_INT					(GIC_SPI_START+25)
#define GSM_TL_INT					(GIC_SPI_START+26)
#define GPRS0_INT					(GIC_SPI_START+27)
#define GPRS1_INT					(GIC_SPI_START+28)
#define DSP0_INT					(GIC_SPI_START+29)
#define DSP1_INT					(GIC_SPI_START+30)
#define DSP2_INT					(GIC_SPI_START+31)
#define DSP3_INT					(GIC_SPI_START+32)
#define DSP4_INT					(GIC_SPI_START+33)
#define DSP6_INT					(GIC_SPI_START+34)
#define DSP7_INT					(GIC_SPI_START+35)
#define SPCU_PW_INT					(GIC_SPI_START+36)
#define ROUT1_INT					(GIC_SPI_START+37)
#define PS_DMA_INT					(GIC_SPI_START+38)
#define PHY_DMA_INT					(GIC_SPI_START+39)
#define NAND_INT                    (GIC_SPI_START+40)
#define USB_INT						(GIC_SPI_START+41)
#define USB_POWERDWN_UP_INT  		(GIC_SPI_START+42)
#define USB_POWERDWN_DOWN_INT 		(GIC_SPI_START+43)
#define HSIC_INT					(GIC_SPI_START+44)
#define HSIC_POWERDWN_UP_INT  		(GIC_SPI_START+45)
#define HSIC_POWERDWN_DOWN_INT 		(GIC_SPI_START+46)

#define GSM_USIM_INT				(GIC_SPI_START+48)

#define EX8IN1_INT					(GIC_SPI_START+51)
#define EX0_INT						(GIC_SPI_START+52)
#define EX1_INT						(GIC_SPI_START+53)
#define EX2_INT						(GIC_SPI_START+54)
#define EX3_INT						(GIC_SPI_START+55)
#define EX4_INT						(GIC_SPI_START+56)
#define EX5_INT						(GIC_SPI_START+57)
#define EX6_INT						(GIC_SPI_START+58)
#define EX7_INT						(GIC_SPI_START+59)
#define SSC_CONGLICT_INT			(GIC_SPI_START+60)
#define TD_LPM_TIMER_IND3_INT		(GIC_SPI_START+61)
#define TD_LPM_FRM_INT				(GIC_SPI_START+62)
#define FRM_ARM_INT					(GIC_SPI_START+63)
#define LTE_LPM_TIMER2_INT			(GIC_SPI_START+64)
#define LTE_LPM_TIMER4_INT			(GIC_SPI_START+65)
#define LTE_LPM_TIMER5_INT 			(GIC_SPI_START+66)
#define GSM_LPM_INT1_INT 			(GIC_SPI_START+67)
#define LTE_TPU_INT_PS_INT 			(GIC_SPI_START+68)
#define WD_LPM_TIMER4_INT 			(GIC_SPI_START+69)
#define WD_FRAME_INT				(GIC_SPI_START+70)
#define EDCP_INT					(GIC_SPI_START+71)

#define SD1_DATA1_INT				(GIC_SPI_START+72)
#define UART0_RXD_INT				(GIC_SPI_START+73)
#define SPI_FC0_INT					(GIC_SPI_START+74)	/*spi nand*/
#define PS_TIMER2_INT     			(GIC_SPI_START+75)
#define ICP_AP2PS_INT				(GIC_SPI_START+77)/*ICP_AP2PS_INT*/
#define SSP1_INT					(GIC_SPI_START+78)
#define SD0_DATA1_INT				(GIC_SPI_START+79)
//#define EFUSE_INT					(GIC_SPI_START+58)
//#define RSA_INT						(GIC_SPI_START+59)
//#define HASH_INT					(GIC_SPI_START+60)
//#define GMAC_INT					(GIC_SPI_START+61)
//#define AP_TIMER3_INT				(GIC_SPI_START+62)
//#define AP_TIMER4_INT				(GIC_SPI_START+63)

//#define MCU_LCD_INT					(GIC_SPI_START+67)
//#define VOU_OSD_INT					(GIC_SPI_START+68)
#define TDM_INT						(GIC_SPI_START+80)
#define PHY_TIMER0_INT				(GIC_SPI_START+81)
#define PHY_TIMER1_INT				(GIC_SPI_START+82)
#define TDMODEM_INT0_INT			(GIC_SPI_START+83)
#define TDMODEM_INT1_INT			(GIC_SPI_START+84)
#define TDMODEM_INT2_INT			(GIC_SPI_START+85)
#define LTEMODEM_INT0_INT			(GIC_SPI_START+86)
#define LTEMODEM_INT1_INT			(GIC_SPI_START+87)
#define LTEMODEM_INT2_INT			(GIC_SPI_START+88)
#define WDMODEM_INT0_INT			(GIC_SPI_START+89)
#define WDMODEM_INT1_INT			(GIC_SPI_START+90)
#define WDMODEM_INT2_INT			(GIC_SPI_START+91)
#define TD_LPM_TIMER_IND2_INT		(GIC_SPI_START+92)
#define LTE_LPM_TIMER1_INT			(GIC_SPI_START+93)
#define WD_LPM_TIMER3_INT			(GIC_SPI_START+94)
#define EDCP_PHY_INT				(GIC_SPI_START+95)




//#define RESERVED_INT				(GIC_SPI_START+70)
//#define PWM_INT						(GIC_SPI_START+72)
//#define GMACPHY_WAKE_INT			(GIC_SPI_START+73)
//#define GMACPHY_INT					(GIC_SPI_START+74)

#define NR_SOC_IRQS 				(GIC_SPI_START+96)

#else
#define WDT_INT						(GIC_SPI_START+0)
#define UART0_MIX_INT				(GIC_SPI_START+1)
#define UART2_MIX_INT				(GIC_SPI_START+2)
#define SSP0_INT					(GIC_SPI_START+3)
#define RTC_ALARM_INT				(GIC_SPI_START+4)
#define RTC_TIMER_INT				(GIC_SPI_START+5)
#define I2S0_INT					(GIC_SPI_START+6)
#define I2S1_INT					(GIC_SPI_START+7)
#define I2C1_INT					(GIC_SPI_START+8)
#define I2C0_INT					(GIC_SPI_START+9)	/*pmic i2c*/
#define KEYPAD_INT					(GIC_SPI_START+10)
#define SD1_INT						(GIC_SPI_START+11)
#define SD0_INT						(GIC_SPI_START+12)
#define ICP_PS2AP_INT				(GIC_SPI_START+13)
#define ICP_M02AP_INT				(GIC_SPI_START+14)
#define AP_TIMER0_INT				(GIC_SPI_START+15)
#define AP_TIMER1_INT				(GIC_SPI_START+16)
#define AP_TIMER2_INT				(GIC_SPI_START+17)
#define GSM_RFSSCR_INT				(GIC_SPI_START+18)
#define GSM_RFSSCT_INT				(GIC_SPI_START+19)
#define GSM_GP0_INT					(GIC_SPI_START+20)
#define GSM_T_INT					(GIC_SPI_START+21)
#define GSM_TL_INT					(GIC_SPI_START+22)
#define GPRS0_INT					(GIC_SPI_START+23)
#define GPRS1_INT					(GIC_SPI_START+24)
#define DSP0_INT					(GIC_SPI_START+25)
#define DSP1_INT					(GIC_SPI_START+26)
#define DSP2_INT					(GIC_SPI_START+27)
#define DSP3_INT					(GIC_SPI_START+28)
#define DSP4_INT					(GIC_SPI_START+29)
#define DSP6_INT					(GIC_SPI_START+30)
#define DSP7_INT					(GIC_SPI_START+31)
#define SPCU_PW_INT					(GIC_SPI_START+32)
#define ROUT1_INT					(GIC_SPI_START+33)
#define PS_DMA_INT					(GIC_SPI_START+34)
#define NAND_INT                    (GIC_SPI_START+35)
#define USB_INT						(GIC_SPI_START+36)
#define USB_POWERDWN_UP_INT  		(GIC_SPI_START+37)
#define USB_POWERDWN_DOWN_INT 		(GIC_SPI_START+38)
#define HSIC_INT					(GIC_SPI_START+39)
#define HSIC_POWERDWN_UP_INT  		(GIC_SPI_START+40)
#define HSIC_POWERDWN_DOWN_INT 		(GIC_SPI_START+41)
#define LTE_LPM_TIMER5_INT 			(GIC_SPI_START+42)
#define GSM_USIM_INT				(GIC_SPI_START+43)
#define EX8IN1_INT					(GIC_SPI_START+44)
#define EX0_INT						(GIC_SPI_START+45)
#define EX1_INT						(GIC_SPI_START+46)
#define EX2_INT						(GIC_SPI_START+47)
#define EX3_INT						(GIC_SPI_START+48)
#define EX4_INT						(GIC_SPI_START+49)
#define EX5_INT						(GIC_SPI_START+50)
#define EX6_INT						(GIC_SPI_START+51)
#define EX7_INT						(GIC_SPI_START+52)
#define SD1_DATA1_INT				(GIC_SPI_START+53)
#define UART0_RXD_INT				(GIC_SPI_START+54)
#define SPI_FC0_INT					(GIC_SPI_START+55)	/*spi nand*/
#define SSP1_INT					(GIC_SPI_START+56)
#define SD0_DATA1_INT				(GIC_SPI_START+57)
#define EFUSE_INT					(GIC_SPI_START+58)
#define RSA_INT						(GIC_SPI_START+59)
#define HASH_INT					(GIC_SPI_START+60)
#define GMAC_INT					(GIC_SPI_START+61)
#define AP_TIMER3_INT				(GIC_SPI_START+62)
#define AP_TIMER4_INT				(GIC_SPI_START+63)
#define FRM_ARM_INT					(GIC_SPI_START+64)
#define WD_FRAME_INT				(GIC_SPI_START+65)
#define ICP_PHY2AP_INT				(GIC_SPI_START+66)
#define MCU_LCD_INT					(GIC_SPI_START+67)
#define VOU_OSD_INT					(GIC_SPI_START+68)
#define TDM_INT						(GIC_SPI_START+69)
#define RESERVED_INT				(GIC_SPI_START+70)
#define SYS_COUNTER_INT				(GIC_SPI_START+71)
#define PWM_INT						(GIC_SPI_START+72)
#define GMACPHY_WAKE_INT			(GIC_SPI_START+73)
#define GMACPHY_INT					(GIC_SPI_START+74)
#define USIM1_INT					(GIC_SPI_START+75)
#define UART1_MIX_INT				(GIC_SPI_START+76)

#define NR_SOC_IRQS 				(GIC_SPI_START+77)
#endif

/*virtual external 8in1 interrupts*/
#define EX8IN1_INT_BASE             (NR_SOC_IRQS)
#define EX8_INT                     (EX8IN1_INT_BASE)
#define EX9_INT                     (EX8IN1_INT_BASE+1)
#define EX10_INT                    (EX8IN1_INT_BASE+2)
#define EX11_INT                    (EX8IN1_INT_BASE+3)
#define EX12_INT                    (EX8IN1_INT_BASE+4)
#define EX13_INT                    (EX8IN1_INT_BASE+5)
#define EX14_INT                    (EX8IN1_INT_BASE+6)
#define EX15_INT                    (EX8IN1_INT_BASE+7)
#define EX8IN1_INT_END             	(EX15_INT)


#ifndef MAX_GIC_NR
#define MAX_GIC_NR					(1)
#endif

#define ENT_ZX234290_IRQ_BASE		(EX8IN1_INT_END+1)
#define ENT_ZX234290_IRQ_END  		(ENT_ZX234290_IRQ_BASE+13)

#define	NR_IRQS						(ENT_ZX234290_IRQ_END+1)


bool irq_type_valid(unsigned int int_type);
void __init zx29_init_irq(void);
unsigned int zx29_gic_pending_interrupt(void);


#endif
