/*
 *  arch/arm/mach-zx297520v2/include/mach/memory.h
 *
 *  Copyright (C) 1996-1999 ZXIC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __ASM_ARCH_MEMORY_H
#define __ASM_ARCH_MEMORY_H

#define CPU_SHIFT 0
#include "ram_base_config_7520v3.h"

#ifdef CONFIG_SYSTEM_CAP

#define PLAT_PHYS_OFFSET	DDR_BASE_CAP_ADDR_PA

/*
 * ICP shared memeory
 */
#define ICP_MEM_BASE		ICP_CAP_BUF_ADDR//DDR_BASE_ADDR_AP_CP_SHAREBUF
#define ICP_MEM_SIZE		ICP_CAP_BUF_LEN

/* 2Kж̹߳켣 */
#define IRAM_BASE_ADDR_VA
#define IRAM_BASE_ADDR_LINUX_STATISTIC     ((unsigned long)ZX_IRAM0_BASE + 0x4C00)
#define IRAM_BASE_LEN_LINUX_STATISTIC      ((2 * 1024))

/* IRAM켣ַ */
#define IRAM_BASE_ADDR_LINUX_STATISTIC_APCPU   (IRAM_BASE_ADDR_LINUX_STATISTIC)
#define IRAM_BASE_LEN_LINUX_STATISTIC_APCPU    (0x200)
#define IRAM_BASE_ADDR_LINUX_STATISTIC_PHYCPU  (IRAM_BASE_ADDR_LINUX_STATISTIC + IRAM_BASE_LEN_LINUX_STATISTIC_APCPU)
#define IRAM_BASE_LEN_LINUX_STATISTIC_PHYCPU   (0x200)
#define IRAM_BASE_ADDR_LINUX_STATISTIC_PSCPU   (IRAM_BASE_ADDR_LINUX_STATISTIC + IRAM_BASE_LEN_LINUX_STATISTIC_PHYCPU)
#define IRAM_BASE_LEN_LINUX_STATISTIC_PSCPU    (0x400)

#else

/*
 * Physical DRAM offset.
 */
#ifndef CONFIG_SYSTEM_RECOVERY
#define PLAT_PHYS_OFFSET	DDR_BASE_AP_ADDR_PA
#else
#define PLAT_PHYS_OFFSET	DDR_BASE_ADDR
#endif
/* #define PLAT_PHYS_SIZE		DDR_BASE_LEN_AP */

/*
 * DMA shared memeory
 */
#define DMA_MEM_BASE		DDR_BASE_ADDR_DRV
#define DMA_MEM_SIZE		DDR_BASE_LEN_DRV

/*
 * ICP shared memeory
 */
#ifdef _USE_CAP_SYS
#define ICP_MEM_BASE		ICP_CAP_BUF_ADDR
#define ICP_MEM_SIZE		ICP_CAP_BUF_LEN
#endif

/*
 * Power management shared memeory
 */
#define PM_MEM_BASE		DDR_BASE_ADDR_PSM
#define PM_MEM_SIZE		DDR_BASE_LEN_PSM

/*
 * TOOLs shared memeory
 */
#define TOOL_MEM_BASE		DDR_BASE_ADDR_TOOL_ICP
#define TOOL_MEM_SIZE		DDR_BASE_LEN_TOOL_ICP

/* 2Kж̹߳켣 */
#define IRAM_BASE_ADDR_VA
#define IRAM_BASE_ADDR_LINUX_STATISTIC     ((unsigned long)ZX_IRAM0_BASE + 0x4C00)
#define IRAM_BASE_LEN_LINUX_STATISTIC      ((2 * 1024))

/* IRAM켣ַ */
#define IRAM_BASE_ADDR_LINUX_STATISTIC_PSCPU   (IRAM_BASE_ADDR_LINUX_STATISTIC)
#define IRAM_BASE_LEN_LINUX_STATISTIC_PSCPU    (0x200)
#define IRAM_BASE_ADDR_LINUX_STATISTIC_PHYCPU  (IRAM_BASE_ADDR_LINUX_STATISTIC_PSCPU + IRAM_BASE_LEN_LINUX_STATISTIC_PSCPU)
#define IRAM_BASE_LEN_LINUX_STATISTIC_PHYCPU   (0x200)
#define IRAM_BASE_ADDR_LINUX_STATISTIC_APCPU   (IRAM_BASE_ADDR_LINUX_STATISTIC_PHYCPU + IRAM_BASE_LEN_LINUX_STATISTIC_PHYCPU)
#define IRAM_BASE_LEN_LINUX_STATISTIC_APCPU    (0x400)
#define IRAM_BASE_ADDR_LINUX_SYS_TRACE         (IRAM_BASE_ADDR_LINUX_STATISTIC +  IRAM_BASE_LEN_LINUX_STATISTIC)
#define IRAM_BASE_LEN_LINUX_SYS_TRACE          (0x400)
#define IRAM_BASE_ADDR_LOG_DROP_TRACE          (IRAM_BASE_ADDR_LINUX_SYS_TRACE + IRAM_BASE_LEN_LINUX_SYS_TRACE - 0x40)

#endif

#endif

