/*
 * arch/arm/mach-zx297520v2/include/mach/pcu.h
 *
 *  Copyright (C) 2015 ZTE-TSP
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * NOTICE:
 * In zx29 platform, some interrupt lines pass through pcu, such as definition in PCU_INT_INDEX enumeration type. Whatever types of interrupt lines is, pcu will
 * adjust its to high level. additional, if type of interrupt source is pulse, pcu will lacth it to high level. So in ISR ,we need clear interrupt status in pcu by using 
 *            void pcu_int_clear(PCU_INT_INDEX index)
 * to avoid interrupt coming incessantly when interrupt was triggered only once.
 *
 * If gpio pin is configured to interrupt mode, pcu_int_clear(PCU_INT_INDEX index) need to be called too, because hardware can trigger a fake interrupt which is just 
 * a interference whatever there is interrupt on pin or not.
 * configure a gpio pin to interrupt mode should as follows:
 * first
 *            pcu_int_set_type(PCU_INT_INDEX index, unsigned int type);
 * then
 *            pcu_int_clear(PCU_INT_INDEX index);
 */
 
#ifndef _PCU_H
#define _PCU_H

/*int bit index which needs be clear in PCU*/

#ifndef CONFIG_ARCH_ZX297520V3_CAP
typedef enum{
	PCU_PS_RM_TIMER_INT	= 1,
	PCU_UART0_RXD_INT,	
	PCU_SD0_DATA1_INT,
	PCU_PS_TIMER1_INT,
	
	PCU_PS_TIMER2_INT,	
	PCU_ICP_AP2PS_INT,	
	PCU_USB_POWERDWN_UP_INT,
	PCU_USB_POWERDWN_DOWN_INT,
	PCU_HSIC_POWERDWN_UP_INT,
	
	/*10*/
	PCU_HSIC_POWERDWN_DOWN_INT,	
	PCU_ICP_PHY2PS_INT,	
	PCU_ICP_M02PS_INT,	
	PCU_RTC_ALARM_INT,
	PCU_RTC_TIMER_INT,	

	PCU_KEYPAD_INT,
	PCU_SD1_DATA1_INT,
	RESERVED0,
	PCU_SPCU_PW_INT,
	PCU_GSM_LPM_INT1_INT,
	
	/*20*/
	RESERVED1,
	PCU_WD_LPM_TIMER_IND2_INT,
	PCU_LTE_LPM_TIMER_IND1_INT,
	PCU_TD_LPM_TIMER_IND2_INT,
	PCU_TD_LPM_TIMER_IND3_INT,
	
	PCU_TD_LPM_TIMER_IND4_INT,
	PCU_LTE_LPM_TIMER_IND2_INT,
	PCU_LTE_LPM_TIMER_IND4_INT,
	PCU_LTE_LPM_TIMER_IND5_INT,
	PCU_WD_LPM_TIMER_IND3_INT,

	/*30*/
	PCU_WD_LPM_TIMER_IND4_INT,
	PCU_FRM_ARM_32K_INT,
	RESERVED2,
	RESERVED3,	
	PCU_EX0_INT,
	
	PCU_EX1_INT,
	PCU_EX2_INT,
	PCU_EX3_INT,
	PCU_EX4_INT,
	PCU_EX5_INT,

	/*40*/	
	PCU_EX6_INT,
	PCU_EX7_INT,
	PCU_EX8_INT,
	PCU_EX9_INT,
	PCU_EX10_INT,
	
	PCU_EX11_INT,
	PCU_EX12_INT,
	PCU_EX13_INT,
	PCU_EX14_INT,
	PCU_EX15_INT,

	PCU_MAX_INT,
	PCU_UNKNOWN_INT = 0xff,

}PCU_INT_INDEX;

#else

typedef enum{
	PCU_AP_TIMER1_INT	= 0,
	PCU_AP_TIMER2_INT,
	PCU_ICP_PS2AP_INT,
	PCU_USB_POWERDWN_UP_INT,
	PCU_USB_POWERDWN_DOWN_INT,
	
	PCU_HSIC_POWERDWN_UP_INT,
	PCU_HSIC_POWERDWN_DOWN_INT,	
	PCU_ICP_M02AP_INT,	
	PCU_RTC_ALARM_INT,
	PCU_RTC_TIMER_INT,	

	/*10*/
	PCU_KEYPAD_INT,
	PCU_SD1_DATA1_INT,
	RESERVED,
	PCU_SPCU_PW_INT,
	PCU_EX0_INT,
	
	PCU_EX1_INT,
	PCU_EX2_INT,
	PCU_EX3_INT,
	PCU_EX4_INT,
	PCU_EX5_INT,

	/*20*/	
	PCU_EX6_INT,
	PCU_EX7_INT,
	PCU_EX8_INT,
	PCU_EX9_INT,
	PCU_EX10_INT,
	
	PCU_EX11_INT,
	PCU_EX12_INT,
	PCU_EX13_INT,
	PCU_EX14_INT,
	PCU_EX15_INT,

	/*30*/	
	PCU_SD0_DATA1_INT,
	PCU_ICP_PHY2AP_INT,	
	PCU_FRM_ARM_32K_INT,
	PCU_LTE_LPM_TIMER_IND5_INT,
	PCU_WD_LPM_TIMER_INT4_INT,
	
	PCU_UART0_RXD_INT,	
	PCU_GMAC_INT,
	PCU_GMACPHY_WAKE_INT,
	PCU_GMACPHY_INT,

	PCU_MAX_INT,
	PCU_UNKNOWN_INT = 0xff,

}PCU_INT_INDEX;
#endif

typedef enum _T_Pcu_CoreId
{
       CPU_M0 = 0,
       CPU_PS,
       CPU_AP,
       CPU_PHY,
       MAX_CPU
} T_Pcu_CoreId;



/* ap related registers */
#define ARM_AP_CONFIG_REG           (ZX_PCU_BASE + 0x0)
#define ARM_AP_SLEEP_TIME_REG       (ZX_PCU_BASE + 4*0x3C)
#define ARM_PS_CONFIG_REG           (ZX_PCU_BASE + 0x004)
#define ARM_PS_SLEEP_TIME_REG       (ZX_PCU_BASE + 4*0x33)

#define CORE_WFI_DELAY_REG          (ZX_PCU_BASE + 4*0x4)

#define PS_INT_WAKE_DIS_REG1        (ZX_PCU_BASE + 4*0xA)
#define PS_INT_WAKE_DIS_REG2        (ZX_PCU_BASE + 4*0xB)

#define AP_INT_WAKE_DIS_REG        	(ZX_PCU_BASE + 4*0xD)
#define M0_INT_WAKE_DIS_REG        	(ZX_PCU_BASE + 4*0xE)
#define PCU_INT_TYPE_REG1           (ZX_PCU_BASE + 4*0xF)
#define PCU_INT_TYPE_REG2           (ZX_PCU_BASE + 4*0x10)
#define PCU_INT_TYPE_REG3           (ZX_PCU_BASE + 4*0x11)
#define PCU_INT_TYPE_REG4           (ZX_PCU_BASE + 4*0x12)
#define PCU_INT_POLARITY_REG1       (ZX_PCU_BASE + 4*0x13)
#define PCU_INT_POLARITY_REG2       (ZX_PCU_BASE + 4*0x14)
#define PCU_INT_POLARITY_REG3       (ZX_PCU_BASE + 4*0x15)
#define PCU_INT_POLARITY_REG4       (ZX_PCU_BASE + 4*0x16)
#define PCU_INT_CLEAR_REG1          (ZX_PCU_BASE + 4*0x17)
#define PCU_INT_CLEAR_REG2          (ZX_PCU_BASE + 4*0x18)
#define PCU_INT_CLEAR_REG3          (ZX_PCU_BASE + 4*0x19)
#define PCU_INT_CLEAR_REG4          (ZX_PCU_BASE + 4*0x1A)

#define CORE_SWITCH_CONFIG_REG    	(ZX_PCU_BASE + 4*0x2b)
#define CORE_SW_CONFIG_REG1    		(ZX_PCU_BASE + 4*0x2e)
#define CORE_SW_CONFIG_REG2    		(ZX_PCU_BASE + 4*0x2f)

#define PLL_STATUS_READ_REG    		(ZX_PCU_BASE + 4*0x35)
#define DEBUG_SEL_CONFIG_REG    	(ZX_PCU_BASE + 4*0x40)
#define DEBUG_SIGNAL_READ_REG0    	(ZX_PCU_BASE + 4*0x1F5)
#define DEBUG_SIGNAL_READ_REG1    	(ZX_PCU_BASE + 4*0x1F6)
#define DEBUG_SIGNAL_READ_REG2    	(ZX_PCU_BASE + 4*0x1F7)

#ifndef CONFIG_ARCH_ZX297520V3_CAP
#define EX_INT_TOP_CLEAR_REG		(ZX_PCU_BASE + 4*0x46)
#define EX_INT_VECTOR_REG			(ZX_PCU_BASE + 4*0x47)
#else
#define EX_INT_TOP_CLEAR_REG		(ZX_PCU_BASE + 4*0x4A)
#define EX_INT_VECTOR_REG			(ZX_PCU_BASE + 4*0x4B)
#endif

#define PCU_INT_M_READOUT_REG0		(ZX_PCU_BASE + 4*0x1E8)
#define PCU_INT_M_READOUT_REG1		(ZX_PCU_BASE + 4*0x1E9)
#define PCU_INT_M_READOUT_REG2		(ZX_PCU_BASE + 4*0x1EA)
#define PCU_INT_READOUT_REG1		(ZX_PCU_BASE + 4*0x1EB)
#define PCU_INT_READOUT_REG2		(ZX_PCU_BASE + 4*0x1EC)
#define PCU_INT_READOUT_REG3		(ZX_PCU_BASE + 4*0x1ED)


/*ARM_AP_CONFIG_REG*/
#define	PCU_SLEEP_MODE				(1U << 0)
#define	PCU_POWEROFF_MODE			(1U << 1)
#define	PCU_L2_CLK_GATE				(1U << 2)		/*1-can turn off*/
#define PCU_SLEEP_2M0               (1U << 3)
#define	PCU_SLEEP_DONE_BYPASS		(1U << 4)	 	
#define	PCU_SW_CONFIG_MASK			(1U << 5)	 	/* ?????  */

#define	PCU_MODE_MASK				(0x3U << 0)

/*ARM_AP_SLEEP_TIME_REG*/
#define	PCU_AP_SLEEP_TIME_DIS       (1U << 31)

/*debug config*/
#define	PCU_DEBUG_CONFIG_AP       	(0)			/* bit 1/0 */

#define	PCU_DEBUG_HIGH_PINS       	(0U << 2)	/* bit2 1--debug low 16 bit  for there are total 16 debug pins , 
                                                   but we will use them to debug 32 signals */
#define	PCU_DEBUG_LOW_PINS       	(1U << 2)
                                                   

#ifndef CONFIG_ARCH_ZX297520V3_CAP
/*PS_INT_*/
//#define WAKE_SRC_AP_TIMER1         	(1U << 0)
#define WAKE_SRC_PS_RM_TIMER      	(1U << 1)
#define WAKE_SRC_UART0_RXD     		(1U << 2)
#define WAKE_SRC_SD0_DATA1   		(1U << 3)
#define WAKE_SRC_PS_TIMER1			(1U << 4)
#define WAKE_SRC_PS_TIMER2   		(1U << 5)
#define WAKE_SRC_ICP_AP2PS 			(1U << 6)
#define WAKE_SRC_USB_POWERDWN_UP    (1U << 7)
#define WAKE_SRC_USB_POWERDWN_DOWN  (1U << 8)
#define WAKE_SRC_HSIC_POWERDWN_UP   (1U << 9)
#define WAKE_SRC_HSIC_POWERDWN_DOWN (1U << 10)
#define WAKE_SRC_ICP_PHY2PS 		(1U << 11)
#define WAKE_SRC_ICP_M02PS     		(1U << 12)
#define WAKE_SRC_RTC_ALARM     		(1U << 13)
#define WAKE_SRC_RTC_TIMER          (1U << 14)
#define WAKE_SRC_KEYPAD          	(1U << 15)
#define WAKE_SRC_SD1_DATA1          (1U << 16)
//#define WAKE_SRC_EXTERNAL3          (1U << 17)
#define WAKE_SRC_SPCU_PW          	(1U << 18)
#define WAKE_SRC_GSM_LPM_INT1       (1U << 19)
//#define WAKE_SRC_EXTERNAL6          (1U << 20)
#define WAKE_SRC_WD_LPM_TIMER_IND2  (1U << 21)
#define WAKE_SRC_LTE_LPM_TIMER_IND1	(1U << 22)
#define WAKE_SRC_TD_LPM_TIMER_IND2	(1U << 23)
#define WAKE_SRC_TD_LPM_TIMER_IND3	(1U << 24)
#define WAKE_SRC_TD_LPM_TIMER_IND4	(1U << 25)
#define WAKE_SRC_LTE_LPM_TIMER_IND2	(1U << 26)
#define WAKE_SRC_LTE_LPM_TIMER_IND4	(1U << 27)
#define WAKE_SRC_LTE_LPM_TIMER_IND5	(1U << 28)
#define WAKE_SRC_WD_LPM_TIMER_IND3	(1U << 29)
#define WAKE_SRC_WD_LPM_TIMER_IND4	(1U << 30)
#define WAKE_SRC_FRM_ARM_32K		(1U << 31)
#else
/*AP_INT_*/
#define WAKE_SRC_AP_TIMER1         	(1U << 0)
#define WAKE_SRC_AP_TIMER2      	(1U << 1)
#define WAKE_SRC_ICP_PS2AP     		(1U << 2)
#define WAKE_SRC_USB_POWERDWN_UP   	(1U << 3)
#define WAKE_SRC_USB_POWERDWN_DOWN  (1U << 4)
#define WAKE_SRC_HSIC_POWERDWN_UP   (1U << 5)
#define WAKE_SRC_HSIC_POWERDWN_DOWN (1U << 6)
#define WAKE_SRC_ICP_M02AP          (1U << 7)
#define WAKE_SRC_RTC_ALARM          (1U << 8)
#define WAKE_SRC_RTC_TIMER      	(1U << 9)
#define WAKE_SRC_KEYPAD   			(1U << 10)
#define WAKE_SRC_SD1_DATA1 			(1U << 11)
#define WAKE_SRC_RESERVED     		(1U << 12)
#define WAKE_SRC_SPCU_PW     		(1U << 13)
#define WAKE_SRC_EXTERNAL0          (1U << 14)
#define WAKE_SRC_EXTERNAL1          (1U << 15)
#define WAKE_SRC_EXTERNAL2          (1U << 16)
#define WAKE_SRC_EXTERNAL3          (1U << 17)
#define WAKE_SRC_EXTERNAL4          (1U << 18)
#define WAKE_SRC_EXTERNAL5          (1U << 19)
#define WAKE_SRC_EXTERNAL6          (1U << 20)
#define WAKE_SRC_EXTERNAL7          (1U << 21)
#define WAKE_SRC_EXTERNAL8			(1U << 22)
#define WAKE_SRC_EXTERNAL9			(1U << 23)
#define WAKE_SRC_EXTERNAL10			(1U << 24)
#define WAKE_SRC_EXTERNAL11			(1U << 25)
#define WAKE_SRC_EXTERNAL12			(1U << 26)
#define WAKE_SRC_EXTERNAL13			(1U << 27)
#define WAKE_SRC_EXTERNAL14			(1U << 28)
#define WAKE_SRC_EXTERNAL15			(1U << 29)
#define WAKE_SRC_SD0_DATA1     		(1U << 30)
#define WAKE_SRC_ICP_PHY2AP     	(1U << 31)
#endif

/*external  interrupt function */
void pcu_int_clear(PCU_INT_INDEX index);
void pcu_int_set_type(PCU_INT_INDEX index, unsigned int type);
void pcu_irq_wakeup(PCU_INT_INDEX index, int enable);
unsigned int pcu_get_8in1_int_source(void);

/**
 * pcu_CoreIsActive
 * 
 * 
 */
int pcu_CoreIsActive(T_Pcu_CoreId core);

/* low power function */
void __init pcu_init(void);
void __init pm_pcu_init(void);
extern void pm_set_pcu_poweroff(u32 sleep_time);
extern void pm_set_pcu_sleep(u32 sleep_time);
extern void pm_clear_pcu(void);
extern unsigned int pcu_get_wakeup_setting(void);
extern int pcu_set_irq_wake(unsigned gic, unsigned on);
extern int pcu_set_irq_type(unsigned gic, unsigned int type);
extern int pcu_clr_irq_pending(unsigned gic);
	
#endif
