/*
 * arch/arm/mach-zx297502/include/mach/spi.h
 *
 * Copyright (C) 2013 ZTE-TSP
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#ifndef ZX29_SPI_H
#define ZX29_SPI_H

#include <linux/types.h>


#define SPI_CLK_SRC_26M			(26 * 1000 * 1000)
#define SPI_CLK_SRC_104M		(104 * 1000 * 1000)
#define SPI_CLK_SRC_156M		(156 * 1000 * 1000)

/*SPI  gpio*/
#define SPI_CS_GPIONUM  2// GPIO_1v8_PIN2
#define SPI_CLK_GPIONUM 3//GPIO_1v8_PIN3
#define SPI_RXD_GPIONUM  4//GPIO_1v8_PIN4
#define SPI_TXD_GPIONUM  5//GPIO_1v8_PIN5

#define GPIO_AP_SPI0_CS   ZX29_GPIO_25
#define GPIO_AP_SPI0_CLK  ZX29_GPIO_26
#define GPIO_AP_SPI0_RXD  ZX29_GPIO_27
#define GPIO_AP_SPI0_TXD  ZX29_GPIO_28


#define GPIO_AP_SPI0_CS_FUN 	GPIO25_SSP0_CS
#define GPIO_AP_SPI0_CLK_FUN 	GPIO26_SSP0_CLK
#define GPIO_AP_SPI0_RXD_FUN 	GPIO27_SSP0_RXD
#define GPIO_AP_SPI0_TXD_FUN 	GPIO28_SSP0_TXD


#define GPIO_AP_CS_GPIO_FUN 	GPIO25_GPIO25
#define GPIO_AP_CLK_GPIO_FUN 	GPIO26_GPIO26
#define GPIO_AP_RXD_GPIO_FUN 	GPIO27_GPIO27
#define GPIO_AP_TXD_GPIO_FUN 	GPIO28_GPIO28

#define GPIO_AP_SPI1_CS   		ZX29_GPIO_87
#define GPIO_AP_SPI1_CLK  		ZX29_GPIO_88
#define GPIO_AP_SPI1_RXD  		ZX29_GPIO_89
#define GPIO_AP_SPI1_TXD  		ZX29_GPIO_90


#define GPIO_AP_SPI1_CS_FUN 	GPIO87_CAM_SPI_CS
#define GPIO_AP_SPI1_CLK_FUN 	GPIO88_CAM_SPI_CLK
#define GPIO_AP_SPI1_RXD_FUN 	GPIO89_CAM_SPI_DATA0
#define GPIO_AP_SPI1_TXD_FUN 	GPIO90_CAM_SPI_TXD

#define GPIO_AP_CS1_GPIO_FUN 	GPIO87_GPIO87

/**
 * whether SPI is in loopback mode or not
 */
enum spi_loopback {
	LOOPBACK_DISABLED,
	LOOPBACK_ENABLED
};

/**
 * enum ssp_interface - interfaces allowed for this SSP Controller
 * @SSP_INTERFACE_MOTOROLA_SPI: Motorola Interface
 * @SSP_INTERFACE_TI_SYNC_SERIAL: Texas Instrument Synchronous Serial
 * interface
 * @SSP_INTERFACE_NATIONAL_MICROWIRE: National Semiconductor Microwire
 * interface
 * @SSP_INTERFACE_UNIDIRECTIONAL: Unidirectional interface (STn8810
 * &STn8815 only)
 */
enum spi_interface {
	SPI_INTERFACE_MOTOROLA_SPI,
	SPI_INTERFACE_TI_SYNC_SERIAL,
};

/**
 * enum ssp_hierarchy - whether SSP is configured as Master or Slave
 */
enum spi_hierarchy {
	SPI_MASTER,
	SPI_SLAVE
};

/**
 * enum spi_data_size - number of bits in one data element
 */
enum spi_data_size {
	SPI_DATA_BITS_4 = 0x03, SPI_DATA_BITS_5, SPI_DATA_BITS_6,
	SPI_DATA_BITS_7, SPI_DATA_BITS_8, SPI_DATA_BITS_9,
	SPI_DATA_BITS_10, SPI_DATA_BITS_11, SPI_DATA_BITS_12,
	SPI_DATA_BITS_13, SPI_DATA_BITS_14, SPI_DATA_BITS_15,
	SPI_DATA_BITS_16, SPI_DATA_BITS_17, SPI_DATA_BITS_18,
	SPI_DATA_BITS_19, SPI_DATA_BITS_20, SPI_DATA_BITS_21,
	SPI_DATA_BITS_22, SPI_DATA_BITS_23, SPI_DATA_BITS_24,
	SPI_DATA_BITS_25, SPI_DATA_BITS_26, SPI_DATA_BITS_27,
	SPI_DATA_BITS_28, SPI_DATA_BITS_29, SPI_DATA_BITS_30,
	SPI_DATA_BITS_31, SPI_DATA_BITS_32
};

/**
 * enum ssp_mode - SSP mode of operation (Communication modes)
 */
enum spi_mode {
	INTERRUPT_TRANSFER,
	POLLING_TRANSFER,
	DMA_TRANSFER
};


/**
 * enum ssp_rx_level_trig - receive FIFO watermark level which triggers
 * IT: Interrupt fires when _N_ or more elements in RX FIFO.
 */
enum spi_rx_level_trig {
	SPI_RX_1_OR_MORE_ELEM,
	SPI_RX_4_OR_MORE_ELEM,
	SPI_RX_8_OR_MORE_ELEM,
	SPI_RX_16_OR_MORE_ELEM,
	SPI_RX_32_OR_MORE_ELEM
};

/**
 * Transmit FIFO watermark level which triggers (IT Interrupt fires
 * when _N_ or more empty locations in TX FIFO)
 */
enum spi_tx_level_trig {
	SPI_TX_1_OR_MORE_EMPTY_LOC,
	SPI_TX_4_OR_MORE_EMPTY_LOC,
	SPI_TX_8_OR_MORE_EMPTY_LOC,
	SPI_TX_16_OR_MORE_EMPTY_LOC,
	SPI_TX_32_OR_MORE_EMPTY_LOC
};

/**
 * enum SPI Clock Phase - clock phase (Motorola SPI interface only)
 * @SSP_CLK_FIRST_EDGE: Receive data on first edge transition (actual direction depends on polarity)
 * @SSP_CLK_SECOND_EDGE: Receive data on second edge transition (actual direction depends on polarity)
 */
enum spi_clk_phase {
	SPI_CLK_FIRST_EDGE,
	SPI_CLK_SECOND_EDGE
};

/**
 * enum SPI Clock Polarity - clock polarity (Motorola SPI interface only)
 * @SSP_CLK_POL_IDLE_LOW: Low inactive level
 * @SSP_CLK_POL_IDLE_HIGH: High inactive level
 */
enum spi_clk_pol {
	SPI_CLK_POL_IDLE_LOW,
	SPI_CLK_POL_IDLE_HIGH
};

/**
 * enum ssp_duplex - whether Full/Half Duplex on microwire, only
 * available in the ST Micro variant.
 * @SSP_MICROWIRE_CHANNEL_FULL_DUPLEX: SSPTXD becomes bi-directional,
 *     SSPRXD not used
 * @SSP_MICROWIRE_CHANNEL_HALF_DUPLEX: SSPTXD is an output, SSPRXD is
 *     an input.
 */
enum spi_duplex {
	SPI_MICROWIRE_CHANNEL_FULL_DUPLEX,
	SPI_MICROWIRE_CHANNEL_HALF_DUPLEX
};


struct dma_chan;
/**
 * struct pl022_ssp_master - device.platform_data for SPI controller devices.
 * @num_chipselect: chipselects are used to distinguish individual
 *     SPI slaves, and are numbered from zero to num_chipselects - 1.
 *     each slave has a chipselect signal, but it's common that not
 *     every chipselect is connected to a slave.
 * @enable_dma: if true enables DMA driven transfers.
 * @dma_rx_param: parameter to locate an RX DMA channel.
 * @dma_tx_param: parameter to locate a TX DMA channel.
 * @autosuspend_delay: delay in ms following transfer completion before the
 *     runtime power management system suspends the device. A setting of 0
 *     indicates no delay and the device will be suspended immediately.
 * @rt: indicates the controller should run the message pump with realtime
 *     priority to minimise the transfer latency on the bus.
 */
struct zx29_spi_controller {
	u16 bus_id;
	u8 num_chipselect;
	u8 enable_dma:1;
	bool (*dma_filter)(struct dma_chan *chan, void *filter_param);
	void *dma_rx_param;
	void *dma_tx_param;
	int autosuspend_delay;
	bool rt;
};

/**
 * struct ssp_config_chip - spi_board_info.controller_data for SPI
 * slave devices, copied to spi_device.controller_data.
 *
 * @lbm: used for test purpose to internally connect RX and TX
 * @iface: Interface type(Motorola, TI, Microwire, Universal)
 * @hierarchy: sets whether interface is master or slave
 * @slave_tx_disable: SSPTXD is disconnected (in slave mode only)
 * @clk_freq: Tune freq parameters of SSP(when in master mode)
 * @endian_rx: Endianess of Data in Rx FIFO
 * @endian_tx: Endianess of Data in Tx FIFO
 * @data_size: Width of data element(4 to 32 bits)
 * @com_mode: communication mode: polling, Interrupt or DMA
 * @rx_lev_trig: Rx FIFO watermark level (for IT & DMA mode)
 * @tx_lev_trig: Tx FIFO watermark level (for IT & DMA mode)
 * @clk_phase: Motorola SPI interface Clock phase
 * @clk_pol: Motorola SPI interface Clock polarity
 * @ctrl_len: Microwire interface: Control length
 * @wait_state: Microwire interface: Wait state
 * @duplex: Microwire interface: Full/Half duplex
 * @clkdelay: on the PL023 variant, the delay in feeback clock cycles
 * before sampling the incoming line
 * @cs_control: function pointer to board-specific function to
 * assert/deassert I/O port to control HW generation of devices chip-select.
 * @dma_xfer_type: Type of DMA xfer (Mem-to-periph or Periph-to-Periph)
 * @dma_config: DMA configuration for SSP controller and peripheral
 */
struct spi_config_chip {
	enum spi_interface iface;
	enum spi_hierarchy hierarchy;
	bool slave_tx_disable;
	enum spi_mode com_mode;
	enum spi_rx_level_trig rx_lev_trig;
	enum spi_tx_level_trig tx_lev_trig;
	enum spi_duplex duplex;
	void (*cs_control) (u32 control);
};

enum zx29_spi_speed {
	ZX29_SPI_800K	= SPI_CLK_SRC_26M / 2 / 16,
	ZX29_SPI_900K	= SPI_CLK_SRC_26M / 2 / 14,
	ZX29_SPI_1M1	= SPI_CLK_SRC_26M / 2 / 12,
	ZX29_SPI_1M3	= SPI_CLK_SRC_26M / 2 / 10,
	ZX29_SPI_1M6	= SPI_CLK_SRC_26M / 2 / 8,
	ZX29_SPI_2M2	= SPI_CLK_SRC_26M / 2 / 6,
	ZX29_SPI_3M3	= SPI_CLK_SRC_26M / 2 / 4,
	ZX29_SPI_3M7	= SPI_CLK_SRC_104M / 2 / 14,
	ZX29_SPI_4M3	= SPI_CLK_SRC_104M / 2 / 12,
	ZX29_SPI_4M9	= SPI_CLK_SRC_156M / 2 / 16,
	ZX29_SPI_5M2	= SPI_CLK_SRC_104M / 2 / 10,
	ZX29_SPI_5M6	= SPI_CLK_SRC_156M / 2 / 14,
	ZX29_SPI_6M5	= SPI_CLK_SRC_26M / 2 / 2,
	ZX29_SPI_7M8	= SPI_CLK_SRC_156M / 2 / 10,
	ZX29_SPI_8M7	= SPI_CLK_SRC_104M / 2 / 6,
	ZX29_SPI_9M8	= SPI_CLK_SRC_156M / 2 / 8,
	ZX29_SPI_13M	= SPI_CLK_SRC_26M / 2 / 1,
	ZX29_SPI_20M	= SPI_CLK_SRC_156M / 2 / 4,
	ZX29_SPI_26M	= SPI_CLK_SRC_104M / 2 / 2,
	ZX29_SPI_39M	= SPI_CLK_SRC_156M / 2 / 2,
	ZX29_SPI_52M	= SPI_CLK_SRC_104M / 2 / 1,
};

#endif/*ZX29_SPI_H*/
