/*
 * Copyright (C) 2013 ZTE, China
 *
 * It has the ioctl definitions for the volte driver that
 * userspace needs to know about.
 */

#ifndef __LINUX_AMR_DRV_H
#define __LINUX_AMR_DRV_H

#include <linux/ioctl.h>

typedef enum 
{
	ZMMP_CODEC_AMR_NB_IF1, 
	ZMMP_CODEC_AMR_NB_IF2,
	ZMMP_CODEC_AMR_NB_IETF,
	ZMMP_CODEC_AMR_WB_IF1,
	ZMMP_CODEC_AMR_WB_IF2,
	ZMMP_CODEC_AMR_WB_IETF
} T_zMmp_CodecType;

typedef enum 
{
    ZMMP_AMR_ENC_MODE_0,     /* NB:4.75 kbit/s, WB:6.60 kbit/s  */
    ZMMP_AMR_ENC_MODE_1,     /* NB:5.15 kbit/s, WB:8.85 kbit/s  */	
    ZMMP_AMR_ENC_MODE_2,     /* NB:5.90 kbit/s, WB:12.65 kbit/s */
    ZMMP_AMR_ENC_MODE_3,     /* NB:6.70 kbit/s, WB:14.25 kbit/s */
    ZMMP_AMR_ENC_MODE_4,     /* NB:7.40 kbit/s, WB:15.85 kbit/s */
    ZMMP_AMR_ENC_MODE_5,     /* NB:7.95 kbit/s, WB:18.25 kbit/s */
    ZMMP_AMR_ENC_MODE_6,     /* NB:10.2 kbit/s, WB:19.85 kbit/s */
    ZMMP_AMR_ENC_MODE_7,     /* NB:12.2 kbit/s, WB:23.05 kbit/s */
    ZMMP_AMR_ENC_MODE_8,     /* NB:DTX,         WB:23.85 kbit/s */
    ZMMP_AMR_ENC_MODE_9,     /* NB:Ч,        WB:DTX          */
    ZMMP_AMR_ENC_MODE_INVALID     /* NB:Ч,   WB:Ч          */
} T_zMmp_AmrEncMode;

typedef struct
{
	bool isDtxEnable;
    T_zMmp_CodecType codecType;
} T_ZDrvVoice_EncOpenArg;

typedef struct
{
	bool isWb;
	T_zMmp_AmrEncMode mode;
    uint16_t amrFrameSize;
	uint16_t pcmencsize;//NB:320 WB:640
	const uint16_t *pPcmEnc;
	uint8_t *pAmrEnc;
} T_ZDrvVoice_AmrEncodeArg;

typedef struct
{
	bool isWb;;
    uint16_t pcmFrameSize;
    uint16_t amrdecsize; //NB:32 WB:61
	const uint8_t *pAmrDec;
	uint16_t *pPcmDec; 
} T_ZDrvVoice_AmrDecodeArg;

/**************************************************************************
* 
**************************************************************************/


#define AMR_IOCTL_DECOPEN 		_IOW('v', 1, T_zMmp_CodecType)
#define AMR_IOCTL_ENCOPEN		_IOW('v', 2, T_ZDrvVoice_EncOpenArg)
#define AMR_IOCTL_DECODE 		_IOW('v', 3, T_ZDrvVoice_AmrDecodeArg)
#define AMR_IOCTL_ENCODE 		_IOW('v', 4, T_ZDrvVoice_AmrEncodeArg)
#define AMR_IOCTL_DECODE_VOLTE 	_IOW('v', 5, T_ZDrvVoice_AmrDecodeArg)
#define AMR_IOCTL_ENCODE_VOLTE 	_IOW('v', 6, T_ZDrvVoice_AmrEncodeArg)
#define AMR_IOCTL_DECCLOSE 		_IO('v', 7)
#define AMR_IOCTL_ENCCLOSE 		_IO('v', 8)

#endif

