/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_pub.h
* ļʶ:     ramdump_pub.h
* ժҪ:     ramdumpͷļ
* ʹ÷:     #include "ramdump_pub.h"
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/3/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

#ifndef _RAMDUMP_PUB_H
#define _RAMDUMP_PUB_H

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump.h"
#include "ramdump_arch.h"
#include "ramdump_soc.h"

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/
#define RAMDUMP_SUCCESS (0)
#define RAMDUMP_FAILED  (-1)

#define RAMDUMP_ICP_SUCCESS (RAMDUMP_SUCCESS)
#define RAMDUMP_ICP_FAILED  (RAMDUMP_FAILED)

#define RAMDUMP_TRUE    (1)
#define RAMDUMP_FALSE   (0)

#define RAMDUMP_CLIENT_M0           (1)
#define RAMDUMP_CLIENT_ZSP          (2)
#define RAMDUMP_CLIENT_CAP          (3)

#define RAMDUMP_SYNC_RESET              (0x73787384) /* 73:I 78:N 73:I 84:T */
#define RAMDUMP_SYNC_RAM_CONFIG_DONE    (0x68696576) /* 68:D 69:E 65:A 76:L */
#define RAMDUMP_SYNC_RAM_CONTENT_DONE   (0x68797869) /* 68:D 79:O 78:N 69:E */

/* adapt diff printf fun*/
#define RAMDUMP_PRINTF OSS_PRINTF

#define RAMDUMP_ARRAY_NR(arr) (sizeof(arr) / sizeof((arr)[0]))

#define RAMDUMP_WAIT_TIMELEN (200) /* like before,just a value roughly */

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
typedef unsigned long ramdump_msg_id_t;
typedef unsigned long ramdump_cpu_id_t;
typedef unsigned long *ramdump_client_done_flag_t;

/*
 * ICP MSG struct collect server with 
 * clients and trans server.
 */
enum
{
    RAMDUMP_MSG_INIT_REQ,
    RAMDUMP_MSG_INIT_RSP,
    RAMDUMP_MSG_SYNC,
    RAMDUMP_MSG_EXCEPT,
};

/* 
 * ramdump client id 
 * collect server : RAMDUMP_CPU_0
 * trans server : RAMDUMP_CPU_1
 * client1 : RAMDUMP_CPU_2
 * client2 : RAMDUMP_CPU_3
 */
enum
{
/* 
 * collect server/client0 : RAMDUMP_CPU_0
 * trans server : RAMDUMP_CPU_1
 * client1 : RAMDUMP_CPU_2
 */
    RAMDUMP_CPU_0,
    RAMDUMP_CPU_1,
    RAMDUMP_CPU_2,
    RAMDUMP_CPU_MAX
};

/* client and server icp ram conf data */
typedef struct
{
    char            name[RAMDUMP_RAMCONF_FILENAME_MAXLEN];
    unsigned long   phy;
    unsigned long   vir;
    unsigned long   size;

    unsigned long       flag;       /* RAMDUMP_FLAG_XXX         */
    unsigned long       copy;       /* Copy destination address */
    unsigned long       exter;      /* External address         */
    ramdump_callback_t  callback;   /* Callback funtion         */
} ramdump_ram_config_t;

/* client and server icp init msg */
typedef struct
{
    ramdump_ram_config_t        *array;
    unsigned long               nr;
    ramdump_client_done_flag_t  done_flag;
} ramdump_ram_config_msg_t;

/* collect to trans server icp msginfo */
typedef struct
{
    ramdump_ram_config_msg_t    *array;
    unsigned long               nr;
} ramdump_ram_config_sync_msg_t;

/* client and server message define */
typedef struct
{
    ramdump_cpu_id_t    cpu_id;
    ramdump_msg_id_t    msg_id;

    union
    {
        ramdump_ram_config_msg_t        ram_config;
        ramdump_ram_config_sync_msg_t   ram_config_sync;
    } msg_data_t;
} ramdump_msg_t;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
/* 
 * ramdump assign id array, records the true cpu id value.
 */
extern unsigned long ramdump_cpu_id[RAMDUMP_CPU_MAX];
extern unsigned char *ramdump_cpu_name[RAMDUMP_CPU_MAX];

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/

/*******************************************************************************
*                                ʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_wait_client_dump_delay
* ˵:     
*   ()  ms:   ȴMS
                addr: ַ
                flag: ȴ־
*   ()  
*   ֵ:     
* ˵:     This function is used to delay certain seconds
*******************************************************************************/
static inline void ramdump_wait_done_delay(
                        unsigned long           ms, 
                        volatile unsigned long *addr, 
                        unsigned long           flag)
{
    int j = 0;
    int i = 0;
    for (j = 0; j < RAMDUMP_DELAY_MS_COUNT; j++)
        for (i = 0; i < ms; i++)
            if (*addr == flag)
                return;
}

#endif  //#ifndef _RAMDUMP_PUB_H

