#ifndef LYNQ_AP_NV_CFG_H
#define LYNQ_AP_NV_CFG_H

#pragma pack(1)
struct lynq_nv_cfg_header
{
    unsigned short magic_flag;
    unsigned short valid_flag:1;
    unsigned short content_len:15;
};
struct nv_cfg_info
{
    unsigned char reserved_0:6;
    unsigned char mmc1_enable:1;
    unsigned char mmc0_enable:1;
    unsigned char reserved_1:7;
    unsigned char wifi_enable:1;
    unsigned char reserved_2:7;
    unsigned char rndis_mac_convert:1;
    unsigned char reserved_3:7;
    unsigned char rndis_ip_map:1;

};

struct version_info
{
    unsigned short soft_ver:12;
    unsigned short hard_ver:4;
    unsigned short crc;
};

struct lynq_nv_cfg
{
    struct lynq_nv_cfg_header head;
    struct nv_cfg_info content;
    struct lynq_nv_cfg_header tail;
    struct version_info versions[0];
};

#pragma pack()

extern struct nv_cfg_info *get_ap_nv_cfg_info();

static inline unsigned char get_mmc0_enable() {
    return get_ap_nv_cfg_info()->mmc0_enable;
}

static inline unsigned char get_mmc1_enable() {
    return get_ap_nv_cfg_info()->mmc1_enable;
}

static inline unsigned char get_wifi_enable() {
    return get_ap_nv_cfg_info()->wifi_enable;
}

static inline unsigned char get_rndis_mac_convert() {
    return get_ap_nv_cfg_info()->rndis_mac_convert;
}

static inline unsigned char get_rndis_ip_map() {
    return get_ap_nv_cfg_info()->rndis_ip_map;
}



#endif // LYNQ_AP_NV_CFG_H
