#ifndef OTP_ZX_H
#define OTP_ZX_H

#include <linux/ioctl.h>

#define OTP_IOC_MAGIC     'O'

/*ioctl cmd usd by device*/
#define OTP_GET_DATA			_IOWR(OTP_IOC_MAGIC, 1, char *)
#define OTP_SET_SECURE_EN		_IOW(OTP_IOC_MAGIC, 2, char *)
#define OTP_SET_PUB_KEY_HASH	_IOW(OTP_IOC_MAGIC, 3, char *)
#define OTP_SET_DEVICE_ID		_IOW(OTP_IOC_MAGIC, 4, char *)

#define SPI_NOR_MAX_ID_LEN	8

typedef struct
{
	u32 pubKey[95];
	u32 secureFlag;
	u32 pubKeyHash[8];
	u32 secureDevId[3];
}T_ZDrvOtp_Secure;

typedef enum
{
    OTP_SECURE_EN,
	OTP_PUB_KEY_HASH,
	OTP_DEVICE_ID,
	OTP_MAX_ENUM
}E_ZDrvOtp_SecureMsg;

#endif

struct nor_info {
	char		       *name;

	unsigned char		id[SPI_NOR_MAX_ID_LEN];
	unsigned char		id_len;

	unsigned	        sector_size;
	unsigned short		n_sectors;

	unsigned short		page_size;
	unsigned short		addr_width;

	unsigned short		flags;
#define	SECT_4K				0x01
#define	SPI_NOR_NO_ERASE	0x02
#define	SST_WRITE			0x04
#define	SPI_NOR_NO_FR		0x08
#define	SECT_4K_PMC			0x10
#define	SPI_NOR_DUAL_READ	0x20
#define	SPI_NOR_QUAD_READ	0x40
#define	USE_FSR				0x80
};

int nor_write(u32 to, u32 len, u32 buf);
int nor_read(u32 from, u32 len, u32 to);
int nor_erase(u32 addr);
