#ifndef SOCKET_RPMSG_H
#define SOCKET_RPMSG_H

#include <linux/interrupt.h>
#include <linux/kthread.h>
#include <linux/spinlock.h>
#include <linux/semaphore.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <linux/un.h>
#include <linux/types.h>
#include <linux/soc/zte/rpm/rpmsg.h>

#include <net/sock.h>

extern int socket_rpmsg_debug;

#define sk_soc_dbg(format, arg...) if(socket_rpmsg_debug == 1) \
	printk(KERN_DEBUG "[socket_rpmsg]<%s>: " format "\n" ,__func__ , ## arg)
#define sk_soc_info(format, arg...) if(socket_rpmsg_debug == 1) \
	printk(KERN_INFO "[socket_rpmsg]<%s>: " format "\n" ,__func__ , ## arg)

#define sk_soc_err(format, arg...) printk(KERN_ERR "[socket_rpmsg]<%s>: " format "\n" , \
	__func__ , ## arg)

#define sk_soc_warn(format, arg...) printk(KERN_WARNING "[socket_rpmsg]<%s>: " format "\n" , \
	__func__ , ## arg)



#define	 ICP_CHANNEL_SIZE 	(16 * 1024)

/*remote data ,to local,read from rpmsg channel*/
#define DIR_UPLINK		1
/*local data ,to remote,need write rpmsg channel*/
#define DIR_DOWNLINK	2
#define sockSocCreateChannel zDrvRpMsg_CreateChannel_Cap
#define sockSocWrite         zDrvRpMsg_Write_Cap
#define sockSocRead          zDrvRpMsg_Read_Cap

#define SOCK_OP_RESULT		0

extern spinlock_t sock_table_lock;
extern spinlock_t sock_rpmsg_table_lock;
extern spinlock_t sock_socket_table_lock;
extern spinlock_t sock_release_table_lock;
extern spinlock_t sock_release_lock;
extern spinlock_t sock_release_peer_lock;
extern spinlock_t sock_socketaddr_table_lock;
typedef enum _soc_msg_type
{
	MSG_TYPE_FIND = 0,
	MSG_TYPE_FIND_RESULT,
	MSG_TYPE_ADD_WAIT_QUEUE,
	MSG_TYPE_REMOVE_WAIT_QUEUE,
	MSG_TYPE_SYNC_IPC_SOCKET,
	MSG_TYPE_WAIT_FOR_PEER,
	MSG_TYPE_DATA_READY,
	MSG_TYPE_SEND_MSG,
	MSG_TYPE_SET_PEER,
	MSG_TYPE_UPDATE_PEER,
	MSG_TYPE_SOCK_PUT,
	MSG_TYPE_ADD_SKB_QUEUE_TAIL,
	MSG_TYPE_RECVQ_FULL,
	MSG_TYPE_RECVQ_FULL_RESULT,
	MSG_TYPE_RECVQ_FULL_LOCKLESS_AND_DEAD,
	MSG_TYPE_RECVQ_FULL_LOCKLESS_AND_DEAD_RESULT,
	MSG_TYPE_PEER_CLEAR,
	MSG_TYPE_WAKE_UP_INTERRUPTIBLE_POLL,
	MSG_TYPE_TEST_FLAG,
	MSG_TYPE_TEST_FLAG_RESULT,
	MSG_TYPE_GET_SOCKET_STATES,
	MSG_TYPE_GET_SOCKET_STATES_RESULT,
	MSG_TYPE_STREAM_CONNECT, //21
	MSG_TYPE_SOCKET_RELEASE, //22
	MSG_TYPE_DGRAM_DISCONNECTED,
	MSG_TYPE_STATE_LOCK,
	MSG_TYPE_STATE_UNLOCK,
	MSG_TYPE_SOCK_HOLD,
	MSG_TYPE_RELEASE_PEER,
	MSG_TYPE_NOTIFY_PROXY_CHANGE,
	MSG_TYPE_UNIX_BIND,
	MSG_TYPE_UNIX_UNBIND,
}soc_msg_type;

struct sock_thread_info {
	struct task_struct *p_thread;	
	struct list_head	p_sock_list;
	struct spinlock 	p_sock_lock;
	struct semaphore 	p_sock_sem;

	int bstop;
};

struct sock_channel {
    T_ZDrvRpMsg_ActorID core_id;
    T_ZDrvRpMsg_ChID channel_id;
    unsigned int channel_size;
    //struct task_struct *rcv_thread;
	//struct task_struct *main_thread;
	struct sock_thread_info recv_thread_info;
	struct sock_thread_info main_thread_info;
};

struct sock_elem_flag {
	int sk_err;
	int sk_error_report;
	int skstate;
	u8 skshutdown;
};

struct	sock_rpmsg
{
	struct list_head list;
	soc_msg_type msg_type;
	uint32_t dir;
	struct sockaddr_un sockaddr;
	int addr_len;
	int socktype; 
	unsigned int hash;
	struct sock_elem_flag elem;
	//struct sock sock;	
	int clientfd;
	int serverfd;
	int clientproxyfd;
	int serverproxyfd;
	int newclientfd;
	void* clientsock; //Ϊstruct socket
	void* serversock; //Ϊstruct socket
	void* newsock;
	void* clientproxysock; //Ϊstruct socket
	void* serverproxysock; //Ϊstruct socket
	int result;
	enum sock_flags flag;
	unsigned long flags;
	long timeo;
	unsigned int  msg_flags;
	int isfistfind;
	void* key;
	unsigned int index;
	int data_len;
	unsigned char data[0];	
};

struct	ipc_socket
{	
	struct hlist_node	hlist_node;
	struct socket* socket;
	struct sock* sock;
	int socktype; 
	int localfd;  //ؿͻfd
	int sockfd;   //شsocketfd
	int remotefd; //ӦԶʵfd
	int remoteproxyfd; //ӦԶ˴ fd
	struct socket* localsocket; //ؿͻsocket
	struct socket* proxysocket; //شsocket
	struct socket* remotesocket; //ӦԶʵsocket
	struct socket* remoteproxysocket; //ӦԶ˴socket
	void* key;
};

struct sock_rpmsg_info
{
	struct hlist_node	hlist_node;
	struct sock_rpmsg sock_rpmsg;
	struct semaphore sock_sem;
	struct ipc_socket * ipc_socket;
	void* key; //ʶrpmsgĹؼ
};

struct	peer_sock_info
{	
	int fd;
	int peerfd;
	struct sock* sock;
	struct sock* peersock;
	long timeo;
};

struct release_socket{
	struct list_head	list_node;
#if 0	
	struct socket* sock;
	int clientfd;
	void* clientsock;
#endif	
	int localfd; //ͻfd
	int proxyfd;   //شsocketfd
	int remotefd; //ӦԶʵfd
	struct socket* localsocket; //ؿͻsocket
	struct socket* proxysocket; //شsocket
	struct socket* remotesocket; //ӦԶʵsocket
	struct socket* remoteproxysocket; //Ӧsocket
};

//в뽻socketַ
struct socket_info{
	struct hlist_node	hlist_node;
	struct socket* proxysocket;
	struct socket* localsocket;
};

struct sock_sunaddr_info
{
	struct hlist_node	hlist_node;
	struct sockaddr_un sockaddr;
};

int sock_soc_recvq_full(const struct sock *sk);
int sock_soc_set_peer(struct sock *sock, struct sock *other);
int sock_soc_sock_put(struct sock *other);
int sock_soc_msg_send(struct sock *sock, struct sock *other, struct msghdr *msg, size_t len);
long sock_wait_for_peer(struct sock *sock, struct sock *other, long timeo);
int sock_soc_sk_data_ready(struct sock *sk);
int sock_sync_ipc_socket(struct sock_elem_flag* elem_flag, struct sock *other);
void sock_soc_add_skb_queue_tail(struct sock *sock, struct sock *other);
void sock_soc_add_wait_queue(struct sock *sock, struct sock *other);
void sock_soc_remove_wait_queue(struct sock *sock, struct sock *other);
struct sock *sock_soc_find_other(struct socket* socket,
				    struct sockaddr_un *sunname, int len,
				    int type, unsigned int hash, int *error);
int unix_is_ipc_socket(struct sock *sock);
int unix_is_ipc_local_socket(struct sock *sock);
int sock_soc_test_flags(struct sock *other, enum sock_flags flag);
int sock_soc_recvq_full_lockless_and_dead(const struct sock *other);
int sock_soc_get_state(struct sock_elem_flag* elem_flag, struct sock *other);
void sock_soc_stream_connect(struct sock *sock, struct sock *other, struct sockaddr_un *sunname, int len,int flags);
int sock_soc_update_peer(struct socket *sock, struct socket *newsock);
int sock_soc_dgram_disconnected(struct sock *sock, struct sock *other);
void sock_soc_state_lock(struct sock *other);
void sock_soc_state_unlock(struct sock *other);
void sock_soc_delay_release(struct socket *sock);
void sock_soc_sock_hold(struct sock *other);
void sock_soc_unix_bind(struct sockaddr_un *sunaddr);
void sock_soc_unix_unbind(struct sockaddr_un *sunaddr);

#endif

