#ifndef _SOCK_TRACK_H_
#define _SOCK_TRACK_H_

#include <net/sock.h>

#define SOCK_TRACK_STR_LEN	512


enum sock_err_type
{
    TCP_ACCEPT_QUEUE_FULL,      /*tcpaccept*/
    TCP_REQ_QUEUE_FULL,         /*tcp*/
    TCP_RECV_BUFF_FULL,         /*tcpĽջ*/
    TCP_SEND_BUFF_FULL,         /*tcpķͻ*/
    TCP_RECV_WINDOW_FULL,       /*tcpĽմ*/
    TCP_RST_SEND,               /*tcpRST*/
    TCP_FIN_SEND,               /*tcpFIN*/
    TCP_RST_RECV,               /*tcpRST*/
    TCP_FIN_RECV,               /*tcpFIN*/
    TCP_ERR_MAX,
};

int tcp_sock_track(struct sock *sk, int err_type, char *function, int linenum);

#define TCP_SOCK_TRACK(x, y)  tcp_sock_track((x), (y), __func__, __LINE__)

#endif

