#ifndef _ZX29_SND_PLATFORM_H_
#define _ZX29_SND_PLATFORM_H_ 1

#include <mach/gpio_cfg.h>

#define CONFIG_USE_PIN_I2S0
//#define CONFIG_USE_PIN_I2S1

/****************************************************************************
* 	                              Codec platform data
****************************************************************************/
/************** tlv320aic3100 ************/
#if (defined CONFIG_SND_SOC_TLV320AIC31XX) || (defined CONFIG_SND_SOC_TLV320AIC31XX_MODULE)

#include "../../../sound/soc/codecs/tlv320aic31xx.h"

#define CODEC_NAME  "tlv320aic3100"
#define CODEC_ADDR  0x18

static struct  aic31xx_pdata snd_codec_pdata = {
	.codec_type	    =	AIC3100, 
    .gpio_reset      =   CODEC_RESET,
	.micbias_vg    =   MICBIAS_2_0V,
	.irq_gpio_num  = PIN_EARP_INT,
    .irq_gpio_func = EARP_INT_FUNC_SEL,
};

#define ZX29_SND_CODEC_PDATA (&snd_codec_pdata)

#endif

/************** nau8810 *************/
#if (defined CONFIG_SND_SOC_NAU8810) || (defined CONFIG_SND_SOC_NAU8810_MODULE)

#include "../../../sound/soc/codecs/nau8810.h"

#define CODEC_NAME  "nau8810"
#define CODEC_ADDR  0x1a

#define ZX29_SND_CODEC_PDATA  NULL 

#endif

#if (defined CONFIG_SND_SOC_ES8374) || (defined CONFIG_SND_SOC_ES8374_MODULE)

#include "../../../sound/soc/codecs/es8374.h"

#define CODEC_NAME  "es8374"
#define CODEC_ADDR  0x10

/*
static struct  es8374_pdata {
	int irq_gpio_num;
    int irq_gpio_func;
};

static struct  es8374_pdata snd_codec_pdata = {
	.irq_gpio_num  = ZX29_GPIO_48,
    .irq_gpio_func = GPIO48_EXT_INT1,
};
*/

//#define ZX29_SND_CODEC_PDATA  (&snd_codec_pdata) 
#define ZX29_SND_CODEC_PDATA  NULL

#endif

#if (defined CONFIG_SND_SOC_ES8312) || (defined CONFIG_SND_SOC_ES8312_MODULE)

#include "../../../sound/soc/codecs/es8312.h"

#define CODEC_NAME  "es8312"
#define CODEC_ADDR  0x18


//#define ZX29_SND_CODEC_PDATA  (&snd_codec_pdata) 
#define ZX29_SND_CODEC_PDATA  NULL

#endif

#if (defined CONFIG_SND_SOC_DUMMY) || (defined CONFIG_SND_SOC_DUMMY_MODULE)

#include "../../../sound/soc/codecs/tlv320aic31xx.h"

#define CODEC_NAME  "dummy"
#define CODEC_ADDR  0x18



#define ZX29_SND_CODEC_PDATA NULL
#endif


//#define ZX29_SND_CODEC_PDATA (&snd_codec_pdata)

//#define ZX29_SND_CODEC_PDATA  NULL     //ifndef snd_codec_pdata

/****************************************************************************
* 	                             Machine platform data
****************************************************************************/
/************** zx297520v3_ti3100 ************/
#if (defined CONFIG_SND_SOC_ZX297520V3_TI3100) || (defined CONFIG_SND_SOC_ZX297520V3_TI3100_MODULE)

#define  SND_MACHINE_PDEV_NAME  "zx297520v3_ti3100"

struct zx297520v3_ti3100_platform_data {
	int codec_refclk;
	int codec_en;
};

static struct zx297520v3_ti3100_platform_data snd_machine_pdata  = {
	.codec_refclk = CODEC_REFCLK,
	.codec_en = CODEC_EN,
};

#endif


/************* zx297520v3_nau8810 ************/

#if (defined CONFIG_SND_SOC_ZX297520V3_NAU8810) || (defined CONFIG_SND_SOC_ZX297520V3_NAU8810_MODULE)

#define  SND_MACHINE_PDEV_NAME  "zx297520v3_nau8810"

struct zx297520v3_nau8810_platform_data {
	int codec_refclk;
};

static struct zx297520v3_nau8810_platform_data snd_machine_pdata = {
	.codec_refclk = CODEC_REFCLK,
};

#endif

#if (defined CONFIG_SND_SOC_ZX297520V3_ES8374) || (defined CONFIG_SND_SOC_ZX297520V3_ES8374_MODULE)

#define  SND_MACHINE_PDEV_NAME  "zx29_snd_machine"

struct zx297520v3_es8374_pdata {
	int codec_refclk;
};

static struct zx297520v3_es8374_pdata snd_machine_pdata = {
	.codec_refclk = CODEC_REFCLK,
};

#endif

#if (defined CONFIG_SND_SOC_ZX297520V3_ES8312) || (defined CONFIG_SND_SOC_ZX297520V3_ES8312_MODULE)

#define  SND_MACHINE_PDEV_NAME  "zx29_snd_machine"

struct zx297520v3_es8312_pdata {
	int codec_refclk;
};

static struct zx297520v3_es8312_pdata snd_machine_pdata = {
	.codec_refclk = CODEC_REFCLK,
};

#endif

#if (defined CONFIG_SND_SOC_ZX297520V3_DUMMY) || (defined CONFIG_SND_SOC_ZX297520V3_DUMMY_MODULE)

#define  SND_MACHINE_PDEV_NAME  "zx29_snd_machine"

struct zx297520v3_dummy_pdata {
	int codec_refclk;
};

static struct zx297520v3_dummy_pdata snd_machine_pdata = {
	//.codec_refclk = CODEC_REFCLK,
};

#endif




#define  ZX29_SND_MACH_PDATA  (&snd_machine_pdata)

//#define  ZX29_SND_MACH_PDATA  NULL    //ifndef snd_machine_pdata

#endif

