/*******************************************************************************
* Ȩ (C)2016, ͨѶɷ޹˾
* 
* ļ:     ramdump_oss.c
* ļʶ:     ramdump_oss.c
* ժҪ:     ramdumpϵͳӿ/ݽṹͷļ
* ʹ÷:     ϵͳͷļڽӿڻݶҪ
* 
* ޸        汾      ޸ı        ޸          ޸
* ------------------------------------------------------------------------------
* 2016/6/10      V1.0        Create           Ծ          
* 
*******************************************************************************/

/*******************************************************************************
*                                   ͷļ                                     *
*******************************************************************************/
#include "ramdump_pub.h"
#include "ramdump_oss.h"
#include <linux/module.h>
#include <linux/lzo.h>
#ifdef _USE_VEHICLE_DC
#include "ramdump_compress.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************
*                                ⲿ                                  *
*******************************************************************************/
extern unsigned long ramdump_phy_to_vir(ramdump_ram_config_t * ram_config);

/*******************************************************************************
*                                   궨                                     *
*******************************************************************************/

/*******************************************************************************
*                                Ͷ                                  *
*******************************************************************************/
#ifdef _USE_VEHICLE_DC
typedef struct
{
	volatile unsigned int core_flag;//0:cp,1:cap
	volatile unsigned int rw_flag;//0:non,1:w,2:r
	volatile unsigned int size;//orginal size
	char buf[];
} ramdump_shmem_t;

/*******************************************************************************
*                                ȫֱ                                  *
*******************************************************************************/
unsigned char *ramdump_mem_base = NULL;
unsigned char *ramdump_shared_mem_base = NULL;
unsigned int  ramdump_export_mode = 0xFF;
#endif

/*******************************************************************************
*                                ȫֺ                                  *
*******************************************************************************/
#ifdef _OS_LINUX 
/* icp api */  
extern int zDrvRpMsg_CreateChannel(
              T_ZDrvRpMsg_ActorID actorID, 
              T_ZDrvRpMsg_ChID chID, 
              unsigned int size);
extern int zDrvRpMsg_RegCallBack(
              T_ZDrvRpMsg_ActorID actorID, 
              unsigned int chID, 
              T_ZDrvRpMsg_CallbackFunction callback);
extern int zDrvRpMsg_WriteLockIrq(const T_ZDrvRpMsg_Msg *pMsg);
extern void panic(const char *fmt, ...);

extern int zDrvUsbPoll_Init(void);
extern int zDrvUsbPoll_Isr(void);
extern bool zDrvUsbPoll_isConnect(void);
extern int zDrvUsbPoll_Read(unsigned char* pBuf,unsigned long length);
extern int zDrvUsbPoll_Write(unsigned char* pBuf,unsigned long length);
#if defined CONFIG_PRINTK
extern void get_logbuf_info(unsigned long *addr, unsigned long *size);
#endif
#endif //#ifdef _OS_LINUX 
extern unsigned int ramdump_compress_flag;

/*******************************************************************************
*                                ȫֺʵ                                  *
*******************************************************************************/

/*******************************************************************************
* :     ramdump_oss_create_thread
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_create_thread (
        unsigned char *name, 
        ramdump_oss_thread_entry_t entry)
{
#ifdef _OS_TOS
#define RAMDUMP_THREAD_STACK_DEF_SIZE 2048
#define RAMDUMP_THREAD_DEF_PRIO 20
#define RAMDUMP_THREAD_DEF_ARG 0
#define RAMDUMP_THREAD_AUTORUN 1
#define RAMDUMP_THREAD_PREEMPT 1

    zOss_CreateThread(
        name,entry, 
        RAMDUMP_THREAD_DEF_ARG,
        RAMDUMP_THREAD_STACK_DEF_SIZE,
        RAMDUMP_THREAD_DEF_PRIO,
        RAMDUMP_THREAD_PREEMPT,
        RAMDUMP_THREAD_AUTORUN);
#endif
}

/*******************************************************************************
* :     ramdump_oss_mmap
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
unsigned long ramdump_oss_mmap (unsigned long addr, unsigned long size)
{
#ifdef _OS_LINUX
    return ioremap(addr,size);
#elif defined (_OS_TOS)

#ifdef __USE_MMU__
    T_zTos_MmuRamdumpTable mmuTable = {0};
    zTos_MmuGetMappingRegion(addr, size, &mmuTable);
    /* 
     * TODO!
     * current tos mmap one to one
     * need new API like ioremap realize
     */
    return addr;
#endif

#endif
}

#ifdef _USE_CAP_SYS
/*******************************************************************************
* :    ramdump_oss_icp_send_cap
* ˵:     
*   () icp_msg: msg info
               client_id: client id
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    This function is used for server to send msg to client
*******************************************************************************/
int ramdump_oss_icp_send_cap(ramdump_oss_msg_t *icp_msg, unsigned int client_id)
{
    int ret;
    ramdump_oss_icp_msg rpmsg = {0};

    rpmsg.actorID = client_id;
    rpmsg.chID = channel_10;
    rpmsg.flag = 1;
    rpmsg.buf = icp_msg;
    rpmsg.len = sizeof(*icp_msg);

    /*
     * clean all the caches to make sure all data in ddr 
     */
    ramdump_arch_clean_caches();

    ret = zDrvRpMsg_Write_Cap(&rpmsg);

    if (ret != rpmsg.len)
    {
        OSS_PRINTF(
            "[ramdump] icpmsg send fail, ret != rpmsg.len[ret:%d], [client_id:%d]\n", 
            ret, 
            client_id);
        return ret;
    }

    return RAMDUMP_ICP_SUCCESS;
}
#endif

/*******************************************************************************
* :    ramdump_oss_icp_send
* ˵:     
*   () icp_msg: msg info
               client_id: client id
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    This function is used for server to send msg to client
*******************************************************************************/
int ramdump_oss_icp_send(ramdump_oss_msg_t *icp_msg, unsigned int client_id)
{
    int ret;
    ramdump_oss_icp_msg rpmsg = {0};

    rpmsg.actorID = client_id;
    rpmsg.chID = channel_40;
    rpmsg.flag = 1;
    rpmsg.buf = icp_msg;
    rpmsg.len = sizeof(*icp_msg);

    /*
     * clean all the caches to make sure all data in ddr 
     */
    ramdump_arch_clean_caches();

    ret = ramdump_oss_icp_write(&rpmsg);

    if (ret != rpmsg.len)
    {
#ifdef _OS_LINUX
        OSS_PRINTF(
            "[ramdump] icpmsg send fail, ret != rpmsg.len[ret:%d], [client_id:%d]\n", 
            ret, 
            client_id);
#elif defined (_OS_TOS)
        OSS_PRINTF(
            SUBMDL_TEST, 
            PRINT_LEVEL_NORMAL,
            "[ramdump] icpmsg send fail, ret != rpmsg.len[ret:%d], [client_id:%d]\n", 
            ret,
            client_id);
#endif
        return ret;
    }

    return RAMDUMP_ICP_SUCCESS;
}

/*******************************************************************************
* :     ramdump_oss_error_log_creat
* ˵:     
*   ()  buf : addr point
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_error_log_creat(char *buf)
{
#ifdef _OS_LINUX
    if (current->mm != NULL)
        sprintf(
            buf, 
            " dump at user, app name is: %s, load addr is: %lu \n", 
            current->comm, 
            current->mm->start_code);
    else
        sprintf(
            buf,
            " dump at kernel, app name is: %s \n", 
            current->comm);
#endif

}

/*******************************************************************************
* :    ramdump_oss_icp_create_channel
* ˵:     
*   () actorID: icp send core id
               chID:    icp channel id
               size:    icp channel size
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
int ramdump_oss_icp_create_channel(
        ramdump_oss_icp_actorid actorID, 
        ramdump_oss_icp_channelid chID, 
        unsigned int size)
{
#ifdef _OS_LINUX
    return CPPS_FUNC(cpps_callbacks, zDrvRpMsg_CreateChannel)(actorID, chID, size);
#elif defined (_OS_TOS)
    if (actorID == ramdump_cpu_id[RAMDUMP_CPU_2])
        return 0;
    else
        return zDrvRpMsg_CreateChannel(actorID, chID, size);
#endif
}

/*******************************************************************************
* :    ramdump_oss_icp_regcallback
* ˵:     
*   () actorID: icp send core id
               chID:    icp channel id
               callback:icp callback fun
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
int ramdump_oss_icp_regcallback (
        ramdump_oss_icp_actorid actorID, 
        unsigned int chID, 
        ramdump_oss_icp_callback callback)
{
#ifdef _OS_LINUX
    return CPPS_FUNC(cpps_callbacks, zDrvRpMsg_RegCallBack)(actorID,chID,callback);
#elif defined (_OS_TOS)
    if (actorID == ramdump_cpu_id[RAMDUMP_CPU_2])
        return zDrvIcp_RegCallback(
                ICP_ARM0_MODULE_ID_OS, 
                actorID, 
                callback, 
                ICP_ISR_CALLBACK); 
    else
        return zDrvRpMsg_RegCallBack(actorID,chID,callback);
#endif
}

/*******************************************************************************
* :    ramdump_oss_icp_write
* ˵:     
*   () pMsg: icp send msg
*   () void 
*   ֵ:    int: if msg send success 
* ˵:    
*******************************************************************************/
int ramdump_oss_icp_write(const ramdump_oss_icp_msg *pMsg)
{
#ifdef _OS_LINUX
    return CPPS_FUNC(cpps_callbacks, zDrvRpMsg_Write)(pMsg);
#elif defined (_OS_TOS)
    if ((ramdump_msg_t *)pMsg->actorID == ramdump_cpu_id[RAMDUMP_CPU_2])
    {
        switch (((ramdump_msg_t *)(pMsg->buf))->msg_id)
        {
            case RAMDUMP_MSG_EXCEPT:
            {
                T_HalIcp_Msg icpMsg = { 0 };
                icpMsg.SrcModId          = ICP_ARM0_MODULE_ID_OS;
                icpMsg.desModId          = ICP_ARM1_MODULE_ID_OS;
                icpMsg.IntInfo.high_word = ZPLAT_PS2PHY_RAMDUMP_INT_ICP_CF;
                zDrvIcp_SendMsg((const T_HalIcp_Msg *)&icpMsg);
            }
            case RAMDUMP_MSG_SYNC:
            default:
                return pMsg->len;
        }
    }
    else
        return zDrvRpMsg_WriteLockIrq(pMsg);
#endif
}

/*******************************************************************************
* :     ramdump_oss_data_trans_init
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_init(void)
{
#ifdef _OS_LINUX 
#ifdef _USE_VEHICLE_DC
	if((ramdump_export_mode != RAMDUMP_MODE_EMMC) 
		&&(ramdump_export_mode != RAMDUMP_MODE_SPINAND))
	{
#endif
    	zDrvUsbPoll_Init();                 /* ʼUSB        */
    	while (!zDrvUsbPoll_isConnect()) ;  /* ѯUSBǷ  */
#ifdef _USE_VEHICLE_DC
	}
	else
	{
		ramdump_lzo_init();
	}
#endif
#endif
}

void ramdump_usb_trans_read(unsigned char *buffer, unsigned int size)
{
#ifdef _OS_LINUX 
	unsigned int count = 0;

	do
	{
		zDrvUsbPoll_Isr();
		count = (unsigned int)zDrvUsbPoll_Read(buffer, size);
		if ( size <= count)
		{
			break;
		}
		buffer += count;
		size -=count;
	}
	while (size > 0);
#endif

}

void ramdump_usb_trans_write(unsigned char *buffer, unsigned int size)
{
#ifdef _OS_LINUX 
	unsigned int count = 0;

	while (size > 0)
	{
		zDrvUsbPoll_Isr();
		count = (unsigned int)zDrvUsbPoll_Write(buffer, size);
		if ( size <= count)
		{
			break;
		}

		buffer += count;
		size -=count;
	}
#endif

}
static inline void ramdump_wait_delay( unsigned long ms)
{
    volatile int j = 0;
	for (j = 0; j < 50000; j++);
}

#ifdef _USE_VEHICLE_DC
void ramdump_shared_mem_init(void)
{
	ramdump_mem_base = OSS_MMAP(RAMDUMP_MEM_BASE, RAMDUMP_SHARED_MEM_LEN);
	ramdump_shared_mem_base = ramdump_mem_base;
}

int ramdump_shm_trans_write(unsigned char *buffer, unsigned int size)
{
	int ret = -1;
	size_t dst_len = 0;
	ramdump_shmem_t tmp_msg;
	ramdump_shmem_t *msg = (ramdump_shmem_t *)ramdump_shared_mem_base;

	if (size > (RAMDUMP_SHARED_MEM_LEN - roundup(sizeof(ramdump_shmem_t), RAMDUMP_SHMEM_ALIGN_SIZE)))
		ret = -1;

	while(1){
		if ((msg->core_flag == 0) && (msg->rw_flag == 1)){
			_memcpy_toio(msg->buf, buffer, size);
			tmp_msg.size = size;
			tmp_msg.core_flag = 1;
			tmp_msg.rw_flag = 2;
			_memcpy_toio(msg, &tmp_msg, sizeof(ramdump_shmem_t));
			ret = size;
			break;
		}
		else
			ramdump_wait_delay(0);
	}
	return ret;
}

/*******************************************************************************
* :    ramdump_shm_trans_write_data
* ˵:     
*   () void
*   () void
*   ֵ:    void 
* ˵:    This function is used for ramdump to trans dump data to PC
*******************************************************************************/
int ramdump_shm_trans_write_data(unsigned char *buffer, unsigned int size)
{
	int ret = -1;
	size_t dst_len = 0;
	ramdump_shmem_t tmp_msg;
	ramdump_shmem_t *msg = (ramdump_shmem_t *)ramdump_shared_mem_base;

	if (size > (RAMDUMP_SHARED_MEM_LEN - roundup(sizeof(ramdump_shmem_t), RAMDUMP_SHMEM_ALIGN_SIZE)))
	{
		printk("ramdump_shm_trans_write_data failed!\n");
		return ret;
	}

	while(1){
		if ((msg->core_flag == 0) && (msg->rw_flag == 1)){
			if (ramdump_compress_flag == 1){
				ret = ramdump_lzo_compress(buffer, size, msg->buf, &dst_len);
			}
			if (ret	!= LZO_E_OK){
				_memcpy_toio(msg->buf, buffer, size);
				tmp_msg.size = size;
				tmp_msg.core_flag = 1;
				tmp_msg.rw_flag = 2;
				_memcpy_toio(msg, &tmp_msg, sizeof(ramdump_shmem_t));
				ret = size;
			}else{
				msg->size = dst_len;
				msg->core_flag = 1;
				msg->rw_flag = 2;
			}
			break;
		}
		else
			ramdump_wait_delay(0);
	}
	return ret;
}


/*******************************************************************************
* :    ramdump_shm_trans_read
* ˵:     
*   () void
*   () void
*   ֵ:    void 
* ˵:    This function is used for ramdump to trans dump data to PC
*******************************************************************************/
int ramdump_shm_trans_read(unsigned char *buffer, unsigned int size)
{
	int ret;
	ramdump_shmem_t tmp_msg;
	ramdump_shmem_t *msg = (ramdump_shmem_t *)ramdump_shared_mem_base;

	if (size > (RAMDUMP_SHARED_MEM_LEN - roundup(sizeof(ramdump_shmem_t), RAMDUMP_SHMEM_ALIGN_SIZE)))
		ret = -1;

	while(1){
		if ((msg->core_flag == 0) && (msg->rw_flag == 2)){
			if (size < msg->size)
				return -1;
			_memcpy_fromio(buffer, msg->buf, msg->size);
			tmp_msg.size = msg->size;
			tmp_msg.core_flag = 0;
			tmp_msg.rw_flag = 1;
			_memcpy_toio(msg, &tmp_msg, sizeof(ramdump_shmem_t));
			ret = size;
			break;
		}
		else
			ramdump_wait_delay(0);
	}
	return ret;
}
#endif
/*******************************************************************************
* :     ramdump_oss_data_trans_read
* ˵:     
*   () buffer: data buff
               size:   data size
*   () void 
*   ֵ:    void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_read(unsigned char *buffer, unsigned int size)
{
#ifdef _USE_VEHICLE_DC
	if ((ramdump_export_mode == RAMDUMP_MODE_EMMC)
		|| (ramdump_export_mode == RAMDUMP_MODE_SPINAND))
		ramdump_shm_trans_read(buffer, size);
	else
#endif
		ramdump_usb_trans_read(buffer, size);
}

/*******************************************************************************
* :     ramdump_oss_data_trans_write
* ˵:     
*   () buffer: data buff
               size:   data size
*   () void 
*   ֵ:    void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_write(unsigned char *buffer, unsigned int size)
{
#ifdef _USE_VEHICLE_DC
	if ((ramdump_export_mode == RAMDUMP_MODE_EMMC)
		|| (ramdump_export_mode == RAMDUMP_MODE_SPINAND))
		ramdump_shm_trans_write(buffer, size);
	else
#endif
		ramdump_usb_trans_write(buffer, size);

}

void ramdump_oss_data_trans_write_data(unsigned char *buffer, unsigned int size)
{
#ifdef _USE_VEHICLE_DC
	if ((ramdump_export_mode == RAMDUMP_MODE_EMMC)
		|| (ramdump_export_mode == RAMDUMP_MODE_SPINAND)){
			ramdump_shm_trans_write_data(buffer, size);
	}
	else
#endif
		ramdump_usb_trans_write(buffer, size);

}

/*******************************************************************************
* :     ramdump_oss_data_trans_done
* ˵:     
*   ()  void
*   ()  void
*   ֵ:     void
* ˵:    
*******************************************************************************/
void ramdump_oss_data_trans_done(void)
{
#ifdef _OS_LINUX
#ifdef _USE_VEHICLE_DC

	/* ȴݷ */
	if ((ramdump_export_mode == RAMDUMP_MODE_EMMC)
		|| (ramdump_export_mode == RAMDUMP_MODE_SPINAND))
		return;
	else
#endif
		zDrvUsbPoll_Isr();
#endif
}

void ramdump_oss_logbuf_create(void)
{
#ifdef _OS_LINUX  
#if defined CONFIG_PRINTK

	unsigned long addr;
	unsigned long size;

	get_logbuf_info(&addr, &size);

	ramdump_ram_conf_table_add(
		"ap_log_buf", 
		(unsigned long)OSS_VIRT_TO_PHY(addr), 
		size, 
		addr,
		RAMDUMP_FLAG_LEVEL_HIGH,
		0);
#endif
#endif
}

#ifdef __cplusplus
}
#endif

