//#include <message.h>
#include <errno.h>
#include <wifi.h>
#include "wlan_interface.h"
#include "softap_api.h"

#define WIFI_SSID_LEN        33
#define WLAN_SECURITY_LEN    20
#define WLAN_ENCRYTYPE_LEN   10
#define WLAN_DEFAULTID_LEN    2
#define WLAN_WEPKEY_LEN      32
#define WLAN_PSK_LEN         65
#define WLAN_ENCODE_PSK_LEN 100

#define WF_AU_OPEN          "OPEN"            //wifi auth mode?
#define WF_AU_SHARE         "SHARED"
#define WF_AU_WEPAUTO       "WEPAUTO"
#define WF_AU_WPA           "WPAPSK"
#define WF_AU_WPA2          "WPA2PSK"
#define WF_AU_WPA_WPA2  	"WPAPSKWPA2PSK" 
#define WF_AU_WAPIPSK	    "WAPIPSK"
#define WF_ENCRY_NONE       "NONE"   //encrypt
#define WF_ENCRY_WEP        "WEP"
#define WF_ENCRY_TKIP       "TKIP"
#define WF_ENCRY_CCMP       "CCMP"
#define WF_ENCRY_AES        "AES"
#define WF_ENCRY_TKIP_CCMP  "TKIPCCMP"
#define WF_ENCRY_TKIP_AES   "TKIPAES"

#define MAX_WIFI_NUM 32

static int zte_station_connect_time_calc(char *timeStr);
static void zte_get_vap_sta_list(RT_802_11_MAC_TABLE *staList);
//int get_vap_sta_num(char *vapIface);

static int zte_wlan_ssid1_basic_set(char *ssid_in)
{
    char  *ssid = NULL; 
	char nv_tmp[WIFI_SSID_LEN] = {0};
	
	if (NULL == ssid_in)
	{
		printf("input ssid is null\n");
		return -1;
	}

	if ((!strcmp(ssid_in, "")) || (strlen(ssid_in) <= 0) || (strlen(ssid_in) > WIFI_SSID_LEN))
	{
		printf("input ssid is error\n");
		return -1;
	}
    
    //ssid
    memset(nv_tmp, 0, sizeof(nv_tmp));
    if (ssid_in != NULL)
    {
        sc_cfg_get("SSID1", nv_tmp, sizeof(nv_tmp));
        if (0 != strcmp(ssid_in, nv_tmp))
        {
            sc_cfg_set("SSID1", ssid_in);
			//sc_cfg_save();
        }
		else
		{
			printf("input ssid is same \n");
			return 1;
		}
    }
    return 0;
}

static int zte_wlan_ssid1_security_set(char *password)
{	
    char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};
    int changeSecurityMode = 1;
    
	sc_cfg_get("AuthMode", authMode, sizeof(authMode));
	sc_cfg_get("EncrypType", encrypType, sizeof(encrypType));

    if (authMode != NULL && encrypType != NULL)
    {  
        printf("wlan_ssid1_security_set authMode = [%s]\n", authMode);
		printf("wlan_ssid1_security_set encrypType = [%s]\n", encrypType);   
		if(NULL == password)//&& (!(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))))
		{
			printf("wlan_ssid1_security_set password is null\n");
			return -1;
		}

		if((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_NONE)))
		{
			if(strlen(password) == 0 || (!strcmp(password, "")))
			{
				printf("%s, WF_AU_OPEN password len is 0\n", __FUNCTION__);
				return 1;
			}
			else 
			{
				if((strlen(password) < 8) || (strlen(password) > 64))
				{
					printf("%s,  password len is error\n", __FUNCTION__);
					return -1;
				}
			}
		}
		else
		{
			if((strlen(password) < 8) || (strlen(password) > 64) || (!strcmp(password, "")))
			{
				printf("%s, not open password len is error\n", __FUNCTION__);
				return -1;
			}
		}
		
		if(((!strcmp(authMode, WF_AU_WPA_WPA2)) && (!strcmp(encrypType, WF_ENCRY_TKIP_AES))))
		{
			changeSecurityMode = 0;
		}
		else
		{
			sc_cfg_set("AuthMode", WF_AU_WPA_WPA2);
			sc_cfg_set("EncrypType", WF_ENCRY_TKIP_AES);
		}
        if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
        {   
            if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_WEP))) ||
            	 (!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
            {
			    int len = 0;
				len = strlen(password);
				if(len != 5 || len != 10 || len != 13 || len != 26)
				{
					printf("wlan_ssid1_security_set wep psk len = [%s]\n", len);  
					return -1;
				}
				sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));
                if(DefaultKeyID != NULL)
				{
					char old_wep_key[WLAN_WEPKEY_LEN] = {0};
					
					if(!strcmp(DefaultKeyID, "1"))
					{
						sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key2Str1", password);
							//sc_cfg_save();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
					else if(!strcmp(DefaultKeyID, "2"))
					{
                        sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
						
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key3Str1", password);
							//sc_cfg_save();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
					else if(!strcmp(DefaultKeyID, "3"))
					{
     					sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key4Str1", password);
							//sc_cfg_save();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
					else 
					{
						sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
						if(strcmp(old_wep_key, password))
						{
							sc_cfg_set("Key1Str1", password);
							//sc_cfg_save();
						}
						else
						{
							printf("wlan_ssid1_security_set wep psk is same\n");  
							return 1;
						}
					}
				}
            }
            else if(!strcmp(authMode, WF_AU_OPEN) && !strcmp(encrypType, WF_ENCRY_NONE))
            {
                printf("authMode is open and not wep \n");
				return 1;

            }
        }
        else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
        {
			char psk[WLAN_PSK_LEN]                = {0};
            int len = 0;
			char encode[WLAN_ENCODE_PSK_LEN] = {0};
			len = strlen(password);
			
			if(len < 8 || len > 64)
			{
				printf("%s password len is %d \n",authMode, len);
				return -1;
			}
			sc_cfg_get("WPAPSK1",psk,sizeof(psk));
			if(psk != NULL)
			{
				if(strcmp(psk, password))
				{
					sc_cfg_set("WPAPSK1", password);
					base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
					sc_cfg_set("WPAPSK1_encode", encode);
					//sc_cfg_save();
				}
				else
				{
					if(!changeSecurityMode)
					{
						printf("%s, wpapskwpa2psk psk is same\n", __FUNCTION__);
						return 1;
					}
				}
			}
            else
			{
				sc_cfg_set("WPAPSK1", password);
				base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
				sc_cfg_set("WPAPSK1_encode", encode);
				//sc_cfg_save();
			}
        }
		else if(!strcmp(authMode, WF_AU_WAPIPSK))
		{
			char psk[WLAN_PSK_LEN]                = {0};
			int len = 0;
			char encode[WLAN_PSK_LEN] = {0};
			len = strlen(password);
			
			if(len < 8 || len > 64)
			{
				printf("WF_AU_WAPIPSK password len is %d \n", len);
				return -1;
			}
			sc_cfg_get("WPAPSK1",psk,sizeof(psk));
			if(psk != NULL)
			{
				if(strcmp(psk, password))
				{
					sc_cfg_set("WPAPSK1", password);
					base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
					sc_cfg_set("WPAPSK1_encode", encode);
					//sc_cfg_save();
				}
				else
				{
					if(!changeSecurityMode)
					{
						printf("%s, wapi psk is same\n", __FUNCTION__);
						return 1;
					}
				}
			}
            else
			{
				sc_cfg_set("WPAPSK1", password);
				base64_encode(password, len, encode, WLAN_ENCODE_PSK_LEN);
				sc_cfg_set("WPAPSK1_encode", encode);
				//sc_cfg_save();
			}
		}
        else
        {
            // other security mode is invalid
            printf("ERROR:security mode  is invalid\n");
            return -1;
        }
    }
    else
    {
        //security_mode is NULL
        printf("ERROR:security_mode is null\n");
        return -1;
    }

    return 0;
}

int zte_wlan_get_ssid1_settings(char* ssid, char* password, int ssid_len, int password_len)
{
	char authMode[WLAN_SECURITY_LEN]      = {0};
    char encrypType[WLAN_ENCRYTYPE_LEN]   = {0};
	char DefaultKeyID[WLAN_DEFAULTID_LEN] = {0};

	if(NULL == ssid || NULL == password)
	{
		printf("ERROR:input ssid && password is null\n");
		return -1;
	}
	
	if(NULL != ssid)
	{
		char old_ssid[WIFI_SSID_LEN] = {0};
		sc_cfg_get("SSID1",old_ssid,sizeof(old_ssid));
		if(old_ssid != NULL)
		{
			strncpy(ssid, old_ssid, ssid_len - 1);
		}
		else
		{
			printf("ERROR:input old_ssid is null\n");
			return -1;
		}
	}
	
	if(NULL != password)
	{
		sc_cfg_get("AuthMode",authMode,sizeof(authMode));
		sc_cfg_get("EncrypType",encrypType,sizeof(encrypType));
		
		if(authMode != NULL && encrypType != NULL)
		{  
			printf("wlan_ssid1_security_get authMode = [%s]\n", authMode);   
			printf("wlan_ssid1_security_get encrypType = [%s]\n", encrypType);   

			if((!strcmp(authMode, WF_AU_OPEN))  || (!strcmp(authMode, WF_AU_SHARE)) ||  (!strcmp(authMode, WF_AU_WEPAUTO)))
			{   
				if(((!strcmp(authMode, WF_AU_OPEN)) && (!strcmp(encrypType, WF_ENCRY_WEP))) ||
					(!strcmp(authMode, WF_AU_SHARE)) || (!strcmp(authMode, WF_AU_WEPAUTO))) 
				{
					sc_cfg_get("DefaultKeyID",DefaultKeyID,sizeof(DefaultKeyID));
					if(DefaultKeyID != NULL)
					{
						char old_wep_key[WLAN_WEPKEY_LEN] = {0};
						if(!strcmp(DefaultKeyID, "1"))
						{
							sc_cfg_get("Key2Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
						else if(!strcmp(DefaultKeyID, "2"))
						{
							sc_cfg_get("Key3Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
						else if(!strcmp(DefaultKeyID, "3"))
						{
							sc_cfg_get("Key4Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
						else 
						{
							sc_cfg_get("Key1Str1",old_wep_key,sizeof(old_wep_key));
							if(old_wep_key != NULL)
							{
								strncpy(password, old_wep_key, password_len-1);
							}
							else
							{
								printf("ERROR:input old_wep_key is null\n");
								return -1;
							}
						}
					}
				}
            }
			else if(!strcmp(authMode, WF_AU_WPA)  || !strcmp(authMode, WF_AU_WPA2) || !strcmp(authMode,  WF_AU_WPA_WPA2))
			{
				char psk[WLAN_PSK_LEN]                = {0};
				sc_cfg_get("WPAPSK1",psk,sizeof(psk));
				if(psk != NULL)
				{
					strncpy(password, psk, password_len-1);
				}
				else
				{
					printf("ERROR:%s input psk is null\n", authMode);
					return -1;
				}
			}
			else if(!strcmp(authMode, WF_AU_WAPIPSK))
			{
				char psk[WLAN_PSK_LEN]                = {0};
				sc_cfg_get("WPAPSK1",psk,sizeof(psk));
				if(psk != NULL)
				{
					strncpy(password, psk, password_len-1);
				}
				else
				{
					printf("ERROR:%s input psk is null\n", authMode);
					return -1;
				}
			}
			else
			{
				return -1;
			}
		}
		else
		{
			return -1;
		}
    }
	return 0;
}

int zte_wlan_ssid1_set(char* ssid, char* password)
{
	int ret_for_basic = 0;
	int ret_for_security = 0;
	
	ret_for_basic = zte_wlan_ssid1_basic_set(ssid);
    if(-1 == ret_for_basic)
    {
        printf("wlan_ssid1_basic_set is false\n");
        return -1;
    }
	ret_for_security = zte_wlan_ssid1_security_set(password);
    if(-1 == ret_for_security)
    {
        printf("call lan_ssid1_security_set failure .\n");   
    }
	if(ret_for_basic == -1 && ret_for_security == -1)
	{ 
		printf("%s wifi set cmd error!\n", __FUNCTION__);
		return -1;
	}
    if(ret_for_basic == 0 || ret_for_security == 0)
	{
		if(0 == ipc_send_message(MODULE_ID_WLAN_SERVER, MODULE_ID_WIFI, MSG_CMD_WIFI_ADVANCED, 2, "1", 0))
		{
			//sc_cfg_set("RadioOff", "0");
			printf("wifi set cmd done!\n");
		}
		else
		{
			printf("wifi set cmd wlan_ssid1_set error!\n");
			return -1;
		}
    }
    return 0; 
}

//wifi_hal.c of realtek, in order to capture sta num of va0 and va1(if multi ssid is enabled)
int zte_wlan_capture_sta_num()
{
	int staTotalNum = 0;
	char wifi_cur_state[8] = {0};
	char sta_count[8] = {0};

	sc_cfg_get("wifi_cur_state",wifi_cur_state,sizeof(wifi_cur_state));
	
	if( !strncmp(wifi_cur_state,"0",1) )
	{
	    printf("[%s]wifi is off, can't obtain sta info!!\n",__FUNCTION__);
	    return 0;
	}
	sc_cfg_get("sta_count",sta_count,sizeof(sta_count));

	staTotalNum = atoi(sta_count);
	printf("[%s] staTotalNum = %d\n",__FUNCTION__,staTotalNum);
	return staTotalNum;
 }


static int zte_station_connect_time_calc(char* timeStr)
{
    //timeStr : [1 hr 2 min 3 sec]
	//char timeStr[32] = {0};
    char *splited_val = NULL;
    char *splited_str = NULL;
    char *delimiter = " ";
    char *save = NULL;
    int time = 0;

	//strncpy(timeStr, str, 31);
	//timeStr[31] = '\0';
	printf("timeStr %s\n", timeStr);
    splited_val = strtok_r(timeStr, delimiter, &save);
    if(NULL != splited_val)
    {
		printf("splited_val is %s\n", splited_val);
        splited_str = strtok_r(NULL, delimiter, &save);
    }
	else
	{
		printf("splited_val is NULL\n");
	}
    
    while(NULL != splited_val && NULL != splited_str)
    {
		printf("val %s, str %s\n", splited_val, splited_str);
        if(0 == strncmp(splited_str, "hr", 2))
        {
            time += atoi(splited_val) * 60 * 60;
        }else if(0 == strncmp(splited_str, "min", 3))
        {
            time += atoi(splited_val) * 60;
        }else if(0 == strncmp(splited_str, "sec", 3))
        {
            time += atoi(splited_val);
        }
        splited_val = strtok_r(NULL, delimiter, &save);
        if(NULL != splited_val)
        {
            splited_str = strtok_r(NULL, delimiter, &save);
        }        
    }
    char temp[32] = {0};
    sprintf(temp, "%d", time);
    sc_cfg_set("link_time", temp);
    return time;
}

int  copyfile(const char *source, const char * target)
{
    FILE  *fp_s = NULL;
    FILE  *fp_t = NULL;
    char  buf[1024]={0};
    int  lenR = 0;
    int  lenW=0;

    if( NULL== source  || NULL == target) return -1;
    if((fp_s = fopen(source,"r"))== NULL)
    {
        printf("[copyfile]sunwenming %s can not be open\n", source);
        return -1;
    }

    if((fp_t = fopen(target,"w"))== NULL)
    {
        printf("[copyfile]sunwenming %s can not be open\n", target);
        if(fp_s !=NULL) fclose(fp_s);
        return -1;
    }

    while((lenR = fread(buf, 1, 1024, fp_s)) > 0)
    {
        if((lenW = fwrite(buf, 1, lenR, fp_t)) != lenR)
        {
            printf("[copyfile]sunwenming write to %s failed\n", target);
        if(fp_s !=NULL)fclose(fp_s);
        if(fp_t !=NULL)fclose(fp_t);
            return  -1;
        }
        memset(buf, 0, 1024);
    }

    if(fp_s !=NULL)fclose(fp_s);
    if(fp_t !=NULL)fclose(fp_t);
    return 0;
}


static void  zte_get_vap_sta_list(RT_802_11_MAC_TABLE *staList)
{
	char station_mac_tmp[10*20] = {0};
	char sta_count[8] = {0};
	char * p = NULL;
	int i =0;
	char mac_tmp[18] = {0};
	sc_cfg_get("station_mac", station_mac_tmp, sizeof(station_mac_tmp));
	sc_cfg_get("sta_count", sta_count, sizeof(sta_count));

	staList->Num = atoi(sta_count);
	p = station_mac_tmp;
	printf("station_mac=%s\n", station_mac_tmp);
	for(i=0;i < staList->Num; i++ )
	{            
		memset(mac_tmp, 0, 18);  
		strncpy(mac_tmp, p, 17); p+= 18;
		sscanf(mac_tmp, "%2.2x:%2.2x:%2.2x:%2.2x:%2.2x:%2.2x", &staList->Entry[i].Addr[0],&staList->Entry[i].Addr[1],
		&staList->Entry[i].Addr[2],&staList->Entry[i].Addr[3],&staList->Entry[i].Addr[4],&staList->Entry[i].Addr[5]);
	}    


}
 
void zte_get_wifi_sta_list(RT_802_11_MAC_TABLE *staList)
{
	int i = 0;
	char wifi_cur_state[8]={0};

	sc_cfg_get("wifi_cur_state",wifi_cur_state,sizeof(wifi_cur_state));
	if(atoi(wifi_cur_state) == 0)
	{
	    	printf("wifi is Off, can not read sta_info\n");
	   	 return;
	}        

	zte_get_vap_sta_list(staList);

}
#if 0 //kw 3
int get_channel()
{
	char channel[8] = {0};
	pipecmd("iwpriv wlan0 get_mib channel |cut -d':' -f2", channel);
	return atoi(channel);
}
#endif
