/*---------------------------------------------------------------------------------------------------------------------
 * Ȩ(C)2000-2010, ͨѶɷ޹˾ 
 * 
 *   : mpu.c  
 * 
 *     : yuanhaibo
 * 
 * ļ:MPUýӿں
 * 
 * 
 *     : v1.0
 * 
 * ------------------------------------------------------------------------------------------------------------------ 
 * 
 * ޸        ޸            ޸
 * 20130822       10138762            
 *     
 *-------------------------------------------------------------------------------------------------------------------*/
#include <common.h>
#include <command.h>
#include <malloc.h>
#include <stdio_dev.h>
#include <version.h>

//#include "SysInc.h"
#include <mpu.h>


int32_t  dwRegionMark = 0;
extern void RegionNumSet(int32_t dwNum);
extern int32_t RegionNumGet(void);
extern void RegionBaseSet(int32_t dwBase);
extern int32_t RegionBaseGet(void);
extern void RegionAttrSet(int32_t dwAttr);
extern int32_t RegionAttrGet(void);
extern void RegionSizeSet(int32_t dwSize);
extern void SubRegionSet(int32_t dwSubRegion);
extern void RegionEn(int32_t dwEn);
extern int32_t RegionSizeGet(void);
extern void MPUEnable(void);
extern void MPUDisable(void);
extern int32_t MPURegionNum(void);
extern int32_t MPUSizeSec(int32_t dwSize);

/************************************************************
* ƣMPU_Size2Sec   
* sizeεֵ
* dwSize --regionС
* dwResult --sizeֵ
* ֵ  
* ˵
* ޸ڣ    汾  ޸ ޸
*------------------------------------------------------------
* 2013/08/22    v1.0   yuanhaibo  
*************************************************************/
int32_t MPU_Size2Sec(int32_t dwSize)
{
    int32_t dwResult;
    //IC_ASSERT(dwSize >= 256);
    dwResult = MPUSizeSec(dwSize);
    //if((1<<(dwResult+1)) != dwSize)
    //    IC_DBG(IC_DEBUG_INFO, "region size not aligned\n");
    return dwResult;
}

/************************************************************
* ƣMPU_RegionDisable   
* ȥʹ
* dwNum --region dwEnable--ʹ/ȥʹ
* 
* ֵ  
* ˵
* ޸ڣ    汾  ޸ ޸
*------------------------------------------------------------
* 2013/08/22    v1.0   yuanhaibo  
*************************************************************/
void MPU_RegionDisable(int32_t dwNum, int32_t dwEnable)
{
    RegionNumSet(dwNum);
    RegionEn(dwEnable);
}

/************************************************************
* ƣMPU_RegionInit   
* ʼ
* ptRegion --regionϢ
* 
* ֵ  
* ˵
* ޸ڣ    汾  ޸ ޸
*------------------------------------------------------------
* 2013/08/22    v1.0   yuanhaibo  
*************************************************************/
int32_t MPU_RegionInit(T_Region_Attr* ptRegion)
{
    int32_t dwTemp = 0;
    if((ptRegion->dwBase)%(1<<((ptRegion->dwSize)+1)))
    {
        //IC_DBG(IC_DEBUG_INFO, "baseaddr not aligned with size\n");
        return 1;
    }
    RegionNumSet(ptRegion->dwNum);
    RegionEn(0);
    RegionBaseSet(ptRegion->dwBase);
    dwTemp = ((ptRegion->dwXN << MPU_REGION_XN_POS) & MPU_REGION_XN_MASK)
            |((ptRegion->dwAP << MPU_REGION_AP_POS) & MPU_REGION_AP_MASK)
            |(((ptRegion->dwMemAttr >> 2) << MPU_REGION_TEX_POS) & MPU_REGION_TEX_MASK)
            |((ptRegion->dwShare << MPU_REGION_S_POS) & MPU_REGION_S_MASK)
            |(((ptRegion->dwMemAttr >> 1) << MPU_REGION_C_POS) & MPU_REGION_C_MASK)
            |(((ptRegion->dwMemAttr >> 0) << MPU_REGION_B_POS) & MPU_REGION_B_MASK);
    RegionAttrSet(dwTemp);
    //dwTemp = ((ptRegion->dwSubRegion << MPU_SUBREGION_DIS_POS) & MPU_SUBREGION_DIS_MASK)
    //        |((ptRegion->dwSize << MPU_SIZE_POS) & MPU_SIZE_MASK)
    SubRegionSet(ptRegion->dwSubRegion);
    RegionSizeSet(ptRegion->dwSize);
    RegionEn(1); 
    return 0;
}

/************************************************************
* ƣMPU_Init   
* MPUʼ
* 
* 
* ֵ  
* ˵
* ޸ڣ    汾  ޸ ޸
*------------------------------------------------------------
* 2013/08/22    v1.0   yuanhaibo  
*************************************************************/
void MPU_Setup(void)
{
    int32_t  dwRegionNum = 0, dwMPURegions = 0;
    T_Region_Attr   tRegion;
    dwMPURegions = MPURegionNum();
    //IC_DBG(IC_DEBUG_INFO, " MPU with %d regions\n", dwMPURegions);

    
    dwRegionNum = 0;    //RegionNumGet();
    

    /*****0x00800000~0x00c00000  peripheral*****/
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x0;
    tRegion.dwMemAttr   = MPU_REGION_NSD;   //register
    tRegion.dwAP        = 0x3;              //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_256K; 
    tRegion.dwXN        = 0x1;
    tRegion.dwSubRegion = 0xe0;             //0x00800000 ~ 0x00a80000, ģڼĴ
    MPU_RegionInit(&tRegion);

    /*****0x00100000~0x00110000  iram1*****/
    //dwRegionNum = RegionNumGet();
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x00100000;
    tRegion.dwMemAttr   = MPU_REGION_NSD;   //iram
    tRegion.dwAP        = 0x3;              //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_16K; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0x0;
    MPU_RegionInit(&tRegion);

    /*****0x0 ~ 0x00004000  iram1*****/
    //dwRegionNum = RegionNumGet();
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x0;
    tRegion.dwMemAttr   = MPU_REGION_NSD;   //iram
    tRegion.dwAP        = 0x3;              //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_16K; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0x0;
    MPU_RegionInit(&tRegion);

    /*****0x0 ~ 0x00000080  iram1*****/
    //dwRegionNum = RegionNumGet();
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x0;
    tRegion.dwMemAttr   = MPU_REGION_NM_INC_ONC;    //normal mem for exception handler I-pretch
    tRegion.dwAP        = 0x3;                      //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_256B; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0xf0;                     //0x0 ~ 0x80(exception table 0x0 ~ 0x40)
    MPU_RegionInit(&tRegion);

    /*****0x00200000 ~ 0x00280000  ITCM DTCM L2TCM*****/
    //dwRegionNum = RegionNumGet();
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x00200000;
    tRegion.dwMemAttr   = MPU_REGION_NM_INC_ONC;//normal mem for exception handler I-pretch
    tRegion.dwAP        = 0x3;                      //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_512K; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0x0;                     //0x00200000 ~ 0x00280000
    MPU_RegionInit(&tRegion);

    /*****0x00000000 ~ 0x80000000*****/
    //dwRegionNum = RegionNumGet();
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x00000000;                   //aligned with size
    tRegion.dwMemAttr   = MPU_REGION_NM_INC_ONC;    // close cache
    tRegion.dwAP        = 0x3;                          //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_2G; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0xc3;                         //DDR: 0x20000000 ~ 0x60000000
    MPU_RegionInit(&tRegion);

    /*****0x62000000 ~ 0x62020000*****/
    //dwRegionNum = RegionNumGet();
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x62000000;                   //aligned with size
    tRegion.dwMemAttr   = MPU_REGION_NM_INC_ONC;    //IRAM0
    tRegion.dwAP        = 0x3;                          //r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_128K; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0x0;                          //
    MPU_RegionInit(&tRegion);
    
    /*****0xEF000000 ~ 0xEF002000*****/
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0xEF000000;                   //aligned with size
    tRegion.dwMemAttr   = MPU_REGION_NSD;               //peripherals
    tRegion.dwAP        = 0x3;                          //r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_8K; 
    tRegion.dwXN        = 0x1;
    tRegion.dwSubRegion = 0x0;                          
    MPU_RegionInit(&tRegion);
	/***set dma buffer 0x27700000,16k nand,1k download,68k mmc***/
    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = CONFIG_NAND_DMA_BUF_ADDR;                   //aligned with size
    tRegion.dwMemAttr   = MPU_REGION_NM_INC_ONC;    //normal, wb, wa
    tRegion.dwAP        = 0x3;                          //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_128K; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0x0;                         //DDR: 0x20000000 ~ 0x60000000
    MPU_RegionInit(&tRegion);

	/***set dma buffer 0x20000000,usb buffer no cache***/
	dwRegionNum++;
	tRegion.dwNum		= dwRegionNum;
	tRegion.dwBase		= CONFIG_USB_DMA_BUF_ADDR;					 //aligned with size
	tRegion.dwMemAttr	= MPU_REGION_NM_INC_ONC;	//normal, wb, wa
	tRegion.dwAP		= 0x3;							//access r & w
	tRegion.dwShare 	= 0x0;
	tRegion.dwSize		= REGION_SIZE_32M; 
	tRegion.dwXN		= 0x0;
	tRegion.dwSubRegion = 0x0;						   //DDR: 0x20000000 ~ 0x60000000
	MPU_RegionInit(&tRegion);
	/*****0x25000000 ~ 0x26000000 dma no cache*****/

    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x25000000;                   //aligned with size
    tRegion.dwMemAttr   = MPU_REGION_NM_INC_ONC;    //normal, wb, wa
    tRegion.dwAP        = 0x3;                          //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_16M; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0x0;                      //DDR:  0x25000000 ~ 0x26000000
    MPU_RegionInit(&tRegion);
    dwRegionMark = dwRegionNum;
	/*****0x27c00000 ~ 0x28000000*****/

    dwRegionNum++;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x27c00000;                   //aligned with size
    tRegion.dwMemAttr   = MPU_REGION_NM_IWBWA_OWBWA;    //normal, wb, wa
    tRegion.dwAP        = 0x3;                          //access r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_4M; 
    tRegion.dwXN        = 0x0;
    tRegion.dwSubRegion = 0x0;                      //DDR:  0x25000000 ~ 0x26000000
    MPU_RegionInit(&tRegion);
    dwRegionMark = dwRegionNum;

	/***set 0x20000000--0x22000000, cache***/
	dwRegionNum++;
	tRegion.dwNum		= dwRegionNum;
	tRegion.dwBase		= 0x20000000;					 //aligned with size
	tRegion.dwMemAttr	= MPU_REGION_NM_IWBWA_OWBWA;	//normal, wb, wa
	tRegion.dwAP		= 0x3;							//access r & w
	tRegion.dwShare 	= 0x0;
	tRegion.dwSize		= REGION_SIZE_32M; 
	tRegion.dwXN		= 0x0;
	tRegion.dwSubRegion = 0x0;						   //DDR: 0x20000000 ~ 0x60000000
	MPU_RegionInit(&tRegion);

    /***set region 0 as bg***/
    dwRegionNum = 0;
    tRegion.dwNum       = dwRegionNum;
    tRegion.dwBase      = 0x0;                          //aligned with size
    tRegion.dwMemAttr   = MPU_REGION_SO;                //background
    tRegion.dwAP        = 0x3;                          //r & w
    tRegion.dwShare     = 0x0;
    tRegion.dwSize      = REGION_SIZE_4G; 
    tRegion.dwXN        = 0x1;
    tRegion.dwSubRegion = 0x0;                          
    MPU_RegionInit(&tRegion);
    
}
