#!/bin/bash

set -e

if [ $# -lt 2 ]; then
    echo "$0 private_key work_dir"
    exit -1
fi

PRIVATE_KEY=$1
WORK_DIR=$2
#v3t for old device, sha256 is not supported, only md5
DEVICE=$3
HASH_STR="sha256"

echo "PRIVATE_KEY:" $PRIVATE_KEY
echo "WORK_DIR:" $WORK_DIR

#ap_cpucap name changed for checking errors
if [ -f $WORK_DIR/ap_cpucap.bin ]; then
    mv $WORK_DIR/ap_cpucap.bin $WORK_DIR/inter_ap_cpucap.bin
fi
# vehicle device zloader.bin structure
# ---------------------------------------------------------------
# |      8 KB         |        24 KB       |       8KB          |
# ---------------------------------------------------------------
# |   bootrom1.bin    |   bootrom2.bin     |   zloader3.bin     | 
# ---------------------------------------------------------------
if [ x"$DEVICE" = x"v3t" ]; then
    HASH_STR="md5"
    if [ `ls -s $WORK_DIR/zloader.bin | awk '{print $1}'` -gt 32 ]; then
        #old v3t device for vehicle
        fileread  $WORK_DIR/zloader.bin     0  8192  $WORK_DIR/bootrom1.bin
        fileread  $WORK_DIR/zloader.bin  8192 24576  $WORK_DIR/bootrom2.bin
        fileread  $WORK_DIR/zloader.bin 32768     0  $WORK_DIR/zloader3.bin
        SignImage -z -i $WORK_DIR/bootrom1.bin -k $PRIVATE_KEY -t $HASH_STR
        SignImage -z -i $WORK_DIR/bootrom2.bin -k $PRIVATE_KEY -t $HASH_STR
        SignImage -z -i $WORK_DIR/zloader3.bin -k $PRIVATE_KEY -t $HASH_STR
        cat $WORK_DIR/bootrom1.bin $WORK_DIR/bootrom2.bin $WORK_DIR/zloader3.bin > $WORK_DIR/zloader.bin
        rm -v $WORK_DIR/bootrom1.bin $WORK_DIR/bootrom2.bin $WORK_DIR/zloader3.bin
    else
        #old v3t device for mdl/mifi etc.
        SignImage -z -i $WORK_DIR/zloader.bin -k $PRIVATE_KEY -t $HASH_STR
    fi
    SignImage -z -i $WORK_DIR/tloader.bin -k $PRIVATE_KEY -t $HASH_STR
fi
echo "HASH_STR:" $HASH_STR
SignImage -r -i $WORK_DIR/uboot.bin -k $PRIVATE_KEY -t $HASH_STR

# ap_rootfs.img ap_cpuap.bin
# ---------------------------------------------------------------------------------------------------------------
# |     640 Bytes         |        640 Bytes       |      64 Bytes                |    64 Bytes                 |
# ---------------------------------------------------------------------------------------------------------------
# | ap_cpuap.bin signdata | ap_rootfs.img signdata | ap_rootfs.img mkimage header | ap_cpuap.bin mkimage header |
# ---------------------------------------------------------------------------------------------------------------
#mkimage -A arm -O linux -C none  -T filesystem -a 0 -e 0 -n 'rootfs' -d $WORK_DIR/ap_rootfs.img $WORK_DIR/ap_rootfs_u.img
fileread $WORK_DIR/ap_cpuap.bin  1280 64 $WORK_DIR/rootfs_mkimage_header.img
cat $WORK_DIR/rootfs_mkimage_header.img $WORK_DIR/ap_rootfs.img > $WORK_DIR/ap_rootfs.u
SignImage -i $WORK_DIR/ap_rootfs.u  -o $WORK_DIR/ap_rootfs.signed  -k $PRIVATE_KEY -t $HASH_STR
fileread $WORK_DIR/ap_rootfs.signed 0 704 $WORK_DIR/ap_rootfs.sign
filewrite $WORK_DIR/ap_cpuap.bin 640 $WORK_DIR/ap_rootfs.sign $WORK_DIR/ap_cpuap.bin
SignImage -r -i  $WORK_DIR/ap_cpuap.bin -k $PRIVATE_KEY -t $HASH_STR

SignImage -r -i $WORK_DIR/evb_cpurpm.img -k $PRIVATE_KEY -t $HASH_STR
SignImage -r -i $WORK_DIR/evb_cpuphy.bin -k $PRIVATE_KEY -t $HASH_STR
SignImage -r -i $WORK_DIR/inter_ap_cpucap.bin  -k $PRIVATE_KEY -t $HASH_STR

if [ -f $WORK_DIR/ap_caprootfs.img.dm ]; then
    echo "ap_caprootfs.img resign start"
    rm -rf $WORK_DIR/verity && mkdir -p $WORK_DIR/verity
    zxic_parse_squashfs_verity $WORK_DIR/ap_caprootfs.img.dm  $WORK_DIR/verity/sign $WORK_DIR/verity/raw_table $WORK_DIR/verity/hash_tree_offset
    SignImage -d -i  $WORK_DIR/verity/raw_table -o $WORK_DIR/verity/raw_table.signed  -k $PRIVATE_KEY -t $HASH_STR
    fileseek $WORK_DIR/ap_caprootfs.img $WORK_DIR/verity/sign > $WORK_DIR/verity/sign_offset
    sign_offset=` sed -n '/found/p' $WORK_DIR/verity/sign_offset | awk '{print $2}' `
    echo caprootfs sign_offset $sign_offset
    filewrite  $WORK_DIR/ap_caprootfs.img $sign_offset  $WORK_DIR/verity/raw_table.signed $WORK_DIR/ap_caprootfs.img

    #fix ap_caprootfs.img.dm
    fileseek $WORK_DIR/ap_caprootfs.img.dm $WORK_DIR/verity/sign > $WORK_DIR/verity/sign_offset
    sign_offset=` sed -n '/found/p' $WORK_DIR/verity/sign_offset | awk '{print $2}' `
    echo caprootfs dm sign_offset $sign_offset
    filewrite  $WORK_DIR/ap_caprootfs.img.dm $sign_offset  $WORK_DIR/verity/raw_table.signed $WORK_DIR/ap_caprootfs.img.dm

    echo "ap_caprootfs.img resign success"
fi
if [ -f $WORK_DIR/cap_oem.img.dm ]; then
    echo "cap_oem.img resign start"
    rm -rf $WORK_DIR/verity && mkdir -p $WORK_DIR/verity
    zxic_parse_squashfs_verity $WORK_DIR/cap_oem.img.dm  $WORK_DIR/verity/sign $WORK_DIR/verity/raw_table $WORK_DIR/verity/hash_tree_offset
    SignImage -d -i  $WORK_DIR/verity/raw_table -o $WORK_DIR/verity/raw_table.signed  -k $PRIVATE_KEY -t $HASH_STR
    fileseek $WORK_DIR/cap_oem.img $WORK_DIR/verity/sign > $WORK_DIR/verity/sign_offset
    sign_offset=` sed -n '/found/p' $WORK_DIR/verity/sign_offset | awk '{print $2}' `
    echo oem sign_offset $sign_offset
    filewrite  $WORK_DIR/cap_oem.img $sign_offset  $WORK_DIR/verity/raw_table.signed $WORK_DIR/cap_oem.img

    #fix cap_oem.img.dm
    fileseek $WORK_DIR/cap_oem.img.dm $WORK_DIR/verity/sign > $WORK_DIR/verity/sign_offset
    sign_offset=` sed -n '/found/p' $WORK_DIR/verity/sign_offset | awk '{print $2}' `
    echo oem dm sign_offset $sign_offset
    filewrite  $WORK_DIR/cap_oem.img.dm $sign_offset  $WORK_DIR/verity/raw_table.signed $WORK_DIR/cap_oem.img.dm
    echo "cap_oem.img resign success"
fi

mv $WORK_DIR/inter_ap_cpucap.bin $WORK_DIR/ap_cpucap.bin

rm -fv $WORK_DIR/ap_rootfs.u
rm -fv $WORK_DIR/ap_rootfs.sign
rm -fv $WORK_DIR/rootfs_mkimage_header.img
rm -fv $WORK_DIR/ap_rootfs.signed
rm -fv $WORK_DIR/ap_imagefs*.img
rm -fr $WORK_DIR/verity
