/*********************************************************************************
 *  汾 (C)
 *
 *           :  CcAppAT
 *  		 :  
 *  汾		 :  V1.0
 *       :  2017.2.1
 *  ˵     :
 *           :
 *           :
 *           :
 *  ļ¼     :
 *  ʱ                         
 *-----------------------------------------------------------------------
 *
 *
***********************************************************************************/
#ifndef CONFIG_MIN_8M_VERSION
#include "at_context.h"
#include "cfg_nv_def.h"
#include "at_com.h"

#define ZAT_INVALID_LEN    -1
#define MSG_RETRY_NUM    4
#define MSG_RETRY_INTERVAL    50

char*  atCcapp_SendAtdReq(void *param)
{
    MSG_BUF *msgbuf = (MSG_BUF *)param;
    T_zCcapp_CallMoReq *callReq = (T_zCcapp_CallMoReq *)msgbuf->aucDataBuf;
    char *pAtcmdStr  = NULL;

    pAtcmdStr = malloc(ZDIAL_NUM_MAX+4);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, ZDIAL_NUM_MAX+4);
    snprintf(pAtcmdStr, ZDIAL_NUM_MAX+4,"ATD%s;\r\n", callReq->number);

    return pAtcmdStr;
}
char*  atCcapp_SendAtaReq(void *param)
{
    char *pAtcmdStr  = NULL;

    pAtcmdStr = malloc(10);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, 10);
    snprintf(pAtcmdStr, 10,"ATA\r\n");

    return pAtcmdStr;
}
char*  atCcapp_SendChupReq(void *param)
{
    char *pAtcmdStr  = NULL;

    pAtcmdStr = malloc(30);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, 30);
    snprintf(pAtcmdStr, 30,"AT+CHUP\r\n");

    return pAtcmdStr;
}
char*  atCcapp_SendVtsReq(void *param)
{
    MSG_BUF *msgbuf = (MSG_BUF *)param;
    char *pAtcmdStr  = NULL;
    T_zCcapp_VtsReq *vtsReq = (T_zCcapp_VtsReq *)msgbuf->aucDataBuf;

    pAtcmdStr = malloc(30);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, 30);
    snprintf(pAtcmdStr, 30,"AT+VTS=%c,30\r\n",vtsReq->dtmfchar);

    return pAtcmdStr;
}
char*  atCcapp_SendImsplusReq(void *param)
{
    MSG_BUF *msgbuf = (MSG_BUF *)param;
    char *pAtcmdStr  = NULL;
    T_zCcapp_ImsplusReq *imsplusReq = (T_zCcapp_ImsplusReq *)msgbuf->aucDataBuf;

    pAtcmdStr = malloc(30);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, 30);
    if (imsplusReq->setfg == 1)
    {
        snprintf(pAtcmdStr, 30,"AT+ZIMSPLUS=%d\r\n",imsplusReq->act);
    }
    else
    {
        snprintf(pAtcmdStr, 30,"AT+ZIMSPLUS=%d,4\r\n",imsplusReq->act);
    }

return pAtcmdStr;
}
char*  atCcapp_SendClckReq(void *param)
{
    MSG_BUF *msgbuf = (MSG_BUF *)param;
    char *pAtcmdStr  = NULL;
    T_zCcapp_ClckReq *clckReq = (T_zCcapp_ClckReq *)msgbuf->aucDataBuf;


    pAtcmdStr = malloc(50);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, 50);
    if (clckReq->type == 0)
    snprintf(pAtcmdStr, 50,"AT+CLCK=\"AO\",%d,\"%s\"\r\n",clckReq->act,clckReq->pw);
    else if (clckReq->type == 1)
    snprintf(pAtcmdStr, 50,"AT+CLCK=\"OI\",%d,\"%s\"\r\n",clckReq->act,clckReq->pw);

    return pAtcmdStr;
}
char*  atCcapp_SendCcfcReq(void *param)
{
    MSG_BUF *msgbuf = (MSG_BUF *)param;
    char *pAtcmdStr  = NULL;
    T_zCcapp_CcfcReq *ccfcReq = (T_zCcapp_CcfcReq *)msgbuf->aucDataBuf;

    pAtcmdStr = malloc(30);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, 30);
    if (ccfcReq->act ==1)
    snprintf(pAtcmdStr, 30,"AT+CCFC=%d,%d,\"%s\"\r\n",ccfcReq->type, ccfcReq->act, ccfcReq->dn);
    else if (ccfcReq->act ==0)
    snprintf(pAtcmdStr, 30,"AT+CCFC=%d,%d\r\n",ccfcReq->type, ccfcReq->act);

    return pAtcmdStr;
}
char*  atCcapp_SendChldReq(void *param)
{
    MSG_BUF *msgbuf = (MSG_BUF *)param;
    char *pAtcmdStr  = NULL;
    T_zCcapp_ChldReq *chldReq = (T_zCcapp_ChldReq *)msgbuf->aucDataBuf;

    pAtcmdStr = malloc(30);
	assert(pAtcmdStr);
    memset(pAtcmdStr, 0x00, 30);
    snprintf(pAtcmdStr, 30,"AT+CHLD=%d\r\n",chldReq->type);

    return pAtcmdStr;
}
VOID zCc_NumProc(CHAR *pParaLine)
{
    SINT32  flg = 0;
    UINT32  i = 0;
    UINT32  length = 0;
    CHAR *pSource = pParaLine;
    CHAR *pDest = NULL;
    CHAR abStrDest[ZDIAL_NUM_MAX+50] = {0};

    pDest = abStrDest;
    length = strlen(pParaLine);

    for (i = 0; i < length ; i++)
    {
        if ('"' == *pSource)
        {
            flg = (0 == flg)?1:0;                    
            if (0 == flg)
            {
                break;
            }
            pSource++;
        }
        else
        {
            *pDest++ = *pSource++;
        }
    }

    memset(pParaLine, 0, length);                           /* Ԥݿز */
    strcpy(pParaLine, abStrDest);
}
int atCcapp_RecvDsciInd( char *at_paras ,int is_query_report)
{   
    T_zCcApp_DsciInd *dsciInd = NULL;
    char abNum[ZDIAL_NUM_MAX+50]= {0};
	unsigned int type;

    dsciInd = malloc(sizeof(T_zCcApp_DsciInd));
    if(dsciInd==NULL){softap_assert(""); return AT_END;}
    memset(dsciInd, 0, sizeof(T_zCcApp_DsciInd));
    //zCc_PreProcRes(at_paras);
    at_print(AT_DEBUG,"[CCAPP] dsci ind! pResLine->resParas:%s.\n", at_paras);
    sscanf(at_paras, "%u, %u, %u, %u, %u, %97s", &dsciInd->cid, &dsciInd->dir, &dsciInd->state,&type, &dsciInd->inMpty, abNum);
    zCc_NumProc(abNum);
    memcpy(dsciInd->num, abNum, sizeof(dsciInd->num)-1);//cov 
    
    at_print(AT_DEBUG,"[CCAPP] DSCI %d %d %d\n", dsciInd->cid, dsciInd->dir, dsciInd->state);

    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_CALL_CTRL, MSG_CMD_DSCI_IND, sizeof(T_zCcApp_DsciInd), (unsigned char *)dsciInd,0);
    at_print(AT_DEBUG,"[CCAPP]send DSCI %d\n ",MSG_CMD_DSCI_IND );
    free(dsciInd);
    return AT_CONTINUE;
}

int atCcapp_RecvZvoicechnlInd(char *at_paras ,int is_query_report)
{   
    T_zCcApp_VoiceChnl *voicechnl = NULL;

    voicechnl = malloc(sizeof(T_zCcApp_VoiceChnl));
    if(voicechnl==NULL){softap_assert(""); return AT_END;}
    memset(voicechnl, 0, sizeof(T_zCcApp_VoiceChnl));

    at_print(AT_DEBUG,"[CCAPP] voicechnl ind! pResLine->resParas:%s.\n", at_paras);
    sscanf(at_paras, "%u, %u, %u, %u", &voicechnl->op, &voicechnl->act, &voicechnl->codetype,  &voicechnl->amrpath);  
    at_print(AT_DEBUG,"[CCAPP] voicechnl->op= %d voicechnl->act= %d voicechnl->codetype= %d voicechnl->amrpath= %d\n", voicechnl->op, voicechnl->act, voicechnl->codetype, voicechnl->amrpath);

    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_CALL_CTRL, MSG_CMD_ZVOICECHNL, sizeof(T_zCcApp_VoiceChnl), (unsigned char *)voicechnl,0);
    at_print(AT_DEBUG,"[CCAPP]send VOICECHNL %d\n ",MSG_CMD_ZVOICECHNL );
    free(voicechnl);
    return AT_CONTINUE;
}



int atCcapp_RecvImsplusInd(char *at_paras ,int is_query_report)
{   
    T_zCcApp_ImsplusInd *imsplusInd = NULL;

    imsplusInd = malloc(sizeof(T_zCcApp_ImsplusInd));
    if(imsplusInd==NULL){softap_assert("");return AT_END;}
    memset(imsplusInd, 0, sizeof(T_zCcApp_ImsplusInd));

    //zCc_PreProcRes(at_paras);
    at_print(AT_DEBUG,"[CCAPP] imsplus ind! pResLine->resParas:%s.\n", at_paras);
    sscanf(at_paras, "%u, %u", &imsplusInd->act, &imsplusInd->rate);  
    at_print(AT_DEBUG,"[CCAPP] imsplusInd->act= %d imsplusInd->rate= %d\n", imsplusInd->act, imsplusInd->rate);

#ifdef USE_CAP_SUPPORT
    if(imsplusInd->act == 0) {//Ƶ豸ر
    }
    else if(imsplusInd->act == 1) {//Ƶ豸
    }
    else if(imsplusInd->act == 2) {//֪ͨʼű
    }
    else if(imsplusInd->act == 3) {//ֹ֪ͨͣű
        T_zCcapp_ImsplusReq imsplusReq;

        imsplusReq.setfg = 0;
        imsplusReq.act = imsplusInd->rate;
        ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, MSG_CMD_ZIMSPLUS_REQ, sizeof(T_zCcapp_ImsplusReq), (unsigned char *)&imsplusReq,0);    
    }

    if(imsplusInd->rate == 8000) {
    }
    else if(imsplusInd->rate == 16000) {
    }
#else
    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_CALL_CTRL, MSG_CMD_ZIMSPLUS_IND, sizeof(T_zCcApp_ImsplusInd), (unsigned char *)imsplusInd,0);
    at_print(AT_DEBUG,"[CCAPP]send IMSPLUS %d\n ",MSG_CMD_ZIMSPLUS_IND );
    free(imsplusInd);
#endif

    return AT_CONTINUE;
}

int atCcapp_RecvZcpiInd(char *at_paras ,int is_query_report)
{   
    T_zCcApp_ZcpiInd *zcpiInd = NULL;

    zcpiInd = malloc(sizeof(T_zCcApp_ZcpiInd));
    if(zcpiInd==NULL){softap_assert("");return AT_END;}
    memset(zcpiInd, 0, sizeof(T_zCcApp_ZcpiInd));

    //zCc_PreProcRes(at_paras);
    at_print(AT_DEBUG,"[CCAPP] zcpi ind! pResLine->resParas:%s.\n", at_paras);
    sscanf(at_paras, "%u, %u, %u",&zcpiInd->cid,&zcpiInd->state,&zcpiInd->progdsp);

    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_CALL_CTRL, MSG_CMD_ZCPI, sizeof(T_zCcApp_ZcpiInd), (unsigned char *)zcpiInd,0);
    free(zcpiInd);
    return AT_CONTINUE;
}
int atCcapp_RecvOk(char *at_str,struct at_context *context,void **next_req,int *next_len)
{    
    T_zCcapp_optRsp* optRsp = NULL;

    optRsp = (T_zCcapp_optRsp *)malloc(sizeof(T_zCcapp_optRsp));
    if(optRsp == NULL){softap_assert("");return AT_END;}
    memset(optRsp, 0 , sizeof(T_zCcapp_optRsp));
    optRsp->result = 0;
    *next_req = optRsp;
    *next_len = sizeof(T_zCcapp_optRsp);
    at_print(AT_DEBUG,"CCAPP atCcapp_RecvOk receive ok\n");
    return AT_END;
}

int atCcapp_RecvErr(char *at_str,struct at_context *context,void **next_req,int *next_len)
{  
   T_zCcapp_optRsp* optRsp = NULL;

    optRsp = (T_zCcapp_optRsp *)malloc(sizeof(T_zCcapp_optRsp));
    if(optRsp == NULL){softap_assert("");return AT_END;}
    memset(optRsp, 0 , sizeof(T_zCcapp_optRsp));
    optRsp->result = -1;
    *next_req = optRsp;
    *next_len = sizeof(T_zCcapp_optRsp);
    at_print(AT_DEBUG,"CCAPP atCcapp_RecvOk receive err\n");
    return AT_END;
}

void ext_ccapp_regist(void)
{
	/****************************************************************************************
	*עccAPPops
	*****************************************************************************************/
	register_psclt_func(MSG_CMD_ATD_DIAL_REQ,        MSG_CMD_ATD_DIAL_RSP,        	atCcapp_SendAtdReq);
	register_psclt_func(MSG_CMD_ATA_REQ,  MSG_CMD_ATA_RSP,      atCcapp_SendAtaReq);
	register_psclt_func(MSG_CMD_CHUP_REQ,      MSG_CMD_CHUP_RSP,        	atCcapp_SendChupReq);
	register_psclt_func(MSG_CMD_VTS_REQ, 		MSG_CMD_VTS_RSP, 		    atCcapp_SendVtsReq);
	register_psclt_func(MSG_CMD_ZIMSPLUS_REQ, 		MSG_CMD_ZIMSPLUS_RSP, 		    atCcapp_SendImsplusReq);
	register_psclt_func(MSG_CMD_CHLD_REQ, 		MSG_CMD_CHLD_RSP, 		    atCcapp_SendChldReq);
	register_psclt_func(MSG_CMD_CCFC_REQ, 		MSG_CMD_CCFC_RSP, 		    atCcapp_SendCcfcReq);
	register_psclt_func(MSG_CMD_CLCK_REQ, 		MSG_CMD_CLCK_RSP, 		    atCcapp_SendClckReq);
 
	/**********************עat_ctlڲops********************************/
	register_clt_func("ATD", 	atCcapp_RecvOk, 		atCcapp_RecvErr);
	register_clt_func("ATA", 	atCcapp_RecvOk, 		atCcapp_RecvErr);
	register_clt_func("CHUP", 	atCcapp_RecvOk, 		atCcapp_RecvErr);
	register_clt_func("VTS=", 	atCcapp_RecvOk, 		atCcapp_RecvErr);
	register_clt_func("ZIMSPLUS=", 	atCcapp_RecvOk, 		atCcapp_RecvErr);
	register_clt_func("CHLD=", 	atCcapp_RecvOk, 		atCcapp_RecvErr);
	register_clt_func("CCFC=", 	atCcapp_RecvOk, 		atCcapp_RecvErr);
	//register_clt_func("CLCK=", 	atCcapp_RecvOk, 		atCcapp_RecvErr);


	/**********************עPSصϱͲѯмϱĻص**************************/
	/*м*/
	register_inform_func("DSCI",atCcapp_RecvDsciInd);
	register_inform_func("ZCPI",atCcapp_RecvZcpiInd);
	register_inform_func("ZIMSPLUS",atCcapp_RecvImsplusInd);
    register_inform_func("ZVOICECHNL",atCcapp_RecvZvoicechnlInd);
}

#endif
