/**
 * @file ext_socket_func.h
 * @brief ṩƽ̨ڲϢϢṹ壬at_ctlƽ̨ڲģ齻Ϣ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __EXT_SOCKET_FUNC_H__
#define __EXT_SOCKET_FUNC_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "arpa/inet.h"

#include "ext_ftp_func.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/


//socket

#define UNIX_SOCKET_SERVER "socket_proxy_server"

#define NON_TRANSPARENT_MODE  0 //͸
#define TRANSPARENT_MODE	 1 //͸

#define CONN_TYPE_TCP_C  0 //tcp ͻ
#define CONN_TYPE_TCP_S	 1 //tcp 
#define CONN_TYPE_UDP	 2 //udp
#define IP_FILTER_NUM 5
#define MAX_WRITE_LEN 1460
#define MAX_WRITE_LEN_NANDIAN 2000
#define AP_LOCK "ap_lock"

struct comm_rspmsg {
	int ret;
	int err;
	int socketid;
	int len;
	int viewmode;
	int remote_mss;
};

struct comm_reqmsg {
	int socketid;
	int len;
};

struct netsrv_msg {
	int ch_id;
	int socketid;
	int conn_type;
	int viewMode;
	char ipport[128];
};
struct netcreate_msg {
	int ch_id;
	int mode;
	int socketid;
	char remote_ip[128];
	int remote_port;
	int local_port;
};
struct netcreate_rspmsg {
	int ret;
	int err;
	int socketid;
	int mode;
};
struct netping_reqmsg {
	char remote_ip[128];
	int try_count;
	int packet_size;
};

struct netping_rspmsg {
	int ret;
	int err;
	int try_count;
	int total_recv;
	int packet_size;
	char remote_ip[128];
	int echo_rep_ttl;
	char round_trip_sta[100];
};
struct netaccept_reqmsg {
	int socketid;
	int action;//Ƿ 0- 1-ܾ
	int transportMode;//ɹĴģʽ 0-͸ģʽ 1-͸ģʽ
};
struct netaccept_rspmsg {
	int ret;
	int err;
	int socketid;
	int transportMode;//ɹĴģʽ 0-͸ģʽ 1-͸ģʽ
};
struct netcon_reqmsg {
	int extcid;//ṩⲿʹõcidֵ֧1-16
	int is_userpwd;//ûΪգҪñ־λָʾǰǷû
	int cfgt;//ÿ͵ȴʱ
	int cfgp;//ݰ͵ֵ
	char apn[70];//ⲿͨչatõapn
	int  auth_type;//ⲿͨչat֤
	char username[65];//ⲿͨչatõû
	char password[65];//ⲿͨչatõ
};
struct netact_reqmsg {
	int act_type;// 1ʾ0ʾȥ
	int extcid;  //ָмȥⲿcid
};

struct neturc_reqmsg {
	int on_off;// 0-رЭջϱ 1-Эջϱ
};
struct ipfilter_reqmsg {
	int id;
	int action;
	char ip_address[128];
	char net_mask[128];
};
struct netack_rspmsg {
	int ret;
	int err;
	int socketid;
	int unacked_datalen;
	int rest_bufferlen;
};
struct type_rspmsg {
	int mode;
	int network_type;
	int extended_feature;
};
struct netact_query_rspmsg {
	int channel;
	int status;
	char ip[128];
};
struct neturc_query_rspmsg {
	int on_off;// 0-رЭջϱ 1-Эջϱ
};
struct ipfilter_config_info {
	int id;
	char ip_address[128];
	char net_mask[128];
};
struct ipfilter_query_rspmsg {
	int num;
	struct ipfilter_config_info ipfilter_info[IP_FILTER_NUM];
};
struct netopen_query_rspmsg {
	int ret;
	int socket_id;
	char local_ip[128];
	int local_port;
	char gate[128];
	char dns1[128];
	char dns2[128];
	int type;
	char dest_ip[128];
	int dest_prot;
};




//quectel socket

#define MAX_SOCKET_SERVICE_NUM 12
#define MAX_CONTEXT_NUM 16

#define MAX_SEND_LEN 1024
#define MAX_READ_LEN 1500
#define MAX_SEND_HEX_LEN 512
#define MAX_PING_NUM 10



/* */
enum service_type {
	TCP,
	UDP,
	TCP_LISTENER,
	UDP_SERVICE
};
/*ݴ */
enum access_mode {
	BUFFER_ACCESS_MODE,
	DIRECT_PUSH_MODE,
	TRANSPARENT_ACCESS_MODE
};
/*͸ģʽģʽ/ģʽ */
enum data_mode_or_cmd_mode {
	TM_DATA_MODE,
	TM_CMD_MODE
};

/*socket״̬*/
enum socket_state {
	INITIAL_STATE,
	OPENING_STATE,
	CONNECTED_STATE,
	LISTENING_STATE,
	CLOSING_STATE
};

/*ѯ״̬ */
enum query_type {
	QUERY_CONNECTION_STATUS_BY_CONTEXTID,
	QUERY_CONNECTION_STATUS_BY_CONNECTID
};

/*ݷͻյ */
enum data_type {
	CHANGEABLE_LENGTH,
	FIXED_LENGTH,
	UDP_DATA,
	QUERY_DATA_INFO
};

/*ݷ͵Ľ */
enum send_rsp {
	SEND_OK,
	SEND_FAIL,
	SEND_ERROR,
	READY_TO_SEND
};
/*ݽյĽ */
enum read_rsp {
	READ_OK,
	NODATA_READ,
	CONNECTION_EXIST,
	CONNECTION_NOT_EXIST
};
/*ģʽлĽ */
enum swtmd_rsp {
	SW_SUCC,
	SW_FAIL
};
enum dns_action_req {
	DNS_CFG_WITH_SECDNSADDR,
	DNS_CFG_NO_SECDNSADDR,
	DNS_QUERY
};
enum dns_action_rsp {
	DNS_ACTION_SUCC,
	DNS_ACTION_FAIL
};
struct quectel_sock_info {
	int socket;//Ӧʵsocket
	int connect_id;//
	char service_type[20];//
	struct in_addr ip_addr; //ipַ
	int  remote_port;//Զport
	int local_port;	//port
	int socket_state;
	int context_id;
	int server_id;
	int access_mode;
	int at_port;
	int total_send_length;
	int ackedbytes;
	int unackedbytes;
	int total_rcv_length;
	int have_read_length;
	int unread_length;
};

struct each_ping_req_result {
	int result;
	char remote_ip[128];
	int ping_len;
	int response_time;//in ms
	int ttl;
};

struct quectel_comm_reqmsg {
	int connect_id;
	int len;
};
struct quectel_comm_rspmsg {
	int ret;
	int err;
	int connect_id;
	int access_mode;
	//int len;
};

struct quectel_qiclose_reqmsg {
	int connect_id;
	//int len;
	int timeout;
};

struct quectel_qisend_reqmsg {
	int send_type;//0-changeable length  1-fixed length  2-udp send  3-query
	int connect_id;
	int len;
	char ip_addr[128];
	int remote_port;
};

struct quectel_qisend_rspmsg {
	int send_type;//0-changeable length  1-fixed length  2-udp send  3-query
	int ret;
	int connect_id;
	int total_send_length;
	int ackedbytes;
	int unackedbytes;
};
struct quectel_qisendex_reqmsg {
	int connect_id;
	char hex_data[MAX_SEND_HEX_LEN];
};
struct quectel_qird_reqmsg {
	int read_type;//0-changeable length  1-fixed length  2-query
	int connect_id;
	int len;
};

struct quectel_qird_rspmsg {
	int read_type;//0-changeable length  1-fixed length  2-query
	int service_type;
	int ret;
	int read_actual_length;
	char remote_ipaddr[128];
	int remote_port;
	int total_rcv_length;
	int have_read_length;
	int unread_length;
	//int ackedbytes;
	//int unackedbytes;
	char data[MAX_READ_LEN];
};
struct quectel_qiopen_msg {
	int context_id;
	int connect_id;
	char service_type[20];
	char ip_addr[128];
	int remote_port;
	int local_port;
	int access_mode;
};
struct quectel_qistate_reqmsg {
	int query_type;
	int query_id;
};
struct quectel_qistate_rspmsg {
	int num;
	int query_type;
	struct quectel_sock_info query_status_info[MAX_SOCKET_SERVICE_NUM];
};

struct quectel_qiswtmd_reqmsg {
	int connect_id;
	int access_mode;
};
struct quectel_qiswtmd_rspmsg {
	int ret;
	int access_mode;
};
struct quectel_qidnscfg_reqmsg {
	int action_type;//0-config  1-query
	int context_id;
	char pri_dns_addr[128];
	char sec_dns_addr[128];
};
struct quectel_qidnscfg_rspmsg {
	int action_type;//0-config  1-query
	int ret;
	int context_id;
	char pri_dns_addr[128];
	char sec_dns_addr[128];
};
struct quectel_qidnsgip_reqmsg {
	int context_id;
	char host_name[128];
};
struct quectel_qidnsgip_rspmsg {
	int ret;
	int error;
	int ip_count;
	int dns_ttl;
	char host_ipaddr[4][128];
};
struct quectel_qigeterror_rspmsg {
	int err;
	char errcode_description[32];
};
struct qping_reqmsg {
	int context;
	char remote_ip[128];
	int timeout;
	int ping_num;
};

struct qping_rspmsg {
	int ret;
	int ping_num;
	struct each_ping_req_result each_ping_result[MAX_PING_NUM];
	int finresult;
	int sent;
	int rcvd;
	int lost;
	int min;
	int max;
	int avg;
};
struct quectel_qiurc_rspmsg {
	int buffer_mode;
	int service_type;
	int connect_id;
	int currentrecvlength;
	char remote_ipaddr[128];
	int remote_port;
	char data[MAX_READ_LEN];
};
/*ͬźŵƿƣЭջsocketӳɹʱLEDźŵ˸*/
struct zteftp_socketled_reqmsg {
	int iswitch;/*0ʾsocketδʱLED˸״̬1ʾsocketӳɹʱLEDƣ*/
};
struct zteftp_socketled_rspmsg {
	int result;/*0ʾOK-1ʾERROR*/
};
#endif
