#ifndef CONFIG_MIN_8M_VERSION
#include "ext_socket_func.h"
#include "cfg_nv_def.h"
#include "at_context.h"
#include "kwatch_msg.h"

int netcon_extcid = -1;
char netcon_configname[10] = {0};
int netcon_value_int = 0;
char netcon_value_char[70] = {0};
extern char* normal_getzversion();
int urcsysinfo = 0;
typedef struct
{
    int mode;
    int creg;
    int cgreg;
    int cereg;
} EXT_NETSTATE_INFO;
EXT_NETSTATE_INFO urcinfo = {0};
//========================================================================================================//
//socketʵ
//========================================================================================================//
static int gsmband = 0;

static void comm_rspmsg_proc(void *rsp_msg, void**ret, int *retlen)
{
    AT_COMM_RSPMSG *msg = (AT_COMM_RSPMSG*)rsp_msg;
    char *at_str = NULL;
    int offset = 0;

    if (msg->result < 0)
    {
        at_str = malloc(32);
        assert(at_str);
        memset(at_str, 0x00, 32);
        if (msg->errcode)
        {
            sprintf(at_str, "\r\nERROR: %d\r\n", msg->errcode);
        }
        else
        {
            sprintf(at_str, "\r\nERROR\r\n");
        }
    }
    else
    {
        at_str = malloc(64);
        assert(at_str);
        memset(at_str, 0x00, 64);
        if (msg->msg_cmd == MSG_CMD_NETACT_REQ)
        {
            offset += sprintf(at_str, "\r\nOK\r\n");
            if (msg->urc_switch)
            {
                if (g_customer_type == CUSTOMER_GUODIAN)
                {
                    offset += sprintf(at_str + offset, "\r\n$MYURCACT: %d,%d\r\n", msg->extcid, msg->act_type);
                }
                else if (g_customer_type == CUSTOMER_NANDIAN)
                {
                    offset += sprintf(at_str + offset, "\r\n$MYURCACT: %d,%d,\"%s\"\r\n", msg->extcid, msg->act_type, msg->ip);
                }
            }

            *ret = at_str;
            *retlen = offset;
            return;
        }
        sprintf(at_str, "\r\nOK\r\n");
    }
    *ret = at_str;
    *retlen = strlen(at_str);

}


int ext_netcon_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
    struct netcon_reqmsg *reqmsg = malloc(sizeof(struct netcon_reqmsg));
    assert(reqmsg);
    char configname[10] = {0};
    char *l_quota = NULL;//˫
    char *r_quota = NULL;//˫
    char *at_str = NULL;

    //if (NULL == reqmsg) softap_assert("");
    //ʼ
    memset(reqmsg, 0x00, sizeof(struct netcon_reqmsg));
    reqmsg->auth_type = -1;
    reqmsg->cfgp = -1;
    reqmsg->cfgt = -1;

    reqmsg->extcid = at_paras[0] - '0';
    if (reqmsg->extcid < 0 || reqmsg->extcid >= 6)
    {
        goto error;
    }
    l_quota = strstr(at_paras, "\"");
    if (NULL == l_quota)
    {
        goto error;
    }
    r_quota = strstr(l_quota + 1, "\"");

    if (NULL == r_quota)
    {
        goto error;
    }
    memcpy(configname, l_quota + 1, r_quota - l_quota - 1);
    if (0 == at_strncmp(configname, "APN", strlen("APN")))
    {
        l_quota = strstr(r_quota + 1, "\"");
        if (l_quota == NULL)
        {
            goto error;
        }
        r_quota = strstr(l_quota + 1, "\"");
        if (r_quota == NULL)
        {
            goto error;
        }
        memcpy(reqmsg->apn, l_quota + 1, r_quota - l_quota - 1);
        memset(netcon_value_char, 0, sizeof(netcon_value_char));
        memcpy(netcon_value_char, l_quota + 1, r_quota - l_quota - 1);
    }
    else if (0 == at_strncmp(configname, "USERPWD", strlen("USERPWD")))
    {
        l_quota = strstr(r_quota + 1, "\"");
        if (l_quota == NULL)
        {
            goto error;
        }
        r_quota = strstr(l_quota + 1, "\"");
        if (r_quota == NULL)
        {
            goto error;
        }
        char *comma = strstr(l_quota + 1, ",");
        if (NULL != comma)   //жţû벻Ϊ
        {
            if (comma > r_quota)
            {
                goto error;
            }
            memcpy(reqmsg->username, l_quota + 1, comma - l_quota - 1);
            memcpy(reqmsg->password, comma + 1, r_quota - comma - 1);
        }
        memset(netcon_value_char, 0, sizeof(netcon_value_char));
        memcpy(netcon_value_char, l_quota + 1, r_quota - l_quota - 1);

        reqmsg->is_userpwd = 1;
    }
    else if (0 == at_strncmp(configname, "CFGT", strlen("CFGT")))
    {
        int len = strlen(r_quota + 2);
        char* str = malloc(len + 1);
        assert(str);
        strcpy(str, r_quota + 2);
        reqmsg->cfgt = atoi(str);
        if (reqmsg->cfgt < 1 || reqmsg->cfgt > 65535)
        {
            free(str);
            goto error;
        }
        netcon_value_int = atoi(str);
        free(str);
    }
    else if (0 == at_strncmp(configname, "CFGP", strlen("CFGP")))
    {
        int len = strlen(r_quota + 2);
        char* str = malloc(len + 1);
        assert(str);
        strcpy(str, r_quota + 2);
        reqmsg->cfgp = atoi(str);
        if (reqmsg->cfgp < 1 || reqmsg->cfgp > 1460)
        {
            free(str);
            goto error;
        }
        netcon_value_int = atoi(str);
        free(str);
    }
    else if (0 == at_strncmp(configname, "AUTH", strlen("AUTH")))
    {
        int len = strlen(r_quota + 2);
        char* str = malloc(len + 1);
        assert(str);
        strcpy(str, r_quota + 2);
        reqmsg->auth_type = atoi(str);
        if (reqmsg->auth_type < 0 || reqmsg->auth_type > 2)
        {
            free(str);
            goto error;
        }
        netcon_value_int = atoi(str);
        free(str);
    }
    else
    {
        goto error;
    }
    netcon_extcid = reqmsg->extcid;
    strncpy(netcon_configname, configname, sizeof(netcon_configname) - 1);

    *res_msg = reqmsg;
    *res_msglen = sizeof(struct netcon_reqmsg);
    return AT_CONTINUE;
error:
    free(reqmsg);
    at_str = malloc(32);
    assert(at_str);
    memset(at_str, 0x00, 32);
    sprintf(at_str, "\r\nERROR: 980\r\n");
    *res_msg = at_str;
    *res_msglen = strlen(at_str);
    return AT_END;
}
int ext_netcon_rsp(void *rsp_msg, void**ret, int *retlen)
{
    comm_rspmsg_proc(rsp_msg, ret, retlen);
    return AT_END;
}

int ext_netact_req(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
    struct netact_reqmsg *reqmsg = malloc(sizeof(struct netact_reqmsg));
    assert(reqmsg);
    char *p[2] = {&reqmsg->extcid, &reqmsg->act_type};
    char *at_str = NULL;
    memset(reqmsg, 0x00, sizeof(struct comm_reqmsg));
    if (2 != parse_param2("%d,%d", at_paras, p))
    {
        free(reqmsg);
        at_str = malloc(32);
        assert(at_str);
        memset(at_str, 0x00, 32);
        sprintf(at_str, "\r\nERROR: 980\r\n");
        *res_msg = at_str;
        *res_msglen = strlen(at_str);
        return AT_END;
    }

    *res_msg = reqmsg;
    *res_msglen = sizeof(struct netact_reqmsg);
    return AT_CONTINUE;
}
int ext_netact_rsp(void *rsp_msg, void**ret, int *retlen)
{
    comm_rspmsg_proc(rsp_msg, ret, retlen);

    return AT_END;
}

/*ػ*/
int ext_poweroff_req(int at_fd, char * at_paras, void **res_msg, int * res_msglen)
{
    return AT_CONTINUE;
}



int ext_i_act_func(int at_fd, char * at_paras, void * *res_msg, int * res_msglen)
{
    char *at_str = NULL;

    at_str = malloc(128);
    assert(at_str);
    memset(at_str, 0, 128);
    sprintf((char*)at_str, "\r\nLQBS\r\nLQ300V3\r\nREVISION V1.0.0\r\nOK\r\n");

    *res_msg = at_str;
    *res_msglen = strlen(*res_msg);
    return AT_END;
}
int ext_myband_set_func(char *at_paras, void ** res_msg)
{
    if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYBAND_SET_REQ, strlen(at_paras),
                       (unsigned char *)at_paras, 0))
    {
        softap_assert("");
    }
    return AT_CONTINUE;
}

int ext_myband_query_func(char *at_paras, void ** res_msg)
{
    if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYBAND_QUERY_REQ, 0, NULL, 0))
    {
        softap_assert("");
    }
    return AT_CONTINUE;
}

int ext_beeh_act_func(int at_fd, char * at_paras, void * *res_msg, int * res_msglen)
{
    *res_msg = at_ok_build();
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

int ext_poweroff_rsp(void *rsp_msg, void**ret, int *retlen)
{
    char *at_str = NULL;

    at_str = at_ok_build();

    *ret = at_str;
    *retlen = strlen(at_str);

    return AT_END;
}

/*ⲿ汾*/
int ext_gmr_act_func(int at_fd, char * at_paras, void * *res_msg, int * res_msglen)
{
    char hwver[32] = {0};
    char swver[32] = {0};
    char *at_str = NULL;

    //sc_cfg_get(NV_HW_VERSION, hwver, sizeof(hwver));
    //sc_cfg_get(NV_WA_VERSION, swver, sizeof(swver));
    //̴šģͺšӲڡλȡ
    at_str = malloc(128);
    assert(at_str);
    memset(at_str, 0, 128);
    sprintf((char*)at_str, "\r\nLQBS\r\nLQ300V3\r\nV1.0.0\r\n151017\r\nV1.0\r\n151017\r\nOK\r\n");
    *res_msg = at_str;
    *res_msglen = strlen(*res_msg);
    return AT_END;
}
/*ȡSIMк*/
int ext_ccid_act_func(int at_fd, char * at_paras, void * *res_msg, int * res_msglen)
{
    char iccid[32] = {0};
    char *at_str = NULL;

    at_str = malloc(64);
    assert(at_str);
    memset(at_str, 0, 64);
    sc_cfg_get(NV_ZICCID, iccid, sizeof(iccid));
    //at_print(1,"ext_ccid_act_func: iccid = %s\n",iccid);
    sprintf((char*)at_str, "\r\n$MYCCID: \"%s\"\r\nOK\r\n", iccid);
    *res_msg = at_str;
    *res_msglen = strlen(*res_msg);
    return AT_END;
}
int ext_netcon_query_func(int at_fd, char *at_paras, void ** res_msg, int *res_msglen)
{
    char *at_str = NULL;
    int offset = 0;

    if (netcon_extcid == -1)
    {
        at_str = malloc(32);
        assert(at_str);
        memset(at_str, 0x00, 32);
        sprintf(at_str, "\r\nERROR\r\n");
    }
    else
    {
        at_str = malloc(32 + sizeof(netcon_extcid) + sizeof(netcon_configname) + sizeof(netcon_value_char));
        assert(at_str);
        memset(at_str, 0, 32 + sizeof(netcon_extcid) + sizeof(netcon_configname) + sizeof(netcon_value_char));
        offset += sprintf(at_str + offset, "\r\n$MYNETCON: %d,\"%s\",", netcon_extcid, netcon_configname);
        if (0 == at_strncmp(netcon_configname, "APN", strlen("APN"))
                || 0 == at_strncmp(netcon_configname, "USERPWD", strlen("USERPWD")))
        {
            offset += sprintf(at_str + offset, "\"%s\"\r\nOK\r\n", netcon_value_char);
        }
        else
        {
            offset += sprintf(at_str + offset, "%d\r\nOK\r\n", netcon_value_int);
        }
    }

    *res_msg = at_str;
    *res_msglen = strlen(*res_msg);
    return AT_END;

}

int ext_gmr_query_func(char *at_paras, void ** res_msg)
{
    if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_GMR_QUERY_REQ, 0, NULL, 0))
    {
        softap_assert("");
    }
    return AT_CONTINUE;
}
int ext_gmr_func(int at_fd, char * at_paras, void * *res_msg, int * res_msglen)
{
    *res_msg = at_ok_build();
    *res_msglen = strlen(*res_msg);
    return AT_END;
}

int ext_mysysinfo_query_func(char *at_paras, void ** res_msg)
{
    if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYSYSINFO_QUERY_REQ, 0, NULL, 0))
    {
        softap_assert("");
    }
    return AT_CONTINUE;
}

int ext_mynetinfo_set_func(char *at_paras, void ** res_msg)
{
    if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYNETINFO_SET_REQ, strlen(at_paras),
                       (unsigned char *)at_paras, 0))
    {
        softap_assert("");
    }
    return AT_CONTINUE;
}

int ext_mynetinfo_query_func(char *at_paras, void ** res_msg)
{
    if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYNETINFO_QUERY_REQ, 0, NULL, 0))
    {
        softap_assert("");
    }
    return AT_CONTINUE;
}

int ext_urcsysinfo_act_func(char *at_paras, void ** res_msg)
{
    int flag = 0;
    void *p[1] = {&flag};
    int ret = 0;
    ret = parse_param("%d", at_paras, p);
    if (ret != AT_PARSE_OK)
    {
        return AT_END;
    }
    if (1 == flag)
    {
        urcsysinfo = 1;
        *res_msg = at_ok_build();
    }
    else
    {
        *res_msg = at_err_build(0);
    }
    return AT_END;
}

int mode_inform_act(char *at_paras, int is_query_report)
{
    int mode = 0;
    void *p[1] = {&mode};
    int ret = 0;
    ret = parse_param("%d", at_paras, p);
    if (ret != AT_PARSE_OK)
    {
        return AT_END;
    }
    if ((mode != urcinfo.mode) && (urcsysinfo == 1))
    {
        urcinfo.mode = mode;
        if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYURCSYSINFO_INFORM_REQ, 0, NULL, 0))
        {
            softap_assert("");
        }
    }
    return AT_END;
}

int net_state_transfer(int state)
{
    if ((state == 1) || (state == 5))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}
int creg_inform_act(char *at_paras, int is_query_report)
{
    int state = 0;
    void *p[1] = {&state};
    int ret = 0;
    ret = parse_param("%d", at_paras, p);
    if (ret != AT_PARSE_OK)
    {
        return AT_END;
    }
    state = net_state_transfer(state);
    if ((state != urcinfo.creg) && (urcsysinfo == 1))
    {
        urcinfo.creg = state;
        if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYURCSYSINFO_INFORM_REQ, 0, NULL, 0))
        {
            softap_assert("");
        }
    }
    return AT_END;
}
int cgreg_inform_act(char *at_paras, int is_query_report)
{
    int state = 0;
    void *p[1] = {&state};
    int ret = 0;
    ret = parse_param("%d", at_paras, p);
    if (ret != AT_PARSE_OK)
    {
        return AT_END;
    }
    state = net_state_transfer(state);
    if ((state != urcinfo.cgreg) && (urcsysinfo == 1))
    {
        urcinfo.cgreg = state;
        if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYURCSYSINFO_INFORM_REQ, 0, NULL, 0))
        {
            softap_assert("");
        }
    }
    return AT_END;
}
int cereg_inform_act(char *at_paras, int is_query_report)
{
    int state = 0;
    void *p[1] = {&state};
    int ret = 0;
    ret = parse_param("%d", at_paras, p);
    if (ret != AT_PARSE_OK)
    {
        return AT_END;
    }
    state = net_state_transfer(state);
    if ((state != urcinfo.cereg) && (urcsysinfo == 1))
    {
        urcinfo.cereg = state;
        if (unix_send_proc(get_default_sockfd(), MODULE_ID_SOCKET_PROXY, MSG_CMD_MYURCSYSINFO_INFORM_REQ, 0, NULL, 0))
        {
            softap_assert("");
        }
    }
    return AT_END;
}

int ext_time_set_func(char *at_paras, void ** res_msg)
{
    char settime[32] = {0};
    void *p[] = {settime};
    int ret = 0;
    char *at_str = NULL;
    at_str = malloc(16);
    assert(at_str);
    memset(at_str, 0, 16);
    struct tm set_tm = {0};
    struct timeval time_tv = {0};
    struct timezone time_tz = {0, 0};

    ret = parse_param("%32s", at_paras, p);
    if (ret != AT_PARSE_OK)
    {
        sprintf(at_str, "\r\nERROR: 980\r\n");
        *res_msg = at_str;
        return AT_END;
    }
    sscanf(settime, "%2d/%2d/%2d,%2d:%2d:%2d", &set_tm.tm_year,
           &set_tm.tm_mon, &set_tm.tm_mday, &set_tm.tm_hour, &set_tm.tm_min, &set_tm.tm_sec);
    at_print(1, "ext_time_set_func: %2d/%2d/%2d,%2d:%2d:%2d\n", set_tm.tm_year,
             set_tm.tm_mon, set_tm.tm_mday, set_tm.tm_hour, set_tm.tm_min, set_tm.tm_sec);

#if 1   // kw 3
    if (set_tm.tm_year < 0 || set_tm.tm_year > 5000)
    {
        set_tm.tm_year = 1970;
    }

    if (set_tm.tm_mon < 0 || set_tm.tm_mon > 13)
    {
        set_tm.tm_mon = 1;
    }
#endif
    set_tm.tm_year = set_tm.tm_year + 100;
    set_tm.tm_mon = set_tm.tm_mon - 1;

    time_tv.tv_sec = mktime(&set_tm);
    if (time_tv.tv_sec < 0) // cov M
    {
        time_tv.tv_sec = 0;
    }

    //	time_tv.tv_sec = time_tv.tv_sec;  // cov M
    struct tm * new_time = gmtime(&time_tv.tv_sec);
    if (new_time)
    {
        time_tz.tz_minuteswest = (mktime(new_time) - (time_tv.tv_sec)) / 60;
    }

    if (0 != settimeofday(&time_tv, &time_tz))
    {
        at_print(AT_ERR, "zmmi_auto_act,set time of system wrong");
        sprintf(at_str, "\r\nERROR: 981\r\n");
        *res_msg = at_str;
        return AT_END;
    }
    rtc_set_time(MODULE_ID_AT_CTL);
    sprintf(at_str, "\r\nOK\r\n");
    *res_msg = at_str;
    return AT_END;
}

int ext_time_query_func(char *at_paras, void ** res_msg)
{
    struct tm *p;
    time_t timep;
    char buf[32] = {0};
    char *at_str = NULL;
    at_str = malloc(64);
    assert(at_str);
    memset(at_str, 0, 64);
    time(&timep);
    p = localtime(&timep);
    assert(p);
    snprintf(buf, 32, "%02d/%02d/%02d,%02d:%02d:%02d", (1900 + p->tm_year) % 100, 1 + p->tm_mon, p->tm_mday, p->tm_hour,
             p->tm_min, p->tm_sec);
    at_print(1, "ext_time_query_func: time: %s\n", buf);
    sprintf(at_str, "\r\n+CCLK: \"%s\"\r\nOK\r\n", buf);
    *res_msg = at_str;
    return AT_END;
}

#ifdef USE_CAP_SUPPORT
int ext_nitz_query_func(char *at_paras, void ** res_msg)
{
    struct tm *p = 0;
    time_t timep;
    char buf[32] = {0};
    char time_zone[16] = {0};
    char sav_time[16] = {0};
    char nitz_valid[16] = {0};
    char *at_str = NULL;

    sc_cfg_get("nitz_time_zone", time_zone, sizeof(time_zone) - 1);
    sc_cfg_get("nitz_sav_time", sav_time, sizeof(sav_time) - 1);

    at_str = malloc(64);
    assert(at_str);
    memset(at_str, 0, 64);

    sc_cfg_get("nitz_is_valid", nitz_valid, sizeof(nitz_valid) - 1);
    if (1 != atoi(nitz_valid))
    {
        sprintf(at_str, "\r\n+ZNITZ: 0,0,\"\"\r\nOK\r\n");
        *res_msg = at_str;
        return AT_END;
    }

    time(&timep);
    p = gmtime(&timep);
    assert(p);
    snprintf(buf, 32, "%02d/%02d/%02d,%02d:%02d:%02d", (1900 + p->tm_year) % 100, 1 + p->tm_mon, p->tm_mday, p->tm_hour,
             p->tm_min, p->tm_sec);

    at_print(1, "ext_nitz_query_func: time: %s\n", buf);

    sprintf(at_str, "\r\n+ZNITZ: %s,%s,\"%s\"\r\nOK\r\n", time_zone, sav_time, buf);

    *res_msg = at_str;

    return AT_END;
}
#endif

int  ext_user_modem_regist(void)
{
    //#ifdef GUODIAN
    if (g_customer_type == CUSTOMER_GUODIAN)
    {
        //PDP
        register_serv_func2("MYNETCON=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETCON_REQ, MSG_CMD_NETCON_RSP, ext_netcon_req,
                            ext_netcon_rsp);
        register_serv_func2("MYNETACT=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACT_REQ, MSG_CMD_NETACT_RSP, ext_netact_req,
                            ext_netact_rsp);
        register_serv_func2("MYPOWEROFF", MODULE_ID_MAIN_CTRL, MSG_CMD_POWEROFF_REQUEST, MSG_CMD_POWEROFF_RSP, ext_poweroff_req,
                            ext_poweroff_rsp);

        register_serv_func2("MYGMR", 0, 0, 0, ext_gmr_act_func, NULL);
        register_serv_func2("MYCCID", 0, 0, 0, ext_ccid_act_func, NULL);
        register_serv_func2("ATI", 0, 0, 0, ext_i_act_func, NULL);

        register_serv_func2("MYBCCH?", 0, 0, 0, ext_beeh_act_func, NULL);
        register_serv_func2("MYBCCH=?", 0, 0, 0, ext_beeh_act_func, NULL);
        register_serv_func2("MYBCCH=", 0, 0, 0, ext_beeh_act_func, NULL);

        register_serv_func("MYBAND=", MODULE_ID_SOCKET_PROXY, ext_myband_set_func);
        register_serv_func("MYBAND?", MODULE_ID_SOCKET_PROXY, ext_myband_query_func);

        register_serv_func2("MYNETCON?", 0, 0, 0, ext_netcon_query_func, NULL);

        register_serv_func("GMR", MODULE_ID_SOCKET_PROXY, ext_gmr_query_func);
        register_serv_func2("GMR=?", 0, 0, 0, ext_gmr_func, NULL);
    }
    else if (g_customer_type == CUSTOMER_NANDIAN)
    {
        register_serv_func2("MYPOWEROFF", MODULE_ID_MAIN_CTRL, MSG_CMD_POWEROFF_REQUEST, MSG_CMD_POWEROFF_RSP, ext_poweroff_req,
                            ext_poweroff_rsp);
        register_serv_func2("MYNETCON=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETCON_REQ, MSG_CMD_NETCON_RSP, ext_netcon_req,
                            ext_netcon_rsp);
        register_serv_func2("MYNETCON?", 0, 0, 0, ext_netcon_query_func, NULL);
        register_serv_func2("MYNETACT=", MODULE_ID_SOCKET_PROXY, MSG_CMD_NETACT_REQ, MSG_CMD_NETACT_RSP, ext_netact_req,
                            ext_netact_rsp);

        register_serv_func2("MYGMR", 0, 0, 0, ext_gmr_act_func, NULL);
        register_serv_func2("MYCCID", 0, 0, 0, ext_ccid_act_func, NULL);

        register_serv_func2("ATI", 0, 0, 0, ext_i_act_func, NULL);
        register_serv_func("GMR", MODULE_ID_SOCKET_PROXY, ext_gmr_query_func);
        register_serv_func2("GMR=?", 0, 0, 0, ext_gmr_func, NULL);

        register_serv_func("MYURCSYSINFO=", 0, ext_urcsysinfo_act_func);
        register_serv_func("MYSYSINFO", MODULE_ID_SOCKET_PROXY, ext_mysysinfo_query_func);
        register_serv_func("MYNETINFO=", MODULE_ID_SOCKET_PROXY, ext_mynetinfo_set_func);
        register_serv_func("MYNETINFO?", MODULE_ID_SOCKET_PROXY, ext_mynetinfo_query_func);

        register_inform_func("CEREG", cereg_inform_act);
        register_inform_func("CGREG", cgreg_inform_act);
        register_inform_func("CREG", creg_inform_act);
        register_inform_func("MODE", mode_inform_act);
    }
    register_serv_func("CCLK=", 0, ext_time_set_func);
    register_serv_func("CCLK?", 0, ext_time_query_func);

#ifdef USE_CAP_SUPPORT
    register_serv_func("ZNITZ?", 0, ext_nitz_query_func);
#endif
    return 0;
}

#endif
