#include "ext_regist.h"

#include "NvParam_drv.h"
#include "libcpnv.h"
#define ZOSS_ERROR              0xffffffff
#define ZOSS_SUCCESS            0x0

/*wdt  nv  flag*/
#define WDT_OFF 			(0x57445446) //ascii:WDTF
#define WDT_ON 				(0x5744544F) //ascii:WDTO

#define ZX_WDT_IOC_MAGIC     'W'

/*ioctl cmd usd by device*/
#define ZX_WDT_SET_INTERNAL         	_IOW(ZX_WDT_IOC_MAGIC, 1, char *)
#define ZX_WDT_SET_WAKEUP            	_IOW(ZX_WDT_IOC_MAGIC, 2, char *)
#define ZX_WDT_FEED_DOG            		_IOW(ZX_WDT_IOC_MAGIC, 3, char *)
#define ZX_WDT_GET_HANDLE_TIMEOUT     	_IOWR(ZX_WDT_IOC_MAGIC, 4, char *)
#define ZX_WDT_GET_GLOBAL_CNT       	_IOWR(ZX_WDT_IOC_MAGIC, 5, char *)
#define ZX_WDT_GET_AP_TIMEOUT       	_IOWR(ZX_WDT_IOC_MAGIC, 6, char *)
#define ZX_WDT_SET_AP_SWITCH      		_IOWR(ZX_WDT_IOC_MAGIC, 7, char *)
#define ZX_WDT_SET_NV      				_IOWR(ZX_WDT_IOC_MAGIC, 8, char *)
#define ZX_WDT_GET_NV      				_IOWR(ZX_WDT_IOC_MAGIC, 9, char *)
#define ZX_WDT_SET_CHECK				_IOWR(ZX_WDT_IOC_MAGIC, 10, char *)

#define ZX_SOFT_WDT_DEV    				"/dev/zx_soft_wdt"


extern int zx_wdt_set_nv(BOOL nv_flag);
extern BOOL zx_wdt_get_wdtnv_for_ctrm(void);
//static long int wdt_fd;

int wdt_act_func(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    char			*at_str  		= NULL;
    unsigned long   retCode 		= ZOSS_ERROR;
	int	    		nv_value 		= 0;
	unsigned int wdt_nvdata = 0;

	assert(at_paras!=NULL);
	at_str = at_paras; 	

	 get_at_cmd_param_int(at_str, &nv_value, &at_str);
	 at_print(AT_DEBUG,"wdt_act_func:nv_value == %d\n", nv_value);
	 
	 if(0 == nv_value )
	 {
	 	
	 	//ioctl(wdt_fd, ZX_WDT_SET_NV, FALSE);
	 	wdt_nvdata=WDT_OFF;
	 	retCode = cpnv_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(wdtSwitch), (unsigned char *)(&wdt_nvdata), DRV_SYS_NV_ITEM_SIZE(wdtSwitch));
		if(ZOSS_SUCCESS == retCode ){
			retCode= cpnv_NvramFlush();
		}

	 }
	 else if(1 == nv_value )
	 {
	 	//ioctl(wdt_fd, ZX_WDT_SET_NV, TRUE);
	 	wdt_nvdata=WDT_ON;	
	 	retCode = cpnv_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(wdtSwitch), (unsigned char *)(&wdt_nvdata), DRV_SYS_NV_ITEM_SIZE(wdtSwitch));
		if(ZOSS_SUCCESS == retCode ){
			retCode= cpnv_NvramFlush();
		}
	 }
	 else 
	 {
		 *res_msg = at_err_build(ATERR_PARAM_INVALID);
		 *res_msglen = strlen(*res_msg);
		 return AT_END;
	 }
	 
	if (retCode == ZOSS_SUCCESS)
	{
		*res_msg = at_query_result_build("WDT=",at_str);
	}
	else
	{
		*res_msg = at_err_build(ATERR_PROC_FAILED); 	
	}
	   
	*res_msglen = strlen(*res_msg);
    return AT_END;
}

int wdt_get_nv_state(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{

	unsigned int wdt_nvdata = 0;
    long retCode = CPNV_ERROR;

	//ioctl(wdt_fd, ZX_WDT_GET_NV, &retCode);
	
	retCode =cpnv_NvItemRead(DRV_SYS_NV_ITEM_ADDR(wdtSwitch), (unsigned char *)(&wdt_nvdata), DRV_SYS_NV_ITEM_SIZE(wdtSwitch));
	if(CPNV_ERROR == retCode) softap_assert("");
	if (WDT_OFF == wdt_nvdata )
	{
		*res_msg = at_query_result_build("WDT","WDT OFF");
		
	} else if(WDT_ON== wdt_nvdata ) 
	{
		*res_msg = at_query_result_build("WDT","WDT ON");
	}
	else
	{
		*res_msg = at_err_build(ATERR_PROC_FAILED);
	}
		
	*res_msglen = strlen(*res_msg);
	return AT_END;
}

int wdt_set_nv_priority(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
    char			*at_str  		= NULL;
    unsigned long   retCode 		= ZOSS_ERROR;
	int	    		nv_value 		= 0;
	char strCmd[AT_CMD_MAX] = {0};

	assert(at_paras!=NULL);
	at_str = at_paras; 	

	 get_at_cmd_param_int(at_str, &nv_value, &at_str);
	 at_print(AT_DEBUG,"wdt_set_nv_priority:nv_value == %d\n", nv_value);
	 
	 if((nv_value > 0)&&(nv_value <= 99))//priority
	 {
	 	retCode = cpnv_NvItemWrite(DRV_SYS_NV_ITEM_ADDR(wdtPriority), (unsigned char *)(&nv_value), DRV_SYS_NV_ITEM_SIZE(wdtPriority));
		if(ZOSS_SUCCESS == retCode ){
			retCode= cpnv_NvramFlush();
		}
	 }
	 else 
	 {
		 *res_msg = at_err_build(ATERR_PARAM_INVALID);
		 *res_msglen = strlen(*res_msg);
		 return AT_END;
	 }
	 
	if (retCode == ZOSS_SUCCESS)
	{
		sprintf(strCmd,"%d", nv_value); 
		*res_msg = at_query_result_build("WDTP=",strCmd);
	}
	else
	{
		*res_msg = at_err_build(ATERR_PROC_FAILED); 	
	}
	   
	*res_msglen = strlen(*res_msg);
    return AT_END;
}

int wdt_get_nv_priority(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	unsigned int wdt_nvdata = 0;
    long retCode = CPNV_ERROR;
	char strCmd[AT_CMD_MAX] = {0};
	
	retCode =cpnv_NvItemRead(DRV_SYS_NV_ITEM_ADDR(wdtPriority), (unsigned char *)(&wdt_nvdata), DRV_SYS_NV_ITEM_SIZE(wdtPriority));
	if(CPNV_ERROR == retCode) softap_assert("");

	sprintf(strCmd,"%d", wdt_nvdata);

	*res_msg = at_query_result_build("WDTP",strCmd);
	*res_msglen = strlen(*res_msg);
	return AT_END;
}


/*****************
*
*
*/

#define RPMSG_IOC_MAGIC     'R'

/*ioctl cmd usd by device*/
#define RPMSG_CREATE_CHANNEL          _IOW(RPMSG_IOC_MAGIC, 1, char *)
#define RPMSG_GET_DATASIZE       _IOWR(RPMSG_IOC_MAGIC, 2, char *)
#define RPMSG_SET_INT            _IOW(RPMSG_IOC_MAGIC, 3, char *)
#define RPMSG_SET_INT_FLAG        _IOW(RPMSG_IOC_MAGIC, 4, char *)
#define RPMSG_CLEAR_INT_FLAG      _IOW(RPMSG_IOC_MAGIC, 5, char *)
#define RPMSG_SET_POLL_FLAG       _IOW(RPMSG_IOC_MAGIC, 6, char *)
#define RPMSG_CLEAR_POLL_FLAG     _IOW(RPMSG_IOC_MAGIC, 7, char *)
#define AT_CAP_DEV    "/dev/rpmsg2"

 static void write_lockfile(char *filepath, char *setbuf)
 {	
 	int f, len = 0;	
	f = open(filepath, O_RDWR);	
	if (f == -1) {
	 	at_print(AT_DEBUG,"write_lockfile OPEN FAIL\n");
		return;	
	}	
	len = strlen(setbuf);	
	if (write(f, setbuf, len) != len) 
	{	} 
	else 
	{	}
	
	close(f);
}

static int pm_apadd_wakelock(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	char strCmd[AT_CMD_MAX] = {0};

	write_lockfile("/sys/power/wake_lock", "test_wakelock");

	*res_msg = at_query_result_build("delete_lock",strCmd);	
	*res_msglen = strlen(*res_msg);	
	return AT_END;
}

static int pm_apdelete_wakelock(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	char strCmd[AT_CMD_MAX] = {0};

	write_lockfile("/sys/power/wake_unlock", "test_wakelock");

	*res_msg = at_query_result_build("delete_lock",strCmd);	
	*res_msglen = strlen(*res_msg);
	
	return AT_END;
}


static int pm_capadd_wakelock(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	char strCmd[AT_CMD_MAX] = {0};
	unsigned int ctx=0x5a5a;
	int fd, ret;
	
	 at_print(AT_DEBUG,"pm_capadd_wakelock\n");


	fd =open(AT_CAP_DEV, O_RDWR);
	if(fd<0){
	 	at_print(AT_DEBUG,"cap add  open FAIL\n");
		return -1;	
	}

	ret=ioctl(fd, RPMSG_SET_INT_FLAG, NULL);
	if(ret<0){
	 	at_print(AT_DEBUG,"cap add  ioctl FAIL\n");
		close(fd);
		return AT_END;	
	}		
	ret=write(fd, &ctx, 4);
	if(ret<0){
	 	at_print(AT_DEBUG,"cap add  write FAIL\n");
		close(fd);
		return AT_END;	
	}
	
	*res_msg = at_query_result_build("capadd_lock",strCmd);	
	*res_msglen = strlen(*res_msg);
	
	close(fd);
	
	return AT_END;
}

static int pm_capdelete_wakelock(int at_fd,char * at_paras,void * *res_msg,int * res_msglen)
{
	char strCmd[AT_CMD_MAX] = {0};

	unsigned int ctx=0x5a5b;
	int fd, ret;
	
	 at_print(AT_DEBUG,"pm_capdelete_wakelock\n");

	fd =open(AT_CAP_DEV, O_RDWR);
	if(fd<0){
	 	at_print(AT_DEBUG,"cap add  open FAIL\n");
		return -1;	
	}

	ret=ioctl(fd, RPMSG_SET_INT_FLAG, NULL);
	if(ret<0){
	 	at_print(AT_DEBUG,"cap add  ioctl FAIL\n");
		close(fd);
		return AT_END;	
	}		
	ret=write(fd, &ctx, 4);
	if(ret<0){
	 	at_print(AT_DEBUG,"cap add  write FAIL\n");
		close(fd);
		return AT_END;	
	}

	close(fd);
	
	*res_msg = at_query_result_build("capdelete_lock",strCmd);	
	*res_msglen = strlen(*res_msg);
	
	return AT_END;
}
void ext_wdt_regist_init(void)
{
	//wdt_fd = open(ZX_SOFT_WDT_DEV, O_RDWR);
	//ioctl(wdt_fd, ZX_WDT_SET_CHECK, FALSE);

	register_serv_func2("WDT=", 0, 0, 0, wdt_act_func, NULL);
	register_serv_func2("WDT?", 0, 0, 0,wdt_get_nv_state,NULL);
	register_serv_func2("WDTP=", 0, 0, 0, wdt_set_nv_priority, NULL);
	register_serv_func2("WDTP?", 0, 0, 0,wdt_get_nv_priority,NULL);

	register_serv_func2("apadd_lock", 0, 0, 0,pm_apadd_wakelock,NULL);
	register_serv_func2("apdel_lock", 0, 0, 0,pm_apdelete_wakelock,NULL);
	register_serv_func2("capadd_lock", 0, 0, 0,pm_capadd_wakelock,NULL);
	register_serv_func2("capdel_lock", 0, 0, 0,pm_capdelete_wakelock,NULL);		
}

