/**
 * 
 * @file      ext_zcat_func.c
 * @brief     
 *            This file is part of ZCAT.
 *            ZCATģAT
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/05/22  1.0      hou.bing       Create file
 * 2019/01/15  1.1      jiang.fenglin  /ѯzcat_usblog
 * 2019/02/02  1.2      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/07/08  1.3      jiang.fenglin  APFS/CPFSģʽ
 * ---------------------------------------------------------------------------
 * 
 * 
 */


#if (APP_OS_TYPE == APP_OS_LINUX)
#include "ext_regist.h"
#include "at_utils.h"
#include "softap_api.h"
#include "zxic_errno.h"  
#include "nv_api.h"
//#include "nvserver.h"

#ifndef max
#define max(a, b)           (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a, b)           (((a) < (b)) ? (a) : (b))
#endif


/**
 * ʵ
 */

int ext_zcat_set_mode(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
	char  zcat_mode[512] = {0};
	//E_AT_PARSE parseRst = AT_PARSE_SUCCESS;

    printf("ext_zcat_set %s,len is %d\n",at_paras,strlen(at_paras));
    memcpy(zcat_mode,at_paras,min(strlen(at_paras), sizeof(zcat_mode) - 1));
	printf("zcat_mode is %s",zcat_mode);
	if(0==strcmp(zcat_mode,"APUSB") || 0==strcmp(zcat_mode,"APNET") || 0==strcmp(zcat_mode,"APTF") \
		|| 0==strcmp(zcat_mode,"APFS") || 0==strcmp(zcat_mode,"CPFS") \
		|| 0==strcmp(zcat_mode,"CPUSB") || 0==strcmp(zcat_mode,"CPTF"))
	{
        sc_cfg_set("zcat_mode",zcat_mode);
        sc_cfg_save();
		nv_set_item("cfg","zcat_mode", zcat_mode,1);
		nv_commit("cfg");
	}
	else
	{
        *res_msg = at_err_build(ATERR_PARAM_INVALID);	
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

    *res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);

	return AT_END;
	#if 0
	switch(iNetcardType)
	{
		case 0:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_ndis",1);
			break;
		}
		case 1:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_ecm",1);
			break;
		}
		case 2:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_mbim",1);
			break;
		}
		case 3:
		{
			nv_set_item(NV_RO,"forcenetcard_type", "force_rndis",1);
			break;
		}
		default:
		{
			*res_msg = at_err_build(ATERR_PARAM_INVALID);	
			*res_msglen = strlen(*res_msg);
			return AT_END;
		}
	}
	nv_commit(NV_RO);

	*res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);

	return AT_END;
	#endif
}


int ext_zcat_get_mode(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
    char  zcat_mode[512] = {0};
    printf("ext_zcat_get %s\n",at_paras);

	if(-1 == sc_cfg_get("zcat_mode", zcat_mode, sizeof(zcat_mode)))
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);	
		*res_msglen = strlen(*res_msg);
		return AT_END;
    }
	nv_get_item("cfg", "zcat_mode", zcat_mode, sizeof(zcat_mode));
    printf("zcat_mode is %s ,%d",zcat_mode,strlen(zcat_mode));
	*res_msg = at_query_result_build("ZCAT_MODE",zcat_mode);
	*res_msglen = strlen(*res_msg);
    return AT_END;

}


int ext_zcat_set_usblog(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
	char  zcat_usblog[512] = {0};
	//E_AT_PARSE parseRst = AT_PARSE_SUCCESS;

    printf("ext_zcat_set %s,len is %d\n", at_paras, strlen(at_paras));
    memcpy(zcat_usblog, at_paras, min(strlen(at_paras), sizeof(zcat_usblog)-1));
	printf("zcat_usblog is %s", zcat_usblog);
	if(strstr(zcat_usblog, "tty"))
	{
        sc_cfg_set("zcat_usblog", zcat_usblog);
        sc_cfg_save();
		nv_set_item("cfg", "zcat_usblog", zcat_usblog, 1);
		nv_commit("cfg");
	}
	else
	{
        *res_msg = at_err_build(ATERR_PARAM_INVALID);	
		*res_msglen = strlen(*res_msg);
		return AT_END;
	}

    *res_msg = at_ok_build();
	*res_msglen = strlen(*res_msg);

	return AT_END;
}

int ext_zcat_get_usblog(int at_fd,char * at_paras,void **res_msg,int * res_msglen)
{
    char  zcat_usblog[512] = {0};
    printf("ext_zcat_get %s\n", at_paras);

	if(-1 == sc_cfg_get("zcat_usblog", zcat_usblog, sizeof(zcat_usblog)))
    {
        *res_msg = at_err_build(ATERR_PROC_FAILED);	
		*res_msglen = strlen(*res_msg);
		return AT_END;
    }
    
	nv_get_item("cfg", "zcat_usblog", zcat_usblog, sizeof(zcat_usblog));
    printf("zcat_usblog is %s ,%d",zcat_usblog,strlen(zcat_usblog));
	*res_msg = at_query_result_build("ZCAT_USBLOG",zcat_usblog);
	*res_msglen = strlen(*res_msg);
    return AT_END;

}


int  ext_zcat_regist(void)
{

	register_serv_func2("zcatmode=",0,0,0,	ext_zcat_set_mode,	NULL);
	register_serv_func2("zcatmode?",0,0,0,	ext_zcat_get_mode, NULL);

    register_serv_func2("zcatusblog=",0,0,0,ext_zcat_set_usblog, NULL);
    register_serv_func2("zcatusblog?",0,0,0,ext_zcat_get_usblog, NULL);

	return 0;
	
}

#endif

